/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifterKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLogRangeShifter;", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "<init>", "(Lcom/jetbrains/rd/ide/document/DocumentLog;)V", "shrinkHistory", "", "shiftRange", "Lcom/intellij/openapi/util/TextRange;", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "range", "isVerifiable", "", "isGreedyToLeft", "isGreedyToRight", "shiftOnePoint", "", "offset", "isStickingToRight", "checkVersions", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLogRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n1#2:142\n14#3:143\n*S KotlinDebug\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifter\n*L\n138#1:143\n*E\n"})
public final class DocumentLogRangeShifter
implements IDocumentRangeShifter {
    @NotNull
    private final DocumentLog documentLog;

    public DocumentLogRangeShifter(@NotNull DocumentLog documentLog) {
        Intrinsics.checkNotNullParameter((Object)documentLog, (String)"documentLog");
        this.documentLog = documentLog;
    }

    @Override
    public void shrinkHistory() {
    }

    @Override
    @Nullable
    public TextRange shiftRange(@NotNull AbstractDocumentVersion v, @NotNull TextRange range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl2 = bl = range.getStartOffset() <= range.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DocumentLogRangeShifter$shiftRange$22 = false;
            String $i$a$-assert-DocumentLogRangeShifter$shiftRange$22 = "Range: " + range + " is not normalized";
            throw new AssertionError((Object)$i$a$-assert-DocumentLogRangeShifter$shiftRange$22);
        }
        RdDocumentVersion initialVersion = (RdDocumentVersion)v;
        if (!this.checkVersions(initialVersion)) {
            return null;
        }
        int resultStart = range.getStartOffset();
        int resultEnd = range.getEndOffset();
        for (Map.Entry<RdDocumentVersion, RdDocumentChangeBase> entry : this.documentLog) {
            RdDocumentVersion version = entry.getKey();
            RdDocumentChangeBase change = entry.getValue();
            if (version.getValue() <= initialVersion.getValue()) continue;
            if (change instanceof RdResetDocumentChange) {
                return null;
            }
            if (!(change instanceof RdDocumentChange)) {
                boolean $i$a$-check-DocumentLogRangeShifter$shiftRange$32 = false;
                String $i$a$-check-DocumentLogRangeShifter$shiftRange$32 = "Unknown document change type: " + change;
                throw new IllegalStateException($i$a$-check-DocumentLogRangeShifter$shiftRange$32.toString());
            }
            int oldLength = ((RdDocumentChange)change).getOldText().length();
            int newLength = ((RdDocumentChange)change).getNewText().length();
            int start = ((RdDocumentChange)change).getOffset();
            int end = start + oldLength;
            int delta = newLength - oldLength;
            if (oldLength == 0 && ((RdDocumentChange)change).getMoveOffset() != start) {
                int it = ((RdDocumentChange)change).getMoveOffset();
                boolean bl3 = false;
                int moveOffset = it > start ? it - newLength : it;
                if (moveOffset <= resultStart && resultEnd <= moveOffset + newLength) {
                    int moveDelta = start - moveOffset;
                    resultStart += moveDelta;
                    resultEnd += moveDelta;
                    continue;
                }
            }
            if (resultEnd == start && (((RdDocumentChange)change).getModificationKind() == RdTextModificationKind.RightSide || isGreedyToRight)) {
                resultEnd += delta;
                continue;
            }
            if (resultEnd <= start) continue;
            if (resultStart == end && (((RdDocumentChange)change).getModificationKind() == RdTextModificationKind.LeftSide || isGreedyToLeft)) {
                resultEnd += delta;
                continue;
            }
            if (resultStart >= end) {
                resultStart += delta;
                resultEnd += delta;
                continue;
            }
            if (resultStart <= start && end <= resultEnd && !isVerifiable) {
                resultEnd += delta;
                continue;
            }
            return null;
        }
        return new TextRange(resultStart, resultEnd);
    }

    @Override
    public int shiftOnePoint(@NotNull AbstractDocumentVersion v, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion initialVersion = (RdDocumentVersion)v;
        if (!this.checkVersions(initialVersion)) {
            return -1;
        }
        List changes = new ArrayList();
        for (Map.Entry<RdDocumentVersion, RdDocumentChangeBase> entry : this.documentLog) {
            RdDocumentVersion version = entry.getKey();
            RdDocumentChangeBase change = entry.getValue();
            if (version.getValue() <= initialVersion.getValue()) continue;
            changes.add(change);
        }
        return DocumentLogRangeShifterKt.shiftOnePoint(changes, offset, isStickingToRight);
    }

    private final boolean checkVersions(RdDocumentVersion version) {
        if (this.documentLog.contains(version)) {
            return true;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DocumentLogRangeShifter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Version " + version + " is not found in document log");
        return false;
    }
}

