/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.handler.unified;

import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.trace.impl.handler.unified.HandlerBase;
import com.intellij.debugger.streams.trace.impl.handler.unified.TerminatorTraceHandler;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/debugger/streams/trace/impl/handler/unified/OptionalTerminationHandler;", "Lcom/intellij/debugger/streams/trace/impl/handler/unified/HandlerBase$Terminal;", "call", "Lcom/intellij/debugger/streams/wrapper/TerminatorStreamCall;", "resultExpression", "", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "<init>", "(Lcom/intellij/debugger/streams/wrapper/TerminatorStreamCall;Ljava/lang/String;Lcom/intellij/debugger/streams/trace/dsl/Dsl;)V", "myTerminatorHandler", "Lcom/intellij/debugger/streams/trace/impl/handler/unified/TerminatorTraceHandler;", "additionalVariablesDeclaration", "", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "prepareResult", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "getResultExpression", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "additionalCallsBefore", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "intellij.java.debugger.streams"})
public final class OptionalTerminationHandler
extends HandlerBase.Terminal {
    @NotNull
    private final TerminatorStreamCall call;
    @NotNull
    private final String resultExpression;
    @NotNull
    private final TerminatorTraceHandler myTerminatorHandler;

    public OptionalTerminationHandler(@NotNull TerminatorStreamCall call, @NotNull String resultExpression, @NotNull Dsl dsl) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)resultExpression, (String)"resultExpression");
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        super(dsl);
        this.call = call;
        this.resultExpression = resultExpression;
        this.myTerminatorHandler = new TerminatorTraceHandler(this.call, dsl);
    }

    @Override
    @NotNull
    public List<VariableDeclaration> additionalVariablesDeclaration() {
        return this.myTerminatorHandler.additionalVariablesDeclaration();
    }

    @Override
    @NotNull
    public CodeBlock prepareResult() {
        return this.myTerminatorHandler.prepareResult();
    }

    @Override
    @NotNull
    public Expression getResultExpression() {
        Expression[] expressionArray = new Expression[]{new TextExpression(this.resultExpression).call("isPresent", new Expression[0])};
        Expression isPresent = this.getDsl().newArray(this.getDsl().getTypes().getBOOLEAN(), expressionArray);
        GenericType genericType = this.call.getResultType();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getResultType(...)");
        GenericType optionalType = JavaTypes.INSTANCE.unwrapOptional(genericType);
        Expression[] expressionArray2 = new Expression[1];
        Expression[] expressionArray3 = new Expression[]{new TextExpression(optionalType.getDefaultValue())};
        expressionArray2[0] = new TextExpression(this.resultExpression).call("orElse", expressionArray3);
        Expression optionalContent = this.getDsl().newArray(optionalType, expressionArray2);
        expressionArray3 = new Expression[]{isPresent, optionalContent};
        Expression optionalData = this.getDsl().newArray(this.getDsl().getTypes().getANY(), expressionArray3);
        expressionArray3 = new Expression[]{this.myTerminatorHandler.getResultExpression(), optionalData};
        return this.getDsl().newArray(this.getDsl().getTypes().getANY(), expressionArray3);
    }

    @Override
    @NotNull
    public List<IntermediateStreamCall> additionalCallsBefore() {
        return this.myTerminatorHandler.additionalCallsBefore();
    }
}

