/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.JulLogger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LogSetup {
    public static final String LOG_CONFIG_FILE_NAME = "build-log-jul.properties";
    private static final String LOG_FILE_NAME = "build.log";

    public static void initLoggers() {
        if (!Boolean.parseBoolean(System.getProperty("jps.use.default.file.logging", "true"))) {
            return;
        }
        try {
            String logDir = System.getProperty("jps.log.dir", null);
            Path configFile = logDir == null ? Paths.get(LOG_CONFIG_FILE_NAME, new String[0]) : Paths.get(logDir, LOG_CONFIG_FILE_NAME);
            LogSetup.ensureLogConfigExists(configFile);
            Path logFilePath = logDir != null ? Paths.get(logDir, LOG_FILE_NAME) : Paths.get(LOG_FILE_NAME, new String[0]);
            JulLogger.clearHandlers();
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(configFile, new OpenOption[0]));){
                LogManager.getLogManager().readConfiguration(in);
            }
            JulLogger.configureLogFileAndConsole((Path)logFilePath, (boolean)true, (boolean)true, (boolean)true, null);
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging: ");
            e.printStackTrace(System.err);
        }
        com.intellij.openapi.diagnostic.Logger.setFactory(category -> new JulLogger(Logger.getLogger(category)));
    }

    private static void ensureLogConfigExists(@NotNull Path logConfig) throws IOException {
        if (logConfig == null) {
            LogSetup.$$$reportNull$$$0(0);
        }
        if (!Files.exists(logConfig, new LinkOption[0])) {
            Files.createDirectories(logConfig.getParent(), new FileAttribute[0]);
            try (InputStream in = LogSetup.readDefaultLogConfig();){
                if (in != null) {
                    Files.copy(in, logConfig, new CopyOption[0]);
                }
            }
        }
    }

    public static InputStream readDefaultLogConfig() {
        return LogSetup.class.getResourceAsStream("/defaultLogConfig.properties");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logConfig", "org/jetbrains/jps/cmdline/LogSetup", "ensureLogConfigExists"));
    }
}

