/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.type.DataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AddItemDecisionMaker;
import org.jetbrains.jps.incremental.storage.ExperimentalOneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMappingKt;
import org.jetbrains.jps.incremental.storage.MapHandle;
import org.jetbrains.jps.incremental.storage.RemoveItemDecisionMaker;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;
import org.jetbrains.jps.incremental.storage.dataTypes.StringListDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB=\b\u0002\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalSourceToOutputMapping;", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "mapHandle", "Lorg/jetbrains/jps/incremental/storage/MapHandle;", "", "", "", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "outputToTargetMapping", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "targetHashId", "", "<init>", "(Lorg/jetbrains/jps/incremental/storage/MapHandle;Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;J)V", "setOutputs", "", "path", "outPaths", "", "setOutput", "sourcePath", "outputPath", "appendOutput", "removeOutput", "cursor", "Lorg/jetbrains/jps/incremental/storage/SourceToOutputMappingCursor;", "getSourcesIterator", "", "clear", "Companion", "intellij.platform.jps.build"})
@ApiStatus.Internal
public final class ExperimentalSourceToOutputMapping
extends ExperimentalOneToManyPathMapping
implements SourceToOutputMapping {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final ExperimentalOutputToTargetMapping outputToTargetMapping;
    @JvmField
    public final long targetHashId;
    @NotNull
    private static final MVMap.Builder<long[], String[]> mapBuilder;

    private ExperimentalSourceToOutputMapping(MapHandle<long[], String[]> mapHandle, PathRelativizerService relativizer, ExperimentalOutputToTargetMapping outputToTargetMapping, long targetHashId) {
        super(mapHandle, relativizer, 1);
        this.outputToTargetMapping = outputToTargetMapping;
        this.targetHashId = targetHashId;
    }

    @Override
    public void setOutputs(@NotNull String path, @NotNull List<String> outPaths) {
        block1: {
            String[] normalizeOutputPaths;
            long[] key;
            block0: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(outPaths, (String)"outPaths");
                String string = this.relativizer.toRelative(path);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
                String relativeSourcePath = string;
                key = LongPairKeyDataTypeKt.stringTo128BitHash(relativeSourcePath);
                normalizeOutputPaths = super.normalizeOutputPaths(outPaths, relativeSourcePath);
                if (normalizeOutputPaths != null) break block0;
                this.mapHandle.map.remove((Object)key);
                break block1;
            }
            this.mapHandle.map.put((Object)key, (Object)normalizeOutputPaths);
            ExperimentalOutputToTargetMapping experimentalOutputToTargetMapping = this.outputToTargetMapping;
            if (experimentalOutputToTargetMapping == null) break block1;
            experimentalOutputToTargetMapping.addMappings(normalizeOutputPaths, this.targetHashId);
        }
    }

    @Override
    public void setOutput(@NotNull String sourcePath, @NotNull String outputPath) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            String string = this.relativizer.toRelative(sourcePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
            String relativeSourcePath = string;
            String string2 = this.relativizer.toRelative(outputPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toRelative(...)");
            String relativeOutputPath = string2;
            String[] stringArray = new String[]{relativeSourcePath, relativeOutputPath};
            this.mapHandle.map.put((Object)LongPairKeyDataTypeKt.stringTo128BitHash(relativeSourcePath), (Object)stringArray);
            ExperimentalOutputToTargetMapping experimentalOutputToTargetMapping = this.outputToTargetMapping;
            if (experimentalOutputToTargetMapping == null) break block0;
            experimentalOutputToTargetMapping.addMapping(relativeOutputPath, this.targetHashId);
        }
    }

    @Override
    public void appendOutput(@NotNull String sourcePath, @NotNull String outputPath) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            String string = this.relativizer.toRelative(sourcePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
            String relativeSourcePath = string;
            String string2 = this.relativizer.toRelative(outputPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toRelative(...)");
            String relativeOutputPath = string2;
            this.mapHandle.map.operate((Object)LongPairKeyDataTypeKt.stringTo128BitHash(relativeSourcePath), null, (MVMap.DecisionMaker)new AddItemDecisionMaker(relativeSourcePath, relativeOutputPath));
            ExperimentalOutputToTargetMapping experimentalOutputToTargetMapping = this.outputToTargetMapping;
            if (experimentalOutputToTargetMapping == null) break block0;
            experimentalOutputToTargetMapping.addMapping(relativeOutputPath, this.targetHashId);
        }
    }

    @Override
    public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        MVMap mVMap = this.mapHandle.map;
        long[] lArray = this.getKey(sourcePath);
        String string = this.relativizer.toRelative(outputPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
        mVMap.operate((Object)lArray, null, (MVMap.DecisionMaker)new RemoveItemDecisionMaker(string));
    }

    @Override
    @NotNull
    public SourceToOutputMappingCursor cursor() {
        Cursor cursor2 = this.mapHandle.map.cursor(null);
        return new SourceToOutputMappingCursor((Cursor<long[], String[]>)cursor2, this){
            final /* synthetic */ Cursor<long[], String[]> $cursor;
            final /* synthetic */ ExperimentalSourceToOutputMapping this$0;
            {
                this.$cursor = $cursor;
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.$cursor.hasNext();
            }

            public String next() {
                this.$cursor.next();
                PathRelativizerService pathRelativizerService = this.this$0.relativizer;
                Object object = this.$cursor.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                String string = pathRelativizerService.toFull((String)ArraysKt.first((Object[])((Object[])object)));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toFull(...)");
                return string;
            }

            public String[] getOutputPaths() {
                String[] list = (String[])this.$cursor.getValue();
                int n = 0;
                int n2 = list.length - 1;
                String[] stringArray = new String[n2];
                while (n < n2) {
                    int n3 = n++;
                    Intrinsics.checkNotNullExpressionValue((Object)this.this$0.relativizer.toFull(list[n3 + 1]), (String)"toFull(...)");
                }
                return stringArray;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() {
        return this.cursor();
    }

    @TestOnly
    public final void clear() {
        this.mapHandle.map.clear();
    }

    public /* synthetic */ ExperimentalSourceToOutputMapping(MapHandle mapHandle, PathRelativizerService relativizer, ExperimentalOutputToTargetMapping outputToTargetMapping, long targetHashId, DefaultConstructorMarker $constructor_marker) {
        this(mapHandle, relativizer, outputToTargetMapping, targetHashId);
    }

    static {
        MVMap.Builder builder;
        Companion = new Companion(null);
        MVMap.Builder it = builder = new MVMap.Builder();
        boolean bl = false;
        it.setKeyType((DataType)LongPairKeyDataType.INSTANCE);
        it.setValueType((DataType)StringListDataType.INSTANCE);
        mapBuilder = builder;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalSourceToOutputMapping$Companion;", "", "<init>", "()V", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "", "", "", "createSourceToOutputMap", "Lorg/jetbrains/jps/incremental/storage/ExperimentalSourceToOutputMapping;", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "targetId", "targetTypeId", "outputToTargetMapping", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "intellij.platform.jps.build"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @ApiStatus.Internal
        @NotNull
        public final ExperimentalSourceToOutputMapping createSourceToOutputMap(@NotNull StorageManager storageManager, @NotNull PathRelativizerService relativizer, @NotNull String targetId, @NotNull String targetTypeId, @Nullable ExperimentalOutputToTargetMapping outputToTargetMapping) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
            Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
            Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
            String mapName = storageManager.getMapName(targetId, targetTypeId, "src-to-out-v1");
            return new ExperimentalSourceToOutputMapping(storageManager.openMap(mapName, mapBuilder), relativizer, outputToTargetMapping, ExperimentalOutputToTargetMappingKt.targetToHash(targetId, targetTypeId), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

