/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;
import org.jetbrains.jps.incremental.storage.StorageOwner;

@ApiStatus.Internal
public final class SourceToOutputMappingImpl
implements SourceToOutputMapping,
StorageOwner {
    private final OneToManyPathsMapping myMapping;

    public SourceToOutputMappingImpl(@NotNull Path storePath, @NotNull PathRelativizerService relativizer) throws IOException {
        if (storePath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(0);
        }
        if (relativizer == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(1);
        }
        this.myMapping = new OneToManyPathsMapping(storePath, relativizer);
    }

    @Override
    public void setOutputs(@NotNull String srcPath, @NotNull List<String> outputs) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(2);
        }
        if (outputs == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(3);
        }
        this.myMapping.setOutputs(srcPath, outputs);
    }

    @Override
    public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(4);
        }
        if (outputPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(5);
        }
        this.myMapping.setOutput(srcPath, outputPath);
    }

    @Override
    public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(6);
        }
        if (outputPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(7);
        }
        this.myMapping.appendData(srcPath, outputPath);
    }

    @Override
    public void remove(@NotNull String srcPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(8);
        }
        this.myMapping.remove(srcPath);
    }

    @Override
    public void removeOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(9);
        }
        if (outputPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(10);
        }
        this.myMapping.removeData(srcPath, outputPath);
    }

    @Nullable
    public List<String> getOutputs(@NotNull String srcPath) throws IOException {
        if (srcPath == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(11);
        }
        return this.myMapping.getOutputs(srcPath);
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() throws IOException {
        Iterator<String> iterator = this.myMapping.getKeysIterator();
        if (iterator == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(12);
        }
        return iterator;
    }

    @Override
    @NotNull
    public SourceToOutputMappingCursor cursor() throws IOException {
        SourceToOutputMappingCursor sourceToOutputMappingCursor = this.myMapping.cursor();
        if (sourceToOutputMappingCursor == null) {
            SourceToOutputMappingImpl.$$$reportNull$$$0(13);
        }
        return sourceToOutputMappingCursor;
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        this.myMapping.flush(memoryCachesOnly);
    }

    @Override
    public void close() throws IOException {
        this.myMapping.close();
    }

    @Override
    public void clean() throws IOException {
        this.myMapping.clean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativizer";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputs";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesIterator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cursor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOutputs";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOutput";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeOutput";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOutputs";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

