/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.StoreErrorHandler;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aZ\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0000\u0010\u0006*\u00020\b\"\b\b\u0001\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u001a*\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a(\u0010\u0017\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"MV_STORE_CACHE_SIZE_IN_MB", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "openOrResetMap", "Lorg/h2/mvstore/MVMap;", "K", "V", "", "store", "Lorg/h2/mvstore/MVStore;", "name", "", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "logSupplier", "Lkotlin/Function0;", "createOrResetMvStore", "file", "Ljava/nio/file/Path;", "readOnly", "", "getInvalidateMarkerFile", "tryOpenMvStore", "intellij.platform.jps.build"})
@SourceDebugExtension(value={"SMAP\nStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageManager.kt\norg/jetbrains/jps/incremental/storage/StorageManagerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,208:1\n1#2:209\n14#3:210\n*S KotlinDebug\n*F\n+ 1 StorageManager.kt\norg/jetbrains/jps/incremental/storage/StorageManagerKt\n*L\n19#1:210\n*E\n"})
public final class StorageManagerKt {
    private static final int MV_STORE_CACHE_SIZE_IN_MB;
    @NotNull
    private static final Logger LOG;

    private static final <K, V> MVMap<K, V> openOrResetMap(MVStore store, String name, MVMap.Builder<K, V> mapBuilder, Function0<? extends Logger> logSupplier) {
        try {
            MVMap mVMap = store.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"openMap(...)");
            return mVMap;
        }
        catch (Throwable e) {
            ((Logger)logSupplier.invoke()).error("Cannot open map " + name + ", map will be removed", e);
            try {
                store.removeMap(name);
            }
            catch (Throwable e2) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)e2);
            }
            MVMap mVMap = store.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"openMap(...)");
            return mVMap;
        }
    }

    private static final MVStore createOrResetMvStore(Path file, boolean readOnly, Function0<? extends Logger> logSupplier) {
        if (file == null || readOnly && Files.notExists(file, new LinkOption[0])) {
            return StorageManagerKt.tryOpenMvStore(null, readOnly, logSupplier);
        }
        Path markerFile = StorageManagerKt.getInvalidateMarkerFile(file);
        if (Files.exists(markerFile, new LinkOption[0])) {
            Files.deleteIfExists(file);
            Files.deleteIfExists(markerFile);
        }
        Path path = file.getParent();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        try {
            return StorageManagerKt.tryOpenMvStore(file, readOnly, logSupplier);
        }
        catch (Throwable e) {
            ((Logger)logSupplier.invoke()).warn("Cannot open cache state storage, will be recreated", e);
            Files.deleteIfExists(file);
            return StorageManagerKt.tryOpenMvStore(file, readOnly, logSupplier);
        }
    }

    static /* synthetic */ MVStore createOrResetMvStore$default(Path path, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StorageManagerKt.createOrResetMvStore(path, bl, (Function0<? extends Logger>)function0);
    }

    private static final Path getInvalidateMarkerFile(Path file) {
        Path path = file.resolveSibling(file.getFileName() + ".invalidated");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    private static final MVStore tryOpenMvStore(Path file, boolean readOnly, Function0<? extends Logger> logSupplier) {
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler(file, logSupplier);
        Path path = file;
        MVStore.Builder it = new MVStore.Builder().fileName(path != null && (path = path.toAbsolutePath()) != null ? ((Object)path).toString() : null).backgroundExceptionHandler((Thread.UncaughtExceptionHandler)storeErrorHandler).cacheSize(MV_STORE_CACHE_SIZE_IN_MB);
        boolean bl = false;
        MVStore store = (readOnly ? it.readOnly() : it).autoCommitBufferSize(0).open();
        storeErrorHandler.isStoreOpened = true;
        store.setVersionsToKeep(0);
        store.setAutoCommitDelay(60000);
        Intrinsics.checkNotNull((Object)store);
        return store;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ MVMap access$openOrResetMap(MVStore store, String name, MVMap.Builder mapBuilder, Function0 logSupplier) {
        return StorageManagerKt.openOrResetMap(store, name, mapBuilder, (Function0<? extends Logger>)logSupplier);
    }

    public static final /* synthetic */ int access$getMV_STORE_CACHE_SIZE_IN_MB$p() {
        return MV_STORE_CACHE_SIZE_IN_MB;
    }

    public static final /* synthetic */ MVStore access$createOrResetMvStore(Path file, boolean readOnly, Function0 logSupplier) {
        return StorageManagerKt.createOrResetMvStore(file, readOnly, (Function0<? extends Logger>)logSupplier);
    }

    static {
        String string = System.getProperty("jps.new.storage.cache.size.mb", "64");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        MV_STORE_CACHE_SIZE_IN_MB = Integer.parseInt(string);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StorageManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

