/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util;

import com.intellij.gradle.toolingExtension.impl.util.GradleTreeTraverserUtil;
import com.intellij.openapi.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public final class GradleModelProviderUtil {
    public static <M> void buildModels(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(0);
        }
        if (buildModel == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(1);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(3);
        }
        GradleModelProviderUtil.buildModels(controller, Collections.singleton(buildModel), modelClass, consumer);
    }

    public static <M> void buildModels(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(4);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(5);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(7);
        }
        if (Objects.equals(System.getProperty("idea.parallelModelFetch.enabled"), "true")) {
            GradleModelProviderUtil.buildModelsInParallel(controller, buildModels, modelClass, consumer);
        } else {
            GradleModelProviderUtil.buildModelsInSequence(controller, buildModels, modelClass, consumer);
        }
    }

    public static <M> void buildModelsInParallel(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(8);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(9);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(11);
        }
        ArrayList<BuildAction & Serializable> buildActions = new ArrayList<BuildAction & Serializable>();
        for (GradleBuild gradleBuild : buildModels) {
            for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
                buildActions.add((BuildAction & Serializable)innerController -> {
                    Object model = innerController.findModel((Model)gradleProject, modelClass);
                    if (model == null) {
                        return null;
                    }
                    return new Pair((Object)gradleProject, model);
                });
            }
        }
        List models = controller.run(buildActions);
        for (Pair model : models) {
            if (model == null) continue;
            consumer.consumeProjectModel((BasicGradleProject)model.first, model.second, modelClass);
        }
    }

    private static <M> void buildModelsInSequence(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(12);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(13);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(15);
        }
        for (GradleBuild gradleBuild : buildModels) {
            for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
                Object model = controller.findModel((Model)gradleProject, modelClass);
                if (model == null) continue;
                consumer.consumeProjectModel(gradleProject, model, modelClass);
            }
        }
    }

    public static <M> void buildModelsRecursively(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(16);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(17);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(19);
        }
        for (GradleBuild gradleBuild : buildModels) {
            GradleModelProviderUtil.buildModelsRecursively(controller, gradleBuild, modelClass, consumer);
        }
    }

    public static <M> void buildModelsRecursively(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(20);
        }
        if (buildModel == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(21);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(23);
        }
        @NotNull BasicGradleProject root = buildModel.getRootProject();
        GradleTreeTraverserUtil.breadthFirstTraverseTree(root, gradleProject -> {
            Object model = controller.findModel((Model)gradleProject, modelClass);
            if (model != null) {
                consumer.consumeProjectModel(gradleProject, model, modelClass);
            }
            return gradleProject.getChildren();
        });
    }

    public static <M, P> void buildModelsWithParameter(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer, @NotNull Class<P> parameterClass, @NotNull Action<? super P> action) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(24);
        }
        if (buildModel == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(25);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(27);
        }
        if (parameterClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(28);
        }
        if (action == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(29);
        }
        GradleModelProviderUtil.buildModelsWithParameter(controller, Collections.singleton(buildModel), modelClass, consumer, parameterClass, action);
    }

    public static <M, P> void buildModelsWithParameter(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer, @NotNull Class<P> parameterClass, @NotNull Action<? super P> action) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(30);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(31);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(32);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(33);
        }
        if (parameterClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(34);
        }
        if (action == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(35);
        }
        if (Objects.equals(System.getProperty("idea.parallelModelFetch.enabled"), "true")) {
            GradleModelProviderUtil.buildModelsWithParameterInParallel(controller, buildModels, modelClass, consumer, parameterClass, action);
        } else {
            GradleModelProviderUtil.buildModelsWithParameterInSequence(controller, buildModels, modelClass, consumer, parameterClass, action);
        }
    }

    private static <M, P> void buildModelsWithParameterInSequence(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer, @NotNull Class<P> parameterClass, @NotNull Action<? super P> action) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(36);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(37);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(38);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(39);
        }
        if (parameterClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(40);
        }
        if (action == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(41);
        }
        for (GradleBuild gradleBuild : buildModels) {
            for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
                Object model = controller.findModel((Model)gradleProject, modelClass, parameterClass, action);
                if (model == null) continue;
                consumer.consumeProjectModel(gradleProject, model, modelClass);
            }
        }
    }

    private static <M, P> void buildModelsWithParameterInParallel(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull Class<M> modelClass, @NotNull ProjectImportModelProvider.GradleModelConsumer consumer, @NotNull Class<P> parameterClass, @NotNull Action<? super P> action) {
        if (controller == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(42);
        }
        if (buildModels == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(43);
        }
        if (modelClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(44);
        }
        if (consumer == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(45);
        }
        if (parameterClass == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(46);
        }
        if (action == null) {
            GradleModelProviderUtil.$$$reportNull$$$0(47);
        }
        ArrayList<BuildAction & Serializable> buildActions = new ArrayList<BuildAction & Serializable>();
        for (GradleBuild gradleBuild : buildModels) {
            for (BasicGradleProject gradleProject : gradleBuild.getProjects()) {
                buildActions.add((BuildAction & Serializable)innerController -> {
                    Object model = innerController.findModel((Model)gradleProject, modelClass, parameterClass, action);
                    if (model == null) {
                        return null;
                    }
                    return new Pair((Object)gradleProject, model);
                });
            }
        }
        List models = controller.run(buildActions);
        for (Pair model : models) {
            if (model == null) continue;
            consumer.consumeProjectModel((BasicGradleProject)model.first, model.second, modelClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 26: 
            case 32: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 33: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 31: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModels";
                break;
            }
            case 28: 
            case 34: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterClass";
                break;
            }
            case 29: 
            case 35: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleModelProviderUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModels";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModelsInParallel";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModelsInSequence";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModelsRecursively";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModelsWithParameter";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModelsWithParameterInSequence";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "buildModelsWithParameterInParallel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

