/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\bH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ReplaceDotFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "oldDot", "Lcom/intellij/psi/tree/IElementType;", "newDot", "<init>", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;)V", "myName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getMyName", "()Ljava/lang/String;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.groovy.psi"})
public final class ReplaceDotFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final IElementType oldDot;
    @NotNull
    private final IElementType newDot;

    public ReplaceDotFix(@NotNull IElementType oldDot, @NotNull IElementType newDot) {
        Intrinsics.checkNotNullParameter((Object)oldDot, (String)"oldDot");
        Intrinsics.checkNotNullParameter((Object)newDot, (String)"newDot");
        this.oldDot = oldDot;
        this.newDot = newDot;
    }

    private final String getMyName() {
        Object[] objectArray = new Object[]{this.oldDot, this.newDot};
        String string = GroovyBundle.message("intention.family.name.replace.something.with", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getMyName();
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        ASTNode aSTNode = element.getNode();
        if (aSTNode == null) {
            return;
        }
        ASTNode oldNode = aSTNode;
        LeafElement leafElement = ASTFactory.leaf((IElementType)this.newDot, (CharSequence)this.newDot.toString());
        Intrinsics.checkNotNullExpressionValue((Object)leafElement, (String)"leaf(...)");
        LeafElement newNode = leafElement;
        CodeEditUtil.setNodeGenerated((ASTNode)((ASTNode)newNode), (boolean)true);
        oldNode.getTreeParent().replaceChild(oldNode, (ASTNode)newNode);
    }
}

