/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;

public class ArrayDataMethodItem
extends InstructionMethodItem<ArrayPayload> {
    public ArrayDataMethodItem(MethodDefinition methodDef, int codeAddress, ArrayPayload instruction) {
        super(methodDef, codeAddress, instruction);
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        int elementWidth = ((ArrayPayload)this.instruction).getElementWidth();
        writer.write(".array-data ");
        writer.writeSignedIntAsDec(((ArrayPayload)this.instruction).getElementWidth());
        writer.write(10);
        writer.indent(4);
        List elements = ((ArrayPayload)this.instruction).getArrayElements();
        String suffix = "";
        switch (elementWidth) {
            case 1: {
                suffix = "t";
                break;
            }
            case 2: {
                suffix = "s";
            }
        }
        for (Number number : elements) {
            int value;
            boolean isResourceId;
            writer.writeSignedIntOrLongTo(number.longValue());
            writer.write(suffix);
            if (elementWidth == 8) {
                this.writeCommentIfLikelyDouble(writer, number.longValue());
            } else if (elementWidth == 4 && !(isResourceId = this.writeCommentIfResourceId(writer, value = number.intValue()))) {
                this.writeCommentIfLikelyFloat(writer, value);
            }
            writer.write("\n");
        }
        writer.deindent(4);
        writer.write(".end array-data");
        return true;
    }
}

