/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.KeyEventPostProcessor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.basic.ComboPopup;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    static final AltProcessor altProcessor = new AltProcessor();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRootPaneUI;
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;

        AltProcessor() {
        }

        void altPressed(KeyEvent keyEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
                menuCanceledOnPress = true;
                keyEvent.consume();
            } else if (menuElementArray.length > 0) {
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                keyEvent.consume();
            } else {
                JMenu jMenu;
                JMenuBar jMenuBar;
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
                if (jMenuBar == null && winAncestor instanceof JFrame) {
                    jMenuBar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                if (jMenu != null) {
                    keyEvent.consume();
                }
            }
        }

        void altReleased(KeyEvent keyEvent) {
            if (menuCanceledOnPress) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                MenuElement[] menuElementArray;
                JMenuBar jMenuBar;
                JMenuBar jMenuBar2 = jMenuBar = root != null ? root.getJMenuBar() : null;
                if (jMenuBar == null && winAncestor instanceof JFrame) {
                    jMenuBar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                boolean bl = false;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit instanceof SunToolkit) {
                    menuElementArray = AWTAccessor.getKeyEventAccessor().getOriginalSource(keyEvent);
                    boolean bl2 = bl = SunToolkit.getContainingWindow((Component)menuElementArray) != winAncestor || keyEvent.getWhen() <= ((SunToolkit)toolkit).getWindowDeactivationTime(winAncestor);
                }
                if (jMenu != null && !bl) {
                    menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else if (!WindowsLookAndFeel.isMnemonicHidden()) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                }
            } else if (menuSelectionManager.getSelectedPath()[0] instanceof ComboPopup) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
            }
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.isConsumed() && keyEvent.getKeyCode() != 18) {
                altKeyPressed = false;
                return false;
            }
            if (keyEvent.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(keyEvent.getComponent());
                Window window = winAncestor = root == null ? null : SwingUtilities.getWindowAncestor(root);
                if (keyEvent.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed(keyEvent);
                    }
                    altKeyPressed = true;
                    return true;
                }
                if (keyEvent.getID() == 402) {
                    if (altKeyPressed) {
                        this.altReleased(keyEvent);
                    } else {
                        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                        if (menuElementArray.length <= 0) {
                            WindowsLookAndFeel.setMnemonicHidden(true);
                            WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                        }
                    }
                    altKeyPressed = false;
                }
                root = null;
                winAncestor = null;
            } else {
                altKeyPressed = false;
            }
            return false;
        }
    }
}

