/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;

public class RemoteCachesChangesPerformer<K, V extends SessionEntity>
implements SessionChangesPerformer<K, V> {
    private final KeycloakSession session;
    private final Cache<K, SessionEntityWrapper<V>> cache;
    private final RemoteCacheInvoker remoteCacheInvoker;
    private final List<Runnable> changes = new LinkedList<Runnable>();

    public RemoteCachesChangesPerformer(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> cache, RemoteCacheInvoker remoteCacheInvoker) {
        this.session = session;
        this.cache = cache;
        this.remoteCacheInvoker = remoteCacheInvoker;
    }

    @Override
    public void registerChange(Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        SessionUpdatesList<V> updates = entry.getValue();
        this.changes.add(() -> this.remoteCacheInvoker.runTask(this.session, updates.getRealm(), this.cache.getName(), entry.getKey(), merged, updates.getEntityWrapper()));
    }

    @Override
    public void applyChanges() {
        this.changes.forEach(Runnable::run);
    }
}

