/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageFormatProperties;

public class VkSparseImageMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMATPROPERTIES;
    public static final int IMAGEMIPTAILFIRSTLOD;
    public static final int IMAGEMIPTAILSIZE;
    public static final int IMAGEMIPTAILOFFSET;
    public static final int IMAGEMIPTAILSTRIDE;

    public VkSparseImageMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSparseImageMemoryRequirements.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkSparseImageFormatProperties formatProperties() {
        return VkSparseImageMemoryRequirements.nformatProperties(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageMipTailFirstLod() {
        return VkSparseImageMemoryRequirements.nimageMipTailFirstLod(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long imageMipTailSize() {
        return VkSparseImageMemoryRequirements.nimageMipTailSize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long imageMipTailOffset() {
        return VkSparseImageMemoryRequirements.nimageMipTailOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long imageMipTailStride() {
        return VkSparseImageMemoryRequirements.nimageMipTailStride(this.address());
    }

    public static VkSparseImageMemoryRequirements malloc() {
        return (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSparseImageMemoryRequirements calloc() {
        return (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSparseImageMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSparseImageMemoryRequirements create(long address) {
        return (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)address);
    }

    @Nullable
    public static VkSparseImageMemoryRequirements createSafe(long address) {
        return address == 0L ? null : (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSparseImageMemoryRequirements.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryRequirements.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements mallocStack() {
        return VkSparseImageMemoryRequirements.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements callocStack() {
        return VkSparseImageMemoryRequirements.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.malloc(stack);
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements callocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryRequirements.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryRequirements.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements.calloc(capacity, stack);
    }

    public static VkSparseImageMemoryRequirements malloc(MemoryStack stack) {
        return (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements calloc(MemoryStack stack) {
        return (VkSparseImageMemoryRequirements)VkSparseImageMemoryRequirements.wrap(VkSparseImageMemoryRequirements.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkSparseImageMemoryRequirements.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkSparseImageFormatProperties nformatProperties(long struct) {
        return VkSparseImageFormatProperties.create(struct + (long)FORMATPROPERTIES);
    }

    public static int nimageMipTailFirstLod(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEMIPTAILFIRSTLOD);
    }

    public static long nimageMipTailSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEMIPTAILSIZE);
    }

    public static long nimageMipTailOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEMIPTAILOFFSET);
    }

    public static long nimageMipTailStride(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEMIPTAILSTRIDE);
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryRequirements.__struct((Struct.Member[])new Struct.Member[]{VkSparseImageMemoryRequirements.__member((int)VkSparseImageFormatProperties.SIZEOF, (int)VkSparseImageFormatProperties.ALIGNOF), VkSparseImageMemoryRequirements.__member((int)4), VkSparseImageMemoryRequirements.__member((int)8), VkSparseImageMemoryRequirements.__member((int)8), VkSparseImageMemoryRequirements.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMATPROPERTIES = layout.offsetof(0);
        IMAGEMIPTAILFIRSTLOD = layout.offsetof(1);
        IMAGEMIPTAILSIZE = layout.offsetof(2);
        IMAGEMIPTAILOFFSET = layout.offsetof(3);
        IMAGEMIPTAILSTRIDE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkSparseImageMemoryRequirements ELEMENT_FACTORY = VkSparseImageMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSparseImageMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkSparseImageFormatProperties formatProperties() {
            return VkSparseImageMemoryRequirements.nformatProperties(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageMipTailFirstLod() {
            return VkSparseImageMemoryRequirements.nimageMipTailFirstLod(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long imageMipTailSize() {
            return VkSparseImageMemoryRequirements.nimageMipTailSize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long imageMipTailOffset() {
            return VkSparseImageMemoryRequirements.nimageMipTailOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long imageMipTailStride() {
            return VkSparseImageMemoryRequirements.nimageMipTailStride(this.address());
        }
    }
}

