/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkTransformMatrixKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MATRIX;

    public VkTransformMatrixKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkTransformMatrixKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[3][4]")
    public FloatBuffer matrix() {
        return VkTransformMatrixKHR.nmatrix(this.address());
    }

    public float matrix(int index) {
        return VkTransformMatrixKHR.nmatrix(this.address(), index);
    }

    public VkTransformMatrixKHR matrix(@NativeType(value="float[3][4]") FloatBuffer value) {
        VkTransformMatrixKHR.nmatrix(this.address(), value);
        return this;
    }

    public VkTransformMatrixKHR matrix(int index, float value) {
        VkTransformMatrixKHR.nmatrix(this.address(), index, value);
        return this;
    }

    public VkTransformMatrixKHR set(VkTransformMatrixKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkTransformMatrixKHR malloc() {
        return (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkTransformMatrixKHR calloc() {
        return (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkTransformMatrixKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkTransformMatrixKHR create(long address) {
        return (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)address);
    }

    @Nullable
    public static VkTransformMatrixKHR createSafe(long address) {
        return address == 0L ? null : (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkTransformMatrixKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkTransformMatrixKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkTransformMatrixKHR malloc(MemoryStack stack) {
        return (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkTransformMatrixKHR calloc(MemoryStack stack) {
        return (VkTransformMatrixKHR)VkTransformMatrixKHR.wrap(VkTransformMatrixKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkTransformMatrixKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer nmatrix(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)MATRIX), (int)12);
    }

    public static float nmatrix(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)MATRIX + Checks.check((int)index, (int)12) * 4L);
    }

    public static void nmatrix(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)12);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)MATRIX), (long)(value.remaining() * 4));
    }

    public static void nmatrix(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)MATRIX + Checks.check((int)index, (int)12) * 4L, value);
    }

    static {
        Struct.Layout layout = VkTransformMatrixKHR.__struct((Struct.Member[])new Struct.Member[]{VkTransformMatrixKHR.__array((int)4, (int)12)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MATRIX = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VkTransformMatrixKHR, Buffer>
    implements NativeResource {
        private static final VkTransformMatrixKHR ELEMENT_FACTORY = VkTransformMatrixKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkTransformMatrixKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[3][4]")
        public FloatBuffer matrix() {
            return VkTransformMatrixKHR.nmatrix(this.address());
        }

        public float matrix(int index) {
            return VkTransformMatrixKHR.nmatrix(this.address(), index);
        }

        public Buffer matrix(@NativeType(value="float[3][4]") FloatBuffer value) {
            VkTransformMatrixKHR.nmatrix(this.address(), value);
            return this;
        }

        public Buffer matrix(int index, float value) {
            VkTransformMatrixKHR.nmatrix(this.address(), index, value);
            return this;
        }
    }
}

