/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct MDB_envinfo")
public class MDBEnvInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ME_MAPADDR;
    public static final int ME_MAPSIZE;
    public static final int ME_LAST_PGNO;
    public static final int ME_LAST_TXNID;
    public static final int ME_MAXREADERS;
    public static final int ME_NUMREADERS;

    public MDBEnvInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MDBEnvInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long me_mapaddr() {
        return MDBEnvInfo.nme_mapaddr(this.address());
    }

    @NativeType(value="size_t")
    public long me_mapsize() {
        return MDBEnvInfo.nme_mapsize(this.address());
    }

    @NativeType(value="size_t")
    public long me_last_pgno() {
        return MDBEnvInfo.nme_last_pgno(this.address());
    }

    @NativeType(value="size_t")
    public long me_last_txnid() {
        return MDBEnvInfo.nme_last_txnid(this.address());
    }

    @NativeType(value="unsigned int")
    public int me_maxreaders() {
        return MDBEnvInfo.nme_maxreaders(this.address());
    }

    @NativeType(value="unsigned int")
    public int me_numreaders() {
        return MDBEnvInfo.nme_numreaders(this.address());
    }

    public static MDBEnvInfo malloc() {
        return (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MDBEnvInfo calloc() {
        return (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MDBEnvInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MDBEnvInfo create(long address) {
        return (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)address);
    }

    @Nullable
    public static MDBEnvInfo createSafe(long address) {
        return address == 0L ? null : (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MDBEnvInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MDBEnvInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static MDBEnvInfo mallocStack() {
        return MDBEnvInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MDBEnvInfo callocStack() {
        return MDBEnvInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MDBEnvInfo mallocStack(MemoryStack stack) {
        return MDBEnvInfo.malloc(stack);
    }

    @Deprecated
    public static MDBEnvInfo callocStack(MemoryStack stack) {
        return MDBEnvInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MDBEnvInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MDBEnvInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MDBEnvInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MDBEnvInfo.calloc(capacity, stack);
    }

    public static MDBEnvInfo malloc(MemoryStack stack) {
        return (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBEnvInfo calloc(MemoryStack stack) {
        return (MDBEnvInfo)MDBEnvInfo.wrap(MDBEnvInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)MDBEnvInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nme_mapaddr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_MAPADDR));
    }

    public static long nme_mapsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_MAPSIZE));
    }

    public static long nme_last_pgno(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_LAST_PGNO));
    }

    public static long nme_last_txnid(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ME_LAST_TXNID));
    }

    public static int nme_maxreaders(long struct) {
        return UNSAFE.getInt(null, struct + (long)ME_MAXREADERS);
    }

    public static int nme_numreaders(long struct) {
        return UNSAFE.getInt(null, struct + (long)ME_NUMREADERS);
    }

    static {
        Struct.Layout layout = MDBEnvInfo.__struct((Struct.Member[])new Struct.Member[]{MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)POINTER_SIZE), MDBEnvInfo.__member((int)4), MDBEnvInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ME_MAPADDR = layout.offsetof(0);
        ME_MAPSIZE = layout.offsetof(1);
        ME_LAST_PGNO = layout.offsetof(2);
        ME_LAST_TXNID = layout.offsetof(3);
        ME_MAXREADERS = layout.offsetof(4);
        ME_NUMREADERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<MDBEnvInfo, Buffer>
    implements NativeResource {
        private static final MDBEnvInfo ELEMENT_FACTORY = MDBEnvInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MDBEnvInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long me_mapaddr() {
            return MDBEnvInfo.nme_mapaddr(this.address());
        }

        @NativeType(value="size_t")
        public long me_mapsize() {
            return MDBEnvInfo.nme_mapsize(this.address());
        }

        @NativeType(value="size_t")
        public long me_last_pgno() {
            return MDBEnvInfo.nme_last_pgno(this.address());
        }

        @NativeType(value="size_t")
        public long me_last_txnid() {
            return MDBEnvInfo.nme_last_txnid(this.address());
        }

        @NativeType(value="unsigned int")
        public int me_maxreaders() {
            return MDBEnvInfo.nme_maxreaders(this.address());
        }

        @NativeType(value="unsigned int")
        public int me_numreaders() {
            return MDBEnvInfo.nme_numreaders(this.address());
        }
    }
}

