//////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2004-2023 musikcube team
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//
//    * Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//
//    * Neither the name of the author nor the names of other contributors may
//      be used to endorse or promote products derived from this software
//      without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include "constants.h"
#include "IPlugin.h"
#include "IDataStream.h"
#include "IBuffer.h"
#include "IBufferProvider.h"
#include "IDevice.h"

namespace musik { namespace core { namespace sdk {

    class IOutput {
        public:
            virtual void Release() = 0;
            virtual void Pause() = 0;
            virtual void Resume() = 0;
            virtual void SetVolume(double volume) = 0;
            virtual double GetVolume() = 0;
            virtual void Stop() = 0;
            virtual OutputState Play(IBuffer *buffer, IBufferProvider *provider) = 0;
            virtual void Drain() = 0;
            virtual double Latency() = 0;
            virtual const char* Name() = 0;
            virtual int GetDefaultSampleRate() = 0;
            virtual IDeviceList* GetDeviceList() = 0;
            virtual bool SetDefaultDevice(const char* deviceId) = 0;
            virtual IDevice* GetDefaultDevice() = 0;
    };

} } }
