/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.PskSecretResultHandler;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

public class AdvancedSinglePskStore
implements AdvancedPskStore,
Destroyable {
    private final PskPublicInformation identity;
    private final SecretKey secret;

    public AdvancedSinglePskStore(String identity, byte[] key) {
        this(new PskPublicInformation(identity), key);
    }

    public AdvancedSinglePskStore(PskPublicInformation identity, byte[] key) {
        this.identity = identity;
        this.secret = SecretUtil.create(key, "PSK");
    }

    public AdvancedSinglePskStore(String identity, SecretKey key) {
        this(new PskPublicInformation(identity), key);
    }

    public AdvancedSinglePskStore(PskPublicInformation identity, SecretKey key) {
        this.identity = identity;
        this.secret = SecretUtil.create(key);
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed) {
        SecretKey secret = null;
        if (this.identity.equals((Object)identity)) {
            secret = SecretUtil.create(this.secret);
        }
        return new PskSecretResult(cid, this.identity, secret);
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return this.identity;
    }

    @Override
    public void setResultHandler(PskSecretResultHandler resultHandler) {
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.secret);
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.secret);
    }
}

