/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.internal;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.Command;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.InterpretationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={HumanLanguageInterpreter.class}, configurationPid={"org.openhab.rulehli"}, property={"service.pid=org.openhab.rulehli"})
@ConfigurableService(category="system", label="Rule Voice Interpreter", description_uri="system:rulehli")
public class RuleHumanLanguageInterpreter
implements HumanLanguageInterpreter {
    private final Logger logger = LoggerFactory.getLogger(RuleHumanLanguageInterpreter.class);
    protected static final String CONFIG_URI = "system:rulehli";
    private String itemName = "VoiceCommand";
    private final EventPublisher eventPublisher;

    @Activate
    public RuleHumanLanguageInterpreter(@Reference EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        String configItemName;
        if (config != null && (configItemName = (String)config.get("item")) != null && ItemUtil.isValidItemName((String)configItemName)) {
            this.itemName = configItemName;
            this.logger.debug("Using item '{}' for passing voice commands.", (Object)this.itemName);
        }
    }

    public String getId() {
        return "rulehli";
    }

    public String getLabel(@Nullable Locale locale) {
        return "Rule-based Interpreter";
    }

    public String interpret(Locale locale, String text) throws InterpretationException {
        ItemCommandEvent event = ItemEventFactory.createCommandEvent((String)this.itemName, (Command)new StringType(text));
        this.eventPublisher.post((Event)event);
        return "";
    }

    public @Nullable String getGrammar(Locale locale, String format) {
        return null;
    }

    public Set<Locale> getSupportedLocales() {
        return Set.of();
    }

    public Set<String> getSupportedGrammarFormats() {
        return Set.of();
    }
}

