/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import org.apache.solr.client.api.endpoint.RenameCoreApi;
import org.apache.solr.client.api.model.RenameCoreRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class RenameCore
extends CoreAdminAPIBase
implements RenameCoreApi {
    @Inject
    public RenameCore(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse renameCore(String coreName, RenameCoreRequestBody requestBody) throws Exception {
        this.ensureRequiredParameterProvided("coreName", coreName);
        this.ensureRequiredRequestBodyProvided(requestBody);
        this.ensureRequiredParameterProvided("to", requestBody.to);
        SolrJerseyResponse solrJerseyResponse = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (coreName.equals(requestBody.to)) {
            return solrJerseyResponse;
        }
        return this.handlePotentiallyAsynchronousTask(solrJerseyResponse, coreName, requestBody.async, "rename", () -> {
            this.coreContainer.rename(coreName, requestBody.to);
            return solrJerseyResponse;
        });
    }
}

