/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.analysis.ja.dict.CharacterDefinition;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;

public final class UnknownDictionary
extends BinaryDictionary {
    private final CharacterDefinition characterDefinition = CharacterDefinition.getInstance();

    @Deprecated(forRemoval=true, since="9.1")
    public UnknownDictionary(BinaryDictionary.ResourceScheme scheme, String path) throws IOException {
        super((IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(scheme, path + "$targetMap.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(scheme, path + "$posDict.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> BinaryDictionary.getResource(scheme, path + "$buffer.dat")));
    }

    public UnknownDictionary(Path targetMapFile, Path posDictFile, Path dictFile) throws IOException {
        super((IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(targetMapFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(posDictFile, new OpenOption[0])), (IOSupplier<InputStream>)((IOSupplier)() -> Files.newInputStream(dictFile, new OpenOption[0])));
    }

    public UnknownDictionary(URL targetMapUrl, URL posDictUrl, URL dictUrl) throws IOException {
        super((IOSupplier<InputStream>)((IOSupplier)() -> targetMapUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> posDictUrl.openStream()), (IOSupplier<InputStream>)((IOSupplier)() -> dictUrl.openStream()));
    }

    private UnknownDictionary() throws IOException {
        super((IOSupplier<InputStream>)((IOSupplier)() -> UnknownDictionary.getClassResource("$targetMap.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> UnknownDictionary.getClassResource("$posDict.dat")), (IOSupplier<InputStream>)((IOSupplier)() -> UnknownDictionary.getClassResource("$buffer.dat")));
    }

    private static InputStream getClassResource(String suffix) throws IOException {
        String resourcePath = UnknownDictionary.class.getSimpleName() + suffix;
        return (InputStream)IOUtils.requireResourceNonNull((Object)UnknownDictionary.class.getResourceAsStream(resourcePath), (String)resourcePath);
    }

    public int lookup(char[] text, int offset, int len) {
        if (!this.characterDefinition.isGroup(text[offset])) {
            return 1;
        }
        byte characterIdOfFirstCharacter = this.characterDefinition.getCharacterClass(text[offset]);
        int length = 1;
        for (int i = 1; i < len && characterIdOfFirstCharacter == this.characterDefinition.getCharacterClass(text[offset + i]); ++i) {
            ++length;
        }
        return length;
    }

    public CharacterDefinition getCharacterDefinition() {
        return this.characterDefinition;
    }

    @Override
    public String getReading(int wordId, char[] surface, int off, int len) {
        return null;
    }

    @Override
    public String getInflectionType(int wordId) {
        return null;
    }

    @Override
    public String getInflectionForm(int wordId) {
        return null;
    }

    public static UnknownDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final UnknownDictionary INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new UnknownDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load UnknownDictionary.", ioe);
            }
        }
    }
}

