/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;

public class OtlpMetricExporterProvider
implements ConfigurableMetricExporterProvider {
    public MetricExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpMetricExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcMetricExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            OtlpConfigUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    public String getName() {
        return "otlp";
    }

    OtlpHttpMetricExporterBuilder httpBuilder() {
        return OtlpHttpMetricExporter.builder();
    }

    OtlpGrpcMetricExporterBuilder grpcBuilder() {
        return OtlpGrpcMetricExporter.builder();
    }
}

