/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.kafka.common.metadata.AbortTransactionRecord;
import org.apache.kafka.common.metadata.BeginTransactionRecord;
import org.apache.kafka.common.metadata.EndTransactionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class ActivationRecordsGenerator {
    static ControllerResult<Void> recordsForEmptyLog(Consumer<String> activationMessageConsumer, long transactionStartOffset, boolean zkMigrationEnabled, BootstrapMetadata bootstrapMetadata, MetadataVersion metadataVersion) {
        StringBuilder logMessageBuilder = new StringBuilder("Performing controller activation. ");
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        if (transactionStartOffset != -1L) {
            if (!metadataVersion.isMetadataTransactionSupported()) {
                throw new RuntimeException("Detected partial bootstrap records transaction at " + transactionStartOffset + ", but the metadata.version " + metadataVersion + " does not support transactions. Cannot continue.");
            }
            logMessageBuilder.append("Aborting partial bootstrap records transaction at offset ").append(transactionStartOffset).append(". Re-appending ").append(bootstrapMetadata.records().size()).append(" bootstrap record(s) in new metadata transaction at metadata.version ").append(metadataVersion).append(" from bootstrap source '").append(bootstrapMetadata.source()).append("'. ");
            records.add(new ApiMessageAndVersion((ApiMessage)new AbortTransactionRecord().setReason("Controller failover"), 0));
            records.add(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("Bootstrap records"), 0));
        } else {
            logMessageBuilder.append("The metadata log appears to be empty. ").append("Appending ").append(bootstrapMetadata.records().size()).append(" bootstrap record(s) ");
            if (metadataVersion.isMetadataTransactionSupported()) {
                records.add(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("Bootstrap records"), 0));
                logMessageBuilder.append("in metadata transaction ");
            }
            logMessageBuilder.append("at metadata.version ").append(metadataVersion).append(" from bootstrap source '").append(bootstrapMetadata.source()).append("'. ");
        }
        records.addAll(bootstrapMetadata.records());
        if (metadataVersion.isMigrationSupported()) {
            if (zkMigrationEnabled) {
                logMessageBuilder.append("Putting the controller into pre-migration mode. No metadata updates will be allowed until the ZK metadata has been migrated. ");
                records.add(ZkMigrationState.PRE_MIGRATION.toRecord());
            } else {
                logMessageBuilder.append("Setting the ZK migration state to NONE since this is a de-novo KRaft cluster. ");
                records.add(ZkMigrationState.NONE.toRecord());
            }
        } else if (zkMigrationEnabled) {
            throw new RuntimeException("The bootstrap metadata.version " + bootstrapMetadata.metadataVersion() + " does not support ZK migrations. Cannot continue with ZK migrations enabled.");
        }
        activationMessageConsumer.accept(logMessageBuilder.toString().trim());
        if (metadataVersion.isMetadataTransactionSupported()) {
            records.add(new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
            return ControllerResult.of(records, null);
        }
        return ControllerResult.atomicOf(records, null);
    }

    static ControllerResult<Void> recordsForNonEmptyLog(Consumer<String> activationMessageConsumer, long transactionStartOffset, boolean zkMigrationEnabled, FeatureControlManager featureControl, MetadataVersion metadataVersion) {
        StringBuilder logMessageBuilder = new StringBuilder("Performing controller activation. ");
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        if (transactionStartOffset != -1L) {
            if (!metadataVersion.isMetadataTransactionSupported()) {
                throw new RuntimeException("Detected in-progress transaction at offset " + transactionStartOffset + ", but the metadata.version " + metadataVersion + " does not support transactions. Cannot continue.");
            }
            logMessageBuilder.append("Aborting in-progress metadata transaction at offset ").append(transactionStartOffset).append(". ");
            records.add(new ApiMessageAndVersion((ApiMessage)new AbortTransactionRecord().setReason("Controller failover"), 0));
        }
        if (metadataVersion.equals((Object)MetadataVersion.MINIMUM_KRAFT_VERSION)) {
            logMessageBuilder.append("No metadata.version feature level record was found in the log. ").append("Treating the log as version ").append(MetadataVersion.MINIMUM_KRAFT_VERSION).append(". ");
        }
        if (zkMigrationEnabled && !metadataVersion.isMigrationSupported()) {
            throw new RuntimeException("Should not have ZK migrations enabled on a cluster running metadata.version " + featureControl.metadataVersion());
        }
        if (metadataVersion.isMigrationSupported()) {
            logMessageBuilder.append("Loaded ZK migration state of ").append((Object)featureControl.zkMigrationState()).append(". ");
            switch (featureControl.zkMigrationState()) {
                case NONE: {
                    if (!zkMigrationEnabled) break;
                    throw new RuntimeException("Should not have ZK migrations enabled on a cluster that was created in KRaft mode.");
                }
                case PRE_MIGRATION: {
                    if (metadataVersion.isMetadataTransactionSupported()) break;
                    logMessageBuilder.append("Activating pre-migration controller without empty log. ").append("There may be a partial migration. ");
                    break;
                }
                case MIGRATION: {
                    if (!zkMigrationEnabled) {
                        logMessageBuilder.append("Completing the ZK migration since this controller was configured with ").append("'zookeeper.metadata.migration.enable' set to 'false'. ");
                        records.add(ZkMigrationState.POST_MIGRATION.toRecord());
                        break;
                    }
                    logMessageBuilder.append("Staying in ZK migration mode since 'zookeeper.metadata.migration.enable' ").append("is still 'true'. ");
                    break;
                }
                case POST_MIGRATION: {
                    if (!zkMigrationEnabled) break;
                    logMessageBuilder.append("Ignoring 'zookeeper.metadata.migration.enable' value of 'true' since ").append("the ZK migration has been completed. ");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported ZkMigrationState " + (Object)((Object)featureControl.zkMigrationState()));
                }
            }
        }
        activationMessageConsumer.accept(logMessageBuilder.toString().trim());
        return ControllerResult.atomicOf(records, null);
    }

    static ControllerResult<Void> generate(Consumer<String> activationMessageConsumer, boolean isEmpty, long transactionStartOffset, boolean zkMigrationEnabled, BootstrapMetadata bootstrapMetadata, FeatureControlManager featureControl) {
        if (isEmpty) {
            return ActivationRecordsGenerator.recordsForEmptyLog(activationMessageConsumer, transactionStartOffset, zkMigrationEnabled, bootstrapMetadata, bootstrapMetadata.metadataVersion());
        }
        return ActivationRecordsGenerator.recordsForNonEmptyLog(activationMessageConsumer, transactionStartOffset, zkMigrationEnabled, featureControl, featureControl.metadataVersion());
    }
}

