/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;

public class FeaturesPublisher
implements MetadataPublisher {
    private final Logger log;
    private volatile Features features = Features.fromKRaftVersion((MetadataVersion)MetadataVersion.MINIMUM_KRAFT_VERSION);

    public FeaturesPublisher(LogContext logContext) {
        this.log = logContext.logger(FeaturesPublisher.class);
    }

    public Features features() {
        return this.features;
    }

    @Override
    public String name() {
        return "FeaturesPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        Features newFeatures;
        if (delta.featuresDelta() != null && !(newFeatures = new Features(newImage.features().metadataVersion(), newImage.features().finalizedVersions(), newImage.provenance().lastContainedOffset(), true)).equals((Object)this.features)) {
            this.log.info("Loaded new metadata {}.", (Object)newFeatures);
            this.features = newFeatures;
        }
    }
}

