/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.ltr.LTRThreadModule;
import org.apache.solr.ltr.SolrQueryRequestContextUtils;
import org.apache.solr.ltr.interleaving.Interleaving;
import org.apache.solr.ltr.interleaving.LTRInterleavingQuery;
import org.apache.solr.ltr.interleaving.LTRInterleavingScoringQuery;
import org.apache.solr.ltr.interleaving.OriginalRankingLTRScoringQuery;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.search.LTRQuery;
import org.apache.solr.ltr.store.rest.ManagedFeatureStore;
import org.apache.solr.ltr.store.rest.ManagedModelStore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;

public class LTRQParserPlugin
extends QParserPlugin
implements ResourceLoaderAware,
ManagedResourceObserver {
    public static final String NAME = "ltr";
    private static final String ORIGINAL_RANKING = "_OriginalRanking_";
    static final String EXTERNAL_FEATURE_INFO = "efi.";
    private ManagedFeatureStore fr = null;
    private ManagedModelStore mr = null;
    private LTRThreadModule threadManager = null;
    public static final String MODEL = "model";
    public static final int DEFAULT_RERANK_DOCS = 200;
    public static final String RERANK_DOCS = "reRankDocs";
    public static final String DEFAULT_INTERLEAVING_ALGORITHM = "TeamDraft";
    public static final String INTERLEAVING_ALGORITHM = "interleavingAlgorithm";

    public void init(NamedList<?> args) {
        super.init(args);
        this.threadManager = LTRThreadModule.getInstance(args);
        SolrPluginUtils.invokeSetters((Object)((Object)this), args);
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new LTRQParser(qstr, localParams, params, req);
    }

    public static Map<String, String[]> extractEFIParams(SolrParams localParams) {
        HashMap<String, String[]> externalFeatureInfo = new HashMap<String, String[]>();
        Iterator it = localParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith(EXTERNAL_FEATURE_INFO)) continue;
            externalFeatureInfo.put(name.substring(EXTERNAL_FEATURE_INFO.length()), new String[]{localParams.get(name)});
        }
        return externalFeatureInfo;
    }

    public void inform(ResourceLoader loader) throws IOException {
        SolrResourceLoader solrResourceLoader = (SolrResourceLoader)loader;
        ManagedFeatureStore.registerManagedFeatureStore(solrResourceLoader, this);
        ManagedModelStore.registerManagedModelStore(solrResourceLoader, this);
    }

    public void onManagedResourceInitialized(NamedList<?> args, ManagedResource res) throws SolrException {
        if (res instanceof ManagedFeatureStore) {
            this.fr = (ManagedFeatureStore)res;
        }
        if (res instanceof ManagedModelStore) {
            this.mr = (ManagedModelStore)res;
        }
        if (this.mr != null && this.fr != null) {
            this.mr.setManagedFeatureStore(this.fr);
            this.mr.loadStoredModels();
        }
    }

    public class LTRQParser
    extends QParser {
        public LTRQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        public Query parse() throws SyntaxError {
            String[] modelNames;
            if (LTRQParserPlugin.this.threadManager != null) {
                LTRQParserPlugin.this.threadManager.setExecutor(this.req.getCoreContainer().getUpdateShardHandler().getUpdateExecutor());
            }
            if ((modelNames = this.localParams.getParams(LTRQParserPlugin.MODEL)) == null || modelNames.length != 1 && modelNames.length != 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Must provide one or two models in the request");
            }
            boolean isInterleaving = modelNames.length > 1;
            boolean isLoggingFeatures = SolrQueryRequestContextUtils.isLoggingFeatures(this.req);
            Map<String, String[]> externalFeatureInfo = LTRQParserPlugin.extractEFIParams(this.localParams);
            LTRScoringQuery rerankingQuery = null;
            LTRScoringQuery[] rerankingQueries = new LTRInterleavingScoringQuery[modelNames.length];
            for (int i = 0; i < modelNames.length; ++i) {
                if (modelNames[i].isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "the model " + i + " is empty");
                }
                if (!LTRQParserPlugin.ORIGINAL_RANKING.equals(modelNames[i])) {
                    LTRScoringModel ltrScoringModel = LTRQParserPlugin.this.mr.getModel(modelNames[i]);
                    if (ltrScoringModel == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cannot find model " + modelNames[i]);
                    }
                    if (isInterleaving) {
                        rerankingQuery = rerankingQueries[i] = new LTRInterleavingScoringQuery(ltrScoringModel, externalFeatureInfo, LTRQParserPlugin.this.threadManager);
                    } else {
                        rerankingQuery = new LTRScoringQuery(ltrScoringModel, externalFeatureInfo, LTRQParserPlugin.this.threadManager);
                        rerankingQueries[i] = null;
                    }
                    if (isLoggingFeatures) {
                        String loggerFeatureStore;
                        boolean isSameFeatureStore;
                        FeatureLogger featureLogger = SolrQueryRequestContextUtils.getFeatureLogger(this.req);
                        String modelFeatureStore = ltrScoringModel.getFeatureStoreName();
                        boolean bl = isSameFeatureStore = modelFeatureStore.equals(loggerFeatureStore = SolrQueryRequestContextUtils.getFvStoreName(this.req)) || loggerFeatureStore == null;
                        if (isSameFeatureStore) {
                            if (featureLogger.isLoggingAll() == null) {
                                featureLogger.setLogAll(false);
                            }
                            rerankingQuery.setFeatureLogger(featureLogger);
                        } else {
                            if (featureLogger.isLoggingAll() == null) {
                                featureLogger.setLogAll(true);
                            }
                            if (!featureLogger.isLoggingAll().booleanValue()) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "the feature store '" + loggerFeatureStore + "' in the logger is different from the model feature store '" + modelFeatureStore + "', you can only log all the features from the store");
                            }
                        }
                    }
                } else {
                    rerankingQueries[i] = new OriginalRankingLTRScoringQuery(LTRQParserPlugin.ORIGINAL_RANKING);
                    rerankingQuery = rerankingQueries[i];
                }
                rerankingQuery.setRequest(this.req);
            }
            int reRankDocs = this.localParams.getInt(LTRQParserPlugin.RERANK_DOCS, 200);
            if (reRankDocs <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Must rerank at least 1 document");
            }
            if (!isInterleaving) {
                SolrQueryRequestContextUtils.setScoringQueries(this.req, new LTRScoringQuery[]{rerankingQuery});
                return new LTRQuery(rerankingQuery, reRankDocs);
            }
            String interleavingAlgorithm = this.localParams.get(LTRQParserPlugin.INTERLEAVING_ALGORITHM, LTRQParserPlugin.DEFAULT_INTERLEAVING_ALGORITHM);
            SolrQueryRequestContextUtils.setScoringQueries(this.req, rerankingQueries);
            return new LTRInterleavingQuery(Interleaving.getImplementation(interleavingAlgorithm), (LTRInterleavingScoringQuery[])rerankingQueries, reRankDocs);
        }
    }
}

