/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;

final class IdentityConverter
extends AbstractConverter
implements LenientComparable {
    private static final long serialVersionUID = 1230536100139464866L;
    static final IdentityConverter INSTANCE = new IdentityConverter();

    private IdentityConverter() {
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public UnitConverter inverse() {
        return this;
    }

    @Override
    public double convert(double d) {
        return d;
    }

    @Override
    public double derivative(double d) {
        return 1.0;
    }

    @Override
    public UnitConverter concatenate(UnitConverter unitConverter) {
        return unitConverter;
    }

    public String toString() {
        return "y\u00a0=\u00a0x";
    }

    @Override
    public Number convert(Number number) {
        ArgumentChecks.ensureNonNull("value", number);
        return number;
    }

    public int hashCode() {
        return 1008433314;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AbstractConverter && ((AbstractConverter)object).isIdentity();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (comparisonMode.isApproximate() && object instanceof LinearConverter) {
            return ((LinearConverter)object).almostIdentity();
        }
        return object instanceof UnitConverter && ((UnitConverter)object).isIdentity();
    }
}

