/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.server.metrics.ClientMetricsConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m3A\u0001C\u0005\u0001\u001d!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003,\u0001\u0011%A\u0006C\u0003A\u0001\u0011%\u0011\tC\u0003D\u0001\u0011%A\tC\u0003P\u0001\u0011\u0005\u0003\u000bC\u0003P\u0001\u0011\u0005#K\u0001\u0011D_:$(o\u001c7mKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]Z\u000bG.\u001b3bi>\u0014(B\u0001\u0006\f\u0003\u0019\u0019XM\u001d<fe*\tA\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tA\u0002%D\u0001\u001a\u0015\tQ2$\u0001\u0006d_:$(o\u001c7mKJT!\u0001\u0004\u000f\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\u0005\u0003Ce\u0011acQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN]\u0001\fW\u000647.Y\"p]\u001aLw\r\u0005\u0002%K5\t\u0011\"\u0003\u0002'\u0013\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003I\u0001AQA\t\u0002A\u0002\r\n\u0011C^1mS\u0012\fG/\u001a+pa&\u001cg*Y7f)\ti3\u0007\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0003V]&$\b\"\u0002\u001b\u0004\u0001\u0004)\u0014\u0001\u00028b[\u0016\u0004\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d0\u001b\u0005I$B\u0001\u001e\u000e\u0003\u0019a$o\\8u}%\u0011AhL\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=_\u0005\u0011b/\u00197jI\u0006$XM\u0011:pW\u0016\u0014h*Y7f)\ti#\tC\u00035\t\u0001\u0007Q'\u0001\u0013uQJ|w/\u0012=dKB$\u0018n\u001c8G_J,fn\u001b8po:\u0014Vm]8ve\u000e,G+\u001f9f)\tiS\tC\u0003G\u000b\u0001\u0007q)\u0001\u0005sKN|WO]2f!\tAU*D\u0001J\u0015\tQ5*\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u0019n\taaY8n[>t\u0017B\u0001(J\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003[ECQA\u0012\u0004A\u0002\u001d#2!L*U\u0011\u00151u\u00011\u0001H\u0011\u0015Qu\u00011\u0001V!\u00111\u0016,N\u001b\u000e\u0003]S!\u0001W\n\u0002\tU$\u0018\u000e\\\u0005\u00035^\u00131!T1q\u0001")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final KafkaConfig kafkaConfig;

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.entrySet().forEach(e -> {
                if (e.getValue() == null) {
                    nullTopicConfigs.$plus$eq(e.getKey());
                    return;
                }
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(44).append("Null value not supported for topic configs: ").append(nullTopicConfigs.mkString(",")).toString());
            }
            LogConfig.validate((Properties)properties, this.kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig.isRemoteLogStorageSystemEnabled()));
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
            Properties properties = new Properties();
            config.entrySet().forEach(e -> properties.setProperty((String)e.getKey(), (String)e.getValue()));
            ClientMetricsConfigs.validate((String)resource.name(), (Properties)properties);
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public ControllerConfigurationValidator(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
    }
}

