/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;

public class PropertyEnv {
    public static final String PROP_STATE = "state";
    public static final Object STATE_VALID = "valid";
    public static final Object STATE_NEEDS_VALIDATION = "needs_validation";
    public static final Object STATE_INVALID = "invalid";
    static final String PROP_CHANGE_IMMEDIATE = "changeImmediate";
    static final FeatureDescriptor dummyDescriptor = new FeatureDescriptor();
    private FeatureDescriptor featureDescriptor = dummyDescriptor;
    private Object[] beans;
    private Object state = STATE_VALID;
    private VetoableChangeSupport support;
    private PropertyChangeSupport change;
    private boolean changeImmediate = true;
    InplaceEditor.Factory factory = null;
    boolean editable = true;

    PropertyEnv() {
    }

    public Object[] getBeans() {
        return this.beans;
    }

    void setBeans(Object[] objectArray) {
        this.beans = objectArray;
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.featureDescriptor;
    }

    void setFeatureDescriptor(FeatureDescriptor featureDescriptor) {
        Object object;
        if (featureDescriptor == null) {
            throw new IllegalArgumentException("Cannot set FeatureDescriptor to null.");
        }
        this.featureDescriptor = featureDescriptor;
        if (this.featureDescriptor != null && (object = this.featureDescriptor.getValue(PROP_CHANGE_IMMEDIATE)) instanceof Boolean) {
            this.setChangeImmediate((Boolean)object);
        }
    }

    public void setState(Object object) {
        if (this.getState().equals(object)) {
            return;
        }
        try {
            this.getSupport().fireVetoableChange(PROP_STATE, this.getState(), object);
            this.state = object;
            this.getChange().firePropertyChange(PROP_STATE, null, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            PropertyDialogManager.notify(propertyVetoException);
        }
    }

    String silentlySetState(Object object, Object object2) {
        if (this.getState().equals(object)) {
            return null;
        }
        try {
            this.getSupport().fireVetoableChange(PROP_STATE, this.getState(), object);
            this.state = object;
            this.getChange().firePropertyChange(PROP_STATE, null, object);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
            String string = this.getFeatureDescriptor() == null ? null : this.getFeatureDescriptor().getDisplayName();
            return PropUtils.findLocalizedMessage(propertyVetoException, object2, string);
        }
        return null;
    }

    public Object getState() {
        return this.state;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getSupport().addVetoableChangeListener(vetoableChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChange().addPropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.getSupport().removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getChange().removePropertyChangeListener(propertyChangeListener);
    }

    boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    void setChangeImmediate(boolean bl) {
        this.changeImmediate = bl;
    }

    private synchronized VetoableChangeSupport getSupport() {
        if (this.support == null) {
            this.support = new VetoableChangeSupport(this);
        }
        return this.support;
    }

    private synchronized PropertyChangeSupport getChange() {
        if (this.change == null) {
            this.change = new PropertyChangeSupport(this);
        }
        return this.change;
    }

    public void registerInplaceEditorFactory(InplaceEditor.Factory factory) {
        this.factory = factory;
    }

    InplaceEditor getInplaceEditor() {
        InplaceEditor inplaceEditor = this.factory != null ? this.factory.getInplaceEditor() : null;
        return inplaceEditor;
    }

    void setEditable(boolean bl) {
        this.editable = bl;
    }

    boolean isEditable() {
        return this.editable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append("[state=");
        stringBuffer.append(this.state == STATE_NEEDS_VALIDATION ? "STATE_NEEDS_VALIDATION" : (this.state == STATE_INVALID ? "STATE_INVALID" : "STATE_VALID"));
        stringBuffer.append(", ");
        if (this.factory != null) {
            stringBuffer.append("InplaceEditorFactory=" + this.factory.getClass().getName());
            stringBuffer.append(", ");
        }
        stringBuffer.append("editable=");
        stringBuffer.append(this.editable);
        stringBuffer.append(", isChangeImmediate=");
        stringBuffer.append(this.isChangeImmediate());
        stringBuffer.append(", featureDescriptor=");
        stringBuffer.append(this.getFeatureDescriptor().getDisplayName());
        return stringBuffer.toString();
    }
}

