/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.JsonFactory;
import com.google.firebase.FirebaseException;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.AbstractPlatformErrorHandler;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.SdkUtils;
import com.google.firebase.projectmanagement.FirebaseProjectManagementException;

final class HttpHelper {
    private static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private static final String CLIENT_VERSION = "Java/Admin/" + SdkUtils.getVersion();
    private final ErrorHandlingHttpClient<FirebaseProjectManagementException> httpClient;

    HttpHelper(JsonFactory jsonFactory, HttpRequestFactory requestFactory) {
        ProjectManagementErrorHandler errorHandler = new ProjectManagementErrorHandler(jsonFactory);
        this.httpClient = new ErrorHandlingHttpClient<FirebaseProjectManagementException>(requestFactory, jsonFactory, errorHandler);
    }

    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpClient.setInterceptor(interceptor);
    }

    <T> IncomingHttpResponse makeGetRequest(String url, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        return this.makeRequest(HttpRequestInfo.buildGetRequest(url), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
    }

    <T> IncomingHttpResponse makePostRequest(String url, Object payload, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        return this.makeRequest(HttpRequestInfo.buildJsonPostRequest(url, payload), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
    }

    <T> void makePatchRequest(String url, Object payload, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        this.makeRequest(HttpRequestInfo.buildJsonRequest("PATCH", url, payload), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
    }

    <T> void makeDeleteRequest(String url, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        this.makeRequest(HttpRequestInfo.buildDeleteRequest(url), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
    }

    private <T> IncomingHttpResponse makeRequest(HttpRequestInfo baseRequest, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        try {
            baseRequest.addHeader(CLIENT_VERSION_HEADER, CLIENT_VERSION);
            IncomingHttpResponse response = this.httpClient.send(baseRequest);
            this.httpClient.parse(response, parsedResponseInstance);
            return response;
        }
        catch (FirebaseProjectManagementException e) {
            String message = String.format("%s \"%s\": %s", requestIdentifierDescription, requestIdentifier, e.getMessage());
            throw new FirebaseProjectManagementException(e, message);
        }
    }

    private static class ProjectManagementErrorHandler
    extends AbstractPlatformErrorHandler<FirebaseProjectManagementException> {
        ProjectManagementErrorHandler(JsonFactory jsonFactory) {
            super(jsonFactory);
        }

        @Override
        protected FirebaseProjectManagementException createException(FirebaseException base) {
            return new FirebaseProjectManagementException(base);
        }
    }
}

