/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodePanel;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.codearea.SearchBar;
import jadx.gui.ui.panel.IViewStateSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;

public final class CodeContentPanel
extends AbstractCodeContentPanel
implements IViewStateSupport {
    private static final long serialVersionUID = 5310536092010045565L;
    private final CodePanel codePanel;

    public CodeContentPanel(TabbedPane panel, JNode jnode) {
        super(panel, jnode);
        this.setLayout(new BorderLayout());
        this.codePanel = new CodePanel(new CodeArea(this, jnode));
        this.add((Component)this.codePanel, "Center");
        this.codePanel.load();
    }

    @Override
    public void loadSettings() {
        this.codePanel.loadSettings();
        this.updateUI();
    }

    SearchBar getSearchBar() {
        return this.codePanel.getSearchBar();
    }

    @Override
    public AbstractCodeArea getCodeArea() {
        return this.codePanel.getCodeArea();
    }

    @Override
    public String getTabTooltip() {
        String name;
        String s = this.node.getName();
        for (JNode n = (JNode)this.node.getParent(); n != null && (name = n.getName()) != null; n = (JNode)n.getParent()) {
            s = name + '/' + s;
        }
        return '/' + s;
    }

    @Override
    public EditorViewState getEditorViewState() {
        int caretPos = this.codePanel.getCodeArea().getCaretPosition();
        Point viewPoint = this.codePanel.getCodeScrollPane().getViewport().getViewPosition();
        return new EditorViewState(this.getNode(), "", caretPos, viewPoint);
    }

    @Override
    public void restoreEditorViewState(EditorViewState viewState) {
        this.codePanel.getCodeScrollPane().getViewport().setViewPosition(viewState.getViewPoint());
        this.codePanel.getCodeArea().setCaretPosition(viewState.getCaretPos());
    }

    @Override
    public void dispose() {
        this.codePanel.dispose();
    }
}

