/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public final class RecordSizeLimitExtension
extends HelloExtension {
    public static final int MIN_RECORD_SIZE_LIMIT = 64;
    public static final int MAX_RECORD_SIZE_LIMIT = 65535;
    private static final int RECORD_SIZE_LIMIT_BITS = 16;
    private int recordSizeLimit;

    public RecordSizeLimitExtension(int recordSizeLimit) {
        super(HelloExtension.ExtensionType.RECORD_SIZE_LIMIT);
        this.recordSizeLimit = RecordSizeLimitExtension.ensureInRange(recordSizeLimit);
    }

    public int getRecordSizeLimit() {
        return this.recordSizeLimit;
    }

    @Override
    public int getLength() {
        return 6;
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        writer.write(2, 16);
        writer.write(this.recordSizeLimit, 16);
    }

    public static RecordSizeLimitExtension fromExtensionDataReader(DatagramReader extensionDataReader, InetSocketAddress peerAddress) throws HandshakeException {
        if (extensionDataReader == null) {
            throw new NullPointerException("record size limit must not be null!");
        }
        int recordSizeLimit = extensionDataReader.read(16);
        if (recordSizeLimit < 64) {
            throw new HandshakeException("record size limit must be at last 64 bytes, not only " + recordSizeLimit + "!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
        }
        return new RecordSizeLimitExtension(recordSizeLimit);
    }

    public static int ensureInRange(int recordSizeLimit) {
        if (recordSizeLimit < 64 || recordSizeLimit > 65535) {
            throw new IllegalArgumentException("Record size limit must be within [64...65535], not " + recordSizeLimit + "!");
        }
        return recordSizeLimit;
    }
}

