# ****************************** -*-
# flake8: noqa
# generated by datamodel-codegen:
#   filename:  cql-schema.json
#   timestamp: 2021-03-13T21:05:20+00:00
# =================================================================
#
# Authors: Francesco Bartoli <xbartolone@gmail.com>
#
# Copyright (c) 2024 Francesco Bartoli
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation
# files (the "Software"), to deal in the Software without
# restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following
# conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# =================================================================

from datetime import date, datetime
from typing import Any, List, Optional, Union
from typing_extensions import Literal

from pydantic import BaseModel, Field, RootModel


class CQLModel(RootModel):
    root: 'Union[\n        ComparisonPredicate,\n        SpatialPredicate,\n        TemporalPredicate,\n        AndExpression\n    ]'


class AndExpression(BaseModel):
    and_: 'List[ComparisonPredicate]' = Field(..., alias='and')


class NotExpression(BaseModel):
    not_: 'List[Any]' = Field(..., alias='not')


class OrExpression(BaseModel):
    or_: 'List[Any]' = Field(..., alias='or')


class PropertyRef(BaseModel):
    property: 'Optional[str]' = None


class ScalarLiteral(RootModel):
    root: 'Union[str, float, bool]'


class Bbox(RootModel):
    root: 'List[float]'


class LinestringCoordinate(RootModel):
    root: 'List[Any]'


class Linestring(BaseModel):
    type: Literal['LineString']
    coordinates: 'List[LinestringCoordinate]' = Field(...)
    bbox: 'Optional[List[float]]' = Field(None)


class MultilineStringCoordinate(RootModel):
    root: 'List[Any]'


class Multilinestring(BaseModel):
    type: Literal['MultiLineString']
    coordinates: 'List[List[MultilineStringCoordinate]]'
    bbox: 'Optional[List[float]]' = Field(None)


class Multipoint(BaseModel):
    type: Literal['MultiPoint']
    coordinates: 'List[List[float]]'
    bbox: 'Optional[List[float]]' = Field(None)


class MultipolygonCoordinateItem(RootModel):
    root: 'List[Any]'


class Multipolygon(BaseModel):
    type: Literal['MultiPolygon']
    coordinates: 'List[List[List[MultipolygonCoordinateItem]]]'
    bbox: 'Optional[List[float]]' = Field(None)


class Point(BaseModel):
    type: Literal['Point']
    coordinates: 'List[float]' = Field(...)
    bbox: 'Optional[List[float]]' = Field(None)


class PolygonCoordinatesItem(RootModel):
    root: 'List[Any]'


class Polygon(BaseModel):
    type: Literal['Polygon']
    coordinates: 'List[List[PolygonCoordinatesItem]]'
    bbox: 'Optional[List[float]]' = Field(None)


class TimeString(RootModel):
    root: 'Union[date, datetime]'


class EnvelopeLiteral(BaseModel):
    bbox: 'Bbox'


class GeometryLiteral(RootModel):
    root: 'Union[\n        Point, Linestring, Polygon, Multipoint, Multilinestring, Multipolygon\n    ]'


class TypedTimeString(BaseModel):
    datetime: 'TimeString'


class PeriodString(RootModel):
    root: 'List[Union[TimeString, str]]' = Field(...)


class SpatialLiteral(RootModel):
    root: 'Union[GeometryLiteral, EnvelopeLiteral]'


class TemporalLiteral(RootModel):
    root: 'Union[TimeString, PeriodString]'


class TypedPeriodString(BaseModel):
    datetime: 'PeriodString'


class TypedTemporalLiteral(RootModel):
    root: 'Union[TypedTimeString, TypedPeriodString]'


class ArrayPredicate(RootModel):
    root: 'Union[\n        AequalsExpression,\n        AcontainsExpression,\n        AcontainedByExpression,\n        AoverlapsExpression,\n    ]'


class ComparisonPredicate(RootModel):
    root: 'Union[\n        BinaryComparisonPredicate,\n        IsLikePredicate,\n        IsBetweenPredicate,\n        IsInListPredicate,\n        IsNullPredicate,\n    ]'


class SpatialPredicate(RootModel):
    root: 'Union[\n        IntersectsExpression,\n        EqualsExpression,\n        DisjointExpression,\n        TouchesExpression,\n        WithinExpression,\n        OverlapsExpression,\n        CrossesExpression,\n        ContainsExpression,\n    ]'


class TemporalPredicate(RootModel):
    root: 'Union[\n        BeforeExpression,\n        AfterExpression,\n        MeetsExpression,\n        MetbyExpression,\n        ToverlapsExpression,\n        OverlappedbyExpression,\n        BeginsExpression,\n        BegunbyExpression,\n        DuringExpression,\n        TcontainsExpression,\n        EndsExpression,\n        EndedbyExpression,\n        TequalsExpression,\n        AnyinteractsExpression,\n    ]'


class AcontainedByExpression(BaseModel):
    acontainedBy: 'ArrayExpression'


class AcontainsExpression(BaseModel):
    acontains: 'ArrayExpression'


class AequalsExpression(BaseModel):
    aequals: 'ArrayExpression'


class AfterExpression(BaseModel):
    after: 'TemporalOperands'


class AnyinteractsExpression(BaseModel):
    anyinteracts: 'TemporalOperands'


class AoverlapsExpression(BaseModel):
    aoverlaps: 'ArrayExpression'


class BeforeExpression(BaseModel):
    before: 'TemporalOperands'


class BeginsExpression(BaseModel):
    begins: 'TemporalOperands'


class BegunbyExpression(BaseModel):
    begunby: 'TemporalOperands'


class BinaryComparisonPredicate(RootModel):
    root: 'Union[\n        EqExpression, LtExpression, GtExpression, LteExpression, GteExpression\n    ]'


class ContainsExpression(BaseModel):
    contains: 'SpatialOperands'


class CrossesExpression(BaseModel):
    crosses: 'SpatialOperands'


class DisjointExpression(BaseModel):
    disjoint: 'SpatialOperands'


class DuringExpression(BaseModel):
    during: 'TemporalOperands'


class EndedbyExpression(BaseModel):
    endedby: 'TemporalOperands'


class EndsExpression(BaseModel):
    ends: 'TemporalOperands'


class EqualsExpression(BaseModel):
    equals: 'SpatialOperands'


class IntersectsExpression(BaseModel):
    intersects: 'SpatialOperands'


class Between(BaseModel):
    value: 'ValueExpression'
    lower: 'Optional[ScalarExpression]' = Field(None)
    upper: 'Optional[ScalarExpression]' = Field(None)


class IsBetweenPredicate(BaseModel):
    between: 'Between'


class In(BaseModel):
    value: 'ValueExpression'
    list: 'List[ValueExpression]'
    nocase: 'Optional[bool]' = True


class IsInListPredicate(BaseModel):
    in_: 'In' = Field(..., alias='in')


class IsLikePredicate(BaseModel):
    like: 'ScalarOperands'
    wildcard: 'Optional[str]' = '%'
    singleChar: 'Optional[str]' = '.'
    escapeChar: 'Optional[str]' = '\\'
    nocase: 'Optional[bool]' = True


class IsNullPredicate(BaseModel):
    isNull: 'ScalarExpression'


class MeetsExpression(BaseModel):
    meets: 'TemporalOperands'


class MetbyExpression(BaseModel):
    metby: 'TemporalOperands'


class OverlappedbyExpression(BaseModel):
    overlappedby: 'TemporalOperands'


class OverlapsExpression(BaseModel):
    overlaps: 'SpatialOperands'


class TcontainsExpression(BaseModel):
    tcontains: 'TemporalOperands'


class TequalsExpression(BaseModel):
    tequals: 'TemporalOperands'


class TouchesExpression(BaseModel):
    touches: 'SpatialOperands'


class ToverlapsExpression(BaseModel):
    toverlaps: 'TemporalOperands'


class WithinExpression(BaseModel):
    within: 'SpatialOperands'


class ArrayExpression(RootModel):
    root: 'List[Union[PropertyRef, FunctionRef, ArrayLiteral]]' = Field(
        ...  # , max_items=2, min_items=2
    )


class EqExpression(BaseModel):
    eq: 'ScalarOperands'


class GtExpression(BaseModel):
    gt: 'ScalarOperands'


class GteExpression(BaseModel):
    gte: 'ScalarOperands'


class LtExpression(BaseModel):
    lt: 'ScalarOperands'


class LteExpression(BaseModel):
    lte: 'ScalarOperands'


class ScalarExpression(RootModel):
    root: 'Union[ScalarLiteral, PropertyRef,\n                    FunctionRef, ArithmeticExpression]'


class ScalarOperands(RootModel):
    root: 'List[ScalarExpression]' = Field(...)


class SpatialOperands(RootModel):
    root: 'List[GeomExpression]' = Field(...)


class TemporalOperands(RootModel):
    root: 'List[TemporalExpression]' = Field(...)
    # , max_items=2, min_items=2)


class ValueExpression(RootModel):
    root: 'Union[ScalarExpression, SpatialLiteral, TypedTemporalLiteral]'


class ArithmeticExpression(RootModel):
    root: 'Union[AddExpression, SubExpression, MulExpression, DivExpression]'


class ArrayLiteral(RootModel):
    root: 'List[\n        Union[\n            ScalarLiteral,\n            SpatialLiteral,\n            TypedTemporalLiteral,\n            PropertyRef,\n            FunctionRef,\n            ArithmeticExpression,\n            ArrayLiteral,\n        ]\n    ]'


class FunctionRef(BaseModel):
    function: 'Function'


class GeomExpression(RootModel):
    root: 'Union[SpatialLiteral, PropertyRef, FunctionRef]'


class TemporalExpression(RootModel):
    root: 'Union[TemporalLiteral, PropertyRef, FunctionRef]'


# here
class AddExpression(BaseModel):
    add_: 'ArithmeticOperands' = Field(..., alias='+')


# here
class DivExpression(BaseModel):
    div_: 'Optional[ArithmeticOperands]' = Field(None, alias='/')


class Function(BaseModel):
    name: 'str'
    arguments: 'Optional[\n        List[\n            Union[\n                ScalarLiteral,\n                SpatialLiteral,\n                TypedTemporalLiteral,\n                PropertyRef,\n                FunctionRef,\n                ArithmeticExpression,\n                ArrayLiteral,\n            ]\n        ]\n    ]' = None


# here
class MulExpression(BaseModel):
    mul_: 'ArithmeticOperands' = Field(..., alias='*')


# here
class SubExpression(BaseModel):
    sub_: 'ArithmeticOperands' = Field(..., alias='-')


class ArithmeticOperands(RootModel):
    root: 'List[\n        Union[ArithmeticExpression, PropertyRef, FunctionRef, float]\n    ]' = Field(...)


CQLModel.model_rebuild()
AndExpression.model_rebuild()
ArrayPredicate.model_rebuild()
ComparisonPredicate.model_rebuild()
SpatialPredicate.model_rebuild()
TemporalPredicate.model_rebuild()
AcontainedByExpression.model_rebuild()
AcontainsExpression.model_rebuild()
AequalsExpression.model_rebuild()
AfterExpression.model_rebuild()
AnyinteractsExpression.model_rebuild()
AoverlapsExpression.model_rebuild()
BeforeExpression.model_rebuild()
BeginsExpression.model_rebuild()
BegunbyExpression.model_rebuild()
BinaryComparisonPredicate.model_rebuild()
ContainsExpression.model_rebuild()
CrossesExpression.model_rebuild()
DisjointExpression.model_rebuild()
DuringExpression.model_rebuild()
EndedbyExpression.model_rebuild()
EndsExpression.model_rebuild()
EqualsExpression.model_rebuild()
IntersectsExpression.model_rebuild()
Between.model_rebuild()
In.model_rebuild()
IsBetweenPredicate.model_rebuild()
IsLikePredicate.model_rebuild()
IsNullPredicate.model_rebuild()
ValueExpression.model_rebuild()
MeetsExpression.model_rebuild()
MetbyExpression.model_rebuild()
OverlappedbyExpression.model_rebuild()
OverlapsExpression.model_rebuild()
TcontainsExpression.model_rebuild()
TequalsExpression.model_rebuild()
TouchesExpression.model_rebuild()
ToverlapsExpression.model_rebuild()
WithinExpression.model_rebuild()
ArrayExpression.model_rebuild()
EqExpression.model_rebuild()
GtExpression.model_rebuild()
GteExpression.model_rebuild()
LtExpression.model_rebuild()
LteExpression.model_rebuild()
ScalarExpression.model_rebuild()
ScalarOperands.model_rebuild()
SpatialOperands.model_rebuild()
TemporalOperands.model_rebuild()
ArithmeticExpression.model_rebuild()
ArrayLiteral.model_rebuild()
ScalarLiteral.model_rebuild()
PropertyRef.model_rebuild()
FunctionRef.model_rebuild()
AddExpression.model_rebuild()
DivExpression.model_rebuild()
MulExpression.model_rebuild()
SubExpression.model_rebuild()


def get_next_node(obj):
    logical_op = None
    if obj.__repr_name__() == 'AndExpression':
        next_node = obj.and_
        logical_op = 'and'
    elif obj.__repr_name__() == 'OrExpression':
        next_node = obj.or_
        logical_op = 'or'
    elif obj.__repr_name__() == 'NotExpression':
        next_node = obj.not_
        logical_op = 'not'
    elif obj.__repr_name__() == 'ComparisonPredicate':
        next_node = obj.root
    elif obj.__repr_name__() == 'SpatialPredicate':
        next_node = obj.root
    elif obj.__repr_name__() == 'TemporalPredicate':
        next_node = obj.root
    elif obj.__repr_name__() == 'IsBetweenPredicate':
        next_node = obj.between
    elif obj.__repr_name__() == 'Between':
        next_node = obj.value
    elif obj.__repr_name__() == 'ValueExpression':
        next_node = obj.root or obj.lower or obj.upper
    elif obj.__repr_name__() == 'ScalarExpression':
        next_node = obj.root
    elif obj.__repr_name__() == 'ScalarLiteral':
        next_node = obj.root
    elif obj.__repr_name__() == 'PropertyRef':
        next_node = obj.property
    elif obj.__repr_name__() == 'BinaryComparisonPredicate':
        next_node = obj.root
    elif obj.__repr_name__() == 'EqExpression':
        next_node = obj.eq
        logical_op = 'eq'
    else:
        raise ValueError("Object not valid")

    return (logical_op, next_node)
