/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class MultiViewTopComponentLookup
extends Lookup {
    private MyProxyLookup proxy;
    private InitialProxyLookup initial;

    public MultiViewTopComponentLookup(ActionMap actionMap) {
        this.initial = new InitialProxyLookup(actionMap);
        this.proxy = new MyProxyLookup((Lookup)this.initial);
    }

    public void setElementLookup(Lookup lookup) {
        this.proxy.setElementLookup(lookup);
        this.initial.refreshLookup();
    }

    public Lookup.Item lookupItem(Lookup.Template template) {
        if (template.getType() == ActionMap.class || template.getId() != null && template.getId().equals("javax.swing.ActionMap")) {
            return this.initial.lookupItem(template);
        }
        Lookup.Item item = super.lookupItem(template);
        return item;
    }

    public Object lookup(Class clazz) {
        if (clazz == ActionMap.class) {
            return this.initial.lookup(clazz);
        }
        Object object = this.proxy.lookup(clazz);
        return object;
    }

    public Lookup.Result lookup(Lookup.Template template) {
        if (template.getType() == ActionMap.class || template.getId() != null && template.getId().equals("javax.swing.ActionMap")) {
            return this.initial.lookup(template);
        }
        Lookup.Result result = this.proxy.lookup(template);
        result = new ExclusionResult(result);
        return result;
    }

    private static final class ExclusionResult
    extends Lookup.Result
    implements LookupListener {
        private final Lookup.Result delegate;
        private final List listeners = new ArrayList();
        private Collection lastResults;

        public ExclusionResult(Lookup.Result result) {
            this.delegate = result;
        }

        public Collection allInstances() {
            HashSet hashSet = new HashSet(this.delegate.allInstances());
            return hashSet;
        }

        public Set allClasses() {
            return this.delegate.allClasses();
        }

        public Collection allItems() {
            HashSet hashSet = new HashSet(this.delegate.allItems());
            Iterator iterator = hashSet.iterator();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            while (iterator.hasNext()) {
                Lookup.Item item = (Lookup.Item)iterator.next();
                if (hashSet2.contains(item.getInstance())) {
                    iterator.remove();
                    continue;
                }
                hashSet2.add(item.getInstance());
            }
            return hashSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener lookupListener) {
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    if (this.lastResults == null) {
                        this.lastResults = this.allInstances();
                    }
                    this.delegate.addLookupListener((LookupListener)this);
                }
                this.listeners.add(lookupListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener lookupListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(lookupListener);
                if (this.listeners.isEmpty()) {
                    this.delegate.removeLookupListener((LookupListener)this);
                    this.lastResults = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            LookupListener[] lookupListenerArray;
            List list = this.listeners;
            synchronized (list) {
                boolean bl;
                lookupListenerArray = this.allInstances();
                boolean bl2 = bl = this.lastResults != null && lookupListenerArray != null && lookupListenerArray.containsAll(this.lastResults) && this.lastResults.containsAll((Collection<?>)lookupListenerArray);
                if (bl) {
                    return;
                }
                this.lastResults = lookupListenerArray;
            }
            list = new LookupEvent((Lookup.Result)this);
            List list2 = this.listeners;
            synchronized (list2) {
                lookupListenerArray = this.listeners.toArray(new LookupListener[this.listeners.size()]);
            }
            for (int i = 0; i < lookupListenerArray.length; ++i) {
                lookupListenerArray[i].resultChanged((LookupEvent)list);
            }
        }
    }

    static class InitialProxyLookup
    extends ProxyLookup {
        private ActionMap initObject;

        public InitialProxyLookup(ActionMap actionMap) {
            super(new Lookup[]{Lookups.fixed((Object[])new Object[]{new LookupProxyActionMap(actionMap)})});
            this.initObject = actionMap;
        }

        public void refreshLookup() {
            this.setLookups(new Lookup[]{Lookups.fixed((Object[])new Object[]{new LookupProxyActionMap(this.initObject)})});
        }
    }

    static class LookupProxyActionMap
    extends ActionMap {
        private ActionMap map;

        public LookupProxyActionMap(ActionMap actionMap) {
            this.map = actionMap;
        }

        public void setParent(ActionMap actionMap) {
            this.map.setParent(actionMap);
        }

        public ActionMap getParent() {
            return this.map.getParent();
        }

        public void put(Object object, Action action) {
            this.map.put(object, action);
        }

        public Action get(Object object) {
            return this.map.get(object);
        }

        public void remove(Object object) {
            this.map.remove(object);
        }

        public void clear() {
            this.map.clear();
        }

        public Object[] keys() {
            return this.map.keys();
        }

        public int size() {
            return this.map.size();
        }

        public Object[] allKeys() {
            return this.map.allKeys();
        }
    }

    private static class MyProxyLookup
    extends ProxyLookup {
        private Lookup initialLookup;

        public MyProxyLookup(Lookup lookup) {
            super(new Lookup[]{lookup});
            this.initialLookup = lookup;
        }

        public void setElementLookup(Lookup lookup) {
            this.setLookups(new Lookup[]{this.initialLookup, lookup});
        }
    }
}

