/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum ClientCertificateType {
    RSA_SIGN(1),
    DSS_SIGN(2),
    RSA_FIXED_DH(3),
    DSS_FIXED_DH(4),
    RSA_EPHEMERAL_DH_RESERVED(5),
    DSS_EPHEMERAL_DH_RESERVED(6),
    FORTEZZA_DMS_RESERVED(20),
    GOSTR34101994(21),
    GOSTR34102001(22),
    ECDSA_SIGN(64),
    RSA_FIXED_ECDH(65),
    ECDSA_FIXED_ECDH(66),
    GOST_SIGN256(66),
    GOST_SIGN512(67),
    GOSTR34102012_256(-18),
    GOSTR34102012_512(-17);

    public static final int LENGTH = 1;
    private byte value;
    private static final Map<Byte, ClientCertificateType> MAP;

    private ClientCertificateType(byte value) {
        this.value = value;
    }

    public static ClientCertificateType getClientCertificateType(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    static {
        MAP = new HashMap<Byte, ClientCertificateType>();
        for (ClientCertificateType c : ClientCertificateType.values()) {
            MAP.put(c.value, c);
        }
    }
}

