/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum SrtpProtectionProfiles {
    SRTP_AES128_CM_HMAC_SHA1_80(new byte[]{0, 1}),
    SRTP_AES128_CM_HMAC_SHA1_32(new byte[]{0, 2}),
    SRTP_NULL_HMAC_SHA1_80(new byte[]{0, 5}),
    SRTP_NULL_HMAC_SHA1_32(new byte[]{0, 6});

    private final byte[] srtpProtectionProfiles;
    private static final Map<Integer, SrtpProtectionProfiles> MAP;
    private static final Logger LOGGER;

    private SrtpProtectionProfiles(byte[] value) {
        this.srtpProtectionProfiles = value;
    }

    public byte[] getByteValue() {
        return this.srtpProtectionProfiles;
    }

    public static SrtpProtectionProfiles getProfileByType(byte[] value) {
        return MAP.get(ArrayConverter.bytesToInt((byte[])value));
    }

    public static List<SrtpProtectionProfiles> getProfilesAsArrayList(byte[] value) {
        ArrayList<SrtpProtectionProfiles> profileList = new ArrayList<SrtpProtectionProfiles>();
        for (int i = 0; i < value.length; i += 2) {
            if (i + 1 < value.length) {
                profileList.add(SrtpProtectionProfiles.getProfileByType(new byte[]{value[i], value[i + 1]}));
                continue;
            }
            LOGGER.warn("value cannot be converted into an SrtpProtectionProfile - not enough bytes left");
        }
        return profileList;
    }

    public byte getMinor() {
        return this.srtpProtectionProfiles[0];
    }

    public byte getMajor() {
        return this.srtpProtectionProfiles[1];
    }

    static {
        LOGGER = LogManager.getLogger();
        MAP = new HashMap<Integer, SrtpProtectionProfiles>();
        for (SrtpProtectionProfiles c : SrtpProtectionProfiles.values()) {
            MAP.put(ArrayConverter.bytesToInt((byte[])c.srtpProtectionProfiles), c);
        }
    }
}

