/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificatePair;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import de.rub.nds.tlsattacker.core.protocol.parser.cert.CertificatePairParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParserFactory;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateMessageParser
extends HandshakeMessageParser<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateMessageParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, HandshakeMessageType.CERTIFICATE, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(CertificateMessage msg) {
        LOGGER.debug("Parsing CertificateMessage");
        if (this.getVersion().isTLS13()) {
            this.parseRequestContextLength(msg);
            this.parseRequestContextBytes(msg);
        }
        this.parseCertificatesListLength(msg);
        this.parseCertificateListBytes(msg);
        if (this.getVersion().isTLS13()) {
            this.parseCertificateList(msg);
        }
    }

    @Override
    protected CertificateMessage createHandshakeMessage() {
        return new CertificateMessage();
    }

    private void parseRequestContextLength(CertificateMessage msg) {
        msg.setRequestContextLength(this.parseIntField(1));
        LOGGER.debug("RequestContextLength: " + msg.getRequestContextLength());
    }

    private void parseRequestContextBytes(CertificateMessage msg) {
        msg.setRequestContext(this.parseByteArrayField((Integer)msg.getRequestContextLength().getValue()));
        LOGGER.debug("RequestContextBytes: " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getRequestContext()));
    }

    private void parseCertificatesListLength(CertificateMessage msg) {
        msg.setCertificatesListLength(this.parseIntField(3));
        LOGGER.debug("CertificatesListLength: " + msg.getCertificatesListLength());
    }

    private void parseCertificateListBytes(CertificateMessage msg) {
        msg.setCertificatesListBytes(this.parseByteArrayField((Integer)msg.getCertificatesListLength().getValue()));
        LOGGER.debug("CertificatesListBytes: " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getCertificatesListBytes()));
    }

    private void parseCertificateList(CertificateMessage msg) {
        int position = 0;
        LinkedList<CertificatePair> pairList = new LinkedList<CertificatePair>();
        while (position < (Integer)msg.getCertificatesListLength().getValue()) {
            CertificatePairParser parser = new CertificatePairParser(position, (byte[])msg.getCertificatesListBytes().getValue());
            pairList.add(parser.parse());
            if (position == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing CertificatePairs");
            }
            position = parser.getPointer();
        }
        msg.setCertificatesList(pairList);
        LinkedList<CertificateEntry> entryList = new LinkedList<CertificateEntry>();
        for (CertificatePair pair : msg.getCertificatesList()) {
            LinkedList<ExtensionMessage> extensionMessages = new LinkedList<ExtensionMessage>();
            int pointer = 0;
            while (pointer < (Integer)pair.getExtensionsLength().getValue()) {
                ExtensionParser parser = ExtensionParserFactory.getExtensionParser((byte[])pair.getExtensions().getValue(), pointer, msg.getHandshakeMessageType(), this.getConfig());
                extensionMessages.add((ExtensionMessage)parser.parse());
                if (pointer == parser.getPointer()) {
                    throw new ParserException("Ran into infinite Loop while parsing CertificateExtensions");
                }
                pointer = parser.getPointer();
            }
            entryList.add(new CertificateEntry((byte[])pair.getCertificate().getValue(), extensionMessages));
        }
        msg.setCertificatesListAsEntry(entryList);
    }
}

