/*****************************************************************************
 *
 * Copyright (C) 2009-2010 Atmel Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * * Neither the name of the copyright holders nor the names of
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Model        : UC3C0128C
 * Revision     : $Revision: 74809 $
 * Checkin Date : $Date: 2010-05-17 00:46:10 +0200 (Mon, 17 May 2010) $ 
 *
 ****************************************************************************/
#ifndef AVR32_PDCA_121_H_INCLUDED
#define AVR32_PDCA_121_H_INCLUDED

#define AVR32_PDCA_H_VERSION 121

#include "avr32/abi.h"


/*
 Note to user:

 The following defines are always generated:
 - Register offset: AVR32_PDCA_<register>
 - Bitfield mask:   AVR32_PDCA_<register>_<bitfield>
 - Bitfield offset: AVR32_PDCA_<register>_<bitfield>_OFFSET
 - Bitfield size:   AVR32_PDCA_<register>_<bitfield>_SIZE
 - Bitfield values: AVR32_PDCA_<register>_<bitfield>_<value name>

 The following defines are generated if they don't cause ambiguities,
 i.e. the name is unique, or all values with that name are the same.
 - Bitfield mask:   AVR32_PDCA_<bitfield>
 - Bitfield offset: AVR32_PDCA_<bitfield>_OFFSET
 - Bitfield size:   AVR32_PDCA_<bitfield>_SIZE
 - Bitfield values: AVR32_PDCA_<bitfield>_<value name>
 - Bitfield values: AVR32_PDCA_<value name>

 All defines are sorted alphabetically.
*/


#define AVR32_PDCA_BYTE                                     0x00000000
#define AVR32_PDCA_CH0EN                                             0
#define AVR32_PDCA_CH0EN_MASK                               0x00000001
#define AVR32_PDCA_CH0EN_OFFSET                                      0
#define AVR32_PDCA_CH0EN_SIZE                                        1
#define AVR32_PDCA_CH0OF                                             4
#define AVR32_PDCA_CH0OF_MASK                               0x00000010
#define AVR32_PDCA_CH0OF_OFFSET                                      4
#define AVR32_PDCA_CH0OF_SIZE                                        1
#define AVR32_PDCA_CH0RES                                            8
#define AVR32_PDCA_CH0RES_MASK                              0x00000100
#define AVR32_PDCA_CH0RES_OFFSET                                     8
#define AVR32_PDCA_CH0RES_SIZE                                       1
#define AVR32_PDCA_CH1EN                                             1
#define AVR32_PDCA_CH1EN_MASK                               0x00000002
#define AVR32_PDCA_CH1EN_OFFSET                                      1
#define AVR32_PDCA_CH1EN_SIZE                                        1
#define AVR32_PDCA_CH1OF                                             5
#define AVR32_PDCA_CH1OF_MASK                               0x00000020
#define AVR32_PDCA_CH1OF_OFFSET                                      5
#define AVR32_PDCA_CH1OF_SIZE                                        1
#define AVR32_PDCA_CH1RES                                            9
#define AVR32_PDCA_CH1RES_MASK                              0x00000200
#define AVR32_PDCA_CH1RES_OFFSET                                     9
#define AVR32_PDCA_CH1RES_SIZE                                       1

#define AVR32_PDCA_CR                                       0x00000014
#define AVR32_PDCA_CR_ECLR                                           8
#define AVR32_PDCA_CR_ECLR_MASK                             0x00000100
#define AVR32_PDCA_CR_ECLR_OFFSET                                    8
#define AVR32_PDCA_CR_ECLR_SIZE                                      1
#define AVR32_PDCA_CR_MASK                                  0x00000103
#define AVR32_PDCA_CR_RESETVALUE                            0x00000000
#define AVR32_PDCA_CR_TDIS                                           1
#define AVR32_PDCA_CR_TDIS_MASK                             0x00000002
#define AVR32_PDCA_CR_TDIS_OFFSET                                    1
#define AVR32_PDCA_CR_TDIS_SIZE                                      1
#define AVR32_PDCA_CR_TEN                                            0
#define AVR32_PDCA_CR_TEN_MASK                              0x00000001
#define AVR32_PDCA_CR_TEN_OFFSET                                     0
#define AVR32_PDCA_CR_TEN_SIZE                                       1


#define AVR32_PDCA_DATA                                              0
#define AVR32_PDCA_DATA_MASK                                0xffffffff
#define AVR32_PDCA_DATA_OFFSET                                       0
#define AVR32_PDCA_DATA_SIZE                                        32
#define AVR32_PDCA_ECLR                                              8
#define AVR32_PDCA_ECLR_MASK                                0x00000100
#define AVR32_PDCA_ECLR_OFFSET                                       8
#define AVR32_PDCA_ECLR_SIZE                                         1
#define AVR32_PDCA_ETRIG                                             2
#define AVR32_PDCA_ETRIG_MASK                               0x00000004
#define AVR32_PDCA_ETRIG_OFFSET                                      2
#define AVR32_PDCA_ETRIG_SIZE                                        1
#define AVR32_PDCA_HALF_WORD                                0x00000001
#define AVR32_PDCA_IDR0                                     0x00000024
#define AVR32_PDCA_IDR0_MASK                                0x00000007
#define AVR32_PDCA_IDR0_RCZ                                          0
#define AVR32_PDCA_IDR0_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR0_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR0_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR0_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR0_TERR                                         2
#define AVR32_PDCA_IDR0_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR0_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR0_TERR_SIZE                                    1
#define AVR32_PDCA_IDR0_TRC                                          1
#define AVR32_PDCA_IDR0_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR0_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR0_TRC_SIZE                                     1
#define AVR32_PDCA_IDR1                                     0x00000064
#define AVR32_PDCA_IDR10                                    0x000002a4
#define AVR32_PDCA_IDR10_MASK                               0x00000007
#define AVR32_PDCA_IDR10_RCZ                                         0
#define AVR32_PDCA_IDR10_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR10_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR10_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR10_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR10_TERR                                        2
#define AVR32_PDCA_IDR10_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR10_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR10_TERR_SIZE                                   1
#define AVR32_PDCA_IDR10_TRC                                         1
#define AVR32_PDCA_IDR10_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR10_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR10_TRC_SIZE                                    1
#define AVR32_PDCA_IDR11                                    0x000002e4
#define AVR32_PDCA_IDR11_MASK                               0x00000007
#define AVR32_PDCA_IDR11_RCZ                                         0
#define AVR32_PDCA_IDR11_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR11_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR11_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR11_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR11_TERR                                        2
#define AVR32_PDCA_IDR11_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR11_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR11_TERR_SIZE                                   1
#define AVR32_PDCA_IDR11_TRC                                         1
#define AVR32_PDCA_IDR11_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR11_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR11_TRC_SIZE                                    1
#define AVR32_PDCA_IDR12                                    0x00000324
#define AVR32_PDCA_IDR12_MASK                               0x00000007
#define AVR32_PDCA_IDR12_RCZ                                         0
#define AVR32_PDCA_IDR12_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR12_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR12_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR12_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR12_TERR                                        2
#define AVR32_PDCA_IDR12_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR12_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR12_TERR_SIZE                                   1
#define AVR32_PDCA_IDR12_TRC                                         1
#define AVR32_PDCA_IDR12_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR12_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR12_TRC_SIZE                                    1
#define AVR32_PDCA_IDR13                                    0x00000364
#define AVR32_PDCA_IDR13_MASK                               0x00000007
#define AVR32_PDCA_IDR13_RCZ                                         0
#define AVR32_PDCA_IDR13_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR13_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR13_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR13_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR13_TERR                                        2
#define AVR32_PDCA_IDR13_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR13_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR13_TERR_SIZE                                   1
#define AVR32_PDCA_IDR13_TRC                                         1
#define AVR32_PDCA_IDR13_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR13_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR13_TRC_SIZE                                    1
#define AVR32_PDCA_IDR14                                    0x000003a4
#define AVR32_PDCA_IDR14_MASK                               0x00000007
#define AVR32_PDCA_IDR14_RCZ                                         0
#define AVR32_PDCA_IDR14_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR14_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR14_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR14_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR14_TERR                                        2
#define AVR32_PDCA_IDR14_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR14_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR14_TERR_SIZE                                   1
#define AVR32_PDCA_IDR14_TRC                                         1
#define AVR32_PDCA_IDR14_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR14_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR14_TRC_SIZE                                    1
#define AVR32_PDCA_IDR15                                    0x000003e4
#define AVR32_PDCA_IDR15_MASK                               0x00000007
#define AVR32_PDCA_IDR15_RCZ                                         0
#define AVR32_PDCA_IDR15_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR15_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR15_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR15_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR15_TERR                                        2
#define AVR32_PDCA_IDR15_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR15_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR15_TERR_SIZE                                   1
#define AVR32_PDCA_IDR15_TRC                                         1
#define AVR32_PDCA_IDR15_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR15_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR15_TRC_SIZE                                    1
#define AVR32_PDCA_IDR16                                    0x00000424
#define AVR32_PDCA_IDR16_MASK                               0x00000007
#define AVR32_PDCA_IDR16_RCZ                                         0
#define AVR32_PDCA_IDR16_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR16_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR16_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR16_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR16_TERR                                        2
#define AVR32_PDCA_IDR16_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR16_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR16_TERR_SIZE                                   1
#define AVR32_PDCA_IDR16_TRC                                         1
#define AVR32_PDCA_IDR16_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR16_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR16_TRC_SIZE                                    1
#define AVR32_PDCA_IDR17                                    0x00000464
#define AVR32_PDCA_IDR17_MASK                               0x00000007
#define AVR32_PDCA_IDR17_RCZ                                         0
#define AVR32_PDCA_IDR17_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR17_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR17_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR17_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR17_TERR                                        2
#define AVR32_PDCA_IDR17_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR17_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR17_TERR_SIZE                                   1
#define AVR32_PDCA_IDR17_TRC                                         1
#define AVR32_PDCA_IDR17_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR17_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR17_TRC_SIZE                                    1
#define AVR32_PDCA_IDR18                                    0x000004a4
#define AVR32_PDCA_IDR18_MASK                               0x00000007
#define AVR32_PDCA_IDR18_RCZ                                         0
#define AVR32_PDCA_IDR18_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR18_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR18_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR18_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR18_TERR                                        2
#define AVR32_PDCA_IDR18_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR18_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR18_TERR_SIZE                                   1
#define AVR32_PDCA_IDR18_TRC                                         1
#define AVR32_PDCA_IDR18_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR18_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR18_TRC_SIZE                                    1
#define AVR32_PDCA_IDR19                                    0x000004e4
#define AVR32_PDCA_IDR19_MASK                               0x00000007
#define AVR32_PDCA_IDR19_RCZ                                         0
#define AVR32_PDCA_IDR19_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IDR19_RCZ_OFFSET                                  0
#define AVR32_PDCA_IDR19_RCZ_SIZE                                    1
#define AVR32_PDCA_IDR19_RESETVALUE                         0x00000000
#define AVR32_PDCA_IDR19_TERR                                        2
#define AVR32_PDCA_IDR19_TERR_MASK                          0x00000004
#define AVR32_PDCA_IDR19_TERR_OFFSET                                 2
#define AVR32_PDCA_IDR19_TERR_SIZE                                   1
#define AVR32_PDCA_IDR19_TRC                                         1
#define AVR32_PDCA_IDR19_TRC_MASK                           0x00000002
#define AVR32_PDCA_IDR19_TRC_OFFSET                                  1
#define AVR32_PDCA_IDR19_TRC_SIZE                                    1
#define AVR32_PDCA_IDR1_MASK                                0x00000007
#define AVR32_PDCA_IDR1_RCZ                                          0
#define AVR32_PDCA_IDR1_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR1_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR1_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR1_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR1_TERR                                         2
#define AVR32_PDCA_IDR1_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR1_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR1_TERR_SIZE                                    1
#define AVR32_PDCA_IDR1_TRC                                          1
#define AVR32_PDCA_IDR1_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR1_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR1_TRC_SIZE                                     1
#define AVR32_PDCA_IDR2                                     0x000000a4
#define AVR32_PDCA_IDR2_MASK                                0x00000007
#define AVR32_PDCA_IDR2_RCZ                                          0
#define AVR32_PDCA_IDR2_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR2_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR2_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR2_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR2_TERR                                         2
#define AVR32_PDCA_IDR2_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR2_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR2_TERR_SIZE                                    1
#define AVR32_PDCA_IDR2_TRC                                          1
#define AVR32_PDCA_IDR2_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR2_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR2_TRC_SIZE                                     1
#define AVR32_PDCA_IDR3                                     0x000000e4
#define AVR32_PDCA_IDR3_MASK                                0x00000007
#define AVR32_PDCA_IDR3_RCZ                                          0
#define AVR32_PDCA_IDR3_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR3_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR3_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR3_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR3_TERR                                         2
#define AVR32_PDCA_IDR3_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR3_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR3_TERR_SIZE                                    1
#define AVR32_PDCA_IDR3_TRC                                          1
#define AVR32_PDCA_IDR3_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR3_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR3_TRC_SIZE                                     1
#define AVR32_PDCA_IDR4                                     0x00000124
#define AVR32_PDCA_IDR4_MASK                                0x00000007
#define AVR32_PDCA_IDR4_RCZ                                          0
#define AVR32_PDCA_IDR4_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR4_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR4_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR4_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR4_TERR                                         2
#define AVR32_PDCA_IDR4_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR4_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR4_TERR_SIZE                                    1
#define AVR32_PDCA_IDR4_TRC                                          1
#define AVR32_PDCA_IDR4_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR4_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR4_TRC_SIZE                                     1
#define AVR32_PDCA_IDR5                                     0x00000164
#define AVR32_PDCA_IDR5_MASK                                0x00000007
#define AVR32_PDCA_IDR5_RCZ                                          0
#define AVR32_PDCA_IDR5_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR5_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR5_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR5_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR5_TERR                                         2
#define AVR32_PDCA_IDR5_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR5_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR5_TERR_SIZE                                    1
#define AVR32_PDCA_IDR5_TRC                                          1
#define AVR32_PDCA_IDR5_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR5_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR5_TRC_SIZE                                     1
#define AVR32_PDCA_IDR6                                     0x000001a4
#define AVR32_PDCA_IDR6_MASK                                0x00000007
#define AVR32_PDCA_IDR6_RCZ                                          0
#define AVR32_PDCA_IDR6_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR6_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR6_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR6_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR6_TERR                                         2
#define AVR32_PDCA_IDR6_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR6_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR6_TERR_SIZE                                    1
#define AVR32_PDCA_IDR6_TRC                                          1
#define AVR32_PDCA_IDR6_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR6_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR6_TRC_SIZE                                     1
#define AVR32_PDCA_IDR7                                     0x000001e4
#define AVR32_PDCA_IDR7_MASK                                0x00000007
#define AVR32_PDCA_IDR7_RCZ                                          0
#define AVR32_PDCA_IDR7_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR7_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR7_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR7_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR7_TERR                                         2
#define AVR32_PDCA_IDR7_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR7_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR7_TERR_SIZE                                    1
#define AVR32_PDCA_IDR7_TRC                                          1
#define AVR32_PDCA_IDR7_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR7_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR7_TRC_SIZE                                     1
#define AVR32_PDCA_IDR8                                     0x00000224
#define AVR32_PDCA_IDR8_MASK                                0x00000007
#define AVR32_PDCA_IDR8_RCZ                                          0
#define AVR32_PDCA_IDR8_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR8_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR8_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR8_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR8_TERR                                         2
#define AVR32_PDCA_IDR8_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR8_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR8_TERR_SIZE                                    1
#define AVR32_PDCA_IDR8_TRC                                          1
#define AVR32_PDCA_IDR8_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR8_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR8_TRC_SIZE                                     1
#define AVR32_PDCA_IDR9                                     0x00000264
#define AVR32_PDCA_IDR9_MASK                                0x00000007
#define AVR32_PDCA_IDR9_RCZ                                          0
#define AVR32_PDCA_IDR9_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IDR9_RCZ_OFFSET                                   0
#define AVR32_PDCA_IDR9_RCZ_SIZE                                     1
#define AVR32_PDCA_IDR9_RESETVALUE                          0x00000000
#define AVR32_PDCA_IDR9_TERR                                         2
#define AVR32_PDCA_IDR9_TERR_MASK                           0x00000004
#define AVR32_PDCA_IDR9_TERR_OFFSET                                  2
#define AVR32_PDCA_IDR9_TERR_SIZE                                    1
#define AVR32_PDCA_IDR9_TRC                                          1
#define AVR32_PDCA_IDR9_TRC_MASK                            0x00000002
#define AVR32_PDCA_IDR9_TRC_OFFSET                                   1
#define AVR32_PDCA_IDR9_TRC_SIZE                                     1
#define AVR32_PDCA_IER0                                     0x00000020
#define AVR32_PDCA_IER0_MASK                                0x00000007
#define AVR32_PDCA_IER0_RCZ                                          0
#define AVR32_PDCA_IER0_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER0_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER0_RCZ_SIZE                                     1
#define AVR32_PDCA_IER0_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER0_TERR                                         2
#define AVR32_PDCA_IER0_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER0_TERR_OFFSET                                  2
#define AVR32_PDCA_IER0_TERR_SIZE                                    1
#define AVR32_PDCA_IER0_TRC                                          1
#define AVR32_PDCA_IER0_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER0_TRC_OFFSET                                   1
#define AVR32_PDCA_IER0_TRC_SIZE                                     1
#define AVR32_PDCA_IER1                                     0x00000060
#define AVR32_PDCA_IER10                                    0x000002a0
#define AVR32_PDCA_IER10_MASK                               0x00000007
#define AVR32_PDCA_IER10_RCZ                                         0
#define AVR32_PDCA_IER10_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER10_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER10_RCZ_SIZE                                    1
#define AVR32_PDCA_IER10_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER10_TERR                                        2
#define AVR32_PDCA_IER10_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER10_TERR_OFFSET                                 2
#define AVR32_PDCA_IER10_TERR_SIZE                                   1
#define AVR32_PDCA_IER10_TRC                                         1
#define AVR32_PDCA_IER10_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER10_TRC_OFFSET                                  1
#define AVR32_PDCA_IER10_TRC_SIZE                                    1
#define AVR32_PDCA_IER11                                    0x000002e0
#define AVR32_PDCA_IER11_MASK                               0x00000007
#define AVR32_PDCA_IER11_RCZ                                         0
#define AVR32_PDCA_IER11_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER11_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER11_RCZ_SIZE                                    1
#define AVR32_PDCA_IER11_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER11_TERR                                        2
#define AVR32_PDCA_IER11_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER11_TERR_OFFSET                                 2
#define AVR32_PDCA_IER11_TERR_SIZE                                   1
#define AVR32_PDCA_IER11_TRC                                         1
#define AVR32_PDCA_IER11_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER11_TRC_OFFSET                                  1
#define AVR32_PDCA_IER11_TRC_SIZE                                    1
#define AVR32_PDCA_IER12                                    0x00000320
#define AVR32_PDCA_IER12_MASK                               0x00000007
#define AVR32_PDCA_IER12_RCZ                                         0
#define AVR32_PDCA_IER12_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER12_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER12_RCZ_SIZE                                    1
#define AVR32_PDCA_IER12_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER12_TERR                                        2
#define AVR32_PDCA_IER12_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER12_TERR_OFFSET                                 2
#define AVR32_PDCA_IER12_TERR_SIZE                                   1
#define AVR32_PDCA_IER12_TRC                                         1
#define AVR32_PDCA_IER12_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER12_TRC_OFFSET                                  1
#define AVR32_PDCA_IER12_TRC_SIZE                                    1
#define AVR32_PDCA_IER13                                    0x00000360
#define AVR32_PDCA_IER13_MASK                               0x00000007
#define AVR32_PDCA_IER13_RCZ                                         0
#define AVR32_PDCA_IER13_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER13_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER13_RCZ_SIZE                                    1
#define AVR32_PDCA_IER13_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER13_TERR                                        2
#define AVR32_PDCA_IER13_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER13_TERR_OFFSET                                 2
#define AVR32_PDCA_IER13_TERR_SIZE                                   1
#define AVR32_PDCA_IER13_TRC                                         1
#define AVR32_PDCA_IER13_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER13_TRC_OFFSET                                  1
#define AVR32_PDCA_IER13_TRC_SIZE                                    1
#define AVR32_PDCA_IER14                                    0x000003a0
#define AVR32_PDCA_IER14_MASK                               0x00000007
#define AVR32_PDCA_IER14_RCZ                                         0
#define AVR32_PDCA_IER14_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER14_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER14_RCZ_SIZE                                    1
#define AVR32_PDCA_IER14_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER14_TERR                                        2
#define AVR32_PDCA_IER14_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER14_TERR_OFFSET                                 2
#define AVR32_PDCA_IER14_TERR_SIZE                                   1
#define AVR32_PDCA_IER14_TRC                                         1
#define AVR32_PDCA_IER14_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER14_TRC_OFFSET                                  1
#define AVR32_PDCA_IER14_TRC_SIZE                                    1
#define AVR32_PDCA_IER15                                    0x000003e0
#define AVR32_PDCA_IER15_MASK                               0x00000007
#define AVR32_PDCA_IER15_RCZ                                         0
#define AVR32_PDCA_IER15_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER15_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER15_RCZ_SIZE                                    1
#define AVR32_PDCA_IER15_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER15_TERR                                        2
#define AVR32_PDCA_IER15_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER15_TERR_OFFSET                                 2
#define AVR32_PDCA_IER15_TERR_SIZE                                   1
#define AVR32_PDCA_IER15_TRC                                         1
#define AVR32_PDCA_IER15_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER15_TRC_OFFSET                                  1
#define AVR32_PDCA_IER15_TRC_SIZE                                    1
#define AVR32_PDCA_IER16                                    0x00000420
#define AVR32_PDCA_IER16_MASK                               0x00000007
#define AVR32_PDCA_IER16_RCZ                                         0
#define AVR32_PDCA_IER16_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER16_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER16_RCZ_SIZE                                    1
#define AVR32_PDCA_IER16_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER16_TERR                                        2
#define AVR32_PDCA_IER16_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER16_TERR_OFFSET                                 2
#define AVR32_PDCA_IER16_TERR_SIZE                                   1
#define AVR32_PDCA_IER16_TRC                                         1
#define AVR32_PDCA_IER16_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER16_TRC_OFFSET                                  1
#define AVR32_PDCA_IER16_TRC_SIZE                                    1
#define AVR32_PDCA_IER17                                    0x00000460
#define AVR32_PDCA_IER17_MASK                               0x00000007
#define AVR32_PDCA_IER17_RCZ                                         0
#define AVR32_PDCA_IER17_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER17_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER17_RCZ_SIZE                                    1
#define AVR32_PDCA_IER17_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER17_TERR                                        2
#define AVR32_PDCA_IER17_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER17_TERR_OFFSET                                 2
#define AVR32_PDCA_IER17_TERR_SIZE                                   1
#define AVR32_PDCA_IER17_TRC                                         1
#define AVR32_PDCA_IER17_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER17_TRC_OFFSET                                  1
#define AVR32_PDCA_IER17_TRC_SIZE                                    1
#define AVR32_PDCA_IER18                                    0x000004a0
#define AVR32_PDCA_IER18_MASK                               0x00000007
#define AVR32_PDCA_IER18_RCZ                                         0
#define AVR32_PDCA_IER18_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER18_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER18_RCZ_SIZE                                    1
#define AVR32_PDCA_IER18_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER18_TERR                                        2
#define AVR32_PDCA_IER18_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER18_TERR_OFFSET                                 2
#define AVR32_PDCA_IER18_TERR_SIZE                                   1
#define AVR32_PDCA_IER18_TRC                                         1
#define AVR32_PDCA_IER18_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER18_TRC_OFFSET                                  1
#define AVR32_PDCA_IER18_TRC_SIZE                                    1
#define AVR32_PDCA_IER19                                    0x000004e0
#define AVR32_PDCA_IER19_MASK                               0x00000007
#define AVR32_PDCA_IER19_RCZ                                         0
#define AVR32_PDCA_IER19_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IER19_RCZ_OFFSET                                  0
#define AVR32_PDCA_IER19_RCZ_SIZE                                    1
#define AVR32_PDCA_IER19_RESETVALUE                         0x00000000
#define AVR32_PDCA_IER19_TERR                                        2
#define AVR32_PDCA_IER19_TERR_MASK                          0x00000004
#define AVR32_PDCA_IER19_TERR_OFFSET                                 2
#define AVR32_PDCA_IER19_TERR_SIZE                                   1
#define AVR32_PDCA_IER19_TRC                                         1
#define AVR32_PDCA_IER19_TRC_MASK                           0x00000002
#define AVR32_PDCA_IER19_TRC_OFFSET                                  1
#define AVR32_PDCA_IER19_TRC_SIZE                                    1
#define AVR32_PDCA_IER1_MASK                                0x00000007
#define AVR32_PDCA_IER1_RCZ                                          0
#define AVR32_PDCA_IER1_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER1_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER1_RCZ_SIZE                                     1
#define AVR32_PDCA_IER1_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER1_TERR                                         2
#define AVR32_PDCA_IER1_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER1_TERR_OFFSET                                  2
#define AVR32_PDCA_IER1_TERR_SIZE                                    1
#define AVR32_PDCA_IER1_TRC                                          1
#define AVR32_PDCA_IER1_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER1_TRC_OFFSET                                   1
#define AVR32_PDCA_IER1_TRC_SIZE                                     1
#define AVR32_PDCA_IER2                                     0x000000a0
#define AVR32_PDCA_IER2_MASK                                0x00000007
#define AVR32_PDCA_IER2_RCZ                                          0
#define AVR32_PDCA_IER2_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER2_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER2_RCZ_SIZE                                     1
#define AVR32_PDCA_IER2_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER2_TERR                                         2
#define AVR32_PDCA_IER2_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER2_TERR_OFFSET                                  2
#define AVR32_PDCA_IER2_TERR_SIZE                                    1
#define AVR32_PDCA_IER2_TRC                                          1
#define AVR32_PDCA_IER2_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER2_TRC_OFFSET                                   1
#define AVR32_PDCA_IER2_TRC_SIZE                                     1
#define AVR32_PDCA_IER3                                     0x000000e0
#define AVR32_PDCA_IER3_MASK                                0x00000007
#define AVR32_PDCA_IER3_RCZ                                          0
#define AVR32_PDCA_IER3_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER3_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER3_RCZ_SIZE                                     1
#define AVR32_PDCA_IER3_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER3_TERR                                         2
#define AVR32_PDCA_IER3_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER3_TERR_OFFSET                                  2
#define AVR32_PDCA_IER3_TERR_SIZE                                    1
#define AVR32_PDCA_IER3_TRC                                          1
#define AVR32_PDCA_IER3_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER3_TRC_OFFSET                                   1
#define AVR32_PDCA_IER3_TRC_SIZE                                     1
#define AVR32_PDCA_IER4                                     0x00000120
#define AVR32_PDCA_IER4_MASK                                0x00000007
#define AVR32_PDCA_IER4_RCZ                                          0
#define AVR32_PDCA_IER4_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER4_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER4_RCZ_SIZE                                     1
#define AVR32_PDCA_IER4_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER4_TERR                                         2
#define AVR32_PDCA_IER4_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER4_TERR_OFFSET                                  2
#define AVR32_PDCA_IER4_TERR_SIZE                                    1
#define AVR32_PDCA_IER4_TRC                                          1
#define AVR32_PDCA_IER4_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER4_TRC_OFFSET                                   1
#define AVR32_PDCA_IER4_TRC_SIZE                                     1
#define AVR32_PDCA_IER5                                     0x00000160
#define AVR32_PDCA_IER5_MASK                                0x00000007
#define AVR32_PDCA_IER5_RCZ                                          0
#define AVR32_PDCA_IER5_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER5_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER5_RCZ_SIZE                                     1
#define AVR32_PDCA_IER5_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER5_TERR                                         2
#define AVR32_PDCA_IER5_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER5_TERR_OFFSET                                  2
#define AVR32_PDCA_IER5_TERR_SIZE                                    1
#define AVR32_PDCA_IER5_TRC                                          1
#define AVR32_PDCA_IER5_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER5_TRC_OFFSET                                   1
#define AVR32_PDCA_IER5_TRC_SIZE                                     1
#define AVR32_PDCA_IER6                                     0x000001a0
#define AVR32_PDCA_IER6_MASK                                0x00000007
#define AVR32_PDCA_IER6_RCZ                                          0
#define AVR32_PDCA_IER6_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER6_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER6_RCZ_SIZE                                     1
#define AVR32_PDCA_IER6_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER6_TERR                                         2
#define AVR32_PDCA_IER6_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER6_TERR_OFFSET                                  2
#define AVR32_PDCA_IER6_TERR_SIZE                                    1
#define AVR32_PDCA_IER6_TRC                                          1
#define AVR32_PDCA_IER6_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER6_TRC_OFFSET                                   1
#define AVR32_PDCA_IER6_TRC_SIZE                                     1
#define AVR32_PDCA_IER7                                     0x000001e0
#define AVR32_PDCA_IER7_MASK                                0x00000007
#define AVR32_PDCA_IER7_RCZ                                          0
#define AVR32_PDCA_IER7_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER7_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER7_RCZ_SIZE                                     1
#define AVR32_PDCA_IER7_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER7_TERR                                         2
#define AVR32_PDCA_IER7_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER7_TERR_OFFSET                                  2
#define AVR32_PDCA_IER7_TERR_SIZE                                    1
#define AVR32_PDCA_IER7_TRC                                          1
#define AVR32_PDCA_IER7_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER7_TRC_OFFSET                                   1
#define AVR32_PDCA_IER7_TRC_SIZE                                     1
#define AVR32_PDCA_IER8                                     0x00000220
#define AVR32_PDCA_IER8_MASK                                0x00000007
#define AVR32_PDCA_IER8_RCZ                                          0
#define AVR32_PDCA_IER8_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER8_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER8_RCZ_SIZE                                     1
#define AVR32_PDCA_IER8_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER8_TERR                                         2
#define AVR32_PDCA_IER8_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER8_TERR_OFFSET                                  2
#define AVR32_PDCA_IER8_TERR_SIZE                                    1
#define AVR32_PDCA_IER8_TRC                                          1
#define AVR32_PDCA_IER8_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER8_TRC_OFFSET                                   1
#define AVR32_PDCA_IER8_TRC_SIZE                                     1
#define AVR32_PDCA_IER9                                     0x00000260
#define AVR32_PDCA_IER9_MASK                                0x00000007
#define AVR32_PDCA_IER9_RCZ                                          0
#define AVR32_PDCA_IER9_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IER9_RCZ_OFFSET                                   0
#define AVR32_PDCA_IER9_RCZ_SIZE                                     1
#define AVR32_PDCA_IER9_RESETVALUE                          0x00000000
#define AVR32_PDCA_IER9_TERR                                         2
#define AVR32_PDCA_IER9_TERR_MASK                           0x00000004
#define AVR32_PDCA_IER9_TERR_OFFSET                                  2
#define AVR32_PDCA_IER9_TERR_SIZE                                    1
#define AVR32_PDCA_IER9_TRC                                          1
#define AVR32_PDCA_IER9_TRC_MASK                            0x00000002
#define AVR32_PDCA_IER9_TRC_OFFSET                                   1
#define AVR32_PDCA_IER9_TRC_SIZE                                     1
#define AVR32_PDCA_IMR0                                     0x00000028
#define AVR32_PDCA_IMR0_MASK                                0x00000007
#define AVR32_PDCA_IMR0_RCZ                                          0
#define AVR32_PDCA_IMR0_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR0_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR0_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR0_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR0_TERR                                         2
#define AVR32_PDCA_IMR0_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR0_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR0_TERR_SIZE                                    1
#define AVR32_PDCA_IMR0_TRC                                          1
#define AVR32_PDCA_IMR0_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR0_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR0_TRC_SIZE                                     1
#define AVR32_PDCA_IMR1                                     0x00000068
#define AVR32_PDCA_IMR10                                    0x000002a8
#define AVR32_PDCA_IMR10_MASK                               0x00000007
#define AVR32_PDCA_IMR10_RCZ                                         0
#define AVR32_PDCA_IMR10_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR10_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR10_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR10_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR10_TERR                                        2
#define AVR32_PDCA_IMR10_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR10_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR10_TERR_SIZE                                   1
#define AVR32_PDCA_IMR10_TRC                                         1
#define AVR32_PDCA_IMR10_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR10_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR10_TRC_SIZE                                    1
#define AVR32_PDCA_IMR11                                    0x000002e8
#define AVR32_PDCA_IMR11_MASK                               0x00000007
#define AVR32_PDCA_IMR11_RCZ                                         0
#define AVR32_PDCA_IMR11_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR11_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR11_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR11_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR11_TERR                                        2
#define AVR32_PDCA_IMR11_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR11_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR11_TERR_SIZE                                   1
#define AVR32_PDCA_IMR11_TRC                                         1
#define AVR32_PDCA_IMR11_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR11_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR11_TRC_SIZE                                    1
#define AVR32_PDCA_IMR12                                    0x00000328
#define AVR32_PDCA_IMR12_MASK                               0x00000007
#define AVR32_PDCA_IMR12_RCZ                                         0
#define AVR32_PDCA_IMR12_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR12_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR12_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR12_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR12_TERR                                        2
#define AVR32_PDCA_IMR12_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR12_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR12_TERR_SIZE                                   1
#define AVR32_PDCA_IMR12_TRC                                         1
#define AVR32_PDCA_IMR12_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR12_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR12_TRC_SIZE                                    1
#define AVR32_PDCA_IMR13                                    0x00000368
#define AVR32_PDCA_IMR13_MASK                               0x00000007
#define AVR32_PDCA_IMR13_RCZ                                         0
#define AVR32_PDCA_IMR13_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR13_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR13_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR13_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR13_TERR                                        2
#define AVR32_PDCA_IMR13_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR13_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR13_TERR_SIZE                                   1
#define AVR32_PDCA_IMR13_TRC                                         1
#define AVR32_PDCA_IMR13_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR13_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR13_TRC_SIZE                                    1
#define AVR32_PDCA_IMR14                                    0x000003a8
#define AVR32_PDCA_IMR14_MASK                               0x00000007
#define AVR32_PDCA_IMR14_RCZ                                         0
#define AVR32_PDCA_IMR14_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR14_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR14_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR14_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR14_TERR                                        2
#define AVR32_PDCA_IMR14_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR14_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR14_TERR_SIZE                                   1
#define AVR32_PDCA_IMR14_TRC                                         1
#define AVR32_PDCA_IMR14_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR14_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR14_TRC_SIZE                                    1
#define AVR32_PDCA_IMR15                                    0x000003e8
#define AVR32_PDCA_IMR15_MASK                               0x00000007
#define AVR32_PDCA_IMR15_RCZ                                         0
#define AVR32_PDCA_IMR15_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR15_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR15_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR15_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR15_TERR                                        2
#define AVR32_PDCA_IMR15_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR15_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR15_TERR_SIZE                                   1
#define AVR32_PDCA_IMR15_TRC                                         1
#define AVR32_PDCA_IMR15_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR15_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR15_TRC_SIZE                                    1
#define AVR32_PDCA_IMR16                                    0x00000428
#define AVR32_PDCA_IMR16_MASK                               0x00000007
#define AVR32_PDCA_IMR16_RCZ                                         0
#define AVR32_PDCA_IMR16_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR16_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR16_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR16_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR16_TERR                                        2
#define AVR32_PDCA_IMR16_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR16_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR16_TERR_SIZE                                   1
#define AVR32_PDCA_IMR16_TRC                                         1
#define AVR32_PDCA_IMR16_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR16_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR16_TRC_SIZE                                    1
#define AVR32_PDCA_IMR17                                    0x00000468
#define AVR32_PDCA_IMR17_MASK                               0x00000007
#define AVR32_PDCA_IMR17_RCZ                                         0
#define AVR32_PDCA_IMR17_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR17_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR17_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR17_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR17_TERR                                        2
#define AVR32_PDCA_IMR17_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR17_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR17_TERR_SIZE                                   1
#define AVR32_PDCA_IMR17_TRC                                         1
#define AVR32_PDCA_IMR17_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR17_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR17_TRC_SIZE                                    1
#define AVR32_PDCA_IMR18                                    0x000004a8
#define AVR32_PDCA_IMR18_MASK                               0x00000007
#define AVR32_PDCA_IMR18_RCZ                                         0
#define AVR32_PDCA_IMR18_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR18_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR18_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR18_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR18_TERR                                        2
#define AVR32_PDCA_IMR18_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR18_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR18_TERR_SIZE                                   1
#define AVR32_PDCA_IMR18_TRC                                         1
#define AVR32_PDCA_IMR18_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR18_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR18_TRC_SIZE                                    1
#define AVR32_PDCA_IMR19                                    0x000004e8
#define AVR32_PDCA_IMR19_MASK                               0x00000007
#define AVR32_PDCA_IMR19_RCZ                                         0
#define AVR32_PDCA_IMR19_RCZ_MASK                           0x00000001
#define AVR32_PDCA_IMR19_RCZ_OFFSET                                  0
#define AVR32_PDCA_IMR19_RCZ_SIZE                                    1
#define AVR32_PDCA_IMR19_RESETVALUE                         0x00000000
#define AVR32_PDCA_IMR19_TERR                                        2
#define AVR32_PDCA_IMR19_TERR_MASK                          0x00000004
#define AVR32_PDCA_IMR19_TERR_OFFSET                                 2
#define AVR32_PDCA_IMR19_TERR_SIZE                                   1
#define AVR32_PDCA_IMR19_TRC                                         1
#define AVR32_PDCA_IMR19_TRC_MASK                           0x00000002
#define AVR32_PDCA_IMR19_TRC_OFFSET                                  1
#define AVR32_PDCA_IMR19_TRC_SIZE                                    1
#define AVR32_PDCA_IMR1_MASK                                0x00000007
#define AVR32_PDCA_IMR1_RCZ                                          0
#define AVR32_PDCA_IMR1_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR1_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR1_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR1_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR1_TERR                                         2
#define AVR32_PDCA_IMR1_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR1_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR1_TERR_SIZE                                    1
#define AVR32_PDCA_IMR1_TRC                                          1
#define AVR32_PDCA_IMR1_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR1_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR1_TRC_SIZE                                     1
#define AVR32_PDCA_IMR2                                     0x000000a8
#define AVR32_PDCA_IMR2_MASK                                0x00000007
#define AVR32_PDCA_IMR2_RCZ                                          0
#define AVR32_PDCA_IMR2_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR2_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR2_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR2_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR2_TERR                                         2
#define AVR32_PDCA_IMR2_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR2_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR2_TERR_SIZE                                    1
#define AVR32_PDCA_IMR2_TRC                                          1
#define AVR32_PDCA_IMR2_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR2_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR2_TRC_SIZE                                     1
#define AVR32_PDCA_IMR3                                     0x000000e8
#define AVR32_PDCA_IMR3_MASK                                0x00000007
#define AVR32_PDCA_IMR3_RCZ                                          0
#define AVR32_PDCA_IMR3_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR3_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR3_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR3_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR3_TERR                                         2
#define AVR32_PDCA_IMR3_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR3_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR3_TERR_SIZE                                    1
#define AVR32_PDCA_IMR3_TRC                                          1
#define AVR32_PDCA_IMR3_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR3_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR3_TRC_SIZE                                     1
#define AVR32_PDCA_IMR4                                     0x00000128
#define AVR32_PDCA_IMR4_MASK                                0x00000007
#define AVR32_PDCA_IMR4_RCZ                                          0
#define AVR32_PDCA_IMR4_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR4_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR4_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR4_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR4_TERR                                         2
#define AVR32_PDCA_IMR4_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR4_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR4_TERR_SIZE                                    1
#define AVR32_PDCA_IMR4_TRC                                          1
#define AVR32_PDCA_IMR4_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR4_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR4_TRC_SIZE                                     1
#define AVR32_PDCA_IMR5                                     0x00000168
#define AVR32_PDCA_IMR5_MASK                                0x00000007
#define AVR32_PDCA_IMR5_RCZ                                          0
#define AVR32_PDCA_IMR5_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR5_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR5_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR5_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR5_TERR                                         2
#define AVR32_PDCA_IMR5_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR5_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR5_TERR_SIZE                                    1
#define AVR32_PDCA_IMR5_TRC                                          1
#define AVR32_PDCA_IMR5_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR5_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR5_TRC_SIZE                                     1
#define AVR32_PDCA_IMR6                                     0x000001a8
#define AVR32_PDCA_IMR6_MASK                                0x00000007
#define AVR32_PDCA_IMR6_RCZ                                          0
#define AVR32_PDCA_IMR6_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR6_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR6_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR6_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR6_TERR                                         2
#define AVR32_PDCA_IMR6_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR6_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR6_TERR_SIZE                                    1
#define AVR32_PDCA_IMR6_TRC                                          1
#define AVR32_PDCA_IMR6_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR6_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR6_TRC_SIZE                                     1
#define AVR32_PDCA_IMR7                                     0x000001e8
#define AVR32_PDCA_IMR7_MASK                                0x00000007
#define AVR32_PDCA_IMR7_RCZ                                          0
#define AVR32_PDCA_IMR7_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR7_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR7_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR7_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR7_TERR                                         2
#define AVR32_PDCA_IMR7_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR7_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR7_TERR_SIZE                                    1
#define AVR32_PDCA_IMR7_TRC                                          1
#define AVR32_PDCA_IMR7_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR7_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR7_TRC_SIZE                                     1
#define AVR32_PDCA_IMR8                                     0x00000228
#define AVR32_PDCA_IMR8_MASK                                0x00000007
#define AVR32_PDCA_IMR8_RCZ                                          0
#define AVR32_PDCA_IMR8_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR8_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR8_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR8_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR8_TERR                                         2
#define AVR32_PDCA_IMR8_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR8_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR8_TERR_SIZE                                    1
#define AVR32_PDCA_IMR8_TRC                                          1
#define AVR32_PDCA_IMR8_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR8_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR8_TRC_SIZE                                     1
#define AVR32_PDCA_IMR9                                     0x00000268
#define AVR32_PDCA_IMR9_MASK                                0x00000007
#define AVR32_PDCA_IMR9_RCZ                                          0
#define AVR32_PDCA_IMR9_RCZ_MASK                            0x00000001
#define AVR32_PDCA_IMR9_RCZ_OFFSET                                   0
#define AVR32_PDCA_IMR9_RCZ_SIZE                                     1
#define AVR32_PDCA_IMR9_RESETVALUE                          0x00000000
#define AVR32_PDCA_IMR9_TERR                                         2
#define AVR32_PDCA_IMR9_TERR_MASK                           0x00000004
#define AVR32_PDCA_IMR9_TERR_OFFSET                                  2
#define AVR32_PDCA_IMR9_TERR_SIZE                                    1
#define AVR32_PDCA_IMR9_TRC                                          1
#define AVR32_PDCA_IMR9_TRC_MASK                            0x00000002
#define AVR32_PDCA_IMR9_TRC_OFFSET                                   1
#define AVR32_PDCA_IMR9_TRC_SIZE                                     1
#define AVR32_PDCA_ISR0                                     0x0000002c
#define AVR32_PDCA_ISR0_MASK                                0x00000007
#define AVR32_PDCA_ISR0_RCZ                                          0
#define AVR32_PDCA_ISR0_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR0_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR0_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR0_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR0_TERR                                         2
#define AVR32_PDCA_ISR0_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR0_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR0_TERR_SIZE                                    1
#define AVR32_PDCA_ISR0_TRC                                          1
#define AVR32_PDCA_ISR0_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR0_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR0_TRC_SIZE                                     1
#define AVR32_PDCA_ISR1                                     0x0000006c
#define AVR32_PDCA_ISR10                                    0x000002ac
#define AVR32_PDCA_ISR10_MASK                               0x00000007
#define AVR32_PDCA_ISR10_RCZ                                         0
#define AVR32_PDCA_ISR10_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR10_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR10_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR10_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR10_TERR                                        2
#define AVR32_PDCA_ISR10_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR10_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR10_TERR_SIZE                                   1
#define AVR32_PDCA_ISR10_TRC                                         1
#define AVR32_PDCA_ISR10_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR10_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR10_TRC_SIZE                                    1
#define AVR32_PDCA_ISR11                                    0x000002ec
#define AVR32_PDCA_ISR11_MASK                               0x00000007
#define AVR32_PDCA_ISR11_RCZ                                         0
#define AVR32_PDCA_ISR11_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR11_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR11_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR11_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR11_TERR                                        2
#define AVR32_PDCA_ISR11_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR11_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR11_TERR_SIZE                                   1
#define AVR32_PDCA_ISR11_TRC                                         1
#define AVR32_PDCA_ISR11_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR11_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR11_TRC_SIZE                                    1
#define AVR32_PDCA_ISR12                                    0x0000032c
#define AVR32_PDCA_ISR12_MASK                               0x00000007
#define AVR32_PDCA_ISR12_RCZ                                         0
#define AVR32_PDCA_ISR12_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR12_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR12_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR12_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR12_TERR                                        2
#define AVR32_PDCA_ISR12_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR12_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR12_TERR_SIZE                                   1
#define AVR32_PDCA_ISR12_TRC                                         1
#define AVR32_PDCA_ISR12_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR12_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR12_TRC_SIZE                                    1
#define AVR32_PDCA_ISR13                                    0x0000036c
#define AVR32_PDCA_ISR13_MASK                               0x00000007
#define AVR32_PDCA_ISR13_RCZ                                         0
#define AVR32_PDCA_ISR13_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR13_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR13_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR13_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR13_TERR                                        2
#define AVR32_PDCA_ISR13_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR13_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR13_TERR_SIZE                                   1
#define AVR32_PDCA_ISR13_TRC                                         1
#define AVR32_PDCA_ISR13_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR13_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR13_TRC_SIZE                                    1
#define AVR32_PDCA_ISR14                                    0x000003ac
#define AVR32_PDCA_ISR14_MASK                               0x00000007
#define AVR32_PDCA_ISR14_RCZ                                         0
#define AVR32_PDCA_ISR14_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR14_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR14_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR14_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR14_TERR                                        2
#define AVR32_PDCA_ISR14_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR14_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR14_TERR_SIZE                                   1
#define AVR32_PDCA_ISR14_TRC                                         1
#define AVR32_PDCA_ISR14_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR14_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR14_TRC_SIZE                                    1
#define AVR32_PDCA_ISR15                                    0x000003ec
#define AVR32_PDCA_ISR15_MASK                               0x00000007
#define AVR32_PDCA_ISR15_RCZ                                         0
#define AVR32_PDCA_ISR15_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR15_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR15_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR15_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR15_TERR                                        2
#define AVR32_PDCA_ISR15_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR15_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR15_TERR_SIZE                                   1
#define AVR32_PDCA_ISR15_TRC                                         1
#define AVR32_PDCA_ISR15_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR15_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR15_TRC_SIZE                                    1
#define AVR32_PDCA_ISR16                                    0x0000042c
#define AVR32_PDCA_ISR16_MASK                               0x00000007
#define AVR32_PDCA_ISR16_RCZ                                         0
#define AVR32_PDCA_ISR16_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR16_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR16_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR16_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR16_TERR                                        2
#define AVR32_PDCA_ISR16_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR16_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR16_TERR_SIZE                                   1
#define AVR32_PDCA_ISR16_TRC                                         1
#define AVR32_PDCA_ISR16_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR16_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR16_TRC_SIZE                                    1
#define AVR32_PDCA_ISR17                                    0x0000046c
#define AVR32_PDCA_ISR17_MASK                               0x00000007
#define AVR32_PDCA_ISR17_RCZ                                         0
#define AVR32_PDCA_ISR17_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR17_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR17_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR17_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR17_TERR                                        2
#define AVR32_PDCA_ISR17_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR17_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR17_TERR_SIZE                                   1
#define AVR32_PDCA_ISR17_TRC                                         1
#define AVR32_PDCA_ISR17_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR17_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR17_TRC_SIZE                                    1
#define AVR32_PDCA_ISR18                                    0x000004ac
#define AVR32_PDCA_ISR18_MASK                               0x00000007
#define AVR32_PDCA_ISR18_RCZ                                         0
#define AVR32_PDCA_ISR18_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR18_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR18_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR18_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR18_TERR                                        2
#define AVR32_PDCA_ISR18_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR18_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR18_TERR_SIZE                                   1
#define AVR32_PDCA_ISR18_TRC                                         1
#define AVR32_PDCA_ISR18_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR18_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR18_TRC_SIZE                                    1
#define AVR32_PDCA_ISR19                                    0x000004ec
#define AVR32_PDCA_ISR19_MASK                               0x00000007
#define AVR32_PDCA_ISR19_RCZ                                         0
#define AVR32_PDCA_ISR19_RCZ_MASK                           0x00000001
#define AVR32_PDCA_ISR19_RCZ_OFFSET                                  0
#define AVR32_PDCA_ISR19_RCZ_SIZE                                    1
#define AVR32_PDCA_ISR19_RESETVALUE                         0x00000000
#define AVR32_PDCA_ISR19_TERR                                        2
#define AVR32_PDCA_ISR19_TERR_MASK                          0x00000004
#define AVR32_PDCA_ISR19_TERR_OFFSET                                 2
#define AVR32_PDCA_ISR19_TERR_SIZE                                   1
#define AVR32_PDCA_ISR19_TRC                                         1
#define AVR32_PDCA_ISR19_TRC_MASK                           0x00000002
#define AVR32_PDCA_ISR19_TRC_OFFSET                                  1
#define AVR32_PDCA_ISR19_TRC_SIZE                                    1
#define AVR32_PDCA_ISR1_MASK                                0x00000007
#define AVR32_PDCA_ISR1_RCZ                                          0
#define AVR32_PDCA_ISR1_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR1_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR1_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR1_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR1_TERR                                         2
#define AVR32_PDCA_ISR1_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR1_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR1_TERR_SIZE                                    1
#define AVR32_PDCA_ISR1_TRC                                          1
#define AVR32_PDCA_ISR1_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR1_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR1_TRC_SIZE                                     1
#define AVR32_PDCA_ISR2                                     0x000000ac
#define AVR32_PDCA_ISR2_MASK                                0x00000007
#define AVR32_PDCA_ISR2_RCZ                                          0
#define AVR32_PDCA_ISR2_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR2_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR2_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR2_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR2_TERR                                         2
#define AVR32_PDCA_ISR2_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR2_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR2_TERR_SIZE                                    1
#define AVR32_PDCA_ISR2_TRC                                          1
#define AVR32_PDCA_ISR2_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR2_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR2_TRC_SIZE                                     1
#define AVR32_PDCA_ISR3                                     0x000000ec
#define AVR32_PDCA_ISR3_MASK                                0x00000007
#define AVR32_PDCA_ISR3_RCZ                                          0
#define AVR32_PDCA_ISR3_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR3_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR3_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR3_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR3_TERR                                         2
#define AVR32_PDCA_ISR3_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR3_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR3_TERR_SIZE                                    1
#define AVR32_PDCA_ISR3_TRC                                          1
#define AVR32_PDCA_ISR3_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR3_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR3_TRC_SIZE                                     1
#define AVR32_PDCA_ISR4                                     0x0000012c
#define AVR32_PDCA_ISR4_MASK                                0x00000007
#define AVR32_PDCA_ISR4_RCZ                                          0
#define AVR32_PDCA_ISR4_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR4_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR4_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR4_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR4_TERR                                         2
#define AVR32_PDCA_ISR4_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR4_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR4_TERR_SIZE                                    1
#define AVR32_PDCA_ISR4_TRC                                          1
#define AVR32_PDCA_ISR4_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR4_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR4_TRC_SIZE                                     1
#define AVR32_PDCA_ISR5                                     0x0000016c
#define AVR32_PDCA_ISR5_MASK                                0x00000007
#define AVR32_PDCA_ISR5_RCZ                                          0
#define AVR32_PDCA_ISR5_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR5_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR5_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR5_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR5_TERR                                         2
#define AVR32_PDCA_ISR5_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR5_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR5_TERR_SIZE                                    1
#define AVR32_PDCA_ISR5_TRC                                          1
#define AVR32_PDCA_ISR5_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR5_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR5_TRC_SIZE                                     1
#define AVR32_PDCA_ISR6                                     0x000001ac
#define AVR32_PDCA_ISR6_MASK                                0x00000007
#define AVR32_PDCA_ISR6_RCZ                                          0
#define AVR32_PDCA_ISR6_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR6_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR6_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR6_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR6_TERR                                         2
#define AVR32_PDCA_ISR6_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR6_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR6_TERR_SIZE                                    1
#define AVR32_PDCA_ISR6_TRC                                          1
#define AVR32_PDCA_ISR6_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR6_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR6_TRC_SIZE                                     1
#define AVR32_PDCA_ISR7                                     0x000001ec
#define AVR32_PDCA_ISR7_MASK                                0x00000007
#define AVR32_PDCA_ISR7_RCZ                                          0
#define AVR32_PDCA_ISR7_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR7_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR7_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR7_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR7_TERR                                         2
#define AVR32_PDCA_ISR7_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR7_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR7_TERR_SIZE                                    1
#define AVR32_PDCA_ISR7_TRC                                          1
#define AVR32_PDCA_ISR7_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR7_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR7_TRC_SIZE                                     1
#define AVR32_PDCA_ISR8                                     0x0000022c
#define AVR32_PDCA_ISR8_MASK                                0x00000007
#define AVR32_PDCA_ISR8_RCZ                                          0
#define AVR32_PDCA_ISR8_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR8_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR8_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR8_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR8_TERR                                         2
#define AVR32_PDCA_ISR8_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR8_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR8_TERR_SIZE                                    1
#define AVR32_PDCA_ISR8_TRC                                          1
#define AVR32_PDCA_ISR8_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR8_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR8_TRC_SIZE                                     1
#define AVR32_PDCA_ISR9                                     0x0000026c
#define AVR32_PDCA_ISR9_MASK                                0x00000007
#define AVR32_PDCA_ISR9_RCZ                                          0
#define AVR32_PDCA_ISR9_RCZ_MASK                            0x00000001
#define AVR32_PDCA_ISR9_RCZ_OFFSET                                   0
#define AVR32_PDCA_ISR9_RCZ_SIZE                                     1
#define AVR32_PDCA_ISR9_RESETVALUE                          0x00000000
#define AVR32_PDCA_ISR9_TERR                                         2
#define AVR32_PDCA_ISR9_TERR_MASK                           0x00000004
#define AVR32_PDCA_ISR9_TERR_OFFSET                                  2
#define AVR32_PDCA_ISR9_TERR_SIZE                                    1
#define AVR32_PDCA_ISR9_TRC                                          1
#define AVR32_PDCA_ISR9_TRC_MASK                            0x00000002
#define AVR32_PDCA_ISR9_TRC_OFFSET                                   1
#define AVR32_PDCA_ISR9_TRC_SIZE                                     1
#define AVR32_PDCA_LAT                                               0
#define AVR32_PDCA_LAT_MASK                                 0x0000ffff
#define AVR32_PDCA_LAT_OFFSET                                        0
#define AVR32_PDCA_LAT_SIZE                                         16
#define AVR32_PDCA_MADDR                                             0
#define AVR32_PDCA_MADDR_MASK                               0xffffffff
#define AVR32_PDCA_MADDR_OFFSET                                      0
#define AVR32_PDCA_MADDR_SIZE                                       32
#define AVR32_PDCA_MAR0                                     0x00000000
#define AVR32_PDCA_MAR0_MADDR                                        0
#define AVR32_PDCA_MAR0_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR0_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR0_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR0_MASK                                0xffffffff
#define AVR32_PDCA_MAR0_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR1                                     0x00000040
#define AVR32_PDCA_MAR10                                    0x00000280
#define AVR32_PDCA_MAR10_MADDR                                       0
#define AVR32_PDCA_MAR10_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR10_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR10_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR10_MASK                               0xffffffff
#define AVR32_PDCA_MAR10_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR11                                    0x000002c0
#define AVR32_PDCA_MAR11_MADDR                                       0
#define AVR32_PDCA_MAR11_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR11_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR11_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR11_MASK                               0xffffffff
#define AVR32_PDCA_MAR11_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR12                                    0x00000300
#define AVR32_PDCA_MAR12_MADDR                                       0
#define AVR32_PDCA_MAR12_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR12_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR12_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR12_MASK                               0xffffffff
#define AVR32_PDCA_MAR12_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR13                                    0x00000340
#define AVR32_PDCA_MAR13_MADDR                                       0
#define AVR32_PDCA_MAR13_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR13_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR13_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR13_MASK                               0xffffffff
#define AVR32_PDCA_MAR13_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR14                                    0x00000380
#define AVR32_PDCA_MAR14_MADDR                                       0
#define AVR32_PDCA_MAR14_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR14_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR14_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR14_MASK                               0xffffffff
#define AVR32_PDCA_MAR14_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR15                                    0x000003c0
#define AVR32_PDCA_MAR15_MADDR                                       0
#define AVR32_PDCA_MAR15_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR15_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR15_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR15_MASK                               0xffffffff
#define AVR32_PDCA_MAR15_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR16                                    0x00000400
#define AVR32_PDCA_MAR16_MADDR                                       0
#define AVR32_PDCA_MAR16_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR16_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR16_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR16_MASK                               0xffffffff
#define AVR32_PDCA_MAR16_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR17                                    0x00000440
#define AVR32_PDCA_MAR17_MADDR                                       0
#define AVR32_PDCA_MAR17_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR17_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR17_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR17_MASK                               0xffffffff
#define AVR32_PDCA_MAR17_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR18                                    0x00000480
#define AVR32_PDCA_MAR18_MADDR                                       0
#define AVR32_PDCA_MAR18_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR18_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR18_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR18_MASK                               0xffffffff
#define AVR32_PDCA_MAR18_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR19                                    0x000004c0
#define AVR32_PDCA_MAR19_MADDR                                       0
#define AVR32_PDCA_MAR19_MADDR_MASK                         0xffffffff
#define AVR32_PDCA_MAR19_MADDR_OFFSET                                0
#define AVR32_PDCA_MAR19_MADDR_SIZE                                 32
#define AVR32_PDCA_MAR19_MASK                               0xffffffff
#define AVR32_PDCA_MAR19_RESETVALUE                         0x00000000
#define AVR32_PDCA_MAR1_MADDR                                        0
#define AVR32_PDCA_MAR1_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR1_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR1_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR1_MASK                                0xffffffff
#define AVR32_PDCA_MAR1_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR2                                     0x00000080
#define AVR32_PDCA_MAR2_MADDR                                        0
#define AVR32_PDCA_MAR2_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR2_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR2_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR2_MASK                                0xffffffff
#define AVR32_PDCA_MAR2_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR3                                     0x000000c0
#define AVR32_PDCA_MAR3_MADDR                                        0
#define AVR32_PDCA_MAR3_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR3_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR3_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR3_MASK                                0xffffffff
#define AVR32_PDCA_MAR3_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR4                                     0x00000100
#define AVR32_PDCA_MAR4_MADDR                                        0
#define AVR32_PDCA_MAR4_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR4_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR4_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR4_MASK                                0xffffffff
#define AVR32_PDCA_MAR4_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR5                                     0x00000140
#define AVR32_PDCA_MAR5_MADDR                                        0
#define AVR32_PDCA_MAR5_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR5_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR5_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR5_MASK                                0xffffffff
#define AVR32_PDCA_MAR5_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR6                                     0x00000180
#define AVR32_PDCA_MAR6_MADDR                                        0
#define AVR32_PDCA_MAR6_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR6_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR6_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR6_MASK                                0xffffffff
#define AVR32_PDCA_MAR6_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR7                                     0x000001c0
#define AVR32_PDCA_MAR7_MADDR                                        0
#define AVR32_PDCA_MAR7_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR7_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR7_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR7_MASK                                0xffffffff
#define AVR32_PDCA_MAR7_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR8                                     0x00000200
#define AVR32_PDCA_MAR8_MADDR                                        0
#define AVR32_PDCA_MAR8_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR8_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR8_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR8_MASK                                0xffffffff
#define AVR32_PDCA_MAR8_RESETVALUE                          0x00000000
#define AVR32_PDCA_MAR9                                     0x00000240
#define AVR32_PDCA_MAR9_MADDR                                        0
#define AVR32_PDCA_MAR9_MADDR_MASK                          0xffffffff
#define AVR32_PDCA_MAR9_MADDR_OFFSET                                 0
#define AVR32_PDCA_MAR9_MADDR_SIZE                                  32
#define AVR32_PDCA_MAR9_MASK                                0xffffffff
#define AVR32_PDCA_MAR9_RESETVALUE                          0x00000000
#define AVR32_PDCA_MARR0                                    0x0000000c
#define AVR32_PDCA_MARR0_MARV                                        0
#define AVR32_PDCA_MARR0_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR0_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR0_MARV_SIZE                                  32
#define AVR32_PDCA_MARR0_MASK                               0xffffffff
#define AVR32_PDCA_MARR0_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR1                                    0x0000004c
#define AVR32_PDCA_MARR10                                   0x0000028c
#define AVR32_PDCA_MARR10_MARV                                       0
#define AVR32_PDCA_MARR10_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR10_MARV_OFFSET                                0
#define AVR32_PDCA_MARR10_MARV_SIZE                                 32
#define AVR32_PDCA_MARR10_MASK                              0xffffffff
#define AVR32_PDCA_MARR10_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR11                                   0x000002cc
#define AVR32_PDCA_MARR11_MARV                                       0
#define AVR32_PDCA_MARR11_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR11_MARV_OFFSET                                0
#define AVR32_PDCA_MARR11_MARV_SIZE                                 32
#define AVR32_PDCA_MARR11_MASK                              0xffffffff
#define AVR32_PDCA_MARR11_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR12                                   0x0000030c
#define AVR32_PDCA_MARR12_MARV                                       0
#define AVR32_PDCA_MARR12_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR12_MARV_OFFSET                                0
#define AVR32_PDCA_MARR12_MARV_SIZE                                 32
#define AVR32_PDCA_MARR12_MASK                              0xffffffff
#define AVR32_PDCA_MARR12_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR13                                   0x0000034c
#define AVR32_PDCA_MARR13_MARV                                       0
#define AVR32_PDCA_MARR13_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR13_MARV_OFFSET                                0
#define AVR32_PDCA_MARR13_MARV_SIZE                                 32
#define AVR32_PDCA_MARR13_MASK                              0xffffffff
#define AVR32_PDCA_MARR13_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR14                                   0x0000038c
#define AVR32_PDCA_MARR14_MARV                                       0
#define AVR32_PDCA_MARR14_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR14_MARV_OFFSET                                0
#define AVR32_PDCA_MARR14_MARV_SIZE                                 32
#define AVR32_PDCA_MARR14_MASK                              0xffffffff
#define AVR32_PDCA_MARR14_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR15                                   0x000003cc
#define AVR32_PDCA_MARR15_MARV                                       0
#define AVR32_PDCA_MARR15_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR15_MARV_OFFSET                                0
#define AVR32_PDCA_MARR15_MARV_SIZE                                 32
#define AVR32_PDCA_MARR15_MASK                              0xffffffff
#define AVR32_PDCA_MARR15_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR16                                   0x0000040c
#define AVR32_PDCA_MARR16_MARV                                       0
#define AVR32_PDCA_MARR16_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR16_MARV_OFFSET                                0
#define AVR32_PDCA_MARR16_MARV_SIZE                                 32
#define AVR32_PDCA_MARR16_MASK                              0xffffffff
#define AVR32_PDCA_MARR16_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR17                                   0x0000044c
#define AVR32_PDCA_MARR17_MARV                                       0
#define AVR32_PDCA_MARR17_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR17_MARV_OFFSET                                0
#define AVR32_PDCA_MARR17_MARV_SIZE                                 32
#define AVR32_PDCA_MARR17_MASK                              0xffffffff
#define AVR32_PDCA_MARR17_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR18                                   0x0000048c
#define AVR32_PDCA_MARR18_MARV                                       0
#define AVR32_PDCA_MARR18_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR18_MARV_OFFSET                                0
#define AVR32_PDCA_MARR18_MARV_SIZE                                 32
#define AVR32_PDCA_MARR18_MASK                              0xffffffff
#define AVR32_PDCA_MARR18_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR19                                   0x000004cc
#define AVR32_PDCA_MARR19_MARV                                       0
#define AVR32_PDCA_MARR19_MARV_MASK                         0xffffffff
#define AVR32_PDCA_MARR19_MARV_OFFSET                                0
#define AVR32_PDCA_MARR19_MARV_SIZE                                 32
#define AVR32_PDCA_MARR19_MASK                              0xffffffff
#define AVR32_PDCA_MARR19_RESETVALUE                        0x00000000
#define AVR32_PDCA_MARR1_MARV                                        0
#define AVR32_PDCA_MARR1_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR1_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR1_MARV_SIZE                                  32
#define AVR32_PDCA_MARR1_MASK                               0xffffffff
#define AVR32_PDCA_MARR1_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR2                                    0x0000008c
#define AVR32_PDCA_MARR2_MARV                                        0
#define AVR32_PDCA_MARR2_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR2_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR2_MARV_SIZE                                  32
#define AVR32_PDCA_MARR2_MASK                               0xffffffff
#define AVR32_PDCA_MARR2_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR3                                    0x000000cc
#define AVR32_PDCA_MARR3_MARV                                        0
#define AVR32_PDCA_MARR3_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR3_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR3_MARV_SIZE                                  32
#define AVR32_PDCA_MARR3_MASK                               0xffffffff
#define AVR32_PDCA_MARR3_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR4                                    0x0000010c
#define AVR32_PDCA_MARR4_MARV                                        0
#define AVR32_PDCA_MARR4_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR4_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR4_MARV_SIZE                                  32
#define AVR32_PDCA_MARR4_MASK                               0xffffffff
#define AVR32_PDCA_MARR4_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR5                                    0x0000014c
#define AVR32_PDCA_MARR5_MARV                                        0
#define AVR32_PDCA_MARR5_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR5_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR5_MARV_SIZE                                  32
#define AVR32_PDCA_MARR5_MASK                               0xffffffff
#define AVR32_PDCA_MARR5_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR6                                    0x0000018c
#define AVR32_PDCA_MARR6_MARV                                        0
#define AVR32_PDCA_MARR6_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR6_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR6_MARV_SIZE                                  32
#define AVR32_PDCA_MARR6_MASK                               0xffffffff
#define AVR32_PDCA_MARR6_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR7                                    0x000001cc
#define AVR32_PDCA_MARR7_MARV                                        0
#define AVR32_PDCA_MARR7_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR7_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR7_MARV_SIZE                                  32
#define AVR32_PDCA_MARR7_MASK                               0xffffffff
#define AVR32_PDCA_MARR7_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR8                                    0x0000020c
#define AVR32_PDCA_MARR8_MARV                                        0
#define AVR32_PDCA_MARR8_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR8_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR8_MARV_SIZE                                  32
#define AVR32_PDCA_MARR8_MASK                               0xffffffff
#define AVR32_PDCA_MARR8_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARR9                                    0x0000024c
#define AVR32_PDCA_MARR9_MARV                                        0
#define AVR32_PDCA_MARR9_MARV_MASK                          0xffffffff
#define AVR32_PDCA_MARR9_MARV_OFFSET                                 0
#define AVR32_PDCA_MARR9_MARV_SIZE                                  32
#define AVR32_PDCA_MARR9_MASK                               0xffffffff
#define AVR32_PDCA_MARR9_RESETVALUE                         0x00000000
#define AVR32_PDCA_MARV                                              0
#define AVR32_PDCA_MARV_MASK                                0xffffffff
#define AVR32_PDCA_MARV_OFFSET                                       0
#define AVR32_PDCA_MARV_SIZE                                        32
#define AVR32_PDCA_MON0CH                                           16
#define AVR32_PDCA_MON0CH_MASK                              0x003f0000
#define AVR32_PDCA_MON0CH_OFFSET                                    16
#define AVR32_PDCA_MON0CH_SIZE                                       6
#define AVR32_PDCA_MON1CH                                           24
#define AVR32_PDCA_MON1CH_MASK                              0x3f000000
#define AVR32_PDCA_MON1CH_OFFSET                                    24
#define AVR32_PDCA_MON1CH_SIZE                                       6
#define AVR32_PDCA_MR0                                      0x00000018
#define AVR32_PDCA_MR0_ETRIG                                         2
#define AVR32_PDCA_MR0_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR0_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR0_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR0_MASK                                 0x0000000f
#define AVR32_PDCA_MR0_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR0_RING                                          3
#define AVR32_PDCA_MR0_RING_MASK                            0x00000008
#define AVR32_PDCA_MR0_RING_OFFSET                                   3
#define AVR32_PDCA_MR0_RING_SIZE                                     1
#define AVR32_PDCA_MR0_SIZE                                          0
#define AVR32_PDCA_MR0_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR0_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR0_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR0_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR0_SIZE_SIZE                                     2
#define AVR32_PDCA_MR0_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR1                                      0x00000058
#define AVR32_PDCA_MR10                                     0x00000298
#define AVR32_PDCA_MR10_ETRIG                                        2
#define AVR32_PDCA_MR10_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR10_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR10_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR10_MASK                                0x0000000f
#define AVR32_PDCA_MR10_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR10_RING                                         3
#define AVR32_PDCA_MR10_RING_MASK                           0x00000008
#define AVR32_PDCA_MR10_RING_OFFSET                                  3
#define AVR32_PDCA_MR10_RING_SIZE                                    1
#define AVR32_PDCA_MR10_SIZE                                         0
#define AVR32_PDCA_MR10_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR10_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR10_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR10_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR10_SIZE_SIZE                                    2
#define AVR32_PDCA_MR10_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR11                                     0x000002d8
#define AVR32_PDCA_MR11_ETRIG                                        2
#define AVR32_PDCA_MR11_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR11_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR11_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR11_MASK                                0x0000000f
#define AVR32_PDCA_MR11_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR11_RING                                         3
#define AVR32_PDCA_MR11_RING_MASK                           0x00000008
#define AVR32_PDCA_MR11_RING_OFFSET                                  3
#define AVR32_PDCA_MR11_RING_SIZE                                    1
#define AVR32_PDCA_MR11_SIZE                                         0
#define AVR32_PDCA_MR11_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR11_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR11_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR11_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR11_SIZE_SIZE                                    2
#define AVR32_PDCA_MR11_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR12                                     0x00000318
#define AVR32_PDCA_MR12_ETRIG                                        2
#define AVR32_PDCA_MR12_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR12_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR12_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR12_MASK                                0x0000000f
#define AVR32_PDCA_MR12_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR12_RING                                         3
#define AVR32_PDCA_MR12_RING_MASK                           0x00000008
#define AVR32_PDCA_MR12_RING_OFFSET                                  3
#define AVR32_PDCA_MR12_RING_SIZE                                    1
#define AVR32_PDCA_MR12_SIZE                                         0
#define AVR32_PDCA_MR12_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR12_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR12_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR12_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR12_SIZE_SIZE                                    2
#define AVR32_PDCA_MR12_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR13                                     0x00000358
#define AVR32_PDCA_MR13_ETRIG                                        2
#define AVR32_PDCA_MR13_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR13_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR13_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR13_MASK                                0x0000000f
#define AVR32_PDCA_MR13_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR13_RING                                         3
#define AVR32_PDCA_MR13_RING_MASK                           0x00000008
#define AVR32_PDCA_MR13_RING_OFFSET                                  3
#define AVR32_PDCA_MR13_RING_SIZE                                    1
#define AVR32_PDCA_MR13_SIZE                                         0
#define AVR32_PDCA_MR13_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR13_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR13_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR13_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR13_SIZE_SIZE                                    2
#define AVR32_PDCA_MR13_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR14                                     0x00000398
#define AVR32_PDCA_MR14_ETRIG                                        2
#define AVR32_PDCA_MR14_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR14_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR14_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR14_MASK                                0x0000000f
#define AVR32_PDCA_MR14_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR14_RING                                         3
#define AVR32_PDCA_MR14_RING_MASK                           0x00000008
#define AVR32_PDCA_MR14_RING_OFFSET                                  3
#define AVR32_PDCA_MR14_RING_SIZE                                    1
#define AVR32_PDCA_MR14_SIZE                                         0
#define AVR32_PDCA_MR14_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR14_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR14_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR14_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR14_SIZE_SIZE                                    2
#define AVR32_PDCA_MR14_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR15                                     0x000003d8
#define AVR32_PDCA_MR15_ETRIG                                        2
#define AVR32_PDCA_MR15_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR15_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR15_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR15_MASK                                0x0000000f
#define AVR32_PDCA_MR15_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR15_RING                                         3
#define AVR32_PDCA_MR15_RING_MASK                           0x00000008
#define AVR32_PDCA_MR15_RING_OFFSET                                  3
#define AVR32_PDCA_MR15_RING_SIZE                                    1
#define AVR32_PDCA_MR15_SIZE                                         0
#define AVR32_PDCA_MR15_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR15_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR15_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR15_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR15_SIZE_SIZE                                    2
#define AVR32_PDCA_MR15_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR16                                     0x00000418
#define AVR32_PDCA_MR16_ETRIG                                        2
#define AVR32_PDCA_MR16_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR16_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR16_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR16_MASK                                0x0000000f
#define AVR32_PDCA_MR16_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR16_RING                                         3
#define AVR32_PDCA_MR16_RING_MASK                           0x00000008
#define AVR32_PDCA_MR16_RING_OFFSET                                  3
#define AVR32_PDCA_MR16_RING_SIZE                                    1
#define AVR32_PDCA_MR16_SIZE                                         0
#define AVR32_PDCA_MR16_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR16_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR16_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR16_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR16_SIZE_SIZE                                    2
#define AVR32_PDCA_MR16_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR17                                     0x00000458
#define AVR32_PDCA_MR17_ETRIG                                        2
#define AVR32_PDCA_MR17_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR17_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR17_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR17_MASK                                0x0000000f
#define AVR32_PDCA_MR17_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR17_RING                                         3
#define AVR32_PDCA_MR17_RING_MASK                           0x00000008
#define AVR32_PDCA_MR17_RING_OFFSET                                  3
#define AVR32_PDCA_MR17_RING_SIZE                                    1
#define AVR32_PDCA_MR17_SIZE                                         0
#define AVR32_PDCA_MR17_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR17_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR17_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR17_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR17_SIZE_SIZE                                    2
#define AVR32_PDCA_MR17_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR18                                     0x00000498
#define AVR32_PDCA_MR18_ETRIG                                        2
#define AVR32_PDCA_MR18_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR18_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR18_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR18_MASK                                0x0000000f
#define AVR32_PDCA_MR18_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR18_RING                                         3
#define AVR32_PDCA_MR18_RING_MASK                           0x00000008
#define AVR32_PDCA_MR18_RING_OFFSET                                  3
#define AVR32_PDCA_MR18_RING_SIZE                                    1
#define AVR32_PDCA_MR18_SIZE                                         0
#define AVR32_PDCA_MR18_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR18_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR18_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR18_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR18_SIZE_SIZE                                    2
#define AVR32_PDCA_MR18_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR19                                     0x000004d8
#define AVR32_PDCA_MR19_ETRIG                                        2
#define AVR32_PDCA_MR19_ETRIG_MASK                          0x00000004
#define AVR32_PDCA_MR19_ETRIG_OFFSET                                 2
#define AVR32_PDCA_MR19_ETRIG_SIZE                                   1
#define AVR32_PDCA_MR19_MASK                                0x0000000f
#define AVR32_PDCA_MR19_RESETVALUE                          0x00000000
#define AVR32_PDCA_MR19_RING                                         3
#define AVR32_PDCA_MR19_RING_MASK                           0x00000008
#define AVR32_PDCA_MR19_RING_OFFSET                                  3
#define AVR32_PDCA_MR19_RING_SIZE                                    1
#define AVR32_PDCA_MR19_SIZE                                         0
#define AVR32_PDCA_MR19_SIZE_BYTE                           0x00000000
#define AVR32_PDCA_MR19_SIZE_HALF_WORD                      0x00000001
#define AVR32_PDCA_MR19_SIZE_MASK                           0x00000003
#define AVR32_PDCA_MR19_SIZE_OFFSET                                  0
#define AVR32_PDCA_MR19_SIZE_SIZE                                    2
#define AVR32_PDCA_MR19_SIZE_WORD                           0x00000002
#define AVR32_PDCA_MR1_ETRIG                                         2
#define AVR32_PDCA_MR1_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR1_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR1_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR1_MASK                                 0x0000000f
#define AVR32_PDCA_MR1_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR1_RING                                          3
#define AVR32_PDCA_MR1_RING_MASK                            0x00000008
#define AVR32_PDCA_MR1_RING_OFFSET                                   3
#define AVR32_PDCA_MR1_RING_SIZE                                     1
#define AVR32_PDCA_MR1_SIZE                                          0
#define AVR32_PDCA_MR1_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR1_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR1_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR1_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR1_SIZE_SIZE                                     2
#define AVR32_PDCA_MR1_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR2                                      0x00000098
#define AVR32_PDCA_MR2_ETRIG                                         2
#define AVR32_PDCA_MR2_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR2_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR2_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR2_MASK                                 0x0000000f
#define AVR32_PDCA_MR2_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR2_RING                                          3
#define AVR32_PDCA_MR2_RING_MASK                            0x00000008
#define AVR32_PDCA_MR2_RING_OFFSET                                   3
#define AVR32_PDCA_MR2_RING_SIZE                                     1
#define AVR32_PDCA_MR2_SIZE                                          0
#define AVR32_PDCA_MR2_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR2_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR2_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR2_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR2_SIZE_SIZE                                     2
#define AVR32_PDCA_MR2_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR3                                      0x000000d8
#define AVR32_PDCA_MR3_ETRIG                                         2
#define AVR32_PDCA_MR3_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR3_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR3_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR3_MASK                                 0x0000000f
#define AVR32_PDCA_MR3_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR3_RING                                          3
#define AVR32_PDCA_MR3_RING_MASK                            0x00000008
#define AVR32_PDCA_MR3_RING_OFFSET                                   3
#define AVR32_PDCA_MR3_RING_SIZE                                     1
#define AVR32_PDCA_MR3_SIZE                                          0
#define AVR32_PDCA_MR3_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR3_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR3_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR3_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR3_SIZE_SIZE                                     2
#define AVR32_PDCA_MR3_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR4                                      0x00000118
#define AVR32_PDCA_MR4_ETRIG                                         2
#define AVR32_PDCA_MR4_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR4_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR4_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR4_MASK                                 0x0000000f
#define AVR32_PDCA_MR4_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR4_RING                                          3
#define AVR32_PDCA_MR4_RING_MASK                            0x00000008
#define AVR32_PDCA_MR4_RING_OFFSET                                   3
#define AVR32_PDCA_MR4_RING_SIZE                                     1
#define AVR32_PDCA_MR4_SIZE                                          0
#define AVR32_PDCA_MR4_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR4_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR4_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR4_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR4_SIZE_SIZE                                     2
#define AVR32_PDCA_MR4_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR5                                      0x00000158
#define AVR32_PDCA_MR5_ETRIG                                         2
#define AVR32_PDCA_MR5_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR5_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR5_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR5_MASK                                 0x0000000f
#define AVR32_PDCA_MR5_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR5_RING                                          3
#define AVR32_PDCA_MR5_RING_MASK                            0x00000008
#define AVR32_PDCA_MR5_RING_OFFSET                                   3
#define AVR32_PDCA_MR5_RING_SIZE                                     1
#define AVR32_PDCA_MR5_SIZE                                          0
#define AVR32_PDCA_MR5_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR5_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR5_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR5_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR5_SIZE_SIZE                                     2
#define AVR32_PDCA_MR5_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR6                                      0x00000198
#define AVR32_PDCA_MR6_ETRIG                                         2
#define AVR32_PDCA_MR6_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR6_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR6_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR6_MASK                                 0x0000000f
#define AVR32_PDCA_MR6_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR6_RING                                          3
#define AVR32_PDCA_MR6_RING_MASK                            0x00000008
#define AVR32_PDCA_MR6_RING_OFFSET                                   3
#define AVR32_PDCA_MR6_RING_SIZE                                     1
#define AVR32_PDCA_MR6_SIZE                                          0
#define AVR32_PDCA_MR6_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR6_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR6_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR6_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR6_SIZE_SIZE                                     2
#define AVR32_PDCA_MR6_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR7                                      0x000001d8
#define AVR32_PDCA_MR7_ETRIG                                         2
#define AVR32_PDCA_MR7_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR7_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR7_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR7_MASK                                 0x0000000f
#define AVR32_PDCA_MR7_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR7_RING                                          3
#define AVR32_PDCA_MR7_RING_MASK                            0x00000008
#define AVR32_PDCA_MR7_RING_OFFSET                                   3
#define AVR32_PDCA_MR7_RING_SIZE                                     1
#define AVR32_PDCA_MR7_SIZE                                          0
#define AVR32_PDCA_MR7_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR7_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR7_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR7_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR7_SIZE_SIZE                                     2
#define AVR32_PDCA_MR7_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR8                                      0x00000218
#define AVR32_PDCA_MR8_ETRIG                                         2
#define AVR32_PDCA_MR8_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR8_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR8_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR8_MASK                                 0x0000000f
#define AVR32_PDCA_MR8_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR8_RING                                          3
#define AVR32_PDCA_MR8_RING_MASK                            0x00000008
#define AVR32_PDCA_MR8_RING_OFFSET                                   3
#define AVR32_PDCA_MR8_RING_SIZE                                     1
#define AVR32_PDCA_MR8_SIZE                                          0
#define AVR32_PDCA_MR8_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR8_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR8_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR8_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR8_SIZE_SIZE                                     2
#define AVR32_PDCA_MR8_SIZE_WORD                            0x00000002
#define AVR32_PDCA_MR9                                      0x00000258
#define AVR32_PDCA_MR9_ETRIG                                         2
#define AVR32_PDCA_MR9_ETRIG_MASK                           0x00000004
#define AVR32_PDCA_MR9_ETRIG_OFFSET                                  2
#define AVR32_PDCA_MR9_ETRIG_SIZE                                    1
#define AVR32_PDCA_MR9_MASK                                 0x0000000f
#define AVR32_PDCA_MR9_RESETVALUE                           0x00000000
#define AVR32_PDCA_MR9_RING                                          3
#define AVR32_PDCA_MR9_RING_MASK                            0x00000008
#define AVR32_PDCA_MR9_RING_OFFSET                                   3
#define AVR32_PDCA_MR9_RING_SIZE                                     1
#define AVR32_PDCA_MR9_SIZE                                          0
#define AVR32_PDCA_MR9_SIZE_BYTE                            0x00000000
#define AVR32_PDCA_MR9_SIZE_HALF_WORD                       0x00000001
#define AVR32_PDCA_MR9_SIZE_MASK                            0x00000003
#define AVR32_PDCA_MR9_SIZE_OFFSET                                   0
#define AVR32_PDCA_MR9_SIZE_SIZE                                     2
#define AVR32_PDCA_MR9_SIZE_WORD                            0x00000002
#define AVR32_PDCA_PCONTROL                                 0x00000800
#define AVR32_PDCA_PCONTROL_CH0EN                                    0
#define AVR32_PDCA_PCONTROL_CH0EN_MASK                      0x00000001
#define AVR32_PDCA_PCONTROL_CH0EN_OFFSET                             0
#define AVR32_PDCA_PCONTROL_CH0EN_SIZE                               1
#define AVR32_PDCA_PCONTROL_CH0OF                                    4
#define AVR32_PDCA_PCONTROL_CH0OF_MASK                      0x00000010
#define AVR32_PDCA_PCONTROL_CH0OF_OFFSET                             4
#define AVR32_PDCA_PCONTROL_CH0OF_SIZE                               1
#define AVR32_PDCA_PCONTROL_CH0RES                                   8
#define AVR32_PDCA_PCONTROL_CH0RES_MASK                     0x00000100
#define AVR32_PDCA_PCONTROL_CH0RES_OFFSET                            8
#define AVR32_PDCA_PCONTROL_CH0RES_SIZE                              1
#define AVR32_PDCA_PCONTROL_CH1EN                                    1
#define AVR32_PDCA_PCONTROL_CH1EN_MASK                      0x00000002
#define AVR32_PDCA_PCONTROL_CH1EN_OFFSET                             1
#define AVR32_PDCA_PCONTROL_CH1EN_SIZE                               1
#define AVR32_PDCA_PCONTROL_CH1OF                                    5
#define AVR32_PDCA_PCONTROL_CH1OF_MASK                      0x00000020
#define AVR32_PDCA_PCONTROL_CH1OF_OFFSET                             5
#define AVR32_PDCA_PCONTROL_CH1OF_SIZE                               1
#define AVR32_PDCA_PCONTROL_CH1RES                                   9
#define AVR32_PDCA_PCONTROL_CH1RES_MASK                     0x00000200
#define AVR32_PDCA_PCONTROL_CH1RES_OFFSET                            9
#define AVR32_PDCA_PCONTROL_CH1RES_SIZE                              1
#define AVR32_PDCA_PCONTROL_MASK                            0x3f3f0333
#define AVR32_PDCA_PCONTROL_MON0CH                                  16
#define AVR32_PDCA_PCONTROL_MON0CH_MASK                     0x003f0000
#define AVR32_PDCA_PCONTROL_MON0CH_OFFSET                           16
#define AVR32_PDCA_PCONTROL_MON0CH_SIZE                              6
#define AVR32_PDCA_PCONTROL_MON1CH                                  24
#define AVR32_PDCA_PCONTROL_MON1CH_MASK                     0x3f000000
#define AVR32_PDCA_PCONTROL_MON1CH_OFFSET                           24
#define AVR32_PDCA_PCONTROL_MON1CH_SIZE                              6
#define AVR32_PDCA_PCONTROL_RESETVALUE                      0x00000000
#define AVR32_PDCA_PID                                               0
#define AVR32_PDCA_PID_MASK                                 0x000000ff
#define AVR32_PDCA_PID_OFFSET                                        0
#define AVR32_PDCA_PID_SIZE                                          8
#define AVR32_PDCA_PRDATA0                                  0x00000804
#define AVR32_PDCA_PRDATA0_DATA                                      0
#define AVR32_PDCA_PRDATA0_DATA_MASK                        0xffffffff
#define AVR32_PDCA_PRDATA0_DATA_OFFSET                               0
#define AVR32_PDCA_PRDATA0_DATA_SIZE                                32
#define AVR32_PDCA_PRDATA0_MASK                             0xffffffff
#define AVR32_PDCA_PRDATA0_RESETVALUE                       0x00000000
#define AVR32_PDCA_PRDATA1                                  0x0000081c
#define AVR32_PDCA_PRDATA1_DATA                                      0
#define AVR32_PDCA_PRDATA1_DATA_MASK                        0xffffffff
#define AVR32_PDCA_PRDATA1_DATA_OFFSET                               0
#define AVR32_PDCA_PRDATA1_DATA_SIZE                                32
#define AVR32_PDCA_PRDATA1_MASK                             0xffffffff
#define AVR32_PDCA_PRDATA1_RESETVALUE                       0x00000000
#define AVR32_PDCA_PRLAT0                                   0x0000080c
#define AVR32_PDCA_PRLAT0_LAT                                        0
#define AVR32_PDCA_PRLAT0_LAT_MASK                          0x0000ffff
#define AVR32_PDCA_PRLAT0_LAT_OFFSET                                 0
#define AVR32_PDCA_PRLAT0_LAT_SIZE                                  16
#define AVR32_PDCA_PRLAT0_MASK                              0x0000ffff
#define AVR32_PDCA_PRLAT0_RESETVALUE                        0x00000000
#define AVR32_PDCA_PRLAT1                                   0x00000824
#define AVR32_PDCA_PRLAT1_LAT                                        0
#define AVR32_PDCA_PRLAT1_LAT_MASK                          0x0000ffff
#define AVR32_PDCA_PRLAT1_LAT_OFFSET                                 0
#define AVR32_PDCA_PRLAT1_LAT_SIZE                                  16
#define AVR32_PDCA_PRLAT1_MASK                              0x0000ffff
#define AVR32_PDCA_PRLAT1_RESETVALUE                        0x00000000
#define AVR32_PDCA_PRSTALL0                                 0x00000808
#define AVR32_PDCA_PRSTALL0_MASK                            0xffffffff
#define AVR32_PDCA_PRSTALL0_RESETVALUE                      0x00000000
#define AVR32_PDCA_PRSTALL0_STALL                                    0
#define AVR32_PDCA_PRSTALL0_STALL_MASK                      0xffffffff
#define AVR32_PDCA_PRSTALL0_STALL_OFFSET                             0
#define AVR32_PDCA_PRSTALL0_STALL_SIZE                              32
#define AVR32_PDCA_PRSTALL1                                 0x00000820
#define AVR32_PDCA_PRSTALL1_MASK                            0xffffffff
#define AVR32_PDCA_PRSTALL1_RESETVALUE                      0x00000000
#define AVR32_PDCA_PRSTALL1_STALL                                    0
#define AVR32_PDCA_PRSTALL1_STALL_MASK                      0xffffffff
#define AVR32_PDCA_PRSTALL1_STALL_OFFSET                             0
#define AVR32_PDCA_PRSTALL1_STALL_SIZE                              32
#define AVR32_PDCA_PSR0                                     0x00000004
#define AVR32_PDCA_PSR0_MASK                                0x000000ff
#define AVR32_PDCA_PSR0_PID                                          0
#define AVR32_PDCA_PSR0_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR0_PID_OFFSET                                   0
#define AVR32_PDCA_PSR0_PID_SIZE                                     8
#define AVR32_PDCA_PSR0_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR1                                     0x00000044
#define AVR32_PDCA_PSR10                                    0x00000284
#define AVR32_PDCA_PSR10_MASK                               0x000000ff
#define AVR32_PDCA_PSR10_PID                                         0
#define AVR32_PDCA_PSR10_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR10_PID_OFFSET                                  0
#define AVR32_PDCA_PSR10_PID_SIZE                                    8
#define AVR32_PDCA_PSR10_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR11                                    0x000002c4
#define AVR32_PDCA_PSR11_MASK                               0x000000ff
#define AVR32_PDCA_PSR11_PID                                         0
#define AVR32_PDCA_PSR11_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR11_PID_OFFSET                                  0
#define AVR32_PDCA_PSR11_PID_SIZE                                    8
#define AVR32_PDCA_PSR11_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR12                                    0x00000304
#define AVR32_PDCA_PSR12_MASK                               0x000000ff
#define AVR32_PDCA_PSR12_PID                                         0
#define AVR32_PDCA_PSR12_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR12_PID_OFFSET                                  0
#define AVR32_PDCA_PSR12_PID_SIZE                                    8
#define AVR32_PDCA_PSR12_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR13                                    0x00000344
#define AVR32_PDCA_PSR13_MASK                               0x000000ff
#define AVR32_PDCA_PSR13_PID                                         0
#define AVR32_PDCA_PSR13_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR13_PID_OFFSET                                  0
#define AVR32_PDCA_PSR13_PID_SIZE                                    8
#define AVR32_PDCA_PSR13_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR14                                    0x00000384
#define AVR32_PDCA_PSR14_MASK                               0x000000ff
#define AVR32_PDCA_PSR14_PID                                         0
#define AVR32_PDCA_PSR14_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR14_PID_OFFSET                                  0
#define AVR32_PDCA_PSR14_PID_SIZE                                    8
#define AVR32_PDCA_PSR14_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR15                                    0x000003c4
#define AVR32_PDCA_PSR15_MASK                               0x000000ff
#define AVR32_PDCA_PSR15_PID                                         0
#define AVR32_PDCA_PSR15_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR15_PID_OFFSET                                  0
#define AVR32_PDCA_PSR15_PID_SIZE                                    8
#define AVR32_PDCA_PSR15_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR16                                    0x00000404
#define AVR32_PDCA_PSR16_MASK                               0x000000ff
#define AVR32_PDCA_PSR16_PID                                         0
#define AVR32_PDCA_PSR16_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR16_PID_OFFSET                                  0
#define AVR32_PDCA_PSR16_PID_SIZE                                    8
#define AVR32_PDCA_PSR16_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR17                                    0x00000444
#define AVR32_PDCA_PSR17_MASK                               0x000000ff
#define AVR32_PDCA_PSR17_PID                                         0
#define AVR32_PDCA_PSR17_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR17_PID_OFFSET                                  0
#define AVR32_PDCA_PSR17_PID_SIZE                                    8
#define AVR32_PDCA_PSR17_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR18                                    0x00000484
#define AVR32_PDCA_PSR18_MASK                               0x000000ff
#define AVR32_PDCA_PSR18_PID                                         0
#define AVR32_PDCA_PSR18_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR18_PID_OFFSET                                  0
#define AVR32_PDCA_PSR18_PID_SIZE                                    8
#define AVR32_PDCA_PSR18_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR19                                    0x000004c4
#define AVR32_PDCA_PSR19_MASK                               0x000000ff
#define AVR32_PDCA_PSR19_PID                                         0
#define AVR32_PDCA_PSR19_PID_MASK                           0x000000ff
#define AVR32_PDCA_PSR19_PID_OFFSET                                  0
#define AVR32_PDCA_PSR19_PID_SIZE                                    8
#define AVR32_PDCA_PSR19_RESETVALUE                         0x00000000
#define AVR32_PDCA_PSR1_MASK                                0x000000ff
#define AVR32_PDCA_PSR1_PID                                          0
#define AVR32_PDCA_PSR1_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR1_PID_OFFSET                                   0
#define AVR32_PDCA_PSR1_PID_SIZE                                     8
#define AVR32_PDCA_PSR1_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR2                                     0x00000084
#define AVR32_PDCA_PSR2_MASK                                0x000000ff
#define AVR32_PDCA_PSR2_PID                                          0
#define AVR32_PDCA_PSR2_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR2_PID_OFFSET                                   0
#define AVR32_PDCA_PSR2_PID_SIZE                                     8
#define AVR32_PDCA_PSR2_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR3                                     0x000000c4
#define AVR32_PDCA_PSR3_MASK                                0x000000ff
#define AVR32_PDCA_PSR3_PID                                          0
#define AVR32_PDCA_PSR3_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR3_PID_OFFSET                                   0
#define AVR32_PDCA_PSR3_PID_SIZE                                     8
#define AVR32_PDCA_PSR3_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR4                                     0x00000104
#define AVR32_PDCA_PSR4_MASK                                0x000000ff
#define AVR32_PDCA_PSR4_PID                                          0
#define AVR32_PDCA_PSR4_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR4_PID_OFFSET                                   0
#define AVR32_PDCA_PSR4_PID_SIZE                                     8
#define AVR32_PDCA_PSR4_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR5                                     0x00000144
#define AVR32_PDCA_PSR5_MASK                                0x000000ff
#define AVR32_PDCA_PSR5_PID                                          0
#define AVR32_PDCA_PSR5_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR5_PID_OFFSET                                   0
#define AVR32_PDCA_PSR5_PID_SIZE                                     8
#define AVR32_PDCA_PSR5_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR6                                     0x00000184
#define AVR32_PDCA_PSR6_MASK                                0x000000ff
#define AVR32_PDCA_PSR6_PID                                          0
#define AVR32_PDCA_PSR6_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR6_PID_OFFSET                                   0
#define AVR32_PDCA_PSR6_PID_SIZE                                     8
#define AVR32_PDCA_PSR6_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR7                                     0x000001c4
#define AVR32_PDCA_PSR7_MASK                                0x000000ff
#define AVR32_PDCA_PSR7_PID                                          0
#define AVR32_PDCA_PSR7_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR7_PID_OFFSET                                   0
#define AVR32_PDCA_PSR7_PID_SIZE                                     8
#define AVR32_PDCA_PSR7_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR8                                     0x00000204
#define AVR32_PDCA_PSR8_MASK                                0x000000ff
#define AVR32_PDCA_PSR8_PID                                          0
#define AVR32_PDCA_PSR8_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR8_PID_OFFSET                                   0
#define AVR32_PDCA_PSR8_PID_SIZE                                     8
#define AVR32_PDCA_PSR8_RESETVALUE                          0x00000000
#define AVR32_PDCA_PSR9                                     0x00000244
#define AVR32_PDCA_PSR9_MASK                                0x000000ff
#define AVR32_PDCA_PSR9_PID                                          0
#define AVR32_PDCA_PSR9_PID_MASK                            0x000000ff
#define AVR32_PDCA_PSR9_PID_OFFSET                                   0
#define AVR32_PDCA_PSR9_PID_SIZE                                     8
#define AVR32_PDCA_PSR9_RESETVALUE                          0x00000000
#define AVR32_PDCA_PWDATA0                                  0x00000810
#define AVR32_PDCA_PWDATA0_DATA                                      0
#define AVR32_PDCA_PWDATA0_DATA_MASK                        0xffffffff
#define AVR32_PDCA_PWDATA0_DATA_OFFSET                               0
#define AVR32_PDCA_PWDATA0_DATA_SIZE                                32
#define AVR32_PDCA_PWDATA0_MASK                             0xffffffff
#define AVR32_PDCA_PWDATA0_RESETVALUE                       0x00000000
#define AVR32_PDCA_PWDATA1                                  0x00000828
#define AVR32_PDCA_PWDATA1_DATA                                      0
#define AVR32_PDCA_PWDATA1_DATA_MASK                        0xffffffff
#define AVR32_PDCA_PWDATA1_DATA_OFFSET                               0
#define AVR32_PDCA_PWDATA1_DATA_SIZE                                32
#define AVR32_PDCA_PWDATA1_MASK                             0xffffffff
#define AVR32_PDCA_PWDATA1_RESETVALUE                       0x00000000
#define AVR32_PDCA_PWLAT0                                   0x00000818
#define AVR32_PDCA_PWLAT0_LAT                                        0
#define AVR32_PDCA_PWLAT0_LAT_MASK                          0x0000ffff
#define AVR32_PDCA_PWLAT0_LAT_OFFSET                                 0
#define AVR32_PDCA_PWLAT0_LAT_SIZE                                  16
#define AVR32_PDCA_PWLAT0_MASK                              0x0000ffff
#define AVR32_PDCA_PWLAT0_RESETVALUE                        0x00000000
#define AVR32_PDCA_PWLAT1                                   0x00000830
#define AVR32_PDCA_PWLAT1_LAT                                        0
#define AVR32_PDCA_PWLAT1_LAT_MASK                          0x0000ffff
#define AVR32_PDCA_PWLAT1_LAT_OFFSET                                 0
#define AVR32_PDCA_PWLAT1_LAT_SIZE                                  16
#define AVR32_PDCA_PWLAT1_MASK                              0x0000ffff
#define AVR32_PDCA_PWLAT1_RESETVALUE                        0x00000000
#define AVR32_PDCA_PWSTALL0                                 0x00000814
#define AVR32_PDCA_PWSTALL0_MASK                            0xffffffff
#define AVR32_PDCA_PWSTALL0_RESETVALUE                      0x00000000
#define AVR32_PDCA_PWSTALL0_STALL                                    0
#define AVR32_PDCA_PWSTALL0_STALL_MASK                      0xffffffff
#define AVR32_PDCA_PWSTALL0_STALL_OFFSET                             0
#define AVR32_PDCA_PWSTALL0_STALL_SIZE                              32
#define AVR32_PDCA_PWSTALL1                                 0x0000082c
#define AVR32_PDCA_PWSTALL1_MASK                            0xffffffff
#define AVR32_PDCA_PWSTALL1_RESETVALUE                      0x00000000
#define AVR32_PDCA_PWSTALL1_STALL                                    0
#define AVR32_PDCA_PWSTALL1_STALL_MASK                      0xffffffff
#define AVR32_PDCA_PWSTALL1_STALL_OFFSET                             0
#define AVR32_PDCA_PWSTALL1_STALL_SIZE                              32
#define AVR32_PDCA_RCZ                                               0
#define AVR32_PDCA_RCZ_MASK                                 0x00000001
#define AVR32_PDCA_RCZ_OFFSET                                        0
#define AVR32_PDCA_RCZ_SIZE                                          1
#define AVR32_PDCA_RING                                              3
#define AVR32_PDCA_RING_MASK                                0x00000008
#define AVR32_PDCA_RING_OFFSET                                       3
#define AVR32_PDCA_RING_SIZE                                         1
#define AVR32_PDCA_SIZE                                              0
#define AVR32_PDCA_SIZE_BYTE                                0x00000000
#define AVR32_PDCA_SIZE_HALF_WORD                           0x00000001
#define AVR32_PDCA_SIZE_MASK                                0x00000003
#define AVR32_PDCA_SIZE_OFFSET                                       0
#define AVR32_PDCA_SIZE_SIZE                                         2
#define AVR32_PDCA_SIZE_WORD                                0x00000002
#define AVR32_PDCA_SR0                                      0x0000001c
#define AVR32_PDCA_SR0_MASK                                 0x00000001
#define AVR32_PDCA_SR0_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR0_TEN                                           0
#define AVR32_PDCA_SR0_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR0_TEN_OFFSET                                    0
#define AVR32_PDCA_SR0_TEN_SIZE                                      1
#define AVR32_PDCA_SR1                                      0x0000005c
#define AVR32_PDCA_SR10                                     0x0000029c
#define AVR32_PDCA_SR10_MASK                                0x00000001
#define AVR32_PDCA_SR10_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR10_TEN                                          0
#define AVR32_PDCA_SR10_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR10_TEN_OFFSET                                   0
#define AVR32_PDCA_SR10_TEN_SIZE                                     1
#define AVR32_PDCA_SR11                                     0x000002dc
#define AVR32_PDCA_SR11_MASK                                0x00000001
#define AVR32_PDCA_SR11_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR11_TEN                                          0
#define AVR32_PDCA_SR11_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR11_TEN_OFFSET                                   0
#define AVR32_PDCA_SR11_TEN_SIZE                                     1
#define AVR32_PDCA_SR12                                     0x0000031c
#define AVR32_PDCA_SR12_MASK                                0x00000001
#define AVR32_PDCA_SR12_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR12_TEN                                          0
#define AVR32_PDCA_SR12_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR12_TEN_OFFSET                                   0
#define AVR32_PDCA_SR12_TEN_SIZE                                     1
#define AVR32_PDCA_SR13                                     0x0000035c
#define AVR32_PDCA_SR13_MASK                                0x00000001
#define AVR32_PDCA_SR13_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR13_TEN                                          0
#define AVR32_PDCA_SR13_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR13_TEN_OFFSET                                   0
#define AVR32_PDCA_SR13_TEN_SIZE                                     1
#define AVR32_PDCA_SR14                                     0x0000039c
#define AVR32_PDCA_SR14_MASK                                0x00000001
#define AVR32_PDCA_SR14_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR14_TEN                                          0
#define AVR32_PDCA_SR14_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR14_TEN_OFFSET                                   0
#define AVR32_PDCA_SR14_TEN_SIZE                                     1
#define AVR32_PDCA_SR15                                     0x000003dc
#define AVR32_PDCA_SR15_MASK                                0x00000001
#define AVR32_PDCA_SR15_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR15_TEN                                          0
#define AVR32_PDCA_SR15_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR15_TEN_OFFSET                                   0
#define AVR32_PDCA_SR15_TEN_SIZE                                     1
#define AVR32_PDCA_SR16                                     0x0000041c
#define AVR32_PDCA_SR16_MASK                                0x00000001
#define AVR32_PDCA_SR16_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR16_TEN                                          0
#define AVR32_PDCA_SR16_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR16_TEN_OFFSET                                   0
#define AVR32_PDCA_SR16_TEN_SIZE                                     1
#define AVR32_PDCA_SR17                                     0x0000045c
#define AVR32_PDCA_SR17_MASK                                0x00000001
#define AVR32_PDCA_SR17_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR17_TEN                                          0
#define AVR32_PDCA_SR17_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR17_TEN_OFFSET                                   0
#define AVR32_PDCA_SR17_TEN_SIZE                                     1
#define AVR32_PDCA_SR18                                     0x0000049c
#define AVR32_PDCA_SR18_MASK                                0x00000001
#define AVR32_PDCA_SR18_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR18_TEN                                          0
#define AVR32_PDCA_SR18_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR18_TEN_OFFSET                                   0
#define AVR32_PDCA_SR18_TEN_SIZE                                     1
#define AVR32_PDCA_SR19                                     0x000004dc
#define AVR32_PDCA_SR19_MASK                                0x00000001
#define AVR32_PDCA_SR19_RESETVALUE                          0x00000000
#define AVR32_PDCA_SR19_TEN                                          0
#define AVR32_PDCA_SR19_TEN_MASK                            0x00000001
#define AVR32_PDCA_SR19_TEN_OFFSET                                   0
#define AVR32_PDCA_SR19_TEN_SIZE                                     1
#define AVR32_PDCA_SR1_MASK                                 0x00000001
#define AVR32_PDCA_SR1_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR1_TEN                                           0
#define AVR32_PDCA_SR1_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR1_TEN_OFFSET                                    0
#define AVR32_PDCA_SR1_TEN_SIZE                                      1
#define AVR32_PDCA_SR2                                      0x0000009c
#define AVR32_PDCA_SR2_MASK                                 0x00000001
#define AVR32_PDCA_SR2_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR2_TEN                                           0
#define AVR32_PDCA_SR2_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR2_TEN_OFFSET                                    0
#define AVR32_PDCA_SR2_TEN_SIZE                                      1
#define AVR32_PDCA_SR3                                      0x000000dc
#define AVR32_PDCA_SR3_MASK                                 0x00000001
#define AVR32_PDCA_SR3_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR3_TEN                                           0
#define AVR32_PDCA_SR3_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR3_TEN_OFFSET                                    0
#define AVR32_PDCA_SR3_TEN_SIZE                                      1
#define AVR32_PDCA_SR4                                      0x0000011c
#define AVR32_PDCA_SR4_MASK                                 0x00000001
#define AVR32_PDCA_SR4_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR4_TEN                                           0
#define AVR32_PDCA_SR4_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR4_TEN_OFFSET                                    0
#define AVR32_PDCA_SR4_TEN_SIZE                                      1
#define AVR32_PDCA_SR5                                      0x0000015c
#define AVR32_PDCA_SR5_MASK                                 0x00000001
#define AVR32_PDCA_SR5_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR5_TEN                                           0
#define AVR32_PDCA_SR5_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR5_TEN_OFFSET                                    0
#define AVR32_PDCA_SR5_TEN_SIZE                                      1
#define AVR32_PDCA_SR6                                      0x0000019c
#define AVR32_PDCA_SR6_MASK                                 0x00000001
#define AVR32_PDCA_SR6_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR6_TEN                                           0
#define AVR32_PDCA_SR6_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR6_TEN_OFFSET                                    0
#define AVR32_PDCA_SR6_TEN_SIZE                                      1
#define AVR32_PDCA_SR7                                      0x000001dc
#define AVR32_PDCA_SR7_MASK                                 0x00000001
#define AVR32_PDCA_SR7_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR7_TEN                                           0
#define AVR32_PDCA_SR7_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR7_TEN_OFFSET                                    0
#define AVR32_PDCA_SR7_TEN_SIZE                                      1
#define AVR32_PDCA_SR8                                      0x0000021c
#define AVR32_PDCA_SR8_MASK                                 0x00000001
#define AVR32_PDCA_SR8_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR8_TEN                                           0
#define AVR32_PDCA_SR8_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR8_TEN_OFFSET                                    0
#define AVR32_PDCA_SR8_TEN_SIZE                                      1
#define AVR32_PDCA_SR9                                      0x0000025c
#define AVR32_PDCA_SR9_MASK                                 0x00000001
#define AVR32_PDCA_SR9_RESETVALUE                           0x00000000
#define AVR32_PDCA_SR9_TEN                                           0
#define AVR32_PDCA_SR9_TEN_MASK                             0x00000001
#define AVR32_PDCA_SR9_TEN_OFFSET                                    0
#define AVR32_PDCA_SR9_TEN_SIZE                                      1
#define AVR32_PDCA_STALL                                             0
#define AVR32_PDCA_STALL_MASK                               0xffffffff
#define AVR32_PDCA_STALL_OFFSET                                      0
#define AVR32_PDCA_STALL_SIZE                                       32
#define AVR32_PDCA_TCR0                                     0x00000008
#define AVR32_PDCA_TCR0_MASK                                0x0000ffff
#define AVR32_PDCA_TCR0_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR0_TCV                                          0
#define AVR32_PDCA_TCR0_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR0_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR0_TCV_SIZE                                    16
#define AVR32_PDCA_TCR1                                     0x00000048
#define AVR32_PDCA_TCR10                                    0x00000288
#define AVR32_PDCA_TCR10_MASK                               0x0000ffff
#define AVR32_PDCA_TCR10_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR10_TCV                                         0
#define AVR32_PDCA_TCR10_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR10_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR10_TCV_SIZE                                   16
#define AVR32_PDCA_TCR11                                    0x000002c8
#define AVR32_PDCA_TCR11_MASK                               0x0000ffff
#define AVR32_PDCA_TCR11_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR11_TCV                                         0
#define AVR32_PDCA_TCR11_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR11_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR11_TCV_SIZE                                   16
#define AVR32_PDCA_TCR12                                    0x00000308
#define AVR32_PDCA_TCR12_MASK                               0x0000ffff
#define AVR32_PDCA_TCR12_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR12_TCV                                         0
#define AVR32_PDCA_TCR12_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR12_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR12_TCV_SIZE                                   16
#define AVR32_PDCA_TCR13                                    0x00000348
#define AVR32_PDCA_TCR13_MASK                               0x0000ffff
#define AVR32_PDCA_TCR13_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR13_TCV                                         0
#define AVR32_PDCA_TCR13_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR13_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR13_TCV_SIZE                                   16
#define AVR32_PDCA_TCR14                                    0x00000388
#define AVR32_PDCA_TCR14_MASK                               0x0000ffff
#define AVR32_PDCA_TCR14_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR14_TCV                                         0
#define AVR32_PDCA_TCR14_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR14_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR14_TCV_SIZE                                   16
#define AVR32_PDCA_TCR15                                    0x000003c8
#define AVR32_PDCA_TCR15_MASK                               0x0000ffff
#define AVR32_PDCA_TCR15_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR15_TCV                                         0
#define AVR32_PDCA_TCR15_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR15_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR15_TCV_SIZE                                   16
#define AVR32_PDCA_TCR16                                    0x00000408
#define AVR32_PDCA_TCR16_MASK                               0x0000ffff
#define AVR32_PDCA_TCR16_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR16_TCV                                         0
#define AVR32_PDCA_TCR16_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR16_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR16_TCV_SIZE                                   16
#define AVR32_PDCA_TCR17                                    0x00000448
#define AVR32_PDCA_TCR17_MASK                               0x0000ffff
#define AVR32_PDCA_TCR17_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR17_TCV                                         0
#define AVR32_PDCA_TCR17_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR17_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR17_TCV_SIZE                                   16
#define AVR32_PDCA_TCR18                                    0x00000488
#define AVR32_PDCA_TCR18_MASK                               0x0000ffff
#define AVR32_PDCA_TCR18_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR18_TCV                                         0
#define AVR32_PDCA_TCR18_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR18_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR18_TCV_SIZE                                   16
#define AVR32_PDCA_TCR19                                    0x000004c8
#define AVR32_PDCA_TCR19_MASK                               0x0000ffff
#define AVR32_PDCA_TCR19_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCR19_TCV                                         0
#define AVR32_PDCA_TCR19_TCV_MASK                           0x0000ffff
#define AVR32_PDCA_TCR19_TCV_OFFSET                                  0
#define AVR32_PDCA_TCR19_TCV_SIZE                                   16
#define AVR32_PDCA_TCR1_MASK                                0x0000ffff
#define AVR32_PDCA_TCR1_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR1_TCV                                          0
#define AVR32_PDCA_TCR1_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR1_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR1_TCV_SIZE                                    16
#define AVR32_PDCA_TCR2                                     0x00000088
#define AVR32_PDCA_TCR2_MASK                                0x0000ffff
#define AVR32_PDCA_TCR2_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR2_TCV                                          0
#define AVR32_PDCA_TCR2_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR2_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR2_TCV_SIZE                                    16
#define AVR32_PDCA_TCR3                                     0x000000c8
#define AVR32_PDCA_TCR3_MASK                                0x0000ffff
#define AVR32_PDCA_TCR3_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR3_TCV                                          0
#define AVR32_PDCA_TCR3_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR3_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR3_TCV_SIZE                                    16
#define AVR32_PDCA_TCR4                                     0x00000108
#define AVR32_PDCA_TCR4_MASK                                0x0000ffff
#define AVR32_PDCA_TCR4_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR4_TCV                                          0
#define AVR32_PDCA_TCR4_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR4_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR4_TCV_SIZE                                    16
#define AVR32_PDCA_TCR5                                     0x00000148
#define AVR32_PDCA_TCR5_MASK                                0x0000ffff
#define AVR32_PDCA_TCR5_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR5_TCV                                          0
#define AVR32_PDCA_TCR5_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR5_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR5_TCV_SIZE                                    16
#define AVR32_PDCA_TCR6                                     0x00000188
#define AVR32_PDCA_TCR6_MASK                                0x0000ffff
#define AVR32_PDCA_TCR6_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR6_TCV                                          0
#define AVR32_PDCA_TCR6_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR6_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR6_TCV_SIZE                                    16
#define AVR32_PDCA_TCR7                                     0x000001c8
#define AVR32_PDCA_TCR7_MASK                                0x0000ffff
#define AVR32_PDCA_TCR7_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR7_TCV                                          0
#define AVR32_PDCA_TCR7_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR7_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR7_TCV_SIZE                                    16
#define AVR32_PDCA_TCR8                                     0x00000208
#define AVR32_PDCA_TCR8_MASK                                0x0000ffff
#define AVR32_PDCA_TCR8_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR8_TCV                                          0
#define AVR32_PDCA_TCR8_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR8_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR8_TCV_SIZE                                    16
#define AVR32_PDCA_TCR9                                     0x00000248
#define AVR32_PDCA_TCR9_MASK                                0x0000ffff
#define AVR32_PDCA_TCR9_RESETVALUE                          0x00000000
#define AVR32_PDCA_TCR9_TCV                                          0
#define AVR32_PDCA_TCR9_TCV_MASK                            0x0000ffff
#define AVR32_PDCA_TCR9_TCV_OFFSET                                   0
#define AVR32_PDCA_TCR9_TCV_SIZE                                    16
#define AVR32_PDCA_TCRR0                                    0x00000010
#define AVR32_PDCA_TCRR0_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR0_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR0_TCRV                                        0
#define AVR32_PDCA_TCRR0_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR0_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR0_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR1                                    0x00000050
#define AVR32_PDCA_TCRR10                                   0x00000290
#define AVR32_PDCA_TCRR10_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR10_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR10_TCRV                                       0
#define AVR32_PDCA_TCRR10_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR10_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR10_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR11                                   0x000002d0
#define AVR32_PDCA_TCRR11_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR11_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR11_TCRV                                       0
#define AVR32_PDCA_TCRR11_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR11_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR11_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR12                                   0x00000310
#define AVR32_PDCA_TCRR12_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR12_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR12_TCRV                                       0
#define AVR32_PDCA_TCRR12_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR12_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR12_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR13                                   0x00000350
#define AVR32_PDCA_TCRR13_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR13_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR13_TCRV                                       0
#define AVR32_PDCA_TCRR13_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR13_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR13_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR14                                   0x00000390
#define AVR32_PDCA_TCRR14_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR14_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR14_TCRV                                       0
#define AVR32_PDCA_TCRR14_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR14_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR14_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR15                                   0x000003d0
#define AVR32_PDCA_TCRR15_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR15_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR15_TCRV                                       0
#define AVR32_PDCA_TCRR15_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR15_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR15_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR16                                   0x00000410
#define AVR32_PDCA_TCRR16_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR16_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR16_TCRV                                       0
#define AVR32_PDCA_TCRR16_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR16_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR16_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR17                                   0x00000450
#define AVR32_PDCA_TCRR17_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR17_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR17_TCRV                                       0
#define AVR32_PDCA_TCRR17_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR17_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR17_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR18                                   0x00000490
#define AVR32_PDCA_TCRR18_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR18_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR18_TCRV                                       0
#define AVR32_PDCA_TCRR18_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR18_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR18_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR19                                   0x000004d0
#define AVR32_PDCA_TCRR19_MASK                              0x0000ffff
#define AVR32_PDCA_TCRR19_RESETVALUE                        0x00000000
#define AVR32_PDCA_TCRR19_TCRV                                       0
#define AVR32_PDCA_TCRR19_TCRV_MASK                         0x0000ffff
#define AVR32_PDCA_TCRR19_TCRV_OFFSET                                0
#define AVR32_PDCA_TCRR19_TCRV_SIZE                                 16
#define AVR32_PDCA_TCRR1_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR1_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR1_TCRV                                        0
#define AVR32_PDCA_TCRR1_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR1_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR1_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR2                                    0x00000090
#define AVR32_PDCA_TCRR2_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR2_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR2_TCRV                                        0
#define AVR32_PDCA_TCRR2_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR2_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR2_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR3                                    0x000000d0
#define AVR32_PDCA_TCRR3_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR3_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR3_TCRV                                        0
#define AVR32_PDCA_TCRR3_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR3_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR3_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR4                                    0x00000110
#define AVR32_PDCA_TCRR4_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR4_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR4_TCRV                                        0
#define AVR32_PDCA_TCRR4_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR4_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR4_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR5                                    0x00000150
#define AVR32_PDCA_TCRR5_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR5_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR5_TCRV                                        0
#define AVR32_PDCA_TCRR5_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR5_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR5_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR6                                    0x00000190
#define AVR32_PDCA_TCRR6_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR6_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR6_TCRV                                        0
#define AVR32_PDCA_TCRR6_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR6_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR6_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR7                                    0x000001d0
#define AVR32_PDCA_TCRR7_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR7_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR7_TCRV                                        0
#define AVR32_PDCA_TCRR7_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR7_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR7_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR8                                    0x00000210
#define AVR32_PDCA_TCRR8_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR8_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR8_TCRV                                        0
#define AVR32_PDCA_TCRR8_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR8_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR8_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRR9                                    0x00000250
#define AVR32_PDCA_TCRR9_MASK                               0x0000ffff
#define AVR32_PDCA_TCRR9_RESETVALUE                         0x00000000
#define AVR32_PDCA_TCRR9_TCRV                                        0
#define AVR32_PDCA_TCRR9_TCRV_MASK                          0x0000ffff
#define AVR32_PDCA_TCRR9_TCRV_OFFSET                                 0
#define AVR32_PDCA_TCRR9_TCRV_SIZE                                  16
#define AVR32_PDCA_TCRV                                              0
#define AVR32_PDCA_TCRV_MASK                                0x0000ffff
#define AVR32_PDCA_TCRV_OFFSET                                       0
#define AVR32_PDCA_TCRV_SIZE                                        16
#define AVR32_PDCA_TCV                                               0
#define AVR32_PDCA_TCV_MASK                                 0x0000ffff
#define AVR32_PDCA_TCV_OFFSET                                        0
#define AVR32_PDCA_TCV_SIZE                                         16
#define AVR32_PDCA_TDIS                                              1
#define AVR32_PDCA_TDIS_MASK                                0x00000002
#define AVR32_PDCA_TDIS_OFFSET                                       1
#define AVR32_PDCA_TDIS_SIZE                                         1
#define AVR32_PDCA_TEN                                               0
#define AVR32_PDCA_TEN_MASK                                 0x00000001
#define AVR32_PDCA_TEN_OFFSET                                        0
#define AVR32_PDCA_TEN_SIZE                                          1
#define AVR32_PDCA_TERR                                              2
#define AVR32_PDCA_TERR_MASK                                0x00000004
#define AVR32_PDCA_TERR_OFFSET                                       2
#define AVR32_PDCA_TERR_SIZE                                         1
#define AVR32_PDCA_TRC                                               1
#define AVR32_PDCA_TRC_MASK                                 0x00000002
#define AVR32_PDCA_TRC_OFFSET                                        1
#define AVR32_PDCA_TRC_SIZE                                          1
#define AVR32_PDCA_VERSION                                  0x00000834
#define AVR32_PDCA_VERSION_MASK                             0x00000000
#define AVR32_PDCA_VERSION_RESETVALUE                       0x00000120
#define AVR32_PDCA_WORD                                     0x00000002




#ifdef __AVR32_ABI_COMPILER__


typedef struct avr32_pdca_psr_t {
    unsigned int                 :24;
    unsigned int pid             : 8;
} avr32_pdca_psr_t;



typedef struct avr32_pdca_tcr_t {
    unsigned int                 :16;
    unsigned int tcv             :16;
} avr32_pdca_tcr_t;



typedef struct avr32_pdca_tcrr_t {
    unsigned int                 :16;
    unsigned int tcrv            :16;
} avr32_pdca_tcrr_t;



typedef struct avr32_pdca_cr_t {
    unsigned int                 :23;
    unsigned int eclr            : 1;
    unsigned int                 : 6;
    unsigned int tdis            : 1;
    unsigned int ten             : 1;
} avr32_pdca_cr_t;



typedef struct avr32_pdca_mr_t {
    unsigned int                 :28;
    unsigned int ring            : 1;
    unsigned int etrig           : 1;
    unsigned int size            : 2;
} avr32_pdca_mr_t;



typedef struct avr32_pdca_sr_t {
    unsigned int                 :31;
    unsigned int ten             : 1;
} avr32_pdca_sr_t;



typedef struct avr32_pdca_ier_t {
    unsigned int                 :29;
    unsigned int terr            : 1;
    unsigned int trc             : 1;
    unsigned int rcz             : 1;
} avr32_pdca_ier_t;



typedef struct avr32_pdca_idr_t {
    unsigned int                 :29;
    unsigned int terr            : 1;
    unsigned int trc             : 1;
    unsigned int rcz             : 1;
} avr32_pdca_idr_t;



typedef struct avr32_pdca_imr_t {
    unsigned int                 :29;
    unsigned int terr            : 1;
    unsigned int trc             : 1;
    unsigned int rcz             : 1;
} avr32_pdca_imr_t;



typedef struct avr32_pdca_isr_t {
    unsigned int                 :29;
    unsigned int terr            : 1;
    unsigned int trc             : 1;
    unsigned int rcz             : 1;
} avr32_pdca_isr_t;



typedef struct avr32_pdca_pcontrol_t {
    unsigned int                 : 2;
    unsigned int mon1ch          : 6;
    unsigned int                 : 2;
    unsigned int mon0ch          : 6;
    unsigned int                 : 6;
    unsigned int ch1res          : 1;
    unsigned int ch0res          : 1;
    unsigned int                 : 2;
    unsigned int ch1of           : 1;
    unsigned int ch0of           : 1;
    unsigned int                 : 2;
    unsigned int ch1en           : 1;
    unsigned int ch0en           : 1;
} avr32_pdca_pcontrol_t;



typedef struct avr32_pdca_prlat0_t {
    unsigned int                 :16;
    unsigned int lat             :16;
} avr32_pdca_prlat0_t;



typedef struct avr32_pdca_pwlat0_t {
    unsigned int                 :16;
    unsigned int lat             :16;
} avr32_pdca_pwlat0_t;



typedef struct avr32_pdca_prlat1_t {
    unsigned int                 :16;
    unsigned int lat             :16;
} avr32_pdca_prlat1_t;



typedef struct avr32_pdca_pwlat1_t {
    unsigned int                 :16;
    unsigned int lat             :16;
} avr32_pdca_pwlat1_t;


typedef struct avr32_pdca_channel_t {
          unsigned long                  mar       ;//0x0000
  union {
          unsigned long                  psr       ;//0x0004
          avr32_pdca_psr_t               PSR       ;
  };
  union {
          unsigned long                  tcr       ;//0x0008
          avr32_pdca_tcr_t               TCR       ;
  };
          unsigned long                  marr      ;//0x000c
  union {
          unsigned long                  tcrr      ;//0x0010
          avr32_pdca_tcrr_t              TCRR      ;
  };
  union {
          unsigned long                  cr        ;//0x0014
          avr32_pdca_cr_t                CR        ;
  };
  union {
          unsigned long                  mr        ;//0x0018
          avr32_pdca_mr_t                MR        ;
  };
  union {
    const unsigned long                  sr        ;//0x001c
    const avr32_pdca_sr_t                SR        ;
  };
  union {
          unsigned long                  ier       ;//0x0020
          avr32_pdca_ier_t               IER       ;
  };
  union {
          unsigned long                  idr       ;//0x0024
          avr32_pdca_idr_t               IDR       ;
  };
  union {
    const unsigned long                  imr       ;//0x0028
    const avr32_pdca_imr_t               IMR       ;
  };
  union {
    const unsigned long                  isr       ;//0x002c
    const avr32_pdca_isr_t               ISR       ;
  };
          unsigned int                   :32       ;//0x0030
          unsigned int                   :32       ;//0x0034
          unsigned int                   :32       ;//0x0038
          unsigned int                   :32       ;//0x003c
} avr32_pdca_channel_t;


typedef struct avr32_pdca_t {
  avr32_pdca_channel_t channel[AVR32_PDCA_CHANNEL_LENGTH];//0x0
  avr32_pdca_channel_t channel_reserved[32 - AVR32_PDCA_CHANNEL_LENGTH];//Padding
  union {
          unsigned long                  pcontrol  ;//0x0800
          avr32_pdca_pcontrol_t          PCONTROL  ;
  };
    const unsigned long                  prdata0   ;//0x0804
    const unsigned long                  prstall0  ;//0x0808
  union {
    const unsigned long                  prlat0    ;//0x080c
    const avr32_pdca_prlat0_t            PRLAT0    ;
  };
    const unsigned long                  pwdata0   ;//0x0810
    const unsigned long                  pwstall0  ;//0x0814
  union {
    const unsigned long                  pwlat0    ;//0x0818
    const avr32_pdca_pwlat0_t            PWLAT0    ;
  };
    const unsigned long                  prdata1   ;//0x081c
    const unsigned long                  prstall1  ;//0x0820
  union {
    const unsigned long                  prlat1    ;//0x0824
    const avr32_pdca_prlat1_t            PRLAT1    ;
  };
    const unsigned long                  pwdata1   ;//0x0828
    const unsigned long                  pwstall1  ;//0x082c
  union {
    const unsigned long                  pwlat1    ;//0x0830
    const avr32_pdca_pwlat1_t            PWLAT1    ;
  };
    const unsigned long                  version   ;//0x0834
} avr32_pdca_t;



#if !defined (DEPRECATED_DISABLE)

#define AVR32_PDCA_CR0                                      0x00000014
#define AVR32_PDCA_CR0_ECLR                                          8
#define AVR32_PDCA_CR0_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR0_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR0_ECLR_SIZE                                     1
#define AVR32_PDCA_CR0_MASK                                 0x00000103
#define AVR32_PDCA_CR0_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR0_TDIS                                          1
#define AVR32_PDCA_CR0_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR0_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR0_TDIS_SIZE                                     1
#define AVR32_PDCA_CR0_TEN                                           0
#define AVR32_PDCA_CR0_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR0_TEN_OFFSET                                    0
#define AVR32_PDCA_CR0_TEN_SIZE                                      1
#define AVR32_PDCA_CR1                                      0x00000054
#define AVR32_PDCA_CR10                                     0x00000294
#define AVR32_PDCA_CR10_ECLR                                         8
#define AVR32_PDCA_CR10_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR10_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR10_ECLR_SIZE                                    1
#define AVR32_PDCA_CR10_MASK                                0x00000103
#define AVR32_PDCA_CR10_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR10_TDIS                                         1
#define AVR32_PDCA_CR10_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR10_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR10_TDIS_SIZE                                    1
#define AVR32_PDCA_CR10_TEN                                          0
#define AVR32_PDCA_CR10_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR10_TEN_OFFSET                                   0
#define AVR32_PDCA_CR10_TEN_SIZE                                     1
#define AVR32_PDCA_CR11                                     0x000002d4
#define AVR32_PDCA_CR11_ECLR                                         8
#define AVR32_PDCA_CR11_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR11_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR11_ECLR_SIZE                                    1
#define AVR32_PDCA_CR11_MASK                                0x00000103
#define AVR32_PDCA_CR11_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR11_TDIS                                         1
#define AVR32_PDCA_CR11_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR11_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR11_TDIS_SIZE                                    1
#define AVR32_PDCA_CR11_TEN                                          0
#define AVR32_PDCA_CR11_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR11_TEN_OFFSET                                   0
#define AVR32_PDCA_CR11_TEN_SIZE                                     1
#define AVR32_PDCA_CR12                                     0x00000314
#define AVR32_PDCA_CR12_ECLR                                         8
#define AVR32_PDCA_CR12_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR12_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR12_ECLR_SIZE                                    1
#define AVR32_PDCA_CR12_MASK                                0x00000103
#define AVR32_PDCA_CR12_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR12_TDIS                                         1
#define AVR32_PDCA_CR12_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR12_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR12_TDIS_SIZE                                    1
#define AVR32_PDCA_CR12_TEN                                          0
#define AVR32_PDCA_CR12_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR12_TEN_OFFSET                                   0
#define AVR32_PDCA_CR12_TEN_SIZE                                     1
#define AVR32_PDCA_CR13                                     0x00000354
#define AVR32_PDCA_CR13_ECLR                                         8
#define AVR32_PDCA_CR13_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR13_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR13_ECLR_SIZE                                    1
#define AVR32_PDCA_CR13_MASK                                0x00000103
#define AVR32_PDCA_CR13_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR13_TDIS                                         1
#define AVR32_PDCA_CR13_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR13_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR13_TDIS_SIZE                                    1
#define AVR32_PDCA_CR13_TEN                                          0
#define AVR32_PDCA_CR13_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR13_TEN_OFFSET                                   0
#define AVR32_PDCA_CR13_TEN_SIZE                                     1
#define AVR32_PDCA_CR14                                     0x00000394
#define AVR32_PDCA_CR14_ECLR                                         8
#define AVR32_PDCA_CR14_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR14_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR14_ECLR_SIZE                                    1
#define AVR32_PDCA_CR14_MASK                                0x00000103
#define AVR32_PDCA_CR14_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR14_TDIS                                         1
#define AVR32_PDCA_CR14_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR14_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR14_TDIS_SIZE                                    1
#define AVR32_PDCA_CR14_TEN                                          0
#define AVR32_PDCA_CR14_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR14_TEN_OFFSET                                   0
#define AVR32_PDCA_CR14_TEN_SIZE                                     1
#define AVR32_PDCA_CR15                                     0x000003d4
#define AVR32_PDCA_CR15_ECLR                                         8
#define AVR32_PDCA_CR15_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR15_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR15_ECLR_SIZE                                    1
#define AVR32_PDCA_CR15_MASK                                0x00000103
#define AVR32_PDCA_CR15_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR15_TDIS                                         1
#define AVR32_PDCA_CR15_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR15_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR15_TDIS_SIZE                                    1
#define AVR32_PDCA_CR15_TEN                                          0
#define AVR32_PDCA_CR15_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR15_TEN_OFFSET                                   0
#define AVR32_PDCA_CR15_TEN_SIZE                                     1
#define AVR32_PDCA_CR16                                     0x00000414
#define AVR32_PDCA_CR16_ECLR                                         8
#define AVR32_PDCA_CR16_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR16_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR16_ECLR_SIZE                                    1
#define AVR32_PDCA_CR16_MASK                                0x00000103
#define AVR32_PDCA_CR16_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR16_TDIS                                         1
#define AVR32_PDCA_CR16_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR16_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR16_TDIS_SIZE                                    1
#define AVR32_PDCA_CR16_TEN                                          0
#define AVR32_PDCA_CR16_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR16_TEN_OFFSET                                   0
#define AVR32_PDCA_CR16_TEN_SIZE                                     1
#define AVR32_PDCA_CR17                                     0x00000454
#define AVR32_PDCA_CR17_ECLR                                         8
#define AVR32_PDCA_CR17_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR17_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR17_ECLR_SIZE                                    1
#define AVR32_PDCA_CR17_MASK                                0x00000103
#define AVR32_PDCA_CR17_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR17_TDIS                                         1
#define AVR32_PDCA_CR17_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR17_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR17_TDIS_SIZE                                    1
#define AVR32_PDCA_CR17_TEN                                          0
#define AVR32_PDCA_CR17_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR17_TEN_OFFSET                                   0
#define AVR32_PDCA_CR17_TEN_SIZE                                     1
#define AVR32_PDCA_CR18                                     0x00000494
#define AVR32_PDCA_CR18_ECLR                                         8
#define AVR32_PDCA_CR18_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR18_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR18_ECLR_SIZE                                    1
#define AVR32_PDCA_CR18_MASK                                0x00000103
#define AVR32_PDCA_CR18_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR18_TDIS                                         1
#define AVR32_PDCA_CR18_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR18_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR18_TDIS_SIZE                                    1
#define AVR32_PDCA_CR18_TEN                                          0
#define AVR32_PDCA_CR18_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR18_TEN_OFFSET                                   0
#define AVR32_PDCA_CR18_TEN_SIZE                                     1
#define AVR32_PDCA_CR19                                     0x000004d4
#define AVR32_PDCA_CR19_ECLR                                         8
#define AVR32_PDCA_CR19_ECLR_MASK                           0x00000100
#define AVR32_PDCA_CR19_ECLR_OFFSET                                  8
#define AVR32_PDCA_CR19_ECLR_SIZE                                    1
#define AVR32_PDCA_CR19_MASK                                0x00000103
#define AVR32_PDCA_CR19_RESETVALUE                          0x00000000
#define AVR32_PDCA_CR19_TDIS                                         1
#define AVR32_PDCA_CR19_TDIS_MASK                           0x00000002
#define AVR32_PDCA_CR19_TDIS_OFFSET                                  1
#define AVR32_PDCA_CR19_TDIS_SIZE                                    1
#define AVR32_PDCA_CR19_TEN                                          0
#define AVR32_PDCA_CR19_TEN_MASK                            0x00000001
#define AVR32_PDCA_CR19_TEN_OFFSET                                   0
#define AVR32_PDCA_CR19_TEN_SIZE                                     1
#define AVR32_PDCA_CR1_ECLR                                          8
#define AVR32_PDCA_CR1_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR1_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR1_ECLR_SIZE                                     1
#define AVR32_PDCA_CR1_MASK                                 0x00000103
#define AVR32_PDCA_CR1_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR1_TDIS                                          1
#define AVR32_PDCA_CR1_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR1_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR1_TDIS_SIZE                                     1
#define AVR32_PDCA_CR1_TEN                                           0
#define AVR32_PDCA_CR1_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR1_TEN_OFFSET                                    0
#define AVR32_PDCA_CR1_TEN_SIZE                                      1
#define AVR32_PDCA_CR2                                      0x00000094
#define AVR32_PDCA_CR2_ECLR                                          8
#define AVR32_PDCA_CR2_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR2_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR2_ECLR_SIZE                                     1
#define AVR32_PDCA_CR2_MASK                                 0x00000103
#define AVR32_PDCA_CR2_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR2_TDIS                                          1
#define AVR32_PDCA_CR2_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR2_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR2_TDIS_SIZE                                     1
#define AVR32_PDCA_CR2_TEN                                           0
#define AVR32_PDCA_CR2_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR2_TEN_OFFSET                                    0
#define AVR32_PDCA_CR2_TEN_SIZE                                      1
#define AVR32_PDCA_CR3                                      0x000000d4
#define AVR32_PDCA_CR3_ECLR                                          8
#define AVR32_PDCA_CR3_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR3_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR3_ECLR_SIZE                                     1
#define AVR32_PDCA_CR3_MASK                                 0x00000103
#define AVR32_PDCA_CR3_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR3_TDIS                                          1
#define AVR32_PDCA_CR3_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR3_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR3_TDIS_SIZE                                     1
#define AVR32_PDCA_CR3_TEN                                           0
#define AVR32_PDCA_CR3_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR3_TEN_OFFSET                                    0
#define AVR32_PDCA_CR3_TEN_SIZE                                      1
#define AVR32_PDCA_CR4                                      0x00000114
#define AVR32_PDCA_CR4_ECLR                                          8
#define AVR32_PDCA_CR4_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR4_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR4_ECLR_SIZE                                     1
#define AVR32_PDCA_CR4_MASK                                 0x00000103
#define AVR32_PDCA_CR4_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR4_TDIS                                          1
#define AVR32_PDCA_CR4_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR4_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR4_TDIS_SIZE                                     1
#define AVR32_PDCA_CR4_TEN                                           0
#define AVR32_PDCA_CR4_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR4_TEN_OFFSET                                    0
#define AVR32_PDCA_CR4_TEN_SIZE                                      1
#define AVR32_PDCA_CR5                                      0x00000154
#define AVR32_PDCA_CR5_ECLR                                          8
#define AVR32_PDCA_CR5_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR5_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR5_ECLR_SIZE                                     1
#define AVR32_PDCA_CR5_MASK                                 0x00000103
#define AVR32_PDCA_CR5_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR5_TDIS                                          1
#define AVR32_PDCA_CR5_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR5_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR5_TDIS_SIZE                                     1
#define AVR32_PDCA_CR5_TEN                                           0
#define AVR32_PDCA_CR5_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR5_TEN_OFFSET                                    0
#define AVR32_PDCA_CR5_TEN_SIZE                                      1
#define AVR32_PDCA_CR6                                      0x00000194
#define AVR32_PDCA_CR6_ECLR                                          8
#define AVR32_PDCA_CR6_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR6_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR6_ECLR_SIZE                                     1
#define AVR32_PDCA_CR6_MASK                                 0x00000103
#define AVR32_PDCA_CR6_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR6_TDIS                                          1
#define AVR32_PDCA_CR6_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR6_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR6_TDIS_SIZE                                     1
#define AVR32_PDCA_CR6_TEN                                           0
#define AVR32_PDCA_CR6_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR6_TEN_OFFSET                                    0
#define AVR32_PDCA_CR6_TEN_SIZE                                      1
#define AVR32_PDCA_CR7                                      0x000001d4
#define AVR32_PDCA_CR7_ECLR                                          8
#define AVR32_PDCA_CR7_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR7_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR7_ECLR_SIZE                                     1
#define AVR32_PDCA_CR7_MASK                                 0x00000103
#define AVR32_PDCA_CR7_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR7_TDIS                                          1
#define AVR32_PDCA_CR7_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR7_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR7_TDIS_SIZE                                     1
#define AVR32_PDCA_CR7_TEN                                           0
#define AVR32_PDCA_CR7_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR7_TEN_OFFSET                                    0
#define AVR32_PDCA_CR7_TEN_SIZE                                      1
#define AVR32_PDCA_CR8                                      0x00000214
#define AVR32_PDCA_CR8_ECLR                                          8
#define AVR32_PDCA_CR8_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR8_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR8_ECLR_SIZE                                     1
#define AVR32_PDCA_CR8_MASK                                 0x00000103
#define AVR32_PDCA_CR8_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR8_TDIS                                          1
#define AVR32_PDCA_CR8_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR8_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR8_TDIS_SIZE                                     1
#define AVR32_PDCA_CR8_TEN                                           0
#define AVR32_PDCA_CR8_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR8_TEN_OFFSET                                    0
#define AVR32_PDCA_CR8_TEN_SIZE                                      1
#define AVR32_PDCA_CR9                                      0x00000254
#define AVR32_PDCA_CR9_ECLR                                          8
#define AVR32_PDCA_CR9_ECLR_MASK                            0x00000100
#define AVR32_PDCA_CR9_ECLR_OFFSET                                   8
#define AVR32_PDCA_CR9_ECLR_SIZE                                     1
#define AVR32_PDCA_CR9_MASK                                 0x00000103
#define AVR32_PDCA_CR9_RESETVALUE                           0x00000000
#define AVR32_PDCA_CR9_TDIS                                          1
#define AVR32_PDCA_CR9_TDIS_MASK                            0x00000002
#define AVR32_PDCA_CR9_TDIS_OFFSET                                   1
#define AVR32_PDCA_CR9_TDIS_SIZE                                     1
#define AVR32_PDCA_CR9_TEN                                           0
#define AVR32_PDCA_CR9_TEN_MASK                             0x00000001
#define AVR32_PDCA_CR9_TEN_OFFSET                                    0
#define AVR32_PDCA_CR9_TEN_SIZE                                      1

/* !defined (DEPRECATED_DISABLE) */
#endif


/*#ifdef __AVR32_ABI_COMPILER__*/
#endif

/*#ifdef AVR32_PDCA_121_H_INCLUDED*/
#endif
