from typing import List
from pyVmomi import vim
from pyVmomi.VmomiSupport import NoneType, long


class VStorageObjectManager(vim.vslm.VStorageObjectManagerBase):
    def CreateDisk(self, spec: vim.vslm.CreateSpec) -> vim.Task: ...
    def RegisterDisk(self, path: str, name: str, modifyControlFlags: bool) -> vim.vslm.VStorageObject: ...
    def ExtendDisk(self, id: vim.vslm.ID, datastore: vim.Datastore, newCapacityInMB: long) -> vim.Task: ...
    def InflateDisk(self, id: vim.vslm.ID, datastore: vim.Datastore) -> vim.Task: ...
    def RenameVStorageObject(self, id: vim.vslm.ID, datastore: vim.Datastore, name: str) -> NoneType: ...
    def RetrieveVStorageInfrastructureObjectPolicy(self, datastore: vim.Datastore) -> List[vim.vslm.InfrastructureObjectPolicy]: ...
    def DeleteVStorageObject(self, id: vim.vslm.ID, datastore: vim.Datastore) -> vim.Task: ...
    def RetrieveVStorageObject(self, id: vim.vslm.ID, datastore: vim.Datastore, diskInfoFlags: List[str]) -> vim.vslm.VStorageObject: ...
    def RetrieveVStorageObjectState(self, id: vim.vslm.ID, datastore: vim.Datastore) -> vim.vslm.StateInfo: ...
    def ListVStorageObject(self, datastore: vim.Datastore) -> List[vim.vslm.ID]: ...
    def CloneVStorageObject(self, id: vim.vslm.ID, datastore: vim.Datastore, spec: vim.vslm.CloneSpec) -> vim.Task: ...
    def RelocateVStorageObject(self, id: vim.vslm.ID, datastore: vim.Datastore, spec: vim.vslm.RelocateSpec) -> vim.Task: ...
    def SetVStorageObjectControlFlags(self, id: vim.vslm.ID, datastore: vim.Datastore, controlFlags: List[str]) -> NoneType: ...
    def ClearVStorageObjectControlFlags(self, id: vim.vslm.ID, datastore: vim.Datastore, controlFlags: List[str]) -> NoneType: ...
    def ReconcileDatastoreInventory(self, datastore: vim.Datastore) -> vim.Task: ...
    def ScheduleReconcileDatastoreInventory(self, datastore: vim.Datastore) -> NoneType: ...
    def CreateSnapshot(self, id: vim.vslm.ID, datastore: vim.Datastore, description: str) -> vim.Task: ...
    def DeleteSnapshot(self, id: vim.vslm.ID, datastore: vim.Datastore, snapshotId: vim.vslm.ID) -> vim.Task: ...
    def RetrieveSnapshotInfo(self, id: vim.vslm.ID, datastore: vim.Datastore) -> vim.vslm.VStorageObjectSnapshotInfo: ...
    def CreateDiskFromSnapshot(self, id: vim.vslm.ID, datastore: vim.Datastore, snapshotId: vim.vslm.ID, name: str, profile: List[vim.vm.ProfileSpec], crypto: vim.encryption.CryptoSpec, path: str, provisioningType: str) -> vim.Task: ...
    def RevertVStorageObject(self, id: vim.vslm.ID, datastore: vim.Datastore, snapshotId: vim.vslm.ID) -> vim.Task: ...
    def UpdateVStorageObjectMetadata(self, id: vim.vslm.ID, datastore: vim.Datastore, metadata: List[vim.KeyValue], deleteKeys: List[str]) -> vim.Task: ...
    def RetrieveVStorageObjectMetadata(self, id: vim.vslm.ID, datastore: vim.Datastore, snapshotId: vim.vslm.ID, prefix: str) -> List[vim.KeyValue]: ...
    def RetrieveVStorageObjectMetadataValue(self, id: vim.vslm.ID, datastore: vim.Datastore, snapshotId: vim.vslm.ID, key: str) -> str: ...
    def DeleteVStorageObjectEx(self, id: vim.vslm.ID, datastore: vim.Datastore) -> vim.Task: ...
    def UpdateVStorageObjectMetadataEx(self, id: vim.vslm.ID, datastore: vim.Datastore, metadata: List[vim.KeyValue], deleteKeys: List[str]) -> vim.Task: ...