"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTickLabel = void 0;
var canvas_1 = require("../../../../../renderers/canvas");
var axis_utils_1 = require("../../../utils/axis_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderTickLabel(ctx, tick, showTicks, props) {
    var _a = props.axisSpec, position = _a.position, labelFormat = _a.labelFormat, axisTicksDimensions = props.dimension, size = props.size, debug = props.debug, axisStyle = props.axisStyle;
    var labelStyle = axisStyle.tickLabel;
    var tickLabelRotation = labelStyle.rotation, alignment = labelStyle.alignment, offset = labelStyle.offset;
    var maxLabelBboxWidth = axisTicksDimensions.maxLabelBboxWidth, maxLabelBboxHeight = axisTicksDimensions.maxLabelBboxHeight, maxLabelTextWidth = axisTicksDimensions.maxLabelTextWidth, maxLabelTextHeight = axisTicksDimensions.maxLabelTextHeight;
    var _b = axis_utils_1.getTickLabelProps(axisStyle, tick.position, position, tickLabelRotation, size, axisTicksDimensions, showTicks, offset, alignment), x = _b.x, y = _b.y, offsetX = _b.offsetX, offsetY = _b.offsetY, textOffsetX = _b.textOffsetX, textOffsetY = _b.textOffsetY, horizontalAlign = _b.horizontalAlign, verticalAlign = _b.verticalAlign;
    if (debug) {
        debug_1.renderDebugRectCenterRotated(ctx, {
            x: x + offsetX,
            y: y + offsetY,
        }, {
            x: x + offsetX,
            y: y + offsetY,
            height: maxLabelTextHeight,
            width: maxLabelTextWidth,
        }, undefined, undefined, tickLabelRotation);
        if (![0, -90, 90, 180].includes(tickLabelRotation)) {
            debug_1.renderDebugRectCenterRotated(ctx, {
                x: x + offsetX,
                y: y + offsetY,
            }, {
                x: x + offsetX,
                y: y + offsetY,
                height: maxLabelBboxHeight,
                width: maxLabelBboxWidth,
            }, undefined, undefined, 0);
        }
    }
    var font = {
        fontFamily: labelStyle.fontFamily,
        fontStyle: labelStyle.fontStyle ? labelStyle.fontStyle : 'normal',
        fontVariant: 'normal',
        fontWeight: 'normal',
        textColor: labelStyle.fill,
        textOpacity: 1,
    };
    canvas_1.withContext(ctx, function (ctx) {
        text_1.renderText(ctx, {
            x: x + offsetX,
            y: y + offsetY,
        }, labelFormat ? labelFormat(tick.value) : tick.label, __assign(__assign({}, font), { fontSize: labelStyle.fontSize, fill: labelStyle.fill, align: horizontalAlign, baseline: verticalAlign }), tickLabelRotation, {
            x: textOffsetX,
            y: textOffsetY,
        });
    });
}
exports.renderTickLabel = renderTickLabel;
//# sourceMappingURL=tick_label.js.map