"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customStringify = customStringify;
exports.getCharacterLimitedString = getCharacterLimitedString;
exports.isVectorSearchUseCase = isVectorSearchUseCase;
exports.prettifyErrorMessage = void 0;
exports.toFormattedDate = toFormattedDate;
var _moment = _interopRequireDefault(require("moment"));
var _ = require("./");
var _lodash = require("lodash");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function toFormattedDate(timestampMillis) {
  return (0, _moment.default)(new Date(timestampMillis)).format(_.DATE_FORMAT_PATTERN);
}
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
function getCharacterLimitedString(input, limit) {
  return input !== undefined ? input.length > limit ? input.substring(0, limit - 3) + '...' : input : '';
}
function customStringify(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 2);
}
function isVectorSearchUseCase(workflow) {
  var _workflow$ui_metadata, _workflow$ui_metadata2;
  return (workflow === null || workflow === void 0 || (_workflow$ui_metadata = workflow.ui_metadata) === null || _workflow$ui_metadata === void 0 ? void 0 : _workflow$ui_metadata.type) !== undefined && [_.WORKFLOW_TYPE.HYBRID_SEARCH, _.WORKFLOW_TYPE.MULTIMODAL_SEARCH, _.WORKFLOW_TYPE.SEMANTIC_SEARCH, _.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG].includes(workflow === null || workflow === void 0 || (_workflow$ui_metadata2 = workflow.ui_metadata) === null || _workflow$ui_metadata2 === void 0 ? void 0 : _workflow$ui_metadata2.type);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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