/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.cli.Options;

public class DescribeVpcEndpointServices
extends BaseCmd {
    public DescribeVpcEndpointServices(String[] args) {
        super("ec2dves", "ec2-describe-vpc-endpoint-services");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "";
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(DescribeVpcEndpointServices.createOptionWithArgs(null, "max-results", MAX_RESULTS_DESC, "MAX_RESULTS"));
        options.addOption(DescribeVpcEndpointServices.createOptionWithArgs(null, "next-token", NEXT_TOKEN_DESC, "NEXT_TOKEN"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes all supported AWS services that can be specified when creating a VPC endpoint.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("max-results");
        this.printOption("next-token");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        Integer maxResults;
        try {
            maxResults = this.getOptionInteger("max-results");
        }
        catch (NumberFormatException e) {
            maxResults = null;
        }
        String nextToken = this.getOptionValue("next-token");
        boolean automaticPaging = nextToken == null && maxResults == null;
        ArrayList<String> vpcEndpointServices = new ArrayList<String>();
        do {
            rsp = jec2.describeVpcEndpointServices(maxResults, nextToken);
            vpcEndpointServices.addAll((Collection)rsp.getResponse());
            nextToken = rsp.getNextToken();
        } while (automaticPaging && nextToken != null && !nextToken.isEmpty());
        out.outputVpcEndpointServices(System.out, vpcEndpointServices);
        out.printNextToken(System.out, nextToken);
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DescribeVpcEndpointServices(args).invoke();
    }
}

