/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CachingFunction;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;

public final class REFAIPlayer
extends EuropeanAIPlayer {
    private static final Logger logger = Logger.getLogger(REFAIPlayer.class.getName());
    private static final int UNIT_USAD_THRESHOLD = 5;
    private static final int seekAndDestroyRange = 12;
    private final Map<Location, Integer> targetMap = new HashMap<Location, Integer>();
    private boolean landed = false;

    public REFAIPlayer(AIMain aiMain, Player player) {
        super(aiMain, player);
        this.initialized = this.getPlayer() != null;
    }

    public REFAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.initialized = this.getPlayer() != null;
    }

    private List<TargetTuple> findColonyTargets(AIUnit aiu, boolean port, AIUnit aiCarrier) {
        Player player = this.getPlayer();
        Unit unit = aiu.getUnit();
        Unit carrier = aiCarrier.getUnit();
        CachingFunction<Colony, PathNode> pathMapper = new CachingFunction<Colony, PathNode>(c -> unit.findPath(carrier, (Location)c, carrier));
        Predicate<Colony> pathPred = c -> pathMapper.apply((Colony)c) != null;
        Function<Colony, TargetTuple> newTupleMapper = c -> {
            PathNode path = (PathNode)pathMapper.apply((Colony)c);
            return new TargetTuple((Colony)c, path, UnitSeekAndDestroyMission.scorePath(aiu, path, false, false));
        };
        List<TargetTuple> targets = CollectionUtils.transform(CollectionUtils.flatten(player.getRebels(), port ? Player::getConnectedPorts : Player::getColonies), pathPred, newTupleMapper);
        if (targets.isEmpty()) {
            return targets;
        }
        int percentTwiddle = 20;
        int[] twiddle = RandomUtils.randomInts(logger, "REF target twiddle", this.getAIRandom(), 41, targets.size());
        int twidx = 0;
        for (TargetTuple t : targets) {
            ToDoubleFunction<Building> bdf = b -> (b.hasAbility("model.ability.repairUnits") ? 1.5 : 1.0) * CollectionUtils.product(b.getOutputs(), ag -> ag.getType().getMilitary() ? 2.0 : (ag.getType().isBuildingMaterial() && ag.getType().isRefined() ? 1.5 : 1.0));
            t.score = t.score * (0.01 * (double)(101 - Math.min(100, t.colony.getSonsOfLiberty())) * CollectionUtils.product(t.colony.getBuildings(), b -> b.getLevel() > 1, bdf) * ((double)(6 - (!t.colony.hasStockade() ? 0 : t.colony.getStockade().getLevel())) / 6.0) * (1.0 + 0.01 * (double)(twiddle[twidx++] - 20)));
        }
        targets.sort(Comparator.naturalOrder());
        return targets;
    }

    private List<TargetTuple> findColonyTargets(AIUnit aiu, AIUnit aiCarrier) {
        List<TargetTuple> targets = this.findColonyTargets(aiu, true, aiCarrier);
        if (targets.isEmpty()) {
            targets = this.findColonyTargets(aiu, false, aiCarrier);
        }
        return targets;
    }

    public boolean initialize(boolean teleport) {
        Mission m;
        PathNode path;
        AIMain aiMain = this.getAIMain();
        Random aiRandom = this.getAIRandom();
        AIUnit aiUnit = CollectionUtils.find(this.getAIUnits(), aiu -> !aiu.getUnit().isNaval() && aiu.getUnit().isOffensiveUnit());
        if (aiUnit == null) {
            logger.warning("REF has no army?!?");
            return false;
        }
        Unit unit = aiUnit.getUnit();
        Unit carrier = unit.getCarrier();
        if (carrier == null) {
            logger.warning("REF land unit not on a carrier: " + unit);
            return false;
        }
        AIUnit aiCarrier = aiMain.getAIUnit(carrier);
        if (aiCarrier == null) {
            logger.warning("REF naval unit missing: " + carrier);
            return false;
        }
        List<TargetTuple> targets = this.findColonyTargets(aiUnit, aiCarrier);
        if (targets.isEmpty()) {
            logger.warning("REF found no targets.");
            return false;
        }
        LogBuilder lb = new LogBuilder(64);
        lb.add("REF found colony targets:");
        for (TargetTuple t : targets) {
            lb.add(" ", t.colony, "(", t.score, ")");
        }
        lb.log(logger, Level.FINE);
        Player rebel = targets.get((int)0).colony.getOwner();
        double ratio = this.getStrengthRatio(rebel);
        int n = targets.size();
        LogBuilder lb2 = new LogBuilder(64);
        lb2.add("REF attacking ", rebel.getName(), " ratio=", ratio);
        int fail = 0;
        for (TargetTuple t : targets) {
            GoalDecider gd = GoalDeciders.getDisembarkGoalDecider(t.colony.getTile());
            path = unit.search(t.entry, gd, null, 10, carrier);
            if (path == null) {
                t.disembarkTile = null;
                ++fail;
                continue;
            }
            t.disembarkTile = path.getTransportDropNode().previous.getTile();
        }
        if (fail > 0) {
            if (fail < n) {
                lb2.add(" (");
                int i = 0;
                while (i < targets.size()) {
                    TargetTuple t;
                    t = targets.get(i);
                    if (t.disembarkTile == null) {
                        lb2.add(" ", t.colony);
                        targets.remove(i);
                        --n;
                        continue;
                    }
                    ++i;
                }
                lb2.add(")");
            } else {
                for (TargetTuple t : targets) {
                    t.disembarkTile = t.path.getTransportDropNode().previous.getTile();
                }
            }
        }
        n = ratio < 1.0 ? 1 : (ratio < 2.0 ? Math.min(2, targets.size()) : Math.min(3, targets.size()));
        lb2.add(" => #targets=", n);
        if (!teleport) {
            GoalDecider stealthGD = GoalDeciders.getComposedGoalDecider(true, GoalDeciders.getHighSeasGoalDecider(), GoalDeciders.getStealthyGoalDecider(rebel));
            for (int i = 0; i < n; ++i) {
                TargetTuple t = targets.get(i);
                if (!rebel.canSee(t.entry) || (path = carrier.search(t.disembarkTile, stealthGD, CostDeciders.avoidSettlementsAndBlockingUnits(), t.path.getTotalTurns() + 1, null)) == null) continue;
                t.entry = path.getLastNode().getTile();
                t.score *= 1.5;
            }
            targets.sort(Comparator.naturalOrder());
        }
        ArrayList<AIUnit> navy = new ArrayList<AIUnit>();
        Iterator<AIUnit> auIterator = this.getAIUnits().iterator();
        int land = this.getPlayer().getNumberOfKingLandUnits();
        block5: for (int i = 0; i < n && auIterator.hasNext(); ++i) {
            TargetTuple t = targets.get(i);
            lb2.add("\n  Attack ", t.colony, " from ", t.entry, " via ", t.disembarkTile, " with ");
            while (auIterator.hasNext()) {
                AIUnit aiu2 = auIterator.next();
                if (!aiu2.getUnit().isNaval()) continue;
                Unit ship = aiu2.getUnit();
                if (ship.isEmpty()) {
                    navy.add(aiu2);
                    continue;
                }
                if (teleport) {
                    ship.setEntryLocation(t.disembarkTile);
                } else {
                    ship.setEntryLocation(t.entry);
                }
                lb2.add("[", ship);
                lb2.mark();
                int used = 0;
                for (Unit u : aiu2.getUnit().getUnitList()) {
                    AIUnit laiu = aiMain.getAIUnit(u);
                    m = this.getSeekAndDestroyMission(laiu, t.colony);
                    if (m != null) {
                        lb2.add(" ", m);
                    }
                    ++used;
                }
                m = this.getTransportMission(aiu2);
                lb2.grew(" ", m);
                lb2.add(" ]");
                if (i >= n - 1 || used < (int)Math.floor((double)land * 0.66)) continue;
                land -= used;
                continue block5;
            }
        }
        HashSet<Unit> rebelNavy = new HashSet<Unit>();
        REFNavyGoalDecider navyGD = new REFNavyGoalDecider(rebel, rebelNavy);
        for (int i = 0; i < n; ++i) {
            carrier.search(targets.get((int)i).entry, navyGD, null, carrier.getInitialMovesLeft() * 2, null);
        }
        Comparator<Unit> militaryStrengthComparator = this.getGame().getCombatModel().getMilitaryStrengthComparator();
        ArrayList<Unit> rebelTargets = new ArrayList<Unit>(rebelNavy);
        rebelTargets.sort(militaryStrengthComparator);
        Iterator ui = rebelTargets.iterator();
        ArrayList<Tile> entries = new ArrayList<Tile>();
        entries.add(rebel.getEntryTile());
        while (!navy.isEmpty()) {
            Tile start;
            Unit enemy;
            AIUnit aiu3 = (AIUnit)navy.remove(0);
            Unit u = aiu3.getUnit();
            Unit unit2 = enemy = ui.hasNext() ? (Unit)ui.next() : null;
            if (enemy == null) {
                m = this.getWanderHostileMission(aiu3);
                if (m == null) continue;
                start = (Tile)RandomUtils.getRandomMember(logger, "REF patrol entry", entries, aiRandom);
                u.setEntryLocation(start);
                lb2.add("\n  Patrol from ", start, " with ", m);
                continue;
            }
            m = this.getSeekAndDestroyMission(aiu3, enemy);
            if (m == null) continue;
            start = u.getBestEntryTile(enemy.getTile());
            u.setEntryLocation(start);
            entries.add(start);
            lb2.add("\n  Suppress ", enemy, " from ", start, " with ", m);
        }
        lb2.log(logger, Level.FINE);
        return true;
    }

    private List<AIUnit> requireTransports(int nt, List<AIUnit> transports, List<AIUnit> privateers, LogBuilder lb) {
        Mission m;
        ArrayList<AIUnit> naval = new ArrayList<AIUnit>();
        ArrayList<AIUnit> result = new ArrayList<AIUnit>();
        if (transports.size() < nt) {
            for (AIUnit aiu2 : privateers) {
                Location target = aiu2.getMission().getTarget();
                if (target instanceof Unit && aiu2.getUnit().hasTile()) {
                    naval.add(aiu2);
                    continue;
                }
                m = this.getTransportMission(aiu2);
                if (m == null) continue;
                lb.add(" notarget ", m);
                result.add(aiu2);
            }
        }
        if (transports.size() < nt) {
            ToIntFunction<AIUnit> targetDistance = CollectionUtils.cacheInt(aiu -> {
                Unit target = (Unit)aiu.getMission().getTarget();
                Tile tile = aiu.getUnit().getTile();
                return tile.getDistanceTo(target.getTile());
            });
            for (AIUnit aiu3 : CollectionUtils.sort(naval, Comparator.comparingInt(targetDistance))) {
                int distance = targetDistance.applyAsInt(aiu3);
                m = this.getTransportMission(aiu3);
                if (m == null) continue;
                lb.add(" REQUIRED ", distance, " ", m);
                result.add(aiu3);
                if (result.size() + transports.size() < nt) continue;
                break;
            }
        }
        privateers.removeAll(result);
        transports.addAll(result);
        return result;
    }

    @Override
    protected Stance determineStance(Player other) {
        Player player = this.getPlayer();
        return other.getREFPlayer() == player ? (other.isRebel() ? Stance.WAR : Stance.PEACE) : (other.atWarWith(player) ? Stance.WAR : (!player.getRebels().isEmpty() ? Stance.PEACE : super.determineStance(other)));
    }

    @Override
    public void giveNormalMissions(LogBuilder lb, List<AIUnit> aiUnits) {
        Mission m;
        Colony colony;
        Player player = this.getPlayer();
        HashMap idlers = new HashMap();
        ArrayList<AIUnit> privateers = new ArrayList<AIUnit>();
        ArrayList<AIUnit> transports = new ArrayList<AIUnit>();
        ArrayList<AIUnit> todo = new ArrayList<AIUnit>();
        ArrayList<AIUnit> land = new ArrayList<AIUnit>();
        lb.add("\n  REF mission changes:");
        this.targetMap.clear();
        for (AIUnit aIUnit : this.getAIUnits()) {
            Unit u2 = aIUnit.getUnit();
            if (u2.isDisposed() || !u2.hasAbility("model.ability.refUnit")) continue;
            Mission mission = aIUnit.getMission();
            if (u2.isNaval()) {
                if (mission == null || !mission.isValid()) {
                    todo.add(aIUnit);
                    continue;
                }
                if (mission instanceof TransportMission) {
                    transports.add(aIUnit);
                    continue;
                }
                if (mission instanceof PrivateerMission) {
                    privateers.add(aIUnit);
                    Location loc2 = mission.getTarget();
                    if (loc2 == null) continue;
                    CollectionUtils.incrementMapCount(this.targetMap, loc2);
                    continue;
                }
                todo.add(aIUnit);
                continue;
            }
            if (mission == null) {
                land.add(aIUnit);
                continue;
            }
            if (mission instanceof DefendSettlementMission) {
                if (mission.isValid()) {
                    colony = (Colony)mission.getTarget();
                    if (u2.isAtLocation(colony) && !colony.isBadlyDefended() && RandomUtils.randomInt(logger, "REF defend " + colony.getName(), this.getAIRandom(), 3) == 0) {
                        land.add(aIUnit);
                        continue;
                    }
                    CollectionUtils.incrementMapCount(this.targetMap, mission.getTarget());
                    continue;
                }
                land.add(aIUnit);
                continue;
            }
            if (mission instanceof UnitSeekAndDestroyMission) {
                if (mission.isValid()) {
                    CollectionUtils.incrementMapCount(this.targetMap, mission.getTarget());
                    continue;
                }
                land.add(aIUnit);
                continue;
            }
            land.add(aIUnit);
        }
        for (AIUnit aIUnit : todo) {
            m = this.getTransportMission(aIUnit);
            if (m == null) continue;
            lb.add(" ", m);
            transports.add(aIUnit);
        }
        todo.clear();
        int nt = Math.max(3, privateers.size() / 10);
        this.requireTransports(nt, transports, privateers, lb);
        for (Object aiu3 : land) {
            Location target = UnitSeekAndDestroyMission.findMissionTarget((AIUnit)aiu3, 12, false, false);
            if (target != null) {
                Integer count = this.targetMap.get(target);
                if (count == null) {
                    count = 0;
                }
                if (target instanceof Unit && count < 5 && (m = this.getSeekAndDestroyMission((AIUnit)aiu3, target)) != null) {
                    lb.add(" NEW-SEEK-", count, " ", m);
                    CollectionUtils.incrementMapCount(this.targetMap, target);
                    continue;
                }
                if (target instanceof Settlement && (m = this.getSeekAndDestroyMission((AIUnit)aiu3, target)) != null) {
                    lb.add(" NEW-SEEK ", m);
                    CollectionUtils.incrementMapCount(this.targetMap, target);
                    continue;
                }
                throw new RuntimeException("Bogus target: " + target);
            }
            Unit u3 = ((AIUnit)aiu3).getUnit();
            if (u3.isInEurope()) {
                CollectionUtils.appendToMapList(idlers, player.getEurope(), aiu3);
                continue;
            }
            colony = u3.getColony();
            if (colony != null && colony.isConnectedPort()) {
                CollectionUtils.appendToMapList(idlers, colony, aiu3);
                continue;
            }
            Colony best = u3.getClosestColony(CollectionUtils.map(this.getBadlyDefended(), AIColony::getColony));
            if (best != null && (m = this.getDefendSettlementMission((AIUnit)aiu3, best)) != null) {
                lb.add(" GO-DEFEND-", best.getName(), " ", m);
                CollectionUtils.incrementMapCount(this.targetMap, best);
                continue;
            }
            PathNode pathNode = u3.findOurNearestPort();
            Colony colony2 = colony = pathNode == null ? null : pathNode.getLastNode().getTile().getColony();
            if (colony != null && (m = this.getDefendSettlementMission((AIUnit)aiu3, colony)) != null) {
                lb.add(" GOTO-", colony.getName(), " ", m);
                CollectionUtils.incrementMapCount(this.targetMap, colony);
                continue;
            }
            m = this.getIdleAtSettlementMission((AIUnit)aiu3);
            lb.add(" ", m);
        }
        if (!idlers.isEmpty()) {
            this.requireTransports(0, transports, privateers, lb);
            todo.clear();
            HashMap hashMap = new HashMap();
            for (AIUnit aiu4 : transports) {
                Europe europe;
                TransportMission tm = aiu4.getMission(TransportMission.class);
                if (!tm.isEmpty()) continue;
                Unit u4 = aiu4.getUnit();
                if (u4.isInEurope() && idlers.containsKey(europe = player.getEurope())) {
                    CollectionUtils.appendToMapList(hashMap, europe, aiu4);
                    continue;
                }
                Colony colony3 = u4.getColony();
                if (colony3 != null && idlers.containsKey(colony3)) {
                    CollectionUtils.appendToMapList(hashMap, colony3, aiu4);
                    continue;
                }
                todo.add(aiu4);
            }
            ArrayList<Location> idlePorts = new ArrayList<Location>();
            ArrayList<AIUnit> aiCarriers = new ArrayList<AIUnit>();
            int space = 0;
            for (Map.Entry entry : idlers.entrySet()) {
                Object aiCarrier;
                List<TargetTuple> ct;
                if (entry.getValue() == null) continue;
                aiCarriers.clear();
                Location key = (Location)entry.getKey();
                if (!hashMap.containsKey(key) || ((List)hashMap.get(key)).isEmpty()) continue;
                block5: for (AIUnit aiu5 : (List)entry.getValue()) {
                    for (AIUnit aiCarrier2 : (List)hashMap.get(key)) {
                        Unit carrier = aiCarrier2.getUnit();
                        if (!carrier.canAdd(aiu5.getUnit()) || !aiu5.joinTransport(carrier, null)) continue;
                        if (aiCarriers.contains(aiCarrier2)) continue block5;
                        aiCarriers.add(aiCarrier2);
                        continue block5;
                    }
                }
                if (aiCarriers.isEmpty()) continue;
                AIUnit found = null;
                Colony target = null;
                for (AIUnit aiCarrier2 : aiCarriers) {
                    found = (AIUnit)CollectionUtils.first(CollectionUtils.transform(aiCarrier2.getUnit().getUnits(), u -> u.hasAbility("model.ability.refUnit"), u -> this.getAIUnit((Unit)u), CollectionUtils.toListNoNulls()));
                    if (found == null || (m = found.getMission()) == null || !m.isValid() || !(m instanceof UnitSeekAndDestroyMission) || !(m.getTarget() instanceof Colony)) continue;
                    target = (Colony)m.getTarget();
                    break;
                }
                if (target == null && !(ct = this.findColonyTargets(found, (AIUnit)(aiCarrier = this.getAIUnit(found.getUnit().getCarrier())))).isEmpty()) {
                    target = ct.get((int)0).colony;
                }
                if (target == null) continue;
                aiCarrier = aiCarriers.iterator();
                while (aiCarrier.hasNext()) {
                    AIUnit aiCarrier2;
                    aiCarrier2 = (AIUnit)aiCarrier.next();
                    TransportMission tm = aiCarrier2.getMission(TransportMission.class);
                    for (Unit u5 : aiCarrier2.getUnit().getUnitList()) {
                        AIUnit aiu6;
                        if (!u5.hasAbility("model.ability.refUnit") || (aiu6 = this.getAIUnit(u5)) == null || (m = this.getSeekAndDestroyMission(aiu6, target)) == null) continue;
                        lb.add(" IDLER->", target, " ", m);
                        tm.queueTransportable(aiu6, false, lb);
                        ((List)entry.getValue()).remove(aiu6);
                    }
                }
                if (((List)entry.getValue()).isEmpty()) continue;
                idlePorts.add(key);
                space += CollectionUtils.sum((Collection)entry.getValue(), aiu -> aiu.getUnit().getSpaceTaken());
            }
            if (!idlePorts.isEmpty()) {
                boolean bl;
                for (AIUnit aIUnit : todo) {
                    space -= aIUnit.getUnit().getCargoCapacity() - aIUnit.getUnit().getCargoSpaceTaken();
                }
                nt = todo.size();
                if (space < 0) {
                    this.requireTransports(nt += -space / 5 + 1, todo, privateers, lb);
                }
                Comparator<Location> portUnitComparator = Comparator.comparing(loc -> (List)idlers.get(loc), CollectionUtils.ascendingListLengthComparator);
                idlePorts.sort(portUnitComparator);
                boolean bl2 = false;
                while (!bl && !todo.isEmpty()) {
                    for (Location l : idlePorts) {
                        int bestValue = 10000;
                        AIUnit best = null;
                        for (AIUnit aiu8 : todo) {
                            int value = aiu8.getUnit().getTurnsToReach(l);
                            if (bestValue <= value) continue;
                            bestValue = value;
                            best = aiu8;
                        }
                        if (best == null) {
                            bl = true;
                            continue;
                        }
                        todo.remove(best);
                        best.getMission().setTarget(l);
                        lb.add(" retarget ", best, " to ", l, "(", ((List)idlers.get(l)).size(), ")");
                    }
                }
            }
        }
        super.giveNormalMissions(lb, this.getAIUnits());
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        if (!player.isWorkForREF()) {
            logger.warning("No work for REF: " + player);
            return;
        }
        super.startWorking();
        ArrayList<TransportMission> transport = new ArrayList<TransportMission>();
        ArrayList<TransportableAIObject> land = new ArrayList<TransportableAIObject>();
        for (AIUnit aiu : this.getAIUnits()) {
            Unit u = aiu.getUnit();
            if (u.isNaval()) {
                if (!aiu.hasMission(TransportMission.class)) continue;
                transport.add(aiu.getMission(TransportMission.class));
                continue;
            }
            if (u.isInEurope()) {
                land.add(aiu);
                continue;
            }
            if (!u.isOnTile()) continue;
            this.landed = true;
        }
        if (!land.isEmpty() && !transport.isEmpty()) {
            LogBuilder lb = new LogBuilder(256);
            this.allocateTransportables(land, transport, lb);
            lb.log(logger, Level.FINE);
        }
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (value > 0) {
            if (type == DefendSettlementMission.class) {
                Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
                if (loc instanceof Colony && !((Colony)loc).isBadlyDefended()) {
                    return Integer.MIN_VALUE;
                }
            } else if (type == UnitSeekAndDestroyMission.class) {
                Location target = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
                if (target instanceof Settlement) {
                    if (((Settlement)target).isConnectedPort()) {
                        value += 500;
                    } else if (!this.getPlayer().hasSettlements()) {
                        return Integer.MIN_VALUE;
                    }
                } else if (target instanceof Unit) {
                    if (!this.getPlayer().hasSettlements()) {
                        return Integer.MIN_VALUE;
                    }
                    Predicate<UnitSeekAndDestroyMission> unitPred = m -> m != null && m.getTarget() instanceof Unit && (Unit)m.getTarget() == target;
                    Function<AIUnit, UnitSeekAndDestroyMission> missionMapper = aiu -> aiu.getMission(UnitSeekAndDestroyMission.class);
                    if (CollectionUtils.any(CollectionUtils.transform(this.getAIUnits(), aiu -> aiu != aiUnit, missionMapper), unitPred)) {
                        return Integer.MIN_VALUE;
                    }
                    value /= 2;
                }
            }
        }
        return value;
    }

    private static class TargetTuple
    implements Comparable<TargetTuple> {
        public final Colony colony;
        public final PathNode path;
        public double score;
        public Tile disembarkTile;
        public Tile entry;

        public TargetTuple(Colony colony, PathNode path, double score) {
            this.colony = colony;
            this.path = path;
            this.score = score;
            this.disembarkTile = null;
            this.entry = null;
            if (path != null) {
                PathNode p = path;
                while (p != null) {
                    Tile t = p.getTile();
                    if (t != null) {
                        this.entry = t;
                        break;
                    }
                    p = p.next;
                }
            }
        }

        @Override
        public int compareTo(TargetTuple other) {
            return Double.compare(this.score, other.score);
        }

        public boolean equals(Object o) {
            if (o instanceof TargetTuple) {
                TargetTuple other = (TargetTuple)o;
                return this.compareTo(other) == 0 && super.equals(other);
            }
            return false;
        }

        public int hashCode() {
            int hash = super.hashCode();
            hash = 37 * hash + Utils.hashCode(this.colony);
            hash = 37 * hash + Utils.hashCode(this.path);
            hash = 37 * hash + Utils.hashCode(this.score);
            hash = 37 * hash + Utils.hashCode(this.disembarkTile);
            return 37 * hash + Utils.hashCode(this.entry);
        }
    }

    private static class REFNavyGoalDecider
    implements GoalDecider {
        private Player rebel;
        private Set<Unit> rebelNavy;

        public REFNavyGoalDecider(Player rebel, Set<Unit> rebelNavy) {
            this.rebel = rebel;
            this.rebelNavy = rebelNavy;
        }

        @Override
        public PathNode getGoal() {
            return null;
        }

        @Override
        public boolean hasSubGoals() {
            return true;
        }

        @Override
        public boolean check(Unit unit, PathNode pathNode) {
            Predicate<Unit> pred = u -> u.isOffensiveUnit() && u.isNaval() && !this.rebelNavy.contains(u);
            Tile tile = pathNode.getTile();
            if (tile != null && !tile.isEmpty() && !tile.isLand() && this.rebel.owns(tile.getFirstUnit())) {
                this.rebelNavy.addAll(CollectionUtils.transform(tile.getUnits(), pred));
                return true;
            }
            return false;
        }
    }
}

