/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis;

import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public final class JavaGenericsUtil {
    public static boolean isReifiableType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return JavaGenericsUtil.isReifiableType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)PsiUtil.convertAnonymousToBaseType(type2);
            if (classType.isRaw()) {
                return true;
            }
            PsiType[] parameters2 = classType.getParameters();
            if (parameters2.length > 0) {
                for (PsiType parameter2 : parameters2) {
                    if (parameter2 instanceof PsiWildcardType && ((PsiWildcardType)parameter2).getBound() == null) continue;
                    return false;
                }
                return true;
            }
            PsiClassType.ClassResolveResult resolved = classType.resolveGenerics();
            PsiClass aClass = resolved.getElement();
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            if (aClass != null && !aClass.hasModifierProperty("static")) {
                PsiClass stopClassLevel = PsiUtil.isLocalClass(aClass) ? null : aClass.getContainingClass();
                PsiModifierListOwner enclosingStaticElement = PsiUtil.getEnclosingStaticElement(aClass, stopClassLevel);
                PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, true);
                if (containingClass != null && (enclosingStaticElement == null || PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false))) {
                    while (containingClass instanceof PsiAnonymousClass) {
                        containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, true);
                    }
                    if (containingClass == null || enclosingStaticElement != null && !PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false)) {
                        return true;
                    }
                    return JavaGenericsUtil.isReifiableType(JavaPsiFacade.getElementFactory(aClass.getProject()).createType(containingClass, resolved.getSubstitutor()));
                }
            }
            return true;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isReifiableType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return false;
    }

    public static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return JavaGenericsUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type3 : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(type3, rType)) continue;
                return true;
            }
            return false;
        }
        if (rType instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiCapturedWildcardType)rType).getUpperBound());
        }
        if (!(lType instanceof PsiClassType) || !(rType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf(rClass, lClass, true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent(lClass, rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(rClass, lClass, lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(lClass, rClass, rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator<PsiTypeParameter> lIterator = PsiUtil.typeParametersIterator(lClass);
        Iterator<PsiTypeParameter> rIterator = PsiUtil.typeParametersIterator(rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = lIterator.next();
            PsiTypeParameter rParameter = rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (TypeConversionUtil.typesAgree(lTypeArg, rTypeArg, true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType getCollectionItemType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaGenericsUtil.$$$reportNull$$$0(5);
        }
        return JavaGenericsUtil.getCollectionItemType(expression2.getType(), expression2.getResolveScope());
    }

    @Nullable
    public static PsiType getCollectionItemType(@Nullable PsiType type2, @NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            JavaGenericsUtil.$$$reportNull$$$0(6);
        }
        if (type2 instanceof PsiArrayType) {
            return ((PsiArrayType)type2).getComponentType();
        }
        if (type2 instanceof PsiClassType) {
            PsiTypeParameter typeParameter2;
            PsiClass myClass;
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return null;
            }
            PsiManager manager = aClass.getManager();
            String qName = aClass.getQualifiedName();
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            if (qName != null && (myClass = facade.findClass(qName, scope2)) != null && myClass != aClass) {
                PsiTypeParameter thisTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, myClass);
                if (thisTypeParameter == null) {
                    return null;
                }
                PsiTypeParameter thatTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass);
                if (thatTypeParameter != null) {
                    substitutor2 = substitutor2.put(thisTypeParameter, substitutor2.substitute(thatTypeParameter));
                }
                aClass = myClass;
            }
            if ((typeParameter2 = JavaGenericsUtil.getIterableTypeParameter(facade, aClass)) == null) {
                return null;
            }
            PsiClass owner = (PsiClass)typeParameter2.getOwner();
            if (owner == null) {
                return null;
            }
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor(owner, aClass, substitutor2);
            if (superClassSubstitutor == null) {
                return null;
            }
            PsiType itemType = superClassSubstitutor.substitute(typeParameter2);
            return itemType == null ? PsiType.getJavaLangObject(manager, aClass.getResolveScope()) : itemType;
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiType itemType = JavaGenericsUtil.getCollectionItemType(conjunct, scope2);
                if (itemType == null) continue;
                return itemType;
            }
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.getCollectionItemType(((PsiCapturedWildcardType)type2).getUpperBound(), scope2);
        }
        return null;
    }

    @Nullable
    private static PsiTypeParameter getIterableTypeParameter(JavaPsiFacade facade, PsiClass context) {
        PsiClass iterable = facade.findClass("java.lang.Iterable", context.getResolveScope());
        if (iterable == null) {
            return null;
        }
        PsiTypeParameter[] typeParameters2 = iterable.getTypeParameters();
        if (typeParameters2.length != 1) {
            return null;
        }
        return typeParameters2[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/daemon/impl/analysis/JavaGenericsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncheckedWarning";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUncheckedCast";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCollectionItemType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

