/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public interface RoleBasedConfigurationContainerInternal
extends ConfigurationContainer {
    default public Configuration consumable(String name, boolean lockRole) {
        return this.createWithRole(name, ConfigurationRoles.CONSUMABLE, lockRole);
    }

    default public Configuration resolvable(String name, boolean lockRole) {
        return this.createWithRole(name, ConfigurationRoles.RESOLVABLE, lockRole);
    }

    default public Configuration resolvableBucket(String name, boolean lockRole) {
        return this.createWithRole(name, ConfigurationRoles.RESOLVABLE_BUCKET, lockRole);
    }

    default public Configuration bucket(String name, boolean lockRole) {
        return this.createWithRole(name, ConfigurationRoles.BUCKET, lockRole);
    }

    default public Configuration consumable(String name) {
        return this.consumable(name, false);
    }

    default public Configuration resolvable(String name) {
        return this.resolvable(name, false);
    }

    default public Configuration resolvableBucket(String name) {
        return this.resolvableBucket(name, false);
    }

    default public Configuration bucket(String name) {
        return this.bucket(name, false);
    }

    public Configuration createWithRole(String var1, ConfigurationRole var2, boolean var3, Action<? super Configuration> var4);

    default public Configuration createWithRole(String name, ConfigurationRole role, boolean lockUsage) {
        return this.createWithRole(name, role, lockUsage, (Action<? super Configuration>)Actions.doNothing());
    }

    default public Configuration createWithRole(String name, ConfigurationRole role, Action<? super Configuration> configureAction) {
        return this.createWithRole(name, role, false, configureAction);
    }

    default public Configuration createWithRole(String name, ConfigurationRole role) {
        return this.createWithRole(name, role, false);
    }

    default public Configuration maybeCreateWithRole(String name, ConfigurationRole role) {
        return this.maybeCreateWithRole(name, role, false, false);
    }

    default public Configuration maybeCreateWithRole(String name, ConfigurationRole role, boolean lockUsage, boolean assertInRole) {
        DeprecatableConfiguration configuration = (DeprecatableConfiguration)this.findByName(name);
        if (configuration == null) {
            return this.createWithRole(name, role, lockUsage);
        }
        if (assertInRole) {
            RoleChecker.assertIsInRole(configuration, role);
        }
        if (lockUsage) {
            configuration.preventUsageMutation();
        }
        return configuration;
    }

    public static abstract class RoleChecker {
        private RoleChecker() {
        }

        public static boolean isUsageConsistentWithRole(DeprecatableConfiguration configuration, ConfigurationRole role) {
            return role.isConsumable() == configuration.isCanBeConsumed() && role.isResolvable() == configuration.isCanBeResolved() && role.isDeclarable() == configuration.isCanBeDeclared() && role.isConsumptionDeprecated() == configuration.isDeprecatedForConsumption() && role.isResolutionDeprecated() == configuration.isDeprecatedForResolution() && role.isDeclarationAgainstDeprecated() == configuration.isDeprecatedForDeclarationAgainst();
        }

        public static void assertIsInRole(DeprecatableConfiguration configuration, ConfigurationRole role) {
            if (!RoleChecker.isUsageConsistentWithRole(configuration, role)) {
                throw new GradleException(RoleChecker.describeDifferenceFromRole(configuration, role));
            }
        }

        private static String describeDifferenceFromRole(DeprecatableConfiguration configuration, ConfigurationRole role) {
            if (!RoleChecker.isUsageConsistentWithRole(configuration, role)) {
                return "Usage for configuration: " + configuration.getName() + " is not consistent with the role: " + role.getName() + ".\nExpected that it is:\n" + role.describeUsage() + "\nBut is actually is:\n" + UsageDescriber.describeUsage(configuration.isCanBeConsumed(), configuration.isCanBeResolved(), configuration.isCanBeDeclared(), configuration.isDeprecatedForConsumption(), configuration.isDeprecatedForResolution(), configuration.isDeprecatedForDeclarationAgainst());
            }
            return "Usage for configuration: " + configuration.getName() + " is consistent with the role: " + role.getName() + ".";
        }
    }
}

