/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntityCollector;
import de.escape.quincunx.dxf.reader.DxfEntitySet;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfSEQEND;
import de.escape.quincunx.dxf.reader.DxfVERTEX;
import de.escape.quincunx.trafo.Point3D;
import java.util.Enumeration;

public class DxfPOLYLINE
extends DxfEntity
implements DxfEntityCollector {
    protected boolean vertexFlag = true;
    protected Point3D basis = new Point3D();
    protected int type;
    protected float startWidth;
    protected float endWidth;
    protected int nrCtrlU;
    protected int nrCtrlV;
    protected int nrApproxM;
    protected int nrApproxN;
    protected int smooth;
    protected DxfEntitySet vertices = new DxfEntitySet();
    private boolean prepared = false;
    private boolean hasWidth = false;
    public static final int CLOSED = 1;
    public static final int CURVE_FIT = 2;
    public static final int B_SPLINE = 4;
    public static final int THREE_DIM = 8;
    public static final int WEB = 16;
    public static final int WEB_CLOSED = 32;
    public static final int NET = 64;
    public static final int CONT_LTYPE = 128;
    public static final int TWO_DIM = 6;
    public static final int ANY_WEB = 48;
    public static final int NO_SMOOTH = 0;
    public static final int B_SPLINE_2 = 5;
    public static final int B_SPLINE_3 = 6;
    public static final int BEZIER = 8;

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 20: 
            case 30: {
                this.setCoord(this.basis, grpNr / 10, fval);
                return true;
            }
            case 40: {
                this.startWidth = fval;
                return true;
            }
            case 41: {
                this.endWidth = fval;
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 66: {
                this.vertexFlag = ival != 0;
                return true;
            }
            case 70: {
                this.type = ival;
                return true;
            }
            case 71: {
                this.nrCtrlU = ival;
                return true;
            }
            case 72: {
                this.nrCtrlV = ival;
                return true;
            }
            case 73: {
                this.nrApproxM = ival;
                return true;
            }
            case 74: {
                this.nrApproxN = ival;
                return true;
            }
            case 75: {
                this.smooth = ival;
                return true;
            }
        }
        return super.setGroup(grpNr, ival);
    }

    public boolean hasLineWidth() {
        if (!this.prepared) {
            this.prepare();
        }
        return this.hasWidth;
    }

    public boolean addEntity(DxfEntity vertex) throws DxfException {
        if (vertex instanceof DxfVERTEX) {
            this.vertices.addEntity(vertex);
            return true;
        }
        if (vertex.isTerm() && vertex instanceof DxfSEQEND) {
            return false;
        }
        throw new DxfException("err!VertexAfterPolyline");
    }

    public DxfEntityCollector getEntityCollector() {
        return this.vertexFlag ? this : null;
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
        if (!this.prepared) {
            this.prepare();
        }
        converter.convert(this, dxf, collector);
    }

    public final boolean vertexFollowing() {
        return this.vertexFlag;
    }

    public final Point3D getBasis() {
        return this.basis;
    }

    public final int getType() {
        return this.type;
    }

    public final float getStartWidth() {
        return this.startWidth;
    }

    public final float getEndWidth() {
        return this.endWidth;
    }

    public final int getNrCtrlU() {
        return this.nrCtrlU;
    }

    public final int getNrCtrlV() {
        return this.nrCtrlV;
    }

    public final int getNrApproxM() {
        return this.nrApproxM;
    }

    public final int getNrApproxN() {
        return this.nrApproxN;
    }

    public final int getSmoothType() {
        return this.smooth;
    }

    public final DxfEntitySet getVertices() {
        return this.vertices;
    }

    private void prepare() {
        if (!this.prepared) {
            this.prepared = true;
            DxfVERTEX first = (DxfVERTEX)this.vertices.getEntity(0);
            if (first.getStartWidth() < 0.0f) {
                first.setStartWidth(this.getStartWidth());
            }
            if (first.getEndWidth() < 0.0f) {
                first.setEndWidth(this.getEndWidth());
            }
            float lastEndWidth = (this.getType() & 1) != 0 ? ((DxfVERTEX)this.vertices.getEntity(this.vertices.getNrOfEntities() - 1)).getEndWidth() : 0.0f;
            Enumeration e = this.vertices.getEntities();
            while (e.hasMoreElements()) {
                float f;
                float f2;
                float f3;
                DxfVERTEX v = (DxfVERTEX)e.nextElement();
                float width = v.getStartWidth();
                if (f3 > 0.0f) {
                    this.hasWidth = true;
                } else if (width < 0.0f) {
                    v.setStartWidth(lastEndWidth);
                }
                width = v.getEndWidth();
                if (f2 > 0.0f) {
                    this.hasWidth = true;
                } else if (width < 0.0f) {
                    v.setEndWidth(v.getStartWidth());
                }
                lastEndWidth = v.getEndWidth();
                if (!(f > 0.0f)) continue;
                this.hasWidth = true;
            }
        }
    }
}

