/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadConfigSetAPI
extends ConfigSetAPIBase {
    public static final String CONFIGSET_NAME_PLACEHOLDER = "name";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public UploadConfigSetAPI(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @EndPoint(method={SolrRequest.METHOD.PUT}, path={"/cluster/configs/{name}"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void uploadConfigSet(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.ensureConfigSetUploadEnabled();
        String configSetName = req.getPathTemplateValues().get(CONFIGSET_NAME_PLACEHOLDER);
        boolean overwritesExisting = this.configSetService.checkConfigExists(configSetName);
        boolean requestIsTrusted = UploadConfigSetAPI.isTrusted(req.getUserPrincipal(), this.coreContainer.getAuthenticationPlugin());
        boolean allowOverwrite = req.getParams().getBool("overwrite", true);
        boolean cleanup = req.getParams().getBool("cleanup", false);
        InputStream inputStream = this.ensureNonEmptyInputStream(req);
        if (overwritesExisting && !allowOverwrite) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration " + configSetName + " already exists");
        }
        List<Object> filesToDelete = overwritesExisting && cleanup ? this.configSetService.getAllConfigFiles(configSetName) : Collections.emptyList();
        this.createBaseNode(this.configSetService, overwritesExisting, requestIsTrusted, configSetName);
        try (ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);){
            ZipEntry zipEntry;
            boolean hasEntry = false;
            while ((zipEntry = zis.getNextEntry()) != null) {
                hasEntry = true;
                String filePath = zipEntry.getName();
                filesToDelete.remove(filePath);
                if (zipEntry.isDirectory()) continue;
                this.configSetService.uploadFileToConfig(configSetName, filePath, zis.readAllBytes(), true);
            }
            if (!hasEntry) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either empty zipped data, or non-zipped data was uploaded. In order to upload a configSet, you must zip a non-empty directory to upload.");
            }
        }
        this.deleteUnusedFiles(this.configSetService, configSetName, filesToDelete);
        if (cleanup && requestIsTrusted && overwritesExisting && !this.configSetService.isConfigSetTrusted(configSetName)) {
            this.configSetService.setConfigSetTrust(configSetName, true);
        }
    }

    private void deleteUnusedFiles(ConfigSetService configSetService, String configName, List<String> filesToDelete) throws IOException {
        if (!filesToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("Cleaning up {} unused files", (Object)filesToDelete.size());
            }
            if (log.isDebugEnabled()) {
                log.debug("Cleaning up unused files: {}", filesToDelete);
            }
            configSetService.deleteFilesFromConfig(configName, filesToDelete);
        }
    }
}

