/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.jaas;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.hadoop.shaded.com.nimbusds.jwt.JWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.JWTParser;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbRuntime;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbTokenClient;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.jaas.TokenCache;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.PrivateKeyReader;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.TokenFormat;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.provider.token.JwtAuthToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.provider.token.JwtTokenEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthLoginModule
implements LoginModule {
    public static final String PRINCIPAL = "principal";
    public static final String TOKEN = "token";
    public static final String TOKEN_CACHE = "tokenCache";
    public static final String ARMOR_CACHE = "armorCache";
    public static final String CREDENTIAL_CACHE = "credentialCache";
    public static final String SIGN_KEY_FILE = "signKeyFile";
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthLoginModule.class);
    private Subject subject;
    private String tokenCacheName = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String princName = null;
    private String tokenStr = null;
    private AuthToken authToken = null;
    private KrbToken krbToken = null;
    private File armorCache;
    private File cCache;
    private File signKeyFile;
    private TgtTicket tgtTicket;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.princName = (String)options.get(PRINCIPAL);
        this.tokenStr = (String)options.get(TOKEN);
        this.tokenCacheName = (String)options.get(TOKEN_CACHE);
        if ((String)options.get(ARMOR_CACHE) != null) {
            this.armorCache = new File((String)options.get(ARMOR_CACHE));
        }
        if ((String)options.get(CREDENTIAL_CACHE) != null) {
            this.cCache = new File((String)options.get(CREDENTIAL_CACHE));
        }
        if ((String)options.get(SIGN_KEY_FILE) != null) {
            this.signKeyFile = new File((String)options.get(SIGN_KEY_FILE));
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.validateConfiguration();
        this.succeeded = this.tokenLogin();
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            this.cleanup();
            return false;
        }
        KerberosTicket ticket = null;
        try {
            EncKdcRepPart encKdcRepPart = this.tgtTicket.getEncKdcRepPart();
            boolean[] flags = new boolean[7];
            int flag = encKdcRepPart.getFlags().getFlags();
            for (int i = 6; i >= 0; --i) {
                flags[i] = (flag & 1 << i) != 0;
            }
            Date startTime = null;
            if (encKdcRepPart.getStartTime() != null) {
                startTime = (Date)encKdcRepPart.getStartTime().getValue();
            }
            ticket = new KerberosTicket(this.tgtTicket.getTicket().encode(), new KerberosPrincipal(this.tgtTicket.getClientPrincipal().getName()), new KerberosPrincipal(this.tgtTicket.getEncKdcRepPart().getSname().getName()), encKdcRepPart.getKey().getKeyData(), encKdcRepPart.getKey().getKeyType().getValue(), flags, (Date)encKdcRepPart.getAuthTime().getValue(), startTime, (Date)encKdcRepPart.getEndTime().getValue(), (Date)encKdcRepPart.getRenewTill().getValue(), null);
        }
        catch (IOException e) {
            LOG.error("Commit Failed. " + e.toString());
        }
        this.subject.getPrivateCredentials().add(ticket);
        if (this.princName != null) {
            this.subject.getPrincipals().add(new KerberosPrincipal(this.princName));
        }
        this.commitSucceeded = true;
        LOG.info("Commit Succeeded \n");
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        LOG.info("\t\t[TokenAuthLoginModule]: Entering logout");
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is Readonly");
        }
        for (Principal principal : this.subject.getPrincipals()) {
            if (!principal.getName().equals(this.princName)) continue;
            this.subject.getPrincipals().remove(principal);
        }
        Iterator<Object> it = this.subject.getPrivateCredentials().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof KrbToken)) continue;
            it.remove();
        }
        this.cleanup();
        this.succeeded = false;
        this.commitSucceeded = false;
        LOG.info("\t\t[TokenAuthLoginModule]: logged out Subject");
        return true;
    }

    private void validateConfiguration() throws LoginException {
        if (this.armorCache == null) {
            throw new LoginException("An armor cache must be specified via the armorCache configuration option");
        }
        if (this.cCache == null) {
            LOG.info("No credential cache was specified via 'credentialCache'. The TGT will be stored internally instead");
        }
        String error = "";
        if (this.tokenStr == null && this.tokenCacheName == null) {
            error = "useToken is specified but no token or token cache is provided";
        } else if (this.tokenStr != null && this.tokenCacheName != null) {
            error = "either token or token cache should be provided but not both";
        }
        if (!error.isEmpty()) {
            throw new LoginException(error);
        }
    }

    private boolean tokenLogin() throws LoginException {
        if (this.tokenStr == null) {
            this.tokenStr = TokenCache.readToken(this.tokenCacheName);
            if (this.tokenStr == null) {
                throw new LoginException("No valid token was found in token cache: " + this.tokenCacheName);
            }
        }
        this.krbToken = new KrbToken();
        if (this.signKeyFile != null) {
            try {
                TokenDecoder tokenDecoder = KrbRuntime.getTokenProvider("JWT").createTokenDecoder();
                try {
                    this.authToken = tokenDecoder.decodeFromString(this.tokenStr);
                }
                catch (IOException e) {
                    LOG.error("Token decode failed. " + e.toString());
                }
                TokenEncoder tokenEncoder = KrbRuntime.getTokenProvider("JWT").createTokenEncoder();
                if (tokenEncoder instanceof JwtTokenEncoder) {
                    PrivateKey signKey = null;
                    try (InputStream is = Files.newInputStream(this.signKeyFile.toPath(), new OpenOption[0]);){
                        signKey = PrivateKeyReader.loadPrivateKey(is);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to load private key from file: " + this.signKeyFile.getName());
                    }
                    catch (Exception e) {
                        LOG.error(e.toString());
                    }
                    ((JwtTokenEncoder)tokenEncoder).setSignKey((RSAPrivateKey)signKey);
                }
                this.krbToken.setTokenValue(tokenEncoder.encodeAsBytes(this.authToken));
            }
            catch (KrbException e) {
                throw new RuntimeException("Failed to encode AuthToken", e);
            }
        }
        this.krbToken.setTokenValue(this.tokenStr.getBytes());
        if (this.authToken == null) {
            try {
                JWT jwt = JWTParser.parse(this.tokenStr);
                this.authToken = new JwtAuthToken(jwt.getJWTClaimsSet());
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse JWT token string", e);
            }
        }
        this.krbToken.setInnerToken(this.authToken);
        this.krbToken.setTokenType();
        this.krbToken.setTokenFormat(TokenFormat.JWT);
        KrbClient krbClient = null;
        try {
            File confFile = new File(System.getProperty("java.security.krb5.conf"));
            KrbConfig krbConfig = new KrbConfig();
            krbConfig.addKrb5Config(confFile);
            krbClient = new KrbClient(krbConfig);
            krbClient.init();
        }
        catch (IOException | KrbException e) {
            LOG.error("KrbClient init failed. " + e.toString());
            throw new RuntimeException("KrbClient init failed", e);
        }
        KrbTokenClient tokenClient = new KrbTokenClient(krbClient);
        try {
            this.tgtTicket = tokenClient.requestTgt(this.krbToken, this.armorCache.getAbsolutePath());
        }
        catch (KrbException e) {
            this.throwWith("Failed to do login with token: " + this.tokenStr, e);
            return false;
        }
        if (this.cCache != null) {
            try {
                this.cCache = this.makeTgtCache();
            }
            catch (IOException e) {
                LOG.error("Failed to make tgtCache. " + e.toString());
            }
            try {
                krbClient.storeTicket(this.tgtTicket, this.cCache);
            }
            catch (KrbException e) {
                LOG.error("Failed to store tgtTicket to " + this.cCache.getName());
            }
        }
        return true;
    }

    private File makeTgtCache() throws IOException {
        if (!this.cCache.exists() && !this.cCache.createNewFile()) {
            throw new IOException("Failed to create tgtcache file " + this.cCache.getAbsolutePath());
        }
        this.cCache.setExecutable(false);
        this.cCache.setReadable(true);
        this.cCache.setWritable(true);
        return this.cCache;
    }

    private void cleanup() {
        boolean delete;
        if (this.cCache != null && this.cCache.exists() && !(delete = this.cCache.delete())) {
            throw new RuntimeException("File delete error!");
        }
        this.tgtTicket = null;
        this.krbToken = null;
    }

    private void throwWith(String error, Exception cause) throws LoginException {
        LoginException le = new LoginException(error);
        le.initCause(cause);
        throw le;
    }
}

