/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.util.InstrumentedLock;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InstrumentedWriteLock
extends InstrumentedLock {
    private final ReentrantReadWriteLock readWriteLock;
    private volatile long writeLockHeldTimeStamp = 0L;

    public InstrumentedWriteLock(String name, Logger logger, ReentrantReadWriteLock readWriteLock, long minLoggingGapMs, long lockWarningThresholdMs) {
        this(name, logger, readWriteLock, minLoggingGapMs, lockWarningThresholdMs, new Timer());
    }

    @VisibleForTesting
    InstrumentedWriteLock(String name, Logger logger, ReentrantReadWriteLock readWriteLock, long minLoggingGapMs, long lockWarningThresholdMs, Timer clock) {
        super(name, logger, readWriteLock.writeLock(), minLoggingGapMs, lockWarningThresholdMs, clock);
        this.readWriteLock = readWriteLock;
    }

    @Override
    public void unlock() {
        boolean needReport = this.readWriteLock.getWriteHoldCount() == 1;
        long localWriteReleaseTime = this.getTimer().monotonicNow();
        long localWriteAcquireTime = this.writeLockHeldTimeStamp;
        this.getLock().unlock();
        if (needReport) {
            this.writeLockHeldTimeStamp = 0L;
            this.check(localWriteAcquireTime, localWriteReleaseTime, true);
        }
    }

    @Override
    protected void startLockTiming() {
        if (this.readWriteLock.getWriteHoldCount() == 1) {
            this.writeLockHeldTimeStamp = this.getTimer().monotonicNow();
        }
    }
}

