/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.support;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BasicContainer;
import org.mp4parser.BoxParser;
import org.mp4parser.Container;
import org.mp4parser.ParsableBox;
import org.mp4parser.tools.IsoTypeWriter;

public class AbstractContainerBox
extends BasicContainer
implements ParsableBox {
    protected String type;
    protected boolean largeBox;
    Container parent;

    public AbstractContainerBox(String type) {
        this.type = type;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    @Override
    public long getSize() {
        long s = this.getContainerSize();
        return s + (long)(this.largeBox || s + 8L >= 0x100000000L ? 16 : 8);
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected ByteBuffer getHeader() {
        ByteBuffer header;
        if (this.largeBox || this.getSize() >= 0x100000000L) {
            byte[] byArray = new byte[16];
            byArray[3] = 1;
            byArray[4] = this.type.getBytes()[0];
            byArray[5] = this.type.getBytes()[1];
            byArray[6] = this.type.getBytes()[2];
            byArray[7] = this.type.getBytes()[3];
            header = ByteBuffer.wrap(byArray);
            ((Buffer)header).position(8);
            IsoTypeWriter.writeUInt64(header, this.getSize());
        } else {
            byte[] byArray = new byte[8];
            byArray[4] = this.type.getBytes()[0];
            byArray[5] = this.type.getBytes()[1];
            byArray[6] = this.type.getBytes()[2];
            byArray[7] = this.type.getBytes()[3];
            header = ByteBuffer.wrap(byArray);
            IsoTypeWriter.writeUInt32(header, this.getSize());
        }
        ((Buffer)header).rewind();
        return header;
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.largeBox = header.remaining() == 16;
        this.initContainer(dataSource, contentSize, boxParser);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        this.writeContainer(writableByteChannel);
    }
}

