/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene80;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.backward_codecs.lucene80.IndexedDISI;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;

final class Lucene80NormsProducer
extends NormsProducer
implements Cloneable {
    private final Map<Integer, NormsEntry> norms;
    private final int maxDoc;
    private IndexInput data;
    private boolean merging;
    private Map<Integer, IndexInput> disiInputs;
    private Map<Integer, RandomAccessInput> disiJumpTables;
    private Map<Integer, RandomAccessInput> dataInputs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene80NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block14: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            version = -1;
            try (ChecksumIndexInput in = EndiannessReverserUtil.openChecksumInput(state.directory, metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields((IndexInput)in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = EndiannessReverserUtil.openInput(state.directory, dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    public NormsProducer getMergeInstance() {
        Lucene80NormsProducer clone;
        try {
            clone = (Lucene80NormsProducer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.data = this.data.clone();
        clone.disiInputs = new HashMap<Integer, IndexInput>();
        clone.disiJumpTables = new HashMap<Integer, RandomAccessInput>();
        clone.dataInputs = new HashMap<Integer, RandomAccessInput>();
        clone.merging = true;
        return clone;
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name, (DataInput)meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.docsWithFieldOffset = meta.readLong();
            entry.docsWithFieldLength = meta.readLong();
            entry.jumpTableEntryCount = meta.readShort();
            entry.denseRankPower = meta.readByte();
            entry.numDocsWithField = meta.readInt();
            entry.bytesPerNorm = meta.readByte();
            switch (entry.bytesPerNorm) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + entry.bytesPerNorm + ", field: " + info.name, (DataInput)meta);
                }
            }
            entry.normsOffset = meta.readLong();
            this.norms.put(info.number, entry);
            fieldNumber = meta.readInt();
        }
    }

    private RandomAccessInput getDataInput(FieldInfo field, NormsEntry entry) throws IOException {
        RandomAccessInput slice = null;
        if (this.merging) {
            slice = this.dataInputs.get(field.number);
        }
        if (slice == null) {
            slice = this.data.randomAccessSlice(entry.normsOffset, (long)entry.numDocsWithField * (long)entry.bytesPerNorm);
            if (this.merging) {
                this.dataInputs.put(field.number, slice);
            }
        }
        return slice;
    }

    private IndexInput getDisiInput(FieldInfo field, NormsEntry entry) throws IOException {
        if (!this.merging) {
            return IndexedDISI.createBlockSlice(this.data, "docs", entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount);
        }
        IndexInput in = this.disiInputs.get(field.number);
        if (in == null) {
            in = IndexedDISI.createBlockSlice(this.data, "docs", entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount);
            this.disiInputs.put(field.number, in);
        }
        final IndexInput inF = in;
        return new IndexInput("docs"){
            long offset;
            {
                super(arg0);
                this.offset = 0L;
            }

            public void readBytes(byte[] b, int off, int len) throws IOException {
                inF.seek(this.offset);
                this.offset += (long)len;
                inF.readBytes(b, off, len);
            }

            public byte readByte() throws IOException {
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }

            public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }

            public short readShort() throws IOException {
                inF.seek(this.offset);
                this.offset += 2L;
                return inF.readShort();
            }

            public long readLong() throws IOException {
                inF.seek(this.offset);
                this.offset += 8L;
                return inF.readLong();
            }

            public void seek(long pos) throws IOException {
                this.offset = pos;
            }

            public long length() {
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }

            public long getFilePointer() {
                return this.offset;
            }

            public void close() throws IOException {
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }
        };
    }

    private RandomAccessInput getDisiJumpTable(FieldInfo field, NormsEntry entry) throws IOException {
        RandomAccessInput jumpTable = null;
        if (this.merging) {
            jumpTable = this.disiJumpTables.get(field.number);
        }
        if (jumpTable == null) {
            jumpTable = IndexedDISI.createJumpTable(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount);
            if (this.merging) {
                this.disiJumpTables.put(field.number, jumpTable);
            }
        }
        return jumpTable;
    }

    public NumericDocValues getNorms(FieldInfo field) throws IOException {
        final NormsEntry entry = this.norms.get(field.number);
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.bytesPerNorm == 0) {
                return new DenseNormsIterator(this.maxDoc){

                    public long longValue() throws IOException {
                        return entry.normsOffset;
                    }
                };
            }
            final RandomAccessInput slice = this.getDataInput(field, entry);
            switch (entry.bytesPerNorm) {
                case 1: {
                    return new DenseNormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readByte((long)this.doc);
                        }
                    };
                }
                case 2: {
                    return new DenseNormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readShort((long)this.doc << 1);
                        }
                    };
                }
                case 4: {
                    return new DenseNormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readInt((long)this.doc << 2);
                        }
                    };
                }
                case 8: {
                    return new DenseNormsIterator(this.maxDoc){

                        public long longValue() throws IOException {
                            return slice.readLong((long)this.doc << 3);
                        }
                    };
                }
            }
            throw new AssertionError();
        }
        IndexInput disiInput = this.getDisiInput(field, entry);
        RandomAccessInput disiJumpTable = this.getDisiJumpTable(field, entry);
        IndexedDISI disi = new IndexedDISI(disiInput, disiJumpTable, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        if (entry.bytesPerNorm == 0) {
            return new SparseNormsIterator(disi){

                public long longValue() throws IOException {
                    return entry.normsOffset;
                }
            };
        }
        final RandomAccessInput slice = this.getDataInput(field, entry);
        switch (entry.bytesPerNorm) {
            case 1: {
                return new SparseNormsIterator(disi){

                    public long longValue() throws IOException {
                        return slice.readByte((long)this.disi.index());
                    }
                };
            }
            case 2: {
                return new SparseNormsIterator(disi){

                    public long longValue() throws IOException {
                        return slice.readShort((long)this.disi.index() << 1);
                    }
                };
            }
            case 4: {
                return new SparseNormsIterator(disi){

                    public long longValue() throws IOException {
                        return slice.readInt((long)this.disi.index() << 2);
                    }
                };
            }
            case 8: {
                return new SparseNormsIterator(disi){

                    public long longValue() throws IOException {
                        return slice.readLong((long)this.disi.index() << 3);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public void close() throws IOException {
        this.data.close();
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    static abstract class SparseNormsIterator
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNormsIterator(IndexedDISI disi) {
            this.disi = disi;
        }

        public int docID() {
            return this.disi.docID();
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        public long cost() {
            return this.disi.cost();
        }
    }

    static abstract class DenseNormsIterator
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNormsIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }

        public long cost() {
            return this.maxDoc;
        }
    }

    static class NormsEntry {
        byte denseRankPower;
        byte bytesPerNorm;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        int numDocsWithField;
        long normsOffset;

        NormsEntry() {
        }
    }
}

