/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.util.ScopedName;

final class GeometryConverter<R, G>
extends Node
implements Optimization.OnExpression<R, GeometryWrapper<G>> {
    private static final long serialVersionUID = 1164523020740782044L;
    private static final ScopedName NAME = GeometryConverter.createName("GeometryConverter");
    final Geometries<G> library;
    final Expression<? super R, ?> expression;

    public GeometryConverter(Geometries<G> geometries, Expression<? super R, ?> expression) {
        ArgumentChecks.ensureNonNull("expression", expression);
        ArgumentChecks.ensureNonNull("library", geometries);
        this.expression = expression;
        this.library = geometries;
    }

    @Override
    public Expression<R, GeometryWrapper<G>> recreate(Expression<? super R, ?>[] expressionArray) {
        return new GeometryConverter<R, G>(this.library, expressionArray[0]);
    }

    @Override
    public ScopedName getFunctionName() {
        return NAME;
    }

    @Override
    public List<Expression<? super R, ?>> getParameters() {
        return Collections.singletonList(this.expression);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getParameters();
    }

    @Override
    public GeometryWrapper<G> apply(R r) {
        ImmutableEnvelope immutableEnvelope;
        Object obj = this.expression.apply(r);
        if (obj instanceof GeographicBoundingBox) {
            immutableEnvelope = new ImmutableEnvelope((GeographicBoundingBox)obj);
        } else if (obj instanceof Envelope) {
            immutableEnvelope = (Envelope)obj;
        } else {
            try {
                return this.library.castOrWrap(obj);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(Errors.format((short)50, this.library.rootClass, Classes.getClass(obj)), classCastException);
            }
        }
        return this.library.toGeometry2D((Envelope)immutableEnvelope, WraparoundMethod.NONE);
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> clazz) {
        if (clazz.isAssignableFrom(this.library.rootClass)) {
            return this.expression;
        }
        if (clazz.isAssignableFrom(GeometryWrapper.class)) {
            return this;
        }
        throw new ClassCastException(Errors.format((short)163, clazz));
    }
}

