/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * SPDX-License-Identifier: MIT
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_ATOMIC_MEM},
	{88, PKT3_OCCLUSION_QUERY},
	{104, PKT3_SET_PREDICATION},
	{120, PKT3_COND_EXEC},
	{130, PKT3_PRED_EXEC},
	{140, PKT3_DRAW_INDIRECT},
	{154, PKT3_DRAW_INDEX_INDIRECT},
	{174, PKT3_INDEX_BASE},
	{185, PKT3_DRAW_INDEX_2},
	{198, PKT3_CONTEXT_CONTROL},
	{214, PKT3_INDEX_TYPE},
	{225, PKT3_DRAW_INDIRECT_MULTI},
	{245, PKT3_DRAW_INDEX_AUTO},
	{261, PKT3_DRAW_INDEX_IMMD},
	{277, PKT3_NUM_INSTANCES},
	{291, PKT3_DRAW_INDEX_MULTI_AUTO},
	{313, PKT3_INDIRECT_BUFFER_SI},
	{332, PKT3_INDIRECT_BUFFER_CONST},
	{354, PKT3_STRMOUT_BUFFER_UPDATE},
	{376, PKT3_DRAW_INDEX_OFFSET_2},
	{396, PKT3_WRITE_DATA},
	{407, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{433, PKT3_MEM_SEMAPHORE},
	{447, PKT3_MPEG_INDEX},
	{458, PKT3_WAIT_REG_MEM},
	{471, PKT3_MEM_WRITE},
	{481, PKT3_INDIRECT_BUFFER},
	{497, PKT3_COPY_DATA},
	{507, PKT3_CP_DMA},
	{514, PKT3_PFP_SYNC_ME},
	{526, PKT3_SURFACE_SYNC},
	{539, PKT3_ME_INITIALIZE},
	{553, PKT3_COND_WRITE},
	{564, PKT3_EVENT_WRITE},
	{576, PKT3_EVENT_WRITE_EOP},
	{592, PKT3_EVENT_WRITE_EOS},
	{592, PKT3_EVENT_WRITE_EOS},
	{608, PKT3_RELEASE_MEM},
	{620, PKT3_DISPATCH_MESH_INDIRECT_MULTI},
	{649, PKT3_DISPATCH_TASKMESH_GFX},
	{671, PKT3_DISPATCH_MESH_DIRECT},
	{692, PKT3_DMA_DATA},
	{701, PKT3_CONTEXT_REG_RMW},
	{717, PKT3_ONE_REG_WRITE},
	{731, PKT3_ACQUIRE_MEM},
	{743, PKT3_REWIND},
	{750, PKT3_PRIME_UTCL2},
	{762, PKT3_LOAD_UCONFIG_REG},
	{779, PKT3_LOAD_SH_REG},
	{791, PKT3_LOAD_CONTEXT_REG},
	{808, PKT3_LOAD_SH_REG_INDEX},
	{826, PKT3_SET_CONFIG_REG},
	{841, PKT3_SET_CONTEXT_REG},
	{857, PKT3_SET_SH_REG},
	{868, PKT3_SET_SH_REG_OFFSET},
	{886, PKT3_SET_UCONFIG_REG},
	{902, PKT3_SET_UCONFIG_REG_INDEX},
	{924, PKT3_LOAD_CONST_RAM},
	{939, PKT3_WRITE_CONST_RAM},
	{955, PKT3_DUMP_CONST_RAM},
	{970, PKT3_INCREMENT_CE_COUNTER},
	{991, PKT3_INCREMENT_DE_COUNTER},
	{1012, PKT3_WAIT_ON_CE_COUNTER},
	{1031, PKT3_SET_SH_REG_INDEX},
	{1048, PKT3_LOAD_CONTEXT_REG_INDEX},
	{1071, PKT3_DISPATCH_TASK_STATE_INIT},
	{1096, PKT3_DISPATCH_TASKMESH_DIRECT_ACE},
	{1125, PKT3_DISPATCH_TASKMESH_INDIRECT_MULTI_ACE},
	{1162, PKT3_EVENT_WRITE_ZPASS},
	{1180, PKT3_SET_CONTEXT_REG_PAIRS},
	{1202, PKT3_SET_CONTEXT_REG_PAIRS_PACKED},
	{1231, PKT3_SET_SH_REG_PAIRS},
	{1248, PKT3_SET_SH_REG_PAIRS_PACKED},
	{1272, PKT3_SET_SH_REG_PAIRS_PACKED_N},
	{1298, PKT3_IT_OPCODE_C},
};

static const struct si_reg gfx10_reg_table[] = {
	{1310, 1028, 10, 0},
	{1323, 1032, 20, 10},
	{1338, 1036, 10, 30},
	{1354, 1040, 12, 40},
	{1375, 1044, 4, 52},
	{1393, 1048, 3, 56},
	{1411, 1052, 11, 59},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1454, 1064},
	{1471, 1076, 9, 71},
	{1487, 1080},
	{1504, 1116, 5, 80},
	{1519, 1120, 7, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1573, 1132, 4, 95},
	{1593, 1136, 7, 99},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1882, 2560},
	{1906, 2564},
	{1930, 2568},
	{1954, 32776, 27, 106},
	{1967, 32784, 21, 133},
	{1979, 32788, 14, 154},
	{1995, 32792, 14, 154},
	{2011, 32796, 15, 168},
	{2024, 32824, 14, 154},
	{2040, 32828, 14, 154},
	{2056, 33296, 21, 183},
	{2070, 33300, 28, 204},
	{2087, 33304, 15, 232},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 9, 333},
	{2283, 33436, 1, 342},
	{2306, 36096},
	{2332, 36100, 2, 343},
	{2358, 36104},
	{2384, 36108, 2, 343},
	{2410, 36112, 2, 345},
	{2431, 36116, 4, 347},
	{2452, 36120, 4, 351},
	{2479, 36124, 17, 355},
	{2500, 36128, 6, 372},
	{2523, 36132},
	{2552, 36140},
	{2582, 36144},
	{2614, 36148},
	{2645, 36152},
	{2678, 36348, 5, 378},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 10, 387},
	{2759, 36656, 14, 397},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 415},
	{2813, 36668, 2, 424},
	{2831, 37120, 9, 426},
	{2847, 39160, 5, 435},
	{2862, 39184, 5, 440},
	{2876, 39188, 5, 440},
	{2890, 39192, 5, 440},
	{2904, 39196, 5, 440},
	{2918, 39200, 5, 440},
	{2932, 39204, 5, 440},
	{2946, 39208, 5, 440},
	{2960, 39212, 5, 440},
	{2974, 39216, 5, 440},
	{2988, 39220, 5, 440},
	{3002, 39224, 5, 440},
	{3017, 39228, 5, 440},
	{3032, 39232, 5, 440},
	{3047, 39236, 5, 440},
	{3062, 39240, 5, 440},
	{3077, 39244, 5, 440},
	{3092, 39248, 5, 440},
	{3107, 39252, 5, 440},
	{3122, 39256, 5, 440},
	{3137, 39260, 5, 440},
	{3152, 39264, 5, 440},
	{3167, 39268, 5, 440},
	{3182, 39272, 5, 440},
	{3197, 39276, 5, 440},
	{3212, 39280, 5, 440},
	{3227, 39284, 5, 440},
	{3242, 39288, 5, 440},
	{3257, 39292, 5, 440},
	{3272, 39296, 5, 440},
	{3287, 39300, 5, 440},
	{3302, 39304, 5, 440},
	{3317, 39308, 5, 440},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{3642, 40960},
	{3660, 40964, 4, 449},
	{3678, 40968, 3, 453},
	{3696, 40972, 9, 456},
	{3714, 40976, 2, 465},
	{3732, 40980, 7, 467},
	{3750, 40984, 10, 474},
	{3768, 40988},
	{3786, 45060, 1, 484},
	{3810, 45080},
	{3835, 45084, 3, 485},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 489},
	{3925, 45100, 10, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{4371, 45168},
	{4398, 45172},
	{4425, 45176},
	{4452, 45180},
	{4479, 45184},
	{4506, 45188},
	{4533, 45192},
	{4560, 45196},
	{4587, 45200},
	{4614, 45204},
	{4641, 45208},
	{4668, 45212},
	{4695, 45216},
	{4722, 45220},
	{4749, 45224},
	{4776, 45228},
	{4803, 45248, 8, 510},
	{4826, 45252, 5, 518},
	{4859, 45256, 1, 523},
	{4886, 45260, 1, 523},
	{4913, 45264, 1, 523},
	{4940, 45268, 1, 523},
	{4967, 45316, 1, 484},
	{4991, 45332},
	{5016, 45336, 3, 485},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 525},
	{5131, 45356, 14, 537},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{5577, 45424},
	{5604, 45428},
	{5631, 45432},
	{5658, 45436},
	{5685, 45440},
	{5712, 45444},
	{5739, 45448},
	{5766, 45452},
	{5793, 45456},
	{5820, 45460},
	{5847, 45464},
	{5874, 45468},
	{5901, 45472},
	{5928, 45476},
	{5955, 45480},
	{5982, 45484},
	{6009, 45504, 8, 510},
	{6032, 45508, 5, 518},
	{6065, 45512, 1, 523},
	{6092, 45516, 1, 523},
	{6119, 45520, 1, 523},
	{6146, 45524, 1, 523},
	{6173, 45548, 9, 551},
	{6200, 45552, 6, 560},
	{6227, 45556, 5, 566},
	{6254, 45568},
	{6279, 45572, 2, 571},
	{6303, 45576},
	{6335, 45580},
	{6367, 45584},
	{6391, 45588, 1, 488},
	{6415, 45596, 4, 573},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 13, 577},
	{6505, 45612, 9, 590},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{6951, 45680},
	{6978, 45684},
	{7005, 45688},
	{7032, 45692},
	{7059, 45696},
	{7086, 45700},
	{7113, 45704},
	{7140, 45708},
	{7167, 45712},
	{7194, 45716},
	{7221, 45720},
	{7248, 45724},
	{7275, 45728},
	{7302, 45732},
	{7329, 45736},
	{7356, 45740},
	{7383, 45760, 8, 510},
	{7408, 45764, 5, 518},
	{7443, 45768, 1, 523},
	{7472, 45772, 1, 523},
	{7501, 45776, 1, 523},
	{7530, 45780, 1, 523},
	{7559, 45808, 6, 560},
	{7586, 45852, 4, 573},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{7652, 45864, 10, 599},
	{7676, 45868, 6, 560},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{8122, 46068, 5, 566},
	{8149, 46080},
	{8174, 46084, 1, 484},
	{8198, 46088},
	{8230, 46092},
	{8262, 46096},
	{8286, 46100, 1, 488},
	{8310, 46108, 4, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 12, 613},
	{8400, 46124, 9, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{8846, 46192},
	{8873, 46196},
	{8900, 46200},
	{8927, 46204},
	{8954, 46208},
	{8981, 46212},
	{9008, 46216},
	{9035, 46220},
	{9062, 46224},
	{9089, 46228},
	{9116, 46232},
	{9143, 46236},
	{9170, 46240},
	{9197, 46244},
	{9224, 46248},
	{9251, 46252},
	{9278, 46272, 8, 510},
	{9303, 46276, 5, 518},
	{9338, 46280, 1, 523},
	{9367, 46284, 1, 523},
	{9396, 46288, 1, 523},
	{9425, 46292, 1, 523},
	{9454, 46324, 5, 566},
	{9481, 46364, 4, 573},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{9547, 46376, 9, 634},
	{9571, 46380, 5, 566},
	{9595, 46384},
	{9621, 46388},
	{9647, 46392},
	{9673, 46396},
	{9699, 46400},
	{9725, 46404},
	{9751, 46408},
	{9777, 46412},
	{9803, 46416},
	{9829, 46420},
	{9855, 46424},
	{9882, 46428},
	{9909, 46432},
	{9936, 46436},
	{9963, 46440},
	{9990, 46444},
	{10017, 47104, 13, 643},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 1, 660},
	{10280, 47160},
	{10309, 47164, 1, 660},
	{10338, 47168},
	{10371, 47172, 1, 660},
	{10404, 47176, 12, 661},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{10477, 47192},
	{10504, 47196},
	{10531, 47200, 2, 691},
	{10552, 47204},
	{10579, 47208},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 5, 694},
	{10710, 47232},
	{10730, 47236},
	{10753, 47240, 9, 699},
	{10770, 47248, 1, 523},
	{10791, 47252, 1, 523},
	{10812, 47256, 1, 523},
	{10833, 47260, 1, 523},
	{10854, 47264, 1, 708},
	{10872, 47268, 1, 709},
	{10891, 47272},
	{10913, 47276, 3, 710},
	{10930, 47280},
	{10959, 47284, 1, 713},
	{10988, 47288, 3, 710},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11332, 47604, 2, 714},
	{11356, 47608},
	{11377, 47612},
	{11393, 163840, 10, 716},
	{11411, 163844, 11, 726},
	{11428, 163848, 7, 737},
	{11442, 163852, 23, 744},
	{11461, 163856, 16, 767},
	{11481, 163860},
	{11500, 163868, 2, 783},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{11637, 163896, 3, 790},
	{11653, 163900, 8, 793},
	{11671, 163904, 14, 801},
	{11681, 163908, 9, 815},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{11771, 163928, 2, 824},
	{11789, 163932, 1, 826},
	{11807, 163944, 1, 827},
	{11825, 163948, 1, 827},
	{11849, 163952, 1, 827},
	{11868, 163956, 1, 827},
	{11893, 163960, 1, 827},
	{11915, 163964, 9, 828},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14004, 164700, 7, 892},
	{14033, 164704, 1, 899},
	{14054, 164708, 1, 900},
	{14064, 164712, 1, 901},
	{14072, 164768, 4, 902},
	{14094, 164772, 4, 902},
	{14115, 164776, 4, 906},
	{14132, 164864},
	{14149, 164868},
	{14166, 164872},
	{14182, 164876},
	{14211, 164880, 10, 910},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14293, 164900, 8, 920},
	{14308, 164904, 4, 928},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16814, 165404},
	{16837, 165444, 12, 946},
	{16857, 165448, 12, 946},
	{16877, 165452, 12, 946},
	{16897, 165456, 12, 946},
	{16917, 165460, 12, 946},
	{16937, 165464, 12, 946},
	{16957, 165468, 12, 946},
	{16977, 165472, 12, 946},
	{16997, 165476, 12, 946},
	{17017, 165480, 12, 946},
	{17037, 165484, 12, 946},
	{17058, 165488, 12, 946},
	{17079, 165492, 12, 946},
	{17100, 165496, 12, 946},
	{17121, 165500, 12, 946},
	{17142, 165504, 12, 946},
	{17163, 165508, 12, 946},
	{17184, 165512, 12, 946},
	{17205, 165516, 12, 946},
	{17226, 165520, 12, 946},
	{17247, 165524, 9, 958},
	{17268, 165528, 9, 958},
	{17289, 165532, 9, 958},
	{17310, 165536, 9, 958},
	{17331, 165540, 9, 958},
	{17352, 165544, 9, 958},
	{17373, 165548, 9, 958},
	{17394, 165552, 9, 958},
	{17415, 165556, 9, 958},
	{17436, 165560, 9, 958},
	{17457, 165564, 9, 958},
	{17478, 165568, 9, 958},
	{17499, 165572, 3, 967},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 6, 993},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17623, 165640, 1, 1006},
	{17645, 165644, 5, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{17709, 165716, 8, 1021},
	{17727, 165720, 8, 1029},
	{17748, 165724, 17, 1037},
	{17769, 165728, 6, 1054},
	{17787, 165732, 6, 1054},
	{17805, 165736, 6, 1054},
	{17823, 165740, 6, 1054},
	{17841, 165744, 6, 1054},
	{17859, 165748, 6, 1054},
	{17877, 165752, 6, 1054},
	{17895, 165756, 6, 1054},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 1070},
	{18176, 165864},
	{18189, 165872, 8, 1071},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18245, 165884, 1, 1080},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 4, 1103},
	{18314, 165900, 17, 1107},
	{18332, 165904, 20, 1124},
	{18348, 165908, 16, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 28, 1170},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18490, 165936, 7, 1229},
	{18519, 165940, 2, 1236},
	{18541, 165944, 2, 1238},
	{18556, 165948, 5, 1240},
	{18586, 165952, 5, 1245},
	{18601, 165956},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 1262},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 1282},
	{18954, 166468, 3, 1297},
	{18973, 166472, 7, 1300},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 1335},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 8, 1340},
	{19213, 166528},
	{19224, 166532, 3, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 1351},
	{19307, 166548, 2, 1354},
	{19334, 166552, 5, 1356},
	{19356, 166560},
	{19381, 166564},
	{19406, 166568, 6, 1361},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 9, 1370},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20038, 166732, 2, 1394},
	{20057, 166736, 5, 1396},
	{20079, 166740, 19, 1401},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 12, 1423},
	{20220, 166768, 6, 1435},
	{20237, 166772},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 3, 1443},
	{20455, 166804, 8, 1446},
	{20474, 166808, 4, 1454},
	{20500, 166812, 3, 1351},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 5, 1474},
	{20592, 166880, 6, 1479},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21307, 166976, 4, 1524},
	{21328, 166980, 12, 1528},
	{21348, 166984, 2, 1540},
	{21368, 166988, 20, 1542},
	{21406, 166992, 2, 1562},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{21490, 167012, 2, 1566},
	{21506, 167016, 1, 1568},
	{21522, 167020, 3, 1569},
	{21537, 167024, 19, 1572},
	{21552, 167028, 8, 1591},
	{21569, 167032, 12, 1599},
	{21591, 167036},
	{21607, 167040, 1, 1611},
	{21629, 167044},
	{21645, 167048, 1, 1568},
	{21667, 167052},
	{21689, 167056},
	{21711, 167060},
	{21730, 167068},
	{21745, 167072, 2, 1566},
	{21761, 167076, 1, 1568},
	{21777, 167080, 3, 1569},
	{21792, 167084, 19, 1572},
	{21807, 167088, 8, 1591},
	{21824, 167092, 12, 1599},
	{21846, 167096},
	{21862, 167100, 1, 1611},
	{21884, 167104},
	{21900, 167108, 1, 1568},
	{21922, 167112},
	{21944, 167116},
	{21966, 167120},
	{21985, 167128},
	{22000, 167132, 2, 1566},
	{22016, 167136, 1, 1568},
	{22032, 167140, 3, 1569},
	{22047, 167144, 19, 1572},
	{22062, 167148, 8, 1591},
	{22079, 167152, 12, 1599},
	{22101, 167156},
	{22117, 167160, 1, 1611},
	{22139, 167164},
	{22155, 167168, 1, 1568},
	{22177, 167172},
	{22199, 167176},
	{22221, 167180},
	{22240, 167188},
	{22255, 167192, 2, 1566},
	{22271, 167196, 1, 1568},
	{22287, 167200, 3, 1569},
	{22302, 167204, 19, 1572},
	{22317, 167208, 8, 1591},
	{22334, 167212, 12, 1599},
	{22356, 167216},
	{22372, 167220, 1, 1611},
	{22394, 167224},
	{22410, 167228, 1, 1568},
	{22432, 167232},
	{22454, 167236},
	{22476, 167240},
	{22495, 167248},
	{22510, 167252, 2, 1566},
	{22526, 167256, 1, 1568},
	{22542, 167260, 3, 1569},
	{22557, 167264, 19, 1572},
	{22572, 167268, 8, 1591},
	{22589, 167272, 12, 1599},
	{22611, 167276},
	{22627, 167280, 1, 1611},
	{22649, 167284},
	{22665, 167288, 1, 1568},
	{22687, 167292},
	{22709, 167296},
	{22731, 167300},
	{22750, 167308},
	{22765, 167312, 2, 1566},
	{22781, 167316, 1, 1568},
	{22797, 167320, 3, 1569},
	{22812, 167324, 19, 1572},
	{22827, 167328, 8, 1591},
	{22844, 167332, 12, 1599},
	{22866, 167336},
	{22882, 167340, 1, 1611},
	{22904, 167344},
	{22920, 167348, 1, 1568},
	{22942, 167352},
	{22964, 167356},
	{22986, 167360},
	{23005, 167368},
	{23020, 167372, 2, 1566},
	{23036, 167376, 1, 1568},
	{23052, 167380, 3, 1569},
	{23067, 167384, 19, 1572},
	{23082, 167388, 8, 1591},
	{23099, 167392, 12, 1599},
	{23121, 167396},
	{23137, 167400, 1, 1611},
	{23159, 167404},
	{23175, 167408, 1, 1568},
	{23197, 167412},
	{23219, 167416},
	{23241, 167420},
	{23260, 167428},
	{23275, 167432, 2, 1566},
	{23291, 167436, 1, 1568},
	{23307, 167440, 3, 1569},
	{23322, 167444, 19, 1572},
	{23337, 167448, 8, 1591},
	{23354, 167452, 12, 1599},
	{23376, 167456},
	{23392, 167460, 1, 1611},
	{23414, 167464},
	{23430, 167468, 1, 1568},
	{23452, 167472},
	{23474, 167476},
	{23496, 167480},
	{23515, 167488, 1, 1612},
	{23534, 167492, 1, 1612},
	{23553, 167496, 1, 1612},
	{23572, 167500, 1, 1612},
	{23591, 167504, 1, 1612},
	{23610, 167508, 1, 1612},
	{23629, 167512, 1, 1612},
	{23648, 167516, 1, 1612},
	{23667, 167520, 1, 1612},
	{23692, 167524, 1, 1612},
	{23717, 167528, 1, 1612},
	{23742, 167532, 1, 1612},
	{23767, 167536, 1, 1612},
	{23792, 167540, 1, 1612},
	{23817, 167544, 1, 1612},
	{23842, 167548, 1, 1612},
	{23867, 167552, 1, 1612},
	{23892, 167556, 1, 1612},
	{23917, 167560, 1, 1612},
	{23942, 167564, 1, 1612},
	{23967, 167568, 1, 1612},
	{23992, 167572, 1, 1612},
	{24017, 167576, 1, 1612},
	{24042, 167580, 1, 1612},
	{24067, 167584, 1, 1612},
	{24090, 167588, 1, 1612},
	{24113, 167592, 1, 1612},
	{24136, 167596, 1, 1612},
	{24159, 167600, 1, 1612},
	{24182, 167604, 1, 1612},
	{24205, 167608, 1, 1612},
	{24228, 167612, 1, 1612},
	{24251, 167616, 3, 1613},
	{24269, 167620, 3, 1613},
	{24287, 167624, 3, 1613},
	{24305, 167628, 3, 1613},
	{24323, 167632, 3, 1613},
	{24341, 167636, 3, 1613},
	{24359, 167640, 3, 1613},
	{24377, 167644, 3, 1613},
	{24395, 167648, 8, 1616},
	{24413, 167652, 8, 1616},
	{24431, 167656, 8, 1616},
	{24449, 167660, 8, 1616},
	{24467, 167664, 8, 1616},
	{24485, 167668, 8, 1616},
	{24503, 167672, 8, 1616},
	{24521, 167676, 8, 1616},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{24661, 196632, 1, 1626},
	{24683, 196636, 1, 1627},
	{24705, 196640},
	{24735, 196644},
	{24765, 196648},
	{24794, 196652},
	{24823, 196656},
	{24853, 196660},
	{24883, 196664},
	{24912, 196668},
	{24941, 196672},
	{24971, 196676},
	{25001, 196680},
	{25030, 196684},
	{25059, 196688},
	{25089, 196692},
	{25119, 196696},
	{25148, 196700},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{25781, 196808, 1, 1630},
	{25802, 196812, 1, 1630},
	{25825, 196816, 1, 1630},
	{25841, 196852, 1, 1631},
	{25863, 196856, 1, 1631},
	{25885, 196860, 1, 1632},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{26005, 196896, 1, 1630},
	{26028, 196908, 1, 660},
	{26047, 196912},
	{26065, 196916},
	{26092, 196920},
	{26119, 196928, 2, 1633},
	{26132, 196932},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 4, 1636},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 1, 1640},
	{26554, 197032, 2, 1641},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 1, 1643},
	{26626, 197048, 2, 1644},
	{26644, 197052},
	{26662, 197056, 2, 1646},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 1646},
	{26744, 197080, 5, 1648},
	{26764, 197084, 7, 1653},
	{26783, 197088, 7, 1653},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 13, 1662},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 2, 1675},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 7, 1679},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 7, 1679},
	{27102, 197160, 7, 1686},
	{27114, 197164, 2, 1693},
	{27131, 197168, 1, 1695},
	{27148, 197172, 1, 1696},
	{27166, 197176, 4, 1697},
	{27186, 197180, 2, 1701},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27232, 197192, 1, 1704},
	{27246, 197196, 1, 1705},
	{27260, 197200, 1, 1706},
	{27282, 197204, 1, 1707},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27344, 197216, 1, 1704},
	{27361, 197220, 1, 1705},
	{27378, 197224},
	{27392, 197232, 2, 1710},
	{27414, 197236, 2, 1712},
	{27436, 197240, 2, 1710},
	{27459, 197244, 2, 1712},
	{27482, 197248, 2, 1710},
	{27504, 197252, 2, 1712},
	{27526, 197364, 1, 1714},
	{27547, 197368, 1, 1715},
	{27567, 197372, 1, 1716},
	{27587, 197376, 1, 1715},
	{27604, 197380, 1, 1716},
	{27621, 197384, 1, 1717},
	{27637, 197388, 1, 1718},
	{27656, 197392, 1, 1719},
	{27675, 197396, 1, 1720},
	{27692, 197400, 1, 1721},
	{27710, 197404, 1, 1722},
	{27728, 197408, 1, 1723},
	{27744, 197412, 1, 1724},
	{27762, 197416, 1, 1725},
	{27780, 197420, 1, 1726},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 4, 1730},
	{27945, 197464, 3, 1734},
	{27967, 197468, 1, 1737},
	{27987, 197472, 1, 1738},
	{28001, 197476, 1, 1739},
	{28015, 197480, 1, 1740},
	{28027, 197484, 1, 1741},
	{28043, 197488, 1, 1738},
	{28060, 197492, 1, 1739},
	{28077, 197496, 1, 1740},
	{28092, 197500, 1, 1741},
	{28111, 197552, 1, 1742},
	{28136, 197556, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28235, 197576},
	{28260, 197580, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28493, 197624, 13, 1752},
	{28510, 197628},
	{28527, 197632, 1, 1695},
	{28547, 197636},
	{28564, 197640, 1, 1660},
	{28584, 197644, 2, 1765},
	{28603, 197888, 8, 1767},
	{28624, 197892, 8, 1767},
	{28645, 198656, 6, 1775},
	{28660, 198912},
	{28679, 198916},
	{28698, 198920, 1, 1781},
	{28717, 198924, 1, 1340},
	{28732, 198928},
	{28765, 198932},
	{28798, 198936},
	{28831, 198940},
	{28864, 198948},
	{28880, 198952},
	{28895, 198956, 2, 1354},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 1782},
	{28972, 198972, 2, 1783},
	{28993, 198976},
	{29012, 198980},
	{29031, 198984},
	{29047, 198988, 1, 827},
	{29066, 198992},
	{29086, 198996, 1, 827},
	{29109, 199000},
	{29127, 199004, 1, 827},
	{29148, 199008, 9, 1785},
	{29173, 199012},
	{29189, 199016},
	{29210, 199020, 4, 1794},
	{29218, 199024},
	{29232, 199028},
	{29246, 199032},
	{29260, 199036, 3, 1798},
	{29275, 199040, 2, 1801},
	{29287, 199044, 1, 827},
	{29309, 199048, 3, 1803},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{29983, 199952},
	{30010, 199956},
	{30037, 199960},
	{30064, 199964},
	{30091, 199968, 7, 1816},
	{30102, 199972, 2, 1823},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30345, 200696},
	{30364, 200700, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 1832},
	{30586, 200756, 2, 1834},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 10, 1844},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 1858},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{30916, 200960},
	{30938, 200964},
	{30962, 200968},
	{30986, 200972},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31252, 213040},
	{31275, 213044},
	{31298, 213048},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{31597, 213504},
	{31616, 213508},
	{31635, 213512},
	{31654, 213516},
	{31673, 213520},
	{31692, 213524},
	{31711, 213528},
	{31730, 213532},
	{31749, 213536},
	{31768, 213540},
	{31787, 213544},
	{31806, 213548},
	{31825, 213552},
	{31844, 213556},
	{31863, 213560},
	{31882, 213564},
	{31901, 213568},
	{31920, 213572},
	{31939, 213576},
	{31958, 213580},
	{31977, 213584},
	{31997, 213588},
	{32017, 213592},
	{32037, 213596},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{32825, 214784},
	{32844, 214788},
	{32863, 214792},
	{32882, 214796},
	{32901, 214800},
	{32920, 214804},
	{32939, 214808},
	{32958, 214812},
	{32977, 214816},
	{32996, 214820},
	{33015, 214824},
	{33034, 214828},
	{33053, 214832},
	{33072, 214836},
	{33091, 214840},
	{33110, 214844},
	{33129, 214848},
	{33148, 214852},
	{33167, 214856},
	{33186, 214860},
	{33205, 214864},
	{33225, 214868},
	{33245, 214872},
	{33265, 214876},
	{33285, 214880},
	{33305, 214884},
	{33325, 214888},
	{33345, 214892},
	{33365, 214896},
	{33385, 214900},
	{33405, 214904},
	{33425, 214908},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33597, 215424},
	{33618, 215428},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{34111, 216576},
	{34132, 216580},
	{34153, 216584},
	{34174, 216588},
	{34195, 216592},
	{34216, 216596},
	{34237, 216600},
	{34258, 216604},
	{34279, 216640},
	{34300, 216644},
	{34321, 216648},
	{34342, 216652},
	{34363, 216656},
	{34384, 216660},
	{34405, 216664},
	{34426, 216668},
	{34447, 216704},
	{34468, 216708},
	{34489, 216712},
	{34510, 216716},
	{34531, 216720},
	{34552, 216724},
	{34573, 216728},
	{34594, 216732},
	{34615, 216832},
	{34635, 216836},
	{34655, 216840},
	{34675, 216844},
	{34695, 216848},
	{34715, 216852},
	{34735, 216856},
	{34755, 216860},
	{34775, 216864},
	{34796, 216868},
	{34817, 216872},
	{34838, 216876},
	{34859, 216880},
	{34880, 216884},
	{34901, 216888},
	{34922, 216892},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{35327, 217856},
	{35347, 217860},
	{35367, 217864},
	{35387, 217868},
	{35407, 217872},
	{35427, 217876},
	{35447, 217880},
	{35467, 217884},
	{35487, 217984},
	{35512, 217988, 2, 1867},
	{35537, 218016},
	{35563, 218020, 2, 1867},
	{35589, 218080},
	{35614, 218084},
	{35639, 218088},
	{35664, 218092},
	{35689, 218096},
	{35715, 218100},
	{35741, 218224},
	{35763, 218228},
	{35785, 218232},
	{35807, 218236},
	{35829, 218240},
	{35849, 218244},
	{35869, 218248},
	{35889, 218252},
	{35909, 218624},
	{35931, 218628},
	{35953, 218632},
	{35975, 218636},
	{35997, 218640},
	{36019, 218644},
	{36041, 218648},
	{36063, 218652},
	{36085, 218656},
	{36107, 218660},
	{36129, 218664},
	{36151, 218668},
	{36173, 218672},
	{36195, 218676},
	{36217, 218680},
	{36239, 218684},
	{36261, 218880},
	{36282, 218884},
	{36303, 218888},
	{36324, 218892},
	{36345, 218896},
	{36366, 218900},
	{36387, 218904},
	{36408, 218908},
	{36429, 219136},
	{36449, 219140},
	{36469, 219144},
	{36489, 219148},
	{36509, 219152},
	{36529, 219156},
	{36549, 219160},
	{36569, 219164},
	{36589, 219392},
	{36609, 219396},
	{36629, 221184, 5, 1869},
	{36653, 221188, 4, 1874},
	{36678, 221192, 5, 1869},
	{36702, 221196, 5, 1869},
	{36726, 221200, 4, 1874},
	{36751, 221204, 5, 1869},
	{36775, 221208, 4, 1874},
	{36800, 221212, 5, 1869},
	{36824, 221216, 4, 1878},
	{36840, 221220, 5, 1869},
	{36864, 221224, 3, 1882},
	{36898, 221228, 3, 1885},
	{36932, 221232, 3, 1888},
	{36957, 221236, 3, 1891},
	{36982, 221240, 3, 1888},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 20, 1900},
	{37149, 221444, 20, 1900},
	{37174, 221448, 15, 1920},
	{37202, 221452, 15, 1920},
	{37230, 221456, 15, 1920},
	{37258, 221460, 15, 1920},
	{37286, 221492, 8, 1935},
	{37314, 221496, 8, 1935},
	{37342, 221696, 5, 1943},
	{37365, 221700, 4, 1948},
	{37389, 221704, 5, 1943},
	{37412, 221708, 4, 1948},
	{37436, 221712, 5, 1943},
	{37459, 221716, 4, 1948},
	{37483, 221720, 5, 1943},
	{37506, 221724, 4, 1948},
	{37530, 221728, 2, 1952},
	{37553, 221736, 2, 1952},
	{37576, 221744, 2, 1952},
	{37599, 221752, 2, 1952},
	{37622, 221760, 2, 1952},
	{37645, 221768, 2, 1952},
	{37668, 221776, 2, 1952},
	{37692, 221784, 2, 1952},
	{37716, 222208, 5, 1954},
	{37742, 222212, 4, 1959},
	{37769, 222216, 5, 1954},
	{37795, 222220, 4, 1959},
	{37822, 222224, 5, 1954},
	{37848, 222228, 4, 1959},
	{37875, 222232, 5, 1954},
	{37901, 222236, 4, 1959},
	{37928, 222464, 5, 1954},
	{37954, 222468, 4, 1959},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 5, 1954},
	{38187, 222724, 5, 1954},
	{38211, 222728, 5, 1954},
	{38235, 222732, 5, 1954},
	{38259, 222736, 4, 1959},
	{38284, 222740, 4, 1959},
	{38309, 222744, 4, 1959},
	{38334, 222748, 4, 1959},
	{38359, 222752, 1, 1869},
	{38383, 222756, 1, 1869},
	{38407, 222760, 8, 1963},
	{38428, 222976, 4, 1971},
	{38451, 222980, 4, 1971},
	{38474, 222984, 4, 1971},
	{38497, 222988, 4, 1971},
	{38520, 222992, 4, 1971},
	{38543, 222996, 4, 1971},
	{38566, 223000, 4, 1971},
	{38589, 223004, 4, 1971},
	{38612, 223008, 4, 1971},
	{38635, 223012, 4, 1971},
	{38658, 223016, 4, 1971},
	{38682, 223020, 4, 1971},
	{38706, 223024, 4, 1971},
	{38730, 223028, 4, 1971},
	{38754, 223032, 4, 1971},
	{38778, 223036, 4, 1971},
	{38802, 223104, 9, 1975},
	{38822, 223112, 1, 1984},
	{38843, 223232, 5, 1954},
	{38868, 223236, 4, 1959},
	{38894, 223240, 8, 1985},
	{38917, 223488, 3, 1993},
	{38940, 223492, 3, 1993},
	{38963, 223496, 3, 1993},
	{38986, 223500, 3, 1993},
	{39009, 223504, 2, 1996},
	{39033, 223508, 2, 1996},
	{39057, 223744, 5, 1954},
	{39081, 223748, 5, 1954},
	{39105, 223752, 5, 1954},
	{39129, 223756, 5, 1954},
	{39153, 223760, 4, 1959},
	{39178, 224000, 5, 1998},
	{39201, 224004, 4, 2003},
	{39225, 224008, 3, 2007},
	{39248, 224256, 5, 1998},
	{39271, 224260, 4, 2003},
	{39295, 224264, 3, 2007},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{39464, 224768, 5, 1954},
	{39489, 224772, 4, 1948},
	{39515, 224776, 5, 1954},
	{39540, 224780, 4, 1948},
	{39566, 224784, 3, 2010},
	{39591, 224788, 3, 2010},
	{39616, 224832, 5, 1954},
	{39641, 224836, 4, 1948},
	{39667, 224840, 5, 1954},
	{39692, 224844, 4, 1948},
	{39718, 224848, 3, 2010},
	{39743, 224852, 3, 2010},
	{39768, 224896, 5, 1954},
	{39793, 224900, 4, 1948},
	{39819, 224904, 3, 2010},
	{39844, 224908, 3, 2010},
	{39869, 224912, 3, 2010},
	{39894, 225024, 5, 1954},
	{39918, 225028, 4, 1948},
	{39943, 225032, 3, 2010},
	{39967, 225036, 3, 2010},
	{39991, 225040, 3, 2010},
	{40015, 225048, 5, 1954},
	{40040, 225052, 4, 1948},
	{40066, 225056, 3, 2010},
	{40091, 225060, 3, 2010},
	{40116, 225064, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 2025},
	{40186, 225288, 4, 2030},
	{40210, 225292, 2, 2034},
	{40233, 225296, 2, 2034},
	{40256, 225300, 2, 2034},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 4, 2036},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40524, 225808, 7, 2042},
	{40553, 225812},
	{40572, 225816, 2, 2049},
	{40598, 225820, 2, 2051},
	{40621, 225824},
	{40644, 225828, 2, 2053},
	{40671, 225832},
	{40698, 225836, 2, 2055},
	{40723, 225840, 2, 2057},
	{40751, 225844, 2, 2059},
	{40779, 225848, 2, 2061},
	{40802, 225852, 2, 2063},
	{40825, 225856},
	{40858, 225860, 2, 2065},
	{40891, 225864},
	{40923, 225868, 2, 2065},
	{40955, 225872, 2, 2067},
	{40974, 225876, 2, 2069},
	{41001, 225880},
	{41028, 225884, 2, 2071},
	{41055, 225888, 2, 2073},
	{41082, 225892, 10, 2075},
	{41103, 225896, 8, 2085},
	{41122, 225900, 8, 2093},
	{41141, 225904, 2, 2101},
	{41165, 225908, 2, 2103},
	{41197, 225912, 2, 2105},
	{41227, 225916, 4, 2107},
	{41263, 225920, 3, 2111},
	{41296, 225924, 1, 2114},
	{41314, 225932, 1, 2115},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{41399, 226060, 4, 2119},
	{41425, 226064, 3, 2123},
	{41454, 226068, 1, 684},
	{41483, 226072, 3, 2123},
	{41512, 226076, 1, 684},
	{41541, 226192, 1, 2126},
	{41562, 226196, 1, 2126},
	{41589, 226304, 5, 2025},
	{41613, 226308, 4, 2030},
	{41638, 226312, 2, 2034},
	{41662, 226316, 5, 2025},
	{41686, 226320, 4, 2030},
	{41711, 226324, 2, 2034},
	{41735, 226328, 10, 2127},
	{41757, 226432, 5, 2137},
	{41784, 226436, 5, 2137},
	{41811, 226440, 6, 2142},
	{41843, 226480, 5, 2137},
	{41871, 226484, 5, 2137},
	{41899, 226488, 5, 2137},
	{41927, 226492, 5, 2137},
	{41955, 226496, 5, 2137},
	{41983, 226500, 5, 2137},
	{42011, 226504, 5, 2137},
	{42039, 226508, 5, 2137},
	{42067, 226512, 6, 2142},
	{42100, 226544, 5, 1954},
	{42129, 226548, 5, 1954},
	{42158, 226552, 4, 1959},
	{42188, 226556, 4, 1959},
	{42218, 226560, 8, 1985},
	{42245, 226564, 8, 1985},
	{42272, 226608, 5, 1954},
	{42302, 226612, 4, 1959},
	{42333, 226616, 8, 1985},
	{42361, 226688, 5, 2025},
	{42385, 226692, 4, 2030},
	{42410, 226696, 3, 2148},
	{42434, 226700, 2, 2151},
	{42460, 226704, 2, 2151},
	{42486, 226816, 5, 1954},
	{42512, 226820, 4, 1959},
	{42539, 226824, 5, 1954},
	{42565, 226828, 5, 1954},
	{42591, 226832, 5, 1954},
	{42617, 226836, 1, 1869},
	{42643, 226840, 1, 1869},
	{42669, 226844, 1, 1869},
	{42695, 226848, 1, 1869},
	{42721, 226880, 4, 1959},
	{42748, 226884, 4, 1959},
	{42775, 226888, 4, 1959},
	{42802, 227072, 5, 1954},
	{42827, 227076, 4, 1948},
	{42853, 227080, 3, 2010},
	{42878, 227084, 3, 2010},
	{42903, 227088, 3, 2010},
	{42928, 227200, 5, 1954},
	{42952, 227204, 4, 1948},
	{42977, 227208, 3, 2010},
	{43001, 227212, 3, 2010},
	{43025, 227216, 3, 2010},
	{43049, 227328, 5, 1954},
	{43073, 227332, 4, 1959},
	{43098, 227336, 8, 1985},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 2162},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 7, 2168},
	{43206, 1168, 12, 2175},
	{43221, 1281, 6, 2187},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
	{43248, 1414, 15, 2193},
};

static const struct si_reg gfx103_reg_table[] = {
	{43257, 40, 1, 2208},
	{43272, 44, 1, 2208},
	{1310, 1028, 8, 0},
	{1323, 1032, 20, 10},
	{1338, 1036, 10, 2209},
	{1354, 1040, 12, 40},
	{1375, 1044, 4, 52},
	{1393, 1048, 3, 56},
	{1411, 1052, 8, 2219},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1454, 1064},
	{1471, 1076, 2, 78},
	{1487, 1080},
	{1882, 1104},
	{1906, 1108},
	{1504, 1116, 5, 80},
	{1519, 1120, 6, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1573, 1132, 4, 95},
	{1593, 1136, 5, 99},
	{43295, 1140, 1, 2227},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 29, 2228},
	{1967, 32784, 20, 2257},
	{1979, 32788, 14, 154},
	{1995, 32792, 14, 154},
	{2011, 32796, 15, 168},
	{2024, 32824, 14, 154},
	{2040, 32828, 14, 154},
	{2056, 33296, 21, 183},
	{2070, 33300, 28, 204},
	{2087, 33304, 15, 232},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{43317, 33328, 1, 2277},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 9, 333},
	{2283, 33436, 1, 342},
	{2306, 36096},
	{2332, 36100, 2, 343},
	{2358, 36104},
	{2384, 36108, 2, 343},
	{2410, 36112, 2, 345},
	{2431, 36116, 4, 347},
	{2452, 36120, 6, 2278},
	{2479, 36124, 20, 2284},
	{2500, 36128, 7, 2304},
	{2523, 36132},
	{2552, 36140},
	{2582, 36144},
	{2614, 36148},
	{2645, 36152},
	{43344, 36156, 3, 2311},
	{2678, 36348, 5, 378},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 11, 2314},
	{2759, 36656, 14, 397},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 415},
	{2813, 36668, 2, 424},
	{2831, 37168, 9, 2325},
	{2847, 39160, 6, 2334},
	{3642, 40960},
	{3660, 40964, 4, 449},
	{3678, 40968, 3, 453},
	{3696, 40972, 9, 456},
	{3714, 40976, 3, 2340},
	{3732, 40980, 8, 2343},
	{3750, 40984, 11, 2351},
	{3768, 40988},
	{3786, 45060, 1, 484},
	{3810, 45080},
	{3835, 45084, 3, 485},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 12, 2362},
	{3925, 45100, 10, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{4371, 45168},
	{4398, 45172},
	{4425, 45176},
	{4452, 45180},
	{4479, 45184},
	{4506, 45188},
	{4533, 45192},
	{4560, 45196},
	{4587, 45200},
	{4614, 45204},
	{4641, 45208},
	{4668, 45212},
	{4695, 45216},
	{4722, 45220},
	{4749, 45224},
	{4776, 45228},
	{4803, 45248, 8, 510},
	{4859, 45256, 1, 523},
	{4886, 45260, 1, 523},
	{4913, 45264, 1, 523},
	{4940, 45268, 1, 523},
	{4967, 45316, 1, 484},
	{4991, 45332},
	{5016, 45336, 3, 485},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 525},
	{5131, 45356, 14, 537},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{5577, 45424},
	{5604, 45428},
	{5631, 45432},
	{5658, 45436},
	{5685, 45440},
	{5712, 45444},
	{5739, 45448},
	{5766, 45452},
	{5793, 45456},
	{5820, 45460},
	{5847, 45464},
	{5874, 45468},
	{5901, 45472},
	{5928, 45476},
	{5955, 45480},
	{5982, 45484},
	{6009, 45504, 8, 510},
	{6065, 45512, 1, 523},
	{6092, 45516, 1, 523},
	{6119, 45520, 1, 523},
	{6146, 45524, 1, 523},
	{6173, 45548, 9, 551},
	{6254, 45568},
	{6279, 45572, 2, 571},
	{6303, 45576},
	{6335, 45580},
	{6367, 45584},
	{6391, 45588, 1, 488},
	{6415, 45596, 4, 573},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 13, 577},
	{6505, 45612, 9, 590},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{6951, 45680},
	{6978, 45684},
	{7005, 45688},
	{7032, 45692},
	{7059, 45696},
	{7086, 45700},
	{7113, 45704},
	{7140, 45708},
	{7167, 45712},
	{7194, 45716},
	{7221, 45720},
	{7248, 45724},
	{7275, 45728},
	{7302, 45732},
	{7329, 45736},
	{7356, 45740},
	{7383, 45760, 8, 510},
	{7443, 45768, 1, 523},
	{7472, 45772, 1, 523},
	{7501, 45776, 1, 523},
	{7530, 45780, 1, 523},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{8149, 46080},
	{8174, 46084, 1, 484},
	{8198, 46088},
	{8230, 46092},
	{8262, 46096},
	{8286, 46100, 1, 488},
	{8310, 46108, 4, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 12, 613},
	{8400, 46124, 9, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{8846, 46192},
	{8873, 46196},
	{8900, 46200},
	{8927, 46204},
	{8954, 46208},
	{8981, 46212},
	{9008, 46216},
	{9035, 46220},
	{9062, 46224},
	{9089, 46228},
	{9116, 46232},
	{9143, 46236},
	{9170, 46240},
	{9197, 46244},
	{9224, 46248},
	{9251, 46252},
	{9278, 46272, 8, 510},
	{9338, 46280, 1, 523},
	{9367, 46284, 1, 523},
	{9396, 46288, 1, 523},
	{9425, 46292, 1, 523},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{10017, 47104, 13, 643},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 1, 660},
	{10280, 47160},
	{10309, 47164, 1, 660},
	{10338, 47168},
	{10371, 47172, 1, 660},
	{10404, 47176, 12, 661},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{10477, 47192},
	{10504, 47196},
	{10531, 47200, 2, 691},
	{10552, 47204},
	{10579, 47208},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 5, 694},
	{10710, 47232},
	{10730, 47236},
	{10753, 47240, 9, 699},
	{10770, 47248, 1, 523},
	{10791, 47252, 1, 523},
	{10812, 47256, 1, 523},
	{10833, 47260, 1, 523},
	{10854, 47264, 1, 708},
	{10872, 47268, 1, 709},
	{10891, 47272},
	{10913, 47276, 3, 710},
	{10930, 47280},
	{10959, 47284, 1, 713},
	{10988, 47288, 3, 710},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11332, 47604, 2, 714},
	{11356, 47608},
	{11377, 47612},
	{11393, 163840, 11, 2374},
	{11411, 163844, 11, 726},
	{11428, 163848, 7, 737},
	{11442, 163852, 23, 744},
	{11461, 163856, 18, 2385},
	{11481, 163860},
	{11500, 163868, 2, 783},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{11637, 163896, 3, 790},
	{11653, 163900, 8, 793},
	{11671, 163904, 14, 801},
	{11681, 163908, 9, 815},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{11771, 163928, 2, 824},
	{11789, 163932, 1, 826},
	{43368, 163940, 3, 2403},
	{11807, 163944, 1, 827},
	{11825, 163948, 1, 827},
	{11849, 163952, 1, 827},
	{11868, 163956, 1, 827},
	{11893, 163960, 1, 827},
	{11915, 163964, 13, 2406},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14004, 164700, 6, 2419},
	{14033, 164704, 1, 899},
	{14054, 164708, 1, 900},
	{14064, 164712, 1, 901},
	{43389, 164716},
	{43411, 164720},
	{14132, 164864},
	{14149, 164868},
	{14166, 164872},
	{14182, 164876},
	{14211, 164880, 14, 2425},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14293, 164900, 8, 920},
	{14308, 164904, 4, 928},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16814, 165404},
	{16837, 165444, 13, 2439},
	{16857, 165448, 13, 2439},
	{16877, 165452, 13, 2439},
	{16897, 165456, 13, 2439},
	{16917, 165460, 13, 2439},
	{16937, 165464, 13, 2439},
	{16957, 165468, 13, 2439},
	{16977, 165472, 13, 2439},
	{16997, 165476, 13, 2439},
	{17017, 165480, 13, 2439},
	{17037, 165484, 13, 2439},
	{17058, 165488, 13, 2439},
	{17079, 165492, 13, 2439},
	{17100, 165496, 13, 2439},
	{17121, 165500, 13, 2439},
	{17142, 165504, 13, 2439},
	{17163, 165508, 13, 2439},
	{17184, 165512, 13, 2439},
	{17205, 165516, 13, 2439},
	{17226, 165520, 13, 2439},
	{17247, 165524, 10, 2452},
	{17268, 165528, 10, 2452},
	{17289, 165532, 10, 2452},
	{17310, 165536, 10, 2452},
	{17331, 165540, 10, 2452},
	{17352, 165544, 10, 2452},
	{17373, 165548, 10, 2452},
	{17394, 165552, 10, 2452},
	{17415, 165556, 10, 2452},
	{17436, 165560, 10, 2452},
	{17457, 165564, 10, 2452},
	{17478, 165568, 10, 2452},
	{17499, 165572, 4, 2462},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 6, 2466},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17623, 165640, 1, 1006},
	{17645, 165644, 5, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{43433, 165712, 8, 2472},
	{17709, 165716, 8, 2480},
	{17727, 165720, 8, 1029},
	{17748, 165724, 17, 1037},
	{17769, 165728, 6, 1054},
	{17787, 165732, 6, 1054},
	{17805, 165736, 6, 1054},
	{17823, 165740, 6, 1054},
	{17841, 165744, 6, 1054},
	{17859, 165748, 6, 1054},
	{17877, 165752, 6, 1054},
	{17895, 165756, 6, 1054},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 1070},
	{18176, 165864},
	{18189, 165872, 6, 2488},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18245, 165884, 1, 1080},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 5, 2494},
	{18314, 165900, 17, 1107},
	{18332, 165904, 20, 1124},
	{18348, 165908, 16, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 30, 2499},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18490, 165936, 5, 1229},
	{18541, 165944, 3, 2529},
	{18556, 165948, 5, 1240},
	{18586, 165952, 5, 1245},
	{18601, 165956},
	{43459, 165960, 6, 2532},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 1262},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 1282},
	{18954, 166468, 3, 1297},
	{18973, 166472, 6, 2538},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 1335},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 9, 2544},
	{19213, 166528},
	{19224, 166532, 3, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 1351},
	{19307, 166548, 2, 1354},
	{19334, 166552, 4, 2553},
	{19356, 166560},
	{19381, 166564},
	{19406, 166568, 6, 1361},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 10, 2557},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20038, 166732, 2, 1394},
	{20057, 166736, 5, 1396},
	{20079, 166740, 20, 2567},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 12, 1423},
	{20220, 166768, 6, 1435},
	{20237, 166772},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 3, 1443},
	{20455, 166804, 8, 1446},
	{20474, 166808, 4, 1454},
	{20500, 166812, 3, 1351},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 5, 1474},
	{20592, 166880, 8, 2587},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21307, 166976, 4, 1524},
	{21328, 166980, 12, 1528},
	{21348, 166984, 2, 1540},
	{21368, 166988, 20, 1542},
	{21406, 166992, 2, 1562},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{21490, 167012, 2, 1566},
	{21506, 167016, 1, 1568},
	{21522, 167020, 3, 1569},
	{21537, 167024, 19, 2595},
	{21552, 167028, 8, 1591},
	{21569, 167032, 14, 2614},
	{21591, 167036},
	{21607, 167040, 1, 1611},
	{21629, 167044},
	{21645, 167048, 1, 1568},
	{21667, 167052},
	{21689, 167056},
	{21711, 167060},
	{21730, 167068},
	{21745, 167072, 2, 1566},
	{21761, 167076, 1, 1568},
	{21777, 167080, 3, 1569},
	{21792, 167084, 19, 2595},
	{21807, 167088, 8, 1591},
	{21824, 167092, 14, 2614},
	{21846, 167096},
	{21862, 167100, 1, 1611},
	{21884, 167104},
	{21900, 167108, 1, 1568},
	{21922, 167112},
	{21944, 167116},
	{21966, 167120},
	{21985, 167128},
	{22000, 167132, 2, 1566},
	{22016, 167136, 1, 1568},
	{22032, 167140, 3, 1569},
	{22047, 167144, 19, 2595},
	{22062, 167148, 8, 1591},
	{22079, 167152, 14, 2614},
	{22101, 167156},
	{22117, 167160, 1, 1611},
	{22139, 167164},
	{22155, 167168, 1, 1568},
	{22177, 167172},
	{22199, 167176},
	{22221, 167180},
	{22240, 167188},
	{22255, 167192, 2, 1566},
	{22271, 167196, 1, 1568},
	{22287, 167200, 3, 1569},
	{22302, 167204, 19, 2595},
	{22317, 167208, 8, 1591},
	{22334, 167212, 14, 2614},
	{22356, 167216},
	{22372, 167220, 1, 1611},
	{22394, 167224},
	{22410, 167228, 1, 1568},
	{22432, 167232},
	{22454, 167236},
	{22476, 167240},
	{22495, 167248},
	{22510, 167252, 2, 1566},
	{22526, 167256, 1, 1568},
	{22542, 167260, 3, 1569},
	{22557, 167264, 19, 2595},
	{22572, 167268, 8, 1591},
	{22589, 167272, 14, 2614},
	{22611, 167276},
	{22627, 167280, 1, 1611},
	{22649, 167284},
	{22665, 167288, 1, 1568},
	{22687, 167292},
	{22709, 167296},
	{22731, 167300},
	{22750, 167308},
	{22765, 167312, 2, 1566},
	{22781, 167316, 1, 1568},
	{22797, 167320, 3, 1569},
	{22812, 167324, 19, 2595},
	{22827, 167328, 8, 1591},
	{22844, 167332, 14, 2614},
	{22866, 167336},
	{22882, 167340, 1, 1611},
	{22904, 167344},
	{22920, 167348, 1, 1568},
	{22942, 167352},
	{22964, 167356},
	{22986, 167360},
	{23005, 167368},
	{23020, 167372, 2, 1566},
	{23036, 167376, 1, 1568},
	{23052, 167380, 3, 1569},
	{23067, 167384, 19, 2595},
	{23082, 167388, 8, 1591},
	{23099, 167392, 14, 2614},
	{23121, 167396},
	{23137, 167400, 1, 1611},
	{23159, 167404},
	{23175, 167408, 1, 1568},
	{23197, 167412},
	{23219, 167416},
	{23241, 167420},
	{23260, 167428},
	{23275, 167432, 2, 1566},
	{23291, 167436, 1, 1568},
	{23307, 167440, 3, 1569},
	{23322, 167444, 19, 2595},
	{23337, 167448, 8, 1591},
	{23354, 167452, 14, 2614},
	{23376, 167456},
	{23392, 167460, 1, 1611},
	{23414, 167464},
	{23430, 167468, 1, 1568},
	{23452, 167472},
	{23474, 167476},
	{23496, 167480},
	{23515, 167488, 1, 1612},
	{23534, 167492, 1, 1612},
	{23553, 167496, 1, 1612},
	{23572, 167500, 1, 1612},
	{23591, 167504, 1, 1612},
	{23610, 167508, 1, 1612},
	{23629, 167512, 1, 1612},
	{23648, 167516, 1, 1612},
	{23667, 167520, 1, 1612},
	{23692, 167524, 1, 1612},
	{23717, 167528, 1, 1612},
	{23742, 167532, 1, 1612},
	{23767, 167536, 1, 1612},
	{23792, 167540, 1, 1612},
	{23817, 167544, 1, 1612},
	{23842, 167548, 1, 1612},
	{23867, 167552, 1, 1612},
	{23892, 167556, 1, 1612},
	{23917, 167560, 1, 1612},
	{23942, 167564, 1, 1612},
	{23967, 167568, 1, 1612},
	{23992, 167572, 1, 1612},
	{24017, 167576, 1, 1612},
	{24042, 167580, 1, 1612},
	{24067, 167584, 1, 1612},
	{24090, 167588, 1, 1612},
	{24113, 167592, 1, 1612},
	{24136, 167596, 1, 1612},
	{24159, 167600, 1, 1612},
	{24182, 167604, 1, 1612},
	{24205, 167608, 1, 1612},
	{24228, 167612, 1, 1612},
	{24251, 167616, 3, 1613},
	{24269, 167620, 3, 1613},
	{24287, 167624, 3, 1613},
	{24305, 167628, 3, 1613},
	{24323, 167632, 3, 1613},
	{24341, 167636, 3, 1613},
	{24359, 167640, 3, 1613},
	{24377, 167644, 3, 1613},
	{24395, 167648, 9, 2628},
	{24413, 167652, 9, 2628},
	{24431, 167656, 9, 2628},
	{24449, 167660, 9, 2628},
	{24467, 167664, 9, 2628},
	{24485, 167668, 9, 2628},
	{24503, 167672, 9, 2628},
	{24521, 167676, 9, 2628},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{24661, 196632, 1, 1626},
	{24683, 196636, 1, 1627},
	{24705, 196640},
	{24735, 196644},
	{24765, 196648},
	{24794, 196652},
	{24823, 196656},
	{24853, 196660},
	{24883, 196664},
	{24912, 196668},
	{24941, 196672},
	{24971, 196676},
	{25001, 196680},
	{25030, 196684},
	{25059, 196688},
	{25089, 196692},
	{25119, 196696},
	{25148, 196700},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{25841, 196852, 1, 1631},
	{25863, 196856, 1, 1631},
	{25885, 196860, 1, 1632},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{43474, 196896, 5, 2637},
	{26028, 196908, 1, 660},
	{26047, 196912},
	{26065, 196916},
	{26092, 196920},
	{26119, 196928, 2, 1633},
	{26132, 196932},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 4, 1636},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 1, 1640},
	{26554, 197032, 2, 1641},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 1, 1643},
	{26626, 197048, 2, 1644},
	{26644, 197052},
	{26662, 197056, 2, 2642},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 2642},
	{26744, 197080, 5, 1648},
	{26764, 197084, 7, 1653},
	{26783, 197088, 7, 1653},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 13, 1662},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 2, 1675},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 7, 1679},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 7, 1679},
	{27102, 197160, 7, 1686},
	{27114, 197164, 2, 1693},
	{27131, 197168, 1, 1695},
	{27148, 197172, 1, 1696},
	{27166, 197176, 5, 2644},
	{27186, 197180, 2, 330},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27246, 197196, 1, 1705},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27344, 197216, 1, 1704},
	{27361, 197220, 1, 1705},
	{27378, 197224},
	{27392, 197232, 2, 1710},
	{27414, 197236, 2, 1712},
	{27436, 197240, 2, 1710},
	{27459, 197244, 2, 1712},
	{27482, 197248, 2, 1710},
	{27504, 197252, 2, 1712},
	{43493, 197256},
	{43515, 197260},
	{43537, 197280},
	{43559, 197284},
	{43581, 197288},
	{43608, 197292},
	{43635, 197296},
	{43662, 197300},
	{27526, 197364, 1, 1714},
	{27547, 197368, 1, 1715},
	{27567, 197372, 1, 1716},
	{27604, 197380, 1, 1716},
	{27621, 197384, 1, 1717},
	{27637, 197388, 1, 1718},
	{27656, 197392, 1, 1719},
	{27675, 197396, 1, 1720},
	{27692, 197400, 1, 1721},
	{27710, 197404, 1, 1722},
	{27728, 197408, 1, 1723},
	{27744, 197412, 1, 1724},
	{27762, 197416, 1, 1725},
	{27780, 197420, 1, 1726},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 4, 1730},
	{27945, 197464, 5, 2649},
	{27967, 197468, 1, 1737},
	{27987, 197472, 1, 1738},
	{28001, 197476, 1, 1739},
	{28015, 197480, 1, 1740},
	{28027, 197484, 1, 1741},
	{28043, 197488, 1, 1738},
	{28060, 197492, 1, 1739},
	{28077, 197496, 1, 1740},
	{28092, 197500, 1, 1741},
	{28111, 197552, 1, 1742},
	{28136, 197556, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28235, 197576},
	{28260, 197580, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28493, 197624, 13, 1752},
	{28510, 197628},
	{28527, 197632, 1, 1695},
	{28547, 197636},
	{28564, 197640, 1, 1660},
	{28584, 197644, 2, 1765},
	{28603, 197888, 8, 1767},
	{28624, 197892, 8, 1767},
	{28645, 198656, 6, 1775},
	{28660, 198912},
	{28679, 198916},
	{28698, 198920, 1, 1781},
	{28717, 198924, 2, 2654},
	{28732, 198928},
	{28765, 198932},
	{28798, 198936},
	{28831, 198940},
	{28864, 198948},
	{28880, 198952},
	{28895, 198956, 2, 1354},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 1782},
	{28972, 198972, 2, 2656},
	{28993, 198976},
	{29012, 198980},
	{29031, 198984},
	{29047, 198988, 1, 827},
	{29066, 198992},
	{29086, 198996, 1, 827},
	{29109, 199000},
	{29127, 199004, 1, 827},
	{29148, 199008, 9, 1785},
	{29173, 199012},
	{29189, 199016},
	{29210, 199020, 4, 1794},
	{29218, 199024},
	{29232, 199028},
	{29246, 199032},
	{29260, 199036, 3, 1798},
	{29275, 199040, 2, 1801},
	{29287, 199044, 1, 827},
	{29309, 199048, 3, 1803},
	{43689, 199052, 2, 2658},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{29983, 199952},
	{30010, 199956},
	{30037, 199960},
	{30064, 199964},
	{30091, 199968, 5, 2660},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30345, 200696},
	{30364, 200700, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 1832},
	{30586, 200756, 2, 1834},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 11, 2665},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 1858},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{30916, 200960},
	{30938, 200964},
	{30962, 200968},
	{30986, 200972},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31252, 213040},
	{31275, 213044},
	{31298, 213048},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{43701, 213648},
	{43721, 213652},
	{43741, 213656},
	{43761, 213660},
	{43781, 213664},
	{43801, 213668},
	{43821, 213672},
	{43841, 213676},
	{43861, 213680},
	{43886, 213684},
	{43911, 213688},
	{43936, 213692},
	{43961, 213696},
	{43986, 213700},
	{44011, 213704},
	{44036, 213708},
	{44061, 213712},
	{44084, 213716},
	{44107, 213720},
	{44130, 213724},
	{44153, 213728},
	{44176, 213732},
	{44199, 213736},
	{44222, 213740},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{32825, 214784},
	{32844, 214788},
	{32863, 214792},
	{32882, 214796},
	{32901, 214800},
	{32920, 214804},
	{32939, 214808},
	{32958, 214812},
	{32977, 214816},
	{32996, 214820},
	{33015, 214824},
	{33034, 214828},
	{33053, 214832},
	{33072, 214836},
	{33091, 214840},
	{33110, 214844},
	{33129, 214848},
	{33148, 214852},
	{33167, 214856},
	{33186, 214860},
	{33205, 214864},
	{33225, 214868},
	{33245, 214872},
	{33265, 214876},
	{33285, 214880},
	{33305, 214884},
	{33325, 214888},
	{33345, 214892},
	{33365, 214896},
	{33385, 214900},
	{33405, 214904},
	{33425, 214908},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33597, 215424},
	{33618, 215428},
	{44245, 215432},
	{44265, 215436, 2, 1867},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{34111, 216576},
	{34132, 216580},
	{34153, 216584},
	{34174, 216588},
	{34195, 216592},
	{34216, 216596},
	{34237, 216600},
	{34258, 216604},
	{34279, 216640},
	{34300, 216644},
	{34321, 216648},
	{34342, 216652},
	{34363, 216656},
	{34384, 216660},
	{34405, 216664},
	{34426, 216668},
	{34447, 216704},
	{34468, 216708},
	{34489, 216712},
	{34510, 216716},
	{34531, 216720},
	{34552, 216724},
	{34573, 216728},
	{34594, 216732},
	{34615, 216832},
	{34635, 216836},
	{34655, 216840},
	{34675, 216844},
	{34695, 216848},
	{34715, 216852},
	{34735, 216856},
	{34755, 216860},
	{34775, 216864},
	{34796, 216868},
	{34817, 216872},
	{34838, 216876},
	{34859, 216880},
	{34880, 216884},
	{34901, 216888},
	{34922, 216892},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{35327, 217856},
	{35347, 217860},
	{35367, 217864},
	{35387, 217868},
	{35407, 217872},
	{35427, 217876},
	{35447, 217880},
	{35467, 217884},
	{35537, 218016},
	{35563, 218020, 2, 1867},
	{44285, 218024},
	{44308, 218028, 2, 1867},
	{35589, 218080},
	{35614, 218084},
	{35639, 218088},
	{35664, 218092},
	{35741, 218224},
	{35763, 218228},
	{35785, 218232},
	{35807, 218236},
	{35829, 218240},
	{35849, 218244},
	{35869, 218248},
	{35889, 218252},
	{35909, 218624},
	{35931, 218628},
	{35953, 218632},
	{35975, 218636},
	{35997, 218640},
	{36019, 218644},
	{36041, 218648},
	{36063, 218652},
	{36085, 218656},
	{36107, 218660},
	{36129, 218664},
	{36151, 218668},
	{36173, 218672},
	{36195, 218676},
	{36217, 218680},
	{36239, 218684},
	{36261, 218880},
	{36282, 218884},
	{36303, 218888},
	{36324, 218892},
	{36345, 218896},
	{36366, 218900},
	{36387, 218904},
	{36408, 218908},
	{36429, 219136},
	{36449, 219140},
	{36469, 219144},
	{36489, 219148},
	{36509, 219152},
	{36529, 219156},
	{36549, 219160},
	{36569, 219164},
	{36589, 219392},
	{36609, 219396},
	{44331, 219400},
	{44350, 219404, 2, 1867},
	{44369, 219520},
	{44398, 219524, 2, 1867},
	{44427, 219528},
	{44449, 219532},
	{44471, 219536},
	{44493, 219540},
	{44515, 219568},
	{44544, 219572, 2, 1867},
	{44573, 219576},
	{44595, 219580},
	{44617, 219584},
	{44639, 219588},
	{44661, 219616},
	{44690, 219620, 2, 1867},
	{44719, 219624},
	{44741, 219628},
	{44763, 219632},
	{44785, 219636},
	{44807, 219664},
	{44836, 219668, 2, 1867},
	{44865, 219672},
	{44887, 219676},
	{44909, 219680},
	{44931, 219684},
	{36629, 221184, 5, 1869},
	{36653, 221188, 4, 1874},
	{36678, 221192, 5, 1869},
	{36702, 221196, 5, 1869},
	{36726, 221200, 4, 1874},
	{36751, 221204, 5, 1869},
	{36775, 221208, 4, 1874},
	{36800, 221212, 5, 1869},
	{36824, 221216, 4, 1878},
	{36840, 221220, 5, 1869},
	{36864, 221224, 3, 1882},
	{36898, 221228, 3, 1885},
	{36932, 221232, 3, 1888},
	{36957, 221236, 3, 1891},
	{36982, 221240, 3, 1888},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 20, 1900},
	{37149, 221444, 20, 1900},
	{37174, 221448, 15, 1920},
	{37202, 221452, 15, 1920},
	{37230, 221456, 15, 1920},
	{37258, 221460, 15, 1920},
	{37286, 221492, 8, 1935},
	{37314, 221496, 8, 1935},
	{44953, 221840, 5, 1943},
	{44977, 221844, 4, 1948},
	{45002, 221848, 5, 1943},
	{45026, 221852, 4, 1948},
	{45051, 221856, 5, 1943},
	{45075, 221860, 4, 1948},
	{45100, 221864, 5, 1943},
	{45124, 221868, 4, 1948},
	{45149, 221872, 5, 1943},
	{45178, 221876, 4, 1948},
	{45208, 221880, 5, 1943},
	{45237, 221884, 4, 1948},
	{45267, 221888, 5, 1943},
	{45296, 221892, 4, 1948},
	{45326, 221896, 5, 1943},
	{45355, 221900, 4, 1948},
	{45385, 221904, 5, 1943},
	{45412, 221908, 4, 1948},
	{45440, 221912, 5, 1943},
	{45467, 221916, 4, 1948},
	{45495, 221920, 5, 1943},
	{45522, 221924, 4, 1948},
	{45550, 221928, 5, 1943},
	{45577, 221932, 4, 1948},
	{37716, 222208, 5, 1954},
	{37742, 222212, 4, 1959},
	{37769, 222216, 5, 1954},
	{37795, 222220, 4, 1959},
	{37822, 222224, 5, 1954},
	{37848, 222228, 4, 1959},
	{37875, 222232, 5, 1954},
	{37901, 222236, 4, 1959},
	{37928, 222464, 5, 1954},
	{37954, 222468, 4, 1959},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 5, 1954},
	{38187, 222724, 5, 1954},
	{38211, 222728, 5, 1954},
	{38235, 222732, 5, 1954},
	{38259, 222736, 4, 1959},
	{38284, 222740, 4, 1959},
	{38309, 222744, 4, 1959},
	{38334, 222748, 4, 1959},
	{38359, 222752, 1, 1869},
	{38383, 222756, 1, 1869},
	{38407, 222760, 8, 1963},
	{38428, 222976, 3, 2676},
	{38451, 222980, 3, 2676},
	{38474, 222984, 3, 2676},
	{38497, 222988, 3, 2676},
	{38520, 222992, 3, 2676},
	{38543, 222996, 3, 2676},
	{38566, 223000, 3, 2676},
	{38589, 223004, 3, 2676},
	{38612, 223008, 3, 2676},
	{38635, 223012, 3, 2676},
	{38658, 223016, 3, 2676},
	{38682, 223020, 3, 2676},
	{38706, 223024, 3, 2676},
	{38730, 223028, 3, 2676},
	{38754, 223032, 3, 2676},
	{38778, 223036, 3, 2676},
	{38802, 223104, 15, 2679},
	{38822, 223112, 1, 1984},
	{38843, 223232, 5, 1954},
	{38868, 223236, 4, 1959},
	{38894, 223240, 8, 1985},
	{45605, 223244, 5, 2137},
	{45627, 223248, 5, 2137},
	{45649, 223252, 6, 2142},
	{38917, 223488, 5, 1954},
	{38940, 223492, 5, 1954},
	{38963, 223496, 3, 2010},
	{38986, 223500, 3, 2010},
	{39009, 223504, 4, 1959},
	{39033, 223508, 4, 1959},
	{39057, 223744, 5, 1954},
	{39081, 223748, 5, 1954},
	{39105, 223752, 5, 1954},
	{39129, 223756, 5, 1954},
	{39153, 223760, 4, 1959},
	{45676, 223764, 4, 1959},
	{45701, 223768, 4, 1959},
	{45726, 223772, 4, 1959},
	{39178, 224000, 5, 1954},
	{39201, 224004, 4, 1959},
	{39225, 224008, 3, 2010},
	{39248, 224256, 5, 1954},
	{39271, 224260, 4, 1959},
	{39295, 224264, 3, 2010},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{39464, 224768, 5, 1954},
	{39489, 224772, 4, 1948},
	{39515, 224776, 5, 1954},
	{39540, 224780, 4, 1948},
	{39566, 224784, 3, 2010},
	{39591, 224788, 3, 2010},
	{39616, 224832, 5, 1954},
	{39641, 224836, 4, 1948},
	{39667, 224840, 5, 1954},
	{39692, 224844, 4, 1948},
	{39718, 224848, 3, 2010},
	{39743, 224852, 3, 2010},
	{39768, 224896, 5, 1954},
	{39793, 224900, 4, 1948},
	{39819, 224904, 3, 2010},
	{39844, 224908, 3, 2010},
	{39869, 224912, 3, 2010},
	{39894, 225024, 5, 1954},
	{39918, 225028, 4, 1948},
	{39943, 225032, 3, 2010},
	{39967, 225036, 3, 2010},
	{39991, 225040, 3, 2010},
	{40015, 225048, 5, 1954},
	{40040, 225052, 4, 1948},
	{40066, 225056, 3, 2010},
	{40091, 225060, 3, 2010},
	{40116, 225064, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 2025},
	{40186, 225288, 4, 2030},
	{40210, 225292, 2, 2034},
	{40233, 225296, 2, 2034},
	{40256, 225300, 2, 2034},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 4, 2036},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40524, 225808, 7, 2042},
	{40553, 225812},
	{40572, 225816, 2, 2049},
	{40598, 225820, 2, 2051},
	{40621, 225824},
	{40644, 225828, 2, 2053},
	{40671, 225832},
	{40698, 225836, 2, 2055},
	{40723, 225840, 2, 2057},
	{40751, 225844, 2, 2059},
	{40779, 225848, 2, 2061},
	{40802, 225852, 2, 2063},
	{40825, 225856},
	{40858, 225860, 2, 2065},
	{40891, 225864},
	{40923, 225868, 2, 2065},
	{40955, 225872, 2, 2067},
	{40974, 225876, 2, 2069},
	{41001, 225880},
	{41028, 225884, 2, 2694},
	{41055, 225888, 2, 2073},
	{41082, 225892, 17, 2696},
	{41103, 225896, 9, 2713},
	{41122, 225900, 19, 2722},
	{41141, 225904, 1, 2101},
	{41165, 225908, 1, 2103},
	{41197, 225912, 2, 2105},
	{41227, 225916, 4, 2107},
	{41263, 225920, 3, 2111},
	{41296, 225924, 1, 2114},
	{45751, 225928, 7, 2042},
	{41314, 225932, 1, 2115},
	{45784, 225936},
	{45811, 225940},
	{45837, 225944, 4, 2107},
	{45877, 225948, 2, 2741},
	{45911, 225952, 2, 2741},
	{45941, 225956, 2, 2069},
	{45972, 225960},
	{46003, 225964, 4, 2743},
	{46037, 225968, 3, 2111},
	{46074, 225972, 3, 2747},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{41399, 226060, 4, 2119},
	{41425, 226064, 3, 2123},
	{41454, 226068, 1, 684},
	{41483, 226072, 3, 2123},
	{41512, 226076, 1, 684},
	{41541, 226192, 1, 2126},
	{41589, 226304, 5, 2025},
	{41613, 226308, 4, 2030},
	{41638, 226312, 2, 2034},
	{41662, 226316, 5, 2025},
	{41686, 226320, 4, 2030},
	{41711, 226324, 2, 2034},
	{41735, 226328, 10, 2127},
	{41843, 226480, 5, 2137},
	{41871, 226484, 5, 2137},
	{41899, 226488, 5, 2137},
	{41927, 226492, 5, 2137},
	{41955, 226496, 5, 2137},
	{41983, 226500, 5, 2137},
	{42011, 226504, 5, 2137},
	{42039, 226508, 5, 2137},
	{42067, 226512, 6, 2142},
	{46115, 226516, 5, 2137},
	{46140, 226520, 5, 2137},
	{46165, 226524, 5, 2137},
	{46190, 226528, 5, 2137},
	{46215, 226532, 6, 2142},
	{42100, 226544, 5, 1954},
	{42129, 226548, 5, 1954},
	{42158, 226552, 4, 1959},
	{42188, 226556, 4, 1959},
	{42218, 226560, 8, 1985},
	{42245, 226564, 8, 1985},
	{42361, 226688, 5, 2025},
	{42385, 226692, 4, 2030},
	{42410, 226696, 3, 2148},
	{42434, 226700, 2, 2151},
	{42460, 226704, 2, 2151},
	{42486, 226816, 5, 1954},
	{42512, 226820, 4, 1959},
	{42539, 226824, 5, 1954},
	{42565, 226828, 5, 1954},
	{42591, 226832, 5, 1954},
	{42617, 226836, 1, 1869},
	{42643, 226840, 1, 1869},
	{42669, 226844, 1, 1869},
	{42695, 226848, 1, 1869},
	{42721, 226880, 4, 1959},
	{42748, 226884, 4, 1959},
	{42775, 226888, 4, 1959},
	{42802, 227072, 5, 1954},
	{42827, 227076, 4, 1948},
	{42853, 227080, 3, 2010},
	{42878, 227084, 3, 2010},
	{42903, 227088, 3, 2010},
	{42928, 227200, 5, 1954},
	{42952, 227204, 4, 1948},
	{42977, 227208, 3, 2010},
	{43001, 227212, 3, 2010},
	{43025, 227216, 3, 2010},
	{43049, 227328, 5, 1954},
	{43073, 227332, 4, 1959},
	{43098, 227336, 8, 1985},
	{46245, 227340, 5, 2137},
	{46266, 227344, 5, 2137},
	{46287, 227348, 6, 2142},
	{46313, 227456, 5, 2137},
	{46344, 227460, 5, 2137},
	{46375, 227464, 6, 2142},
	{46411, 227468, 1, 2750},
	{46435, 227472, 5, 1954},
	{46461, 227476, 4, 1959},
	{46488, 227480, 5, 1954},
	{46514, 227484, 4, 1959},
	{46541, 227504, 5, 2137},
	{46572, 227508, 5, 2137},
	{46603, 227512, 6, 2142},
	{46639, 227516, 1, 2750},
	{46663, 227520, 5, 1954},
	{46689, 227524, 4, 1959},
	{46716, 227528, 5, 1954},
	{46742, 227532, 4, 1959},
	{46769, 227552, 5, 2137},
	{46800, 227556, 5, 2137},
	{46831, 227560, 6, 2142},
	{46867, 227564, 1, 2750},
	{46891, 227568, 5, 1954},
	{46917, 227572, 4, 1959},
	{46944, 227576, 5, 1954},
	{46970, 227580, 4, 1959},
	{46997, 227600, 5, 2137},
	{47028, 227604, 5, 2137},
	{47059, 227608, 6, 2142},
	{47095, 227612, 1, 2750},
	{47119, 227616, 5, 1954},
	{47145, 227620, 4, 1959},
	{47172, 227624, 5, 1954},
	{47198, 227628, 4, 1959},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 2162},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 7, 2168},
	{43206, 1168, 12, 2175},
	{43221, 1281, 6, 2187},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
	{43248, 1414, 15, 2193},
};

static const struct si_reg gfx11_reg_table[] = {
	{43257, 40, 1, 2208},
	{43272, 44, 1, 2208},
	{1310, 1028, 10, 2751},
	{1323, 1032, 26, 2761},
	{1338, 1036, 11, 2787},
	{1375, 1044, 2, 2798},
	{1393, 1048, 3, 56},
	{1411, 1052, 4, 2800},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1471, 1076, 2, 78},
	{1487, 1080},
	{1882, 1104},
	{1906, 1108},
	{1504, 1116, 6, 2804},
	{1519, 1120, 6, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1593, 1136, 4, 2810},
	{43295, 1140, 1, 2227},
	{1609, 2480},
	{1623, 2484},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2548},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 22, 2814},
	{1967, 32784, 22, 2836},
	{1979, 32788, 17, 2858},
	{1995, 32792, 17, 2858},
	{2011, 32796, 15, 2875},
	{2024, 32824, 17, 2858},
	{2040, 32828, 17, 2858},
	{47225, 32832, 17, 2858},
	{47241, 32836, 17, 2858},
	{47257, 33280, 1, 2890},
	{47275, 33284},
	{2056, 33296, 23, 2891},
	{2070, 33300, 28, 2914},
	{2087, 33304, 16, 2942},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{43317, 33328, 1, 2958},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 11, 2959},
	{2283, 33436, 1, 342},
	{2687, 36608},
	{2705, 36612, 3, 2970},
	{2723, 36616},
	{2741, 36620, 10, 2973},
	{2759, 36656, 14, 397},
	{2777, 36660, 4, 411},
	{2795, 36664, 8, 2983},
	{2813, 36668, 2, 2991},
	{2847, 39160, 6, 2334},
	{3642, 40960},
	{3660, 40964, 6, 2993},
	{3678, 40968, 2, 453},
	{3696, 40972, 9, 456},
	{3714, 40976, 3, 2340},
	{3732, 40980, 6, 2999},
	{3750, 40984, 11, 3005},
	{3768, 40988},
	{3786, 45060, 5, 3016},
	{3810, 45080},
	{3835, 45084, 3, 3021},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 12, 2362},
	{3925, 45100, 10, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{4371, 45168},
	{4398, 45172},
	{4425, 45176},
	{4452, 45180},
	{4479, 45184},
	{4506, 45188},
	{4533, 45192},
	{4560, 45196},
	{4587, 45200},
	{4614, 45204},
	{4641, 45208},
	{4668, 45212},
	{4695, 45216},
	{4722, 45220},
	{4749, 45224},
	{4776, 45228},
	{4803, 45248, 8, 510},
	{4859, 45256, 1, 523},
	{4886, 45260, 1, 523},
	{4913, 45264, 1, 523},
	{4940, 45268, 1, 523},
	{6254, 45568},
	{6279, 45572, 9, 3024},
	{6303, 45576},
	{6335, 45580},
	{6367, 45584},
	{6391, 45588, 1, 488},
	{6415, 45596, 4, 573},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 13, 577},
	{6505, 45612, 9, 590},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{6951, 45680},
	{6978, 45684},
	{7005, 45688},
	{7032, 45692},
	{7059, 45696},
	{7086, 45700},
	{7113, 45704},
	{7140, 45708},
	{7167, 45712},
	{7194, 45716},
	{7221, 45720},
	{7248, 45724},
	{7275, 45728},
	{7302, 45732},
	{7329, 45736},
	{7356, 45740},
	{47293, 45744, 4, 3033},
	{47319, 45748, 2, 3037},
	{7383, 45760, 8, 510},
	{7443, 45768, 1, 523},
	{7472, 45772, 1, 523},
	{7501, 45776, 1, 523},
	{7530, 45780, 1, 523},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{8149, 46080},
	{8174, 46084, 5, 3016},
	{8198, 46088},
	{8230, 46092},
	{8262, 46096},
	{8286, 46100, 1, 488},
	{8310, 46108, 4, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 12, 613},
	{8400, 46124, 9, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{8846, 46192},
	{8873, 46196},
	{8900, 46200},
	{8927, 46204},
	{8954, 46208},
	{8981, 46212},
	{9008, 46216},
	{9035, 46220},
	{9062, 46224},
	{9089, 46228},
	{9116, 46232},
	{9143, 46236},
	{9170, 46240},
	{9197, 46244},
	{9224, 46248},
	{9251, 46252},
	{9278, 46272, 8, 510},
	{9338, 46280, 1, 523},
	{9367, 46284, 1, 523},
	{9396, 46288, 1, 523},
	{9425, 46292, 1, 523},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{10017, 47104, 15, 3039},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 1, 660},
	{10280, 47160},
	{10309, 47164, 1, 660},
	{10338, 47168},
	{10371, 47172, 1, 660},
	{10404, 47176, 12, 661},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{10477, 47192},
	{10504, 47196},
	{10531, 47200, 2, 3054},
	{10552, 47204},
	{10579, 47208},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 4, 3056},
	{10710, 47232},
	{10730, 47236},
	{10753, 47240, 9, 699},
	{10770, 47248, 1, 523},
	{10791, 47252, 1, 523},
	{10812, 47256, 1, 523},
	{10833, 47260, 1, 523},
	{10854, 47264, 5, 3060},
	{10872, 47268, 1, 709},
	{10891, 47272},
	{47351, 47276, 2, 3065},
	{47382, 47280, 2, 3065},
	{47413, 47284, 2, 3065},
	{47444, 47288, 2, 3065},
	{47475, 47292, 1, 3067},
	{10913, 47296, 3, 710},
	{10930, 47300},
	{10959, 47304, 1, 713},
	{10988, 47308, 3, 710},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11332, 47604, 2, 714},
	{11356, 47608},
	{11377, 47612},
	{11393, 163840, 15, 3068},
	{11411, 163844, 10, 727},
	{11428, 163848, 7, 737},
	{11442, 163852, 22, 3083},
	{11461, 163856, 18, 3105},
	{11481, 163860},
	{11500, 163868, 2, 783},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{11653, 163900, 8, 3123},
	{11671, 163904, 14, 801},
	{11681, 163908, 9, 815},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{11771, 163928, 2, 824},
	{11789, 163932, 1, 826},
	{11807, 163944, 1, 827},
	{11825, 163948, 1, 827},
	{11849, 163952, 1, 827},
	{11868, 163956, 1, 827},
	{11893, 163960, 1, 827},
	{11915, 163964, 13, 3131},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14004, 164700, 4, 3144},
	{14033, 164704, 1, 899},
	{14054, 164708, 1, 900},
	{14064, 164712, 1, 901},
	{43389, 164716},
	{43411, 164720},
	{47503, 164816, 5, 3148},
	{47527, 164820},
	{47556, 164824, 1, 1612},
	{47589, 164828, 2, 3153},
	{47621, 164836, 11, 3155},
	{47647, 164848},
	{47667, 164852, 2, 3166},
	{47691, 164856, 2, 3153},
	{14182, 164876},
	{14211, 164880, 7, 3168},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{47714, 164900, 8, 3175},
	{14308, 164904, 4, 928},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16814, 165404},
	{47730, 165408, 2, 3183},
	{16837, 165444, 13, 3185},
	{16857, 165448, 13, 3185},
	{16877, 165452, 13, 3185},
	{16897, 165456, 13, 3185},
	{16917, 165460, 13, 3185},
	{16937, 165464, 13, 3185},
	{16957, 165468, 13, 3185},
	{16977, 165472, 13, 3185},
	{16997, 165476, 13, 3185},
	{17017, 165480, 13, 3185},
	{17037, 165484, 13, 3185},
	{17058, 165488, 13, 3185},
	{17079, 165492, 13, 3185},
	{17100, 165496, 13, 3185},
	{17121, 165500, 13, 3185},
	{17142, 165504, 13, 3185},
	{17163, 165508, 13, 3185},
	{17184, 165512, 13, 3185},
	{17205, 165516, 13, 3185},
	{17226, 165520, 13, 3185},
	{17247, 165524, 11, 3198},
	{17268, 165528, 11, 3198},
	{17289, 165532, 11, 3198},
	{17310, 165536, 11, 3198},
	{17331, 165540, 11, 3198},
	{17352, 165544, 11, 3198},
	{17373, 165548, 11, 3198},
	{17394, 165552, 11, 3198},
	{17415, 165556, 11, 3198},
	{17436, 165560, 11, 3198},
	{17457, 165564, 11, 3198},
	{17478, 165568, 11, 3198},
	{17499, 165572, 3, 3209},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 7, 3212},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 3054},
	{47743, 165612},
	{47767, 165616, 1, 660},
	{17623, 165640, 1, 1006},
	{17645, 165644, 5, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{43433, 165712, 8, 2472},
	{17709, 165716, 8, 3219},
	{17727, 165720, 8, 1029},
	{17748, 165724, 17, 1037},
	{17769, 165728, 6, 1054},
	{17787, 165732, 6, 1054},
	{17805, 165736, 6, 1054},
	{17823, 165740, 6, 1054},
	{17841, 165744, 6, 1054},
	{17859, 165748, 6, 1054},
	{17877, 165752, 6, 1054},
	{17895, 165756, 6, 1054},
	{17913, 165760, 9, 3227},
	{17931, 165764, 9, 3227},
	{17949, 165768, 9, 3227},
	{17967, 165772, 9, 3227},
	{17985, 165776, 9, 3227},
	{18003, 165780, 9, 3227},
	{18021, 165784, 9, 3227},
	{18039, 165788, 9, 3227},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 1070},
	{18176, 165864},
	{18189, 165872, 6, 2488},
	{18223, 165880, 1, 1079},
	{18245, 165884, 1, 1080},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 5, 3236},
	{18314, 165900, 18, 3241},
	{18332, 165904, 20, 1124},
	{18348, 165908, 16, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 29, 3259},
	{18400, 165920, 16, 1198},
	{18418, 165924, 3, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18490, 165936, 5, 1229},
	{18541, 165944, 3, 2529},
	{18556, 165948, 5, 1240},
	{18586, 165952, 5, 1245},
	{18601, 165956},
	{43459, 165960, 6, 2532},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18724, 166424},
	{18747, 166428},
	{18973, 166472, 6, 2538},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 9, 2544},
	{19213, 166528},
	{19224, 166532, 3, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 3288},
	{19334, 166552, 4, 2553},
	{19425, 166572, 1, 1367},
	{19471, 166580, 1, 1368},
	{19500, 166588, 9, 1370},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20038, 166732, 2, 1394},
	{20057, 166736, 5, 1396},
	{20079, 166740, 17, 3291},
	{20100, 166744, 3, 1420},
	{20207, 166764, 11, 3308},
	{20220, 166768, 6, 1435},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 3, 1443},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 5, 1474},
	{20592, 166880, 8, 2587},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21307, 166976, 5, 3319},
	{21328, 166980, 12, 1528},
	{21348, 166984, 2, 1540},
	{21368, 166988, 20, 1542},
	{21406, 166992, 6, 3324},
	{47791, 166996, 10, 3330},
	{21475, 167008},
	{21522, 167020, 3, 1569},
	{21537, 167024, 10, 3340},
	{21552, 167028, 5, 3350},
	{47811, 167032, 17, 3355},
	{21711, 167060},
	{21730, 167068},
	{21777, 167080, 3, 1569},
	{21792, 167084, 10, 3340},
	{21807, 167088, 5, 3350},
	{47834, 167092, 17, 3355},
	{21966, 167120},
	{21985, 167128},
	{22032, 167140, 3, 1569},
	{22047, 167144, 10, 3340},
	{22062, 167148, 5, 3350},
	{47857, 167152, 17, 3355},
	{22221, 167180},
	{22240, 167188},
	{22287, 167200, 3, 1569},
	{22302, 167204, 10, 3340},
	{22317, 167208, 5, 3350},
	{47880, 167212, 17, 3355},
	{22476, 167240},
	{22495, 167248},
	{22542, 167260, 3, 1569},
	{22557, 167264, 10, 3340},
	{22572, 167268, 5, 3350},
	{47903, 167272, 17, 3355},
	{22731, 167300},
	{22750, 167308},
	{22797, 167320, 3, 1569},
	{22812, 167324, 10, 3340},
	{22827, 167328, 5, 3350},
	{47926, 167332, 17, 3355},
	{22986, 167360},
	{23005, 167368},
	{23052, 167380, 3, 1569},
	{23067, 167384, 10, 3340},
	{23082, 167388, 5, 3350},
	{47949, 167392, 17, 3355},
	{23241, 167420},
	{23260, 167428},
	{23307, 167440, 3, 1569},
	{23322, 167444, 10, 3340},
	{23337, 167448, 5, 3350},
	{47972, 167452, 17, 3355},
	{23496, 167480},
	{23515, 167488, 1, 1612},
	{23534, 167492, 1, 1612},
	{23553, 167496, 1, 1612},
	{23572, 167500, 1, 1612},
	{23591, 167504, 1, 1612},
	{23610, 167508, 1, 1612},
	{23629, 167512, 1, 1612},
	{23648, 167516, 1, 1612},
	{24067, 167584, 1, 1612},
	{24090, 167588, 1, 1612},
	{24113, 167592, 1, 1612},
	{24136, 167596, 1, 1612},
	{24159, 167600, 1, 1612},
	{24182, 167604, 1, 1612},
	{24205, 167608, 1, 1612},
	{24228, 167612, 1, 1612},
	{24251, 167616, 3, 1613},
	{24269, 167620, 3, 1613},
	{24287, 167624, 3, 1613},
	{24305, 167628, 3, 1613},
	{24323, 167632, 3, 1613},
	{24341, 167636, 3, 1613},
	{24359, 167640, 3, 1613},
	{24377, 167644, 3, 1613},
	{24395, 167648, 5, 3372},
	{24413, 167652, 5, 3372},
	{24431, 167656, 5, 3372},
	{24449, 167660, 5, 3372},
	{24467, 167664, 5, 3372},
	{24485, 167668, 5, 3372},
	{24503, 167672, 5, 3372},
	{24521, 167676, 5, 3372},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{47995, 196808},
	{48019, 196812},
	{25841, 196852, 1, 1631},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{43474, 196896, 5, 2637},
	{26028, 196908, 1, 660},
	{26047, 196912},
	{26065, 196916},
	{26092, 196920},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 6, 3377},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 1, 1640},
	{26554, 197032, 7, 3383},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 1, 1643},
	{26626, 197048, 5, 3390},
	{26644, 197052},
	{26662, 197056, 2, 2642},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 2642},
	{26744, 197080, 5, 1648},
	{26764, 197084, 9, 3395},
	{26783, 197088, 9, 3395},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 7, 1679},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 7, 1679},
	{27102, 197160, 7, 1686},
	{27114, 197164, 2, 1693},
	{27148, 197172, 1, 1696},
	{27166, 197176, 6, 3404},
	{27186, 197180, 2, 330},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27246, 197196, 1, 1705},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27392, 197232, 2, 1710},
	{27414, 197236, 2, 1712},
	{27436, 197240, 2, 1710},
	{27459, 197244, 2, 1712},
	{27482, 197248, 2, 1710},
	{27504, 197252, 2, 1712},
	{43493, 197256},
	{43515, 197260},
	{48043, 197264},
	{48065, 197268},
	{48087, 197272},
	{48110, 197276},
	{27604, 197380, 1, 1716},
	{27621, 197384, 1, 1717},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 6, 3410},
	{27945, 197464, 6, 3416},
	{27967, 197468, 1, 1737},
	{27987, 197472, 1, 1738},
	{28001, 197476, 1, 1739},
	{28015, 197480, 1, 1740},
	{28027, 197484, 1, 1741},
	{28111, 197552, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28493, 197624, 13, 1752},
	{28510, 197628},
	{28527, 197632, 1, 1695},
	{28547, 197636},
	{28564, 197640, 1, 1660},
	{28584, 197644, 2, 1765},
	{28603, 197888, 8, 1767},
	{28624, 197892, 8, 1767},
	{28645, 198656, 6, 1775},
	{28698, 198920, 1, 3422},
	{28717, 198924, 2, 2654},
	{28864, 198948},
	{28880, 198952},
	{28895, 198956, 3, 3423},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 3426},
	{28972, 198972, 2, 2656},
	{28993, 198976},
	{29173, 199012},
	{29189, 199016},
	{29210, 199020, 8, 3427},
	{29218, 199024},
	{29232, 199028},
	{29246, 199032},
	{29260, 199036, 3, 1798},
	{29275, 199040, 2, 1801},
	{29287, 199044, 1, 827},
	{29309, 199048, 3, 1803},
	{43689, 199052, 2, 2658},
	{48133, 199056, 2, 3435},
	{48158, 199060, 1, 3437},
	{19132, 199064, 1, 3438},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{29983, 199952},
	{30010, 199956},
	{30037, 199960},
	{30064, 199964},
	{30091, 199968, 4, 2660},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 3439},
	{30586, 200756, 2, 3441},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 9, 3443},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 1858},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{48185, 200840},
	{48214, 200844},
	{48243, 200848},
	{48272, 200852},
	{48301, 200856},
	{48310, 200860},
	{48319, 200864},
	{48328, 200868},
	{48337, 200872},
	{48367, 200876},
	{48397, 200880},
	{48428, 200884},
	{48459, 200888},
	{48489, 200892},
	{48519, 200896},
	{48550, 200900},
	{48581, 200904},
	{48611, 200908},
	{48641, 200912},
	{48672, 200916},
	{48703, 200920},
	{48733, 200924},
	{48763, 200928},
	{48794, 200932},
	{2831, 200960, 7, 3452},
	{48825, 200964, 13, 3459},
	{48843, 200968, 7, 3472},
	{48861, 200972, 3, 3479},
	{48881, 200976, 8, 3482},
	{48903, 200980, 8, 3490},
	{48925, 200984},
	{48949, 200988, 6, 3498},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31252, 213040},
	{31275, 213044},
	{31298, 213048},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{48973, 213300},
	{48997, 213304},
	{49021, 213308},
	{49045, 213312},
	{49069, 213316},
	{49093, 213320},
	{43701, 213648},
	{43721, 213652},
	{43741, 213656},
	{43761, 213660},
	{43781, 213664},
	{43801, 213668},
	{43821, 213672},
	{43841, 213676},
	{43861, 213680},
	{43886, 213684},
	{43911, 213688},
	{43936, 213692},
	{43961, 213696},
	{43986, 213700},
	{44011, 213704},
	{44036, 213708},
	{44061, 213712},
	{44084, 213716},
	{44107, 213720},
	{44130, 213724},
	{44153, 213728},
	{44176, 213732},
	{44199, 213736},
	{44222, 213740},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{31153, 214576},
	{31133, 214580},
	{31113, 214584},
	{31093, 214588},
	{49117, 214592},
	{49136, 214596},
	{49155, 214600},
	{49174, 214604},
	{32825, 214784},
	{32863, 214792},
	{32901, 214800},
	{32939, 214808},
	{32977, 214816},
	{33015, 214824},
	{33053, 214832},
	{33091, 214840},
	{49193, 214928},
	{49213, 214932},
	{49233, 214936},
	{49253, 214940},
	{49273, 214944},
	{49293, 214948},
	{49313, 214952},
	{49333, 214956},
	{49353, 214960},
	{49373, 214964},
	{49393, 214968},
	{49413, 214972},
	{49433, 214976},
	{49453, 214980},
	{49473, 214984},
	{49493, 214988},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33597, 215424},
	{33618, 215428},
	{44245, 215432},
	{44265, 215436, 2, 1867},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{49513, 216352, 12, 3504},
	{49536, 216356, 1, 3516},
	{49560, 216360, 13, 3517},
	{34111, 216576},
	{34132, 216580},
	{34153, 216584},
	{34174, 216588},
	{34195, 216592},
	{34216, 216596},
	{34237, 216600},
	{34258, 216604},
	{34279, 216640},
	{34300, 216644},
	{34321, 216648},
	{34342, 216652},
	{34363, 216656},
	{34384, 216660},
	{34405, 216664},
	{34426, 216668},
	{34447, 216704},
	{34468, 216708},
	{34489, 216712},
	{34510, 216716},
	{34531, 216720},
	{34552, 216724},
	{34573, 216728},
	{34594, 216732},
	{34615, 216832},
	{34635, 216836},
	{34655, 216840},
	{34675, 216844},
	{34695, 216848},
	{34715, 216852},
	{34735, 216856},
	{34755, 216860},
	{34775, 216864},
	{34796, 216868},
	{34817, 216872},
	{34838, 216876},
	{34859, 216880},
	{34880, 216884},
	{34901, 216888},
	{34922, 216892},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{35327, 217856},
	{35347, 217860},
	{35367, 217864},
	{35387, 217868},
	{35407, 217872},
	{35427, 217876},
	{35447, 217880},
	{35467, 217884},
	{35589, 217984},
	{35614, 217988},
	{35639, 217992},
	{35664, 217996},
	{35537, 218000},
	{35563, 218004, 2, 1867},
	{44285, 218008},
	{44308, 218012, 2, 1867},
	{35829, 218240},
	{35849, 218244},
	{35869, 218248},
	{35889, 218252},
	{35909, 218624},
	{35931, 218628},
	{35953, 218632},
	{35975, 218636},
	{35997, 218640},
	{36019, 218644},
	{36041, 218648},
	{36063, 218652},
	{36085, 218656},
	{36107, 218660},
	{36129, 218664},
	{36151, 218668},
	{36173, 218672},
	{36195, 218676},
	{36217, 218680},
	{36239, 218684},
	{35741, 218752},
	{35763, 218756},
	{35785, 218760},
	{35807, 218764},
	{49586, 218768},
	{49608, 218772},
	{49630, 218776},
	{49652, 218780},
	{36261, 218880},
	{36282, 218884},
	{36303, 218888},
	{36324, 218892},
	{36345, 218896},
	{36366, 218900},
	{36387, 218904},
	{36408, 218908},
	{49674, 218944},
	{49695, 218948},
	{49716, 218952},
	{49737, 218956},
	{49758, 218960},
	{49779, 218964},
	{49800, 218968},
	{49821, 218972},
	{36429, 219136},
	{36449, 219140},
	{36469, 219144},
	{36489, 219148},
	{36509, 219152},
	{36529, 219156},
	{36549, 219160},
	{36569, 219164},
	{36589, 219392},
	{36609, 219396},
	{44331, 219400},
	{44350, 219404, 2, 1867},
	{44369, 219520},
	{44398, 219524, 2, 1867},
	{44427, 219528},
	{44449, 219532},
	{44471, 219536},
	{44493, 219540},
	{44515, 219568},
	{44544, 219572, 2, 1867},
	{44573, 219576},
	{44595, 219580},
	{44617, 219584},
	{44639, 219588},
	{36629, 221184, 3, 3530},
	{36653, 221188, 4, 1874},
	{36678, 221192, 5, 1869},
	{36702, 221196, 3, 3530},
	{36726, 221200, 4, 1874},
	{36751, 221204, 3, 3530},
	{36775, 221208, 4, 1874},
	{36800, 221212, 5, 1869},
	{36824, 221216, 4, 1878},
	{36840, 221220, 5, 1869},
	{36864, 221224, 3, 1882},
	{36898, 221228, 3, 1885},
	{36932, 221232, 3, 1888},
	{36957, 221236, 3, 1891},
	{36982, 221240, 3, 1888},
	{49842, 221244, 3, 1885},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 20, 1900},
	{37149, 221444, 20, 1900},
	{37174, 221448, 18, 3533},
	{37202, 221452, 18, 3533},
	{37230, 221456, 18, 3533},
	{37258, 221460, 18, 3533},
	{49876, 221464, 18, 3533},
	{49904, 221468, 18, 3533},
	{49932, 221472, 18, 3533},
	{37286, 221492, 9, 3551},
	{37314, 221496, 9, 3551},
	{44953, 221840, 5, 3560},
	{44977, 221844, 4, 1959},
	{45002, 221848, 5, 3560},
	{45026, 221852, 4, 1959},
	{45051, 221856, 5, 3560},
	{45075, 221860, 4, 1959},
	{45100, 221864, 5, 3560},
	{45124, 221868, 4, 1959},
	{45149, 221872, 5, 3560},
	{45178, 221876, 4, 1959},
	{45208, 221880, 5, 3560},
	{45237, 221884, 4, 1959},
	{45267, 221888, 5, 3560},
	{45296, 221892, 4, 1959},
	{45326, 221896, 5, 3560},
	{45355, 221900, 4, 1959},
	{45385, 221904, 5, 3560},
	{45412, 221908, 4, 1959},
	{45440, 221912, 5, 3560},
	{45467, 221916, 4, 1959},
	{45495, 221920, 5, 3560},
	{45522, 221924, 4, 1959},
	{45550, 221928, 5, 3560},
	{45577, 221932, 4, 1959},
	{37716, 222208, 5, 1954},
	{37742, 222212, 4, 1959},
	{37769, 222216, 5, 1954},
	{37795, 222220, 4, 1959},
	{37822, 222224, 5, 1954},
	{37848, 222228, 4, 1959},
	{37875, 222232, 5, 1954},
	{37901, 222236, 4, 1959},
	{37928, 222464, 5, 1954},
	{37954, 222468, 4, 1959},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 5, 1954},
	{38187, 222724, 5, 1954},
	{38211, 222728, 5, 1954},
	{38235, 222732, 5, 1954},
	{38259, 222736, 4, 1959},
	{38284, 222740, 4, 1959},
	{38309, 222744, 4, 1959},
	{38334, 222748, 4, 1959},
	{38359, 222752, 1, 1869},
	{38383, 222756, 1, 1869},
	{38407, 222760, 8, 1963},
	{36841, 222768, 5, 1954},
	{36703, 222772, 5, 1954},
	{49960, 222776, 5, 1954},
	{49983, 222780, 5, 1954},
	{36727, 222784, 4, 1959},
	{50006, 222788, 4, 1959},
	{50030, 222792, 4, 1959},
	{50054, 222796, 4, 1959},
	{38428, 222976, 3, 2676},
	{38451, 222980, 3, 2676},
	{38474, 222984, 3, 2676},
	{38497, 222988, 3, 2676},
	{38520, 222992, 3, 2676},
	{38543, 222996, 3, 2676},
	{38566, 223000, 3, 2676},
	{38589, 223004, 3, 2676},
	{38612, 223008, 3, 2676},
	{38635, 223012, 3, 2676},
	{38658, 223016, 3, 2676},
	{38682, 223020, 3, 2676},
	{38706, 223024, 3, 2676},
	{38730, 223028, 3, 2676},
	{38754, 223032, 3, 2676},
	{38778, 223036, 3, 2676},
	{50078, 223040, 3, 2676},
	{50102, 223044, 3, 2676},
	{50126, 223048, 3, 2676},
	{50150, 223052, 3, 2676},
	{50174, 223056, 3, 2676},
	{50198, 223060, 3, 2676},
	{50222, 223064, 3, 2676},
	{50246, 223068, 3, 2676},
	{50270, 223072, 10, 3565},
	{50291, 223080, 2, 3575},
	{50313, 223084, 1, 3577},
	{38802, 223104, 10, 3565},
	{38822, 223112, 2, 3575},
	{2306, 223136},
	{2332, 223140, 2, 343},
	{2358, 223144},
	{2384, 223148, 2, 343},
	{2479, 223152, 18, 3578},
	{2431, 223156, 5, 3596},
	{2452, 223160, 7, 3601},
	{2410, 223164, 2, 345},
	{2500, 223184, 5, 3608},
	{43344, 223188, 6, 3613},
	{2552, 223192},
	{2582, 223196},
	{2614, 223200},
	{2645, 223204},
	{2523, 223208},
	{38843, 223232, 5, 1954},
	{38868, 223236, 4, 1959},
	{38894, 223240, 8, 1985},
	{45605, 223244, 5, 2137},
	{45627, 223248, 5, 2137},
	{45649, 223252, 6, 2142},
	{38917, 223488, 5, 1954},
	{38940, 223492, 5, 1954},
	{38963, 223496, 3, 2010},
	{38986, 223500, 3, 2010},
	{39009, 223504, 4, 1959},
	{39033, 223508, 4, 1959},
	{39057, 223744, 5, 1954},
	{39081, 223748, 5, 1954},
	{39105, 223752, 5, 1954},
	{39129, 223756, 5, 1954},
	{39153, 223760, 4, 1959},
	{45676, 223764, 4, 1959},
	{45701, 223768, 4, 1959},
	{45726, 223772, 4, 1959},
	{39178, 224000, 5, 1954},
	{39201, 224004, 4, 1959},
	{39225, 224008, 3, 2010},
	{39248, 224256, 5, 1954},
	{39271, 224260, 4, 1959},
	{39295, 224264, 3, 2010},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{39464, 224768, 5, 1954},
	{39489, 224772, 4, 1948},
	{39515, 224776, 5, 1954},
	{39540, 224780, 4, 1948},
	{39566, 224784, 3, 2010},
	{39591, 224788, 3, 2010},
	{39616, 224832, 5, 1954},
	{39641, 224836, 4, 1948},
	{39667, 224840, 5, 1954},
	{39692, 224844, 4, 1948},
	{39718, 224848, 3, 2010},
	{39743, 224852, 3, 2010},
	{39768, 224896, 5, 1954},
	{39793, 224900, 4, 1948},
	{39819, 224904, 3, 2010},
	{39844, 224908, 3, 2010},
	{39869, 224912, 3, 2010},
	{39894, 225024, 5, 1954},
	{39918, 225028, 4, 1948},
	{39943, 225032, 3, 2010},
	{39967, 225036, 3, 2010},
	{39991, 225040, 3, 2010},
	{40015, 225048, 5, 1954},
	{40040, 225052, 4, 1948},
	{40066, 225056, 3, 2010},
	{40091, 225060, 3, 2010},
	{40116, 225064, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 1954},
	{40186, 225288, 4, 1959},
	{40210, 225292, 2, 3619},
	{40233, 225296, 2, 3619},
	{40256, 225300, 2, 3619},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 5, 3621},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40955, 225808, 2, 2067},
	{40553, 225812},
	{40572, 225816, 2, 2049},
	{40524, 225820, 3, 3626},
	{40644, 225824, 1, 3629},
	{40671, 225828, 2, 3630},
	{40598, 225832, 1, 3629},
	{40621, 225836, 2, 3630},
	{40974, 225864, 2, 2069},
	{41001, 225868},
	{45941, 225872, 2, 2069},
	{45972, 225876},
	{41028, 225880, 2, 2694},
	{41055, 225884, 2, 2073},
	{46003, 225888, 4, 2743},
	{41082, 225892, 18, 3632},
	{41103, 225896, 9, 2713},
	{41122, 225900, 22, 3650},
	{41141, 225904, 1, 2101},
	{41165, 225908, 1, 2103},
	{41197, 225912, 2, 2105},
	{46074, 225916, 3, 2747},
	{50336, 225928, 2, 3672},
	{50350, 225932, 10, 3674},
	{45811, 225936},
	{45784, 225940},
	{50365, 225972, 1, 3684},
	{50378, 225976},
	{50403, 225980, 1, 3685},
	{50428, 225984, 1, 3686},
	{50448, 225988},
	{50470, 225992, 2, 3687},
	{50490, 225996},
	{50518, 226000, 1, 3685},
	{50546, 226004, 1, 3686},
	{50569, 226008},
	{50594, 226012, 2, 3687},
	{50617, 226016, 1, 3689},
	{50634, 226020, 9, 3690},
	{50655, 226044},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{41399, 226060, 4, 2119},
	{41425, 226064, 3, 2123},
	{41454, 226068, 1, 684},
	{41483, 226072, 3, 2123},
	{41512, 226076, 1, 684},
	{41589, 226304, 5, 1954},
	{41613, 226308, 4, 1959},
	{41638, 226312, 2, 3619},
	{41662, 226316, 5, 1954},
	{41686, 226320, 4, 1959},
	{41711, 226324, 2, 3619},
	{41735, 226328, 10, 2127},
	{42100, 226432, 5, 1954},
	{42129, 226436, 5, 1954},
	{42158, 226440, 4, 1959},
	{42188, 226444, 4, 1959},
	{42218, 226448, 8, 1985},
	{42245, 226452, 8, 1985},
	{41843, 226496, 5, 2137},
	{41871, 226500, 5, 2137},
	{41899, 226504, 5, 2137},
	{41927, 226508, 5, 2137},
	{41955, 226512, 5, 2137},
	{41983, 226516, 5, 2137},
	{42011, 226520, 5, 2137},
	{42039, 226524, 5, 2137},
	{42067, 226528, 6, 2142},
	{46115, 226532, 5, 2137},
	{46140, 226536, 5, 2137},
	{46165, 226540, 5, 2137},
	{46190, 226544, 5, 2137},
	{46215, 226548, 6, 2142},
	{42361, 226688, 5, 1954},
	{42385, 226692, 4, 1959},
	{42410, 226696, 3, 2010},
	{42486, 226816, 5, 1954},
	{42512, 226820, 4, 1959},
	{42539, 226824, 5, 1954},
	{42565, 226828, 5, 1954},
	{42591, 226832, 5, 1954},
	{42617, 226836, 1, 1869},
	{42643, 226840, 1, 1869},
	{42669, 226844, 1, 1869},
	{42695, 226848, 1, 1869},
	{42721, 226880, 4, 1959},
	{42748, 226884, 4, 1959},
	{42775, 226888, 4, 1959},
	{42434, 226944, 2, 2151},
	{42460, 226948, 2, 2151},
	{50669, 226952, 2, 2151},
	{50695, 226956, 2, 2151},
	{42802, 227072, 5, 1954},
	{42827, 227076, 4, 1948},
	{42853, 227080, 3, 2010},
	{42878, 227084, 3, 2010},
	{42903, 227088, 3, 2010},
	{50721, 227136, 5, 1954},
	{50746, 227140, 4, 1948},
	{50772, 227144, 3, 2010},
	{50797, 227148, 3, 2010},
	{50822, 227152, 3, 2010},
	{42928, 227200, 5, 1954},
	{42952, 227204, 4, 1948},
	{42977, 227208, 3, 2010},
	{43001, 227212, 3, 2010},
	{43025, 227216, 3, 2010},
	{43049, 227328, 5, 1954},
	{43073, 227332, 4, 1959},
	{43098, 227336, 8, 1985},
	{46245, 227340, 5, 2137},
	{46266, 227344, 5, 2137},
	{46287, 227348, 6, 2142},
	{46313, 227456, 5, 2137},
	{46344, 227460, 5, 2137},
	{46375, 227464, 6, 2142},
	{46411, 227468, 1, 2750},
	{46435, 227472, 5, 1954},
	{46461, 227476, 4, 1959},
	{46488, 227480, 5, 1954},
	{46514, 227484, 4, 1959},
	{46541, 227504, 5, 2137},
	{46572, 227508, 5, 2137},
	{46603, 227512, 6, 2142},
	{46639, 227516, 1, 2750},
	{46663, 227520, 5, 1954},
	{46689, 227524, 4, 1959},
	{46716, 227528, 5, 1954},
	{46742, 227532, 4, 1959},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 2162},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 7, 2168},
	{43206, 1168, 18, 3699},
	{43221, 1281, 6, 2187},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
	{50847, 1408, 4, 3717},
	{50865, 1413, 1, 3721},
	{43248, 1414, 15, 2193},
};

static const struct si_reg gfx115_reg_table[] = {
	{43257, 40, 1, 2208},
	{43272, 44, 1, 2208},
	{1310, 1028, 10, 2751},
	{1323, 1032, 26, 2761},
	{1338, 1036, 11, 2787},
	{1375, 1044, 2, 2798},
	{1393, 1048, 3, 56},
	{1411, 1052, 4, 2800},
	{1426, 1056},
	{1440, 1060, 1, 70},
	{1471, 1076, 2, 78},
	{1487, 1080},
	{1882, 1104},
	{1906, 1108},
	{1504, 1116, 6, 2804},
	{1519, 1120, 6, 85},
	{1534, 1124, 2, 92},
	{1554, 1128, 1, 94},
	{1593, 1136, 4, 2810},
	{43295, 1140, 1, 2227},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2548},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 22, 3722},
	{1967, 32784, 22, 2836},
	{1979, 32788, 16, 3744},
	{2011, 32796, 14, 3760},
	{47257, 33280, 1, 2890},
	{47275, 33284},
	{2056, 33296, 23, 2891},
	{2070, 33300, 28, 2914},
	{2087, 33304, 16, 2942},
	{2108, 33308, 28, 247},
	{2122, 33312, 32, 275},
	{2139, 33316, 13, 307},
	{2160, 33320, 9, 320},
	{2178, 33324, 1, 329},
	{2201, 33344, 2, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2265, 33356, 11, 2959},
	{2283, 33436, 1, 342},
	{2847, 39160, 6, 2334},
	{3786, 45060, 5, 3016},
	{3810, 45080},
	{3835, 45084, 3, 3021},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 12, 2362},
	{3925, 45100, 10, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{4371, 45168},
	{4398, 45172},
	{4425, 45176},
	{4452, 45180},
	{4479, 45184},
	{4506, 45188},
	{4533, 45192},
	{4560, 45196},
	{4587, 45200},
	{4614, 45204},
	{4641, 45208},
	{4668, 45212},
	{4695, 45216},
	{4722, 45220},
	{4749, 45224},
	{4776, 45228},
	{4803, 45248, 8, 510},
	{4859, 45256, 1, 523},
	{4886, 45260, 1, 523},
	{4913, 45264, 1, 523},
	{4940, 45268, 1, 523},
	{6254, 45568},
	{6279, 45572, 9, 3024},
	{6303, 45576},
	{6335, 45580},
	{6367, 45584},
	{6391, 45588, 1, 488},
	{6415, 45596, 4, 573},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 13, 577},
	{6505, 45612, 9, 590},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{6951, 45680},
	{6978, 45684},
	{7005, 45688},
	{7032, 45692},
	{7059, 45696},
	{7086, 45700},
	{7113, 45704},
	{7140, 45708},
	{7167, 45712},
	{7194, 45716},
	{7221, 45720},
	{7248, 45724},
	{7275, 45728},
	{7302, 45732},
	{7329, 45736},
	{7356, 45740},
	{47293, 45744, 4, 3033},
	{47319, 45748, 2, 3037},
	{7383, 45760, 8, 510},
	{7443, 45768, 1, 523},
	{7472, 45772, 1, 523},
	{7501, 45776, 1, 523},
	{7530, 45780, 1, 523},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{8149, 46080},
	{8174, 46084, 5, 3016},
	{8198, 46088},
	{8230, 46092},
	{8262, 46096},
	{8286, 46100, 1, 488},
	{8310, 46108, 4, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 12, 613},
	{8400, 46124, 9, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{8846, 46192},
	{8873, 46196},
	{8900, 46200},
	{8927, 46204},
	{8954, 46208},
	{8981, 46212},
	{9008, 46216},
	{9035, 46220},
	{9062, 46224},
	{9089, 46228},
	{9116, 46232},
	{9143, 46236},
	{9170, 46240},
	{9197, 46244},
	{9224, 46248},
	{9251, 46252},
	{9278, 46272, 8, 510},
	{9338, 46280, 1, 523},
	{9367, 46284, 1, 523},
	{9396, 46288, 1, 523},
	{9425, 46292, 1, 523},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{10017, 47104, 15, 3039},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 1, 660},
	{10280, 47160},
	{10309, 47164, 1, 660},
	{10338, 47168},
	{10371, 47172, 1, 660},
	{10404, 47176, 12, 661},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{10477, 47192},
	{10504, 47196},
	{10531, 47200, 2, 3054},
	{10552, 47204},
	{10579, 47208},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 4, 3056},
	{10710, 47232},
	{10730, 47236},
	{10753, 47240, 9, 699},
	{10770, 47248, 1, 523},
	{10791, 47252, 1, 523},
	{10812, 47256, 1, 523},
	{10833, 47260, 1, 523},
	{10854, 47264, 5, 3060},
	{10872, 47268, 1, 709},
	{10891, 47272},
	{47351, 47276, 2, 3065},
	{47382, 47280, 2, 3065},
	{47413, 47284, 2, 3065},
	{47444, 47288, 2, 3065},
	{47475, 47292, 1, 3067},
	{10913, 47296, 3, 710},
	{10930, 47300},
	{10959, 47304, 1, 713},
	{10988, 47308, 3, 710},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11332, 47604, 2, 714},
	{11356, 47608},
	{11377, 47612},
	{11393, 163840, 15, 3068},
	{11411, 163844, 10, 727},
	{11428, 163848, 7, 737},
	{11442, 163852, 22, 3083},
	{11461, 163856, 18, 3105},
	{11481, 163860},
	{11500, 163868, 2, 783},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{11653, 163900, 8, 3123},
	{11671, 163904, 14, 801},
	{11681, 163908, 9, 815},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{11771, 163928, 2, 824},
	{11789, 163932, 1, 826},
	{50883, 163936, 8, 3774},
	{11807, 163944, 1, 827},
	{11825, 163948, 1, 827},
	{11849, 163952, 1, 827},
	{11868, 163956, 1, 827},
	{11893, 163960, 1, 827},
	{11915, 163964, 13, 3131},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14004, 164700, 4, 3144},
	{14033, 164704, 1, 899},
	{14054, 164708, 1, 900},
	{14064, 164712, 1, 901},
	{43389, 164716},
	{43411, 164720},
	{47503, 164816, 5, 3148},
	{47527, 164820},
	{47556, 164824, 1, 1612},
	{47589, 164828, 2, 3153},
	{47621, 164836, 11, 3155},
	{47647, 164848},
	{47667, 164852, 2, 3166},
	{47691, 164856, 2, 3153},
	{14182, 164876},
	{14211, 164880, 7, 3168},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{47714, 164900, 8, 3175},
	{14308, 164904, 4, 928},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16814, 165404},
	{47730, 165408, 2, 3183},
	{16837, 165444, 13, 3185},
	{16857, 165448, 13, 3185},
	{16877, 165452, 13, 3185},
	{16897, 165456, 13, 3185},
	{16917, 165460, 13, 3185},
	{16937, 165464, 13, 3185},
	{16957, 165468, 13, 3185},
	{16977, 165472, 13, 3185},
	{16997, 165476, 13, 3185},
	{17017, 165480, 13, 3185},
	{17037, 165484, 13, 3185},
	{17058, 165488, 13, 3185},
	{17079, 165492, 13, 3185},
	{17100, 165496, 13, 3185},
	{17121, 165500, 13, 3185},
	{17142, 165504, 13, 3185},
	{17163, 165508, 13, 3185},
	{17184, 165512, 13, 3185},
	{17205, 165516, 13, 3185},
	{17226, 165520, 13, 3185},
	{17247, 165524, 11, 3198},
	{17268, 165528, 11, 3198},
	{17289, 165532, 11, 3198},
	{17310, 165536, 11, 3198},
	{17331, 165540, 11, 3198},
	{17352, 165544, 11, 3198},
	{17373, 165548, 11, 3198},
	{17394, 165552, 11, 3198},
	{17415, 165556, 11, 3198},
	{17436, 165560, 11, 3198},
	{17457, 165564, 11, 3198},
	{17478, 165568, 11, 3198},
	{17499, 165572, 3, 3209},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 7, 3212},
	{50910, 165596, 2, 3782},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 3054},
	{47743, 165612},
	{47767, 165616, 1, 660},
	{17623, 165640, 1, 1006},
	{17645, 165644, 5, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{43433, 165712, 8, 2472},
	{17709, 165716, 8, 3219},
	{17727, 165720, 8, 1029},
	{17748, 165724, 17, 1037},
	{17769, 165728, 6, 1054},
	{17787, 165732, 6, 1054},
	{17805, 165736, 6, 1054},
	{17823, 165740, 6, 1054},
	{17841, 165744, 6, 1054},
	{17859, 165748, 6, 1054},
	{17877, 165752, 6, 1054},
	{17895, 165756, 6, 1054},
	{17913, 165760, 9, 3227},
	{17931, 165764, 9, 3227},
	{17949, 165768, 9, 3227},
	{17967, 165772, 9, 3227},
	{17985, 165776, 9, 3227},
	{18003, 165780, 9, 3227},
	{18021, 165784, 9, 3227},
	{18039, 165788, 9, 3227},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 1070},
	{18176, 165864},
	{18189, 165872, 6, 2488},
	{18223, 165880, 1, 1079},
	{18245, 165884, 1, 1080},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 5, 3236},
	{18314, 165900, 18, 3241},
	{18332, 165904, 20, 1124},
	{18348, 165908, 16, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 29, 3259},
	{18400, 165920, 16, 1198},
	{18418, 165924, 3, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18490, 165936, 6, 3784},
	{18541, 165944, 3, 2529},
	{18556, 165948, 5, 1240},
	{18586, 165952, 5, 1245},
	{18601, 165956},
	{43459, 165960, 6, 2532},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18724, 166424},
	{18747, 166428},
	{18973, 166472, 6, 2538},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 9, 2544},
	{19213, 166528},
	{19224, 166532, 3, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 3288},
	{19334, 166552, 4, 2553},
	{19425, 166572, 1, 1367},
	{19471, 166580, 1, 1368},
	{19500, 166588, 9, 1370},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20038, 166732, 2, 1394},
	{20057, 166736, 5, 1396},
	{20079, 166740, 17, 3291},
	{20100, 166744, 3, 1420},
	{20207, 166764, 12, 3790},
	{20220, 166768, 6, 1435},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 3, 1443},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 5, 1474},
	{20592, 166880, 8, 2587},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21307, 166976, 5, 3319},
	{21328, 166980, 12, 1528},
	{21348, 166984, 2, 1540},
	{21368, 166988, 20, 1542},
	{21406, 166992, 6, 3324},
	{47791, 166996, 14, 3802},
	{50930, 167000, 1, 3816},
	{21475, 167008},
	{21522, 167020, 3, 1569},
	{21537, 167024, 10, 3340},
	{21552, 167028, 5, 3350},
	{47811, 167032, 17, 3355},
	{21711, 167060},
	{21730, 167068},
	{21777, 167080, 3, 1569},
	{21792, 167084, 10, 3340},
	{21807, 167088, 5, 3350},
	{47834, 167092, 17, 3355},
	{21966, 167120},
	{21985, 167128},
	{22032, 167140, 3, 1569},
	{22047, 167144, 10, 3340},
	{22062, 167148, 5, 3350},
	{47857, 167152, 17, 3355},
	{22221, 167180},
	{22240, 167188},
	{22287, 167200, 3, 1569},
	{22302, 167204, 10, 3340},
	{22317, 167208, 5, 3350},
	{47880, 167212, 17, 3355},
	{22476, 167240},
	{22495, 167248},
	{22542, 167260, 3, 1569},
	{22557, 167264, 10, 3340},
	{22572, 167268, 5, 3350},
	{47903, 167272, 17, 3355},
	{22731, 167300},
	{22750, 167308},
	{22797, 167320, 3, 1569},
	{22812, 167324, 10, 3340},
	{22827, 167328, 5, 3350},
	{47926, 167332, 17, 3355},
	{22986, 167360},
	{23005, 167368},
	{23052, 167380, 3, 1569},
	{23067, 167384, 10, 3340},
	{23082, 167388, 5, 3350},
	{47949, 167392, 17, 3355},
	{23241, 167420},
	{23260, 167428},
	{23307, 167440, 3, 1569},
	{23322, 167444, 10, 3340},
	{23337, 167448, 5, 3350},
	{47972, 167452, 17, 3355},
	{23496, 167480},
	{23515, 167488, 1, 1612},
	{23534, 167492, 1, 1612},
	{23553, 167496, 1, 1612},
	{23572, 167500, 1, 1612},
	{23591, 167504, 1, 1612},
	{23610, 167508, 1, 1612},
	{23629, 167512, 1, 1612},
	{23648, 167516, 1, 1612},
	{24067, 167584, 1, 1612},
	{24090, 167588, 1, 1612},
	{24113, 167592, 1, 1612},
	{24136, 167596, 1, 1612},
	{24159, 167600, 1, 1612},
	{24182, 167604, 1, 1612},
	{24205, 167608, 1, 1612},
	{24228, 167612, 1, 1612},
	{24251, 167616, 3, 1613},
	{24269, 167620, 3, 1613},
	{24287, 167624, 3, 1613},
	{24305, 167628, 3, 1613},
	{24323, 167632, 3, 1613},
	{24341, 167636, 3, 1613},
	{24359, 167640, 3, 1613},
	{24377, 167644, 3, 1613},
	{24395, 167648, 5, 3372},
	{24413, 167652, 5, 3372},
	{24431, 167656, 5, 3372},
	{24449, 167660, 5, 3372},
	{24467, 167664, 5, 3372},
	{24485, 167668, 5, 3372},
	{24503, 167672, 5, 3372},
	{24521, 167676, 5, 3372},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{47995, 196808},
	{48019, 196812},
	{25841, 196852, 1, 1631},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{43474, 196896, 5, 2637},
	{26028, 196908, 1, 660},
	{26047, 196912},
	{26065, 196916},
	{26092, 196920},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 6, 3377},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 1, 1640},
	{26554, 197032, 7, 3383},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 1, 1643},
	{26626, 197048, 5, 3390},
	{26644, 197052},
	{26662, 197056, 2, 2642},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 2642},
	{26744, 197080, 5, 1648},
	{26764, 197084, 9, 3395},
	{26783, 197088, 9, 3395},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 7, 1679},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 7, 1679},
	{27102, 197160, 7, 1686},
	{27114, 197164, 2, 1693},
	{27148, 197172, 1, 1696},
	{27166, 197176, 6, 3404},
	{27186, 197180, 2, 330},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27232, 197192, 1, 1704},
	{27246, 197196, 1, 1705},
	{27260, 197200, 1, 1706},
	{27282, 197204, 1, 1707},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27392, 197232, 2, 1710},
	{27414, 197236, 2, 1712},
	{27436, 197240, 2, 1710},
	{27459, 197244, 2, 1712},
	{27482, 197248, 2, 1710},
	{27504, 197252, 2, 1712},
	{43493, 197256},
	{43515, 197260},
	{48043, 197264},
	{48065, 197268},
	{48087, 197272},
	{48110, 197276},
	{27587, 197376, 1, 1715},
	{27604, 197380, 1, 1716},
	{27621, 197384, 1, 1717},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 6, 3410},
	{27945, 197464, 6, 3416},
	{27967, 197468, 1, 1737},
	{27987, 197472, 1, 1738},
	{28001, 197476, 1, 1739},
	{28015, 197480, 1, 1740},
	{28027, 197484, 1, 1741},
	{28111, 197552, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28493, 197624, 13, 1752},
	{28510, 197628},
	{28527, 197632, 1, 1695},
	{28547, 197636},
	{28564, 197640, 1, 1660},
	{28584, 197644, 2, 1765},
	{28603, 197888, 8, 1767},
	{28624, 197892, 8, 1767},
	{28645, 198656, 6, 3817},
	{28698, 198920, 1, 3422},
	{28717, 198924, 2, 2654},
	{28864, 198948},
	{28880, 198952},
	{28895, 198956, 3, 3423},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 3426},
	{28972, 198972, 2, 2656},
	{28993, 198976},
	{29173, 199012},
	{29189, 199016},
	{29210, 199020, 8, 3427},
	{29218, 199024},
	{29232, 199028},
	{29246, 199032},
	{29260, 199036, 3, 1798},
	{29275, 199040, 2, 1801},
	{29287, 199044, 1, 827},
	{29309, 199048, 3, 1803},
	{43689, 199052, 2, 2658},
	{48133, 199056, 2, 3435},
	{48158, 199060, 1, 3437},
	{19132, 199064, 1, 3438},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{29983, 199952},
	{30010, 199956},
	{30037, 199960},
	{30064, 199964},
	{30091, 199968, 4, 2660},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 3439},
	{30586, 200756, 2, 3441},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 9, 3443},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 1858},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{48185, 200840},
	{48214, 200844},
	{48243, 200848},
	{48272, 200852},
	{48301, 200856},
	{48310, 200860},
	{48319, 200864},
	{48328, 200868},
	{48337, 200872},
	{48367, 200876},
	{48397, 200880},
	{48428, 200884},
	{48459, 200888},
	{48489, 200892},
	{48519, 200896},
	{48550, 200900},
	{48581, 200904},
	{48611, 200908},
	{48641, 200912},
	{48672, 200916},
	{48703, 200920},
	{48733, 200924},
	{48763, 200928},
	{48794, 200932},
	{2831, 200960, 7, 3452},
	{48825, 200964, 13, 3459},
	{48843, 200968, 7, 3472},
	{48861, 200972, 3, 3479},
	{48881, 200976, 8, 3482},
	{48903, 200980, 8, 3490},
	{48925, 200984},
	{48949, 200988, 6, 3498},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31252, 213040},
	{31275, 213044},
	{31298, 213048},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{43701, 213648},
	{43721, 213652},
	{43741, 213656},
	{43761, 213660},
	{43781, 213664},
	{43801, 213668},
	{43821, 213672},
	{43841, 213676},
	{43861, 213680},
	{43886, 213684},
	{43911, 213688},
	{43936, 213692},
	{43961, 213696},
	{43986, 213700},
	{44011, 213704},
	{44036, 213708},
	{44061, 213712},
	{44084, 213716},
	{44107, 213720},
	{44130, 213724},
	{44153, 213728},
	{44176, 213732},
	{44199, 213736},
	{44222, 213740},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{31153, 214576},
	{31133, 214580},
	{31113, 214584},
	{31093, 214588},
	{49117, 214592},
	{49136, 214596},
	{49155, 214600},
	{49174, 214604},
	{32825, 214784},
	{32863, 214792},
	{32901, 214800},
	{32939, 214808},
	{32977, 214816},
	{33015, 214824},
	{33053, 214832},
	{33091, 214840},
	{49193, 214928},
	{49213, 214932},
	{49233, 214936},
	{49253, 214940},
	{49273, 214944},
	{49293, 214948},
	{49313, 214952},
	{49333, 214956},
	{49353, 214960},
	{49373, 214964},
	{49393, 214968},
	{49413, 214972},
	{49433, 214976},
	{49453, 214980},
	{49473, 214984},
	{49493, 214988},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33597, 215424},
	{33618, 215428},
	{44245, 215432},
	{44265, 215436, 2, 1867},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{49513, 216352, 12, 3504},
	{49536, 216356, 1, 3516},
	{49560, 216360, 13, 3517},
	{34111, 216576},
	{34132, 216580},
	{34153, 216584},
	{34174, 216588},
	{34195, 216592},
	{34216, 216596},
	{34237, 216600},
	{34258, 216604},
	{34279, 216640},
	{34300, 216644},
	{34321, 216648},
	{34342, 216652},
	{34363, 216656},
	{34384, 216660},
	{34405, 216664},
	{34426, 216668},
	{34447, 216704},
	{34468, 216708},
	{34489, 216712},
	{34510, 216716},
	{34531, 216720},
	{34552, 216724},
	{34573, 216728},
	{34594, 216732},
	{34615, 216832},
	{34635, 216836},
	{34655, 216840},
	{34675, 216844},
	{34695, 216848},
	{34715, 216852},
	{34735, 216856},
	{34755, 216860},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{35327, 217856},
	{35347, 217860},
	{35367, 217864},
	{35387, 217868},
	{35407, 217872},
	{35427, 217876},
	{35447, 217880},
	{35467, 217884},
	{35589, 217984},
	{35614, 217988},
	{35639, 217992},
	{35664, 217996},
	{35537, 218000},
	{35563, 218004, 2, 1867},
	{44285, 218008},
	{44308, 218012, 2, 1867},
	{35689, 218064},
	{35715, 218068},
	{35487, 218080},
	{35512, 218084, 2, 1867},
	{50963, 218088},
	{50986, 218092, 2, 1867},
	{35829, 218240},
	{35849, 218244},
	{35869, 218248},
	{35889, 218252},
	{35909, 218624},
	{35931, 218628},
	{35953, 218632},
	{35975, 218636},
	{35997, 218640},
	{36019, 218644},
	{36041, 218648},
	{36063, 218652},
	{36085, 218656},
	{36107, 218660},
	{36129, 218664},
	{36151, 218668},
	{36173, 218672},
	{36195, 218676},
	{36217, 218680},
	{36239, 218684},
	{35741, 218752},
	{35763, 218756},
	{35785, 218760},
	{35807, 218764},
	{49586, 218768},
	{49608, 218772},
	{49630, 218776},
	{49652, 218780},
	{36261, 218880},
	{36282, 218884},
	{36303, 218888},
	{36324, 218892},
	{36345, 218896},
	{36366, 218900},
	{36387, 218904},
	{36408, 218908},
	{49674, 218944},
	{49695, 218948},
	{49716, 218952},
	{49737, 218956},
	{49758, 218960},
	{49779, 218964},
	{49800, 218968},
	{49821, 218972},
	{36429, 219136},
	{36449, 219140},
	{36469, 219144},
	{36489, 219148},
	{36509, 219152},
	{36529, 219156},
	{36549, 219160},
	{36569, 219164},
	{44369, 219520},
	{44398, 219524, 2, 1867},
	{44427, 219528},
	{44449, 219532},
	{44471, 219536},
	{44493, 219540},
	{36629, 221184, 3, 3530},
	{36653, 221188, 4, 1874},
	{36678, 221192, 5, 1869},
	{36702, 221196, 3, 3530},
	{36726, 221200, 4, 1874},
	{36751, 221204, 3, 3530},
	{36775, 221208, 4, 1874},
	{36800, 221212, 5, 1869},
	{36824, 221216, 4, 1878},
	{36840, 221220, 5, 1869},
	{36864, 221224, 3, 1882},
	{36898, 221228, 3, 1885},
	{36932, 221232, 3, 1888},
	{36957, 221236, 3, 1891},
	{36982, 221240, 3, 1888},
	{49842, 221244, 3, 1885},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 20, 1900},
	{37149, 221444, 20, 1900},
	{37174, 221448, 17, 3533},
	{37202, 221452, 17, 3533},
	{37286, 221492, 9, 3551},
	{37314, 221496, 9, 3551},
	{44953, 221840, 5, 3560},
	{44977, 221844, 4, 1959},
	{45002, 221848, 5, 3560},
	{45026, 221852, 4, 1959},
	{45051, 221856, 5, 3560},
	{45075, 221860, 4, 1959},
	{45100, 221864, 5, 3560},
	{45124, 221868, 4, 1959},
	{45149, 221872, 5, 3560},
	{45178, 221876, 4, 1959},
	{45208, 221880, 5, 3560},
	{45237, 221884, 4, 1959},
	{45267, 221888, 5, 3560},
	{45296, 221892, 4, 1959},
	{45326, 221896, 5, 3560},
	{45355, 221900, 4, 1959},
	{45385, 221904, 5, 3560},
	{45412, 221908, 4, 1959},
	{45440, 221912, 5, 3560},
	{45467, 221916, 4, 1959},
	{45495, 221920, 5, 3560},
	{45522, 221924, 4, 1959},
	{45550, 221928, 5, 3560},
	{45577, 221932, 4, 1959},
	{37716, 222208, 5, 1954},
	{37742, 222212, 4, 1959},
	{37769, 222216, 5, 1954},
	{37795, 222220, 4, 1959},
	{37822, 222224, 5, 1954},
	{37848, 222228, 4, 1959},
	{37875, 222232, 5, 1954},
	{37901, 222236, 4, 1959},
	{37928, 222464, 5, 1954},
	{37954, 222468, 4, 1959},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 5, 1954},
	{38187, 222724, 5, 1954},
	{38211, 222728, 5, 1954},
	{38235, 222732, 5, 1954},
	{38259, 222736, 4, 1959},
	{38284, 222740, 4, 1959},
	{38309, 222744, 4, 1959},
	{38334, 222748, 4, 1959},
	{38359, 222752, 1, 1869},
	{38383, 222756, 1, 1869},
	{38407, 222760, 8, 1963},
	{36841, 222768, 5, 1954},
	{36703, 222772, 5, 1954},
	{49960, 222776, 5, 1954},
	{49983, 222780, 5, 1954},
	{36727, 222784, 4, 1959},
	{50006, 222788, 4, 1959},
	{50030, 222792, 4, 1959},
	{50054, 222796, 4, 1959},
	{38428, 222976, 3, 2676},
	{38451, 222980, 3, 2676},
	{38474, 222984, 3, 2676},
	{38497, 222988, 3, 2676},
	{38520, 222992, 3, 2676},
	{38543, 222996, 3, 2676},
	{38566, 223000, 3, 2676},
	{38589, 223004, 3, 2676},
	{38612, 223008, 3, 2676},
	{38635, 223012, 3, 2676},
	{38658, 223016, 3, 2676},
	{38682, 223020, 3, 2676},
	{38706, 223024, 3, 2676},
	{38730, 223028, 3, 2676},
	{38754, 223032, 3, 2676},
	{38778, 223036, 3, 2676},
	{50078, 223040, 3, 2676},
	{50102, 223044, 3, 2676},
	{50126, 223048, 3, 2676},
	{50150, 223052, 3, 2676},
	{50174, 223056, 3, 2676},
	{50198, 223060, 3, 2676},
	{50222, 223064, 3, 2676},
	{50246, 223068, 3, 2676},
	{50270, 223072, 10, 3565},
	{50291, 223080, 2, 3575},
	{50313, 223084, 1, 3577},
	{38802, 223104, 10, 3565},
	{38822, 223112, 2, 3575},
	{2306, 223136},
	{2332, 223140, 2, 343},
	{2358, 223144},
	{2384, 223148, 2, 343},
	{2479, 223152, 18, 3578},
	{2431, 223156, 5, 3596},
	{2452, 223160, 7, 3601},
	{2410, 223164, 2, 345},
	{2500, 223184, 5, 3608},
	{43344, 223188, 6, 3613},
	{2552, 223192},
	{2582, 223196},
	{2614, 223200},
	{2645, 223204},
	{2523, 223208},
	{38843, 223232, 5, 1954},
	{38868, 223236, 4, 1959},
	{38894, 223240, 8, 1985},
	{45605, 223244, 5, 2137},
	{45627, 223248, 5, 2137},
	{45649, 223252, 4, 3823},
	{38917, 223488, 5, 1954},
	{38940, 223492, 5, 1954},
	{38963, 223496, 3, 2010},
	{38986, 223500, 3, 2010},
	{39009, 223504, 4, 1959},
	{39033, 223508, 4, 1959},
	{39057, 223744, 5, 1954},
	{39081, 223748, 5, 1954},
	{39105, 223752, 5, 1954},
	{39129, 223756, 5, 1954},
	{39153, 223760, 4, 1959},
	{45676, 223764, 4, 1959},
	{45701, 223768, 4, 1959},
	{45726, 223772, 4, 1959},
	{39178, 224000, 5, 1954},
	{39201, 224004, 4, 1959},
	{39225, 224008, 3, 2010},
	{39248, 224256, 5, 1954},
	{39271, 224260, 4, 1959},
	{39295, 224264, 3, 2010},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{39464, 224768, 5, 1954},
	{39489, 224772, 4, 1948},
	{39515, 224776, 5, 1954},
	{39540, 224780, 4, 1948},
	{39566, 224784, 3, 2010},
	{39591, 224788, 3, 2010},
	{39616, 224832, 5, 1954},
	{39641, 224836, 4, 1948},
	{39667, 224840, 5, 1954},
	{39692, 224844, 4, 1948},
	{39718, 224848, 3, 2010},
	{39743, 224852, 3, 2010},
	{39768, 224896, 5, 1954},
	{39793, 224900, 4, 1948},
	{39819, 224904, 3, 2010},
	{39844, 224908, 3, 2010},
	{39869, 224912, 3, 2010},
	{39894, 225024, 5, 1954},
	{39918, 225028, 4, 1948},
	{39943, 225032, 3, 2010},
	{39967, 225036, 3, 2010},
	{39991, 225040, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 1954},
	{40186, 225288, 4, 1959},
	{40210, 225292, 2, 3619},
	{40233, 225296, 2, 3619},
	{40256, 225300, 2, 3619},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 5, 3621},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40955, 225808, 2, 2067},
	{40553, 225812},
	{40572, 225816, 2, 2049},
	{40524, 225820, 3, 3626},
	{40644, 225824, 1, 3629},
	{40671, 225828, 2, 3630},
	{40598, 225832, 1, 3629},
	{40621, 225836, 2, 3630},
	{40974, 225864, 2, 2069},
	{41001, 225868},
	{45941, 225872, 2, 2069},
	{45972, 225876},
	{41028, 225880, 2, 2071},
	{41055, 225884, 2, 2073},
	{46003, 225888, 4, 2743},
	{41082, 225892, 18, 3632},
	{41103, 225896, 9, 2713},
	{41122, 225900, 12, 3650},
	{41141, 225904, 1, 2101},
	{41165, 225908, 1, 2103},
	{41197, 225912, 2, 2105},
	{46074, 225916, 3, 2747},
	{50336, 225928, 2, 3672},
	{50350, 225932, 10, 3674},
	{45811, 225936},
	{45784, 225940},
	{50365, 225972, 1, 3684},
	{50378, 225976},
	{50403, 225980, 1, 3685},
	{50428, 225984, 1, 3686},
	{50448, 225988},
	{50470, 225992, 2, 3687},
	{50490, 225996},
	{50518, 226000, 1, 3685},
	{50546, 226004, 1, 3686},
	{50569, 226008},
	{50594, 226012, 2, 3687},
	{50617, 226016, 1, 3689},
	{50634, 226020, 9, 3690},
	{50655, 226044},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{41589, 226304, 5, 1954},
	{41613, 226308, 4, 1959},
	{41638, 226312, 2, 3619},
	{41662, 226316, 5, 1954},
	{41686, 226320, 4, 1959},
	{41711, 226324, 2, 3619},
	{41735, 226328, 10, 2127},
	{42100, 226432, 5, 1954},
	{42129, 226436, 5, 1954},
	{42158, 226440, 4, 1959},
	{42188, 226444, 4, 1959},
	{42218, 226448, 8, 1985},
	{42245, 226452, 8, 1985},
	{41843, 226496, 5, 2137},
	{41871, 226500, 5, 2137},
	{41899, 226504, 5, 2137},
	{41927, 226508, 5, 2137},
	{41955, 226512, 5, 2137},
	{41983, 226516, 5, 2137},
	{42011, 226520, 5, 2137},
	{42039, 226524, 5, 2137},
	{42067, 226528, 4, 3823},
	{46115, 226532, 5, 2137},
	{46140, 226536, 5, 2137},
	{46165, 226540, 5, 2137},
	{46190, 226544, 5, 2137},
	{46215, 226548, 4, 3823},
	{42272, 226560, 5, 3560},
	{42302, 226564, 4, 1959},
	{42333, 226568, 8, 1985},
	{41757, 226576, 5, 2137},
	{41784, 226580, 5, 2137},
	{41811, 226584, 4, 3823},
	{51009, 226600, 5, 2137},
	{51034, 226604, 5, 2137},
	{51059, 226608, 5, 2137},
	{51084, 226612, 5, 2137},
	{51109, 226616, 4, 3823},
	{42361, 226688, 5, 1954},
	{42385, 226692, 4, 1959},
	{42410, 226696, 3, 2010},
	{42486, 226816, 5, 1954},
	{42512, 226820, 4, 1959},
	{42539, 226824, 5, 1954},
	{42565, 226828, 5, 1954},
	{42591, 226832, 5, 1954},
	{42617, 226836, 1, 1869},
	{42643, 226840, 1, 1869},
	{42669, 226844, 1, 1869},
	{42695, 226848, 1, 1869},
	{42721, 226880, 4, 1959},
	{42748, 226884, 4, 1959},
	{42775, 226888, 4, 1959},
	{42434, 226944, 2, 2151},
	{42460, 226948, 2, 2151},
	{50669, 226952, 2, 2151},
	{50695, 226956, 2, 2151},
	{42802, 227072, 5, 1954},
	{42827, 227076, 4, 1948},
	{42853, 227080, 3, 2010},
	{42878, 227084, 3, 2010},
	{42903, 227088, 3, 2010},
	{50721, 227136, 5, 1954},
	{50746, 227140, 4, 1948},
	{50772, 227144, 3, 2010},
	{50797, 227148, 3, 2010},
	{50822, 227152, 3, 2010},
	{42928, 227200, 5, 1954},
	{42952, 227204, 4, 1948},
	{42977, 227208, 3, 2010},
	{43001, 227212, 3, 2010},
	{43025, 227216, 3, 2010},
	{46313, 227456, 5, 2137},
	{46344, 227460, 5, 2137},
	{46375, 227464, 4, 3823},
	{46411, 227468, 1, 2750},
	{46435, 227472, 5, 1954},
	{46461, 227476, 4, 1959},
	{46488, 227480, 5, 1954},
	{46514, 227484, 4, 1959},
};

static const struct si_reg gfx6_reg_table[] = {
	{1310, 68, 9, 3827},
	{1323, 72, 24, 3836},
	{1338, 76, 3, 3860},
	{51139, 80, 11, 3863},
	{1375, 84, 4, 3874},
	{1393, 88, 2, 3878},
	{1411, 92, 4, 3880},
	{1426, 96},
	{1440, 100, 1, 3884},
	{1454, 104},
	{51153, 108},
	{51170, 112, 13, 3885},
	{51186, 2480},
	{51201, 2484, 1, 3898},
	{51216, 2488},
	{51231, 2492, 1, 3898},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51246, 3660, 21, 3899},
	{51259, 3664, 20, 3920},
	{51271, 3668, 16, 3940},
	{51284, 32768, 1, 3956},
	{51294, 32772, 2, 3957},
	{1954, 32776, 17, 3959},
	{51309, 32780, 2, 3976},
	{1967, 32784, 24, 3978},
	{1979, 32788, 11, 4002},
	{1995, 32792, 11, 4002},
	{51323, 32800, 6, 4013},
	{51339, 32804, 1, 4019},
	{51355, 32808},
	{28645, 32812, 6, 4020},
	{51371, 32816, 2, 4026},
	{51391, 32820, 1, 4028},
	{51413, 32848, 6, 4029},
	{51424, 32852, 22, 4035},
	{51444, 32856, 4, 4057},
	{51460, 32864, 2, 4061},
	{37124, 32880, 19, 4063},
	{37149, 32884, 19, 4063},
	{31321, 32888},
	{31342, 32892},
	{31363, 32896},
	{31384, 32900},
	{37174, 32920, 12, 4082},
	{37202, 32924, 12, 4082},
	{31405, 32936},
	{31429, 32940},
	{31453, 32944},
	{31477, 32948},
	{51474, 33008, 1, 4094},
	{47282, 33012},
	{51486, 33020},
	{51499, 33024},
	{51517, 33028},
	{51535, 33032},
	{51553, 33036},
	{51571, 33040},
	{51589, 33044},
	{51607, 33048},
	{51625, 33052},
	{51643, 33536, 10, 4095},
	{24539, 33792, 2, 4105},
	{24559, 33796, 1, 1625},
	{24579, 33800},
	{24599, 33804},
	{24619, 33808},
	{24640, 33812},
	{24661, 33816, 2, 4107},
	{24683, 33820},
	{24705, 33824},
	{24735, 33828},
	{24765, 33832},
	{24794, 33836},
	{24823, 33840},
	{24853, 33844},
	{24883, 33848},
	{24912, 33852},
	{24941, 33856},
	{24971, 33860},
	{25001, 33864},
	{25030, 33868},
	{25059, 33872},
	{25089, 33876},
	{25119, 33880},
	{25148, 33884},
	{25177, 33888, 2, 4109},
	{25199, 33892},
	{25221, 33896},
	{25244, 33900},
	{25267, 33904},
	{25290, 33908},
	{25313, 33912},
	{25336, 33916},
	{25359, 33920},
	{25383, 33924},
	{25407, 33928},
	{25431, 33932},
	{25455, 33936},
	{25479, 33940},
	{25503, 33944},
	{25527, 33948},
	{25551, 33952},
	{25573, 33956},
	{25595, 33960},
	{25616, 33964},
	{25637, 33968},
	{25661, 33972},
	{25685, 33976},
	{25709, 33980},
	{25733, 33984},
	{25757, 33988},
	{25885, 34044, 1, 1632},
	{25901, 34048},
	{25914, 34052},
	{25927, 34056},
	{25940, 34060},
	{25953, 34064},
	{25966, 34068},
	{25979, 34072},
	{25992, 34076},
	{26119, 34112, 2, 1633},
	{26132, 34116},
	{26303, 34144, 1, 1635},
	{26321, 34148, 3, 4111},
	{26339, 34152},
	{26354, 34156},
	{26378, 34160},
	{26402, 34164},
	{26421, 34168},
	{26440, 34172},
	{26464, 34176},
	{26488, 34180},
	{26512, 34184},
	{26536, 34212, 2, 4114},
	{26554, 34216, 1, 4116},
	{26572, 34220},
	{26590, 34224},
	{26608, 34228, 2, 4117},
	{26626, 34232, 1, 4119},
	{26644, 34236},
	{26662, 34240, 2, 1646},
	{26681, 34244, 5, 4120},
	{26700, 34256},
	{26724, 34260, 2, 1646},
	{26744, 34264, 5, 4120},
	{26818, 34284, 1, 1661},
	{26839, 34288, 23, 4125},
	{26853, 34292},
	{26867, 34296},
	{26881, 34300, 4, 4148},
	{26897, 34304},
	{26916, 34308, 1, 4152},
	{26938, 34312},
	{26957, 34316, 1, 4153},
	{26979, 34320, 9, 4154},
	{26997, 34324},
	{27017, 34328, 1, 4152},
	{27040, 34332},
	{27060, 34336, 1, 4153},
	{27083, 34340, 9, 4154},
	{27102, 34344, 5, 4163},
	{27114, 34348, 2, 1693},
	{27148, 34356, 1, 4168},
	{27166, 34360, 5, 2644},
	{27186, 34364, 1, 1701},
	{27203, 34368},
	{27219, 34372, 1, 1703},
	{27232, 34376, 1, 1704},
	{27246, 34380, 1, 1705},
	{27260, 34384, 1, 1706},
	{27282, 34388, 1, 1707},
	{27302, 34392, 1, 1708},
	{27324, 34396, 1, 1709},
	{51666, 34416, 15, 4169},
	{51683, 34420, 18, 4184},
	{51700, 34424, 31, 4202},
	{51717, 34428, 16, 4233},
	{51730, 34432, 24, 4249},
	{51738, 34436},
	{51756, 34440},
	{51775, 34444, 3, 4273},
	{51794, 34448},
	{51812, 34460, 1, 4276},
	{51833, 34512, 2, 4277},
	{51845, 34516, 1, 4279},
	{51857, 34520, 9, 4280},
	{51868, 34528, 4, 4289},
	{51881, 34532, 1, 4293},
	{51898, 34552, 1, 4294},
	{51910, 34556, 1, 4294},
	{51922, 34560, 1, 4294},
	{51934, 34564, 2, 4295},
	{51951, 34568, 2, 4297},
	{27637, 34572, 1, 1718},
	{27656, 34576, 1, 4299},
	{27675, 34580, 1, 1720},
	{27692, 34584, 1, 1721},
	{27710, 34588, 1, 4300},
	{27728, 34592, 1, 1723},
	{27744, 34596, 1, 1724},
	{27762, 34600, 1, 4301},
	{27780, 34604, 1, 1726},
	{27796, 34608, 1, 1721},
	{27811, 34612, 1, 4300},
	{27826, 34616, 1, 1723},
	{27839, 34620, 1, 1724},
	{27854, 34624, 1, 4301},
	{27869, 34628, 1, 1726},
	{27882, 34632, 1, 1727},
	{27896, 34636, 1, 4302},
	{27910, 34640, 1, 1729},
	{51972, 34644, 4, 4303},
	{51991, 34648, 4, 4307},
	{52010, 34652, 3, 4311},
	{52028, 34656, 2, 4314},
	{52048, 34660, 2, 4316},
	{52066, 34664, 2, 4318},
	{52079, 34668, 1, 4320},
	{52092, 34672, 1, 4321},
	{52106, 34676, 1, 4322},
	{52119, 34680, 3, 4323},
	{52132, 34684},
	{52144, 34688, 2, 4326},
	{52159, 34692, 2, 4328},
	{52175, 34696, 2, 4330},
	{52191, 34700, 1, 4332},
	{52203, 34708, 2, 4333},
	{52215, 34712, 2, 4335},
	{52229, 34716, 1, 4337},
	{52243, 34720, 2, 4338},
	{52261, 34724, 2, 4340},
	{52280, 34728, 2, 4342},
	{52299, 34780, 12, 4344},
	{36824, 34812, 4, 1878},
	{52317, 34944, 5, 4356},
	{52340, 34948, 2, 4361},
	{52363, 34952, 2, 4361},
	{52386, 34956, 2, 4361},
	{52409, 34960},
	{52428, 34964},
	{52447, 34968},
	{52466, 34972},
	{52485, 34976},
	{52504, 34980},
	{52523, 34984},
	{52542, 34988},
	{52561, 34992, 1, 4363},
	{52584, 34996, 1, 4364},
	{52608, 35000, 1, 4365},
	{52631, 35004, 1, 4366},
	{52656, 35008, 2, 4367},
	{52676, 35012, 8, 4369},
	{28660, 35016},
	{28679, 35020},
	{52699, 35024, 4, 4377},
	{52715, 35028, 1, 4381},
	{52735, 35032, 1, 4382},
	{52751, 35036, 5, 4383},
	{52766, 35040, 2, 4388},
	{52781, 35044},
	{52796, 35048, 2, 4390},
	{52810, 35052},
	{52824, 35056, 10, 4392},
	{52840, 35100, 1, 4402},
	{52866, 35104, 5, 4356},
	{52890, 35108, 5, 4356},
	{52914, 35112, 2, 4361},
	{52938, 35116, 2, 4361},
	{52962, 35120},
	{52982, 35124},
	{53002, 35128},
	{53022, 35132},
	{53042, 35136},
	{53062, 35140},
	{53082, 35144},
	{53102, 35148},
	{28698, 35160, 1, 4403},
	{28717, 35164, 1, 4404},
	{28732, 35168},
	{28765, 35172},
	{28798, 35176},
	{28831, 35180},
	{28921, 35184},
	{28937, 35188},
	{53122, 35196, 10, 4405},
	{53140, 35200, 2, 4415},
	{53157, 35204, 10, 4417},
	{28955, 35208, 1, 1782},
	{53174, 35212, 3, 4427},
	{28972, 35248, 2, 4430},
	{28993, 35256},
	{53189, 35260, 4, 4432},
	{53215, 35264, 4, 4432},
	{53243, 35328, 1, 4436},
	{53260, 35332},
	{53277, 35344, 1, 4437},
	{53295, 35348, 9, 4438},
	{53309, 35352, 10, 4447},
	{37716, 35360, 3, 4356},
	{37769, 35364, 3, 4356},
	{37822, 35368, 2, 2007},
	{37875, 35372, 2, 2007},
	{32057, 35376},
	{32079, 35380, 1, 1866},
	{32101, 35384},
	{32123, 35388, 1, 1866},
	{32145, 35392},
	{32167, 35396, 1, 1866},
	{32189, 35400},
	{32211, 35404, 1, 1866},
	{53326, 35408, 1, 4457},
	{53344, 35412, 1, 4458},
	{29325, 35424, 1, 1806},
	{37928, 35456, 3, 4459},
	{37981, 35460, 1, 1971},
	{38007, 35464, 1, 1971},
	{38033, 35468, 1, 1971},
	{38059, 35472, 1, 1971},
	{38085, 35476, 1, 1971},
	{38111, 35480, 1, 1971},
	{38137, 35484, 1, 1971},
	{32233, 35488},
	{32255, 35492},
	{32277, 35496},
	{32299, 35500},
	{32321, 35504},
	{32343, 35508},
	{32365, 35512},
	{32387, 35516},
	{32409, 35520},
	{32431, 35524},
	{32453, 35528},
	{32475, 35532},
	{32497, 35536},
	{32519, 35540},
	{32541, 35544},
	{32563, 35548},
	{29350, 35600, 2, 1807},
	{53366, 35620, 2, 4462},
	{53391, 35624, 10, 4464},
	{53408, 35788, 4, 4474},
	{53424, 35796, 4, 4478},
	{53443, 35800, 1, 4482},
	{53460, 35804},
	{53477, 35824, 26, 4483},
	{53491, 35840, 9, 4509},
	{53501, 35844, 9, 4518},
	{30091, 35848, 3, 4527},
	{53512, 35852, 3, 4530},
	{53531, 35856, 6, 4533},
	{53546, 35860, 4, 4539},
	{38802, 35864, 9, 4543},
	{53560, 35868, 4, 4552},
	{53580, 35872, 4, 4552},
	{53602, 35876, 4, 4556},
	{32825, 35968},
	{32844, 35972},
	{32863, 35976},
	{32882, 35980},
	{32901, 35984},
	{32920, 35988},
	{32939, 35992},
	{32958, 35996},
	{32977, 36000},
	{32996, 36004},
	{33015, 36008},
	{33034, 36012},
	{33053, 36016},
	{33072, 36020},
	{33091, 36024},
	{33110, 36028},
	{33129, 36032},
	{33148, 36036},
	{33167, 36040},
	{33186, 36044},
	{33205, 36048},
	{33225, 36052},
	{33245, 36056},
	{33265, 36060},
	{33285, 36064},
	{33305, 36068},
	{33325, 36072},
	{33345, 36076},
	{33365, 36080},
	{33385, 36084},
	{33405, 36088},
	{33425, 36092},
	{38428, 36096, 6, 4560},
	{38451, 36100, 6, 4560},
	{38474, 36104, 6, 4560},
	{38497, 36108, 6, 4560},
	{38520, 36112, 6, 4560},
	{38543, 36116, 6, 4560},
	{38566, 36120, 6, 4560},
	{38589, 36124, 6, 4560},
	{38612, 36128, 6, 4560},
	{38635, 36132, 6, 4560},
	{38658, 36136, 6, 4560},
	{38682, 36140, 6, 4560},
	{38706, 36144, 6, 4560},
	{38730, 36148, 6, 4560},
	{38754, 36152, 6, 4560},
	{38778, 36156, 6, 4560},
	{53622, 36224, 2, 4566},
	{53638, 36228, 2, 4566},
	{53654, 36232, 4, 4568},
	{53671, 36236, 4, 4568},
	{53689, 36320, 8, 4572},
	{53702, 36324},
	{53714, 36336},
	{53725, 36340},
	{53736, 36352},
	{53757, 36356, 1, 4580},
	{2431, 36360, 8, 4581},
	{2452, 36364, 3, 4589},
	{53778, 36368, 2, 4592},
	{29875, 36384},
	{29902, 36388},
	{29929, 36392},
	{29956, 36396},
	{2410, 36400, 2, 4594},
	{2500, 36404, 5, 4596},
	{53804, 36408, 15, 4601},
	{2479, 36412, 1, 4616},
	{53825, 36416},
	{53846, 36424, 1, 4617},
	{53870, 36440, 3, 4618},
	{53888, 36444, 4, 4621},
	{53907, 36448, 3, 4625},
	{53922, 36452},
	{53944, 36456},
	{53966, 36460},
	{53988, 36464},
	{54010, 36480, 4, 4628},
	{54025, 36484, 3, 4632},
	{54036, 36488, 3, 4635},
	{54047, 36492, 4, 4638},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 4642},
	{3642, 36624},
	{3660, 36628, 5, 4656},
	{3678, 36632, 4, 4661},
	{3696, 36636, 11, 4665},
	{3714, 36640, 2, 4676},
	{3732, 36644, 2, 4678},
	{3750, 36648, 4, 4680},
	{3768, 36652},
	{2759, 36656, 13, 4684},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 4697},
	{2813, 36668, 3, 4706},
	{2831, 37120, 6, 426},
	{30116, 38156},
	{2847, 39160, 9, 4709},
	{2862, 39184, 6, 4718},
	{2876, 39188, 5, 4719},
	{2890, 39192, 5, 4719},
	{2904, 39196, 5, 4719},
	{2918, 39200, 5, 4719},
	{2932, 39204, 5, 4719},
	{2946, 39208, 5, 4719},
	{2960, 39212, 5, 4719},
	{2974, 39216, 5, 4719},
	{2988, 39220, 5, 4719},
	{3002, 39224, 5, 4719},
	{3017, 39228, 5, 4719},
	{3032, 39232, 5, 4719},
	{3047, 39236, 5, 4719},
	{3062, 39240, 5, 4719},
	{3077, 39244, 5, 4719},
	{3092, 39248, 5, 4719},
	{3107, 39252, 5, 4719},
	{3122, 39256, 5, 4719},
	{3137, 39260, 5, 4719},
	{3152, 39264, 5, 4719},
	{3167, 39268, 5, 4719},
	{3182, 39272, 5, 4719},
	{3197, 39276, 5, 4719},
	{3212, 39280, 5, 4719},
	{3227, 39284, 5, 4719},
	{3242, 39288, 5, 4719},
	{3257, 39292, 5, 4719},
	{3272, 39296, 5, 4719},
	{3287, 39300, 5, 4719},
	{3302, 39304, 5, 4719},
	{3317, 39308, 5, 4719},
	{54059, 45056},
	{54080, 45060, 1, 488},
	{54101, 45064},
	{54122, 45068, 1, 488},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 4724},
	{3925, 45100, 6, 4735},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{54143, 45312},
	{54164, 45316, 1, 488},
	{54185, 45320},
	{54206, 45324, 1, 488},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 4741},
	{5131, 45356, 10, 4753},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{54227, 45568},
	{54248, 45572, 1, 488},
	{54269, 45576},
	{54290, 45580, 1, 488},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 11, 4763},
	{6505, 45612, 4, 4774},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{54311, 45824},
	{54332, 45828, 1, 488},
	{54353, 45832},
	{54374, 45836, 1, 488},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{7652, 45864, 12, 4741},
	{7676, 45868, 6, 4778},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{54395, 46080},
	{54416, 46084, 1, 488},
	{54437, 46088},
	{54458, 46092, 1, 488},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 10, 4784},
	{8400, 46124, 6, 4794},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{54479, 46336},
	{54500, 46340, 1, 488},
	{54521, 46344},
	{54542, 46348, 1, 488},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{9547, 46376, 11, 4800},
	{9571, 46380, 5, 4811},
	{9595, 46384},
	{9621, 46388},
	{9647, 46392},
	{9673, 46396},
	{9699, 46400},
	{9725, 46404},
	{9751, 46408},
	{9777, 46412},
	{9803, 46416},
	{9829, 46420},
	{9855, 46424},
	{9882, 46428},
	{9909, 46432},
	{9936, 46436},
	{9963, 46440},
	{9990, 46444},
	{10017, 47104, 12, 4816},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{54563, 47148, 1, 4828},
	{10250, 47152},
	{10265, 47156, 2, 4829},
	{54583, 47160},
	{54598, 47164, 1, 660},
	{54613, 47168},
	{54628, 47172, 1, 660},
	{10404, 47176, 10, 4831},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 7, 4841},
	{54643, 47192, 2, 4848},
	{54674, 47196, 2, 4848},
	{10531, 47200, 2, 691},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{54705, 53300, 29, 4850},
	{54722, 55348, 29, 4850},
	{11393, 163840, 9, 716},
	{11411, 163844, 9, 4879},
	{11428, 163848, 4, 4888},
	{11442, 163852, 23, 744},
	{11461, 163856, 15, 767},
	{11481, 163860},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{54739, 163900, 7, 4892},
	{11671, 163904, 8, 4899},
	{11681, 163908, 5, 4907},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{54753, 163928, 2, 4912},
	{54767, 163932, 1, 4914},
	{11939, 163968},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{14033, 164704, 1, 899},
	{54782, 164708, 1, 4915},
	{14064, 164712, 1, 901},
	{14132, 164864},
	{14149, 164868},
	{14166, 164872},
	{14182, 164876},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16837, 165444, 6, 946},
	{16857, 165448, 6, 946},
	{16877, 165452, 6, 946},
	{16897, 165456, 6, 946},
	{16917, 165460, 6, 946},
	{16937, 165464, 6, 946},
	{16957, 165468, 6, 946},
	{16977, 165472, 6, 946},
	{16997, 165476, 6, 946},
	{17017, 165480, 6, 946},
	{17037, 165484, 6, 946},
	{17058, 165488, 6, 946},
	{17079, 165492, 6, 946},
	{17100, 165496, 6, 946},
	{17121, 165500, 6, 946},
	{17142, 165504, 6, 946},
	{17163, 165508, 6, 946},
	{17184, 165512, 6, 946},
	{17205, 165516, 6, 946},
	{17226, 165520, 6, 946},
	{17247, 165524, 4, 958},
	{17268, 165528, 4, 958},
	{17289, 165532, 4, 958},
	{17310, 165536, 4, 958},
	{17331, 165540, 4, 958},
	{17352, 165544, 4, 958},
	{17373, 165548, 4, 958},
	{17394, 165552, 4, 958},
	{17415, 165556, 4, 958},
	{17436, 165560, 4, 958},
	{17457, 165564, 4, 958},
	{17478, 165568, 4, 958},
	{17499, 165572, 2, 967},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 3, 4916},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17645, 165644, 4, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 4919},
	{18176, 165864},
	{18189, 165872, 5, 1071},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 3, 4920},
	{18314, 165900, 12, 1107},
	{18332, 165904, 19, 1124},
	{18348, 165908, 13, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 26, 1170},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 4923},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 1282},
	{18973, 166472, 4, 1300},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 4927},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 7, 4932},
	{19224, 166532, 2, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 4939},
	{19307, 166548, 1, 1354},
	{19356, 166560},
	{19381, 166564},
	{19406, 166568, 6, 1361},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 7, 4942},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20079, 166740, 6, 1401},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 8, 4949},
	{20220, 166768, 6, 1435},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 2, 1443},
	{20455, 166804, 7, 4957},
	{20474, 166808, 4, 1454},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 4, 1474},
	{20592, 166880, 5, 1479},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{21490, 167012, 2, 1566},
	{21506, 167016, 1, 1568},
	{21522, 167020, 2, 4888},
	{21537, 167024, 15, 4964},
	{21552, 167028, 6, 1591},
	{21591, 167036},
	{21607, 167040, 1, 1611},
	{21629, 167044},
	{21645, 167048, 1, 1568},
	{21667, 167052},
	{21689, 167056},
	{21730, 167068},
	{21745, 167072, 2, 1566},
	{21761, 167076, 1, 1568},
	{21777, 167080, 2, 4888},
	{21792, 167084, 15, 4964},
	{21807, 167088, 6, 1591},
	{21846, 167096},
	{21862, 167100, 1, 1611},
	{21884, 167104},
	{21900, 167108, 1, 1568},
	{21922, 167112},
	{21944, 167116},
	{21985, 167128},
	{22000, 167132, 2, 1566},
	{22016, 167136, 1, 1568},
	{22032, 167140, 2, 4888},
	{22047, 167144, 15, 4964},
	{22062, 167148, 6, 1591},
	{22101, 167156},
	{22117, 167160, 1, 1611},
	{22139, 167164},
	{22155, 167168, 1, 1568},
	{22177, 167172},
	{22199, 167176},
	{22240, 167188},
	{22255, 167192, 2, 1566},
	{22271, 167196, 1, 1568},
	{22287, 167200, 2, 4888},
	{22302, 167204, 15, 4964},
	{22317, 167208, 6, 1591},
	{22356, 167216},
	{22372, 167220, 1, 1611},
	{22394, 167224},
	{22410, 167228, 1, 1568},
	{22432, 167232},
	{22454, 167236},
	{22495, 167248},
	{22510, 167252, 2, 1566},
	{22526, 167256, 1, 1568},
	{22542, 167260, 2, 4888},
	{22557, 167264, 15, 4964},
	{22572, 167268, 6, 1591},
	{22611, 167276},
	{22627, 167280, 1, 1611},
	{22649, 167284},
	{22665, 167288, 1, 1568},
	{22687, 167292},
	{22709, 167296},
	{22750, 167308},
	{22765, 167312, 2, 1566},
	{22781, 167316, 1, 1568},
	{22797, 167320, 2, 4888},
	{22812, 167324, 15, 4964},
	{22827, 167328, 6, 1591},
	{22866, 167336},
	{22882, 167340, 1, 1611},
	{22904, 167344},
	{22920, 167348, 1, 1568},
	{22942, 167352},
	{22964, 167356},
	{23005, 167368},
	{23020, 167372, 2, 1566},
	{23036, 167376, 1, 1568},
	{23052, 167380, 2, 4888},
	{23067, 167384, 15, 4964},
	{23082, 167388, 6, 1591},
	{23121, 167396},
	{23137, 167400, 1, 1611},
	{23159, 167404},
	{23175, 167408, 1, 1568},
	{23197, 167412},
	{23219, 167416},
	{23260, 167428},
	{23275, 167432, 2, 1566},
	{23291, 167436, 1, 1568},
	{23307, 167440, 2, 4888},
	{23322, 167444, 15, 4964},
	{23337, 167448, 6, 1591},
	{23376, 167456},
	{23392, 167460, 1, 1611},
	{23414, 167464},
	{23430, 167468, 1, 1568},
	{23452, 167472},
	{23474, 167476},
	{206, 880, 4, 4979},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 4983},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 9, 4988},
	{43221, 1281, 4, 4997},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
};

static const struct si_reg gfx7_reg_table[] = {
	{1310, 68, 9, 5001},
	{1323, 72, 24, 3836},
	{1338, 76, 3, 5010},
	{51139, 80, 11, 5013},
	{1375, 84, 4, 3874},
	{1393, 88, 2, 3878},
	{1411, 92, 4, 5024},
	{1426, 96},
	{1440, 100, 1, 3884},
	{1454, 104},
	{51153, 108},
	{51170, 112, 13, 3885},
	{51186, 2480},
	{51201, 2484, 1, 3898},
	{51216, 2488},
	{51231, 2492, 1, 3898},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51246, 3660, 21, 3899},
	{51259, 3664, 20, 3920},
	{51271, 3668, 16, 3940},
	{1954, 32776, 17, 5028},
	{1967, 32784, 24, 3978},
	{1979, 32788, 11, 4002},
	{1995, 32792, 11, 4002},
	{2024, 32824, 11, 4002},
	{2040, 32828, 11, 4002},
	{2056, 33296, 16, 5045},
	{2070, 33300, 28, 204},
	{2087, 33304, 17, 5061},
	{2108, 33308, 18, 5078},
	{2122, 33312, 31, 5096},
	{2139, 33316, 7, 5127},
	{54792, 33320, 1, 4276},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 1701},
	{2222, 33348},
	{2283, 33436, 1, 342},
	{53736, 36352},
	{53757, 36356, 1, 4580},
	{2431, 36360, 9, 5134},
	{2452, 36364, 3, 4589},
	{53778, 36368, 2, 4592},
	{54807, 36372, 2, 5143},
	{54829, 36376, 1, 5145},
	{2410, 36400, 2, 4594},
	{2500, 36404, 5, 5146},
	{53804, 36408, 15, 4601},
	{2479, 36412, 1, 4616},
	{53825, 36416},
	{53846, 36424, 1, 4617},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 4642},
	{3642, 36624},
	{3660, 36628, 5, 4656},
	{3678, 36632, 4, 4661},
	{3696, 36636, 11, 4665},
	{3714, 36640, 2, 4676},
	{3732, 36644, 2, 4678},
	{3750, 36648, 4, 4680},
	{3768, 36652},
	{2759, 36656, 13, 4684},
	{2777, 36660, 4, 411},
	{2795, 36664, 9, 4697},
	{2813, 36668, 3, 4706},
	{2831, 37120, 6, 426},
	{2847, 39160, 9, 4709},
	{2862, 39184, 5, 4719},
	{2876, 39188, 5, 4719},
	{2890, 39192, 5, 4719},
	{2904, 39196, 5, 4719},
	{2918, 39200, 5, 4719},
	{2932, 39204, 5, 4719},
	{2946, 39208, 5, 4719},
	{2960, 39212, 5, 4719},
	{2974, 39216, 5, 4719},
	{2988, 39220, 5, 4719},
	{3002, 39224, 5, 4719},
	{3017, 39228, 5, 4719},
	{3032, 39232, 5, 4719},
	{3047, 39236, 5, 4719},
	{3062, 39240, 5, 4719},
	{3077, 39244, 5, 4719},
	{3092, 39248, 5, 4719},
	{3107, 39252, 5, 4719},
	{3122, 39256, 5, 4719},
	{3137, 39260, 5, 4719},
	{3152, 39264, 5, 4719},
	{3167, 39268, 5, 4719},
	{3182, 39272, 5, 4719},
	{3197, 39276, 5, 4719},
	{3212, 39280, 5, 4719},
	{3227, 39284, 5, 4719},
	{3242, 39288, 5, 4719},
	{3257, 39292, 5, 4719},
	{3272, 39296, 5, 4719},
	{3287, 39300, 5, 4719},
	{3302, 39304, 5, 4719},
	{3317, 39308, 5, 4719},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{54059, 45056},
	{54080, 45060, 1, 488},
	{54101, 45064},
	{54122, 45068, 1, 488},
	{3835, 45084, 3, 485},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 4724},
	{3925, 45100, 6, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{54143, 45312},
	{54164, 45316, 1, 488},
	{54185, 45320},
	{54206, 45324, 1, 488},
	{5016, 45336, 3, 485},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 4741},
	{5131, 45356, 10, 537},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{6200, 45552, 6, 560},
	{6227, 45556, 5, 566},
	{54227, 45568},
	{54248, 45572, 1, 488},
	{54269, 45576},
	{54290, 45580, 1, 488},
	{6415, 45596, 3, 485},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 11, 4763},
	{6505, 45612, 4, 551},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{7559, 45808, 6, 560},
	{54311, 45824},
	{54332, 45828, 1, 488},
	{54353, 45832},
	{54374, 45836, 1, 488},
	{7586, 45852, 3, 485},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{7652, 45864, 12, 4741},
	{7676, 45868, 6, 560},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{8122, 46068, 5, 566},
	{54395, 46080},
	{54416, 46084, 1, 488},
	{54437, 46088},
	{54458, 46092, 1, 488},
	{8310, 46108, 2, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 10, 4784},
	{8400, 46124, 6, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{9454, 46324, 5, 566},
	{54479, 46336},
	{54500, 46340, 1, 488},
	{54521, 46344},
	{54542, 46348, 1, 488},
	{9481, 46364, 3, 485},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{9547, 46376, 11, 4800},
	{9571, 46380, 5, 566},
	{9595, 46384},
	{9621, 46388},
	{9647, 46392},
	{9673, 46396},
	{9699, 46400},
	{9725, 46404},
	{9751, 46408},
	{9777, 46412},
	{9803, 46416},
	{9829, 46420},
	{9855, 46424},
	{9882, 46428},
	{9909, 46432},
	{9936, 46436},
	{9963, 46440},
	{9990, 46444},
	{10017, 47104, 12, 4816},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 2, 4829},
	{54583, 47160},
	{54598, 47164, 1, 660},
	{54613, 47168},
	{54628, 47172, 1, 660},
	{10404, 47176, 10, 4831},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{54643, 47192, 2, 4848},
	{54674, 47196, 2, 4848},
	{10531, 47200, 2, 691},
	{54857, 47204, 2, 4848},
	{54888, 47208, 2, 4848},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 4, 694},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{54705, 53300, 29, 4850},
	{54722, 55348, 29, 4850},
	{11393, 163840, 9, 716},
	{11411, 163844, 9, 4879},
	{11428, 163848, 4, 4888},
	{11442, 163852, 23, 744},
	{11461, 163856, 15, 767},
	{11481, 163860},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{54739, 163900, 7, 4892},
	{11671, 163904, 8, 4899},
	{11681, 163908, 5, 4907},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{54753, 163928, 2, 4912},
	{54767, 163932, 1, 4914},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14033, 164704, 1, 899},
	{54782, 164708, 1, 4915},
	{14064, 164712, 1, 901},
	{14132, 164864},
	{14149, 164868},
	{14166, 164872},
	{14182, 164876},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16837, 165444, 6, 946},
	{16857, 165448, 6, 946},
	{16877, 165452, 6, 946},
	{16897, 165456, 6, 946},
	{16917, 165460, 6, 946},
	{16937, 165464, 6, 946},
	{16957, 165468, 6, 946},
	{16977, 165472, 6, 946},
	{16997, 165476, 6, 946},
	{17017, 165480, 6, 946},
	{17037, 165484, 6, 946},
	{17058, 165488, 6, 946},
	{17079, 165492, 6, 946},
	{17100, 165496, 6, 946},
	{17121, 165500, 6, 946},
	{17142, 165504, 6, 946},
	{17163, 165508, 6, 946},
	{17184, 165512, 6, 946},
	{17205, 165516, 6, 946},
	{17226, 165520, 6, 946},
	{17247, 165524, 4, 958},
	{17268, 165528, 4, 958},
	{17289, 165532, 4, 958},
	{17310, 165536, 4, 958},
	{17331, 165540, 4, 958},
	{17352, 165544, 4, 958},
	{17373, 165548, 4, 958},
	{17394, 165552, 4, 958},
	{17415, 165556, 4, 958},
	{17436, 165560, 4, 958},
	{17457, 165564, 4, 958},
	{17478, 165568, 4, 958},
	{17499, 165572, 2, 967},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 3, 4916},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17645, 165644, 4, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 4919},
	{18176, 165864},
	{18189, 165872, 5, 1071},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 3, 4920},
	{18314, 165900, 12, 1107},
	{18332, 165904, 19, 1124},
	{18348, 165908, 13, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 26, 1170},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 4923},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 1282},
	{18954, 166468, 2, 1297},
	{18973, 166472, 4, 1300},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 4927},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 7, 4932},
	{19213, 166528},
	{19224, 166532, 2, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 4939},
	{19307, 166548, 1, 1354},
	{19356, 166560},
	{19381, 166564},
	{19406, 166568, 6, 1361},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 7, 4942},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20079, 166740, 6, 1401},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 8, 4949},
	{20220, 166768, 6, 1435},
	{20237, 166772},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 2, 1443},
	{20455, 166804, 7, 4957},
	{20474, 166808, 4, 1454},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 4, 1474},
	{20592, 166880, 5, 1479},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{21490, 167012, 2, 1566},
	{21506, 167016, 1, 1568},
	{21522, 167020, 2, 4888},
	{21537, 167024, 15, 4964},
	{21552, 167028, 6, 1591},
	{21591, 167036},
	{21607, 167040, 1, 1611},
	{21629, 167044},
	{21645, 167048, 1, 1568},
	{21667, 167052},
	{21689, 167056},
	{21730, 167068},
	{21745, 167072, 2, 1566},
	{21761, 167076, 1, 1568},
	{21777, 167080, 2, 4888},
	{21792, 167084, 15, 4964},
	{21807, 167088, 6, 1591},
	{21846, 167096},
	{21862, 167100, 1, 1611},
	{21884, 167104},
	{21900, 167108, 1, 1568},
	{21922, 167112},
	{21944, 167116},
	{21985, 167128},
	{22000, 167132, 2, 1566},
	{22016, 167136, 1, 1568},
	{22032, 167140, 2, 4888},
	{22047, 167144, 15, 4964},
	{22062, 167148, 6, 1591},
	{22101, 167156},
	{22117, 167160, 1, 1611},
	{22139, 167164},
	{22155, 167168, 1, 1568},
	{22177, 167172},
	{22199, 167176},
	{22240, 167188},
	{22255, 167192, 2, 1566},
	{22271, 167196, 1, 1568},
	{22287, 167200, 2, 4888},
	{22302, 167204, 15, 4964},
	{22317, 167208, 6, 1591},
	{22356, 167216},
	{22372, 167220, 1, 1611},
	{22394, 167224},
	{22410, 167228, 1, 1568},
	{22432, 167232},
	{22454, 167236},
	{22495, 167248},
	{22510, 167252, 2, 1566},
	{22526, 167256, 1, 1568},
	{22542, 167260, 2, 4888},
	{22557, 167264, 15, 4964},
	{22572, 167268, 6, 1591},
	{22611, 167276},
	{22627, 167280, 1, 1611},
	{22649, 167284},
	{22665, 167288, 1, 1568},
	{22687, 167292},
	{22709, 167296},
	{22750, 167308},
	{22765, 167312, 2, 1566},
	{22781, 167316, 1, 1568},
	{22797, 167320, 2, 4888},
	{22812, 167324, 15, 4964},
	{22827, 167328, 6, 1591},
	{22866, 167336},
	{22882, 167340, 1, 1611},
	{22904, 167344},
	{22920, 167348, 1, 1568},
	{22942, 167352},
	{22964, 167356},
	{23005, 167368},
	{23020, 167372, 2, 1566},
	{23036, 167376, 1, 1568},
	{23052, 167380, 2, 4888},
	{23067, 167384, 15, 4964},
	{23082, 167388, 6, 1591},
	{23121, 167396},
	{23137, 167400, 1, 1611},
	{23159, 167404},
	{23175, 167408, 1, 1568},
	{23197, 167412},
	{23219, 167416},
	{23260, 167428},
	{23275, 167432, 2, 1566},
	{23291, 167436, 1, 1568},
	{23307, 167440, 2, 4888},
	{23322, 167444, 15, 4964},
	{23337, 167448, 6, 1591},
	{23376, 167456},
	{23392, 167460, 1, 1611},
	{23414, 167464},
	{23430, 167468, 1, 1568},
	{23452, 167472},
	{23474, 167476},
	{24539, 196608, 2, 4105},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{24661, 196632, 2, 4107},
	{24683, 196636, 1, 1627},
	{24705, 196640},
	{24735, 196644},
	{24765, 196648},
	{24794, 196652},
	{24823, 196656},
	{24853, 196660},
	{24883, 196664},
	{24912, 196668},
	{24941, 196672},
	{24971, 196676},
	{25001, 196680},
	{25030, 196684},
	{25059, 196688},
	{25089, 196692},
	{25119, 196696},
	{25148, 196700},
	{25177, 196704, 2, 4109},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{25885, 196860, 1, 1632},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{26119, 196928, 2, 1633},
	{26132, 196932},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 3, 5151},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 2, 4114},
	{26554, 197032, 1, 1641},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 2, 4117},
	{26626, 197048, 1, 1644},
	{26644, 197052},
	{26662, 197056, 2, 1646},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 1646},
	{26744, 197080, 5, 1648},
	{26764, 197084, 8, 5154},
	{26783, 197088, 8, 5154},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 23, 4125},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 4, 4148},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 9, 4154},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 9, 4154},
	{27102, 197160, 5, 4163},
	{27114, 197164, 2, 1693},
	{27131, 197168, 1, 1695},
	{27148, 197172, 1, 1696},
	{27166, 197176, 5, 2644},
	{27186, 197180, 1, 1701},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27232, 197192, 1, 1704},
	{27246, 197196, 1, 1705},
	{27260, 197200, 1, 1706},
	{27282, 197204, 1, 1707},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27344, 197216, 1, 1704},
	{27361, 197220, 1, 1705},
	{27378, 197224},
	{27637, 197388, 1, 1718},
	{27656, 197392, 1, 1719},
	{27675, 197396, 1, 1720},
	{27692, 197400, 1, 1721},
	{27710, 197404, 1, 1722},
	{27728, 197408, 1, 1723},
	{27744, 197412, 1, 1724},
	{27762, 197416, 1, 1725},
	{27780, 197420, 1, 1726},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 4, 5162},
	{27945, 197464, 4, 5166},
	{28645, 198656, 6, 4020},
	{28660, 198912},
	{28679, 198916},
	{28698, 198920, 1, 4403},
	{28717, 198924, 1, 4404},
	{28732, 198928},
	{28765, 198932},
	{28798, 198936},
	{28831, 198940},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 1782},
	{28972, 198972, 2, 1783},
	{28993, 198976},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{30091, 199968, 3, 4527},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30345, 200696},
	{30364, 200700, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 5170},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 1832},
	{30586, 200756, 2, 1834},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 9, 5174},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 1858},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{54919, 213504},
	{54938, 213508},
	{54957, 213512},
	{54976, 213516},
	{54995, 213520},
	{55014, 213524},
	{55033, 213528},
	{55052, 213532},
	{52409, 213536},
	{52428, 213540},
	{52447, 213544},
	{52466, 213548},
	{52485, 213552},
	{52504, 213556},
	{52523, 213560},
	{52542, 213564},
	{52962, 213568},
	{52982, 213572},
	{53002, 213576},
	{53022, 213580},
	{53042, 213584},
	{53062, 213588},
	{53082, 213592},
	{53102, 213596},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{32825, 214784},
	{32844, 214788},
	{32863, 214792},
	{32882, 214796},
	{32901, 214800},
	{32920, 214804},
	{32939, 214808},
	{32958, 214812},
	{32977, 214816},
	{32996, 214820},
	{33015, 214824},
	{33034, 214828},
	{33053, 214832},
	{33072, 214836},
	{33091, 214840},
	{33110, 214844},
	{33129, 214848},
	{33148, 214852},
	{33167, 214856},
	{33186, 214860},
	{33205, 214864},
	{33225, 214868},
	{33245, 214872},
	{33265, 214876},
	{33285, 214880},
	{33305, 214884},
	{33325, 214888},
	{33345, 214892},
	{33365, 214896},
	{33385, 214900},
	{33405, 214904},
	{33425, 214908},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{55071, 216576},
	{55091, 216580},
	{55111, 216584},
	{55131, 216588},
	{55151, 216592},
	{55171, 216596},
	{55191, 216600},
	{55211, 216604},
	{55231, 216640},
	{55251, 216644},
	{55271, 216648},
	{55291, 216652},
	{55311, 216656},
	{55331, 216660},
	{55351, 216664},
	{55371, 216668},
	{55391, 216704},
	{55411, 216708},
	{55431, 216712},
	{55451, 216716},
	{55471, 216720},
	{55491, 216724},
	{55511, 216728},
	{55531, 216732},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{36629, 221184, 1, 1900},
	{36653, 221188, 2, 5183},
	{36678, 221192, 3, 5185},
	{36702, 221196, 1, 1900},
	{36726, 221200, 2, 5183},
	{36751, 221204, 1, 1900},
	{36775, 221208, 2, 5183},
	{36800, 221212, 3, 5185},
	{36824, 221216, 4, 1878},
	{36840, 221220, 3, 5185},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 19, 4063},
	{37149, 221444, 19, 4063},
	{37174, 221448, 12, 4082},
	{37202, 221452, 12, 4082},
	{37230, 221456, 12, 4082},
	{37258, 221460, 12, 4082},
	{55551, 221696, 2, 4361},
	{55574, 221700, 2, 4361},
	{55597, 221704, 2, 4361},
	{55620, 221708, 2, 4361},
	{52317, 221712, 5, 1954},
	{52340, 221716, 2, 4361},
	{52363, 221720, 2, 4361},
	{52386, 221724, 2, 4361},
	{55643, 221728, 4, 1959},
	{52866, 221744, 5, 1954},
	{52890, 221748, 5, 1954},
	{52914, 221752, 2, 4361},
	{52938, 221756, 2, 4361},
	{55667, 221760, 4, 1959},
	{55692, 221764, 4, 1959},
	{52840, 221776, 1, 4402},
	{37716, 222208, 3, 1954},
	{37742, 222212, 2, 1874},
	{37769, 222216, 3, 1954},
	{37795, 222220, 2, 1874},
	{37822, 222224, 2, 2010},
	{37875, 222228, 2, 2010},
	{37928, 222464, 3, 1954},
	{37954, 222468, 2, 1874},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 3, 1954},
	{38187, 222724, 3, 1954},
	{38211, 222728, 3, 1954},
	{38235, 222732, 3, 1954},
	{38259, 222736, 2, 1874},
	{38284, 222740, 2, 1874},
	{38309, 222744, 2, 1874},
	{38334, 222748, 2, 1874},
	{38359, 222752, 1, 1998},
	{38383, 222756, 1, 1998},
	{38407, 222760, 8, 1963},
	{38428, 222976, 6, 5188},
	{38451, 222980, 6, 5188},
	{38474, 222984, 6, 5188},
	{38497, 222988, 6, 5188},
	{38520, 222992, 6, 5188},
	{38543, 222996, 6, 5188},
	{38566, 223000, 6, 5188},
	{38589, 223004, 6, 5188},
	{38612, 223008, 6, 5188},
	{38635, 223012, 6, 5188},
	{38658, 223016, 6, 5188},
	{38682, 223020, 6, 5188},
	{38706, 223024, 6, 5188},
	{38730, 223028, 6, 5188},
	{38754, 223032, 6, 5188},
	{38778, 223036, 6, 5188},
	{38802, 223104, 9, 4543},
	{55717, 223108, 2, 4592},
	{38822, 223112, 1, 1984},
	{38917, 223488, 3, 1993},
	{38940, 223492, 3, 1993},
	{38963, 223496, 3, 1993},
	{38986, 223500, 3, 1993},
	{39009, 223504, 2, 1996},
	{39033, 223508, 2, 1996},
	{39057, 223744, 3, 1993},
	{39081, 223748, 3, 1993},
	{39105, 223752, 3, 1993},
	{39129, 223756, 3, 1993},
	{39153, 223760, 2, 1996},
	{39178, 224000, 5, 1998},
	{39201, 224004, 4, 2003},
	{39225, 224008, 5, 1998},
	{39248, 224256, 5, 1998},
	{39271, 224260, 4, 2003},
	{39295, 224264, 5, 1998},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{55737, 224768, 5, 1954},
	{55761, 224772, 4, 1948},
	{55786, 224776, 5, 1954},
	{55810, 224780, 4, 1948},
	{55835, 224784, 3, 2010},
	{55859, 224788, 3, 2010},
	{55883, 224832, 5, 1954},
	{55907, 224836, 4, 1948},
	{55932, 224840, 5, 1954},
	{55956, 224844, 4, 1948},
	{55981, 224848, 3, 2010},
	{56005, 224852, 3, 2010},
	{56029, 224896, 5, 1954},
	{56053, 224900, 4, 1948},
	{56078, 224904, 3, 2010},
	{56102, 224908, 3, 2010},
	{56126, 224912, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 2025},
	{40186, 225288, 4, 2030},
	{40210, 225292, 2, 2034},
	{40233, 225296, 2, 2034},
	{40256, 225300, 2, 2034},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 4, 2036},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40524, 225808, 7, 2042},
	{40598, 225812},
	{40621, 225816},
	{56150, 225820, 2, 5194},
	{56183, 225824, 2, 5194},
	{56216, 225828, 2, 5194},
	{56249, 225832, 2, 5194},
	{56281, 225836, 2, 5194},
	{56313, 225840, 2, 5194},
	{56345, 225844, 2, 5194},
	{56378, 225848, 2, 5194},
	{56410, 225856, 2, 5194},
	{56442, 225860, 2, 5194},
	{56475, 225864, 2, 5194},
	{56508, 225868, 2, 5194},
	{56541, 225872, 2, 5194},
	{56573, 225876, 2, 5194},
	{56605, 225880, 2, 5194},
	{56638, 225884, 2, 5194},
	{56671, 225888, 2, 5194},
	{56704, 225892, 2, 5194},
	{56737, 225896, 2, 5194},
	{40644, 225900},
	{40671, 225904},
	{40553, 225908},
	{40572, 225912},
	{56769, 225916, 2, 5194},
	{56803, 225920, 2, 5194},
	{56837, 225924, 2, 5194},
	{56871, 225928, 2, 5194},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 5196},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 9, 4988},
	{43221, 1281, 6, 5201},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
};

static const struct si_reg gfx8_reg_table[] = {
	{1310, 68, 10, 5207},
	{1323, 72, 23, 5217},
	{1338, 76, 4, 5240},
	{51139, 80, 11, 5013},
	{1375, 84, 4, 3874},
	{1393, 88, 2, 3878},
	{1411, 92, 6, 5244},
	{1426, 96},
	{1440, 100, 1, 3884},
	{1454, 104},
	{51153, 108},
	{51170, 112, 13, 5250},
	{1471, 116, 5, 5263},
	{51186, 2480},
	{51201, 2484, 1, 3898},
	{51216, 2488},
	{51231, 2492, 1, 3898},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51246, 3660, 21, 3899},
	{51259, 3664, 20, 3920},
	{51271, 3668, 16, 3940},
	{1954, 32776, 18, 5268},
	{1967, 32784, 24, 3978},
	{1979, 32788, 11, 4002},
	{1995, 32792, 11, 4002},
	{2024, 32824, 11, 4002},
	{2040, 32828, 11, 4002},
	{2056, 33296, 15, 5286},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 5301},
	{2108, 33308, 21, 5315},
	{2122, 33312, 31, 5096},
	{2139, 33316, 9, 5336},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 330},
	{2222, 33348},
	{2283, 33436, 1, 342},
	{53825, 36416},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 5345},
	{3642, 36624},
	{3660, 36628, 5, 5359},
	{3678, 36632, 4, 4661},
	{3696, 36636, 11, 4665},
	{3714, 36640, 2, 4676},
	{3732, 36644, 2, 4678},
	{3750, 36648, 8, 5364},
	{3768, 36652},
	{2759, 36656, 14, 5372},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5386},
	{2813, 36668, 3, 4706},
	{2831, 37120, 6, 426},
	{2847, 39160, 9, 4709},
	{2862, 39184, 5, 4719},
	{2876, 39188, 5, 4719},
	{2890, 39192, 5, 4719},
	{2904, 39196, 5, 4719},
	{2918, 39200, 5, 4719},
	{2932, 39204, 5, 4719},
	{2946, 39208, 5, 4719},
	{2960, 39212, 5, 4719},
	{2974, 39216, 5, 4719},
	{2988, 39220, 5, 4719},
	{3002, 39224, 5, 4719},
	{3017, 39228, 5, 4719},
	{3032, 39232, 5, 4719},
	{3047, 39236, 5, 4719},
	{3062, 39240, 5, 4719},
	{3077, 39244, 5, 4719},
	{3092, 39248, 5, 4719},
	{3107, 39252, 5, 4719},
	{3122, 39256, 5, 4719},
	{3137, 39260, 5, 4719},
	{3152, 39264, 5, 4719},
	{3167, 39268, 5, 4719},
	{3182, 39272, 5, 4719},
	{3197, 39276, 5, 4719},
	{3212, 39280, 5, 4719},
	{3227, 39284, 5, 4719},
	{3242, 39288, 5, 4719},
	{3257, 39292, 5, 4719},
	{3272, 39296, 5, 4719},
	{3287, 39300, 5, 4719},
	{3302, 39304, 5, 4719},
	{3317, 39308, 5, 4719},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{54059, 45056},
	{54080, 45060, 1, 488},
	{54101, 45064},
	{54122, 45068, 1, 488},
	{3835, 45084, 3, 485},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 4724},
	{3925, 45100, 6, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{54143, 45312},
	{54164, 45316, 1, 488},
	{54185, 45320},
	{54206, 45324, 1, 488},
	{5016, 45336, 3, 485},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 4741},
	{5131, 45356, 11, 5396},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{6200, 45552, 6, 560},
	{6227, 45556, 5, 566},
	{54227, 45568},
	{54248, 45572, 1, 488},
	{54269, 45576},
	{54290, 45580, 1, 488},
	{6415, 45596, 4, 573},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 11, 4763},
	{6505, 45612, 4, 551},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{7559, 45808, 6, 560},
	{54311, 45824},
	{54332, 45828, 1, 488},
	{54353, 45832},
	{54374, 45836, 1, 488},
	{7586, 45852, 4, 573},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{7652, 45864, 12, 4741},
	{7676, 45868, 6, 560},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{8122, 46068, 5, 566},
	{54395, 46080},
	{54416, 46084, 1, 488},
	{54437, 46088},
	{54458, 46092, 1, 488},
	{8310, 46108, 3, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 10, 4784},
	{8400, 46124, 6, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{9454, 46324, 5, 566},
	{54479, 46336},
	{54500, 46340, 1, 488},
	{54521, 46344},
	{54542, 46348, 1, 488},
	{9481, 46364, 4, 573},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{9547, 46376, 11, 4800},
	{9571, 46380, 5, 566},
	{9595, 46384},
	{9621, 46388},
	{9647, 46392},
	{9673, 46396},
	{9699, 46400},
	{9725, 46404},
	{9751, 46408},
	{9777, 46412},
	{9803, 46416},
	{9829, 46420},
	{9855, 46424},
	{9882, 46428},
	{9909, 46432},
	{9936, 46436},
	{9963, 46440},
	{9990, 46444},
	{10017, 47104, 12, 4816},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 2, 4829},
	{54583, 47160},
	{54598, 47164, 1, 660},
	{54613, 47168},
	{54628, 47172, 1, 660},
	{10404, 47176, 10, 4831},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{54643, 47192, 2, 4848},
	{54674, 47196, 2, 4848},
	{10531, 47200, 2, 691},
	{54857, 47204, 2, 4848},
	{54888, 47208, 2, 4848},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 5, 694},
	{10710, 47232},
	{10730, 47236},
	{10913, 47240, 3, 710},
	{10930, 47244},
	{10959, 47248, 1, 713},
	{56905, 47252, 2, 5407},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11377, 47612},
	{54705, 53300, 29, 4850},
	{54722, 55348, 29, 4850},
	{11393, 163840, 10, 716},
	{11411, 163844, 9, 4879},
	{11428, 163848, 4, 4888},
	{11442, 163852, 23, 744},
	{11461, 163856, 15, 767},
	{11481, 163860},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{54739, 163900, 7, 4892},
	{11671, 163904, 10, 5409},
	{11681, 163908, 6, 5419},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{54753, 163928, 2, 4912},
	{54767, 163932, 1, 4914},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14033, 164704, 1, 899},
	{54782, 164708, 1, 4915},
	{14064, 164712, 1, 901},
	{14132, 164864},
	{14149, 164868},
	{14166, 164872},
	{14182, 164876},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14293, 164900, 3, 5425},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16837, 165444, 12, 946},
	{16857, 165448, 12, 946},
	{16877, 165452, 12, 946},
	{16897, 165456, 12, 946},
	{16917, 165460, 12, 946},
	{16937, 165464, 12, 946},
	{16957, 165468, 12, 946},
	{16977, 165472, 12, 946},
	{16997, 165476, 12, 946},
	{17017, 165480, 12, 946},
	{17037, 165484, 12, 946},
	{17058, 165488, 12, 946},
	{17079, 165492, 12, 946},
	{17100, 165496, 12, 946},
	{17121, 165500, 12, 946},
	{17142, 165504, 12, 946},
	{17163, 165508, 12, 946},
	{17184, 165512, 12, 946},
	{17205, 165516, 12, 946},
	{17226, 165520, 12, 946},
	{17247, 165524, 9, 958},
	{17268, 165528, 9, 958},
	{17289, 165532, 9, 958},
	{17310, 165536, 9, 958},
	{17331, 165540, 9, 958},
	{17352, 165544, 9, 958},
	{17373, 165548, 9, 958},
	{17394, 165552, 9, 958},
	{17415, 165556, 9, 958},
	{17436, 165560, 9, 958},
	{17457, 165564, 9, 958},
	{17478, 165568, 9, 958},
	{17499, 165572, 2, 967},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 3, 4916},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17645, 165644, 4, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 4919},
	{18176, 165864},
	{18189, 165872, 5, 1071},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 3, 5428},
	{18314, 165900, 12, 1107},
	{18332, 165904, 19, 1124},
	{18348, 165908, 13, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 27, 5431},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 4923},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 5458},
	{18954, 166468, 2, 1297},
	{18973, 166472, 4, 1300},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 4927},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 7, 5473},
	{19213, 166528},
	{19224, 166532, 2, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 5480},
	{19307, 166548, 1, 1354},
	{19356, 166560},
	{19381, 166564},
	{19406, 166568, 7, 5483},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 8, 5490},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20057, 166736, 3, 1396},
	{20079, 166740, 10, 1401},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 10, 5498},
	{20220, 166768, 6, 1435},
	{20237, 166772},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 2, 1443},
	{20455, 166804, 7, 4957},
	{20474, 166808, 4, 1454},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 4, 1474},
	{20592, 166880, 5, 1479},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{21490, 167012, 2, 1566},
	{21506, 167016, 1, 1568},
	{21522, 167020, 2, 4888},
	{21537, 167024, 18, 5508},
	{21552, 167028, 6, 1591},
	{21569, 167032, 9, 1599},
	{21591, 167036},
	{21607, 167040, 1, 1611},
	{21629, 167044},
	{21645, 167048, 1, 1568},
	{21667, 167052},
	{21689, 167056},
	{21711, 167060},
	{21730, 167068},
	{21745, 167072, 2, 1566},
	{21761, 167076, 1, 1568},
	{21777, 167080, 2, 4888},
	{21792, 167084, 18, 5508},
	{21807, 167088, 6, 1591},
	{21824, 167092, 9, 1599},
	{21846, 167096},
	{21862, 167100, 1, 1611},
	{21884, 167104},
	{21900, 167108, 1, 1568},
	{21922, 167112},
	{21944, 167116},
	{21966, 167120},
	{21985, 167128},
	{22000, 167132, 2, 1566},
	{22016, 167136, 1, 1568},
	{22032, 167140, 2, 4888},
	{22047, 167144, 18, 5508},
	{22062, 167148, 6, 1591},
	{22079, 167152, 9, 1599},
	{22101, 167156},
	{22117, 167160, 1, 1611},
	{22139, 167164},
	{22155, 167168, 1, 1568},
	{22177, 167172},
	{22199, 167176},
	{22221, 167180},
	{22240, 167188},
	{22255, 167192, 2, 1566},
	{22271, 167196, 1, 1568},
	{22287, 167200, 2, 4888},
	{22302, 167204, 18, 5508},
	{22317, 167208, 6, 1591},
	{22334, 167212, 9, 1599},
	{22356, 167216},
	{22372, 167220, 1, 1611},
	{22394, 167224},
	{22410, 167228, 1, 1568},
	{22432, 167232},
	{22454, 167236},
	{22476, 167240},
	{22495, 167248},
	{22510, 167252, 2, 1566},
	{22526, 167256, 1, 1568},
	{22542, 167260, 2, 4888},
	{22557, 167264, 18, 5508},
	{22572, 167268, 6, 1591},
	{22589, 167272, 9, 1599},
	{22611, 167276},
	{22627, 167280, 1, 1611},
	{22649, 167284},
	{22665, 167288, 1, 1568},
	{22687, 167292},
	{22709, 167296},
	{22731, 167300},
	{22750, 167308},
	{22765, 167312, 2, 1566},
	{22781, 167316, 1, 1568},
	{22797, 167320, 2, 4888},
	{22812, 167324, 18, 5508},
	{22827, 167328, 6, 1591},
	{22844, 167332, 9, 1599},
	{22866, 167336},
	{22882, 167340, 1, 1611},
	{22904, 167344},
	{22920, 167348, 1, 1568},
	{22942, 167352},
	{22964, 167356},
	{22986, 167360},
	{23005, 167368},
	{23020, 167372, 2, 1566},
	{23036, 167376, 1, 1568},
	{23052, 167380, 2, 4888},
	{23067, 167384, 18, 5508},
	{23082, 167388, 6, 1591},
	{23099, 167392, 9, 1599},
	{23121, 167396},
	{23137, 167400, 1, 1611},
	{23159, 167404},
	{23175, 167408, 1, 1568},
	{23197, 167412},
	{23219, 167416},
	{23241, 167420},
	{23260, 167428},
	{23275, 167432, 2, 1566},
	{23291, 167436, 1, 1568},
	{23307, 167440, 2, 4888},
	{23322, 167444, 18, 5508},
	{23337, 167448, 6, 1591},
	{23354, 167452, 9, 1599},
	{23376, 167456},
	{23392, 167460, 1, 1611},
	{23414, 167464},
	{23430, 167468, 1, 1568},
	{23452, 167472},
	{23474, 167476},
	{23496, 167480},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{24661, 196632, 1, 1626},
	{24683, 196636, 1, 1627},
	{24705, 196640},
	{24735, 196644},
	{24765, 196648},
	{24794, 196652},
	{24823, 196656},
	{24853, 196660},
	{24883, 196664},
	{24912, 196668},
	{24941, 196672},
	{24971, 196676},
	{25001, 196680},
	{25030, 196684},
	{25059, 196688},
	{25089, 196692},
	{25119, 196696},
	{25148, 196700},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{25841, 196852, 2, 5526},
	{25863, 196856, 2, 5526},
	{25885, 196860, 1, 1632},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{26119, 196928, 2, 1633},
	{26132, 196932},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 5, 5528},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 2, 4114},
	{26554, 197032, 3, 5533},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 2, 4117},
	{26626, 197048, 3, 5536},
	{26644, 197052},
	{26662, 197056, 2, 1646},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 1646},
	{26744, 197080, 5, 1648},
	{26764, 197084, 8, 5539},
	{26783, 197088, 8, 5539},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 26, 5547},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 4, 4148},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 9, 4154},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 9, 4154},
	{27102, 197160, 5, 4163},
	{27114, 197164, 2, 1693},
	{27131, 197168, 1, 1695},
	{27148, 197172, 1, 1696},
	{27166, 197176, 4, 1697},
	{27186, 197180, 1, 1701},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27232, 197192, 1, 1704},
	{27246, 197196, 1, 1705},
	{27260, 197200, 1, 1706},
	{27282, 197204, 1, 1707},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27344, 197216, 1, 1704},
	{27361, 197220, 1, 1705},
	{27378, 197224},
	{56934, 197228, 1, 1703},
	{27637, 197388, 1, 1718},
	{27656, 197392, 1, 1719},
	{27675, 197396, 1, 1720},
	{27692, 197400, 1, 1721},
	{27710, 197404, 1, 1722},
	{27728, 197408, 1, 1723},
	{27744, 197412, 1, 1724},
	{27762, 197416, 1, 1725},
	{27780, 197420, 1, 1726},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 4, 5573},
	{27945, 197464, 4, 5166},
	{27967, 197468, 1, 1737},
	{28111, 197552, 1, 1742},
	{28136, 197556, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28235, 197576},
	{28260, 197580, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28645, 198656, 6, 4020},
	{28660, 198912},
	{28679, 198916},
	{28698, 198920, 1, 4403},
	{28717, 198924, 1, 1340},
	{28732, 198928},
	{28765, 198932},
	{28798, 198936},
	{28831, 198940},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 1782},
	{28972, 198972, 2, 1783},
	{28993, 198976},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{53736, 199872},
	{53757, 199876, 1, 4580},
	{2431, 199880, 8, 5134},
	{2452, 199884, 3, 4589},
	{53778, 199888, 2, 4592},
	{2479, 199892, 1, 4616},
	{53804, 199896, 15, 4601},
	{54807, 199900, 1, 5143},
	{54829, 199904},
	{2410, 199908, 2, 4594},
	{2500, 199912, 5, 5146},
	{53846, 199916, 1, 4617},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{30091, 199968, 6, 1816},
	{30102, 199972, 2, 1823},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30345, 200696},
	{30364, 200700, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 1832},
	{30586, 200756, 2, 1834},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 9, 5174},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 5577},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{54919, 213504},
	{54938, 213508},
	{54957, 213512},
	{54976, 213516},
	{54995, 213520},
	{55014, 213524},
	{55033, 213528},
	{55052, 213532},
	{52409, 213536},
	{52428, 213540},
	{52447, 213544},
	{52466, 213548},
	{52485, 213552},
	{52504, 213556},
	{52523, 213560},
	{52542, 213564},
	{52962, 213568},
	{52982, 213572},
	{53002, 213576},
	{53022, 213580},
	{53042, 213584},
	{53062, 213588},
	{53082, 213592},
	{53102, 213596},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{32825, 214784},
	{32844, 214788},
	{32863, 214792},
	{32882, 214796},
	{32901, 214800},
	{32920, 214804},
	{32939, 214808},
	{32958, 214812},
	{32977, 214816},
	{32996, 214820},
	{33015, 214824},
	{33034, 214828},
	{33053, 214832},
	{33072, 214836},
	{33091, 214840},
	{33110, 214844},
	{33129, 214848},
	{33148, 214852},
	{33167, 214856},
	{33186, 214860},
	{33205, 214864},
	{33225, 214868},
	{33245, 214872},
	{33265, 214876},
	{33285, 214880},
	{33305, 214884},
	{33325, 214888},
	{33345, 214892},
	{33365, 214896},
	{33385, 214900},
	{33405, 214904},
	{33425, 214908},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{55071, 216576},
	{55091, 216580},
	{55111, 216584},
	{55131, 216588},
	{55151, 216592},
	{55171, 216596},
	{55191, 216600},
	{55211, 216604},
	{55231, 216640},
	{55251, 216644},
	{55271, 216648},
	{55291, 216652},
	{55311, 216656},
	{55331, 216660},
	{55351, 216664},
	{55371, 216668},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{36629, 221184, 1, 1900},
	{36653, 221188, 2, 5183},
	{36678, 221192, 3, 5185},
	{36702, 221196, 1, 1900},
	{36726, 221200, 2, 5183},
	{36751, 221204, 1, 1900},
	{36775, 221208, 2, 5183},
	{36800, 221212, 3, 5185},
	{36824, 221216, 4, 1878},
	{36840, 221220, 3, 5185},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 19, 4063},
	{37149, 221444, 19, 4063},
	{37174, 221448, 12, 4082},
	{37202, 221452, 12, 4082},
	{37230, 221456, 12, 4082},
	{37258, 221460, 12, 4082},
	{55551, 221696, 2, 4361},
	{55574, 221700, 2, 4361},
	{55597, 221704, 2, 4361},
	{55620, 221708, 2, 4361},
	{52317, 221712, 5, 1954},
	{52340, 221716, 2, 4361},
	{52363, 221720, 2, 4361},
	{52386, 221724, 2, 4361},
	{55643, 221728, 4, 1959},
	{52866, 221744, 5, 1954},
	{52890, 221748, 5, 1954},
	{52914, 221752, 2, 4361},
	{52938, 221756, 2, 4361},
	{55667, 221760, 4, 1959},
	{55692, 221764, 4, 1959},
	{52840, 221776, 1, 4402},
	{37716, 222208, 3, 1954},
	{37742, 222212, 2, 1874},
	{37769, 222216, 3, 1954},
	{37795, 222220, 2, 1874},
	{37822, 222224, 2, 2010},
	{37875, 222228, 2, 2010},
	{37928, 222464, 3, 1954},
	{37954, 222468, 2, 1874},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 3, 1954},
	{38187, 222724, 3, 1954},
	{38211, 222728, 3, 1954},
	{38235, 222732, 3, 1954},
	{38259, 222736, 2, 1874},
	{38284, 222740, 2, 1874},
	{38309, 222744, 2, 1874},
	{38334, 222748, 2, 1874},
	{38359, 222752, 1, 1998},
	{38383, 222756, 1, 1998},
	{38407, 222760, 8, 1963},
	{38428, 222976, 6, 4560},
	{38451, 222980, 6, 4560},
	{38474, 222984, 6, 4560},
	{38497, 222988, 6, 4560},
	{38520, 222992, 6, 4560},
	{38543, 222996, 6, 4560},
	{38566, 223000, 6, 4560},
	{38589, 223004, 6, 4560},
	{38612, 223008, 6, 4560},
	{38635, 223012, 6, 4560},
	{38658, 223016, 6, 4560},
	{38682, 223020, 6, 4560},
	{38706, 223024, 6, 4560},
	{38730, 223028, 6, 4560},
	{38754, 223032, 6, 4560},
	{38778, 223036, 6, 4560},
	{38802, 223104, 9, 4543},
	{55717, 223108, 2, 4592},
	{38822, 223112, 1, 1984},
	{38917, 223488, 3, 1993},
	{38940, 223492, 3, 1993},
	{38963, 223496, 3, 1993},
	{38986, 223500, 3, 1993},
	{39009, 223504, 2, 1996},
	{39033, 223508, 2, 1996},
	{39057, 223744, 3, 1993},
	{39081, 223748, 3, 1993},
	{39105, 223752, 3, 1993},
	{39129, 223756, 3, 1993},
	{39153, 223760, 2, 1996},
	{39178, 224000, 5, 1998},
	{39201, 224004, 4, 2003},
	{39225, 224008, 5, 1998},
	{39248, 224256, 5, 1998},
	{39271, 224260, 4, 2003},
	{39295, 224264, 5, 1998},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{55737, 224768, 5, 1954},
	{55761, 224772, 4, 1948},
	{55786, 224776, 5, 1954},
	{55810, 224780, 4, 1948},
	{55835, 224784, 3, 2010},
	{55859, 224788, 3, 2010},
	{55883, 224832, 5, 1954},
	{55907, 224836, 4, 1948},
	{55932, 224840, 5, 1954},
	{55956, 224844, 4, 1948},
	{55981, 224848, 3, 2010},
	{56005, 224852, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 2025},
	{40186, 225288, 4, 2030},
	{40210, 225292, 2, 2034},
	{40233, 225296, 2, 2034},
	{40256, 225300, 2, 2034},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 4, 2036},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40524, 225808, 7, 2042},
	{40598, 225812},
	{40621, 225816},
	{56150, 225820, 2, 5194},
	{56183, 225824, 2, 5194},
	{56216, 225828, 2, 5194},
	{56249, 225832, 2, 5194},
	{56281, 225836, 2, 5194},
	{56313, 225840, 2, 5194},
	{56345, 225844, 2, 5194},
	{56378, 225848, 2, 5194},
	{56410, 225856, 2, 5194},
	{56442, 225860, 2, 5194},
	{56475, 225864, 2, 5194},
	{56508, 225868, 2, 5194},
	{56541, 225872, 2, 5194},
	{56573, 225876, 2, 5194},
	{56605, 225880, 2, 5194},
	{56638, 225884, 2, 5194},
	{56671, 225888, 2, 5194},
	{56737, 225896, 2, 5194},
	{40644, 225900},
	{40671, 225904},
	{40553, 225908},
	{40572, 225912},
	{56769, 225916, 2, 5194},
	{56803, 225920, 2, 5194},
	{56837, 225924, 2, 5194},
	{56871, 225928, 2, 5194},
	{41541, 226044, 1, 2126},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 5196},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 9, 4988},
	{43221, 1281, 6, 5201},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
};

static const struct si_reg gfx81_reg_table[] = {
	{1310, 68, 10, 5207},
	{1323, 72, 23, 5217},
	{1338, 76, 4, 5240},
	{51139, 80, 11, 5013},
	{1375, 84, 4, 3874},
	{1393, 88, 2, 3878},
	{1411, 92, 6, 5244},
	{1426, 96},
	{1440, 100, 1, 70},
	{1454, 104},
	{51153, 108},
	{51170, 112, 13, 5250},
	{1471, 116, 5, 5263},
	{51186, 2480},
	{51201, 2484, 1, 3898},
	{51216, 2488},
	{51231, 2492, 1, 3898},
	{1609, 2496},
	{1623, 2500},
	{1637, 2504},
	{1651, 2508},
	{1665, 2512},
	{1679, 2516},
	{1693, 2520},
	{1707, 2524},
	{1721, 2528},
	{1735, 2532},
	{1749, 2536},
	{1764, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{51246, 3660, 21, 3899},
	{51259, 3664, 20, 3920},
	{51271, 3668, 16, 3940},
	{1954, 32776, 18, 5268},
	{1967, 32784, 24, 3978},
	{1979, 32788, 11, 4002},
	{1995, 32792, 11, 4002},
	{2024, 32824, 11, 4002},
	{2040, 32828, 11, 4002},
	{2056, 33296, 15, 5286},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 5301},
	{2108, 33308, 21, 5315},
	{2122, 33312, 31, 5096},
	{2139, 33316, 9, 5336},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 330},
	{2222, 33348},
	{2283, 33436, 1, 342},
	{53825, 36416},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 14, 5345},
	{3642, 36624},
	{3660, 36628, 5, 5583},
	{3678, 36632, 4, 4661},
	{3696, 36636, 11, 4665},
	{3714, 36640, 2, 4676},
	{3732, 36644, 2, 4678},
	{3750, 36648, 8, 5364},
	{3768, 36652},
	{2759, 36656, 14, 5372},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5386},
	{2813, 36668, 3, 4706},
	{2831, 37120, 6, 426},
	{2847, 39160, 9, 4709},
	{2862, 39184, 5, 4719},
	{2876, 39188, 5, 4719},
	{2890, 39192, 5, 4719},
	{2904, 39196, 5, 4719},
	{2918, 39200, 5, 4719},
	{2932, 39204, 5, 4719},
	{2946, 39208, 5, 4719},
	{2960, 39212, 5, 4719},
	{2974, 39216, 5, 4719},
	{2988, 39220, 5, 4719},
	{3002, 39224, 5, 4719},
	{3017, 39228, 5, 4719},
	{3032, 39232, 5, 4719},
	{3047, 39236, 5, 4719},
	{3062, 39240, 5, 4719},
	{3077, 39244, 5, 4719},
	{3092, 39248, 5, 4719},
	{3107, 39252, 5, 4719},
	{3122, 39256, 5, 4719},
	{3137, 39260, 5, 4719},
	{3152, 39264, 5, 4719},
	{3167, 39268, 5, 4719},
	{3182, 39272, 5, 4719},
	{3197, 39276, 5, 4719},
	{3212, 39280, 5, 4719},
	{3227, 39284, 5, 4719},
	{3242, 39288, 5, 4719},
	{3257, 39292, 5, 4719},
	{3272, 39296, 5, 4719},
	{3287, 39300, 5, 4719},
	{3302, 39304, 5, 4719},
	{3317, 39308, 5, 4719},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{54059, 45056},
	{54080, 45060, 1, 488},
	{54101, 45064},
	{54122, 45068, 1, 488},
	{3835, 45084, 3, 485},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 4724},
	{3925, 45100, 6, 500},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{54143, 45312},
	{54164, 45316, 1, 488},
	{54185, 45320},
	{54206, 45324, 1, 488},
	{5016, 45336, 3, 485},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 4741},
	{5131, 45356, 11, 5396},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{6200, 45552, 6, 560},
	{6227, 45556, 5, 566},
	{54227, 45568},
	{54248, 45572, 1, 488},
	{54269, 45576},
	{54290, 45580, 1, 488},
	{6415, 45596, 4, 573},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 11, 4763},
	{6505, 45612, 4, 551},
	{6529, 45616},
	{6555, 45620},
	{6581, 45624},
	{6607, 45628},
	{6633, 45632},
	{6659, 45636},
	{6685, 45640},
	{6711, 45644},
	{6737, 45648},
	{6763, 45652},
	{6789, 45656},
	{6816, 45660},
	{6843, 45664},
	{6870, 45668},
	{6897, 45672},
	{6924, 45676},
	{7559, 45808, 6, 560},
	{54311, 45824},
	{54332, 45828, 1, 488},
	{54353, 45832},
	{54374, 45836, 1, 488},
	{7586, 45852, 4, 573},
	{7610, 45856},
	{7631, 45860, 1, 488},
	{7652, 45864, 12, 4741},
	{7676, 45868, 6, 560},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{8122, 46068, 5, 566},
	{54395, 46080},
	{54416, 46084, 1, 488},
	{54437, 46088},
	{54458, 46092, 1, 488},
	{8310, 46108, 3, 609},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 10, 4784},
	{8400, 46124, 6, 625},
	{8424, 46128},
	{8450, 46132},
	{8476, 46136},
	{8502, 46140},
	{8528, 46144},
	{8554, 46148},
	{8580, 46152},
	{8606, 46156},
	{8632, 46160},
	{8658, 46164},
	{8684, 46168},
	{8711, 46172},
	{8738, 46176},
	{8765, 46180},
	{8792, 46184},
	{8819, 46188},
	{9454, 46324, 5, 566},
	{54479, 46336},
	{54500, 46340, 1, 488},
	{54521, 46344},
	{54542, 46348, 1, 488},
	{9481, 46364, 4, 573},
	{9505, 46368},
	{9526, 46372, 1, 488},
	{9547, 46376, 11, 4800},
	{9571, 46380, 5, 566},
	{9595, 46384},
	{9621, 46388},
	{9647, 46392},
	{9673, 46396},
	{9699, 46400},
	{9725, 46404},
	{9751, 46408},
	{9777, 46412},
	{9803, 46416},
	{9829, 46420},
	{9855, 46424},
	{9882, 46428},
	{9909, 46432},
	{9936, 46436},
	{9963, 46440},
	{9990, 46444},
	{10017, 47104, 12, 4816},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 2, 4829},
	{54583, 47160},
	{54598, 47164, 1, 660},
	{54613, 47168},
	{54628, 47172, 1, 660},
	{10404, 47176, 10, 4831},
	{10422, 47180, 11, 673},
	{10440, 47184, 1, 684},
	{10453, 47188, 6, 685},
	{54643, 47192, 2, 4848},
	{54674, 47196, 2, 4848},
	{10531, 47200, 2, 691},
	{54857, 47204, 2, 4848},
	{54888, 47208, 2, 4848},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 5, 694},
	{10710, 47232},
	{10730, 47236},
	{10913, 47240, 3, 710},
	{10930, 47244},
	{10959, 47248, 1, 713},
	{56905, 47252, 2, 5407},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11377, 47612},
	{54705, 53300, 29, 4850},
	{54722, 55348, 29, 4850},
	{11393, 163840, 10, 716},
	{11411, 163844, 9, 4879},
	{11428, 163848, 4, 4888},
	{11442, 163852, 23, 744},
	{11461, 163856, 15, 767},
	{11481, 163860},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{54739, 163900, 7, 4892},
	{11671, 163904, 10, 5409},
	{11681, 163908, 6, 5419},
	{11697, 163912},
	{11712, 163916},
	{11733, 163920},
	{11749, 163924},
	{54753, 163928, 2, 4912},
	{54767, 163932, 1, 4914},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 872},
	{13954, 164692, 3, 887},
	{13976, 164696, 2, 890},
	{14033, 164704, 1, 899},
	{54782, 164708, 1, 4915},
	{14064, 164712, 1, 901},
	{14132, 164864},
	{14149, 164868},
	{14166, 164872},
	{14182, 164876},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14293, 164900, 3, 5425},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16837, 165444, 12, 946},
	{16857, 165448, 12, 946},
	{16877, 165452, 12, 946},
	{16897, 165456, 12, 946},
	{16917, 165460, 12, 946},
	{16937, 165464, 12, 946},
	{16957, 165468, 12, 946},
	{16977, 165472, 12, 946},
	{16997, 165476, 12, 946},
	{17017, 165480, 12, 946},
	{17037, 165484, 12, 946},
	{17058, 165488, 12, 946},
	{17079, 165492, 12, 946},
	{17100, 165496, 12, 946},
	{17121, 165500, 12, 946},
	{17142, 165504, 12, 946},
	{17163, 165508, 12, 946},
	{17184, 165512, 12, 946},
	{17205, 165516, 12, 946},
	{17226, 165520, 12, 946},
	{17247, 165524, 9, 958},
	{17268, 165528, 9, 958},
	{17289, 165532, 9, 958},
	{17310, 165536, 9, 958},
	{17331, 165540, 9, 958},
	{17352, 165544, 9, 958},
	{17373, 165548, 9, 958},
	{17394, 165552, 9, 958},
	{17415, 165556, 9, 958},
	{17436, 165560, 9, 958},
	{17457, 165564, 9, 958},
	{17478, 165568, 9, 958},
	{17499, 165572, 2, 967},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 3, 4916},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17645, 165644, 4, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{17709, 165716, 8, 1021},
	{17727, 165720, 8, 1029},
	{17748, 165724, 17, 1037},
	{17769, 165728, 6, 1054},
	{17787, 165732, 6, 1054},
	{17805, 165736, 6, 1054},
	{17823, 165740, 6, 1054},
	{17841, 165744, 6, 1054},
	{17859, 165748, 6, 1054},
	{17877, 165752, 6, 1054},
	{17895, 165756, 6, 1054},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 4919},
	{18176, 165864},
	{18189, 165872, 5, 1071},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 4, 5588},
	{18314, 165900, 13, 1107},
	{18332, 165904, 19, 1124},
	{18348, 165908, 13, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 27, 5431},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 4923},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 5458},
	{18954, 166468, 2, 1297},
	{18973, 166472, 4, 1300},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 4927},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 7, 5473},
	{19213, 166528},
	{19224, 166532, 2, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 5480},
	{19307, 166548, 1, 1354},
	{19356, 166560},
	{19381, 166564},
	{19406, 166568, 7, 5483},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 8, 5490},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20057, 166736, 4, 5592},
	{20079, 166740, 10, 1401},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 10, 5498},
	{20220, 166768, 6, 1435},
	{20237, 166772},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 2, 1443},
	{20455, 166804, 7, 4957},
	{20474, 166808, 4, 1454},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 4, 1474},
	{20592, 166880, 5, 1479},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21307, 166976, 1, 1524},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{21490, 167012, 2, 1566},
	{21506, 167016, 1, 1568},
	{21522, 167020, 2, 4888},
	{21537, 167024, 18, 5596},
	{21552, 167028, 6, 1591},
	{21569, 167032, 9, 1599},
	{21591, 167036},
	{21607, 167040, 1, 1611},
	{21629, 167044},
	{21645, 167048, 1, 1568},
	{21667, 167052},
	{21689, 167056},
	{21711, 167060},
	{21730, 167068},
	{21745, 167072, 2, 1566},
	{21761, 167076, 1, 1568},
	{21777, 167080, 2, 4888},
	{21792, 167084, 18, 5596},
	{21807, 167088, 6, 1591},
	{21824, 167092, 9, 1599},
	{21846, 167096},
	{21862, 167100, 1, 1611},
	{21884, 167104},
	{21900, 167108, 1, 1568},
	{21922, 167112},
	{21944, 167116},
	{21966, 167120},
	{21985, 167128},
	{22000, 167132, 2, 1566},
	{22016, 167136, 1, 1568},
	{22032, 167140, 2, 4888},
	{22047, 167144, 18, 5596},
	{22062, 167148, 6, 1591},
	{22079, 167152, 9, 1599},
	{22101, 167156},
	{22117, 167160, 1, 1611},
	{22139, 167164},
	{22155, 167168, 1, 1568},
	{22177, 167172},
	{22199, 167176},
	{22221, 167180},
	{22240, 167188},
	{22255, 167192, 2, 1566},
	{22271, 167196, 1, 1568},
	{22287, 167200, 2, 4888},
	{22302, 167204, 18, 5596},
	{22317, 167208, 6, 1591},
	{22334, 167212, 9, 1599},
	{22356, 167216},
	{22372, 167220, 1, 1611},
	{22394, 167224},
	{22410, 167228, 1, 1568},
	{22432, 167232},
	{22454, 167236},
	{22476, 167240},
	{22495, 167248},
	{22510, 167252, 2, 1566},
	{22526, 167256, 1, 1568},
	{22542, 167260, 2, 4888},
	{22557, 167264, 18, 5596},
	{22572, 167268, 6, 1591},
	{22589, 167272, 9, 1599},
	{22611, 167276},
	{22627, 167280, 1, 1611},
	{22649, 167284},
	{22665, 167288, 1, 1568},
	{22687, 167292},
	{22709, 167296},
	{22731, 167300},
	{22750, 167308},
	{22765, 167312, 2, 1566},
	{22781, 167316, 1, 1568},
	{22797, 167320, 2, 4888},
	{22812, 167324, 18, 5596},
	{22827, 167328, 6, 1591},
	{22844, 167332, 9, 1599},
	{22866, 167336},
	{22882, 167340, 1, 1611},
	{22904, 167344},
	{22920, 167348, 1, 1568},
	{22942, 167352},
	{22964, 167356},
	{22986, 167360},
	{23005, 167368},
	{23020, 167372, 2, 1566},
	{23036, 167376, 1, 1568},
	{23052, 167380, 2, 4888},
	{23067, 167384, 18, 5596},
	{23082, 167388, 6, 1591},
	{23099, 167392, 9, 1599},
	{23121, 167396},
	{23137, 167400, 1, 1611},
	{23159, 167404},
	{23175, 167408, 1, 1568},
	{23197, 167412},
	{23219, 167416},
	{23241, 167420},
	{23260, 167428},
	{23275, 167432, 2, 1566},
	{23291, 167436, 1, 1568},
	{23307, 167440, 2, 4888},
	{23322, 167444, 18, 5596},
	{23337, 167448, 6, 1591},
	{23354, 167452, 9, 1599},
	{23376, 167456},
	{23392, 167460, 1, 1611},
	{23414, 167464},
	{23430, 167468, 1, 1568},
	{23452, 167472},
	{23474, 167476},
	{23496, 167480},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{24661, 196632, 1, 1626},
	{24683, 196636, 1, 1627},
	{24705, 196640},
	{24735, 196644},
	{24765, 196648},
	{24794, 196652},
	{24823, 196656},
	{24853, 196660},
	{24883, 196664},
	{24912, 196668},
	{24941, 196672},
	{24971, 196676},
	{25001, 196680},
	{25030, 196684},
	{25059, 196688},
	{25089, 196692},
	{25119, 196696},
	{25148, 196700},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{25841, 196852, 2, 5526},
	{25863, 196856, 2, 5526},
	{25885, 196860, 1, 1632},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{26119, 196928, 2, 1633},
	{26132, 196932},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 5, 5528},
	{26339, 196968},
	{26354, 196972},
	{26378, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 2, 4114},
	{26554, 197032, 3, 5533},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 2, 4117},
	{26626, 197048, 3, 5536},
	{26644, 197052},
	{26662, 197056, 2, 1646},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 1646},
	{26744, 197080, 5, 1648},
	{26764, 197084, 8, 5539},
	{26783, 197088, 8, 5539},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 26, 5547},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 4, 4148},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 9, 4154},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 9, 4154},
	{27102, 197160, 5, 4163},
	{27114, 197164, 2, 1693},
	{27131, 197168, 1, 1695},
	{27148, 197172, 1, 1696},
	{27166, 197176, 4, 1697},
	{27186, 197180, 1, 1701},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27232, 197192, 1, 1704},
	{27246, 197196, 1, 1705},
	{27260, 197200, 1, 1706},
	{27282, 197204, 1, 1707},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27344, 197216, 1, 1704},
	{27361, 197220, 1, 1705},
	{27378, 197224},
	{56934, 197228, 1, 1703},
	{27637, 197388, 1, 1718},
	{27656, 197392, 1, 1719},
	{27675, 197396, 1, 1720},
	{27692, 197400, 1, 1721},
	{27710, 197404, 1, 1722},
	{27728, 197408, 1, 1723},
	{27744, 197412, 1, 1724},
	{27762, 197416, 1, 1725},
	{27780, 197420, 1, 1726},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 4, 5573},
	{27945, 197464, 4, 5166},
	{27967, 197468, 1, 1737},
	{28111, 197552, 1, 1742},
	{28136, 197556, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28235, 197576},
	{28260, 197580, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28645, 198656, 6, 4020},
	{28660, 198912},
	{28679, 198916},
	{28698, 198920, 1, 4403},
	{28717, 198924, 1, 1340},
	{28732, 198928},
	{28765, 198932},
	{28798, 198936},
	{28831, 198940},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 1782},
	{28972, 198972, 2, 1783},
	{28993, 198976},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{53736, 199872},
	{53757, 199876, 1, 4580},
	{2431, 199880, 8, 5134},
	{2452, 199884, 3, 4589},
	{53778, 199888, 2, 4592},
	{2479, 199892, 1, 4616},
	{53804, 199896, 15, 4601},
	{54807, 199900, 1, 5143},
	{54829, 199904},
	{2410, 199908, 2, 4594},
	{2500, 199912, 5, 5146},
	{53846, 199916, 1, 4617},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{30091, 199968, 6, 1816},
	{30102, 199972, 2, 1823},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30345, 200696},
	{30364, 200700, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 1832},
	{30586, 200756, 2, 1834},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 9, 5614},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 5577},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{54919, 213504},
	{54938, 213508},
	{54957, 213512},
	{54976, 213516},
	{54995, 213520},
	{55014, 213524},
	{55033, 213528},
	{55052, 213532},
	{52409, 213536},
	{52428, 213540},
	{52447, 213544},
	{52466, 213548},
	{52485, 213552},
	{52504, 213556},
	{52523, 213560},
	{52542, 213564},
	{52962, 213568},
	{52982, 213572},
	{53002, 213576},
	{53022, 213580},
	{53042, 213584},
	{53062, 213588},
	{53082, 213592},
	{53102, 213596},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{32825, 214784},
	{32844, 214788},
	{32863, 214792},
	{32882, 214796},
	{32901, 214800},
	{32920, 214804},
	{32939, 214808},
	{32958, 214812},
	{32977, 214816},
	{32996, 214820},
	{33015, 214824},
	{33034, 214828},
	{33053, 214832},
	{33072, 214836},
	{33091, 214840},
	{33110, 214844},
	{33129, 214848},
	{33148, 214852},
	{33167, 214856},
	{33186, 214860},
	{33205, 214864},
	{33225, 214868},
	{33245, 214872},
	{33265, 214876},
	{33285, 214880},
	{33305, 214884},
	{33325, 214888},
	{33345, 214892},
	{33365, 214896},
	{33385, 214900},
	{33405, 214904},
	{33425, 214908},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{55071, 216576},
	{55091, 216580},
	{55111, 216584},
	{55131, 216588},
	{55151, 216592},
	{55171, 216596},
	{55191, 216600},
	{55211, 216604},
	{55231, 216640},
	{55251, 216644},
	{55271, 216648},
	{55291, 216652},
	{55311, 216656},
	{55331, 216660},
	{55351, 216664},
	{55371, 216668},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{36629, 221184, 1, 1900},
	{36653, 221188, 2, 5183},
	{36678, 221192, 3, 5185},
	{36702, 221196, 1, 1900},
	{36726, 221200, 2, 5183},
	{36751, 221204, 1, 1900},
	{36775, 221208, 2, 5183},
	{36800, 221212, 3, 5185},
	{36824, 221216, 4, 1878},
	{36840, 221220, 3, 5185},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 19, 4063},
	{37149, 221444, 19, 4063},
	{37174, 221448, 12, 4082},
	{37202, 221452, 12, 4082},
	{37230, 221456, 12, 4082},
	{37258, 221460, 12, 4082},
	{55551, 221696, 2, 4361},
	{55574, 221700, 2, 4361},
	{55597, 221704, 2, 4361},
	{55620, 221708, 2, 4361},
	{52317, 221712, 5, 1954},
	{52340, 221716, 2, 4361},
	{52363, 221720, 2, 4361},
	{52386, 221724, 2, 4361},
	{55643, 221728, 4, 1959},
	{52866, 221744, 5, 1954},
	{52890, 221748, 5, 1954},
	{52914, 221752, 2, 4361},
	{52938, 221756, 2, 4361},
	{55667, 221760, 4, 1959},
	{55692, 221764, 4, 1959},
	{52840, 221776, 1, 4402},
	{37716, 222208, 3, 1954},
	{37742, 222212, 2, 1874},
	{37769, 222216, 3, 1954},
	{37795, 222220, 2, 1874},
	{37822, 222224, 2, 2010},
	{37875, 222228, 2, 2010},
	{37928, 222464, 3, 1954},
	{37954, 222468, 2, 1874},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 3, 1954},
	{38187, 222724, 3, 1954},
	{38211, 222728, 3, 1954},
	{38235, 222732, 3, 1954},
	{38259, 222736, 2, 1874},
	{38284, 222740, 2, 1874},
	{38309, 222744, 2, 1874},
	{38334, 222748, 2, 1874},
	{38359, 222752, 1, 1998},
	{38383, 222756, 1, 1998},
	{38407, 222760, 8, 1963},
	{38428, 222976, 6, 4560},
	{38451, 222980, 6, 4560},
	{38474, 222984, 6, 4560},
	{38497, 222988, 6, 4560},
	{38520, 222992, 6, 4560},
	{38543, 222996, 6, 4560},
	{38566, 223000, 6, 4560},
	{38589, 223004, 6, 4560},
	{38612, 223008, 6, 4560},
	{38635, 223012, 6, 4560},
	{38658, 223016, 6, 4560},
	{38682, 223020, 6, 4560},
	{38706, 223024, 6, 4560},
	{38730, 223028, 6, 4560},
	{38754, 223032, 6, 4560},
	{38778, 223036, 6, 4560},
	{38802, 223104, 9, 4543},
	{55717, 223108, 2, 4592},
	{38822, 223112, 1, 1984},
	{38917, 223488, 3, 1993},
	{38940, 223492, 3, 1993},
	{38963, 223496, 3, 1993},
	{38986, 223500, 3, 1993},
	{39009, 223504, 2, 1996},
	{39033, 223508, 2, 1996},
	{39057, 223744, 3, 1993},
	{39081, 223748, 3, 1993},
	{39105, 223752, 3, 1993},
	{39129, 223756, 3, 1993},
	{39153, 223760, 2, 1996},
	{39178, 224000, 5, 1998},
	{39201, 224004, 4, 2003},
	{39225, 224008, 5, 1998},
	{39248, 224256, 5, 1998},
	{39271, 224260, 4, 2003},
	{39295, 224264, 5, 1998},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{55737, 224768, 5, 1954},
	{55761, 224772, 4, 1948},
	{55786, 224776, 5, 1954},
	{55810, 224780, 4, 1948},
	{55835, 224784, 3, 2010},
	{55859, 224788, 3, 2010},
	{55883, 224832, 5, 1954},
	{55907, 224836, 4, 1948},
	{55932, 224840, 5, 1954},
	{55956, 224844, 4, 1948},
	{55981, 224848, 3, 2010},
	{56005, 224852, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 2025},
	{40186, 225288, 4, 2030},
	{40210, 225292, 2, 2034},
	{40233, 225296, 2, 2034},
	{40256, 225300, 2, 2034},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 4, 2036},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40524, 225808, 7, 2042},
	{40598, 225812},
	{40621, 225816},
	{56150, 225820, 2, 5194},
	{56183, 225824, 2, 5194},
	{56216, 225828, 2, 5194},
	{56249, 225832, 2, 5194},
	{56281, 225836, 2, 5194},
	{56313, 225840, 2, 5194},
	{56345, 225844, 2, 5194},
	{56378, 225848, 2, 5194},
	{56410, 225856, 2, 5194},
	{56442, 225860, 2, 5194},
	{56475, 225864, 2, 5194},
	{56508, 225868, 2, 5194},
	{56541, 225872, 2, 5194},
	{56573, 225876, 2, 5194},
	{56605, 225880, 2, 5194},
	{56638, 225884, 2, 5194},
	{56671, 225888, 2, 5194},
	{56737, 225896, 2, 5194},
	{40644, 225900},
	{40671, 225904},
	{40553, 225908},
	{40572, 225912},
	{41541, 226044, 1, 2126},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 5196},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 9, 4988},
	{43221, 1281, 6, 5201},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
};

static const struct si_reg gfx9_reg_table[] = {
	{1310, 68, 14, 5623},
	{1323, 72, 23, 5637},
	{1338, 76, 7, 5660},
	{51139, 80, 11, 5013},
	{1375, 84, 4, 3874},
	{1393, 88, 2, 3878},
	{1411, 92, 7, 5667},
	{1426, 96},
	{1440, 100, 1, 70},
	{1454, 104},
	{51153, 108},
	{51170, 112, 13, 5674},
	{1471, 116, 7, 5687},
	{1487, 120},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 25, 5694},
	{1967, 32784, 24, 5719},
	{1979, 32788, 12, 5743},
	{1995, 32792, 12, 5743},
	{2024, 32824, 12, 5743},
	{2040, 32828, 12, 5743},
	{2056, 33296, 16, 5755},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 232},
	{2108, 33308, 21, 5771},
	{2122, 33312, 31, 5096},
	{2139, 33316, 11, 307},
	{2178, 33324, 1, 329},
	{2201, 33344, 1, 330},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2283, 33436, 1, 342},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 12, 5792},
	{3642, 36624},
	{3660, 36628, 8, 5804},
	{3678, 36632, 3, 4661},
	{3696, 36636, 8, 5812},
	{3714, 36640, 3, 5820},
	{3732, 36644, 7, 5823},
	{3750, 36648, 8, 5364},
	{3768, 36652},
	{2759, 36656, 14, 5372},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5830},
	{2813, 36668, 3, 5840},
	{2847, 39160, 13, 5843},
	{2862, 39184, 5, 4719},
	{2876, 39188, 5, 4719},
	{2890, 39192, 5, 4719},
	{2904, 39196, 5, 4719},
	{2918, 39200, 5, 4719},
	{2932, 39204, 5, 4719},
	{2946, 39208, 5, 4719},
	{2960, 39212, 5, 4719},
	{2974, 39216, 5, 4719},
	{2988, 39220, 5, 4719},
	{3002, 39224, 5, 4719},
	{3017, 39228, 5, 4719},
	{3032, 39232, 5, 4719},
	{3047, 39236, 5, 4719},
	{3062, 39240, 5, 4719},
	{3077, 39244, 5, 4719},
	{3092, 39248, 5, 4719},
	{3107, 39252, 5, 4719},
	{3122, 39256, 5, 4719},
	{3137, 39260, 5, 4719},
	{3152, 39264, 5, 4719},
	{3167, 39268, 5, 4719},
	{3182, 39272, 5, 4719},
	{3197, 39276, 5, 4719},
	{3212, 39280, 5, 4719},
	{3227, 39284, 5, 4719},
	{3242, 39288, 5, 4719},
	{3257, 39292, 5, 4719},
	{3272, 39296, 5, 4719},
	{3287, 39300, 5, 4719},
	{3302, 39304, 5, 4719},
	{3317, 39308, 5, 4719},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{3835, 45084, 4, 5856},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 5860},
	{3925, 45100, 10, 5871},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{4371, 45168},
	{4398, 45172},
	{4425, 45176},
	{4452, 45180},
	{4479, 45184},
	{4506, 45188},
	{4533, 45192},
	{4560, 45196},
	{4587, 45200},
	{4614, 45204},
	{4641, 45208},
	{4668, 45212},
	{4695, 45216},
	{4722, 45220},
	{4749, 45224},
	{4776, 45228},
	{5016, 45336, 4, 5856},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 5881},
	{5131, 45356, 14, 5893},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{5577, 45424},
	{5604, 45428},
	{5631, 45432},
	{5658, 45436},
	{5685, 45440},
	{5712, 45444},
	{5739, 45448},
	{5766, 45452},
	{5793, 45456},
	{5820, 45460},
	{5847, 45464},
	{5874, 45468},
	{5901, 45472},
	{5928, 45476},
	{5955, 45480},
	{5982, 45484},
	{6173, 45552, 9, 551},
	{6279, 45572, 2, 5907},
	{6303, 45576},
	{6335, 45580},
	{7610, 45584},
	{7631, 45588, 1, 488},
	{6415, 45596, 4, 5856},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 12, 5909},
	{6505, 45612, 9, 5921},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{56950, 45936},
	{56977, 45940},
	{57004, 45944},
	{57031, 45948},
	{57058, 45952},
	{57085, 45956},
	{57112, 45960},
	{57139, 45964},
	{57166, 45968},
	{57193, 45972},
	{57220, 45976},
	{57247, 45980},
	{57274, 45984},
	{57301, 45988},
	{57328, 45992},
	{57355, 45996},
	{8174, 46084, 1, 5907},
	{8198, 46088},
	{8230, 46092},
	{9505, 46096},
	{9526, 46100, 1, 488},
	{8310, 46108, 4, 5930},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 11, 5934},
	{8400, 46124, 7, 5945},
	{9595, 46128},
	{9621, 46132},
	{9647, 46136},
	{9673, 46140},
	{9699, 46144},
	{9725, 46148},
	{9751, 46152},
	{9777, 46156},
	{9803, 46160},
	{9829, 46164},
	{9855, 46168},
	{9882, 46172},
	{9909, 46176},
	{9936, 46180},
	{9963, 46184},
	{9990, 46188},
	{57382, 46192},
	{57409, 46196},
	{57436, 46200},
	{57463, 46204},
	{57490, 46208},
	{57517, 46212},
	{57544, 46216},
	{57571, 46220},
	{57598, 46224},
	{57625, 46228},
	{57652, 46232},
	{57679, 46236},
	{57706, 46240},
	{57733, 46244},
	{57760, 46248},
	{57787, 46252},
	{57814, 46384},
	{57844, 46388},
	{57874, 46392},
	{57904, 46396},
	{57934, 46400},
	{57964, 46404},
	{57994, 46408},
	{58024, 46412},
	{58054, 46416},
	{58084, 46420},
	{58114, 46424},
	{58145, 46428},
	{58176, 46432},
	{58207, 46436},
	{58238, 46440},
	{58269, 46444},
	{58300, 46448},
	{58331, 46452},
	{58362, 46456},
	{58393, 46460},
	{58424, 46464},
	{58455, 46468},
	{58486, 46472},
	{58517, 46476},
	{58548, 46480},
	{58579, 46484},
	{58610, 46488},
	{58641, 46492},
	{58672, 46496},
	{58703, 46500},
	{58734, 46504},
	{58765, 46508},
	{10017, 47104, 11, 5952},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 1, 660},
	{10280, 47160},
	{10309, 47164, 1, 660},
	{10338, 47168},
	{10371, 47172, 1, 660},
	{10404, 47176, 11, 5963},
	{10422, 47180, 12, 5974},
	{10440, 47184, 1, 684},
	{10453, 47188, 7, 5986},
	{54643, 47192, 2, 4848},
	{54674, 47196, 2, 4848},
	{10531, 47200, 2, 691},
	{54857, 47204, 2, 4848},
	{54888, 47208, 2, 4848},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 5, 694},
	{10710, 47232},
	{10730, 47236},
	{10913, 47240, 3, 710},
	{10930, 47244},
	{10959, 47248, 1, 713},
	{10891, 47252},
	{47351, 47252},
	{47382, 47256},
	{47413, 47260},
	{47444, 47264},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11356, 47608},
	{11377, 47612},
	{11393, 163840, 10, 716},
	{11411, 163844, 9, 4879},
	{11428, 163848, 5, 5993},
	{11442, 163852, 23, 744},
	{11461, 163856, 16, 767},
	{11481, 163860},
	{11893, 163864, 1, 827},
	{54753, 163868, 2, 783},
	{11517, 163872},
	{11537, 163876},
	{11557, 163880, 1, 785},
	{11574, 163884},
	{11589, 163888, 2, 786},
	{11613, 163892, 2, 788},
	{11671, 163896, 13, 5998},
	{11681, 163900, 8, 6011},
	{11697, 163904},
	{11807, 163908, 1, 827},
	{11712, 163912},
	{11825, 163916, 1, 827},
	{11733, 163920},
	{11849, 163924, 1, 827},
	{11749, 163928},
	{11868, 163932, 1, 827},
	{11637, 163936, 3, 790},
	{58796, 163944, 1, 6019},
	{58807, 163948, 1, 6019},
	{11939, 163968},
	{11955, 163972, 1, 837},
	{11974, 164328, 1, 838},
	{11995, 164332, 1, 838},
	{12016, 164336, 1, 838},
	{12037, 164340, 1, 838},
	{12058, 164344},
	{12076, 164348},
	{12094, 164352, 2, 839},
	{12114, 164356, 3, 841},
	{12138, 164360, 2, 844},
	{12162, 164364, 1, 846},
	{12182, 164368, 2, 841},
	{12202, 164372, 2, 844},
	{12222, 164376, 2, 841},
	{12242, 164380, 2, 844},
	{12262, 164384, 2, 841},
	{12282, 164388, 2, 844},
	{12302, 164392, 2, 841},
	{12322, 164396, 2, 844},
	{12342, 164400, 7, 847},
	{12357, 164404, 2, 854},
	{12386, 164408, 8, 856},
	{12401, 164412, 8, 864},
	{12416, 164416, 3, 841},
	{12441, 164420, 2, 844},
	{12466, 164424},
	{12484, 164428},
	{12502, 164432, 3, 841},
	{12527, 164436, 2, 844},
	{12552, 164440, 3, 841},
	{12577, 164444, 2, 844},
	{12602, 164448, 3, 841},
	{12627, 164452, 2, 844},
	{12652, 164456, 3, 841},
	{12677, 164460, 2, 844},
	{12702, 164464, 3, 841},
	{12727, 164468, 2, 844},
	{12752, 164472, 3, 841},
	{12777, 164476, 2, 844},
	{12802, 164480, 3, 841},
	{12827, 164484, 2, 844},
	{12852, 164488, 3, 841},
	{12877, 164492, 2, 844},
	{12902, 164496, 3, 841},
	{12927, 164500, 2, 844},
	{12952, 164504, 3, 841},
	{12977, 164508, 2, 844},
	{13002, 164512, 3, 841},
	{13028, 164516, 2, 844},
	{13054, 164520, 3, 841},
	{13080, 164524, 2, 844},
	{13106, 164528, 3, 841},
	{13132, 164532, 2, 844},
	{13158, 164536, 3, 841},
	{13184, 164540, 2, 844},
	{13210, 164544, 3, 841},
	{13236, 164548, 2, 844},
	{13262, 164552, 3, 841},
	{13288, 164556, 2, 844},
	{13314, 164560},
	{13333, 164564},
	{13352, 164568},
	{13371, 164572},
	{13390, 164576},
	{13409, 164580},
	{13428, 164584},
	{13447, 164588},
	{13466, 164592},
	{13485, 164596},
	{13504, 164600},
	{13523, 164604},
	{13542, 164608},
	{13561, 164612},
	{13580, 164616},
	{13599, 164620},
	{13618, 164624},
	{13637, 164628},
	{13656, 164632},
	{13675, 164636},
	{13694, 164640},
	{13714, 164644},
	{13734, 164648},
	{13754, 164652},
	{13774, 164656},
	{13794, 164660},
	{13814, 164664},
	{13834, 164668},
	{13854, 164672},
	{13874, 164676},
	{13894, 164680},
	{13914, 164684},
	{13934, 164688, 15, 6020},
	{13954, 164692, 3, 6035},
	{13976, 164696, 2, 890},
	{14004, 164700, 3, 892},
	{14033, 164704, 1, 899},
	{14054, 164708, 1, 900},
	{14064, 164712, 1, 901},
	{14072, 164768, 4, 902},
	{14094, 164772, 4, 902},
	{14115, 164776, 4, 906},
	{14182, 164876},
	{14236, 164884},
	{14249, 164888},
	{14264, 164892},
	{14278, 164896},
	{14293, 164900, 9, 6038},
	{14332, 164908, 6, 932},
	{14351, 164912, 4, 938},
	{14369, 164916, 4, 942},
	{14390, 164924},
	{14409, 164928},
	{14429, 164932},
	{14448, 164936},
	{14468, 164940},
	{14487, 164944},
	{14507, 164948},
	{14528, 164952},
	{14550, 164956},
	{14571, 164960},
	{14593, 164964},
	{14614, 164968},
	{14636, 164972},
	{14657, 164976},
	{14679, 164980},
	{14700, 164984},
	{14722, 164988},
	{14743, 164992},
	{14765, 164996},
	{14786, 165000},
	{14808, 165004},
	{14829, 165008},
	{14851, 165012},
	{14872, 165016},
	{14894, 165020},
	{14915, 165024},
	{14937, 165028},
	{14958, 165032},
	{14980, 165036},
	{15001, 165040},
	{15023, 165044},
	{15044, 165048},
	{15066, 165052},
	{15087, 165056},
	{15109, 165060},
	{15130, 165064},
	{15152, 165068},
	{15173, 165072},
	{15195, 165076},
	{15216, 165080},
	{15238, 165084},
	{15259, 165088},
	{15281, 165092},
	{15302, 165096},
	{15324, 165100},
	{15345, 165104},
	{15367, 165108},
	{15388, 165112},
	{15410, 165116},
	{15431, 165120},
	{15453, 165124},
	{15474, 165128},
	{15496, 165132},
	{15517, 165136},
	{15539, 165140},
	{15560, 165144},
	{15582, 165148},
	{15603, 165152},
	{15625, 165156},
	{15646, 165160},
	{15668, 165164},
	{15690, 165168},
	{15713, 165172},
	{15735, 165176},
	{15758, 165180},
	{15780, 165184},
	{15803, 165188},
	{15825, 165192},
	{15848, 165196},
	{15870, 165200},
	{15893, 165204},
	{15915, 165208},
	{15938, 165212},
	{15960, 165216},
	{15983, 165220},
	{16005, 165224},
	{16028, 165228},
	{16050, 165232},
	{16073, 165236},
	{16095, 165240},
	{16118, 165244},
	{16140, 165248},
	{16163, 165252},
	{16185, 165256},
	{16208, 165260},
	{16230, 165264},
	{16253, 165268},
	{16275, 165272},
	{16298, 165276},
	{16320, 165280},
	{16343, 165284},
	{16365, 165288},
	{16388, 165292},
	{16410, 165296},
	{16433, 165300},
	{16455, 165304},
	{16478, 165308},
	{16492, 165312},
	{16506, 165316},
	{16520, 165320},
	{16534, 165324},
	{16548, 165328},
	{16562, 165332},
	{16576, 165336},
	{16590, 165340},
	{16604, 165344},
	{16618, 165348},
	{16632, 165352},
	{16646, 165356},
	{16660, 165360},
	{16674, 165364},
	{16688, 165368},
	{16702, 165372},
	{16716, 165376},
	{16730, 165380},
	{16744, 165384},
	{16758, 165388},
	{16772, 165392},
	{16786, 165396},
	{16800, 165400},
	{16814, 165404},
	{16837, 165444, 12, 946},
	{16857, 165448, 12, 946},
	{16877, 165452, 12, 946},
	{16897, 165456, 12, 946},
	{16917, 165460, 12, 946},
	{16937, 165464, 12, 946},
	{16957, 165468, 12, 946},
	{16977, 165472, 12, 946},
	{16997, 165476, 12, 946},
	{17017, 165480, 12, 946},
	{17037, 165484, 12, 946},
	{17058, 165488, 12, 946},
	{17079, 165492, 12, 946},
	{17100, 165496, 12, 946},
	{17121, 165500, 12, 946},
	{17142, 165504, 12, 946},
	{17163, 165508, 12, 946},
	{17184, 165512, 12, 946},
	{17205, 165516, 12, 946},
	{17226, 165520, 12, 946},
	{17247, 165524, 9, 958},
	{17268, 165528, 9, 958},
	{17289, 165532, 9, 958},
	{17310, 165536, 9, 958},
	{17331, 165540, 9, 958},
	{17352, 165544, 9, 958},
	{17373, 165548, 9, 958},
	{17394, 165552, 9, 958},
	{17415, 165556, 9, 958},
	{17436, 165560, 9, 958},
	{17457, 165564, 9, 958},
	{17478, 165568, 9, 958},
	{17499, 165572, 2, 967},
	{17517, 165580, 16, 970},
	{17534, 165584, 16, 970},
	{17552, 165588, 7, 986},
	{17573, 165592, 5, 993},
	{17591, 165600, 7, 999},
	{17606, 165608, 2, 691},
	{17645, 165644, 4, 1007},
	{17667, 165648, 1, 1012},
	{17687, 165652, 8, 1013},
	{17709, 165716, 8, 1021},
	{17727, 165720, 8, 1029},
	{17748, 165724, 17, 1037},
	{17769, 165728, 6, 1054},
	{17787, 165732, 6, 1054},
	{17805, 165736, 6, 1054},
	{17823, 165740, 6, 1054},
	{17841, 165744, 6, 1054},
	{17859, 165748, 6, 1054},
	{17877, 165752, 6, 1054},
	{17895, 165756, 6, 1054},
	{17913, 165760, 9, 1060},
	{17931, 165764, 9, 1060},
	{17949, 165768, 9, 1060},
	{17967, 165772, 9, 1060},
	{17985, 165776, 9, 1060},
	{18003, 165780, 9, 1060},
	{18021, 165784, 9, 1060},
	{18039, 165788, 9, 1060},
	{58824, 165792, 1, 6019},
	{58839, 165796, 1, 6019},
	{58854, 165800, 1, 6019},
	{58869, 165804, 1, 6019},
	{58884, 165808, 1, 6019},
	{58899, 165812, 1, 6019},
	{58914, 165816, 1, 6019},
	{58929, 165820, 1, 6019},
	{18057, 165836, 1, 1069},
	{18071, 165840, 1, 1069},
	{18086, 165844},
	{18104, 165848},
	{18122, 165852},
	{18139, 165856},
	{18160, 165860, 1, 1070},
	{18176, 165864},
	{18189, 165872, 8, 1071},
	{18208, 165876},
	{18223, 165880, 1, 1079},
	{18272, 165888, 10, 1081},
	{18289, 165892, 12, 1091},
	{18297, 165896, 4, 5588},
	{18314, 165900, 16, 1107},
	{18332, 165904, 20, 1124},
	{18348, 165908, 15, 1144},
	{18367, 165912, 10, 1160},
	{18382, 165916, 28, 6047},
	{18400, 165920, 16, 1198},
	{18418, 165924, 4, 1214},
	{18442, 165928},
	{18467, 165932, 11, 1218},
	{18490, 165936, 6, 3784},
	{18519, 165940, 3, 6075},
	{18541, 165944, 2, 1238},
	{18556, 165948, 5, 1240},
	{18586, 165952, 6, 6078},
	{18619, 166400, 2, 1250},
	{18636, 166404, 2, 1252},
	{18655, 166408, 1, 1254},
	{18671, 166412, 4, 1255},
	{18690, 166416, 1, 1259},
	{18711, 166420, 1, 1260},
	{18724, 166424},
	{18747, 166428},
	{18770, 166432, 1, 1261},
	{18790, 166436, 4, 1262},
	{18810, 166440, 1, 1266},
	{18831, 166444, 1, 1267},
	{18846, 166448, 6, 1268},
	{18868, 166452, 6, 1268},
	{18890, 166456, 8, 1274},
	{18916, 166460, 8, 1274},
	{18942, 166464, 15, 5458},
	{18954, 166468, 3, 1297},
	{18973, 166472, 7, 1300},
	{18991, 166476, 24, 1307},
	{19009, 166480},
	{19021, 166484, 1, 1331},
	{19035, 166488, 1, 1332},
	{19049, 166492, 1, 1333},
	{19063, 166496, 1, 1334},
	{19086, 166500, 1, 1334},
	{19109, 166504, 1, 1334},
	{19132, 166508, 5, 1335},
	{19153, 166512},
	{19164, 166516},
	{19177, 166520},
	{19194, 166524, 7, 6084},
	{19213, 166528},
	{19224, 166532, 3, 1348},
	{19243, 166536},
	{19265, 166540},
	{19287, 166544, 3, 6091},
	{58944, 166548, 1, 6094},
	{19334, 166552, 4, 6095},
	{19356, 166560},
	{19381, 166564},
	{19425, 166572, 1, 1367},
	{19448, 166576, 1, 1367},
	{19471, 166580, 1, 1368},
	{19485, 166584, 1, 1369},
	{19500, 166588, 8, 6099},
	{19517, 166592, 4, 1379},
	{19544, 166596, 4, 1383},
	{19571, 166600, 4, 1387},
	{19590, 166608},
	{19616, 166612, 1, 1391},
	{19641, 166620},
	{19669, 166624},
	{19695, 166628, 1, 1391},
	{19720, 166636},
	{19748, 166640},
	{19774, 166644, 1, 1391},
	{19799, 166652},
	{19827, 166656},
	{19853, 166660, 1, 1391},
	{19878, 166668},
	{19906, 166696},
	{19937, 166700},
	{19980, 166704, 1, 1392},
	{20018, 166712, 1, 1393},
	{20057, 166736, 5, 1396},
	{20079, 166740, 13, 6107},
	{20100, 166744, 3, 1420},
	{20117, 166748, 1, 1367},
	{20138, 166752, 1, 1367},
	{20161, 166756, 1, 1367},
	{20184, 166760, 1, 1367},
	{20207, 166764, 8, 6120},
	{20220, 166768, 6, 1435},
	{20237, 166772},
	{20261, 166776, 2, 1441},
	{20291, 166780},
	{20315, 166784},
	{20345, 166788},
	{20376, 166792},
	{20405, 166796},
	{20435, 166800, 2, 1443},
	{20455, 166804, 8, 1446},
	{20474, 166808, 4, 1454},
	{20500, 166812, 3, 6091},
	{20524, 166868, 8, 1458},
	{20550, 166872, 8, 1466},
	{20576, 166876, 5, 1474},
	{20592, 166880, 6, 1479},
	{20608, 166884, 3, 1485},
	{20623, 166888},
	{20646, 166892},
	{20669, 166896},
	{20692, 166900},
	{20715, 166904, 8, 1488},
	{20749, 166908, 8, 1496},
	{20783, 166912, 8, 1504},
	{20817, 166916, 8, 1512},
	{20851, 166920, 8, 1488},
	{20885, 166924, 8, 1496},
	{20919, 166928, 8, 1504},
	{20953, 166932, 8, 1512},
	{20987, 166936, 8, 1488},
	{21021, 166940, 8, 1496},
	{21055, 166944, 8, 1504},
	{21089, 166948, 8, 1512},
	{21123, 166952, 8, 1488},
	{21157, 166956, 8, 1496},
	{21191, 166960, 8, 1504},
	{21225, 166964, 8, 1512},
	{21259, 166968, 2, 1520},
	{21283, 166972, 2, 1522},
	{21307, 166976, 3, 1524},
	{21328, 166980, 11, 1528},
	{21348, 166984, 2, 1540},
	{21368, 166988, 18, 1542},
	{21406, 166992, 1, 1562},
	{21426, 167000, 1, 1564},
	{21454, 167004, 1, 1565},
	{21475, 167008},
	{23515, 167012, 1, 1612},
	{24251, 167016, 3, 1613},
	{21522, 167020, 3, 6128},
	{21537, 167024, 16, 6131},
	{21552, 167028, 10, 6147},
	{21569, 167032, 11, 1599},
	{21591, 167036},
	{23667, 167040, 1, 1612},
	{21629, 167044},
	{23867, 167048, 1, 1612},
	{21667, 167052},
	{21689, 167056},
	{21711, 167060},
	{24067, 167064, 1, 1612},
	{21730, 167068},
	{23534, 167072, 1, 1612},
	{24269, 167076, 3, 1613},
	{21777, 167080, 3, 6128},
	{21792, 167084, 16, 6131},
	{21807, 167088, 10, 6147},
	{21824, 167092, 11, 1599},
	{21846, 167096},
	{23692, 167100, 1, 1612},
	{21884, 167104},
	{23892, 167108, 1, 1612},
	{21922, 167112},
	{21944, 167116},
	{21966, 167120},
	{24090, 167124, 1, 1612},
	{21985, 167128},
	{23553, 167132, 1, 1612},
	{24287, 167136, 3, 1613},
	{22032, 167140, 3, 6128},
	{22047, 167144, 16, 6131},
	{22062, 167148, 10, 6147},
	{22079, 167152, 11, 1599},
	{22101, 167156},
	{23717, 167160, 1, 1612},
	{22139, 167164},
	{23917, 167168, 1, 1612},
	{22177, 167172},
	{22199, 167176},
	{22221, 167180},
	{24113, 167184, 1, 1612},
	{22240, 167188},
	{23572, 167192, 1, 1612},
	{24305, 167196, 3, 1613},
	{22287, 167200, 3, 6128},
	{22302, 167204, 16, 6131},
	{22317, 167208, 10, 6147},
	{22334, 167212, 11, 1599},
	{22356, 167216},
	{23742, 167220, 1, 1612},
	{22394, 167224},
	{23942, 167228, 1, 1612},
	{22432, 167232},
	{22454, 167236},
	{22476, 167240},
	{24136, 167244, 1, 1612},
	{22495, 167248},
	{23591, 167252, 1, 1612},
	{24323, 167256, 3, 1613},
	{22542, 167260, 3, 6128},
	{22557, 167264, 16, 6131},
	{22572, 167268, 10, 6147},
	{22589, 167272, 11, 1599},
	{22611, 167276},
	{23767, 167280, 1, 1612},
	{22649, 167284},
	{23967, 167288, 1, 1612},
	{22687, 167292},
	{22709, 167296},
	{22731, 167300},
	{24159, 167304, 1, 1612},
	{22750, 167308},
	{23610, 167312, 1, 1612},
	{24341, 167316, 3, 1613},
	{22797, 167320, 3, 6128},
	{22812, 167324, 16, 6131},
	{22827, 167328, 10, 6147},
	{22844, 167332, 11, 1599},
	{22866, 167336},
	{23792, 167340, 1, 1612},
	{22904, 167344},
	{23992, 167348, 1, 1612},
	{22942, 167352},
	{22964, 167356},
	{22986, 167360},
	{24182, 167364, 1, 1612},
	{23005, 167368},
	{23629, 167372, 1, 1612},
	{24359, 167376, 3, 1613},
	{23052, 167380, 3, 6128},
	{23067, 167384, 16, 6131},
	{23082, 167388, 10, 6147},
	{23099, 167392, 11, 1599},
	{23121, 167396},
	{23817, 167400, 1, 1612},
	{23159, 167404},
	{24017, 167408, 1, 1612},
	{23197, 167412},
	{23219, 167416},
	{23241, 167420},
	{24205, 167424, 1, 1612},
	{23260, 167428},
	{23648, 167432, 1, 1612},
	{24377, 167436, 3, 1613},
	{23307, 167440, 3, 6128},
	{23322, 167444, 16, 6131},
	{23337, 167448, 10, 6147},
	{23354, 167452, 11, 1599},
	{23376, 167456},
	{23842, 167460, 1, 1612},
	{23414, 167464},
	{24042, 167468, 1, 1612},
	{23452, 167472},
	{23474, 167476},
	{23496, 167480},
	{24228, 167484, 1, 1612},
	{24539, 196608, 1, 1624},
	{24559, 196612, 1, 1625},
	{24579, 196616},
	{24599, 196620},
	{24619, 196624},
	{24640, 196628},
	{24661, 196632, 1, 1626},
	{24683, 196636, 1, 1627},
	{24705, 196640},
	{24735, 196644},
	{24765, 196648},
	{24794, 196652},
	{24823, 196656},
	{24853, 196660},
	{24883, 196664},
	{24912, 196668},
	{24941, 196672},
	{24971, 196676},
	{25001, 196680},
	{25030, 196684},
	{25059, 196688},
	{25089, 196692},
	{25119, 196696},
	{25148, 196700},
	{25177, 196704, 1, 1628},
	{25199, 196708, 1, 1629},
	{25221, 196712},
	{25244, 196716},
	{25267, 196720},
	{25290, 196724},
	{25313, 196728},
	{25336, 196732},
	{25359, 196736},
	{25383, 196740},
	{25407, 196744},
	{25431, 196748},
	{25455, 196752},
	{25479, 196756},
	{25503, 196760},
	{25527, 196764},
	{25551, 196768},
	{25573, 196772},
	{25595, 196776},
	{25616, 196780},
	{25637, 196784},
	{25661, 196788},
	{25685, 196792},
	{25709, 196796},
	{25733, 196800},
	{25757, 196804},
	{25841, 196852, 1, 5530},
	{25863, 196856, 1, 5530},
	{25885, 196860, 1, 1632},
	{25901, 196864},
	{25914, 196868},
	{25927, 196872},
	{25940, 196876},
	{25953, 196880},
	{25966, 196884},
	{25979, 196888},
	{25992, 196892},
	{26047, 196912},
	{26065, 196916},
	{26092, 196920},
	{26119, 196928, 2, 1633},
	{26132, 196932},
	{26145, 196936},
	{26168, 196940},
	{26191, 196944},
	{26219, 196948},
	{26247, 196952},
	{26275, 196956},
	{26303, 196960, 1, 1635},
	{26321, 196964, 4, 6157},
	{58974, 196968},
	{58992, 196972},
	{59019, 196976},
	{26402, 196980},
	{26421, 196984},
	{26440, 196988},
	{26464, 196992},
	{26488, 196996},
	{26512, 197000},
	{26536, 197028, 1, 1640},
	{26554, 197032, 2, 6161},
	{26572, 197036},
	{26590, 197040},
	{26608, 197044, 1, 1643},
	{26626, 197048, 2, 6163},
	{26644, 197052},
	{26662, 197056, 2, 1646},
	{26681, 197060, 5, 1648},
	{26700, 197072},
	{26724, 197076, 2, 1646},
	{26744, 197080, 5, 1648},
	{26764, 197084, 5, 6165},
	{26783, 197088, 5, 6165},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 13, 1662},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 2, 1675},
	{26897, 197120},
	{26916, 197124, 1, 1677},
	{26938, 197128},
	{26957, 197132, 1, 1678},
	{26979, 197136, 7, 1679},
	{26997, 197140},
	{27017, 197144, 1, 1677},
	{27040, 197148},
	{27060, 197152, 1, 1678},
	{27083, 197156, 7, 1679},
	{27102, 197160, 6, 6170},
	{27114, 197164, 2, 1693},
	{27131, 197168, 1, 1695},
	{27148, 197172, 1, 1696},
	{27166, 197176, 4, 1697},
	{27186, 197180, 1, 1701},
	{27203, 197184},
	{27219, 197188, 1, 1703},
	{27232, 197192, 1, 1704},
	{27246, 197196, 1, 1705},
	{27260, 197200, 1, 1706},
	{27282, 197204, 1, 1707},
	{27302, 197208, 1, 1708},
	{27324, 197212, 1, 1709},
	{27344, 197216, 1, 1704},
	{27361, 197220, 1, 1705},
	{27378, 197224},
	{56934, 197228, 1, 1703},
	{27526, 197364, 1, 1714},
	{27547, 197368, 1, 1715},
	{27567, 197372, 1, 1716},
	{27587, 197376, 1, 1715},
	{27604, 197380, 1, 1716},
	{27621, 197384, 1, 1717},
	{27637, 197388, 1, 1718},
	{27656, 197392, 1, 1719},
	{27675, 197396, 1, 1720},
	{27692, 197400, 1, 1721},
	{27710, 197404, 1, 1722},
	{27728, 197408, 1, 1723},
	{27744, 197412, 1, 1724},
	{27762, 197416, 1, 1725},
	{27780, 197420, 1, 1726},
	{27796, 197424, 1, 1721},
	{27811, 197428, 1, 1722},
	{27826, 197432, 1, 1723},
	{27839, 197436, 1, 1724},
	{27854, 197440, 1, 1725},
	{27869, 197444, 1, 1726},
	{27882, 197448, 1, 1727},
	{27896, 197452, 1, 1728},
	{27910, 197456, 1, 1729},
	{27922, 197460, 4, 6176},
	{27945, 197464, 3, 1734},
	{27967, 197468, 1, 1737},
	{28111, 197552, 1, 1742},
	{28136, 197556, 1, 1742},
	{28160, 197560, 1, 1743},
	{28180, 197568},
	{28206, 197572, 1, 1625},
	{28235, 197576},
	{28260, 197580, 1, 1625},
	{28288, 197584},
	{28311, 197588, 1, 1625},
	{28337, 197592},
	{28359, 197596, 1, 1625},
	{28384, 197600},
	{28403, 197604, 1, 1625},
	{28425, 197608, 1, 1340},
	{28439, 197612},
	{28456, 197616, 1, 1625},
	{28476, 197620, 8, 1744},
	{28493, 197624, 13, 1752},
	{28510, 197628},
	{28527, 197632, 1, 1695},
	{28547, 197636},
	{28564, 197640, 1, 1660},
	{28584, 197644, 2, 1765},
	{28603, 197888, 8, 6180},
	{28624, 197892, 8, 6180},
	{28645, 198656, 6, 4020},
	{28679, 198916},
	{28698, 198920, 1, 1781},
	{28717, 198924, 2, 6188},
	{28732, 198928},
	{28765, 198932},
	{28798, 198936},
	{28831, 198940},
	{14132, 198944},
	{14149, 198948},
	{14166, 198952},
	{19307, 198956, 2, 1354},
	{28921, 198960},
	{28937, 198964},
	{28955, 198968, 1, 1782},
	{28972, 198972, 2, 1783},
	{28993, 198976},
	{29287, 198980, 1, 827},
	{29031, 198984},
	{29047, 198988, 1, 827},
	{29066, 198992},
	{29086, 198996, 1, 827},
	{29109, 199000},
	{29127, 199004, 1, 827},
	{19406, 199008, 9, 1785},
	{29189, 199016},
	{29325, 199168, 1, 1806},
	{29350, 199172, 2, 1807},
	{29375, 199184, 2, 1809},
	{29401, 199188, 2, 1809},
	{29427, 199192, 2, 1809},
	{29453, 199212, 2, 1809},
	{29479, 199296, 2, 1811},
	{29507, 199300, 1, 1813},
	{29531, 199304, 1, 1814},
	{29555, 199308, 1, 1815},
	{29588, 199312, 1, 1815},
	{29616, 199328, 2, 1811},
	{29645, 199332, 1, 1813},
	{29670, 199336, 1, 1814},
	{29695, 199340, 1, 1815},
	{29729, 199344, 1, 1815},
	{29758, 199360, 2, 1811},
	{29782, 199364, 1, 1813},
	{29802, 199368, 1, 1814},
	{29822, 199372, 1, 1815},
	{29851, 199376, 1, 1815},
	{18601, 199380},
	{53736, 199872},
	{53757, 199876, 1, 4580},
	{2431, 199880, 7, 5134},
	{2452, 199884, 3, 4589},
	{53778, 199888, 2, 4592},
	{2479, 199892, 1, 4616},
	{53804, 199896, 15, 6190},
	{54807, 199900, 1, 5143},
	{54829, 199904},
	{2410, 199908, 2, 4594},
	{2500, 199912, 6, 6205},
	{53846, 199916, 1, 4617},
	{53825, 199920},
	{29875, 199936},
	{29902, 199940},
	{29929, 199944},
	{29956, 199948},
	{30091, 199968, 6, 1816},
	{30102, 199972, 2, 1823},
	{30116, 200192},
	{30135, 200196, 1, 837},
	{30157, 200448},
	{30181, 200452, 1, 1825},
	{30204, 200456},
	{30228, 200460, 1, 1825},
	{30251, 200464},
	{30275, 200468, 1, 1825},
	{30298, 200472},
	{30322, 200476, 1, 1825},
	{30345, 200696},
	{30364, 200700, 1, 1825},
	{30382, 200704},
	{30394, 200708},
	{30406, 200712},
	{30424, 200716},
	{30443, 200720},
	{30461, 200724},
	{30473, 200728},
	{30485, 200732},
	{30503, 200736},
	{30521, 200740},
	{30540, 200744, 4, 1826},
	{30554, 200748, 2, 1830},
	{30572, 200752, 2, 1832},
	{30586, 200756, 2, 1834},
	{30600, 200760, 2, 1836},
	{30617, 200764, 2, 1838},
	{30634, 200768},
	{30647, 200772, 2, 1840},
	{30659, 200776},
	{30673, 200780},
	{30689, 200784},
	{30703, 200788},
	{30719, 200792},
	{30734, 200796},
	{30751, 200800},
	{30766, 200804},
	{30783, 200808, 2, 1842},
	{30805, 200812, 10, 6211},
	{30822, 200816, 2, 1854},
	{30843, 200820, 2, 1856},
	{30855, 200824},
	{30870, 200828, 6, 5577},
	{30885, 200832, 2, 1864},
	{30899, 200836},
	{2831, 200960, 9, 426},
	{48825, 200964, 11, 6221},
	{48843, 200968, 2, 3472},
	{48861, 200972, 4, 6232},
	{31012, 212992},
	{31032, 212996},
	{31052, 213000},
	{31072, 213004},
	{31092, 213008},
	{31112, 213012},
	{31132, 213016},
	{31152, 213020},
	{31172, 213024},
	{31192, 213028},
	{31212, 213032},
	{31232, 213036},
	{31252, 213040},
	{31275, 213044},
	{31298, 213048},
	{31321, 213248},
	{31342, 213252},
	{31363, 213260},
	{31384, 213264},
	{31405, 213268},
	{31429, 213272},
	{31453, 213276},
	{31477, 213280},
	{31501, 213284},
	{31525, 213288},
	{31549, 213292},
	{31573, 213296},
	{54919, 213504},
	{54938, 213508},
	{54957, 213512},
	{54976, 213516},
	{54995, 213520},
	{55014, 213524},
	{55033, 213528},
	{55052, 213532},
	{52409, 213536},
	{52428, 213540},
	{52447, 213544},
	{52466, 213548},
	{52485, 213552},
	{52504, 213556},
	{52523, 213560},
	{52542, 213564},
	{52962, 213568},
	{52982, 213572},
	{53002, 213576},
	{53022, 213580},
	{53042, 213584},
	{53062, 213588},
	{53082, 213592},
	{53102, 213596},
	{32057, 214016},
	{32079, 214020, 1, 1866},
	{32101, 214024},
	{32123, 214028, 1, 1866},
	{32145, 214032},
	{32167, 214036, 1, 1866},
	{32189, 214040},
	{32211, 214044, 1, 1866},
	{32233, 214272},
	{32255, 214276},
	{32277, 214280},
	{32299, 214284},
	{32321, 214288},
	{32343, 214292},
	{32365, 214296},
	{32387, 214300},
	{32409, 214304},
	{32431, 214308},
	{32453, 214312},
	{32475, 214316},
	{32497, 214320},
	{32519, 214324},
	{32541, 214328},
	{32563, 214332},
	{32585, 214528},
	{32605, 214532},
	{32625, 214536},
	{32645, 214540},
	{32665, 214544},
	{32685, 214548},
	{32705, 214552},
	{32725, 214556},
	{32745, 214560},
	{32765, 214564},
	{32785, 214568},
	{32805, 214572},
	{32825, 214784},
	{32844, 214788},
	{32863, 214792},
	{32882, 214796},
	{32901, 214800},
	{32920, 214804},
	{32939, 214808},
	{32958, 214812},
	{32977, 214816},
	{32996, 214820},
	{33015, 214824},
	{33034, 214828},
	{33053, 214832},
	{33072, 214836},
	{33091, 214840},
	{33110, 214844},
	{33129, 214848},
	{33148, 214852},
	{33167, 214856},
	{33186, 214860},
	{33205, 214864},
	{33225, 214868},
	{33245, 214872},
	{33265, 214876},
	{33285, 214880},
	{33305, 214884},
	{33325, 214888},
	{33345, 214892},
	{33365, 214896},
	{33385, 214900},
	{33405, 214904},
	{33425, 214908},
	{33445, 215296},
	{33464, 215300},
	{33483, 215304},
	{33502, 215308},
	{33521, 215312},
	{33540, 215316},
	{33559, 215320},
	{33578, 215324},
	{33639, 215552},
	{33659, 215556},
	{33679, 215560},
	{33699, 215564},
	{33719, 215568},
	{33739, 215572},
	{33759, 215576},
	{33779, 215580},
	{33799, 215808},
	{33818, 215812},
	{33837, 215816},
	{33856, 215820},
	{33875, 216064},
	{33894, 216068},
	{33913, 216072},
	{33932, 216076},
	{33951, 216320},
	{33971, 216324},
	{33991, 216328},
	{34011, 216332},
	{34031, 216336},
	{34051, 216340},
	{34071, 216344},
	{34091, 216348},
	{55071, 216576},
	{55091, 216580},
	{55111, 216584},
	{55131, 216588},
	{55151, 216592},
	{55171, 216596},
	{55191, 216600},
	{55211, 216604},
	{55231, 216640},
	{55251, 216644},
	{55271, 216648},
	{55291, 216652},
	{55311, 216656},
	{55331, 216660},
	{55351, 216664},
	{55371, 216668},
	{34943, 217112},
	{34962, 217116},
	{34981, 217120},
	{35000, 217124},
	{35019, 217128},
	{35038, 217132},
	{35057, 217136},
	{35076, 217140},
	{35095, 217344},
	{35114, 217348},
	{35133, 217352},
	{35152, 217356},
	{35171, 217360},
	{35190, 217364},
	{35209, 217368},
	{35228, 217372},
	{35247, 217600},
	{35267, 217604},
	{35287, 217608},
	{35307, 217612},
	{35327, 217856},
	{35347, 217860},
	{35367, 217864},
	{35387, 217868},
	{35407, 217872},
	{35427, 217876},
	{35447, 217880},
	{35467, 217884},
	{35490, 218112},
	{35515, 218116, 2, 1867},
	{35539, 218144},
	{35565, 218148, 2, 1867},
	{36629, 221184, 5, 6236},
	{36653, 221188, 4, 6241},
	{36678, 221192, 5, 6236},
	{36702, 221196, 5, 6236},
	{36726, 221200, 4, 6241},
	{36751, 221204, 5, 6236},
	{36775, 221208, 4, 6241},
	{36800, 221212, 5, 6236},
	{36824, 221216, 4, 1878},
	{36840, 221220, 5, 6236},
	{36864, 221224, 3, 1882},
	{36898, 221228, 3, 1885},
	{36932, 221232, 3, 1888},
	{36957, 221236, 3, 1891},
	{36982, 221240, 3, 6245},
	{37007, 221248},
	{37022, 221252, 1, 1815},
	{37045, 221256},
	{37068, 221260},
	{37086, 221264, 2, 1894},
	{37104, 221268, 4, 1896},
	{37124, 221440, 22, 6248},
	{37149, 221444, 22, 6248},
	{37174, 221448, 13, 6270},
	{37202, 221452, 13, 6270},
	{37230, 221456, 13, 6270},
	{37258, 221460, 13, 6270},
	{55551, 221696, 2, 4361},
	{55574, 221700, 2, 4361},
	{55597, 221704, 2, 4361},
	{55620, 221708, 2, 4361},
	{52317, 221712, 5, 1954},
	{52340, 221716, 2, 4361},
	{52363, 221720, 2, 4361},
	{52386, 221724, 2, 4361},
	{55643, 221728, 4, 1959},
	{52866, 221744, 5, 1954},
	{52890, 221748, 5, 1954},
	{52914, 221752, 2, 4361},
	{52938, 221756, 2, 4361},
	{55667, 221760, 4, 1959},
	{55692, 221764, 4, 1959},
	{52840, 221776, 1, 4402},
	{37716, 222208, 5, 1954},
	{37742, 222212, 4, 1959},
	{37769, 222216, 5, 1954},
	{37795, 222220, 4, 1959},
	{37822, 222224, 3, 2010},
	{37875, 222228, 3, 2010},
	{37928, 222464, 5, 1954},
	{37954, 222468, 4, 1959},
	{37981, 222472, 1, 1869},
	{38007, 222476, 1, 1869},
	{38033, 222480, 1, 1869},
	{38059, 222484, 1, 1869},
	{38085, 222488, 1, 1869},
	{38111, 222492, 1, 1869},
	{38137, 222496, 1, 1869},
	{38163, 222720, 5, 1954},
	{38187, 222724, 5, 1954},
	{38211, 222728, 5, 1954},
	{38235, 222732, 5, 1954},
	{38259, 222736, 4, 1959},
	{38284, 222740, 4, 1959},
	{38309, 222744, 4, 1959},
	{38334, 222748, 4, 1959},
	{38359, 222752, 1, 1998},
	{38383, 222756, 1, 1998},
	{38407, 222760, 8, 1963},
	{38428, 222976, 6, 4560},
	{38451, 222980, 6, 4560},
	{38474, 222984, 6, 4560},
	{38497, 222988, 6, 4560},
	{38520, 222992, 6, 4560},
	{38543, 222996, 6, 4560},
	{38566, 223000, 6, 4560},
	{38589, 223004, 6, 4560},
	{38612, 223008, 6, 4560},
	{38635, 223012, 6, 4560},
	{38658, 223016, 6, 4560},
	{38682, 223020, 6, 4560},
	{38706, 223024, 6, 4560},
	{38730, 223028, 6, 4560},
	{38754, 223032, 6, 4560},
	{38778, 223036, 6, 4560},
	{38802, 223104, 9, 4543},
	{55717, 223108, 2, 4592},
	{38822, 223112, 1, 1984},
	{38917, 223488, 5, 1954},
	{38940, 223492, 5, 1954},
	{38963, 223496, 3, 2010},
	{38986, 223500, 3, 2010},
	{39009, 223504, 4, 1959},
	{39033, 223508, 4, 1959},
	{39057, 223744, 5, 1954},
	{39081, 223748, 5, 1954},
	{39105, 223752, 5, 1954},
	{39129, 223756, 5, 1954},
	{39153, 223760, 4, 1959},
	{39178, 224000, 5, 1998},
	{39201, 224004, 4, 2003},
	{39225, 224008, 3, 2007},
	{39248, 224256, 5, 1998},
	{39271, 224260, 4, 2003},
	{39295, 224264, 3, 2007},
	{39318, 224512, 5, 1954},
	{39342, 224516, 4, 1959},
	{39367, 224520, 5, 1954},
	{39391, 224524, 4, 1959},
	{39416, 224528, 3, 2010},
	{39440, 224532, 3, 2010},
	{55737, 224768, 5, 1954},
	{55761, 224772, 4, 1948},
	{55786, 224776, 5, 1954},
	{55810, 224780, 4, 1948},
	{55835, 224784, 3, 2010},
	{55859, 224788, 3, 2010},
	{55883, 224832, 5, 1954},
	{55907, 224836, 4, 1948},
	{55932, 224840, 5, 1954},
	{55956, 224844, 4, 1948},
	{55981, 224848, 3, 2010},
	{56005, 224852, 3, 2010},
	{40141, 225280, 12, 2013},
	{40163, 225284, 5, 2025},
	{40186, 225288, 4, 2030},
	{40210, 225292, 2, 2034},
	{40233, 225296, 2, 2034},
	{40256, 225300, 2, 2034},
	{40279, 225536, 5, 1954},
	{40302, 225540, 4, 1959},
	{40326, 225544, 5, 1954},
	{40349, 225548, 4, 1959},
	{40373, 225552, 5, 1954},
	{40396, 225560, 5, 1954},
	{40419, 225792, 4, 2036},
	{40440, 225796},
	{40469, 225800, 2, 2040},
	{40498, 225804},
	{40524, 225808, 7, 2042},
	{40598, 225812},
	{40621, 225816},
	{56150, 225820, 2, 5194},
	{56183, 225824, 2, 5194},
	{56216, 225828, 2, 5194},
	{56249, 225832, 2, 5194},
	{56281, 225836, 2, 5194},
	{56313, 225840, 2, 5194},
	{56345, 225844, 2, 5194},
	{56378, 225848, 2, 5194},
	{56410, 225856, 2, 5194},
	{56442, 225860, 2, 5194},
	{56475, 225864, 2, 5194},
	{56508, 225868, 2, 5194},
	{56541, 225872, 2, 5194},
	{56573, 225876, 2, 5194},
	{56605, 225880, 2, 5194},
	{56638, 225884, 2, 5194},
	{56671, 225888, 2, 5194},
	{56737, 225896, 2, 5194},
	{40644, 225900},
	{40671, 225904},
	{40553, 225908},
	{40572, 225912},
	{59046, 225932, 2, 5194},
	{59079, 225936, 2, 6283},
	{41562, 226040, 1, 2126},
	{41541, 226044, 1, 2126},
	{41334, 226048, 2, 2116},
	{41351, 226052, 1, 2118},
	{41375, 226056, 1, 2118},
	{41399, 226060, 4, 2119},
	{41425, 226064, 3, 2123},
	{41454, 226068, 1, 684},
	{41483, 226072, 3, 2123},
	{41512, 226076, 1, 684},
	{41589, 226304, 5, 2025},
	{41613, 226308, 4, 2030},
	{41638, 226312, 2, 2034},
	{41662, 226316, 5, 2025},
	{41686, 226320, 4, 2030},
	{41711, 226324, 2, 2034},
	{41735, 226328, 10, 2127},
	{41760, 226560, 5, 2137},
	{41787, 226564, 5, 2137},
	{41814, 226568, 6, 2142},
	{41845, 226608, 5, 2137},
	{41873, 226612, 5, 2137},
	{41901, 226616, 5, 2137},
	{41929, 226620, 5, 2137},
	{41957, 226624, 5, 2137},
	{41985, 226628, 5, 2137},
	{42013, 226632, 5, 2137},
	{42041, 226636, 5, 2137},
	{42069, 226640, 6, 2142},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 2162},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 7, 2168},
	{43221, 1281, 6, 2187},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
};

static const struct si_reg gfx940_reg_table[] = {
	{43272, 40},
	{1310, 68, 14, 5623},
	{1323, 72, 25, 6285},
	{1338, 76, 11, 6310},
	{51139, 80, 11, 6321},
	{1375, 84, 5, 6332},
	{1393, 88, 2, 3878},
	{1411, 92, 7, 5667},
	{1426, 96},
	{1440, 100, 1, 70},
	{1454, 104},
	{51153, 108},
	{51170, 112, 13, 5674},
	{1471, 116, 7, 5687},
	{1487, 120},
	{1609, 2480},
	{1623, 2484},
	{1637, 2488},
	{1651, 2492},
	{1665, 2496},
	{1679, 2500},
	{1693, 2504},
	{1707, 2508},
	{1721, 2512},
	{1735, 2516},
	{1749, 2520},
	{1764, 2524},
	{1779, 2528},
	{1794, 2532},
	{1809, 2536},
	{1824, 2540},
	{1839, 2544},
	{1850, 2552},
	{1866, 2556},
	{1954, 32776, 27, 6337},
	{1967, 32784, 24, 5719},
	{1979, 32788, 12, 5743},
	{1995, 32792, 12, 5743},
	{2024, 32824, 12, 5743},
	{2040, 32828, 12, 5743},
	{47257, 33280, 4, 6364},
	{59112, 33288, 3, 6368},
	{2056, 33296, 16, 5755},
	{2070, 33300, 28, 204},
	{2087, 33304, 14, 232},
	{2108, 33308, 21, 5771},
	{2122, 33312, 31, 5096},
	{2139, 33316, 11, 307},
	{2178, 33324, 1, 329},
	{43317, 33328, 4, 6371},
	{2201, 33344, 1, 6375},
	{2222, 33348},
	{2242, 33352, 1, 332},
	{2283, 33436, 1, 342},
	{53736, 36032},
	{53757, 36036, 1, 4580},
	{2431, 36040, 7, 5134},
	{2452, 36044, 3, 4589},
	{53778, 36048, 2, 4592},
	{2479, 36052, 1, 4616},
	{53804, 36056, 15, 6190},
	{54807, 36060, 1, 5143},
	{54829, 36064},
	{2410, 36068, 2, 4594},
	{2500, 36072, 6, 6205},
	{53846, 36076, 1, 4617},
	{53825, 36080},
	{29875, 36096},
	{29902, 36100},
	{29929, 36104},
	{29956, 36108},
	{2687, 36608},
	{2705, 36612, 4, 383},
	{2723, 36616},
	{2741, 36620, 12, 5792},
	{3642, 36624},
	{3660, 36628, 6, 6376},
	{3678, 36632, 3, 4661},
	{3696, 36636, 8, 5812},
	{3714, 36640, 3, 5820},
	{3732, 36644, 7, 5823},
	{3750, 36648, 8, 5364},
	{3768, 36652},
	{2759, 36656, 14, 5372},
	{2777, 36660, 4, 411},
	{2795, 36664, 10, 5830},
	{2813, 36668, 3, 5840},
	{2831, 37120, 9, 426},
	{2847, 39160, 13, 5843},
	{2862, 39184, 5, 4719},
	{2876, 39188, 5, 4719},
	{2890, 39192, 5, 4719},
	{2904, 39196, 5, 4719},
	{2918, 39200, 5, 4719},
	{2932, 39204, 5, 4719},
	{2946, 39208, 5, 4719},
	{2960, 39212, 5, 4719},
	{2974, 39216, 5, 4719},
	{2988, 39220, 5, 4719},
	{3002, 39224, 5, 4719},
	{3017, 39228, 5, 4719},
	{3032, 39232, 5, 4719},
	{3047, 39236, 5, 4719},
	{3062, 39240, 5, 4719},
	{3077, 39244, 5, 4719},
	{3092, 39248, 5, 4719},
	{3107, 39252, 5, 4719},
	{3122, 39256, 5, 4719},
	{3137, 39260, 5, 4719},
	{3152, 39264, 5, 4719},
	{3167, 39268, 5, 4719},
	{3182, 39272, 5, 4719},
	{3197, 39276, 5, 4719},
	{3212, 39280, 5, 4719},
	{3227, 39284, 5, 4719},
	{3242, 39288, 5, 4719},
	{3257, 39292, 5, 4719},
	{3272, 39296, 5, 4719},
	{3287, 39300, 5, 4719},
	{3302, 39304, 5, 4719},
	{3317, 39308, 5, 4719},
	{3332, 39312, 4, 445},
	{3351, 39316, 4, 445},
	{3370, 39320, 4, 445},
	{3389, 39324, 4, 445},
	{3408, 39328, 4, 445},
	{3427, 39332, 4, 445},
	{3446, 39336, 4, 445},
	{3465, 39340, 4, 445},
	{3484, 39344, 4, 445},
	{3503, 39348, 4, 445},
	{3522, 39352, 4, 445},
	{3542, 39356, 4, 445},
	{3562, 39360, 4, 445},
	{3582, 39364, 4, 445},
	{3602, 39368, 4, 445},
	{3622, 39372, 4, 445},
	{3835, 45084, 4, 5856},
	{3859, 45088},
	{3880, 45092, 1, 488},
	{3901, 45096, 11, 5860},
	{3925, 45100, 10, 5871},
	{3949, 45104},
	{3975, 45108},
	{4001, 45112},
	{4027, 45116},
	{4053, 45120},
	{4079, 45124},
	{4105, 45128},
	{4131, 45132},
	{4157, 45136},
	{4183, 45140},
	{4209, 45144},
	{4236, 45148},
	{4263, 45152},
	{4290, 45156},
	{4317, 45160},
	{4344, 45164},
	{4371, 45168},
	{4398, 45172},
	{4425, 45176},
	{4452, 45180},
	{4479, 45184},
	{4506, 45188},
	{4533, 45192},
	{4560, 45196},
	{4587, 45200},
	{4614, 45204},
	{4641, 45208},
	{4668, 45212},
	{4695, 45216},
	{4722, 45220},
	{4749, 45224},
	{4776, 45228},
	{5016, 45336, 4, 5856},
	{5040, 45340, 1, 524},
	{5065, 45344},
	{5086, 45348, 1, 488},
	{5107, 45352, 12, 5881},
	{5131, 45356, 14, 5893},
	{5155, 45360},
	{5181, 45364},
	{5207, 45368},
	{5233, 45372},
	{5259, 45376},
	{5285, 45380},
	{5311, 45384},
	{5337, 45388},
	{5363, 45392},
	{5389, 45396},
	{5415, 45400},
	{5442, 45404},
	{5469, 45408},
	{5496, 45412},
	{5523, 45416},
	{5550, 45420},
	{5577, 45424},
	{5604, 45428},
	{5631, 45432},
	{5658, 45436},
	{5685, 45440},
	{5712, 45444},
	{5739, 45448},
	{5766, 45452},
	{5793, 45456},
	{5820, 45460},
	{5847, 45464},
	{5874, 45468},
	{5901, 45472},
	{5928, 45476},
	{5955, 45480},
	{5982, 45484},
	{6173, 45552, 9, 551},
	{6279, 45572, 2, 5907},
	{6303, 45576},
	{6335, 45580},
	{7610, 45584},
	{7631, 45588, 1, 488},
	{6415, 45596, 4, 5856},
	{6439, 45600},
	{6460, 45604, 1, 488},
	{6481, 45608, 12, 5909},
	{6505, 45612, 9, 5921},
	{7700, 45872},
	{7726, 45876},
	{7752, 45880},
	{7778, 45884},
	{7804, 45888},
	{7830, 45892},
	{7856, 45896},
	{7882, 45900},
	{7908, 45904},
	{7934, 45908},
	{7960, 45912},
	{7987, 45916},
	{8014, 45920},
	{8041, 45924},
	{8068, 45928},
	{8095, 45932},
	{56950, 45936},
	{56977, 45940},
	{57004, 45944},
	{57031, 45948},
	{57058, 45952},
	{57085, 45956},
	{57112, 45960},
	{57139, 45964},
	{57166, 45968},
	{57193, 45972},
	{57220, 45976},
	{57247, 45980},
	{57274, 45984},
	{57301, 45988},
	{57328, 45992},
	{57355, 45996},
	{8174, 46084, 1, 5907},
	{8198, 46088},
	{8230, 46092},
	{9505, 46096},
	{9526, 46100, 1, 488},
	{8310, 46108, 4, 5930},
	{8334, 46112},
	{8355, 46116, 1, 488},
	{8376, 46120, 11, 5934},
	{8400, 46124, 7, 5945},
	{9595, 46128},
	{9621, 46132},
	{9647, 46136},
	{9673, 46140},
	{9699, 46144},
	{9725, 46148},
	{9751, 46152},
	{9777, 46156},
	{9803, 46160},
	{9829, 46164},
	{9855, 46168},
	{9882, 46172},
	{9909, 46176},
	{9936, 46180},
	{9963, 46184},
	{9990, 46188},
	{57382, 46192},
	{57409, 46196},
	{57436, 46200},
	{57463, 46204},
	{57490, 46208},
	{57517, 46212},
	{57544, 46216},
	{57571, 46220},
	{57598, 46224},
	{57625, 46228},
	{57652, 46232},
	{57679, 46236},
	{57706, 46240},
	{57733, 46244},
	{57760, 46248},
	{57787, 46252},
	{57814, 46384},
	{57844, 46388},
	{57874, 46392},
	{57904, 46396},
	{57934, 46400},
	{57964, 46404},
	{57994, 46408},
	{58024, 46412},
	{58054, 46416},
	{58084, 46420},
	{58114, 46424},
	{58145, 46428},
	{58176, 46432},
	{58207, 46436},
	{58238, 46440},
	{58269, 46444},
	{58300, 46448},
	{58331, 46452},
	{58362, 46456},
	{58393, 46460},
	{58424, 46464},
	{58455, 46468},
	{58486, 46472},
	{58517, 46476},
	{58548, 46480},
	{58579, 46484},
	{58610, 46488},
	{58641, 46492},
	{58672, 46496},
	{58703, 46500},
	{58734, 46504},
	{58765, 46508},
	{10017, 47104, 11, 5952},
	{10044, 47108},
	{10058, 47112},
	{10072, 47116},
	{10086, 47120},
	{10102, 47124},
	{10118, 47128},
	{10134, 47132, 2, 656},
	{10155, 47136, 2, 656},
	{10176, 47140, 2, 656},
	{10197, 47144, 1, 658},
	{10225, 47148, 1, 659},
	{10250, 47152},
	{10265, 47156, 1, 660},
	{10280, 47160},
	{10309, 47164, 1, 660},
	{10338, 47168},
	{10371, 47172, 1, 660},
	{10404, 47176, 11, 5963},
	{10422, 47180, 12, 5974},
	{10440, 47184, 1, 684},
	{10453, 47188, 7, 5986},
	{54643, 47192, 2, 4848},
	{54674, 47196, 2, 4848},
	{10531, 47200, 2, 691},
	{54857, 47204, 2, 4848},
	{54888, 47208, 2, 4848},
	{10606, 47212},
	{10624, 47216},
	{10642, 47220},
	{10660, 47224, 1, 693},
	{10688, 47228, 2, 6382},
	{10710, 47232},
	{10730, 47236},
	{10913, 47240, 3, 710},
	{10930, 47244},
	{10959, 47248, 1, 713},
	{59130, 47260, 1, 6384},
	{10891, 47280},
	{10854, 47284, 4, 6385},
	{11006, 47360},
	{11026, 47364},
	{11046, 47368},
	{11066, 47372},
	{11086, 47376},
	{11106, 47380},
	{11126, 47384},
	{11146, 47388},
	{11166, 47392},
	{11186, 47396},
	{11206, 47400},
	{11227, 47404},
	{11248, 47408},
	{11269, 47412},
	{11290, 47416},
	{11311, 47420},
	{11356, 47608},
	{11377, 47612},
	{26801, 197092, 1, 1660},
	{26818, 197100, 1, 1661},
	{26839, 197104, 13, 1662},
	{26853, 197108},
	{26867, 197112},
	{26881, 197116, 2, 1675},
	{27131, 197168, 1, 1695},
	{206, 880, 4, 2153},
	{43120, 881},
	{26967, 882},
	{43132, 1008},
	{43143, 1009},
	{27155, 1010, 4, 2157},
	{43154, 1040, 1, 2161},
	{43167, 1041, 5, 2162},
	{43180, 1042, 1, 2167},
	{43193, 1043, 1, 1678},
	{26989, 1045, 7, 2168},
	{43221, 1281, 6, 2187},
	{43236, 1282},
	{26926, 1283},
	{43120, 1285},
	{26967, 1286},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{59152, 0xF},
	{59161, 0xF0},
	{59171, 0x100},
	{59182, 0x200},
	{59187, 0x400},
	{59314, 0x1FF000, 257, 0},
	{59322, 0x800000},
	{59332, 0x8000000},
	{59345, 0x10000000},
	{59351, 0xE0000000},
	/* 10 */
	{59355, 0x1},
	{59359, 0x6},
	{59368, 0x18},
	{59378, 0x20},
	{59383, 0x40},
	{59391, 0x80},
	{59401, 0x100},
	{59412, 0x200},
	{59418, 0x400},
	{59423, 0x800},
	{59429, 0x1000},
	{59440, 0x2000},
	{59445, 0x4000},
	{59450, 0x8000},
	{59201, 0x10000},
	{59465, 0x20000},
	{59473, 0x40000},
	{59485, 0x80000},
	{59493, 0x800000},
	{59504, 0x8000000},
	/* 30 */
	{59516, 0x1FF, 257, 0},
	{59521, 0x400},
	{59529, 0x800},
	{59542, 0x7000},
	{59550, 0x8000},
	{59561, 0xF0000},
	{59572, 0xF00000},
	{59588, 0x1000000},
	{59602, 0x10000000},
	{59614, 0xE0000000},
	/* 40 */
	{54575, 0xF},
	{59622, 0x30},
	{59630, 0xC0},
	{59638, 0xF00},
	{59644, 0x1000},
	{29204, 0x6000},
	{59650, 0x8000},
	{59662, 0xF0000},
	{59668, 0xF00000},
	{59674, 0x7000000},
	{59683, 0x38000000},
	{59692, 0xC0000000},
	/* 52 */
	{59698, 0xFF},
	{59708, 0xFF00},
	{59718, 0xFF0000},
	{59728, 0xF000000},
	/* 56 */
	{59738, 0x1FF},
	{59747, 0x1FF000},
	{59756, 0xF000000},
	/* 59 */
	{59773, 0xF},
	{59780, 0x70},
	{59788, 0x80},
	{59802, 0xF00},
	{59811, 0x7000},
	{59820, 0x8000},
	{59833, 0x3F0000},
	{59838, 0xC00000},
	{59848, 0x1000000},
	{59862, 0x2000000},
	{59874, 0xFC000000},
	/* 70 */
	{1448, 0xFFFF},
	/* 71 */
	{59602, 0x1},
	{59881, 0x2},
	{59887, 0x4},
	{59901, 0x8},
	{59916, 0x3F0},
	{59921, 0x1F800},
	{59833, 0xFC0000},
	{59926, 0x1000000},
	{59936, 0xFE000000},
	/* 80 */
	{54575, 0x1F},
	{59622, 0x300},
	{59945, 0x3C00},
	{59952, 0x10000},
	{29204, 0xC0000},
	/* 85 */
	{59674, 0xF},
	{59630, 0x30},
	{59692, 0x300},
	{59683, 0x7000},
	{59958, 0x1F0000},
	{59668, 0xF000000},
	{59964, 0x60000000},
	/* 92 */
	{59977, 0x1},
	{59985, 0x6},
	/* 94 */
	{60000, 0x3},
	/* 95 */
	{30668, 0x3F},
	{10417, 0xFC0},
	{10435, 0x3F000},
	{30643, 0xFC0000},
	/* 99 */
	{60009, 0x3},
	{60023, 0x80},
	{60041, 0x300},
	{60051, 0x400},
	{60064, 0x800},
	{59593, 0x1000},
	{60071, 0x2000},
	/* 106 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60310, 0x4000},
	{60325, 0x8000},
	{60336, 0x10000},
	{60344, 0x20000},
	{60353, 0x40000},
	{60370, 0x80000},
	{60385, 0x100000},
	{60398, 0x200000},
	{60408, 0x400000},
	{60425, 0x800000},
	{60442, 0x1000000},
	{60451, 0x2000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	{60487, 0x80000000},
	/* 133 */
	{60498, 0xF},
	{60521, 0x20},
	{60537, 0x80},
	{60560, 0x100},
	{60583, 0x200},
	{60602, 0x1000},
	{60611, 0x2000},
	{60620, 0x4000},
	{60628, 0x8000},
	{60637, 0x10000},
	{60652, 0x100000},
	{60660, 0x200000},
	{60668, 0x400000},
	{60677, 0x800000},
	{60686, 0x1000000},
	{60694, 0x2000000},
	{60702, 0x4000000},
	{60710, 0x10000000},
	{60452, 0x20000000},
	{60728, 0x40000000},
	{60736, 0x80000000},
	/* 154 */
	{60602, 0x2},
	{60611, 0x4},
	{60747, 0x8},
	{60451, 0x10},
	{60758, 0x20},
	{60344, 0x200000},
	{60677, 0x400000},
	{60694, 0x1000000},
	{60620, 0x2000000},
	{60652, 0x4000000},
	{60668, 0x8000000},
	{60686, 0x20000000},
	{60702, 0x40000000},
	{60728, 0x80000000},
	/* 168 */
	{60769, 0x20},
	{60798, 0x40},
	{60829, 0x80},
	{60858, 0x100},
	{60878, 0x200},
	{60898, 0x400},
	{60918, 0x800},
	{60938, 0x2000},
	{60946, 0x4000},
	{60954, 0x8000},
	{60758, 0x10000},
	{60965, 0x10000000},
	{60979, 0x20000000},
	{60747, 0x40000000},
	{60988, 0x80000000},
	/* 183 */
	{60997, 0x1},
	{61007, 0x2},
	{61017, 0x4},
	{61026, 0x8},
	{61035, 0x10},
	{61046, 0x20},
	{61057, 0x40},
	{61067, 0x80},
	{61077, 0x400},
	{61087, 0x800},
	{61104, 0x1000},
	{61112, 0x2000},
	{61125, 0x4000},
	{61143, 0x8000},
	{61154, 0x10000},
	{61163, 0x20000},
	{61184, 0x40000},
	{61195, 0x80000},
	{61222, 0x20000000},
	{61235, 0x40000000},
	{60469, 0x80000000},
	/* 204 */
	{61248, 0x1},
	{61263, 0x2},
	{61283, 0x4},
	{61299, 0x8},
	{61317, 0x10},
	{61337, 0x20},
	{61356, 0x40},
	{61375, 0x80},
	{61388, 0x100},
	{61402, 0x200},
	{61426, 0x400},
	{61442, 0x800},
	{61458, 0x1000},
	{61474, 0x2000},
	{61490, 0x10000},
	{61505, 0x20000},
	{61525, 0x40000},
	{61541, 0x80000},
	{61559, 0x100000},
	{61579, 0x200000},
	{61598, 0x400000},
	{61617, 0x800000},
	{61630, 0x1000000},
	{61644, 0x2000000},
	{61668, 0x4000000},
	{61684, 0x8000000},
	{61700, 0x10000000},
	{61716, 0x20000000},
	/* 232 */
	{61732, 0x8},
	{61751, 0x10},
	{61771, 0x40},
	{61790, 0x100},
	{61811, 0x200},
	{61829, 0x400},
	{61852, 0x2000},
	{61874, 0x10000},
	{61895, 0x20000},
	{61913, 0x40000},
	{61936, 0x200000},
	{61958, 0x400000},
	{61982, 0x800000},
	{62006, 0x1000000},
	{62029, 0x2000000},
	/* 247 */
	{62051, 0x1},
	{62070, 0x2},
	{62079, 0x10},
	{62094, 0x20},
	{62108, 0x40},
	{62127, 0x80},
	{62146, 0x100},
	{62161, 0x200},
	{62178, 0x400},
	{62200, 0x800},
	{62222, 0x1000},
	{62237, 0x2000},
	{61077, 0x4000},
	{62252, 0x8000},
	{62261, 0x10000},
	{61112, 0x20000},
	{62270, 0x40000},
	{62280, 0x80000},
	{62294, 0x100000},
	{62308, 0x200000},
	{62322, 0x400000},
	{61143, 0x800000},
	{62339, 0x1000000},
	{62352, 0x4000000},
	{62365, 0x8000000},
	{62378, 0x30000000},
	{62397, 0x40000000},
	{60460, 0x80000000},
	/* 275 */
	{62410, 0x1},
	{62428, 0x2},
	{62442, 0x4},
	{62461, 0x8},
	{62480, 0x10},
	{62495, 0x20},
	{62513, 0x40},
	{62531, 0x80},
	{62548, 0x100},
	{62563, 0x200},
	{62577, 0x400},
	{62594, 0x800},
	{62618, 0x1000},
	{62636, 0x2000},
	{62654, 0x4000},
	{62675, 0x8000},
	{62699, 0x10000},
	{62725, 0x20000},
	{62742, 0x40000},
	{62762, 0x80000},
	{62782, 0x100000},
	{62802, 0x200000},
	{62823, 0x400000},
	{62846, 0x800000},
	{62867, 0x1000000},
	{62886, 0x2000000},
	{62903, 0x4000000},
	{62919, 0x8000000},
	{62935, 0x10000000},
	{62951, 0x20000000},
	{62970, 0x40000000},
	{62982, 0x80000000},
	/* 307 */
	{62994, 0x1},
	{63013, 0x2},
	{63033, 0x4},
	{63053, 0x8},
	{63073, 0x20},
	{63094, 0x40},
	{61958, 0x80},
	{61982, 0x100},
	{63115, 0x200},
	{63142, 0x400},
	{63169, 0x800},
	{63190, 0x1000},
	{63209, 0x2000},
	/* 320 */
	{63228, 0x1},
	{63242, 0x4},
	{63257, 0x8},
	{63274, 0x80},
	{63286, 0x100},
	{63299, 0x400},
	{63314, 0x800},
	{63329, 0x1000},
	{63344, 0x2000},
	/* 329 */
	{2190, 0x3F},
	/* 330 */
	{2208, 0x1FF},
	{63359, 0x80000000},
	/* 332 */
	{2190, 0x7},
	/* 333 */
	{63384, 0x1000},
	{63406, 0x4000},
	{63431, 0x20000},
	{63452, 0x40000},
	{63476, 0x400000},
	{63503, 0x800000},
	{63528, 0x1000000},
	{63551, 0x8000000},
	{63571, 0x40000000},
	/* 342 */
	{2195, 0xF},
	/* 343 */
	{10396, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{879, 0x1FFFFFFF},
	{63587, 0x80000000},
	/* 347 */
	{63597, 0x3},
	{63606, 0xF0},
	{63614, 0x200},
	{63621, 0x1FC00},
	/* 351 */
	{63892, 0xFFF, 2049, 257},
	{64054, 0xFF0000, 129, 2306},
	{64066, 0x3000000},
	{64079, 0x80000000},
	/* 355 */
	{1318, 0x3},
	{64094, 0x4},
	{64103, 0x8},
	{64114, 0x10},
	{64127, 0x20},
	{53862, 0x1C0},
	{64141, 0x200},
	{64154, 0x400},
	{64167, 0x800},
	{64179, 0x1000},
	{64197, 0x2000},
	{64208, 0xC000},
	{64223, 0x30000},
	{64231, 0x40000},
	{64250, 0x80000},
	{64267, 0x40000000},
	{64279, 0x80000000},
	/* 372 */
	{64293, 0xFFF},
	{64308, 0xFFF000},
	{64320, 0x1000000},
	{60331, 0x2000000},
	{64328, 0x4000000},
	{64348, 0x8000000},
	/* 378 */
	{14261, 0xF},
	{64436, 0x3F0, 33, 2435},
	{64440, 0x400},
	{64315, 0x800},
	{64446, 0x1000},
	/* 383 */
	{64449, 0xFFFF},
	{20011, 0x3FFF0000},
	{64465, 0x40000000},
	{64479, 0x80000000},
	/* 387 */
	{64494, 0x7},
	{64504, 0x38},
	{64514, 0x1C0},
	{64524, 0xE00},
	{17638, 0x7F000, 293, 2468},
	{68761, 0x600000},
	{68774, 0x800000},
	{68789, 0x1000000},
	{68895, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 397 */
	{68906, 0x7},
	{68914, 0x38},
	{68922, 0x1C0},
	{68930, 0xE00},
	{68946, 0x7000},
	{68965, 0x8000},
	{68984, 0x70000},
	{69000, 0x80000},
	{69015, 0x100000},
	{69029, 0x7E00000},
	{69040, 0x8000000},
	{69052, 0x10000000},
	{69070, 0x60000000},
	{69082, 0x80000000},
	/* 411 */
	{69095, 0xFFF},
	{69103, 0xFFF000},
	{69111, 0xF000000},
	{69120, 0xF0000000},
	/* 415 */
	{69127, 0x3FFF},
	{69136, 0xFC000},
	{69149, 0x300000},
	{69163, 0xC00000},
	{69177, 0x3000000},
	{69186, 0xC000000},
	{69197, 0x10000000},
	{69216, 0x20000000},
	{69231, 0x40000000},
	/* 424 */
	{69246, 0xFFF},
	{69263, 0xC0000000},
	/* 426 */
	{69281, 0x1FFFFF},
	{69300, 0xE00000},
	{69319, 0x1000000},
	{69341, 0x2000000},
	{69363, 0x4000000},
	{69379, 0x8000000},
	{69396, 0x10000000},
	{69414, 0x20000000},
	{69430, 0xC0000000},
	/* 435 */
	{69451, 0x7},
	{69461, 0x38},
	{69482, 0xC0},
	{69503, 0x180000},
	{69522, 0xC000000},
	/* 440 */
	{69892, 0x3C, 16, 2765},
	{70320, 0x7C0, 19, 2781},
	{70510, 0x3800, 7, 2800},
	{70669, 0x1C00000, 5, 2807},
	{70689, 0x6000000},
	/* 445 */
	{70794, 0x3, 4, 2812},
	{70901, 0xC, 4, 2816},
	{71013, 0x30, 4, 2820},
	{71100, 0xC0, 4, 2824},
	/* 449 */
	{64449, 0xFF},
	{69095, 0xFFF00},
	{17638, 0x1FF00000, 293, 2468},
	{71110, 0xC0000000},
	/* 453 */
	{71119, 0xFFF},
	{70906, 0xFFFC000},
	{68789, 0x80000000},
	/* 456 */
	{64494, 0x7},
	{64504, 0x38},
	{64514, 0x1C0},
	{64524, 0xE00},
	{71128, 0xF000},
	{71139, 0xF0000},
	{71150, 0x1F00000},
	{71254, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 465 */
	{18784, 0x1FFF},
	{71265, 0x1FFF0000},
	/* 467 */
	{71276, 0xF},
	{71288, 0xF0},
	{71296, 0xFFF00},
	{71309, 0x700000},
	{71318, 0x800000},
	{71333, 0x2000000},
	{71348, 0x4000000},
	/* 474 */
	{71360, 0xFF},
	{71376, 0x400},
	{71388, 0x18000},
	{71416, 0x60000},
	{71442, 0x80000},
	{71460, 0x100000},
	{71482, 0x200000},
	{71497, 0x400000},
	{71513, 0x800000},
	{71529, 0xFF000000},
	/* 484 */
	{71550, 0xFFFF},
	/* 485 */
	{71550, 0xFFFF},
	{71556, 0x3F0000},
	{71567, 0x3C00000},
	/* 488 */
	{71586, 0xFF},
	/* 489 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{71712, 0x1000000},
	{71729, 0x2000000},
	{60051, 0x4000000},
	{59322, 0x20000000},
	/* 500 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{71775, 0x80},
	{71787, 0xFF00},
	{59314, 0x1FF0000, 257, 0},
	{71802, 0x2000000},
	{71824, 0x4000000},
	{71849, 0x8000000},
	{71863, 0xF0000000},
	/* 510 */
	{71879, 0x1},
	{71896, 0x1E},
	{71922, 0x1E0},
	{71955, 0x200},
	{71976, 0x7C00},
	{72000, 0x8000},
	{72025, 0x10000},
	{72044, 0xE0000},
	/* 518 */
	{72081, 0x7},
	{72110, 0x38},
	{72142, 0x40},
	{72158, 0xFF00},
	{72187, 0xFF0000},
	/* 523 */
	{72219, 0x7F},
	/* 524 */
	{71561, 0x3F},
	/* 525 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{72232, 0x3000000},
	{72246, 0x4000000},
	{71729, 0x8000000},
	{60051, 0x10000000},
	{59322, 0x80000000},
	/* 537 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{72272, 0x100},
	{72284, 0x200},
	{72296, 0x400},
	{72308, 0x800},
	{72320, 0x1000},
	{59314, 0x3FE000, 257, 0},
	{72326, 0x400000},
	{72337, 0x1000000},
	{71849, 0x8000000},
	{71863, 0xF0000000},
	/* 551 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59314, 0xFF80, 257, 0},
	{72232, 0x30000},
	{72262, 0x40000},
	{59747, 0x7F80000},
	{72354, 0x8000000},
	{71849, 0x10000000},
	/* 560 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{59314, 0x1FF00, 257, 0},
	{59747, 0x1FF00000},
	/* 566 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59747, 0xFF80},
	{59314, 0x1FF0000, 257, 0},
	/* 571 */
	{71550, 0xFFFF},
	{72366, 0x7F0000},
	/* 573 */
	{71550, 0xFFFF},
	{71556, 0x3F0000},
	{71567, 0x3C00000},
	{72391, 0xFC000000},
	/* 577 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{72246, 0x1000000},
	{71729, 0x2000000},
	{60051, 0x4000000},
	{72408, 0x8000000},
	{72417, 0x60000000},
	{59322, 0x80000000},
	/* 590 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59314, 0xFF80, 257, 0},
	{72434, 0x30000},
	{72262, 0x40000},
	{59747, 0x7F80000},
	{71849, 0x8000000},
	{71863, 0xF0000000},
	/* 599 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{72232, 0x3000000},
	{72246, 0x4000000},
	{59322, 0x80000000},
	/* 609 */
	{71556, 0x3F},
	{71567, 0x3C0},
	{72391, 0xFC00},
	{71550, 0xFFFF0000},
	/* 613 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{71729, 0x1000000},
	{60051, 0x2000000},
	{72408, 0x4000000},
	{72451, 0x30000000},
	{59322, 0x40000000},
	/* 625 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{72468, 0x100},
	{59314, 0x3FE00, 257, 0},
	{59747, 0x7FC0000},
	{71849, 0x8000000},
	{71863, 0xF0000000},
	/* 634 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{72232, 0x3000000},
	{59322, 0x40000000},
	/* 643 */
	{72479, 0x1},
	{72497, 0x2},
	{72511, 0x4},
	{72530, 0x8},
	{72550, 0x10},
	{72570, 0x20},
	{72592, 0x40},
	{72603, 0x400},
	{72621, 0x800},
	{10701, 0x1000},
	{72639, 0x2000},
	{72653, 0x4000},
	{72661, 0x8000},
	/* 656 */
	{72671, 0xFFFF},
	{72687, 0xFFFF0000},
	/* 658 */
	{10205, 0x1},
	/* 659 */
	{10233, 0x1},
	/* 660 */
	{402, 0xFF},
	/* 661 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{72706, 0x1000000},
	{59322, 0x4000000},
	{72408, 0x20000000},
	{71729, 0x40000000},
	{60051, 0x80000000},
	/* 673 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72712, 0x80},
	{72722, 0x100},
	{72732, 0x200},
	{72468, 0x400},
	{72742, 0x1800},
	{72757, 0x6000},
	{59747, 0xFF8000},
	{59314, 0x7F000000, 257, 0},
	/* 684 */
	{402, 0xF},
	/* 685 */
	{72769, 0x3FF},
	{72782, 0xF000},
	{72792, 0x3F0000},
	{72807, 0x400000},
	{72822, 0x800000},
	{72838, 0x7000000},
	/* 691 */
	{72853, 0xFFF},
	{72859, 0x1FFF000},
	/* 693 */
	{10668, 0x1},
	/* 694 */
	{72868, 0x3},
	{69975, 0x4},
	{72878, 0x8},
	{72888, 0x10},
	{72898, 0x1FFE0},
	/* 699 */
	{71879, 0x1},
	{71896, 0x1E},
	{71922, 0x1E0},
	{71955, 0x200},
	{71976, 0x7C00},
	{72000, 0x8000},
	{72025, 0x10000},
	{72044, 0xE0000},
	{72911, 0x7F00000},
	/* 708 */
	{71863, 0xF},
	/* 709 */
	{452, 0x7FF},
	/* 710 */
	{72948, 0x3FFFFFFF},
	{72956, 0x40000000},
	{72965, 0x80000000},
	/* 713 */
	{11950, 0xFFFF},
	/* 714 */
	{72974, 0x3FF},
	{63760, 0x400},
	/* 716 */
	{72984, 0x1},
	{73003, 0x2},
	{73024, 0x4},
	{73035, 0x8},
	{73048, 0x10},
	{73067, 0x20},
	{73092, 0x40},
	{73115, 0x80},
	{73129, 0xF00},
	{73141, 0x1000},
	/* 726 */
	{73159, 0x1},
	{73183, 0x2},
	{73204, 0x4},
	{73238, 0x8},
	{73273, 0x70},
	{73285, 0xF00},
	{73298, 0xF000},
	{73311, 0xF0000},
	{73324, 0xF00000},
	{73338, 0xF000000},
	{73356, 0xF0000000},
	/* 737 */
	{73373, 0x7FF},
	{73385, 0x1800},
	{73400, 0xFFE000},
	{73410, 0x1000000},
	{73422, 0x2000000},
	{73440, 0x3C000000},
	{73446, 0xC0000000},
	/* 744 */
	{73511, 0x3, 4, 3027},
	{73528, 0xC, 4, 3027},
	{73546, 0x30, 4, 3027},
	{73564, 0x40},
	{73585, 0x80},
	{73600, 0x100},
	{73621, 0x200},
	{73639, 0x400},
	{73656, 0x800},
	{73669, 0x1000},
	{73688, 0x6000, 4, 3027},
	{73707, 0x8000},
	{73731, 0x10000},
	{73754, 0x20000},
	{73771, 0x40000},
	{73856, 0x180000, 4, 3031},
	{73875, 0x3E00000},
	{73892, 0x4000000},
	{73916, 0x8000000},
	{73930, 0x10000000},
	{73950, 0x20000000},
	{73964, 0x40000000},
	{73984, 0x80000000},
	/* 767 */
	{74058, 0x3, 4, 3035},
	{74087, 0x1C},
	{74118, 0x20},
	{74154, 0x40},
	{74189, 0x80},
	{74217, 0x100},
	{74239, 0x200},
	{74257, 0x400},
	{74289, 0x800},
	{74410, 0x7000, 8, 3039},
	{74420, 0x38000},
	{74433, 0x1C0000},
	{74446, 0x200000},
	{74462, 0x400000},
	{74480, 0x800000},
	{74498, 0x2000000},
	/* 783 */
	{74526, 0x3FFF},
	{59106, 0x3FFF0000},
	/* 785 */
	{11568, 0xFF},
	/* 786 */
	{74532, 0xFFFF},
	{74537, 0xFFFF0000},
	/* 788 */
	{74542, 0xFFFF},
	{74547, 0xFFFF0000},
	/* 790 */
	{74561, 0x3, 4, 3047},
	{74575, 0x4},
	{74600, 0x8},
	/* 793 */
	{74618, 0xF},
	{74626, 0xF0},
	{74634, 0x1F00},
	{74642, 0x6000},
	{74650, 0x18000},
	{74658, 0x60000},
	{74666, 0x180000},
	{68789, 0xF0000000},
	/* 801 */
	{17638, 0x3, 4, 3051},
	{74705, 0xC},
	{71150, 0x1F0},
	{74760, 0x600, 4, 3055},
	{74775, 0x800},
	{74789, 0x1000},
	{74808, 0xE000},
	{74825, 0xF0000},
	{71376, 0x100000},
	{74832, 0x7800000},
	{74856, 0x8000000},
	{74871, 0x10000000},
	{74881, 0x20000000},
	{74901, 0x80000000},
	/* 815 */
	{17638, 0x1, 2, 3059},
	{71150, 0x1F0},
	{74760, 0x600, 4, 3055},
	{74775, 0x800},
	{74789, 0x1000},
	{74808, 0xE000},
	{71376, 0x100000},
	{74856, 0x8000000},
	{74944, 0x20000000},
	/* 824 */
	{74618, 0x7FF},
	{74626, 0x3FF800},
	/* 826 */
	{74618, 0x3FFFFF},
	/* 827 */
	{10396, 0xFF},
	/* 828 */
	{75016, 0x3, 4, 3061},
	{75028, 0xC, 4, 3061},
	{75040, 0x30, 4, 3061},
	{75056, 0xC0, 4, 3061},
	{75126, 0x30000, 4, 3065},
	{75138, 0xC0000, 4, 3065},
	{75150, 0x300000, 4, 3065},
	{75166, 0x1000000},
	{75177, 0x2000000},
	/* 837 */
	{30877, 0xFF},
	/* 838 */
	{75188, 0xFF},
	/* 839 */
	{75206, 0xFFFF},
	{75222, 0xFFFF0000},
	/* 841 */
	{74532, 0x7FFF},
	{74537, 0x7FFF0000},
	{75238, 0x80000000},
	/* 844 */
	{74542, 0x7FFF},
	{74547, 0x7FFF0000},
	/* 846 */
	{75326, 0xFFFF, 32769, 3069},
	/* 847 */
	{75336, 0xF},
	{75343, 0xF0},
	{75352, 0xF00},
	{75360, 0x3F000},
	{75371, 0xFC0000},
	{75382, 0xF000000},
	{75393, 0xF0000000},
	/* 854 */
	{75404, 0x1FF},
	{75423, 0x1FF0000},
	/* 856 */
	{75442, 0xF},
	{75457, 0xF0},
	{75472, 0xF00},
	{75487, 0xF000},
	{75502, 0xF0000},
	{75517, 0xF00000},
	{75532, 0xF000000},
	{75547, 0xF0000000},
	/* 864 */
	{75562, 0xF},
	{75577, 0xF0},
	{75592, 0xF00},
	{75607, 0xF000},
	{75622, 0xF0000},
	{75637, 0xF00000},
	{75652, 0xF000000},
	{75667, 0xF0000000},
	/* 872 */
	{75774, 0x3, 4, 35838},
	{75786, 0xC, 4, 35838},
	{75898, 0x30, 4, 35842},
	{75955, 0x40, 2, 35846},
	{76011, 0x80, 2, 35848},
	{76115, 0x300, 4, 35850},
	{76223, 0xC00, 4, 35854},
	{76332, 0x3000, 4, 35858},
	{76445, 0xC000, 4, 35862},
	{76547, 0x30000, 4, 35866},
	{76693, 0xC0000, 4, 35870},
	{76840, 0x300000, 4, 35874},
	{76940, 0x3000000, 4, 35878},
	{77086, 0xC000000, 4, 35882},
	{77233, 0x30000000, 4, 35886},
	/* 887 */
	{77353, 0x3, 4, 35890},
	{77524, 0xC, 4, 35894},
	{77696, 0x30, 4, 35898},
	/* 890 */
	{73338, 0x3},
	{73356, 0xC},
	/* 892 */
	{10218, 0x1},
	{77709, 0x6},
	{69522, 0x60},
	{77716, 0x100},
	{77751, 0x3000},
	{77758, 0x30000},
	{77772, 0x100000},
	/* 899 */
	{77790, 0x80000000},
	/* 900 */
	{59630, 0x3},
	/* 901 */
	{10448, 0xF},
	/* 902 */
	{77805, 0xFF},
	{77814, 0xFF00},
	{77824, 0xFF0000},
	{77835, 0xFF000000},
	/* 906 */
	{77845, 0xFF},
	{77853, 0xFF00},
	{77862, 0xFF0000},
	{77871, 0xFF000000},
	/* 910 */
	{77879, 0x3, 4, 3061},
	{77895, 0xC, 4, 3061},
	{77911, 0x30, 4, 3061},
	{77925, 0xC0, 4, 3061},
	{77941, 0x30000, 4, 3065},
	{77957, 0xC0000, 4, 3065},
	{77973, 0x300000, 4, 3065},
	{77987, 0xC00000, 4, 3065},
	{78003, 0x40000000},
	{78018, 0x80000000},
	/* 920 */
	{78033, 0x1},
	{78060, 0x7C},
	{78089, 0x100},
	{78118, 0x200},
	{78149, 0x400},
	{78177, 0x1000},
	{78205, 0x2000},
	{78235, 0x4000},
	/* 928 */
	{78261, 0x1},
	{78281, 0xE},
	{78298, 0x30},
	{78319, 0xF00},
	/* 932 */
	{78577, 0xF, 16, 35902},
	{78589, 0xF0, 16, 35902},
	{78602, 0xF00, 16, 35902},
	{78615, 0xF000, 16, 35902},
	{78630, 0xF0000, 16, 35902},
	{78646, 0xF00000, 16, 35902},
	/* 938 */
	{78662, 0xFF},
	{78677, 0xFF00},
	{78689, 0xFF0000},
	{78706, 0xFF000000},
	/* 942 */
	{78719, 0xFF},
	{78737, 0xFF00},
	{78752, 0xFF0000},
	{78772, 0xFF000000},
	/* 946 */
	{879, 0x3F},
	{78788, 0x300},
	{78800, 0x400},
	{78811, 0x1E000},
	{78820, 0x20000},
	{78834, 0x40000},
	{78838, 0x80000},
	{78855, 0x100000},
	{78873, 0x600000},
	{78891, 0x800000},
	{78911, 0x1000000},
	{78923, 0x2000000},
	/* 958 */
	{879, 0x3F},
	{78788, 0x300},
	{78800, 0x400},
	{78834, 0x40000},
	{78838, 0x80000},
	{78855, 0x100000},
	{78873, 0x600000},
	{78911, 0x1000000},
	{78923, 0x2000000},
	/* 967 */
	{78935, 0x3E},
	{78951, 0x40},
	{78964, 0x80},
	/* 970 */
	{78977, 0x1},
	{78994, 0x2},
	{79011, 0x4},
	{79030, 0x8},
	{79051, 0x10},
	{79069, 0x20},
	{79087, 0x40},
	{79107, 0x80},
	{79128, 0x100},
	{79144, 0x200},
	{79160, 0x400},
	{79176, 0x800},
	{79192, 0x1000},
	{79207, 0x2000},
	{79221, 0x4000},
	{79241, 0x8000},
	/* 986 */
	{79258, 0x1},
	{79273, 0x2},
	{79396, 0x1C, 5, 35918},
	{79414, 0xE0, 5, 35918},
	{79432, 0x700, 5, 35918},
	{79450, 0x3800, 5, 35918},
	{79468, 0x4000},
	/* 993 */
	{79485, 0x3F},
	{79496, 0x40},
	{79506, 0x80},
	{79523, 0x100},
	{79539, 0x4000},
	{79559, 0x8000},
	/* 999 */
	{79569, 0x1},
	{79587, 0x10},
	{79607, 0x100},
	{79626, 0x1000},
	{79647, 0x30000},
	{79666, 0x100000},
	{79680, 0x1000000},
	/* 1006 */
	{79788, 0xF, 5, 35923},
	/* 1007 */
	{79807, 0xF, 5, 35923},
	{79826, 0xF0, 5, 35923},
	{79845, 0xF00, 5, 35923},
	{79864, 0xF000, 5, 35923},
	{79883, 0xF0000, 5, 35923},
	/* 1012 */
	{80102, 0xF, 10, 35928},
	/* 1013 */
	{80118, 0xF, 10, 35928},
	{80137, 0xF0, 10, 35928},
	{80156, 0xF00, 10, 35928},
	{80175, 0xF000, 10, 35928},
	{80194, 0xF0000, 10, 35928},
	{80213, 0xF00000, 10, 35928},
	{80232, 0xF000000, 10, 35928},
	{80251, 0xF0000000, 10, 35928},
	/* 1021 */
	{80505, 0xF, 11, 35938},
	{80510, 0xF0, 11, 35938},
	{80515, 0xF00, 11, 35938},
	{80520, 0xF000, 11, 35938},
	{80525, 0xF0000, 11, 35938},
	{80530, 0xF00000, 11, 35938},
	{80535, 0xF000000, 11, 35938},
	{80540, 0xF0000000, 11, 35938},
	/* 1029 */
	{80712, 0xF, 16, 35949},
	{80725, 0xF0},
	{80738, 0xF00},
	{80751, 0xF000},
	{80764, 0xF0000},
	{80777, 0xF00000},
	{80790, 0xF000000},
	{80803, 0xF0000000},
	/* 1037 */
	{80816, 0x1},
	{80839, 0x2},
	{80862, 0x10},
	{80885, 0x20},
	{80908, 0x100},
	{80931, 0x200},
	{80954, 0x1000},
	{80977, 0x2000},
	{81000, 0x10000},
	{81023, 0x20000},
	{81046, 0x100000},
	{81069, 0x200000},
	{81092, 0x1000000},
	{81115, 0x2000000},
	{81138, 0x10000000},
	{81161, 0x20000000},
	{81184, 0x80000000},
	/* 1054 */
	{81475, 0x7, 8, 35965},
	{81489, 0x70, 8, 35965},
	{81637, 0x700, 8, 35973},
	{81652, 0x70000, 8, 35965},
	{81666, 0x700000, 8, 35965},
	{81680, 0x7000000, 8, 35973},
	/* 1060 */
	{82135, 0x1F, 21, 35981},
	{81637, 0xE0, 5, 36002},
	{82240, 0x1F00, 21, 35981},
	{82256, 0x1F0000, 21, 35981},
	{81680, 0xE00000, 5, 36002},
	{82271, 0x1F000000, 21, 35981},
	{82287, 0x20000000},
	{10218, 0x40000000},
	{82308, 0x80000000},
	/* 1069 */
	{82321, 0x7},
	/* 1070 */
	{11945, 0xFFFF},
	/* 1071 */
	{82412, 0x3, 4, 36007},
	{82458, 0xC, 2, 36011},
	{82469, 0x10},
	{82484, 0x20},
	{82492, 0x40},
	{82503, 0x80},
	{82517, 0x100},
	{82534, 0xE0000000},
	/* 1079 */
	{82547, 0xFFFFFFF},
	/* 1080 */
	{82559, 0x3FF},
	/* 1081 */
	{82582, 0x1},
	{73519, 0x2},
	{82597, 0x4},
	{82612, 0x8},
	{74414, 0x70, 8, 3039},
	{82632, 0x80},
	{82648, 0x700, 8, 3039},
	{82660, 0x700000, 8, 3039},
	{82675, 0x40000000},
	{82709, 0x80000000},
	/* 1091 */
	{82744, 0x7},
	{82763, 0x70},
	{82779, 0x700},
	{82803, 0x7000},
	{82829, 0x10000},
	{82856, 0x20000},
	{82878, 0x40000},
	{82897, 0x80000},
	{82915, 0x100000},
	{82942, 0x200000},
	{82969, 0x7000000},
	{82994, 0x8000000},
	/* 1103 */
	{83025, 0x1},
	{83043, 0x8},
	{1318, 0x70, 8, 36013},
	{82316, 0xFF0000, 256, 36021},
	/* 1107 */
	{83463, 0x1},
	{83479, 0x2},
	{83510, 0x4},
	{73577, 0x30, 4, 36277},
	{83589, 0x40},
	{83601, 0x80},
	{83625, 0x100},
	{83644, 0x200},
	{83662, 0x400},
	{83675, 0x800},
	{83697, 0x1000},
	{83787, 0x6000, 4, 36281},
	{83809, 0x8000},
	{83827, 0x10000},
	{83858, 0x20000},
	{83877, 0x700000},
	{83902, 0x800000},
	/* 1124 */
	{83935, 0x1},
	{83945, 0x2},
	{83955, 0x4},
	{83965, 0x8},
	{83975, 0x10},
	{83985, 0x20},
	{83995, 0x2000},
	{84014, 0xC000},
	{84026, 0x10000},
	{84039, 0x20000},
	{84057, 0x40000},
	{84080, 0x80000},
	{84098, 0x100000},
	{84118, 0x200000},
	{84130, 0x400000},
	{84152, 0x1000000},
	{84176, 0x2000000},
	{84202, 0x4000000},
	{84221, 0x8000000},
	{84239, 0x10000000},
	/* 1144 */
	{84259, 0x1},
	{84270, 0x2},
	{19512, 0x4},
	{84290, 0x18, 2, 36285},
	{84356, 0xE0, 3, 36287},
	{84377, 0x700, 3, 36287},
	{84397, 0x800},
	{84422, 0x1000},
	{84446, 0x2000},
	{84470, 0x10000},
	{84495, 0x80000},
	{84514, 0x100000},
	{84529, 0x200000},
	{84547, 0x400000},
	{84585, 0x800000},
	{84608, 0x1000000},
	/* 1160 */
	{84629, 0x1},
	{84647, 0x2},
	{84666, 0x4},
	{84684, 0x8},
	{84703, 0x10},
	{84721, 0x20},
	{84740, 0x100},
	{84751, 0x200},
	{84761, 0x400},
	{84772, 0x800},
	/* 1170 */
	{84788, 0x1},
	{84804, 0x2},
	{84820, 0x4},
	{84836, 0x8},
	{84852, 0x10},
	{84868, 0x20},
	{84884, 0x40},
	{84900, 0x80},
	{84916, 0x100},
	{84932, 0x200},
	{84948, 0x400},
	{84964, 0x800},
	{84980, 0x1000},
	{84996, 0x2000},
	{85012, 0x4000},
	{85028, 0x8000},
	{85044, 0x10000},
	{85063, 0x20000},
	{85081, 0x40000},
	{85108, 0x80000},
	{85130, 0x100000},
	{85148, 0x200000},
	{85168, 0x400000},
	{85191, 0x800000},
	{85214, 0x1000000},
	{85239, 0x2000000},
	{85259, 0x4000000},
	{85282, 0x8000000},
	/* 1198 */
	{85301, 0x1},
	{85320, 0x2},
	{85338, 0x4},
	{85356, 0x8},
	{85374, 0x10},
	{85392, 0x20},
	{85409, 0x40},
	{85426, 0x80},
	{85447, 0x100},
	{85464, 0x200},
	{85481, 0x400},
	{85497, 0x800},
	{85513, 0x1000},
	{85529, 0x2000},
	{85545, 0x4000},
	{85570, 0x100000},
	/* 1214 */
	{85590, 0x3},
	{85609, 0x4},
	{85628, 0x8},
	{85645, 0x10},
	/* 1218 */
	{85660, 0x1},
	{85684, 0x2},
	{85704, 0x4},
	{85725, 0x8},
	{85750, 0x10},
	{85770, 0x20},
	{85786, 0x40},
	{85803, 0x80},
	{85824, 0xFF00},
	{85845, 0x40000000},
	{85866, 0x80000000},
	/* 1229 */
	{85888, 0x1},
	{85660, 0x2},
	{85684, 0x4},
	{85704, 0x8},
	{85725, 0x10},
	{85913, 0x20},
	{85926, 0x40},
	/* 1236 */
	{85955, 0x1},
	{85966, 0x2},
	/* 1238 */
	{85984, 0x1},
	{86001, 0x2},
	/* 1240 */
	{86025, 0x1},
	{86050, 0x2},
	{86071, 0x4},
	{86093, 0x8},
	{86119, 0x10},
	/* 1245 */
	{86136, 0x1E},
	{86148, 0xE0},
	{86162, 0xF00},
	{86178, 0x70000},
	{86189, 0x780000},
	/* 1250 */
	{70906, 0xFFFF},
	{70799, 0xFFFF0000},
	/* 1252 */
	{86202, 0xFFFF},
	{19185, 0xFFFF0000},
	/* 1254 */
	{70799, 0xFFFF},
	/* 1255 */
	{86211, 0xFFFF},
	{86224, 0xFF0000},
	{86237, 0x10000000},
	{86255, 0x60000000},
	/* 1259 */
	{86271, 0x7},
	/* 1260 */
	{86283, 0x3},
	/* 1261 */
	{18778, 0xFF},
	/* 1262 */
	{18800, 0x1F, 22, 36290},
	{86642, 0x4000},
	{86655, 0x8000},
	{86668, 0x70000},
	/* 1266 */
	{18820, 0xF},
	/* 1267 */
	{18826, 0xF},
	/* 1268 */
	{86679, 0x1},
	{86689, 0x2},
	{86699, 0x4},
	{86709, 0x8},
	{20011, 0xFF00},
	{86719, 0xFF0000},
	/* 1274 */
	{86725, 0xF},
	{14173, 0xF0},
	{86732, 0xF00},
	{75229, 0xF000},
	{86739, 0xF0000},
	{86746, 0xF00000},
	{86755, 0xF000000},
	{12105, 0xF0000000},
	/* 1282 */
	{1318, 0x7, 6, 36312},
	{86835, 0x8},
	{86891, 0x30, 4, 36318},
	{86900, 0x7C0},
	{86911, 0x800},
	{86924, 0x1000},
	{86935, 0x2000},
	{86947, 0x4000},
	{86960, 0x8000},
	{86978, 0x10000},
	{86994, 0x20000},
	{87013, 0x40000},
	{87027, 0x80000},
	{87045, 0x100000},
	{87063, 0x600000},
	/* 1297 */
	{87070, 0x7FF},
	{87090, 0x3FF800},
	{87110, 0xFFC00000},
	/* 1300 */
	{87134, 0x1},
	{87146, 0x2},
	{87167, 0x4},
	{87187, 0x8},
	{87212, 0x10},
	{87233, 0x20},
	{87256, 0x40},
	/* 1307 */
	{87286, 0x1},
	{87296, 0x2},
	{87311, 0x4},
	{87336, 0x8},
	{87354, 0x70},
	{87370, 0x80},
	{87375, 0x100},
	{87398, 0x200},
	{87417, 0x400},
	{87439, 0x800},
	{87455, 0x1000},
	{87471, 0x2000},
	{87487, 0x4000},
	{87506, 0x8000},
	{87532, 0x10000},
	{87547, 0x20000},
	{87587, 0x40000},
	{87614, 0x80000},
	{87637, 0xF00000},
	{87653, 0x1000000},
	{87683, 0x2000000},
	{87707, 0x4000000},
	{87728, 0x8000000},
	{87758, 0x70000000},
	/* 1331 */
	{19025, 0x7FF},
	/* 1332 */
	{19039, 0x7FF},
	/* 1333 */
	{19053, 0xF},
	/* 1334 */
	{879, 0x7FFF},
	/* 1335 */
	{87782, 0x3F, 4, 36322},
	{87795, 0x3F00, 4, 36322},
	{87810, 0x3F0000, 4, 36322},
	{87825, 0xFC00000, 4, 36322},
	{87840, 0x80000000},
	/* 1340 */
	{214, 0x3, 3, 36326},
	{87977, 0xC, 4, 36329},
	{88057, 0x30, 4, 36333},
	{88117, 0xC0, 3, 36337},
	{88130, 0x100},
	{82484, 0x200},
	{88134, 0x400},
	{88143, 0x3800},
	/* 1348 */
	{19228, 0x1},
	{88149, 0x2},
	{88170, 0x4},
	/* 1351 */
	{89353, 0x3F, 64, 36340},
	{64454, 0x7FFFC00},
	{89364, 0x8000000},
	/* 1354 */
	{19325, 0x1},
	{89379, 0x2},
	/* 1356 */
	{89394, 0x1},
	{89408, 0x2},
	{89424, 0x4},
	{89442, 0x8},
	{89458, 0x10},
	/* 1361 */
	{89469, 0xFFFF},
	{89484, 0x10000},
	{89503, 0x20000},
	{89517, 0x40000},
	{89536, 0x80000},
	{89550, 0x100000},
	/* 1367 */
	{19439, 0x7FFF},
	/* 1368 */
	{19475, 0x1},
	/* 1369 */
	{19489, 0x1},
	/* 1370 */
	{74808, 0x1},
	{89567, 0x2},
	{89578, 0x4},
	{89595, 0x8},
	{89612, 0x3F0},
	{89629, 0xFC00},
	{89646, 0x10000},
	{89670, 0x20000},
	{71447, 0x40000},
	/* 1379 */
	{89687, 0x7, 8, 3039},
	{89700, 0xFF0},
	{89714, 0xFF000},
	{73538, 0x1000000},
	/* 1383 */
	{89727, 0x7, 8, 3039},
	{89740, 0xFF0},
	{89754, 0xFF000},
	{73556, 0x1000000},
	/* 1387 */
	{10094, 0xFF},
	{10110, 0xFF00},
	{89767, 0xFF0000},
	{89773, 0xFF000000},
	/* 1391 */
	{20011, 0x3FF},
	/* 1392 */
	{20004, 0x1FF},
	/* 1393 */
	{20025, 0x7FF},
	/* 1394 */
	{89779, 0x1FF},
	{89795, 0x3FE00},
	/* 1396 */
	{89811, 0xFF},
	{89825, 0xFF00},
	{89835, 0xFF0000},
	{89846, 0x1F000000},
	{89858, 0xE0000000},
	/* 1401 */
	{89918, 0x3, 4, 36404},
	{89949, 0x4, 2, 36408},
	{20094, 0x18, 4, 36410},
	{90031, 0x20, 2, 36414},
	{90096, 0xC0, 4, 36416},
	{90102, 0x100},
	{72337, 0x200},
	{90113, 0x400},
	{90133, 0x800},
	{90153, 0x1000},
	{90167, 0x2000},
	{90178, 0x4000},
	{90194, 0x78000},
	{90214, 0x180000},
	{90229, 0x200000},
	{90239, 0x400000},
	{90249, 0x800000},
	{90259, 0x1000000},
	{90274, 0x2000000},
	/* 1420 */
	{90294, 0xFF},
	{90306, 0x3F00},
	{90322, 0xFC000},
	/* 1423 */
	{220, 0x3, 3, 36420},
	{90428, 0x1C, 4, 36423},
	{90505, 0xE0, 4, 36427},
	{90514, 0x100},
	{90534, 0x200},
	{90545, 0x3C00},
	{90567, 0x4000},
	{88117, 0x18000, 3, 36337},
	{90601, 0x60000, 4, 36431},
	{90660, 0x80000, 3, 36435},
	{90712, 0x100000, 3, 36438},
	{88143, 0x3800000},
	/* 1435 */
	{90724, 0x1},
	{90745, 0x300},
	{90767, 0xC00},
	{90789, 0x3000},
	{90811, 0xC000},
	{90833, 0x10000},
	/* 1441 */
	{90846, 0xFF},
	{90874, 0x100},
	/* 1443 */
	{10218, 0x1},
	{20451, 0x1FC},
	{90902, 0x80000000},
	/* 1446 */
	{90934, 0x1},
	{90949, 0x2},
	{90964, 0x4},
	{90979, 0x8},
	{90994, 0x70},
	{91006, 0x80},
	{91026, 0xF00},
	{91043, 0x80000000},
	/* 1454 */
	{91064, 0xF},
	{91083, 0xF0},
	{91102, 0xF00},
	{91121, 0xF000},
	/* 1458 */
	{91140, 0xF},
	{91151, 0xF0},
	{91162, 0xF00},
	{91173, 0xF000},
	{91184, 0xF0000},
	{91195, 0xF00000},
	{91206, 0xF000000},
	{91217, 0xF0000000},
	/* 1466 */
	{91228, 0xF},
	{91239, 0xF0},
	{91250, 0xF00},
	{91262, 0xF000},
	{91274, 0xF0000},
	{91286, 0xF00000},
	{91298, 0xF000000},
	{91310, 0xF0000000},
	/* 1474 */
	{91322, 0x200},
	{91340, 0x400},
	{91351, 0x800},
	{91376, 0x1000},
	{91398, 0x2000},
	/* 1479 */
	{91420, 0x7},
	{91437, 0x10},
	{91459, 0x1E000},
	{91475, 0x700000},
	{91496, 0x3000000},
	{91576, 0xC000000, 4, 36441},
	/* 1485 */
	{91602, 0x1},
	{91663, 0x6, 4, 36445},
	{91879, 0x38, 8, 36449},
	/* 1488 */
	{91890, 0xF},
	{91895, 0xF0},
	{91900, 0xF00},
	{91905, 0xF000},
	{91910, 0xF0000},
	{91915, 0xF00000},
	{91920, 0xF000000},
	{91925, 0xF0000000},
	/* 1496 */
	{91930, 0xF},
	{91935, 0xF0},
	{91940, 0xF00},
	{91945, 0xF000},
	{91950, 0xF0000},
	{91955, 0xF00000},
	{91960, 0xF000000},
	{91965, 0xF0000000},
	/* 1504 */
	{91970, 0xF},
	{91975, 0xF0},
	{91980, 0xF00},
	{91985, 0xF000},
	{91990, 0xF0000},
	{91996, 0xF00000},
	{92002, 0xF000000},
	{92008, 0xF0000000},
	/* 1512 */
	{92014, 0xF},
	{92020, 0xF0},
	{92026, 0xF00},
	{92032, 0xF000},
	{92038, 0xF0000},
	{92044, 0xF00000},
	{92050, 0xF000000},
	{92056, 0xF0000000},
	/* 1520 */
	{92062, 0xFFFF},
	{92075, 0xFFFF0000},
	/* 1522 */
	{92088, 0xFFFF},
	{92101, 0xFFFF0000},
	/* 1524 */
	{92114, 0x3},
	{71802, 0x4},
	{71824, 0x8},
	{92143, 0x60},
	/* 1528 */
	{92256, 0x3, 4, 36457},
	{92269, 0x4},
	{92280, 0x8},
	{92389, 0x70, 5, 36461},
	{92407, 0x380, 5, 36461},
	{92425, 0x1C00},
	{92448, 0x3E000},
	{92474, 0x40000},
	{92496, 0x7F80000},
	{92512, 0x8000000},
	{92534, 0x10000000},
	{92621, 0x60000000, 3, 36466},
	/* 1540 */
	{92638, 0xFFFF},
	{92654, 0xFFFF0000},
	/* 1542 */
	{92673, 0x1},
	{92690, 0x1E},
	{92714, 0x20},
	{92732, 0x3C0},
	{92757, 0x400},
	{92787, 0x800},
	{92802, 0x1000},
	{92817, 0x2000},
	{92852, 0x4000},
	{92888, 0x8000},
	{92978, 0x30000, 3, 36469},
	{93002, 0x40000},
	{93038, 0x80000},
	{93074, 0x100000},
	{93100, 0x200000},
	{93124, 0x400000},
	{93144, 0x800000},
	{93165, 0x1000000},
	{93190, 0x6000000},
	{93214, 0x18000000},
	/* 1562 */
	{93242, 0x7FF},
	{93263, 0xFF0000},
	/* 1564 */
	{93281, 0xFF},
	/* 1565 */
	{93297, 0x7F},
	/* 1566 */
	{93310, 0x7FF},
	{93319, 0x7FF00000},
	/* 1568 */
	{93310, 0x3FFFFF},
	/* 1569 */
	{73373, 0x1FFF},
	{73400, 0x3FFE000},
	{93334, 0x3C000000},
	/* 1572 */
	{93395, 0x3, 4, 36472},
	{17638, 0x7C, 32, 36476},
	{69542, 0x80},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{83092, 0x2000},
	{73993, 0x4000},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94097, 0x80000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	{94370, 0x4000000},
	{94396, 0x8000000},
	{94422, 0x10000000},
	{94490, 0x60000000, 3, 36528},
	{94506, 0x80000000},
	/* 1591 */
	{94520, 0x1F},
	{94536, 0x3E0},
	{94558, 0xC00},
	{74705, 0x7000},
	{94576, 0x18000},
	{94590, 0x20000},
	{94608, 0x40000},
	{94634, 0x80000},
	/* 1599 */
	{78033, 0x1},
	{94664, 0x2},
	{71388, 0xC, 3, 36531},
	{94778, 0x10, 2, 36534},
	{71416, 0x60},
	{71513, 0x180},
	{94804, 0x200},
	{94827, 0x3C00},
	{94847, 0x3C000},
	{78149, 0x40000},
	{94869, 0x80000},
	{94902, 0x100000},
	/* 1611 */
	{93310, 0x3FFF},
	/* 1612 */
	{94926, 0xFF},
	/* 1613 */
	{94936, 0x3FFF},
	{94948, 0xFFFC000},
	{71288, 0xF0000000},
	/* 1616 */
	{94959, 0x1FFF},
	{94970, 0x2000},
	{94982, 0x7C000},
	{94996, 0xF80000},
	{95010, 0x3000000},
	{95024, 0x4000000},
	{68789, 0x38000000},
	{95043, 0x40000000},
	/* 1624 */
	{10301, 0xFFFFFFFC},
	/* 1625 */
	{10330, 0xFFFF},
	/* 1626 */
	{24664, 0xFFFFFFFC},
	/* 1627 */
	{24686, 0xFFFF},
	/* 1628 */
	{25180, 0xFFFFFFFC},
	/* 1629 */
	{25202, 0xFFFF},
	/* 1630 */
	{95060, 0xFFFFFFC},
	/* 1631 */
	{95076, 0x6000000},
	/* 1632 */
	{95089, 0x1},
	/* 1633 */
	{95108, 0xFF},
	{95122, 0x30000},
	/* 1635 */
	{95136, 0xFFFFFFFC},
	/* 1636 */
	{95148, 0xFFFF},
	{95160, 0x10000},
	{95076, 0x6000000},
	{26989, 0xE0000000},
	/* 1640 */
	{26539, 0xFFFFFFFC},
	/* 1641 */
	{26557, 0xFFFF},
	{95076, 0xC00000},
	/* 1643 */
	{26611, 0xFFFFFFFC},
	/* 1644 */
	{26629, 0xFFFF},
	{95076, 0xC00000},
	/* 1646 */
	{95170, 0x3},
	{26669, 0xFFFFFFF8},
	/* 1648 */
	{26688, 0xFFFF},
	{95184, 0x10000},
	{95200, 0x100000},
	{95216, 0x3000000},
	{95232, 0xE0000000},
	/* 1653 */
	{95243, 0x400},
	{95256, 0x6000},
	{95273, 0x8000},
	{95285, 0x300000},
	{95296, 0x6000000},
	{95313, 0x8000000},
	{95325, 0x60000000},
	/* 1660 */
	{95336, 0xFF},
	/* 1661 */
	{95355, 0x3F},
	/* 1662 */
	{95373, 0x8},
	{95390, 0x10},
	{95407, 0x20},
	{95434, 0x8000},
	{95454, 0x40000},
	{95471, 0x400000},
	{95487, 0x800000},
	{95501, 0x2000000},
	{95515, 0x4000000},
	{95529, 0x8000000},
	{95550, 0x10000000},
	{95575, 0x20000000},
	{95596, 0x40000000},
	/* 1675 */
	{95620, 0x3000000},
	{1331, 0x80000000},
	/* 1677 */
	{26926, 0xFFFF},
	/* 1678 */
	{26967, 0xFFFF},
	/* 1679 */
	{95625, 0x3FFFFFF},
	{95636, 0x4000000},
	{95640, 0x8000000},
	{95644, 0x10000000},
	{95649, 0x20000000},
	{95654, 0x40000000},
	{95663, 0x80000000},
	/* 1686 */
	{95670, 0x1},
	{95690, 0x2},
	{95704, 0x30},
	{95716, 0x1FF0000},
	{95729, 0x10000000},
	{95744, 0x20000000},
	{95758, 0xC0000000},
	/* 1693 */
	{95768, 0x3FFFFFF},
	{95781, 0x10000000},
	/* 1695 */
	{95800, 0xFF},
	/* 1696 */
	{95819, 0xFF},
	/* 1697 */
	{95825, 0x1},
	{95839, 0x2},
	{95851, 0x10000},
	{95865, 0x1000000},
	/* 1701 */
	{2208, 0xFF},
	{63359, 0x80000000},
	/* 1703 */
	{27222, 0xFFFFF},
	/* 1704 */
	{27235, 0xFFFFF},
	/* 1705 */
	{27249, 0xFFFFF},
	/* 1706 */
	{27263, 0xFFFFF},
	/* 1707 */
	{27285, 0xFFFFF},
	/* 1708 */
	{27305, 0xFFFFF},
	/* 1709 */
	{27327, 0xFFFFF},
	/* 1710 */
	{95878, 0x3},
	{10301, 0xFFFFFFFC},
	/* 1712 */
	{10330, 0xFFFF},
	{95878, 0xFFFF0000},
	/* 1714 */
	{95883, 0xFFF},
	/* 1715 */
	{95898, 0xFFFFF},
	/* 1716 */
	{95912, 0xFFFFF},
	/* 1717 */
	{95926, 0xFFFFF},
	/* 1718 */
	{27643, 0xFFFFFFE0},
	/* 1719 */
	{27662, 0xFFFF},
	/* 1720 */
	{27681, 0xFFF},
	/* 1721 */
	{27698, 0xFFFFFFFC},
	/* 1722 */
	{27716, 0xFFFF},
	/* 1723 */
	{27734, 0xFFFFF},
	/* 1724 */
	{27750, 0xFFFFFFFC},
	/* 1725 */
	{27768, 0xFFFF},
	/* 1726 */
	{27786, 0xFFFFF},
	/* 1727 */
	{27885, 0xFFFFFFFC},
	/* 1728 */
	{27899, 0xFFFF},
	/* 1729 */
	{27913, 0xFFFFF},
	/* 1730 */
	{43248, 0xFFF000},
	{95076, 0x6000000},
	{95939, 0x8000000},
	{95952, 0x10000000},
	/* 1734 */
	{95960, 0x30000},
	{95968, 0x7000000},
	{95976, 0xE0000000},
	/* 1737 */
	{27979, 0xFFFFFFF},
	/* 1738 */
	{27990, 0xFFFFFFFC},
	/* 1739 */
	{28004, 0xFFFF},
	/* 1740 */
	{28018, 0xFFFFF},
	/* 1741 */
	{95985, 0xFFFFF},
	/* 1742 */
	{1331, 0x3},
	/* 1743 */
	{28168, 0x1},
	/* 1744 */
	{95998, 0x1},
	{96012, 0x2},
	{96029, 0x4},
	{96045, 0x8},
	{96060, 0x10},
	{96079, 0x20},
	{96097, 0x40},
	{96118, 0x80},
	/* 1752 */
	{96139, 0x1},
	{96155, 0x2},
	{96171, 0x40},
	{96189, 0x80},
	{96207, 0x100},
	{96225, 0x200},
	{96243, 0x400},
	{96261, 0x800},
	{96279, 0x1000},
	{96297, 0x2000},
	{96315, 0x4000},
	{96332, 0x80000},
	{96348, 0x200000},
	/* 1765 */
	{96364, 0xFF},
	{1331, 0x80000000},
	/* 1767 */
	{96382, 0xF},
	{96394, 0xF0},
	{96403, 0xF00},
	{96412, 0xF000},
	{96422, 0x30000},
	{96432, 0xC0000},
	{10218, 0x100000},
	{10701, 0xFFE00000},
	/* 1775 */
	{96439, 0xFF},
	{96403, 0xFF00},
	{96394, 0xFF0000},
	{96454, 0x20000000},
	{96474, 0x40000000},
	{96500, 0x80000000},
	/* 1781 */
	{18800, 0x3F, 22, 36290},
	/* 1782 */
	{38, 0xFFFF},
	/* 1783 */
	{96520, 0x1FF},
	{96586, 0x600, 4, 36536},
	/* 1785 */
	{89469, 0xFFFF},
	{89484, 0x10000},
	{89503, 0x20000},
	{89517, 0x40000},
	{89536, 0x80000},
	{89550, 0x100000},
	{96606, 0x200000},
	{96624, 0x400000},
	{96640, 0x800000},
	/* 1794 */
	{96652, 0x1FF},
	{96666, 0x3FE00},
	{96680, 0x40000},
	{96698, 0x80000},
	/* 1798 */
	{96715, 0x7},
	{96724, 0x78},
	{96733, 0x100},
	/* 1801 */
	{96743, 0x1},
	{96754, 0x7FE},
	/* 1803 */
	{96767, 0x1},
	{96781, 0x2},
	{96795, 0x4},
	/* 1806 */
	{29331, 0xFFFFFF},
	/* 1807 */
	{96809, 0xF},
	{96821, 0xFF00},
	/* 1809 */
	{456, 0xFFFF},
	{102, 0xFFFF0000},
	/* 1811 */
	{96835, 0x1},
	{96856, 0x2},
	/* 1813 */
	{96884, 0x3FFF},
	/* 1814 */
	{96892, 0x3FFF},
	/* 1815 */
	{2195, 0xFFFF},
	/* 1816 */
	{96900, 0x1},
	{96912, 0x2},
	{96924, 0x4},
	{30106, 0x8},
	{72617, 0x10},
	{30531, 0x10000},
	{96935, 0x60000},
	/* 1823 */
	{96948, 0x1},
	{73924, 0x2},
	/* 1825 */
	{25258, 0x7FFFFFFF},
	/* 1826 */
	{96952, 0x3F},
	{96957, 0xC0},
	{96965, 0x300},
	{96971, 0xFFFFFC00},
	/* 1830 */
	{30531, 0x1},
	{96432, 0xFFFFFFFE},
	/* 1832 */
	{8, 0xFFFF},
	{96432, 0xFFFF0000},
	/* 1834 */
	{38, 0xFFFF},
	{96432, 0xFFFF0000},
	/* 1836 */
	{30609, 0xFF},
	{96432, 0xFFFFFF00},
	/* 1838 */
	{30626, 0xFF},
	{96432, 0xFFFFFF00},
	/* 1840 */
	{1, 0xFF},
	{96432, 0xFFFFFF00},
	/* 1842 */
	{452, 0x3F},
	{96432, 0xFFFFFFC0},
	/* 1844 */
	{85076, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{92957, 0x4000},
	{96979, 0x8000},
	{96991, 0x7FF0000},
	{97002, 0x8000000},
	{97013, 0x10000000},
	{97023, 0x20000000},
	{96957, 0xC0000000},
	/* 1854 */
	{30830, 0xFFFF},
	{96432, 0xFFFF0000},
	/* 1856 */
	{452, 0xF},
	{96432, 0xFFFFFFF0},
	/* 1858 */
	{97030, 0xFFFF},
	{97041, 0xF0000},
	{97054, 0xF00000},
	{96432, 0x3F000000},
	{97062, 0x40000000},
	{10218, 0x80000000},
	/* 1864 */
	{29344, 0x7FFFFFFF},
	{30892, 0x80000000},
	/* 1866 */
	{31438, 0xFFFF},
	/* 1867 */
	{31442, 0xFFFF},
	{97071, 0xFFFF0000},
	/* 1869 */
	{97085, 0x3FF},
	{97094, 0xFFC00},
	{50369, 0xF00000},
	{97104, 0xF000000},
	{97115, 0xF0000000},
	/* 1874 */
	{97126, 0x3FF},
	{97136, 0xFFC00},
	{97146, 0xF000000},
	{97157, 0xF0000000},
	/* 1878 */
	{97377, 0xF, 6, 36540},
	{97612, 0xF0, 6, 36546},
	{97785, 0x300, 4, 36552},
	{97805, 0x400},
	/* 1882 */
	{452, 0x7},
	{74403, 0x40000000},
	{10218, 0x80000000},
	/* 1885 */
	{452, 0x1F},
	{74403, 0x40000000},
	{10218, 0x80000000},
	/* 1888 */
	{452, 0xF},
	{11568, 0x40000000},
	{10218, 0x80000000},
	/* 1891 */
	{452, 0x1F},
	{11568, 0x40000000},
	{10218, 0x80000000},
	/* 1894 */
	{11533, 0xFFFF},
	{11553, 0xFFFF0000},
	/* 1896 */
	{97827, 0x1},
	{97854, 0x2},
	{97881, 0x4},
	{1318, 0x100},
	/* 1900 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{97958, 0x2000},
	{97984, 0x4000},
	{98010, 0x10000},
	{98037, 0x20000},
	{98063, 0x40000},
	{98089, 0x80000},
	{98117, 0x100000},
	{98143, 0x200000},
	{98169, 0x400000},
	{98195, 0x1000000},
	{98222, 0x2000000},
	{98249, 0x4000000},
	{98276, 0x8000000},
	{98303, 0x10000000},
	{98329, 0x20000000},
	{98358, 0x40000000},
	{98384, 0x80000000},
	/* 1920 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{97958, 0x1000},
	{97984, 0x2000},
	{98010, 0x8000},
	{98037, 0x10000},
	{98117, 0x20000},
	{98143, 0x40000},
	{98063, 0x100000},
	{98222, 0x200000},
	{98384, 0x400000},
	{98411, 0x800000},
	{98276, 0x1000000},
	{98440, 0x2000000},
	/* 1935 */
	{98411, 0x2},
	{98469, 0x4},
	{98498, 0x8},
	{98526, 0x10},
	{98552, 0x20},
	{98578, 0x40},
	{98605, 0x80},
	{98440, 0x100},
	/* 1943 */
	{98632, 0x3FF},
	{97094, 0xFFC00},
	{98642, 0xF00000},
	{98652, 0xF000000},
	{98663, 0xF0000000},
	/* 1948 */
	{97126, 0x3FF},
	{97136, 0xFFC00},
	{98674, 0xF000000},
	{98685, 0xF0000000},
	/* 1952 */
	{98632, 0x3FF},
	{98696, 0xF0000000},
	/* 1954 */
	{97085, 0x3FF},
	{97094, 0xFFC00},
	{98642, 0xF00000},
	{98663, 0xF000000},
	{98696, 0xF0000000},
	/* 1959 */
	{97126, 0x3FF},
	{97136, 0xFFC00},
	{98685, 0xF000000},
	{98674, 0xF0000000},
	/* 1963 */
	{98706, 0xF},
	{98715, 0xF0},
	{98724, 0xF00},
	{98733, 0xF000},
	{98742, 0xF0000},
	{98751, 0xF00000},
	{98760, 0xF000000},
	{98769, 0xF0000000},
	/* 1971 */
	{97085, 0x1FF},
	{98778, 0xF000},
	{50369, 0xF00000},
	{98696, 0xF0000000},
	/* 1975 */
	{59979, 0x1},
	{90096, 0x2, 4, 36416},
	{90031, 0x4, 2, 36414},
	{20094, 0x8, 4, 36410},
	{89949, 0x10, 2, 36408},
	{89918, 0x20, 4, 36404},
	{98792, 0x40},
	{98798, 0x300},
	{98808, 0x2000},
	/* 1984 */
	{98822, 0x1},
	/* 1985 */
	{98831, 0x3},
	{98845, 0xC},
	{98859, 0x30},
	{98873, 0xC0},
	{98887, 0xF00},
	{98902, 0xF000},
	{98917, 0xF0000},
	{98932, 0xF00000},
	/* 1993 */
	{37183, 0x3FF},
	{98947, 0xFFC00},
	{98642, 0xF00000},
	/* 1996 */
	{98967, 0x3FF},
	{98987, 0xFFC00},
	/* 1998 */
	{97085, 0xFF},
	{97094, 0x3FC00},
	{98642, 0xF00000},
	{98663, 0xF000000},
	{98696, 0xF0000000},
	/* 2003 */
	{97126, 0xFF},
	{97136, 0x3FC00},
	{98685, 0xF000000},
	{98674, 0xF0000000},
	/* 2007 */
	{97085, 0xFF},
	{98642, 0xF00000},
	{98696, 0xF0000000},
	/* 2010 */
	{97085, 0x3FF},
	{98642, 0xF00000},
	{98696, 0xF0000000},
	/* 2013 */
	{99007, 0x1},
	{99242, 0xE, 6, 36556},
	{99256, 0x10},
	{99277, 0x3E0},
	{99295, 0x400},
	{99380, 0x800, 2, 36562},
	{99397, 0x1000},
	{99415, 0xE000},
	{99430, 0x20000},
	{99456, 0x1C0000},
	{99479, 0x200000},
	{99507, 0xC00000},
	/* 2025 */
	{97085, 0x1FF},
	{97094, 0x7FC00},
	{98642, 0xF00000},
	{98663, 0xF000000},
	{98696, 0xF0000000},
	/* 2030 */
	{97126, 0x1FF},
	{97136, 0x7FC00},
	{98685, 0xF000000},
	{98674, 0xF0000000},
	/* 2034 */
	{97085, 0x1FF},
	{98696, 0xF0000000},
	/* 2036 */
	{69952, 0xFFF},
	{99532, 0x3000},
	{10701, 0xC000},
	{99550, 0xFFFF0000},
	/* 2040 */
	{40485, 0xFFFF},
	{10701, 0xFFFF0000},
	/* 2042 */
	{40532, 0xFF},
	{69952, 0x700},
	{99574, 0xF800},
	{99590, 0x1F0000},
	{99603, 0x3E00000},
	{99616, 0x7C000000},
	{10701, 0x80000000},
	/* 2049 */
	{99629, 0xFF},
	{10701, 0xFFFFFF00},
	/* 2051 */
	{99651, 0x1FF},
	{10701, 0xFFFFFE00},
	/* 2053 */
	{99651, 0xFF},
	{10701, 0xFFFFFF00},
	/* 2055 */
	{40706, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2057 */
	{40731, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2059 */
	{40759, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2061 */
	{40787, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2063 */
	{40810, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2065 */
	{99668, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2067 */
	{10701, 0x1F},
	{99673, 0xFFFFFFE0},
	/* 2069 */
	{99692, 0x7F},
	{10701, 0xFFFFFF80},
	/* 2071 */
	{99692, 0x1FF},
	{10701, 0xFFFFFE00},
	/* 2073 */
	{99668, 0xFF},
	{10701, 0xFFFFFF00},
	/* 2075 */
	{99697, 0xFF},
	{99718, 0x100},
	{99728, 0x200},
	{99736, 0x400},
	{99750, 0x800},
	{99761, 0x1000},
	{99780, 0x2000},
	{99804, 0x4000},
	{99818, 0x8000},
	{10701, 0xFFFF0000},
	/* 2085 */
	{99828, 0x1},
	{99852, 0x2},
	{99876, 0x4},
	{99893, 0x8},
	{99910, 0x10},
	{99929, 0x20},
	{99946, 0x3C0},
	{10701, 0xFFFFFC00},
	/* 2093 */
	{99961, 0x1},
	{99973, 0x2},
	{99985, 0x4},
	{99995, 0x8},
	{100016, 0x10},
	{100033, 0x20},
	{100050, 0x40},
	{10701, 0xFFFFFF80},
	/* 2101 */
	{100074, 0xFFFF},
	{10701, 0xFFFF0000},
	/* 2103 */
	{100084, 0xFF},
	{10701, 0xFFFFFF00},
	/* 2105 */
	{100101, 0x7FFFF},
	{10701, 0xFFF80000},
	/* 2107 */
	{99590, 0xFF},
	{99603, 0xFF00},
	{99616, 0xFF0000},
	{100116, 0xFF000000},
	/* 2111 */
	{40532, 0xFF},
	{99574, 0xFF00},
	{10701, 0xFFFF0000},
	/* 2114 */
	{100129, 0x1},
	/* 2115 */
	{100153, 0x1},
	/* 2116 */
	{97377, 0x7, 6, 36540},
	{97805, 0x400},
	/* 2118 */
	{37183, 0xFF},
	/* 2119 */
	{10218, 0x1},
	{100171, 0x2},
	{19281, 0x4},
	{10701, 0xFFFFFFF8},
	/* 2123 */
	{100183, 0xF},
	{100188, 0x30},
	{10701, 0xFFFFFFC0},
	/* 2126 */
	{100195, 0x1},
	/* 2127 */
	{100215, 0x3},
	{100239, 0xC},
	{100263, 0x30},
	{100278, 0xC0},
	{100302, 0x300},
	{100326, 0x3C00},
	{100343, 0x7C000},
	{100361, 0x1F80000},
	{100397, 0x2000000},
	{100413, 0x4000000},
	/* 2137 */
	{97085, 0xFF},
	{100431, 0xFF00},
	{98696, 0xF000000},
	{10218, 0x10000000},
	{11568, 0x20000000},
	/* 2142 */
	{100444, 0xF},
	{100464, 0xFF00},
	{100478, 0xFF0000},
	{100491, 0x1000000},
	{100502, 0x2000000},
	{100512, 0x4000000},
	/* 2148 */
	{97085, 0x1FF},
	{98696, 0xF000000},
	{100533, 0xF0000000},
	/* 2151 */
	{97085, 0x3FF},
	{100543, 0xF0000000},
	/* 2153 */
	{95960, 0xF00, 6, 36564},
	{100595, 0x10000},
	{100607, 0x100000},
	{100622, 0xC0000000, 4, 36570},
	/* 2157 */
	{100633, 0xFFFFF},
	{100641, 0x100000},
	{100647, 0x200000},
	{59201, 0x800000},
	/* 2161 */
	{43236, 0xFFFFFFFF},
	/* 2162 */
	{26926, 0xFFFF},
	{95960, 0x300000, 4, 36574},
	{100670, 0x8000000, 2, 36570},
	{100692, 0x60000000, 4, 36578},
	{100700, 0x80000000},
	/* 2167 */
	{43120, 0xFFFFFFFF},
	/* 2168 */
	{95625, 0x3FFFFFF},
	{95636, 0x4000000, 2, 36582},
	{95640, 0x8000000, 2, 36582},
	{95644, 0x10000000, 2, 36584},
	{95649, 0x20000000, 2, 36584},
	{95654, 0x40000000},
	{100738, 0x80000000},
	/* 2175 */
	{89353, 0x3F},
	{100757, 0xF00},
	{100769, 0x1000},
	{100776, 0x2000},
	{100784, 0x4000},
	{100792, 0x8000},
	{100800, 0x10000},
	{100823, 0x60000, 4, 36586},
	{100848, 0x80000},
	{100860, 0x100000},
	{100868, 0x200000},
	{100912, 0xC00000, 3, 36590},
	/* 2187 */
	{100670, 0x1, 2, 36570},
	{95256, 0x6000},
	{95960, 0x300000, 4, 36574},
	{95296, 0x6000000},
	{100692, 0x60000000, 4, 36578},
	{100700, 0x80000000},
	/* 2193 */
	{100957, 0x3, 4, 36593},
	{100973, 0xC, 4, 36597},
	{100769, 0x10},
	{100776, 0x20},
	{100998, 0x40},
	{101005, 0x80},
	{100784, 0x100},
	{100792, 0x200},
	{100800, 0x400},
	{100823, 0x1800, 4, 36586},
	{100848, 0x2000},
	{100860, 0x4000},
	{100868, 0x8000},
	{100912, 0x30000, 3, 36590},
	{101013, 0x40000},
	/* 2208 */
	{101025, 0xFFFFF},
	/* 2209 */
	{59516, 0x1FF, 257, 0},
	{59521, 0x400},
	{59529, 0x800},
	{59542, 0x7000},
	{59550, 0x8000},
	{59561, 0xF0000},
	{59572, 0xF00000},
	{59588, 0x1000000},
	{101035, 0x10000000},
	{59614, 0xE0000000},
	/* 2219 */
	{59773, 0xF},
	{59780, 0x70},
	{59788, 0x80},
	{59802, 0xF00},
	{59811, 0x7000},
	{59838, 0xC00000},
	{59848, 0x1000000},
	{59874, 0xFC000000},
	/* 2227 */
	{43310, 0xFFFFF},
	/* 2228 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60310, 0x4000},
	{60325, 0x8000},
	{60336, 0x10000},
	{60344, 0x20000},
	{60353, 0x40000},
	{101045, 0x80000},
	{60385, 0x100000},
	{60398, 0x200000},
	{60408, 0x400000},
	{60425, 0x800000},
	{101065, 0x1000000},
	{101082, 0x2000000},
	{60442, 0x4000000},
	{60451, 0x8000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	{60487, 0x80000000},
	/* 2257 */
	{60498, 0xF},
	{60537, 0x80},
	{60560, 0x100},
	{60583, 0x200},
	{60602, 0x1000},
	{60611, 0x2000},
	{60620, 0x4000},
	{60628, 0x8000},
	{60637, 0x10000},
	{60652, 0x100000},
	{60660, 0x200000},
	{60668, 0x400000},
	{60677, 0x800000},
	{60686, 0x1000000},
	{60694, 0x2000000},
	{60702, 0x4000000},
	{60710, 0x10000000},
	{60452, 0x20000000},
	{60728, 0x40000000},
	{60736, 0x80000000},
	/* 2277 */
	{43324, 0xFFFF},
	/* 2278 */
	{63892, 0x7FF, 2049, 257},
	{101099, 0x1000},
	{64054, 0xFF0000, 129, 2306},
	{64066, 0x3000000},
	{101124, 0x1C000000},
	{64079, 0x80000000},
	/* 2284 */
	{1318, 0x3},
	{64094, 0x4},
	{64103, 0x8},
	{64114, 0x10},
	{64127, 0x20},
	{53862, 0x1C0},
	{64141, 0x200},
	{64154, 0x400},
	{64167, 0x800},
	{64179, 0x1000},
	{64197, 0x2000},
	{64208, 0xC000},
	{64223, 0x30000},
	{64231, 0x40000},
	{64250, 0x80000},
	{101136, 0x700000},
	{101151, 0x10000000},
	{101174, 0x20000000},
	{64267, 0x40000000},
	{64279, 0x80000000},
	/* 2304 */
	{64293, 0xFFF},
	{64308, 0xFFF000},
	{64320, 0x1000000},
	{60331, 0x2000000},
	{64328, 0x4000000},
	{64348, 0x8000000},
	{101190, 0xF0000000},
	/* 2311 */
	{101201, 0x1},
	{101211, 0x2},
	{101221, 0x10},
	/* 2314 */
	{64494, 0x7},
	{64504, 0x38},
	{64514, 0x1C0},
	{64524, 0xE00},
	{17638, 0x7F000, 293, 2468},
	{68761, 0x600000},
	{68774, 0x800000},
	{68789, 0x1000000},
	{101249, 0xC000000},
	{68895, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2325 */
	{69281, 0x1FFFFF},
	{69300, 0xE00000},
	{69319, 0x1000000},
	{69341, 0x2000000},
	{101261, 0x4000000},
	{69379, 0x8000000},
	{69396, 0x10000000},
	{69414, 0x20000000},
	{69430, 0xC0000000},
	/* 2334 */
	{69451, 0x7},
	{69461, 0x38},
	{69482, 0xC0},
	{101284, 0x700},
	{69503, 0x180000},
	{69522, 0xC000000},
	/* 2340 */
	{18784, 0x1FFF},
	{101293, 0x2000},
	{71265, 0x1FFF0000},
	/* 2343 */
	{71276, 0xF},
	{71288, 0xF0},
	{71296, 0xFFF00},
	{71309, 0x700000},
	{71318, 0x800000},
	{71333, 0x2000000},
	{71348, 0x4000000},
	{75168, 0x80000000},
	/* 2351 */
	{71360, 0xFF},
	{101249, 0x300},
	{71376, 0x400},
	{71388, 0x18000},
	{71416, 0x60000},
	{71442, 0x80000},
	{71460, 0x100000},
	{71482, 0x200000},
	{71497, 0x400000},
	{71513, 0x800000},
	{71529, 0xFF000000},
	/* 2362 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{71702, 0x800000},
	{71712, 0x1000000},
	{71729, 0x2000000},
	{60051, 0x4000000},
	{101303, 0x8000000},
	{59322, 0x20000000},
	/* 2374 */
	{72984, 0x1},
	{73003, 0x2},
	{73024, 0x4},
	{73035, 0x8},
	{73048, 0x10},
	{73067, 0x20},
	{73092, 0x40},
	{73115, 0x80},
	{73129, 0xF00},
	{73141, 0x1000},
	{101322, 0x2000},
	/* 2385 */
	{74058, 0x3, 4, 3035},
	{74087, 0x1C},
	{74118, 0x20},
	{74154, 0x40},
	{74189, 0x80},
	{74217, 0x100},
	{74239, 0x200},
	{74257, 0x400},
	{74289, 0x800},
	{74410, 0x7000, 8, 3039},
	{74420, 0x38000},
	{74433, 0x1C0000},
	{74446, 0x200000},
	{74462, 0x400000},
	{74480, 0x800000},
	{74498, 0x2000000},
	{101340, 0x4000000},
	{101360, 0x18000000},
	/* 2403 */
	{101506, 0x7, 5, 36601},
	{101538, 0x30},
	{101558, 0xC0},
	/* 2406 */
	{75016, 0x3, 4, 3061},
	{75028, 0xC, 4, 3061},
	{75040, 0x30, 4, 3061},
	{75056, 0xC0, 4, 3061},
	{75126, 0x30000, 4, 3065},
	{75138, 0xC0000, 4, 3065},
	{75150, 0x300000, 4, 3065},
	{75166, 0x1000000},
	{75177, 0x2000000},
	{101578, 0x4000000},
	{101588, 0x8000000},
	{101598, 0x10000000},
	{101612, 0x20000000},
	/* 2419 */
	{10218, 0x1},
	{77709, 0x6},
	{69522, 0x60},
	{77751, 0x3000},
	{77758, 0x30000},
	{77772, 0x300000},
	/* 2425 */
	{77879, 0x3, 4, 3061},
	{77895, 0xC, 4, 3061},
	{77911, 0x30, 4, 3061},
	{77925, 0xC0, 4, 3061},
	{77941, 0x30000, 4, 3065},
	{77957, 0xC0000, 4, 3065},
	{77973, 0x300000, 4, 3065},
	{77987, 0xC00000, 4, 3065},
	{101627, 0x1000000},
	{101643, 0x2000000},
	{101659, 0x4000000},
	{101673, 0x8000000},
	{78003, 0x40000000},
	{78018, 0x80000000},
	/* 2439 */
	{879, 0x3F},
	{78788, 0x300},
	{78800, 0x400},
	{101689, 0x800},
	{78811, 0x1E000},
	{78820, 0x20000},
	{78834, 0x40000},
	{78838, 0x80000},
	{78855, 0x100000},
	{78873, 0x600000},
	{78891, 0x800000},
	{78911, 0x1000000},
	{78923, 0x2000000},
	/* 2452 */
	{879, 0x3F},
	{78788, 0x300},
	{78800, 0x400},
	{101689, 0x800},
	{78834, 0x40000},
	{78838, 0x80000},
	{78855, 0x100000},
	{78873, 0x600000},
	{78911, 0x1000000},
	{78923, 0x2000000},
	/* 2462 */
	{78935, 0x3E},
	{78951, 0x40},
	{78964, 0x80},
	{101703, 0x1F00},
	/* 2466 */
	{79485, 0x3F},
	{79506, 0x80},
	{79523, 0x100},
	{101721, 0x3E00},
	{79539, 0x4000},
	{79559, 0x8000},
	/* 2472 */
	{101737, 0x1},
	{101762, 0x2},
	{101787, 0x4},
	{101812, 0x8},
	{101837, 0x10},
	{101862, 0x20},
	{101887, 0x40},
	{101912, 0x80},
	/* 2480 */
	{80505, 0xF, 12, 36606},
	{80510, 0xF0, 12, 36606},
	{80515, 0xF00, 12, 36606},
	{80520, 0xF000, 12, 36606},
	{80525, 0xF0000, 12, 36606},
	{80530, 0xF00000, 12, 36606},
	{80535, 0xF000000, 12, 36606},
	{80540, 0xF0000000, 12, 36606},
	/* 2488 */
	{82412, 0x3, 4, 36007},
	{82458, 0xC, 2, 36011},
	{82469, 0x10},
	{82484, 0x20},
	{82492, 0x40},
	{82534, 0xE0000000},
	/* 2494 */
	{83025, 0x1},
	{101959, 0x2},
	{83043, 0x8},
	{1318, 0x70, 8, 36013},
	{82316, 0xFF0000, 256, 36021},
	/* 2499 */
	{84788, 0x1},
	{84804, 0x2},
	{84820, 0x4},
	{84836, 0x8},
	{84852, 0x10},
	{84868, 0x20},
	{84884, 0x40},
	{84900, 0x80},
	{84916, 0x100},
	{84932, 0x200},
	{84948, 0x400},
	{84964, 0x800},
	{84980, 0x1000},
	{84996, 0x2000},
	{85012, 0x4000},
	{85028, 0x8000},
	{85044, 0x10000},
	{85063, 0x20000},
	{85081, 0x40000},
	{85108, 0x80000},
	{85130, 0x100000},
	{85148, 0x200000},
	{85168, 0x400000},
	{85191, 0x800000},
	{85214, 0x1000000},
	{85239, 0x2000000},
	{85282, 0x8000000},
	{101982, 0x10000000},
	{101999, 0x20000000},
	{102024, 0x40000000},
	/* 2529 */
	{85984, 0x1},
	{86001, 0x2},
	{102050, 0x3FC},
	/* 2532 */
	{102069, 0x7, 5, 36601},
	{102095, 0x38, 5, 36601},
	{102124, 0x1C0, 5, 36601},
	{102149, 0xE00, 5, 36601},
	{102175, 0x2000},
	{102198, 0x4000},
	/* 2538 */
	{87134, 0x1},
	{87146, 0x2},
	{87167, 0x4},
	{87187, 0x8},
	{87233, 0x20},
	{87256, 0x40},
	/* 2544 */
	{214, 0x3, 3, 36326},
	{87977, 0xC, 4, 36329},
	{88057, 0x30, 4, 36333},
	{88117, 0xC0, 3, 36337},
	{88130, 0x100},
	{82484, 0x200},
	{88134, 0x400},
	{88143, 0x3800},
	{102225, 0x4000},
	/* 2553 */
	{89408, 0x2},
	{89442, 0x8},
	{89458, 0x10},
	{102250, 0x40},
	/* 2557 */
	{74808, 0x1},
	{89567, 0x2},
	{89578, 0x4},
	{89595, 0x8},
	{89612, 0x3F0},
	{89629, 0xFC00},
	{89646, 0x10000},
	{89670, 0x20000},
	{71447, 0x40000},
	{102328, 0x180000, 3, 36618},
	/* 2567 */
	{89918, 0x3, 4, 36404},
	{89949, 0x4, 2, 36408},
	{20094, 0x18, 4, 36410},
	{90031, 0x20, 2, 36414},
	{90096, 0xC0, 4, 36416},
	{90102, 0x100},
	{72337, 0x200},
	{90113, 0x400},
	{90133, 0x800},
	{90153, 0x1000},
	{90167, 0x2000},
	{90178, 0x4000},
	{90194, 0x78000},
	{90214, 0x180000},
	{90229, 0x200000},
	{90239, 0x400000},
	{90249, 0x800000},
	{90259, 0x1000000},
	{90274, 0x2000000},
	{102347, 0x4000000},
	/* 2587 */
	{91420, 0x7},
	{91437, 0x10},
	{91459, 0x1E000},
	{91475, 0x700000},
	{91496, 0x3000000},
	{91576, 0xC000000, 4, 36441},
	{102371, 0x10000000},
	{102396, 0x20000000},
	/* 2595 */
	{93395, 0x3, 4, 36472},
	{17638, 0x7C, 25, 36621},
	{69542, 0x80},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{83092, 0x2000},
	{73993, 0x4000},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94097, 0x80000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	{94370, 0x4000000},
	{94396, 0x8000000},
	{94422, 0x10000000},
	{94490, 0x60000000, 3, 36528},
	{102437, 0x80000000},
	/* 2614 */
	{78033, 0x1},
	{94664, 0x2},
	{71388, 0xC, 3, 36531},
	{94778, 0x10, 2, 36534},
	{71416, 0x60},
	{71513, 0x180},
	{94804, 0x200},
	{94827, 0x3C00},
	{94847, 0x3C000},
	{78149, 0x40000},
	{94869, 0x80000},
	{94902, 0x100000},
	{102448, 0x200000},
	{102468, 0x400000},
	/* 2628 */
	{94959, 0x1FFF},
	{94970, 0x2000},
	{94982, 0x7C000},
	{94996, 0xF80000},
	{95010, 0x3000000},
	{95024, 0x4000000},
	{68789, 0x38000000},
	{95043, 0x40000000},
	{102489, 0x80000000},
	/* 2637 */
	{102510, 0xFFFFFF},
	{10450, 0x7000000},
	{102516, 0x8000000},
	{1, 0x70000000},
	{102527, 0x80000000},
	/* 2642 */
	{102538, 0x1},
	{26669, 0xFFFFFFF8},
	/* 2644 */
	{95825, 0x1},
	{95839, 0x2},
	{102547, 0x8000},
	{95851, 0x10000},
	{95865, 0x1000000},
	/* 2649 */
	{95960, 0x30000},
	{102562, 0x300000},
	{102577, 0xC00000},
	{95968, 0x7000000},
	{95976, 0xE0000000},
	/* 2654 */
	{214, 0x3, 3, 36326},
	{102225, 0x4000},
	/* 2656 */
	{96520, 0x3FF},
	{96586, 0xC00, 4, 36536},
	/* 2658 */
	{101551, 0x3},
	{101571, 0x30},
	/* 2660 */
	{96900, 0x1},
	{96912, 0x2},
	{96924, 0x4},
	{30531, 0x10000},
	{96935, 0x60000},
	/* 2665 */
	{85076, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{92957, 0x4000},
	{96979, 0x8000},
	{96991, 0x7FF0000},
	{97002, 0x8000000},
	{97013, 0x10000000},
	{97023, 0x20000000},
	{102587, 0x40000000},
	{96957, 0x80000000},
	/* 2676 */
	{97085, 0x1FF},
	{50369, 0xF00000},
	{98696, 0xF0000000},
	/* 2679 */
	{59979, 0x1},
	{90096, 0x2, 4, 36416},
	{90031, 0x4, 2, 36414},
	{20094, 0x8, 4, 36410},
	{89949, 0x10, 2, 36408},
	{89918, 0x20, 4, 36404},
	{98792, 0x40},
	{98798, 0x300},
	{98808, 0x2000},
	{102599, 0x4000},
	{102621, 0x8000},
	{102643, 0x10000},
	{102665, 0x20000},
	{102687, 0x40000},
	{102709, 0x80000},
	/* 2694 */
	{99692, 0x7FF},
	{10701, 0xFFFFF800},
	/* 2696 */
	{99697, 0xFF},
	{99718, 0x100},
	{99728, 0x200},
	{99736, 0x400},
	{99750, 0x800},
	{99761, 0x1000},
	{99780, 0x2000},
	{99804, 0x4000},
	{99818, 0x8000},
	{102731, 0x10000},
	{102744, 0x20000},
	{102755, 0x40000},
	{102772, 0x80000},
	{102786, 0x100000},
	{102798, 0x200000},
	{102814, 0x400000},
	{10701, 0xFF800000},
	/* 2713 */
	{99828, 0x1},
	{99852, 0x2},
	{99876, 0x4},
	{102830, 0x8},
	{99946, 0xF0},
	{102850, 0x100},
	{102870, 0x200},
	{102885, 0x400},
	{10701, 0xFFFFF800},
	/* 2722 */
	{99961, 0x1},
	{102910, 0x2},
	{102933, 0x4},
	{100050, 0x8},
	{102947, 0x10},
	{99973, 0x20},
	{102974, 0x40},
	{99985, 0x80},
	{102989, 0x100},
	{99995, 0x200},
	{103002, 0x400},
	{100016, 0x800},
	{103026, 0x1000},
	{100033, 0x2000},
	{103046, 0x4000},
	{103066, 0x8000},
	{103083, 0x10000},
	{103103, 0x20000},
	{103120, 0x40000},
	/* 2741 */
	{879, 0xFFFF},
	{10701, 0xFFFF0000},
	/* 2743 */
	{103140, 0xFF},
	{103154, 0xFF00},
	{103177, 0xFF0000},
	{10701, 0xFF000000},
	/* 2747 */
	{103204, 0xFF},
	{103220, 0xFF00},
	{10701, 0xFFFF0000},
	/* 2750 */
	{103236, 0xFFFF},
	/* 2751 */
	{59152, 0xF},
	{59161, 0xF0},
	{59171, 0x100},
	{59182, 0x200},
	{59187, 0x400},
	{103243, 0x800},
	{59314, 0x1FF000, 257, 0},
	{103262, 0x200000},
	{59322, 0x800000},
	{59332, 0x8000000},
	/* 2761 */
	{59355, 0x1},
	{59359, 0x6},
	{59368, 0x18},
	{59378, 0x20},
	{59383, 0x40},
	{59391, 0x80},
	{59401, 0x100},
	{59412, 0x200},
	{59418, 0x400},
	{59423, 0x800},
	{59429, 0x1000},
	{59440, 0x2000},
	{59445, 0x4000},
	{59450, 0x8000},
	{59201, 0x10000},
	{59465, 0x20000},
	{59473, 0x40000},
	{59485, 0x80000},
	{103271, 0x400000},
	{59493, 0x800000},
	{103285, 0x1000000},
	{103294, 0x2000000},
	{103310, 0x4000000},
	{59504, 0x8000000},
	{43290, 0x10000000},
	{71741, 0x20000000},
	/* 2787 */
	{59516, 0x1FF, 257, 0},
	{59521, 0x400},
	{59529, 0x800},
	{59542, 0x7000},
	{59550, 0x8000},
	{103324, 0x10000},
	{103334, 0x20000},
	{103262, 0x40000},
	{103344, 0x80000},
	{103358, 0x100000},
	{101035, 0x10000000},
	/* 2798 */
	{59698, 0x1FF},
	{59708, 0xFF000},
	/* 2800 */
	{59780, 0x7},
	{59802, 0x3F0},
	{59773, 0xFC00},
	{59874, 0xFC000000},
	/* 2804 */
	{54575, 0x1F},
	{59622, 0x300},
	{59945, 0x3C00},
	{59952, 0x10000},
	{29204, 0x1C0000},
	{59614, 0xE0000000},
	/* 2810 */
	{60009, 0x3},
	{60041, 0x300},
	{60051, 0x400},
	{60064, 0x800},
	/* 2814 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60310, 0x4000},
	{60325, 0x8000},
	{60336, 0x10000},
	{60344, 0x20000},
	{60353, 0x40000},
	{101045, 0x80000},
	{60385, 0x100000},
	{60398, 0x200000},
	{60408, 0x400000},
	{60425, 0x800000},
	{60442, 0x4000000},
	{60451, 0x8000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	/* 2836 */
	{60498, 0xF},
	{103374, 0x40},
	{60537, 0x80},
	{60560, 0x100},
	{60583, 0x200},
	{60602, 0x1000},
	{60611, 0x2000},
	{60620, 0x4000},
	{60628, 0x8000},
	{60637, 0x10000},
	{60652, 0x100000},
	{60660, 0x200000},
	{60668, 0x400000},
	{60677, 0x800000},
	{60686, 0x1000000},
	{60694, 0x2000000},
	{60702, 0x4000000},
	{103390, 0x8000000},
	{60710, 0x10000000},
	{60452, 0x20000000},
	{60728, 0x40000000},
	{60736, 0x80000000},
	/* 2858 */
	{60602, 0x2},
	{60611, 0x4},
	{60747, 0x8},
	{60451, 0x10},
	{60758, 0x20},
	{103401, 0x40},
	{60470, 0x80},
	{103411, 0x100},
	{60344, 0x200000},
	{60677, 0x400000},
	{60694, 0x1000000},
	{60620, 0x2000000},
	{60652, 0x4000000},
	{60668, 0x8000000},
	{60686, 0x20000000},
	{60702, 0x40000000},
	{60728, 0x80000000},
	/* 2875 */
	{60769, 0x20},
	{60829, 0x80},
	{60858, 0x100},
	{60878, 0x200},
	{60938, 0x2000},
	{60946, 0x4000},
	{60954, 0x8000},
	{60758, 0x10000},
	{103411, 0x2000000},
	{60470, 0x4000000},
	{103401, 0x8000000},
	{60965, 0x10000000},
	{60979, 0x20000000},
	{60747, 0x40000000},
	{60988, 0x80000000},
	/* 2890 */
	{103421, 0x7F},
	/* 2891 */
	{60997, 0x1},
	{61007, 0x2},
	{61017, 0x4},
	{61026, 0x8},
	{61035, 0x10},
	{61046, 0x20},
	{61057, 0x40},
	{61067, 0x80},
	{61077, 0x400},
	{61087, 0x800},
	{61104, 0x1000},
	{61112, 0x2000},
	{61125, 0x4000},
	{61143, 0x8000},
	{61154, 0x10000},
	{61163, 0x20000},
	{61184, 0x40000},
	{61195, 0x80000},
	{103432, 0x100000},
	{103452, 0x200000},
	{61222, 0x20000000},
	{61235, 0x40000000},
	{60469, 0x80000000},
	/* 2914 */
	{61248, 0x1},
	{103472, 0x2},
	{61283, 0x4},
	{61299, 0x8},
	{61317, 0x10},
	{61337, 0x20},
	{61356, 0x40},
	{61375, 0x80},
	{61388, 0x100},
	{61402, 0x200},
	{61426, 0x400},
	{61442, 0x800},
	{61458, 0x1000},
	{61474, 0x2000},
	{61490, 0x10000},
	{103492, 0x20000},
	{61525, 0x40000},
	{61541, 0x80000},
	{61559, 0x100000},
	{61579, 0x200000},
	{61598, 0x400000},
	{61617, 0x800000},
	{61630, 0x1000000},
	{61644, 0x2000000},
	{61668, 0x4000000},
	{61684, 0x8000000},
	{61700, 0x10000000},
	{61716, 0x20000000},
	/* 2942 */
	{61732, 0x8},
	{61751, 0x10},
	{61771, 0x40},
	{63094, 0x80},
	{61790, 0x100},
	{61811, 0x200},
	{61829, 0x400},
	{61852, 0x2000},
	{61874, 0x10000},
	{61895, 0x20000},
	{61913, 0x40000},
	{61936, 0x200000},
	{61958, 0x400000},
	{61982, 0x800000},
	{62006, 0x1000000},
	{62029, 0x2000000},
	/* 2958 */
	{43324, 0x3FFFF},
	/* 2959 */
	{103512, 0x1},
	{103529, 0x2},
	{63384, 0x1000},
	{63406, 0x4000},
	{63431, 0x20000},
	{63452, 0x40000},
	{63476, 0x400000},
	{63503, 0x800000},
	{63528, 0x1000000},
	{63551, 0x8000000},
	{63571, 0x40000000},
	/* 2970 */
	{64449, 0xFFFF},
	{20011, 0x3FFF0000},
	{64479, 0xC0000000},
	/* 2973 */
	{64494, 0x7},
	{64504, 0x38},
	{64514, 0x1C0},
	{64524, 0xE00},
	{17638, 0x3F000, 229, 36646},
	{68761, 0x600000},
	{68774, 0x800000},
	{101249, 0xC000000},
	{68895, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2983 */
	{69127, 0x3FFF},
	{69136, 0xFC000},
	{69149, 0x300000},
	{69163, 0xC00000},
	{69177, 0x3000000},
	{69186, 0xC000000},
	{69216, 0x20000000},
	{107100, 0x40000000},
	/* 2991 */
	{69246, 0x3FFC0000},
	{69263, 0xC0000000},
	/* 2993 */
	{64449, 0xFF},
	{101249, 0x6000},
	{75168, 0x8000},
	{71288, 0xF0000},
	{17638, 0xFF00000, 229, 36646},
	{71110, 0xC0000000},
	/* 2999 */
	{71276, 0xF},
	{71296, 0xFFF00},
	{71309, 0x700000},
	{71318, 0x800000},
	{71348, 0x4000000},
	{107110, 0xF8000000},
	/* 3005 */
	{107121, 0x7F},
	{71376, 0x400},
	{107132, 0x7800},
	{71388, 0x18000},
	{71416, 0x60000},
	{71442, 0x80000},
	{71460, 0x100000},
	{71482, 0x200000},
	{71497, 0x400000},
	{71513, 0x800000},
	{71529, 0xFF000000},
	/* 3016 */
	{71550, 0xFFFF},
	{107154, 0x3F0000},
	{107169, 0x20000000},
	{107183, 0x40000000},
	{107195, 0x80000000},
	/* 3021 */
	{71550, 0xFFFF},
	{71556, 0x3F0000},
	{107204, 0xC00000},
	/* 3024 */
	{71550, 0x1},
	{10701, 0x3FFE},
	{107219, 0x4000},
	{107234, 0x8000},
	{72366, 0x7F0000},
	{107154, 0x1F800000},
	{107169, 0x20000000},
	{107183, 0x40000000},
	{107195, 0x80000000},
	/* 3033 */
	{107250, 0xFF},
	{107271, 0xFF00},
	{107292, 0xFF0000},
	{107313, 0xFF000000},
	/* 3037 */
	{107338, 0x1FF},
	{107352, 0x3FE00},
	/* 3039 */
	{72479, 0x1},
	{72497, 0x2},
	{72511, 0x4},
	{72530, 0x8},
	{72550, 0x10},
	{72570, 0x20},
	{72592, 0x40},
	{72603, 0x400},
	{72621, 0x800},
	{10701, 0x1000},
	{72639, 0x2000},
	{72653, 0x4000},
	{72661, 0x8000},
	{107366, 0x10000},
	{107380, 0x20000},
	/* 3054 */
	{72853, 0xFFF},
	{72859, 0x7FFF000},
	/* 3056 */
	{72868, 0x7},
	{72878, 0x8},
	{72888, 0x10},
	{72898, 0x1FFE0},
	/* 3060 */
	{71863, 0xF},
	{107154, 0x3F0},
	{107169, 0x400},
	{107183, 0x800},
	{107195, 0x80000000},
	/* 3065 */
	{107403, 0xFFFF},
	{107413, 0xFFFF0000},
	/* 3067 */
	{47492, 0x3FF},
	/* 3068 */
	{72984, 0x1},
	{73003, 0x2},
	{73024, 0x4},
	{73035, 0x8},
	{73048, 0x10},
	{73067, 0x20},
	{73092, 0x40},
	{73115, 0x80},
	{73129, 0xF00},
	{73141, 0x1000},
	{101322, 0x4000},
	{107489, 0x30000, 4, 36875},
	{107499, 0x40000},
	{107515, 0x80000},
	{107534, 0xF00000},
	/* 3083 */
	{73511, 0x3, 4, 3027},
	{73528, 0xC, 4, 3027},
	{73546, 0x30, 4, 3027},
	{73564, 0x40},
	{73585, 0x80},
	{73600, 0x100},
	{73621, 0x200},
	{73639, 0x400},
	{73656, 0x800},
	{73669, 0x1000},
	{73688, 0x6000, 4, 3027},
	{73731, 0x10000},
	{73754, 0x20000},
	{73771, 0x40000},
	{73856, 0x180000, 4, 3031},
	{73875, 0x3E00000},
	{73892, 0x4000000},
	{73916, 0x8000000},
	{73930, 0x10000000},
	{73950, 0x20000000},
	{73964, 0x40000000},
	{73984, 0x80000000},
	/* 3105 */
	{74058, 0x3, 4, 3035},
	{74087, 0x1C},
	{74118, 0x20},
	{74154, 0x40},
	{74189, 0x80},
	{74217, 0x100},
	{74239, 0x200},
	{74257, 0x400},
	{74289, 0x800},
	{74410, 0x7000, 8, 3039},
	{74420, 0x38000},
	{74433, 0x1C0000},
	{74446, 0x200000},
	{74462, 0x400000},
	{74480, 0x800000},
	{74498, 0x2000000},
	{101360, 0x18000000},
	{107560, 0x20000000},
	/* 3123 */
	{74618, 0xF},
	{74626, 0xF0},
	{74634, 0x1F00},
	{74642, 0x6000},
	{74650, 0x18000},
	{74658, 0x60000},
	{74666, 0x180000},
	{107572, 0xF0000000},
	/* 3131 */
	{75016, 0x3, 4, 36879},
	{75028, 0xC, 4, 36879},
	{75040, 0x30, 4, 36879},
	{75056, 0xC0, 4, 36879},
	{75126, 0x30000, 4, 36883},
	{75138, 0xC0000, 4, 36883},
	{75150, 0x300000, 4, 36883},
	{75166, 0x1000000},
	{75177, 0x2000000},
	{101578, 0x4000000},
	{101588, 0x8000000},
	{101598, 0x10000000},
	{101612, 0x20000000},
	/* 3144 */
	{10218, 0x1},
	{77751, 0x3000},
	{77758, 0x30000},
	{77772, 0x300000},
	/* 3148 */
	{101506, 0x7, 5, 36601},
	{43692, 0xF0, 16, 36887},
	{107997, 0x1000},
	{108016, 0x2000},
	{108044, 0x4000},
	/* 3153 */
	{74526, 0x7FF},
	{59106, 0x7FF0000},
	/* 3155 */
	{108071, 0x1},
	{108083, 0x2},
	{108095, 0xC},
	{108108, 0x30},
	{108121, 0xC0},
	{108134, 0x100},
	{108149, 0x200},
	{108164, 0x400},
	{108174, 0x800},
	{108184, 0x1000},
	{108200, 0x2000},
	/* 3166 */
	{94926, 0xFF},
	{108216, 0xF0000000},
	/* 3168 */
	{77911, 0x3, 4, 36879},
	{77925, 0xC, 4, 36879},
	{77973, 0x300000, 4, 36883},
	{77987, 0xC00000, 4, 36883},
	{101659, 0x4000000},
	{101673, 0x8000000},
	{78018, 0x80000000},
	/* 3175 */
	{108231, 0x1},
	{108259, 0x7C},
	{78089, 0x100},
	{78118, 0x200},
	{78149, 0x400},
	{78177, 0x1000},
	{78205, 0x2000},
	{78235, 0x4000},
	/* 3183 */
	{108289, 0xF},
	{108301, 0xF0},
	/* 3185 */
	{879, 0x3F},
	{78788, 0x300},
	{78800, 0x400},
	{101689, 0x800},
	{108311, 0x1000},
	{78820, 0x20000},
	{78834, 0x40000},
	{78838, 0x80000},
	{78855, 0x100000},
	{78873, 0x600000},
	{78891, 0x800000},
	{78911, 0x1000000},
	{78923, 0x2000000},
	/* 3198 */
	{879, 0x3F},
	{78788, 0x300},
	{78800, 0x400},
	{101689, 0x800},
	{108311, 0x1000},
	{78834, 0x40000},
	{78838, 0x80000},
	{78855, 0x100000},
	{78873, 0x600000},
	{78911, 0x1000000},
	{78923, 0x2000000},
	/* 3209 */
	{78935, 0x3E},
	{78964, 0x80},
	{101703, 0x1F00},
	/* 3212 */
	{79485, 0x3F},
	{79496, 0x40},
	{79506, 0x80},
	{79523, 0x100},
	{101721, 0x3E00},
	{79539, 0x4000},
	{79559, 0x8000},
	/* 3219 */
	{80505, 0xF, 14, 36903},
	{80510, 0xF0, 14, 36903},
	{80515, 0xF00, 14, 36903},
	{80520, 0xF000, 14, 36903},
	{80525, 0xF0000, 14, 36903},
	{80530, 0xF00000, 14, 36903},
	{80535, 0xF000000, 14, 36903},
	{80540, 0xF0000000, 14, 36903},
	/* 3227 */
	{82135, 0x1F, 19, 36917},
	{81637, 0xE0, 5, 36002},
	{82240, 0x1F00, 19, 36917},
	{82256, 0x1F0000, 19, 36917},
	{81680, 0xE00000, 5, 36002},
	{82271, 0x1F000000, 19, 36917},
	{82287, 0x20000000},
	{10218, 0x40000000},
	{82308, 0x80000000},
	/* 3236 */
	{83025, 0x1},
	{101959, 0x2},
	{83043, 0x8},
	{1318, 0x70, 5, 36936},
	{82316, 0xFF0000, 256, 36021},
	/* 3241 */
	{83463, 0x1},
	{83479, 0x2},
	{83510, 0x4},
	{73577, 0x30, 4, 36277},
	{83589, 0x40},
	{83601, 0x80},
	{83625, 0x100},
	{83644, 0x200},
	{83662, 0x400},
	{83675, 0x800},
	{83697, 0x1000},
	{83787, 0x6000, 4, 36281},
	{83809, 0x8000},
	{83827, 0x10000},
	{83902, 0x800000},
	{108377, 0x1000000},
	{108395, 0x2000000},
	{108426, 0x1C000000},
	/* 3259 */
	{84788, 0x1},
	{84804, 0x2},
	{84820, 0x4},
	{84836, 0x8},
	{84852, 0x10},
	{84868, 0x20},
	{84884, 0x40},
	{84900, 0x80},
	{84916, 0x100},
	{84932, 0x200},
	{84948, 0x400},
	{84964, 0x800},
	{84980, 0x1000},
	{84996, 0x2000},
	{85012, 0x4000},
	{85028, 0x8000},
	{85044, 0x10000},
	{85063, 0x20000},
	{85081, 0x40000},
	{85108, 0x80000},
	{85130, 0x100000},
	{85148, 0x200000},
	{85168, 0x400000},
	{85191, 0x800000},
	{85214, 0x1000000},
	{85282, 0x8000000},
	{101982, 0x10000000},
	{101999, 0x20000000},
	{102024, 0x40000000},
	/* 3288 */
	{89353, 0x3F, 64, 36941},
	{64454, 0x7FFFC00},
	{89364, 0x8000000},
	/* 3291 */
	{89918, 0x3, 4, 36404},
	{89949, 0x4, 2, 36408},
	{20094, 0x18, 4, 36410},
	{90031, 0x20, 2, 36414},
	{90096, 0xC0, 4, 36416},
	{90102, 0x100},
	{90153, 0x1000},
	{90167, 0x2000},
	{90178, 0x4000},
	{90194, 0x78000},
	{90214, 0x180000},
	{90229, 0x200000},
	{90239, 0x400000},
	{90249, 0x800000},
	{90259, 0x1000000},
	{90274, 0x2000000},
	{102347, 0x4000000},
	/* 3308 */
	{220, 0x3, 3, 36420},
	{90428, 0x1C, 4, 36423},
	{90505, 0xE0, 4, 36427},
	{108474, 0x200},
	{90545, 0x3C00},
	{90567, 0x4000},
	{88117, 0x18000, 3, 36337},
	{90601, 0x60000, 4, 36431},
	{90660, 0x80000, 2, 37005},
	{90712, 0x100000, 2, 37007},
	{88143, 0x3800000},
	/* 3319 */
	{92114, 0x3},
	{71802, 0x4},
	{71824, 0x8},
	{92143, 0x60},
	{108545, 0x80},
	/* 3324 */
	{93242, 0x7FF},
	{108572, 0x1000},
	{108606, 0x2000},
	{108626, 0x4000},
	{93263, 0xFF0000},
	{108649, 0xFF000000},
	/* 3330 */
	{108672, 0x1},
	{108696, 0x2},
	{108720, 0x4},
	{108763, 0x8},
	{108788, 0x70},
	{108816, 0x780},
	{108844, 0x800},
	{108856, 0x1000},
	{108881, 0x1FE000},
	{108900, 0x200000},
	/* 3340 */
	{17638, 0x1F, 25, 36621},
	{69542, 0x80},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	/* 3350 */
	{94576, 0x3},
	{94590, 0x4},
	{108940, 0x8},
	{94634, 0x10},
	{108966, 0x20},
	/* 3355 */
	{108231, 0x1},
	{109003, 0x2},
	{71388, 0xC, 3, 36531},
	{94778, 0x10, 2, 36534},
	{71416, 0x60},
	{71513, 0x180},
	{94804, 0x200},
	{94902, 0x400},
	{78149, 0x40000},
	{94869, 0x80000},
	{102448, 0x200000},
	{109033, 0x400000},
	{102468, 0x800000},
	{109045, 0x1000000},
	{109071, 0x2000000},
	{109106, 0x4000000},
	{109136, 0x38000000},
	/* 3372 */
	{94959, 0x1FFF},
	{94970, 0x2000},
	{94982, 0x7C000},
	{95010, 0x3000000},
	{95043, 0x40000000},
	/* 3377 */
	{95148, 0xFFFF},
	{95160, 0x30000},
	{87359, 0x40000},
	{109151, 0x80000},
	{95076, 0x6000000},
	{26989, 0xE0000000},
	/* 3383 */
	{26557, 0xFFFF},
	{109162, 0x20000},
	{109176, 0x40000},
	{95076, 0xC00000},
	{10448, 0xF000000},
	{54785, 0x30000000},
	{109184, 0x80000000},
	/* 3390 */
	{26629, 0xFFFF},
	{38, 0xF0000},
	{95076, 0xC00000},
	{10448, 0xF000000},
	{109184, 0x80000000},
	/* 3395 */
	{10448, 0xF},
	{109194, 0x10},
	{95243, 0x400},
	{95256, 0x6000},
	{95273, 0x8000},
	{95285, 0x300000},
	{95296, 0x6000000},
	{95313, 0x8000000},
	{95325, 0x60000000},
	/* 3404 */
	{95825, 0x1},
	{95839, 0x2},
	{102547, 0x8000},
	{95851, 0x10000},
	{95865, 0x1000000},
	{109198, 0x80000000},
	/* 3410 */
	{43248, 0x1FFF000},
	{95076, 0x6000000},
	{95939, 0x8000000},
	{95952, 0x10000000},
	{101005, 0x40000000},
	{109151, 0x80000000},
	/* 3416 */
	{95960, 0x30000},
	{109211, 0x80000},
	{102562, 0x300000},
	{102577, 0xC00000},
	{95968, 0x7000000},
	{95976, 0xE0000000},
	/* 3422 */
	{18800, 0x3F, 22, 37009},
	/* 3423 */
	{19325, 0x1},
	{89379, 0x2},
	{109248, 0x4},
	/* 3426 */
	{38, 0x1FFFF},
	/* 3427 */
	{87093, 0x1FF},
	{87073, 0x3FE00},
	{109271, 0x40000},
	{96698, 0x80000},
	{109291, 0x100000},
	{96652, 0x3FE00000},
	{109312, 0x40000000},
	{109324, 0x80000000},
	/* 3435 */
	{109353, 0xFFFF},
	{109365, 0xFFFF0000},
	/* 3437 */
	{109377, 0xFFFF},
	/* 3438 */
	{87782, 0x3F, 5, 37031},
	/* 3439 */
	{8, 0xFFF},
	{96432, 0xFFFFF000},
	/* 3441 */
	{38, 0x1FFF},
	{96432, 0xFFFFE000},
	/* 3443 */
	{85076, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{92957, 0x4000},
	{96979, 0x8000},
	{96991, 0x1FFF0000},
	{97002, 0x20000000},
	{97013, 0x40000000},
	{97023, 0x80000000},
	/* 3452 */
	{69281, 0x1FFFFF},
	{69300, 0xE00000},
	{69319, 0x1000000},
	{69341, 0x2000000},
	{69396, 0x10000000},
	{69414, 0x20000000},
	{69430, 0xC0000000},
	/* 3459 */
	{109397, 0xF},
	{109412, 0x10},
	{109436, 0x60},
	{109452, 0x80},
	{109468, 0x100},
	{109490, 0x200},
	{109510, 0x3C00},
	{109526, 0x4000},
	{109547, 0x8000},
	{109568, 0x1F0000},
	{109585, 0x200000},
	{109599, 0x400000},
	{109613, 0xFF800000},
	/* 3472 */
	{109630, 0xF},
	{109671, 0xF0},
	{109710, 0x100},
	{109731, 0x200},
	{109751, 0x400},
	{109771, 0x800},
	{109791, 0x1F000},
	/* 3479 */
	{109810, 0x3},
	{109823, 0x30},
	{109836, 0xC0},
	/* 3482 */
	{109849, 0xF},
	{109866, 0xF0},
	{109883, 0xF00},
	{109905, 0xF000},
	{109924, 0xF0000},
	{109942, 0xF00000},
	{109960, 0xF000000},
	{109978, 0xF0000000},
	/* 3490 */
	{110001, 0x3},
	{110019, 0x3C},
	{110042, 0xC0},
	{110072, 0x700},
	{110094, 0x3800},
	{110116, 0xC000},
	{110135, 0x10000},
	{10701, 0xFFFE0000},
	/* 3498 */
	{110143, 0xFF},
	{75168, 0x10000},
	{110152, 0x60000},
	{110162, 0x180000},
	{101249, 0x200000},
	{110172, 0x400000},
	/* 3504 */
	{490, 0x1},
	{110197, 0x2},
	{47315, 0x1C},
	{110202, 0xFE0},
	{110214, 0x1E000},
	{71150, 0x3E0000},
	{74705, 0xC00000},
	{110225, 0x7000000},
	{110237, 0x8000000},
	{110241, 0x10000000},
	{110245, 0x20000000},
	{110249, 0x40000000},
	/* 3516 */
	{110268, 0x7},
	/* 3517 */
	{490, 0x1},
	{110197, 0x2},
	{47315, 0x4},
	{110202, 0x8},
	{110214, 0x10},
	{71150, 0x20},
	{74705, 0x40},
	{110225, 0x80},
	{110237, 0x100},
	{110241, 0x200},
	{110245, 0x400},
	{110249, 0x800},
	{110268, 0x1000},
	/* 3530 */
	{97085, 0x3FF},
	{50369, 0xF00000},
	{98642, 0xF0000000},
	/* 3533 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{97958, 0x1000},
	{97984, 0x2000},
	{98010, 0x8000},
	{98037, 0x10000},
	{98117, 0x20000},
	{98143, 0x40000},
	{98063, 0x100000},
	{98222, 0x200000},
	{98384, 0x400000},
	{98411, 0x800000},
	{98276, 0x1000000},
	{98440, 0x2000000},
	{110277, 0x4000000},
	{110305, 0x8000000},
	{110331, 0x10000000},
	/* 3551 */
	{98411, 0x2},
	{98469, 0x4},
	{98498, 0x8},
	{98526, 0x10},
	{98552, 0x20},
	{98578, 0x40},
	{98605, 0x80},
	{98440, 0x100},
	{110277, 0x200},
	/* 3560 */
	{98632, 0x3FF},
	{97094, 0xFFC00},
	{98642, 0xF00000},
	{98663, 0xF000000},
	{98652, 0xF0000000},
	/* 3565 */
	{59979, 0x1},
	{90031, 0x4, 2, 36414},
	{89949, 0x10, 2, 36408},
	{98792, 0x40},
	{102599, 0x4000},
	{102621, 0x8000},
	{102643, 0x10000},
	{102665, 0x20000},
	{102687, 0x40000},
	{102709, 0x80000},
	/* 3575 */
	{98822, 0x1},
	{110359, 0x1FFFE},
	/* 3577 */
	{1331, 0x7F},
	/* 3578 */
	{1318, 0x3},
	{64094, 0x4},
	{110367, 0x8},
	{64114, 0x10},
	{64127, 0x20},
	{53862, 0x1C0},
	{110379, 0x600},
	{64154, 0x800},
	{64167, 0x1000},
	{64197, 0x2000},
	{64208, 0xC000},
	{64223, 0x30000},
	{64231, 0x40000},
	{64250, 0x80000},
	{101136, 0x700000},
	{101151, 0x10000000},
	{101174, 0x20000000},
	{64279, 0x80000000},
	/* 3596 */
	{63597, 0x3},
	{63606, 0xF0},
	{63614, 0x200},
	{63621, 0x1FC00},
	{110390, 0x20000},
	/* 3601 */
	{63892, 0x7FF, 2049, 257},
	{110419, 0x800},
	{101099, 0x1000},
	{64054, 0xFF0000, 129, 2306},
	{64066, 0x3000000},
	{101124, 0x1C000000},
	{64079, 0x80000000},
	/* 3608 */
	{64293, 0xFFF},
	{64308, 0xFFF000},
	{110431, 0x1000000},
	{60331, 0x2000000},
	{101190, 0xF0000000},
	/* 3613 */
	{101201, 0x1},
	{101211, 0x2},
	{101221, 0x10},
	{110443, 0x1F00},
	{110460, 0x2000},
	{110470, 0x4000},
	/* 3619 */
	{97085, 0x3FF},
	{98696, 0xF0000000},
	/* 3621 */
	{69952, 0xFFF},
	{99532, 0x3000},
	{110485, 0x4000},
	{10701, 0x8000},
	{99550, 0xFFFF0000},
	/* 3626 */
	{110508, 0xFFFF},
	{110526, 0xFF0000},
	{110545, 0xFF000000},
	/* 3629 */
	{11950, 0xFFF},
	/* 3630 */
	{98637, 0xFFFF},
	{97099, 0xFFFF0000},
	/* 3632 */
	{99697, 0xFF},
	{99718, 0x100},
	{99728, 0x200},
	{99736, 0x400},
	{99750, 0x800},
	{99761, 0x1000},
	{99780, 0x2000},
	{99804, 0x4000},
	{99818, 0x8000},
	{102731, 0x10000},
	{102744, 0x20000},
	{102755, 0x40000},
	{102772, 0x80000},
	{102786, 0x100000},
	{102798, 0x200000},
	{102814, 0x400000},
	{110560, 0x800000},
	{10701, 0xFF000000},
	/* 3650 */
	{99961, 0x1},
	{102910, 0x2},
	{102933, 0x4},
	{100050, 0x8},
	{99973, 0x20},
	{102974, 0x40},
	{99985, 0x80},
	{102989, 0x100},
	{99995, 0x200},
	{103002, 0x400},
	{100016, 0x800},
	{103026, 0x1000},
	{100033, 0x2000},
	{103046, 0x4000},
	{103066, 0x8000},
	{103083, 0x10000},
	{103103, 0x20000},
	{103120, 0x40000},
	{110579, 0x80000},
	{110596, 0x100000},
	{110616, 0x200000},
	{110633, 0x400000},
	/* 3672 */
	{50344, 0x1},
	{110653, 0x2},
	/* 3674 */
	{110660, 0x1},
	{110669, 0x2},
	{110683, 0x4},
	{110697, 0x8},
	{110714, 0xFF0},
	{110730, 0x8000},
	{110741, 0xF0000},
	{110758, 0xF00000},
	{110775, 0x3000000},
	{110789, 0x4000000},
	/* 3684 */
	{1318, 0x1},
	/* 3685 */
	{402, 0xFFF},
	/* 3686 */
	{1, 0xF},
	/* 3687 */
	{1, 0xF},
	{59201, 0x100},
	/* 3689 */
	{50630, 0xF},
	/* 3690 */
	{110803, 0x1},
	{110811, 0x2},
	{110819, 0x4},
	{110827, 0x8},
	{110835, 0x10},
	{110843, 0x20},
	{110851, 0x40},
	{110859, 0x80},
	{110867, 0x100},
	/* 3699 */
	{89353, 0x3F, 64, 36941},
	{108464, 0x80},
	{100757, 0xF00},
	{100769, 0x1000},
	{100776, 0x2000},
	{100784, 0x4000},
	{100792, 0x8000},
	{100800, 0x10000},
	{100823, 0x60000, 4, 36586},
	{100848, 0x80000},
	{100860, 0x100000},
	{100868, 0x200000},
	{100912, 0xC00000, 3, 36590},
	{100998, 0x1000000},
	{95076, 0x6000000},
	{95952, 0x30000000},
	{101005, 0x40000000},
	{109151, 0x80000000},
	/* 3717 */
	{110923, 0x3800, 6, 37036},
	{110957, 0xC000, 3, 37042},
	{110973, 0x20000},
	{110982, 0xFC0000},
	/* 3721 */
	{110992, 0x80000000},
	/* 3722 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60310, 0x4000},
	{60325, 0x8000},
	{60336, 0x10000},
	{60344, 0x20000},
	{60353, 0x40000},
	{101045, 0x80000},
	{60385, 0x100000},
	{60398, 0x200000},
	{60408, 0x400000},
	{60442, 0x4000000},
	{60451, 0x8000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	{60487, 0x80000000},
	/* 3744 */
	{60602, 0x2},
	{60611, 0x4},
	{60747, 0x8},
	{60451, 0x10},
	{60758, 0x20},
	{103401, 0x40},
	{60470, 0x80},
	{60344, 0x200000},
	{60677, 0x400000},
	{60694, 0x1000000},
	{60620, 0x2000000},
	{60652, 0x4000000},
	{60668, 0x8000000},
	{60686, 0x20000000},
	{60702, 0x40000000},
	{60728, 0x80000000},
	/* 3760 */
	{60769, 0x20},
	{60829, 0x80},
	{60858, 0x100},
	{60878, 0x200},
	{60938, 0x2000},
	{60946, 0x4000},
	{60954, 0x8000},
	{60758, 0x10000},
	{60470, 0x4000000},
	{103401, 0x8000000},
	{60965, 0x10000000},
	{60979, 0x20000000},
	{60747, 0x40000000},
	{60988, 0x80000000},
	/* 3774 */
	{111000, 0xF},
	{111020, 0xF0},
	{111040, 0xF00},
	{111060, 0xF000},
	{111080, 0xF0000},
	{111100, 0xF00000},
	{111120, 0xF000000},
	{111140, 0xF0000000},
	/* 3782 */
	{111160, 0x1},
	{111177, 0x2},
	/* 3784 */
	{85888, 0x1},
	{85660, 0x2},
	{85684, 0x4},
	{85704, 0x8},
	{85725, 0x10},
	{85926, 0x40},
	/* 3790 */
	{220, 0x3, 3, 36420},
	{90428, 0x1C, 4, 36423},
	{90505, 0xE0, 4, 36427},
	{90514, 0x100},
	{108474, 0x200},
	{90545, 0x3C00},
	{90567, 0x4000},
	{88117, 0x18000, 3, 36337},
	{90601, 0x60000, 4, 36431},
	{90660, 0x80000, 2, 37005},
	{90712, 0x100000, 2, 37007},
	{88143, 0x3800000},
	/* 3802 */
	{108672, 0x1},
	{108696, 0x2},
	{108720, 0x4},
	{108763, 0x8},
	{111196, 0x70},
	{108816, 0x780},
	{108844, 0x800},
	{108856, 0x1000},
	{108881, 0x1FE000},
	{108900, 0x200000},
	{111233, 0x400000},
	{111244, 0x800000},
	{111271, 0x3000000},
	{108788, 0x7C000000},
	/* 3816 */
	{40588, 0xFFFF},
	/* 3817 */
	{96439, 0x7F},
	{96403, 0xFF00},
	{96394, 0xFF0000},
	{96454, 0x20000000},
	{96474, 0x40000000},
	{96500, 0x80000000},
	/* 3823 */
	{100444, 0xF},
	{100491, 0x1000000},
	{100502, 0x2000000},
	{100512, 0x4000000},
	/* 3827 */
	{59152, 0xF},
	{59161, 0xF0},
	{59171, 0x100},
	{59182, 0x200},
	{59187, 0x400},
	{111296, 0x800},
	{59314, 0x7F000, 257, 0},
	{59345, 0x10000000},
	{59351, 0xE0000000},
	/* 3836 */
	{59355, 0x1},
	{59359, 0x6},
	{111305, 0x18},
	{59378, 0x20},
	{59383, 0x40},
	{59391, 0x80},
	{59401, 0x100},
	{59412, 0x200},
	{59418, 0x400},
	{59423, 0x800},
	{59429, 0x1000},
	{59440, 0x2000},
	{59445, 0x4000},
	{111315, 0x8000},
	{59201, 0x10000},
	{59465, 0x20000},
	{59473, 0x40000},
	{59485, 0x80000},
	{111328, 0x100000},
	{111342, 0x200000},
	{111355, 0x400000},
	{111364, 0x800000},
	{111373, 0x7000000},
	{59504, 0x8000000},
	/* 3860 */
	{59516, 0x7F, 257, 0},
	{59561, 0x3F0000},
	{59614, 0xE0000000},
	/* 3863 */
	{54575, 0xF},
	{59622, 0x30},
	{59630, 0xC0},
	{59638, 0xF00},
	{59644, 0x1000},
	{29204, 0x2000},
	{59662, 0xF0000},
	{59668, 0xF00000},
	{59674, 0x7000000},
	{59683, 0x38000000},
	{59692, 0xC0000000},
	/* 3874 */
	{59698, 0x3F},
	{59708, 0x3F00},
	{59718, 0x3F0000},
	{59728, 0xF000000},
	/* 3878 */
	{59738, 0xFF},
	{59747, 0x1FF000},
	/* 3880 */
	{59773, 0xF},
	{59780, 0x70},
	{59802, 0x1F00},
	{59811, 0xE000},
	/* 3884 */
	{1448, 0xFF},
	/* 3885 */
	{111393, 0x7},
	{111401, 0x8},
	{111412, 0x10},
	{111425, 0xE0},
	{111441, 0x300},
	{111451, 0xC00},
	{111461, 0x70000},
	{59936, 0x380000},
	{111473, 0xC00000},
	{111480, 0x1000000},
	{111487, 0x6000000},
	{73651, 0x8000000},
	{111495, 0x10000000},
	/* 3898 */
	{10330, 0xFF},
	/* 3899 */
	{103374, 0x1},
	{111512, 0x2},
	{60425, 0x4},
	{111527, 0x8},
	{111543, 0x10},
	{60398, 0x20},
	{111552, 0x40},
	{111563, 0x80},
	{111573, 0x100},
	{111583, 0x200},
	{111593, 0x400},
	{111604, 0x800},
	{111615, 0x1000},
	{111627, 0x2000},
	{111636, 0x4000},
	{111646, 0x8000},
	{101065, 0x10000},
	{101082, 0x20000},
	{111655, 0x40000},
	{111673, 0x80000},
	{111688, 0x100000},
	/* 3920 */
	{111704, 0x2},
	{111719, 0x4},
	{111737, 0x8},
	{60522, 0x10},
	{111752, 0x20},
	{111768, 0x40},
	{111782, 0x100},
	{111791, 0x200},
	{111800, 0x400},
	{111821, 0x800},
	{111830, 0x1000},
	{111839, 0x2000},
	{111849, 0x4000},
	{111858, 0x10000},
	{111867, 0x20000},
	{111875, 0x80000},
	{111884, 0x100000},
	{111896, 0x200000},
	{111909, 0x400000},
	{111922, 0x20000000},
	/* 3940 */
	{111931, 0x1},
	{111941, 0x2},
	{111951, 0x4},
	{111961, 0x8},
	{111971, 0x10},
	{111981, 0x20},
	{111991, 0x40},
	{112001, 0x80},
	{112011, 0x100},
	{112021, 0x200},
	{112031, 0x400},
	{112041, 0x800},
	{112051, 0x1000},
	{112061, 0x2000},
	{112071, 0x4000},
	{112081, 0x8000},
	/* 3956 */
	{112091, 0xFF},
	/* 3957 */
	{112104, 0x3F},
	{112123, 0xFC0},
	/* 3959 */
	{60081, 0xF},
	{60310, 0x1},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60442, 0x100},
	{60210, 0x200},
	{61380, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	/* 3976 */
	{112134, 0xF},
	{112143, 0xF0},
	/* 3978 */
	{60498, 0xF},
	{112152, 0x20},
	{60537, 0x80},
	{60560, 0x100},
	{60583, 0x200},
	{60602, 0x1000},
	{60611, 0x2000},
	{60620, 0x4000},
	{60628, 0x8000},
	{112168, 0x10000},
	{112183, 0x20000},
	{112192, 0x40000},
	{112207, 0x80000},
	{60652, 0x100000},
	{112215, 0x200000},
	{60668, 0x400000},
	{60677, 0x800000},
	{60686, 0x1000000},
	{60694, 0x2000000},
	{60702, 0x4000000},
	{60710, 0x10000000},
	{60452, 0x20000000},
	{60728, 0x40000000},
	{60736, 0x80000000},
	/* 4002 */
	{60602, 0x2},
	{60611, 0x4},
	{60677, 0x400000},
	{112183, 0x800000},
	{60694, 0x1000000},
	{60620, 0x2000000},
	{60652, 0x4000000},
	{60668, 0x8000000},
	{60686, 0x20000000},
	{60702, 0x40000000},
	{60728, 0x80000000},
	/* 4013 */
	{112223, 0x1},
	{112237, 0x4},
	{112252, 0x10000},
	{112267, 0x20000},
	{112282, 0x40000},
	{112297, 0x80000},
	/* 4019 */
	{112312, 0x3F},
	/* 4020 */
	{96439, 0xFF},
	{112329, 0xFF00},
	{96394, 0xFF0000},
	{112338, 0x20000000},
	{96474, 0x40000000},
	{96500, 0x80000000},
	/* 4026 */
	{112358, 0xF},
	{112375, 0x1F00},
	/* 4028 */
	{51396, 0xFF},
	/* 4029 */
	{112390, 0x2},
	{112401, 0x20},
	{112412, 0x40},
	{112433, 0x80},
	{112453, 0xF00},
	{112475, 0x1000},
	/* 4035 */
	{112501, 0x1},
	{112509, 0x2},
	{112517, 0x2},
	{112526, 0x8},
	{112542, 0x10},
	{112558, 0x40},
	{112579, 0x80},
	{112600, 0x100},
	{112621, 0x200},
	{112629, 0x200},
	{112650, 0x400},
	{112671, 0x800},
	{112692, 0x1000},
	{112713, 0x2000},
	{112734, 0x4000},
	{112755, 0x8000},
	{112776, 0x10000},
	{112797, 0x20000},
	{112818, 0x40000},
	{112839, 0x80000},
	{112860, 0x100000},
	{112881, 0x200000},
	/* 4057 */
	{112902, 0x3FFFC},
	{112915, 0x300000},
	{112927, 0xC00000},
	{51449, 0x80000000},
	/* 4061 */
	{112937, 0x1},
	{112954, 0x80000},
	/* 4063 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{112974, 0x1000},
	{97958, 0x2000},
	{97984, 0x4000},
	{98010, 0x10000},
	{98037, 0x20000},
	{98063, 0x40000},
	{98089, 0x80000},
	{98117, 0x100000},
	{98143, 0x200000},
	{98169, 0x400000},
	{113001, 0x800000},
	{98195, 0x1000000},
	{98222, 0x2000000},
	{98249, 0x4000000},
	{113027, 0x8000000},
	{113053, 0x10000000},
	/* 4082 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{97958, 0x1000},
	{97984, 0x2000},
	{98010, 0x8000},
	{98037, 0x10000},
	{98117, 0x20000},
	{98143, 0x40000},
	{112974, 0x80000},
	{98063, 0x100000},
	{98222, 0x200000},
	/* 4094 */
	{51474, 0x3FFFF},
	/* 4095 */
	{113079, 0x1},
	{113092, 0x2},
	{113096, 0x4},
	{113118, 0x8},
	{113132, 0x10},
	{113146, 0x20},
	{113164, 0x40},
	{113182, 0x80},
	{29204, 0x2000000},
	{102295, 0xC000000},
	/* 4105 */
	{95174, 0x3},
	{10301, 0xFFFFFFFC},
	/* 4107 */
	{113197, 0x3},
	{24664, 0xFFFFFFFC},
	/* 4109 */
	{113218, 0x3},
	{25180, 0xFFFFFFFC},
	/* 4111 */
	{95148, 0xFF},
	{95160, 0x30000},
	{26989, 0xE0000000},
	/* 4114 */
	{113239, 0x3},
	{26539, 0xFFFFFFFC},
	/* 4116 */
	{26557, 0xFF},
	/* 4117 */
	{113256, 0x3},
	{26611, 0xFFFFFFFC},
	/* 4119 */
	{26629, 0xFF},
	/* 4120 */
	{26688, 0xFF},
	{95184, 0x10000},
	{95200, 0x100000},
	{95216, 0x3000000},
	{95232, 0xE0000000},
	/* 4125 */
	{96139, 0x1},
	{96155, 0x2},
	{96171, 0x40},
	{96189, 0x80},
	{96207, 0x100},
	{96225, 0x200},
	{96243, 0x400},
	{96261, 0x800},
	{96279, 0x1000},
	{96297, 0x2000},
	{96315, 0x4000},
	{95434, 0x8000},
	{113273, 0x10000},
	{95454, 0x40000},
	{96332, 0x80000},
	{96348, 0x200000},
	{95471, 0x400000},
	{95487, 0x800000},
	{95501, 0x2000000},
	{95515, 0x4000000},
	{95529, 0x8000000},
	{95550, 0x10000000},
	{95575, 0x20000000},
	/* 4148 */
	{96364, 0xFF},
	{95620, 0x3000000},
	{113291, 0x40000000},
	{1331, 0x80000000},
	/* 4152 */
	{26926, 0xFF},
	/* 4153 */
	{26967, 0xFF},
	/* 4154 */
	{95625, 0x1FFFFF},
	{95663, 0x200000},
	{113305, 0xC00000},
	{113314, 0x3000000},
	{95636, 0x4000000},
	{95640, 0x8000000},
	{95644, 0x10000000},
	{95649, 0x20000000},
	{95654, 0x40000000},
	/* 4163 */
	{95704, 0x30},
	{95716, 0xF0000},
	{95729, 0x10000000},
	{95744, 0x20000000},
	{95758, 0xC0000000},
	/* 4168 */
	{95819, 0x1},
	/* 4169 */
	{113323, 0x1},
	{113348, 0x2},
	{113386, 0x4},
	{113427, 0x8},
	{113450, 0x10},
	{113473, 0x20},
	{113497, 0x40},
	{113527, 0x80},
	{113556, 0x100},
	{113587, 0x400},
	{113613, 0x800},
	{113642, 0x1000},
	{113667, 0x2000},
	{63073, 0x4000},
	{63094, 0x8000},
	/* 4184 */
	{113702, 0x1},
	{113729, 0x4},
	{113756, 0x10},
	{113785, 0x400},
	{113814, 0x800},
	{113843, 0x1000},
	{113871, 0x2000},
	{113901, 0x4000},
	{113928, 0x8000},
	{113956, 0x10000},
	{113982, 0x20000},
	{114008, 0x800000},
	{114033, 0x1000000},
	{114059, 0x2000000},
	{114084, 0x4000000},
	{114108, 0x8000000},
	{114133, 0x10000000},
	{114162, 0x10000000},
	/* 4202 */
	{114190, 0x1},
	{114216, 0x2},
	{114242, 0x4},
	{114269, 0x10},
	{114295, 0x20},
	{114317, 0x40},
	{114338, 0x80},
	{114370, 0x100},
	{114397, 0x200},
	{114419, 0x400},
	{114443, 0x800},
	{114468, 0x1000},
	{114491, 0x2000},
	{114518, 0x4000},
	{114543, 0x8000},
	{114571, 0x10000},
	{114596, 0x20000},
	{114621, 0x40000},
	{114646, 0x80000},
	{114675, 0x100000},
	{114706, 0x200000},
	{114734, 0x400000},
	{114761, 0x800000},
	{114791, 0x1000000},
	{114818, 0x2000000},
	{114845, 0x4000000},
	{114872, 0x8000000},
	{114898, 0x10000000},
	{114922, 0x20000000},
	{114954, 0x40000000},
	{114981, 0x80000000},
	/* 4233 */
	{62410, 0x1},
	{115007, 0x40},
	{115026, 0x80},
	{115046, 0x100},
	{115065, 0x200},
	{115079, 0x400},
	{115092, 0x1000},
	{115114, 0x2000},
	{115137, 0x4000},
	{115158, 0x8000},
	{115175, 0x20000},
	{115190, 0x40000},
	{115204, 0x80000},
	{115218, 0x100000},
	{115234, 0x200000},
	{115247, 0x400000},
	/* 4249 */
	{115266, 0x80},
	{115281, 0x100},
	{62094, 0x200},
	{62108, 0x400},
	{62127, 0x800},
	{62146, 0x1000},
	{103413, 0x2000},
	{115070, 0x8000},
	{115296, 0x10000},
	{115084, 0x20000},
	{115305, 0x40000},
	{62222, 0x80000},
	{62237, 0x100000},
	{115316, 0x200000},
	{60399, 0x400000},
	{62270, 0x800000},
	{61087, 0x1000000},
	{115334, 0x2000000},
	{115239, 0x4000000},
	{61077, 0x8000000},
	{62161, 0x10000000},
	{62178, 0x20000000},
	{62200, 0x40000000},
	{60452, 0x80000000},
	/* 4273 */
	{2190, 0x3F},
	{115347, 0x3F00},
	{115362, 0x3F0000},
	/* 4276 */
	{51818, 0x1F},
	/* 4277 */
	{115377, 0xF},
	{115400, 0x3F00},
	/* 4279 */
	{115421, 0xF},
	/* 4280 */
	{115440, 0x10},
	{115461, 0x40},
	{115483, 0x100},
	{115504, 0x1000000},
	{115512, 0x2000000},
	{115520, 0x4000000},
	{115529, 0x8000000},
	{115538, 0x10000000},
	{115546, 0x20000000},
	/* 4289 */
	{115554, 0xFF},
	{115575, 0x700},
	{115596, 0xFF00000},
	{115616, 0x70000000},
	/* 4293 */
	{115636, 0x1},
	/* 4294 */
	{115657, 0xFFFFF},
	/* 4295 */
	{115665, 0xFFFFFFF},
	{115681, 0xF0000000},
	/* 4297 */
	{115697, 0xFFFF},
	{115712, 0xFFFF0000},
	/* 4299 */
	{27662, 0xFF},
	/* 4300 */
	{27716, 0xFF},
	/* 4301 */
	{27768, 0xFF},
	/* 4302 */
	{27899, 0xFF},
	/* 4303 */
	{115728, 0xFF},
	{115738, 0xFF00},
	{115748, 0xFF0000},
	{115761, 0xFF000000},
	/* 4307 */
	{115774, 0xFF},
	{115787, 0xFF00},
	{115800, 0xFF0000},
	{115813, 0xFF000000},
	/* 4311 */
	{115826, 0xFF},
	{115837, 0xFF00},
	{115848, 0xFF0000},
	/* 4314 */
	{115859, 0x3F},
	{115873, 0x3F00},
	/* 4316 */
	{115887, 0xFF},
	{115898, 0xFF00},
	/* 4318 */
	{115909, 0x7FF},
	{115922, 0x7FF0000},
	/* 4320 */
	{115934, 0x1FF},
	/* 4321 */
	{115942, 0x7FF},
	/* 4322 */
	{115954, 0x3FF},
	/* 4323 */
	{52122, 0x7FF},
	{115962, 0x3000},
	{115973, 0x30000},
	/* 4326 */
	{115987, 0x3FF},
	{116004, 0x3FF0000},
	/* 4328 */
	{116021, 0x3FF},
	{116040, 0x3FF0000},
	/* 4330 */
	{116059, 0x3FF},
	{116078, 0x3FF0000},
	/* 4332 */
	{116097, 0x3FF},
	/* 4333 */
	{116106, 0x3FF},
	{116115, 0x3FF0000},
	/* 4335 */
	{116124, 0x7FF},
	{116137, 0x7FF0000},
	/* 4337 */
	{116149, 0x7FF},
	/* 4338 */
	{116161, 0x3FF},
	{116178, 0x3FF0000},
	/* 4340 */
	{116195, 0x3FF},
	{116214, 0x3FF0000},
	/* 4342 */
	{116233, 0x3FF},
	{116252, 0x3FF0000},
	/* 4344 */
	{116271, 0x4000},
	{116297, 0x20000},
	{116327, 0x80000},
	{116350, 0x100000},
	{116374, 0x400000},
	{116398, 0x800000},
	{116420, 0x1000000},
	{116446, 0x4000000},
	{116470, 0x8000000},
	{116502, 0x20000000},
	{116524, 0x40000000},
	{116546, 0x80000000},
	/* 4356 */
	{97085, 0xFF},
	{97094, 0xFFC00},
	{98642, 0xF00000},
	{98663, 0xF000000},
	{98696, 0xF0000000},
	/* 4361 */
	{97085, 0xFF},
	{98696, 0xF0000000},
	/* 4363 */
	{116568, 0x3FF},
	/* 4364 */
	{52588, 0x1FF},
	/* 4365 */
	{52612, 0x3F},
	/* 4366 */
	{52635, 0x3F},
	/* 4367 */
	{82321, 0x7},
	{116579, 0x70000},
	/* 4369 */
	{52680, 0x3},
	{116592, 0x20},
	{116611, 0xC0},
	{116625, 0x200},
	{116637, 0x800},
	{116658, 0x1000},
	{116675, 0x2000},
	{116696, 0x1F0000},
	/* 4377 */
	{116705, 0x7F},
	{86835, 0x80},
	{116726, 0x3FFF00},
	{86900, 0xFFC00000},
	/* 4381 */
	{116743, 0x1F},
	/* 4382 */
	{116754, 0x3},
	/* 4383 */
	{112207, 0x1},
	{116772, 0x2},
	{116784, 0x4},
	{116800, 0x8},
	{116812, 0x10},
	/* 4388 */
	{116824, 0x3F},
	{116839, 0x40},
	/* 4390 */
	{116859, 0x3F},
	{116873, 0x40},
	/* 4392 */
	{112183, 0x1},
	{116892, 0x2},
	{116910, 0x4},
	{116923, 0x8},
	{116935, 0x10},
	{116947, 0x20},
	{116959, 0x40},
	{116971, 0x80},
	{116983, 0x100},
	{116995, 0x200},
	/* 4402 */
	{117009, 0xFF},
	/* 4403 */
	{18800, 0x3F, 29, 37045},
	/* 4404 */
	{214, 0x3, 2, 36326},
	/* 4405 */
	{117217, 0xF},
	{117226, 0xFF0},
	{117241, 0x1000000},
	{117256, 0x2000000},
	{117268, 0x4000000},
	{117279, 0x8000000},
	{117294, 0x10000000},
	{117309, 0x20000000},
	{117321, 0x40000000},
	{117335, 0x80000000},
	/* 4415 */
	{10218, 0x1},
	{10448, 0x1E},
	/* 4417 */
	{117217, 0xF},
	{117226, 0xFF0},
	{117241, 0x1000000},
	{117256, 0x2000000},
	{117268, 0x4000000},
	{117279, 0x8000000},
	{117294, 0x10000000},
	{117321, 0x20000000},
	{117348, 0x20000000},
	{117335, 0x80000000},
	/* 4427 */
	{117363, 0x1},
	{117376, 0x7E},
	{117393, 0x80},
	/* 4430 */
	{96520, 0x7F},
	{96586, 0x600, 4, 36536},
	/* 4432 */
	{117418, 0x6},
	{117428, 0x8},
	{117448, 0x10},
	{117457, 0xFFFF0000},
	/* 4436 */
	{117470, 0x1F},
	/* 4437 */
	{117484, 0x80000000},
	/* 4438 */
	{117492, 0x1},
	{117513, 0x6},
	{117526, 0x8},
	{117549, 0x10},
	{117569, 0x20},
	{117588, 0x10000000},
	{117599, 0x20000000},
	{117610, 0x40000000},
	{117621, 0x80000000},
	/* 4447 */
	{117217, 0xF},
	{117226, 0xFF0},
	{117241, 0x1000000},
	{117632, 0x2000000},
	{117647, 0x4000000},
	{117279, 0x8000000},
	{117294, 0x10000000},
	{117662, 0x20000000},
	{117678, 0x40000000},
	{117694, 0x80000000},
	/* 4457 */
	{117711, 0x80000000},
	/* 4458 */
	{18784, 0xFF},
	/* 4459 */
	{97085, 0x1FF},
	{97094, 0xFFC00},
	{98642, 0xF00000},
	/* 4462 */
	{117719, 0xFFFF},
	{117741, 0xFFFF0000},
	/* 4464 */
	{117217, 0xF},
	{117226, 0xFF0},
	{117241, 0x1000000},
	{117632, 0x2000000},
	{117647, 0x4000000},
	{117279, 0x8000000},
	{117294, 0x10000000},
	{117348, 0x20000000},
	{117763, 0x40000000},
	{117778, 0x80000000},
	/* 4474 */
	{117793, 0x3F},
	{117820, 0x7FC0},
	{117846, 0x1F8000},
	{117868, 0xFF800000},
	/* 4478 */
	{117893, 0x3F},
	{117917, 0xFC0},
	{117941, 0x3F000},
	{117961, 0xFC0000},
	/* 4482 */
	{117981, 0x3F},
	/* 4483 */
	{117995, 0x1},
	{118021, 0x2},
	{118044, 0x4},
	{118069, 0x8},
	{118100, 0x10},
	{118134, 0x20},
	{118154, 0xC0},
	{118181, 0x100},
	{118209, 0x200},
	{118244, 0x400},
	{118274, 0x800},
	{118309, 0x1000},
	{118339, 0x2000},
	{118362, 0x4000},
	{118401, 0x8000},
	{118433, 0x10000},
	{118469, 0x20000},
	{118499, 0x40000},
	{118545, 0x80000},
	{118586, 0x100000},
	{118636, 0x200000},
	{118686, 0x400000},
	{118737, 0x800000},
	{118785, 0x1000000},
	{117610, 0x40000000},
	{117621, 0x80000000},
	/* 4509 */
	{96432, 0xFF},
	{111296, 0x100},
	{118831, 0x200},
	{118850, 0x400},
	{118871, 0x800},
	{118890, 0x1000},
	{118912, 0x2000},
	{118933, 0x4000},
	{118956, 0x8000},
	/* 4518 */
	{118986, 0x3},
	{119002, 0xC},
	{119018, 0x30},
	{119034, 0x40},
	{119049, 0x80},
	{119067, 0x100},
	{119082, 0x200},
	{119101, 0x400},
	{119119, 0x800},
	/* 4527 */
	{119140, 0x1},
	{119156, 0x2},
	{119172, 0x4},
	/* 4530 */
	{119192, 0x7F},
	{119196, 0x380},
	{119200, 0x1FFC00},
	/* 4533 */
	{119204, 0x3F},
	{119217, 0xF00},
	{110674, 0x10000000},
	{119229, 0x20000000},
	{113182, 0x40000000},
	{113151, 0x80000000},
	/* 4539 */
	{119243, 0xF},
	{119263, 0xF00},
	{119280, 0x30000},
	{119296, 0xC0000},
	/* 4543 */
	{59979, 0x1},
	{90096, 0x2, 4, 36416},
	{90031, 0x4, 2, 36414},
	{20094, 0x8, 4, 36410},
	{89949, 0x10, 2, 36408},
	{89918, 0x20, 4, 36404},
	{98792, 0x40},
	{98798, 0x1F00},
	{98808, 0x2000},
	/* 4552 */
	{119316, 0xF0000},
	{119334, 0xF00000},
	{119352, 0xF000000},
	{119370, 0xF0000000},
	/* 4556 */
	{60331, 0x1},
	{119388, 0x2},
	{119407, 0xFFF0},
	{119422, 0xFFF0000},
	/* 4560 */
	{97085, 0x1FF},
	{98778, 0xF000},
	{119437, 0xF0000},
	{50369, 0xF00000},
	{119453, 0xF000000},
	{98696, 0xF0000000},
	/* 4566 */
	{119463, 0xFFFF},
	{119479, 0xFFFF0000},
	/* 4568 */
	{117217, 0xF},
	{117226, 0xFF0},
	{117321, 0x40000000},
	{117335, 0x80000000},
	/* 4572 */
	{54575, 0xF},
	{59622, 0x30},
	{119495, 0xFC0},
	{119505, 0x1000},
	{119515, 0x2000},
	{112091, 0x4000},
	{119526, 0x8000},
	{452, 0xFFFF0000},
	/* 4580 */
	{38, 0x3FFFFF},
	/* 4581 */
	{119536, 0x1F},
	{119543, 0x20},
	{64141, 0x80},
	{119550, 0x3000},
	{64154, 0x4000},
	{64167, 0x8000},
	{119561, 0xFFFF0000},
	{119561, 0xFFFF0000},
	/* 4589 */
	{2468, 0xFFFF},
	{119573, 0xFF0000},
	{64179, 0x1000000},
	/* 4592 */
	{119582, 0xFFFF},
	{119591, 0xFFFF0000},
	/* 4594 */
	{2426, 0x3FFFFFFF},
	{119600, 0xC0000000},
	/* 4596 */
	{64293, 0x7},
	{64308, 0x70000},
	{119612, 0x20000000},
	{60331, 0x40000000},
	{72682, 0x80000000},
	/* 4601 */
	{119620, 0x7},
	{119628, 0x38},
	{119636, 0x1C0},
	{119644, 0xE00},
	{119652, 0x7000},
	{119660, 0x38000},
	{119668, 0x1C0000},
	{1318, 0x600000},
	{119676, 0x1800000},
	{119689, 0x2000000},
	{59378, 0x4000000},
	{119702, 0x18000000},
	{119713, 0x20000000},
	{64114, 0x40000000},
	{69065, 0x80000000},
	/* 4616 */
	{119723, 0x80000000},
	/* 4617 */
	{53862, 0x7},
	/* 4618 */
	{119736, 0x3FFF},
	{119746, 0x3FFF0000},
	{119756, 0xC0000000},
	/* 4621 */
	{119769, 0x3FFF},
	{119785, 0x3FF0000},
	{119810, 0x78000000},
	{119835, 0x80000000},
	/* 4625 */
	{73379, 0x1},
	{72951, 0x2},
	{11568, 0x4},
	/* 4628 */
	{119849, 0xFF},
	{119858, 0xFF00},
	{119867, 0xFF0000},
	{119876, 0xFF000000},
	/* 4632 */
	{119885, 0x3F},
	{119893, 0x1F00},
	{119902, 0x1FF0000},
	/* 4635 */
	{119911, 0x3F},
	{119919, 0x1F00},
	{119928, 0x1FF0000},
	/* 4638 */
	{54575, 0xF},
	{59622, 0x30},
	{30815, 0x1C0},
	{59668, 0x1E00},
	/* 4642 */
	{64494, 0x7, 8, 37074},
	{64504, 0x38, 8, 37074},
	{64514, 0x1C0, 8, 37074},
	{64524, 0xE00, 8, 37074},
	{110214, 0x7000, 8, 37082},
	{110202, 0x78000, 16, 37090},
	{120582, 0x180000},
	{68761, 0x600000},
	{68774, 0x800000},
	{88130, 0x1000000},
	{120595, 0x2000000},
	{120607, 0x4000000},
	{88143, 0x38000000},
	{220, 0xC0000000, 4, 37106},
	/* 4656 */
	{64449, 0xFF},
	{69095, 0xFFF00},
	{110202, 0x3F00000, 64, 37110},
	{110214, 0x3C000000, 16, 37174},
	{88143, 0xC0000000},
	/* 4661 */
	{70799, 0x3FFF},
	{70906, 0xFFFC000},
	{71309, 0x70000000},
	{122665, 0x80000000},
	/* 4665 */
	{64494, 0x7, 8, 37074},
	{64504, 0x38, 8, 37074},
	{64514, 0x1C0, 8, 37074},
	{64524, 0xE00, 8, 37074},
	{71128, 0xF000},
	{71139, 0xF0000},
	{122676, 0x1F00000},
	{122689, 0x2000000},
	{88143, 0x4000000},
	{88130, 0x8000000},
	{220, 0xF0000000, 16, 37190},
	/* 4676 */
	{18784, 0x1FFF},
	{21500, 0x7FFE000},
	/* 4678 */
	{71265, 0x1FFF},
	{123000, 0x3FFE000},
	/* 4680 */
	{71296, 0xFFF},
	{71360, 0xFF000},
	{71333, 0x100000},
	{123011, 0xFFE00000},
	/* 4684 */
	{68906, 0x7, 8, 37206},
	{68914, 0x38, 8, 37206},
	{68922, 0x1C0, 8, 37206},
	{68930, 0xE00},
	{68946, 0x7000, 8, 37214},
	{68965, 0x8000},
	{68984, 0x70000},
	{69000, 0x80000},
	{69015, 0x100000},
	{69029, 0x7E00000},
	{69040, 0x8000000},
	{69052, 0x10000000},
	{69070, 0x60000000, 3, 37222},
	/* 4697 */
	{69127, 0x3FFF},
	{69136, 0xFC000},
	{69149, 0x300000, 4, 37225},
	{69163, 0xC00000, 4, 37225},
	{69177, 0x3000000, 3, 37229},
	{69186, 0xC000000, 3, 37232},
	{69197, 0x10000000},
	{123752, 0x20000000},
	{123769, 0x40000000},
	/* 4706 */
	{69246, 0xFFF},
	{123785, 0x20000000},
	{69263, 0xC0000000, 4, 37235},
	/* 4709 */
	{69451, 0x7},
	{69461, 0x70},
	{123927, 0x700},
	{69503, 0x3000},
	{123948, 0x70000},
	{123972, 0x700000},
	{123981, 0x3000000},
	{124001, 0x30000000},
	{124010, 0x40000000},
	/* 4718 */
	{124060, 0x3, 4, 37239},
	{69892, 0x3C, 16, 2765},
	{70320, 0x7C0, 18, 2781},
	{70510, 0x3800, 7, 2800},
	{70669, 0x1C00000, 5, 2807},
	{70689, 0x6000000},
	/* 4724 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{71712, 0x1000000},
	{124087, 0xE000000},
	{124097, 0x10000000},
	/* 4735 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{71775, 0x80},
	{71787, 0xFF00},
	{59314, 0x7F0000, 257, 0},
	/* 4741 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72232, 0x3000000},
	{72246, 0x4000000},
	{124087, 0x38000000},
	{124097, 0x40000000},
	/* 4753 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{72272, 0x100},
	{72284, 0x200},
	{72296, 0x400},
	{72308, 0x800},
	{72320, 0x1000},
	{59314, 0xFE000, 257, 0},
	/* 4763 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72246, 0x1000000},
	{124087, 0xE000000},
	{124097, 0x10000000},
	/* 4774 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59314, 0x3F80, 257, 0},
	/* 4778 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{59314, 0x7F00, 257, 0},
	{59747, 0x1FF00000},
	/* 4784 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{124087, 0x7000000},
	{124097, 0x8000000},
	/* 4794 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{72468, 0x100},
	{59314, 0xFE00, 257, 0},
	/* 4800 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72232, 0x3000000},
	{124087, 0x1C000000},
	{124097, 0x20000000},
	/* 4811 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59747, 0xFF80},
	{59314, 0x7F0000, 257, 0},
	/* 4816 */
	{72479, 0x1},
	{72497, 0x2},
	{72511, 0x4},
	{72530, 0x8},
	{72550, 0x10},
	{72570, 0x20},
	{72592, 0x40},
	{124107, 0x380},
	{72603, 0x400},
	{72621, 0x800},
	{111355, 0x1000},
	{72653, 0x4000},
	/* 4828 */
	{54571, 0xFFF},
	/* 4829 */
	{402, 0xFF},
	{111364, 0x100},
	/* 4831 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72706, 0x1000000},
	{124097, 0x2000000},
	/* 4841 */
	{72769, 0x3F},
	{124127, 0x3F},
	{72782, 0xF000},
	{72792, 0x3F0000},
	{72807, 0x400000},
	{72822, 0x800000},
	{72838, 0x7000000},
	/* 4848 */
	{124145, 0xFFFF},
	{124155, 0xFFFF0000},
	/* 4850 */
	{43290, 0x1},
	{124165, 0x2},
	{124174, 0x4},
	{124183, 0x8},
	{124191, 0x10},
	{124203, 0x20},
	{124215, 0x40},
	{124227, 0x80},
	{124239, 0x100},
	{124250, 0x200},
	{124260, 0x400},
	{124268, 0x800},
	{124294, 0x1000},
	{124307, 0x2000},
	{124318, 0x4000},
	{124328, 0x8000},
	{124342, 0x10000},
	{124358, 0x20000},
	{124374, 0x40000},
	{124390, 0x80000},
	{124401, 0x100000},
	{124418, 0x200000},
	{124434, 0x400000},
	{124453, 0x2000000},
	{124467, 0x4000000},
	{124476, 0x8000000},
	{124490, 0x30000000},
	{124505, 0x40000000},
	{124514, 0x80000000},
	/* 4879 */
	{73159, 0x1},
	{73183, 0x2},
	{73273, 0x70},
	{73285, 0xF00},
	{73298, 0xF000},
	{73311, 0xF0000},
	{73324, 0xF00000},
	{73338, 0xF000000},
	{73356, 0xF0000000},
	/* 4888 */
	{73373, 0x7FF},
	{73400, 0xFFE000},
	{73410, 0x1000000},
	{73422, 0x2000000},
	/* 4892 */
	{124528, 0xF},
	{69892, 0xF0, 16, 2765},
	{70320, 0x1F00, 18, 2781},
	{70794, 0x6000, 4, 2812},
	{70901, 0x18000, 4, 2816},
	{71013, 0x60000, 4, 2820},
	{71100, 0x180000, 4, 2824},
	/* 4899 */
	{17638, 0x3, 4, 3051},
	{74705, 0xC},
	{70510, 0xE000, 7, 2800},
	{94520, 0x700000},
	{74856, 0x8000000},
	{74871, 0x10000000},
	{74881, 0x20000000},
	{74901, 0x80000000},
	/* 4907 */
	{17638, 0x1, 2, 3059},
	{70510, 0xE000, 7, 2800},
	{94520, 0x700000},
	{74856, 0x8000000},
	{74944, 0x20000000},
	/* 4912 */
	{124547, 0x7FF},
	{124562, 0x3FF800},
	/* 4914 */
	{124578, 0x3FFFFF},
	/* 4915 */
	{54785, 0x3},
	/* 4916 */
	{79485, 0x3F},
	{79496, 0x40},
	{79539, 0x4000},
	/* 4919 */
	{11945, 0xFF},
	/* 4920 */
	{83043, 0x8},
	{1318, 0x70, 6, 36013},
	{82316, 0xFF0000, 256, 36021},
	/* 4923 */
	{18800, 0x1F, 29, 37045},
	{86642, 0x4000},
	{86655, 0x8000},
	{86668, 0x70000},
	/* 4927 */
	{87782, 0x3F, 3, 36322},
	{87795, 0x3F00, 3, 36322},
	{87810, 0x3F0000, 3, 36322},
	{87825, 0xFC00000, 3, 36322},
	{87840, 0x80000000},
	/* 4932 */
	{214, 0x3, 2, 36326},
	{87977, 0xC, 4, 36329},
	{88057, 0x30, 3, 36333},
	{88117, 0xC0, 4, 37243},
	{88130, 0x100},
	{82484, 0x200},
	{88134, 0x400},
	/* 4939 */
	{89353, 0x3F, 60, 37247},
	{64454, 0x7FC0000},
	{89364, 0x8000000},
	/* 4942 */
	{94106, 0x1},
	{89567, 0x2},
	{124706, 0x4},
	{124729, 0x8},
	{124737, 0x3F0},
	{124752, 0xFC00},
	{89646, 0x10000},
	/* 4949 */
	{220, 0x3, 3, 36420},
	{90428, 0x1C, 4, 36423},
	{90505, 0xE0, 4, 36427},
	{90514, 0x100},
	{90534, 0x200},
	{90545, 0x3C00},
	{90567, 0x4000},
	{88117, 0x18000, 4, 37243},
	/* 4957 */
	{90934, 0x1},
	{90949, 0x2},
	{90964, 0x4},
	{90979, 0x8},
	{90994, 0x70},
	{91026, 0xF00},
	{91043, 0x80000000},
	/* 4964 */
	{93395, 0x3, 4, 36472},
	{17638, 0x7C, 24, 36476},
	{69542, 0x80},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{83092, 0x2000},
	{73993, 0x4000},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94097, 0x80000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	{94370, 0x4000000},
	/* 4979 */
	{95960, 0xF00, 5, 36564},
	{100595, 0x10000},
	{100607, 0x100000},
	{100622, 0xC0000000, 4, 36570},
	/* 4983 */
	{26926, 0xFFFF},
	{95960, 0x300000, 2, 36574},
	{100670, 0x8000000, 2, 36570},
	{100692, 0x60000000, 3, 36578},
	{100700, 0x80000000},
	/* 4988 */
	{95625, 0x1FFFFF},
	{100738, 0x200000},
	{113305, 0xC00000, 4, 37307},
	{113314, 0x3000000, 4, 37307},
	{95636, 0x4000000, 2, 36582},
	{95640, 0x8000000, 2, 36582},
	{95644, 0x10000000, 2, 36584},
	{95649, 0x20000000, 2, 36584},
	{95654, 0x40000000},
	/* 4997 */
	{100670, 0x1, 2, 36570},
	{95960, 0x300000, 2, 36574},
	{100692, 0x60000000, 3, 36578},
	{100700, 0x80000000},
	/* 5001 */
	{59152, 0xF},
	{59161, 0xF0},
	{59171, 0x100},
	{59182, 0x200},
	{59187, 0x400},
	{111296, 0x800},
	{59314, 0x1FF000, 257, 0},
	{59345, 0x10000000},
	{59351, 0xE0000000},
	/* 5010 */
	{59516, 0x1FF, 257, 0},
	{59561, 0x3F0000},
	{59614, 0xE0000000},
	/* 5013 */
	{54575, 0xF},
	{59622, 0x30},
	{59630, 0xC0},
	{59638, 0xF00},
	{59644, 0x1000},
	{29204, 0x6000},
	{59662, 0xF0000},
	{59668, 0xF00000},
	{59674, 0x7000000},
	{59683, 0x38000000},
	{59692, 0xC0000000},
	/* 5024 */
	{59773, 0xF},
	{59780, 0x70},
	{59802, 0xF00},
	{59811, 0x7000},
	/* 5028 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60310, 0x4000},
	{60442, 0x1000000},
	{61380, 0x2000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	/* 5045 */
	{60997, 0x1},
	{61007, 0x2},
	{61017, 0x4},
	{61026, 0x8},
	{61035, 0x10},
	{61046, 0x20},
	{61057, 0x40},
	{61067, 0x80},
	{115266, 0x100},
	{115281, 0x200},
	{61077, 0x400},
	{61087, 0x800},
	{61104, 0x1000},
	{61222, 0x20000000},
	{61235, 0x40000000},
	{60469, 0x80000000},
	/* 5061 */
	{124792, 0x1},
	{124813, 0x2},
	{61732, 0x8},
	{61751, 0x10},
	{61771, 0x40},
	{61790, 0x100},
	{61811, 0x200},
	{61829, 0x400},
	{124834, 0x800},
	{124855, 0x1000},
	{61852, 0x2000},
	{61874, 0x10000},
	{61895, 0x20000},
	{61913, 0x40000},
	{124878, 0x80000},
	{124899, 0x100000},
	{61936, 0x200000},
	/* 5078 */
	{62051, 0x1},
	{62070, 0x2},
	{115266, 0x4},
	{115281, 0x8},
	{62079, 0x10},
	{62094, 0x20},
	{62108, 0x40},
	{62127, 0x80},
	{62146, 0x100},
	{62161, 0x200},
	{62178, 0x400},
	{62200, 0x800},
	{62222, 0x1000},
	{62237, 0x2000},
	{61077, 0x4000},
	{62252, 0x8000},
	{62397, 0x40000000},
	{60460, 0x80000000},
	/* 5096 */
	{62410, 0x1},
	{62428, 0x2},
	{62442, 0x4},
	{62461, 0x8},
	{62480, 0x10},
	{62495, 0x20},
	{62513, 0x40},
	{62531, 0x80},
	{62548, 0x100},
	{124922, 0x200},
	{62594, 0x800},
	{62618, 0x1000},
	{62636, 0x2000},
	{62654, 0x4000},
	{62675, 0x8000},
	{62699, 0x10000},
	{62725, 0x20000},
	{62742, 0x40000},
	{62762, 0x80000},
	{62782, 0x100000},
	{62802, 0x200000},
	{62823, 0x400000},
	{62846, 0x800000},
	{62867, 0x1000000},
	{62886, 0x2000000},
	{62903, 0x4000000},
	{62919, 0x8000000},
	{62935, 0x10000000},
	{62951, 0x20000000},
	{62970, 0x40000000},
	{62982, 0x80000000},
	/* 5127 */
	{62994, 0x1},
	{63013, 0x2},
	{63033, 0x4},
	{63053, 0x8},
	{113956, 0x10},
	{63073, 0x20},
	{63094, 0x40},
	/* 5134 */
	{119536, 0x1F},
	{119543, 0x20},
	{64141, 0x80},
	{59457, 0xF00},
	{119550, 0x3000},
	{64154, 0x4000},
	{64167, 0x8000},
	{119561, 0xFFFF0000},
	{119561, 0xFFFF0000},
	/* 5143 */
	{10330, 0xF},
	{88130, 0x10},
	/* 5145 */
	{124944, 0xFFFF},
	/* 5146 */
	{64293, 0x3FF},
	{64308, 0x3FF0000},
	{119612, 0x20000000},
	{60331, 0x40000000},
	{72682, 0x80000000},
	/* 5151 */
	{95148, 0xFFFF},
	{95160, 0x10000},
	{26989, 0xE0000000},
	/* 5154 */
	{124954, 0x1000},
	{95256, 0x6000},
	{124962, 0x8000},
	{95285, 0x300000},
	{124975, 0x1000000},
	{95296, 0x6000000},
	{124983, 0x8000000},
	{95325, 0x60000000},
	/* 5162 */
	{124996, 0x7F},
	{125008, 0x3F000},
	{11925, 0x6000000},
	{95939, 0x8000000},
	/* 5166 */
	{27979, 0xFFFF},
	{95960, 0x30000},
	{95968, 0x7000000},
	{95976, 0xE0000000},
	/* 5170 */
	{96952, 0x3F},
	{96957, 0xC0},
	{96965, 0x100},
	{96971, 0xFFFFFE00},
	/* 5174 */
	{85076, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{92957, 0x4000},
	{96979, 0x8000},
	{96991, 0x7FF0000},
	{97002, 0x8000000},
	{97013, 0x10000000},
	{96957, 0xE0000000},
	/* 5183 */
	{97126, 0x3F},
	{97136, 0xFC00},
	/* 5185 */
	{97085, 0x3F},
	{97094, 0xFC00},
	{98642, 0xF00000},
	/* 5188 */
	{97085, 0xFF},
	{98778, 0xF000},
	{119437, 0xF0000},
	{50369, 0xF00000},
	{119453, 0xF000000},
	{98696, 0xF0000000},
	/* 5194 */
	{56162, 0xFF},
	{10701, 0xFFFFFF00},
	/* 5196 */
	{26926, 0xFFFF},
	{95960, 0x300000, 4, 37311},
	{100670, 0x8000000, 2, 36570},
	{100692, 0x60000000, 4, 36578},
	{100700, 0x80000000},
	/* 5201 */
	{100670, 0x1, 2, 36570},
	{95256, 0x6000},
	{95960, 0x300000, 4, 37311},
	{95296, 0x6000000},
	{100692, 0x60000000, 4, 36578},
	{100700, 0x80000000},
	/* 5207 */
	{59152, 0xF},
	{59161, 0xF0},
	{59171, 0x100},
	{59182, 0x200},
	{59187, 0x400},
	{111296, 0x800},
	{59314, 0x1FF000, 257, 0},
	{125025, 0x8000000},
	{59345, 0x10000000},
	{59351, 0xE0000000},
	/* 5217 */
	{59355, 0x1},
	{59359, 0x6},
	{59368, 0x18},
	{59378, 0x20},
	{59383, 0x40},
	{59391, 0x80},
	{59401, 0x100},
	{59412, 0x200},
	{59418, 0x400},
	{59423, 0x800},
	{59429, 0x1000},
	{59440, 0x2000},
	{59445, 0x4000},
	{111315, 0x8000},
	{59201, 0x10000},
	{59465, 0x20000},
	{59473, 0x40000},
	{59485, 0x80000},
	{111328, 0x100000},
	{111342, 0x200000},
	{125036, 0x400000},
	{111364, 0x800000},
	{59504, 0x8000000},
	/* 5240 */
	{59516, 0x1FF, 257, 0},
	{59521, 0x400},
	{59561, 0x3F0000},
	{59614, 0xE0000000},
	/* 5244 */
	{59773, 0xF},
	{59780, 0x70},
	{59802, 0xF00},
	{59811, 0x7000},
	{59820, 0x8000},
	{59833, 0xF0000},
	/* 5250 */
	{111393, 0x7},
	{111401, 0x8},
	{111412, 0x10},
	{111425, 0xE0},
	{111441, 0x300},
	{111451, 0xC00},
	{111461, 0xF0000},
	{59936, 0xF00000},
	{111473, 0x3000000},
	{111480, 0x4000000},
	{111487, 0x18000000},
	{73651, 0x20000000},
	{111495, 0x40000000},
	/* 5263 */
	{125049, 0x1},
	{59881, 0x2},
	{59887, 0x4},
	{59916, 0xF0},
	{59921, 0xF00},
	/* 5268 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60310, 0x4000},
	{60442, 0x1000000},
	{61380, 0x2000000},
	{125056, 0x4000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	/* 5286 */
	{60997, 0x1},
	{61007, 0x2},
	{61017, 0x4},
	{61026, 0x8},
	{61035, 0x10},
	{61046, 0x20},
	{61057, 0x40},
	{61067, 0x80},
	{61077, 0x400},
	{61087, 0x800},
	{61104, 0x1000},
	{125072, 0x2000},
	{61222, 0x20000000},
	{61235, 0x40000000},
	{60469, 0x80000000},
	/* 5301 */
	{61732, 0x8},
	{61751, 0x10},
	{61771, 0x40},
	{61790, 0x100},
	{61811, 0x200},
	{61829, 0x400},
	{61852, 0x2000},
	{61874, 0x10000},
	{61895, 0x20000},
	{61913, 0x40000},
	{61936, 0x200000},
	{125085, 0x400000},
	{125109, 0x800000},
	{125133, 0x1000000},
	/* 5315 */
	{62051, 0x1},
	{62070, 0x2},
	{62079, 0x10},
	{62094, 0x20},
	{62108, 0x40},
	{62127, 0x80},
	{62146, 0x100},
	{62161, 0x200},
	{62178, 0x400},
	{62200, 0x800},
	{62222, 0x1000},
	{62237, 0x2000},
	{61077, 0x4000},
	{62252, 0x8000},
	{62261, 0x10000},
	{125072, 0x20000},
	{62352, 0x4000000},
	{62365, 0x8000000},
	{62378, 0x30000000},
	{62397, 0x40000000},
	{60460, 0x80000000},
	/* 5336 */
	{62994, 0x1},
	{63013, 0x2},
	{63033, 0x4},
	{63053, 0x8},
	{63073, 0x20},
	{63094, 0x40},
	{125085, 0x80},
	{125109, 0x100},
	{125133, 0x200},
	/* 5345 */
	{64494, 0x7, 8, 37074},
	{64504, 0x38, 8, 37074},
	{64514, 0x1C0, 8, 37074},
	{64524, 0xE00, 8, 37074},
	{110214, 0x7000, 8, 37315},
	{110202, 0x78000, 16, 37090},
	{120582, 0x180000},
	{68761, 0x600000},
	{68774, 0x800000},
	{88130, 0x1000000},
	{120595, 0x2000000},
	{120607, 0x4000000},
	{88143, 0x38000000},
	{220, 0xC0000000, 4, 37106},
	/* 5359 */
	{64449, 0xFF},
	{69095, 0xFFF00},
	{110202, 0x3F00000, 64, 37110},
	{110214, 0x3C000000, 16, 37323},
	{88143, 0xC0000000},
	/* 5364 */
	{71296, 0xFFF},
	{71360, 0xFF000},
	{71333, 0x100000},
	{71482, 0x200000},
	{71497, 0x400000},
	{71513, 0x800000},
	{125316, 0xF000000},
	{125332, 0xF0000000},
	/* 5372 */
	{68906, 0x7, 8, 37206},
	{68914, 0x38, 8, 37206},
	{68922, 0x1C0, 8, 37206},
	{68930, 0xE00},
	{68946, 0x7000, 8, 37214},
	{68965, 0x8000},
	{68984, 0x70000},
	{69000, 0x80000},
	{69015, 0x100000},
	{69029, 0x7E00000},
	{69040, 0x8000000},
	{69052, 0x10000000},
	{69070, 0x60000000, 3, 37222},
	{125348, 0x80000000},
	/* 5386 */
	{69127, 0x3FFF},
	{69136, 0xFC000},
	{69149, 0x300000, 4, 37225},
	{69163, 0xC00000, 4, 37225},
	{69177, 0x3000000, 3, 37229},
	{69186, 0xC000000, 4, 37339},
	{69197, 0x10000000},
	{123752, 0x20000000},
	{123769, 0x40000000},
	{69216, 0x80000000},
	/* 5396 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{72272, 0x100},
	{72284, 0x200},
	{72296, 0x400},
	{72308, 0x800},
	{72320, 0x1000},
	{59314, 0x3FE000, 257, 0},
	{72337, 0x1000000},
	/* 5407 */
	{88130, 0x1},
	{88143, 0x6},
	/* 5409 */
	{17638, 0x3, 4, 3051},
	{74705, 0xC},
	{70510, 0xE000, 7, 2800},
	{94520, 0x700000},
	{74832, 0x7800000},
	{74856, 0x8000000},
	{74871, 0x10000000},
	{74881, 0x20000000},
	{125394, 0x40000000},
	{74901, 0x80000000},
	/* 5419 */
	{17638, 0x1, 2, 3059},
	{70510, 0xE000, 7, 2800},
	{94520, 0x700000},
	{74856, 0x8000000},
	{74944, 0x20000000},
	{125394, 0x40000000},
	/* 5425 */
	{78033, 0x1},
	{125411, 0x2},
	{78060, 0x7C},
	/* 5428 */
	{83043, 0x8},
	{1318, 0x70, 7, 36013},
	{82316, 0xFF0000, 256, 36021},
	/* 5431 */
	{84788, 0x1},
	{84804, 0x2},
	{84820, 0x4},
	{84836, 0x8},
	{84852, 0x10},
	{84868, 0x20},
	{84884, 0x40},
	{84900, 0x80},
	{84916, 0x100},
	{84932, 0x200},
	{84948, 0x400},
	{84964, 0x800},
	{84980, 0x1000},
	{84996, 0x2000},
	{85012, 0x4000},
	{85028, 0x8000},
	{85044, 0x10000},
	{85063, 0x20000},
	{85081, 0x40000},
	{85108, 0x80000},
	{85130, 0x100000},
	{85148, 0x200000},
	{85168, 0x400000},
	{85191, 0x800000},
	{85214, 0x1000000},
	{85239, 0x2000000},
	{85282, 0x4000000},
	/* 5458 */
	{1318, 0x7, 6, 36312},
	{86835, 0x8},
	{86891, 0x30, 4, 36318},
	{86900, 0x7C0},
	{86911, 0x800},
	{86924, 0x1000},
	{86935, 0x2000},
	{97283, 0x4000},
	{125450, 0x8000},
	{125461, 0x10000},
	{86994, 0x20000},
	{87013, 0x40000},
	{87027, 0x80000},
	{87045, 0x100000},
	{87063, 0x600000},
	/* 5473 */
	{214, 0x3, 3, 36326},
	{87977, 0xC, 4, 36329},
	{88057, 0x30, 4, 36333},
	{88117, 0x40, 2, 36337},
	{82484, 0x200},
	{88134, 0x400},
	{88143, 0x1800},
	/* 5480 */
	{89353, 0x3F, 61, 37343},
	{64454, 0x7FC0000},
	{89364, 0x8000000},
	/* 5483 */
	{89469, 0xFFFF},
	{89484, 0x10000},
	{89503, 0x20000},
	{89517, 0x40000},
	{89536, 0x80000},
	{89550, 0x100000},
	{90194, 0xF0000000},
	/* 5490 */
	{94106, 0x1},
	{89567, 0x2},
	{124706, 0x4},
	{124729, 0x8},
	{124737, 0x3F0},
	{124752, 0xFC00},
	{89646, 0x10000},
	{125472, 0x20000},
	/* 5498 */
	{220, 0x3, 3, 36420},
	{90428, 0x1C, 4, 36423},
	{90505, 0xE0, 4, 36427},
	{90514, 0x100},
	{90534, 0x200},
	{90545, 0x3C00},
	{90567, 0x4000},
	{88117, 0x8000, 2, 36337},
	{90601, 0x60000, 3, 36431},
	{88143, 0x180000},
	/* 5508 */
	{93395, 0x3, 4, 36472},
	{17638, 0x7C, 24, 36476},
	{69542, 0x80},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{83092, 0x2000},
	{73993, 0x4000},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94097, 0x80000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	{94370, 0x4000000},
	{94396, 0x8000000},
	{94422, 0x10000000},
	{94490, 0x60000000, 3, 36528},
	/* 5526 */
	{11925, 0x2000000},
	{88143, 0x18000000},
	/* 5528 */
	{95148, 0xFFFF},
	{95160, 0x10000},
	{95076, 0x2000000},
	{88143, 0x18000000},
	{26989, 0xE0000000},
	/* 5533 */
	{26557, 0xFFFF},
	{88143, 0x300000},
	{95076, 0x400000},
	/* 5536 */
	{26629, 0xFFFF},
	{88143, 0x300000},
	{95076, 0x400000},
	/* 5539 */
	{125486, 0xC00},
	{124954, 0x1000},
	{95256, 0x2000},
	{95285, 0x300000},
	{125496, 0xC00000},
	{124975, 0x1000000},
	{95296, 0x2000000},
	{95325, 0x60000000},
	/* 5547 */
	{96139, 0x1},
	{96155, 0x2},
	{125506, 0x4},
	{95373, 0x8},
	{96171, 0x40},
	{96189, 0x80},
	{96207, 0x100},
	{96225, 0x200},
	{96243, 0x400},
	{96261, 0x800},
	{96279, 0x1000},
	{96297, 0x2000},
	{96315, 0x4000},
	{95434, 0x8000},
	{95454, 0x40000},
	{96332, 0x80000},
	{96348, 0x200000},
	{95471, 0x400000},
	{95487, 0x800000},
	{95501, 0x2000000},
	{95515, 0x4000000},
	{95529, 0x8000000},
	{95550, 0x10000000},
	{95575, 0x20000000},
	{95596, 0x40000000},
	{125523, 0x80000000},
	/* 5573 */
	{124996, 0x7F},
	{125008, 0x3F000},
	{11925, 0x2000000},
	{88143, 0x18000000},
	/* 5577 */
	{97030, 0xFFFF},
	{97054, 0xF0000},
	{97041, 0x300000},
	{96432, 0x3FC00000},
	{97062, 0x40000000},
	{10218, 0x80000000},
	/* 5583 */
	{64449, 0xFF},
	{69095, 0xFFF00},
	{110202, 0x3F00000, 64, 37404},
	{110214, 0x3C000000, 16, 37323},
	{88143, 0xC0000000},
	/* 5588 */
	{83025, 0x1},
	{83043, 0x8},
	{1318, 0x70, 7, 36013},
	{82316, 0xFF0000, 256, 36021},
	/* 5592 */
	{89811, 0xFF},
	{89825, 0xFF00},
	{89835, 0xFF0000},
	{89846, 0xFF000000},
	/* 5596 */
	{93395, 0x3, 4, 36472},
	{17638, 0x7C, 31, 36476},
	{69542, 0x80},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{83092, 0x2000},
	{73993, 0x4000},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94097, 0x80000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	{94370, 0x4000000},
	{94396, 0x8000000},
	{94422, 0x10000000},
	{94490, 0x60000000, 3, 36528},
	/* 5614 */
	{85076, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{92957, 0x4000},
	{96979, 0x8000},
	{96991, 0xFFF0000},
	{97002, 0x10000000},
	{97013, 0x20000000},
	{96957, 0xC0000000},
	/* 5623 */
	{59152, 0xF},
	{59161, 0xF0},
	{59171, 0x100},
	{59182, 0x200},
	{59187, 0x400},
	{111296, 0x800},
	{59314, 0x1FF000, 257, 0},
	{59322, 0x800000},
	{125841, 0x1000000},
	{125854, 0x2000000},
	{59332, 0x4000000},
	{125025, 0x8000000},
	{59345, 0x10000000},
	{59351, 0xE0000000},
	/* 5637 */
	{59355, 0x1},
	{59359, 0x6},
	{59368, 0x18},
	{59378, 0x20},
	{59383, 0x40},
	{59391, 0x80},
	{59401, 0x100},
	{59412, 0x200},
	{59418, 0x400},
	{59423, 0x800},
	{59429, 0x1000},
	{59440, 0x2000},
	{59445, 0x4000},
	{111315, 0x8000},
	{59201, 0x10000},
	{59465, 0x20000},
	{59473, 0x40000},
	{59485, 0x80000},
	{111328, 0x100000},
	{111342, 0x200000},
	{125036, 0x400000},
	{59493, 0x800000},
	{59504, 0x8000000},
	/* 5660 */
	{59516, 0x1FF, 257, 0},
	{59521, 0x400},
	{59529, 0x800},
	{59542, 0x7000},
	{59561, 0x3F0000},
	{59602, 0x10000000},
	{59614, 0xE0000000},
	/* 5667 */
	{59773, 0xF},
	{59780, 0x70},
	{59802, 0xF00},
	{59811, 0x7000},
	{59820, 0x8000},
	{59833, 0x1F0000},
	{59838, 0xC00000},
	/* 5674 */
	{111393, 0x7},
	{111401, 0x8},
	{111412, 0x10},
	{111425, 0xE0},
	{111441, 0x300},
	{111451, 0xC00},
	{111461, 0xF0000},
	{111473, 0x3000000},
	{111480, 0x4000000},
	{111487, 0x18000000},
	{73651, 0x20000000},
	{111495, 0x40000000},
	{125867, 0x80000000},
	/* 5687 */
	{125049, 0x1},
	{59881, 0x2},
	{59887, 0x4},
	{59916, 0x1F0},
	{59921, 0xF800},
	{59833, 0x7C0000},
	{59936, 0xFE000000},
	/* 5694 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60310, 0x4000},
	{60325, 0x8000},
	{60336, 0x10000},
	{60344, 0x20000},
	{60353, 0x40000},
	{60370, 0x80000},
	{60385, 0x100000},
	{60442, 0x1000000},
	{61380, 0x2000000},
	{125056, 0x4000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	{60487, 0x80000000},
	/* 5719 */
	{60498, 0xF},
	{60521, 0x20},
	{60537, 0x80},
	{60560, 0x100},
	{60583, 0x200},
	{60602, 0x1000},
	{60611, 0x2000},
	{60620, 0x4000},
	{60628, 0x8000},
	{112168, 0x10000},
	{112183, 0x20000},
	{112192, 0x40000},
	{112207, 0x80000},
	{60652, 0x100000},
	{112215, 0x200000},
	{60668, 0x400000},
	{60677, 0x800000},
	{60686, 0x1000000},
	{60694, 0x2000000},
	{60702, 0x4000000},
	{60710, 0x10000000},
	{60452, 0x20000000},
	{60728, 0x40000000},
	{60736, 0x80000000},
	/* 5743 */
	{60602, 0x2},
	{60611, 0x4},
	{60344, 0x200000},
	{60677, 0x400000},
	{112183, 0x800000},
	{60694, 0x1000000},
	{60620, 0x2000000},
	{60652, 0x4000000},
	{60668, 0x8000000},
	{60686, 0x20000000},
	{60702, 0x40000000},
	{60728, 0x80000000},
	/* 5755 */
	{60997, 0x1},
	{61007, 0x2},
	{61017, 0x4},
	{61026, 0x8},
	{61035, 0x10},
	{61046, 0x20},
	{61057, 0x40},
	{61067, 0x80},
	{61077, 0x400},
	{61087, 0x800},
	{61104, 0x1000},
	{61112, 0x2000},
	{61125, 0x4000},
	{61222, 0x20000000},
	{61235, 0x40000000},
	{60469, 0x80000000},
	/* 5771 */
	{62051, 0x1},
	{62070, 0x2},
	{62079, 0x10},
	{62094, 0x20},
	{62108, 0x40},
	{62127, 0x80},
	{62146, 0x100},
	{62161, 0x200},
	{62178, 0x400},
	{62200, 0x800},
	{62222, 0x1000},
	{62237, 0x2000},
	{61077, 0x4000},
	{62252, 0x8000},
	{62261, 0x10000},
	{61112, 0x20000},
	{62352, 0x4000000},
	{62365, 0x8000000},
	{62378, 0x30000000},
	{62397, 0x40000000},
	{60460, 0x80000000},
	/* 5792 */
	{64494, 0x7, 8, 37074},
	{64504, 0x38, 8, 37074},
	{64514, 0x1C0, 8, 37074},
	{64524, 0xE00, 8, 37074},
	{110214, 0x7000, 8, 37468},
	{110202, 0x78000, 16, 37090},
	{125912, 0x80000},
	{125927, 0x100000},
	{68761, 0x600000},
	{68774, 0x800000},
	{86729, 0x8000000},
	{220, 0xC0000000, 4, 37106},
	/* 5804 */
	{64449, 0xFF},
	{69095, 0xFFF00},
	{110202, 0x3F00000, 64, 37476},
	{126411, 0x3F00000, 61, 37540},
	{110214, 0x3C000000, 16, 37601},
	{126918, 0x3C000000, 16, 37617},
	{86729, 0x40000000},
	{126935, 0x80000000},
	/* 5812 */
	{64494, 0x7, 8, 37074},
	{64504, 0x38, 8, 37074},
	{64514, 0x1C0, 8, 37074},
	{64524, 0xE00, 8, 37074},
	{71128, 0xF000},
	{71139, 0xF0000},
	{71150, 0x1F00000},
	{220, 0xF0000000, 16, 37190},
	/* 5820 */
	{18784, 0x1FFF},
	{21500, 0x1FFFE000},
	{71254, 0xE0000000, 6, 2828},
	/* 5823 */
	{71265, 0x1FFF},
	{71276, 0x1E000},
	{126947, 0x1FE0000},
	{94970, 0x2000000},
	{71442, 0x4000000},
	{126965, 0x8000000},
	{71288, 0xF0000000},
	/* 5830 */
	{69127, 0x3FFF},
	{69136, 0xFC000},
	{69149, 0x300000, 4, 37225},
	{69163, 0xC00000, 4, 37225},
	{69177, 0x3000000, 3, 37229},
	{69186, 0xC000000, 4, 37339},
	{69197, 0x10000000},
	{69231, 0x20000000},
	{123769, 0x40000000},
	{69216, 0x80000000},
	/* 5840 */
	{69246, 0xFFF},
	{69082, 0x1000},
	{69263, 0xC0000000, 4, 37235},
	/* 5843 */
	{69451, 0x7},
	{69461, 0x38},
	{69482, 0xC0},
	{123927, 0x700},
	{71100, 0x7000, 4, 2824},
	{123948, 0x70000},
	{69503, 0x180000},
	{123972, 0xE00000},
	{123981, 0x3000000},
	{69522, 0xC000000},
	{124001, 0x30000000},
	{124010, 0x40000000},
	{126981, 0x80000000},
	/* 5856 */
	{71550, 0xFFFF},
	{71556, 0x3F0000},
	{71567, 0x3C00000},
	{126991, 0x3C000000},
	/* 5860 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{71712, 0x1000000},
	{124097, 0x10000000},
	{59322, 0x20000000},
	/* 5871 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{71775, 0x80},
	{71787, 0xFF00},
	{59314, 0x1FF0000, 257, 0},
	{71802, 0x2000000},
	{71824, 0x4000000},
	{72354, 0x8000000},
	{71849, 0x10000000},
	/* 5881 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72232, 0x3000000},
	{72246, 0x4000000},
	{124097, 0x40000000},
	{59322, 0x80000000},
	/* 5893 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72262, 0x80},
	{72272, 0x100},
	{72284, 0x200},
	{72296, 0x400},
	{72308, 0x800},
	{72320, 0x1000},
	{59314, 0x3FE000, 257, 0},
	{72326, 0x400000},
	{72337, 0x1000000},
	{72354, 0x8000000},
	{71849, 0x10000000},
	/* 5907 */
	{72391, 0x7F},
	{72366, 0x3F80},
	/* 5909 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72246, 0x1000000},
	{124097, 0x10000000},
	{72417, 0x60000000},
	{59322, 0x80000000},
	/* 5921 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59314, 0xFF80, 257, 0},
	{72434, 0x30000},
	{72262, 0x40000},
	{59747, 0x7F80000},
	{72354, 0x8000000},
	{71849, 0x10000000},
	/* 5930 */
	{71556, 0x3F},
	{71567, 0x3C0},
	{126991, 0x3C00},
	{71550, 0xFFFF0000},
	/* 5934 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{124097, 0x8000000},
	{72451, 0x30000000},
	{59322, 0x40000000},
	/* 5945 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{59314, 0xFF80, 257, 0},
	{59747, 0x1FF0000},
	{72354, 0x8000000},
	{71849, 0x10000000},
	/* 5952 */
	{72479, 0x1},
	{72497, 0x2},
	{72511, 0x4},
	{72530, 0x8},
	{72550, 0x10},
	{72570, 0x20},
	{72592, 0x40},
	{72603, 0x400},
	{72621, 0x800},
	{10701, 0x1000},
	{72653, 0x4000},
	/* 5963 */
	{71595, 0x3F},
	{71601, 0x3C0},
	{69291, 0xC00},
	{71691, 0xFF000, 193, 2834},
	{59378, 0x100000},
	{59171, 0x200000},
	{124076, 0x400000},
	{71702, 0x800000},
	{72706, 0x1000000},
	{124097, 0x2000000},
	{59322, 0x4000000},
	/* 5974 */
	{71741, 0x1},
	{71752, 0x3E},
	{71762, 0x40},
	{72712, 0x80},
	{72722, 0x100},
	{72732, 0x200},
	{72468, 0x400},
	{72742, 0x1800},
	{72757, 0x6000},
	{59747, 0xFF8000},
	{59314, 0x7F000000, 257, 0},
	{72354, 0x80000000},
	/* 5986 */
	{72769, 0x3FF},
	{72782, 0xF000},
	{72792, 0x3F0000},
	{72807, 0x400000},
	{72822, 0x800000},
	{72838, 0x7000000},
	{126991, 0x78000000},
	/* 5993 */
	{73373, 0x7FF},
	{73400, 0xFFE000},
	{73410, 0x1000000},
	{73422, 0x2000000},
	{73440, 0x3C000000},
	/* 5998 */
	{17638, 0x3, 4, 3051},
	{74705, 0xC},
	{71150, 0x1F0},
	{74789, 0x1000},
	{74760, 0x6000, 4, 3055},
	{74775, 0x8000},
	{74825, 0xF0000},
	{74832, 0x7800000},
	{74856, 0x8000000},
	{74871, 0x10000000},
	{74881, 0x20000000},
	{125394, 0x40000000},
	{74901, 0x80000000},
	/* 6011 */
	{17638, 0x1, 2, 3059},
	{71150, 0x1F0},
	{74789, 0x1000},
	{74760, 0x6000, 4, 3055},
	{74775, 0x8000},
	{74856, 0x8000000},
	{74944, 0x20000000},
	{125394, 0x40000000},
	/* 6019 */
	{58832, 0xFFFF},
	/* 6020 */
	{75774, 0x3, 4, 35838},
	{75786, 0xC, 4, 35838},
	{75898, 0x30, 4, 35842},
	{75955, 0x40, 2, 35846},
	{76011, 0x80, 2, 35848},
	{76115, 0x300, 4, 35850},
	{76223, 0xC00, 4, 35854},
	{76332, 0x3000, 4, 35858},
	{76445, 0xC000, 4, 35862},
	{76547, 0x30000, 4, 35866},
	{76693, 0xC0000, 4, 35870},
	{76840, 0x300000, 4, 35874},
	{76940, 0x3000000, 4, 35878},
	{77086, 0x1C000000, 5, 37633},
	{77233, 0xE0000000, 5, 37638},
	/* 6035 */
	{77353, 0x3, 4, 35890},
	{77524, 0x1C, 5, 37643},
	{77696, 0xE0, 5, 37648},
	/* 6038 */
	{78033, 0x1},
	{125411, 0x2},
	{78060, 0x7C},
	{78089, 0x100},
	{78118, 0x200},
	{78149, 0x400},
	{78177, 0x1000},
	{78205, 0x2000},
	{78235, 0x4000},
	/* 6047 */
	{84788, 0x1},
	{84804, 0x2},
	{84820, 0x4},
	{84836, 0x8},
	{84852, 0x10},
	{84868, 0x20},
	{84884, 0x40},
	{84900, 0x80},
	{84916, 0x100},
	{84932, 0x200},
	{84948, 0x400},
	{84964, 0x800},
	{84980, 0x1000},
	{84996, 0x2000},
	{85012, 0x4000},
	{85028, 0x8000},
	{85044, 0x10000},
	{85063, 0x20000},
	{85081, 0x40000},
	{85108, 0x80000},
	{85130, 0x100000},
	{85148, 0x200000},
	{85168, 0x400000},
	{85191, 0x800000},
	{85214, 0x1000000},
	{85239, 0x2000000},
	{85282, 0x4000000},
	{85259, 0x8000000},
	/* 6075 */
	{85955, 0x1},
	{85966, 0x2},
	{127158, 0x4},
	/* 6078 */
	{96733, 0x1},
	{86136, 0x1E},
	{86148, 0xE0},
	{86162, 0x300},
	{86178, 0x1C00},
	{86189, 0x1E000},
	/* 6084 */
	{214, 0x3, 3, 36326},
	{87977, 0xC, 4, 36329},
	{88057, 0x30, 4, 36333},
	{88117, 0x40, 2, 36337},
	{90167, 0x100},
	{82484, 0x200},
	{88134, 0x400},
	/* 6091 */
	{89353, 0x3F, 64, 37653},
	{64454, 0x7FFFC00},
	{89364, 0x8000000},
	/* 6094 */
	{58951, 0xFFFF},
	/* 6095 */
	{89394, 0x1},
	{89408, 0x2},
	{127221, 0x4},
	{89424, 0x8},
	/* 6099 */
	{89567, 0x2},
	{124706, 0x4},
	{124729, 0x8},
	{124737, 0x3F0},
	{124752, 0xFC00},
	{89646, 0x10000},
	{71447, 0x40000},
	{126970, 0x80000},
	/* 6107 */
	{89918, 0x3, 4, 36404},
	{89949, 0x4, 2, 36408},
	{20094, 0x18, 4, 36410},
	{90031, 0x20, 2, 36414},
	{90096, 0xC0, 4, 36416},
	{72337, 0x200},
	{90113, 0x400},
	{90133, 0x800},
	{90153, 0x1000},
	{90167, 0x2000},
	{90178, 0x4000},
	{90194, 0x78000},
	{90214, 0x180000},
	/* 6120 */
	{220, 0x3, 3, 36420},
	{90428, 0x1C, 4, 36423},
	{90505, 0xE0, 4, 36427},
	{90514, 0x100},
	{90534, 0x200},
	{90567, 0x4000},
	{88117, 0x8000, 2, 36337},
	{90601, 0x60000, 4, 36431},
	/* 6128 */
	{73373, 0x7FF},
	{73400, 0xFFE000},
	{93334, 0xF000000},
	/* 6131 */
	{93395, 0x3, 4, 36472},
	{17638, 0x7C, 32, 36476},
	{93993, 0x700, 8, 36508},
	{94049, 0x1800, 4, 36516},
	{83092, 0x2000},
	{73993, 0x4000},
	{94059, 0x8000},
	{94071, 0x10000},
	{94084, 0x20000},
	{91663, 0x40000},
	{94324, 0x700000, 8, 36520},
	{94346, 0x3800000, 8, 36520},
	{94370, 0x4000000},
	{94396, 0x8000000},
	{94422, 0x10000000},
	{94490, 0x60000000, 3, 36528},
	/* 6147 */
	{94959, 0x7FF},
	{94970, 0x800},
	{74705, 0x7000},
	{94576, 0x18000},
	{94590, 0x20000},
	{94982, 0x7C0000},
	{94996, 0xF800000},
	{95010, 0x30000000},
	{126970, 0x40000000},
	{71447, 0x80000000},
	/* 6157 */
	{95148, 0xFFFF},
	{95160, 0x10000},
	{95076, 0x2000000},
	{26989, 0xE0000000},
	/* 6161 */
	{26557, 0xFFFF},
	{95076, 0x400000},
	/* 6163 */
	{26629, 0xFFFF},
	{95076, 0x400000},
	/* 6165 */
	{95243, 0x400},
	{95256, 0x2000},
	{95285, 0x300000},
	{95296, 0x2000000},
	{95325, 0x60000000},
	/* 6170 */
	{95670, 0x1},
	{95704, 0x30},
	{95716, 0xF0000},
	{95729, 0x10000000},
	{95744, 0x20000000},
	{95758, 0xC0000000},
	/* 6176 */
	{124996, 0x7F},
	{125008, 0x3F000},
	{95076, 0x2000000},
	{95952, 0x10000000},
	/* 6180 */
	{96382, 0xF},
	{96394, 0xF0},
	{112329, 0xF00},
	{127240, 0xF000},
	{96422, 0x30000},
	{96432, 0xC0000},
	{10218, 0x100000},
	{10701, 0xFFE00000},
	/* 6188 */
	{214, 0x3, 3, 36326},
	{90167, 0x100},
	/* 6190 */
	{119620, 0x7},
	{119628, 0x38},
	{119636, 0x1C0},
	{119644, 0xE00},
	{119652, 0x7000},
	{119660, 0x38000},
	{119668, 0x1C0000},
	{1318, 0x600000},
	{119676, 0x1800000},
	{119689, 0x2000000},
	{127249, 0x4000000},
	{119702, 0x18000000},
	{119713, 0x20000000},
	{64114, 0x40000000},
	{69065, 0x80000000},
	/* 6205 */
	{64293, 0x3FF},
	{64308, 0x3FF0000},
	{101035, 0x10000000},
	{119612, 0x20000000},
	{60331, 0x40000000},
	{72682, 0x80000000},
	/* 6211 */
	{85076, 0x1},
	{983, 0x1FFE},
	{220, 0x2000},
	{92957, 0x4000},
	{96979, 0x8000},
	{96991, 0xFFF0000},
	{97002, 0x10000000},
	{97013, 0x20000000},
	{97023, 0x40000000},
	{96957, 0x80000000},
	/* 6221 */
	{109397, 0xF},
	{109412, 0x10},
	{127260, 0x20},
	{109436, 0x40},
	{109452, 0x80},
	{127280, 0x100},
	{127306, 0x200},
	{109510, 0x3C00},
	{109526, 0x4000},
	{109547, 0x8000},
	{127323, 0xFFFF0000},
	/* 6232 */
	{109810, 0x3},
	{127337, 0xC},
	{109823, 0x30},
	{109836, 0xC0},
	/* 6236 */
	{127350, 0x3FF},
	{127360, 0xFFC00},
	{50369, 0xF00000},
	{97104, 0xF000000},
	{97115, 0xF0000000},
	/* 6241 */
	{127370, 0x3FF},
	{127380, 0xFFC00},
	{97146, 0xF000000},
	{97157, 0xF0000000},
	/* 6245 */
	{452, 0x7},
	{11568, 0x40000000},
	{10218, 0x80000000},
	/* 6248 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{112974, 0x1000},
	{97958, 0x2000},
	{97984, 0x4000},
	{98010, 0x10000},
	{98037, 0x20000},
	{98063, 0x40000},
	{98089, 0x80000},
	{98117, 0x100000},
	{98143, 0x200000},
	{98169, 0x400000},
	{113001, 0x800000},
	{98195, 0x1000000},
	{98222, 0x2000000},
	{98249, 0x4000000},
	{113027, 0x8000000},
	{113053, 0x10000000},
	{98329, 0x20000000},
	{98358, 0x40000000},
	{98384, 0x80000000},
	/* 6270 */
	{97085, 0x3F},
	{97904, 0x400},
	{97931, 0x800},
	{97958, 0x1000},
	{97984, 0x2000},
	{98010, 0x8000},
	{98037, 0x10000},
	{98117, 0x20000},
	{98143, 0x40000},
	{112974, 0x80000},
	{98063, 0x100000},
	{98222, 0x200000},
	{98384, 0x400000},
	/* 6283 */
	{127390, 0xFF},
	{10701, 0xFFFFFF00},
	/* 6285 */
	{59355, 0x1},
	{59359, 0x6},
	{59368, 0x18},
	{59378, 0x20},
	{59383, 0x40},
	{59391, 0x80},
	{59401, 0x100},
	{59412, 0x200},
	{59418, 0x400},
	{59423, 0x800},
	{59429, 0x1000},
	{59440, 0x2000},
	{59445, 0x4000},
	{111315, 0x8000},
	{59201, 0x10000},
	{59465, 0x20000},
	{59473, 0x40000},
	{59485, 0x80000},
	{111328, 0x100000},
	{111342, 0x200000},
	{125036, 0x400000},
	{59493, 0x800000},
	{59504, 0x8000000},
	{71741, 0x10000000},
	{43290, 0x80000000},
	/* 6310 */
	{59516, 0x1FF, 257, 0},
	{59521, 0x400},
	{59529, 0x800},
	{59542, 0x7000},
	{59561, 0x3F0000},
	{103324, 0x400000},
	{103262, 0x1000000},
	{103358, 0x2000000},
	{103344, 0x4000000},
	{59602, 0x10000000},
	{59614, 0xE0000000},
	/* 6321 */
	{54575, 0xF},
	{59622, 0x30},
	{59630, 0xC0},
	{59638, 0xF00},
	{59644, 0x1000},
	{29204, 0xE000},
	{59662, 0xF0000},
	{59668, 0xF00000},
	{59674, 0x7000000},
	{59683, 0x38000000},
	{59692, 0xC0000000},
	/* 6332 */
	{59698, 0x3F},
	{59708, 0xFC0},
	{127415, 0x3F000},
	{59718, 0xFC0000},
	{59728, 0xF000000},
	/* 6337 */
	{60081, 0xF},
	{60104, 0x10},
	{60127, 0x20},
	{60150, 0x40},
	{60170, 0x80},
	{60190, 0x100},
	{60210, 0x200},
	{60230, 0x400},
	{60250, 0x800},
	{60270, 0x1000},
	{60290, 0x2000},
	{60310, 0x4000},
	{60325, 0x8000},
	{60336, 0x10000},
	{60344, 0x20000},
	{60353, 0x40000},
	{60370, 0x80000},
	{60385, 0x100000},
	{127427, 0x200000},
	{127437, 0x400000},
	{60442, 0x1000000},
	{61380, 0x2000000},
	{125056, 0x4000000},
	{60460, 0x10000000},
	{60469, 0x20000000},
	{60478, 0x40000000},
	{60487, 0x80000000},
	/* 6364 */
	{103421, 0x7F},
	{127452, 0x700},
	{127472, 0x3F0000},
	{127494, 0x80000000},
	/* 6368 */
	{103421, 0x7F},
	{127472, 0x3F0000},
	{127494, 0x80000000},
	/* 6371 */
	{127512, 0x1},
	{127534, 0x2},
	{43324, 0xFFFFC},
	{127552, 0xFFF00000},
	/* 6375 */
	{2208, 0x3FF},
	/* 6376 */
	{64449, 0xFF},
	{69095, 0xFFF00},
	{110202, 0x3F00000, 64, 37476},
	{110214, 0x3C000000, 16, 37601},
	{86729, 0x40000000},
	{126935, 0x80000000},
	/* 6382 */
	{72868, 0x3},
	{72898, 0x1FFE0},
	/* 6384 */
	{59138, 0xFFFF},
	/* 6385 */
	{127579, 0x3F},
	{107169, 0x400},
	{107183, 0x800},
	{127592, 0x10000},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'A', 'T', 'O', 'M', 'I', 'C', '_', 'M', 'E', 'M', '\0', /* ATOMIC_MEM (77, 84) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (88, 102) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (104) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (120) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (130) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (140) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (154) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (174) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (185) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (198, 206) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (214, 220) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (225) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (245, 256) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (261) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (277) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (291) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (313) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (332) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (354) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (376) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (396, 402) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (407) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (433) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (447, 452, 456) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (458) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (471) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* INDIRECT_BUFFER (481, 490) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (497) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (507) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (514, 523) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (526) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (539) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (553) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (564) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (576) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (592) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (608) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DISPATCH_MESH_INDIRECT_MULTI (620) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'G', 'F', 'X', '\0', /* DISPATCH_TASKMESH_GFX (649) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_MESH_DIRECT (671) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (692) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (701) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (717) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (731) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (743) */
	'P', 'R', 'I', 'M', 'E', '_', 'U', 'T', 'C', 'L', '2', '\0', /* PRIME_UTCL2 (750) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (762) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (779) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (791) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_SH_REG_INDEX (808) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (826) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (841) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (857) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (868, 879) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (886) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (902) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (924) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (939) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (955) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (970, 983) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (991) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (1012) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (1031) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (1048) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'N', 'I', 'T', '\0', /* DISPATCH_TASK_STATE_INIT (1071) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_DIRECT_ACE (1096, 1122) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_INDIRECT_MULTI_ACE (1125) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '\0', /* EVENT_WRITE_ZPASS (1162) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_CONTEXT_REG_PAIRS (1180) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_CONTEXT_REG_PAIRS_PACKED (1202) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_SH_REG_PAIRS (1231) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_SH_REG_PAIRS_PACKED (1248) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '_', 'N', '\0', /* SET_SH_REG_PAIRS_PACKED_N (1272) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (1298) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (1310, 1318, 1320) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (1323, 1331) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1338) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1354) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1375) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1393) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1411) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1426) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1440, 1448) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1454) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1471) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1487) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1504) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1519) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1534) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1554) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1573) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1593) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1609) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1623) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1637) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1651) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1665) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1679) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1693) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1707) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1721) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1735) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1749) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1764) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1779) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1794) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1809) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1824) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1839) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1850) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1866) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1882) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1906) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (1930) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (1954) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (1967) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (1979) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (1995) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (2011) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (2024) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (2040) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (2056) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (2070) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (2087) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (2108) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (2122) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (2139) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (2160) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (2178, 2190, 2195) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (2201, 2208) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (2222) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (2242) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (2265) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (2283) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (2306) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (2332) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2358) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2384) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2410, 2426) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2431) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2452, 2468) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2479) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2500) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2523) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2552) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2582) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2614) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2645) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2678) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2687) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2705) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2723) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2741) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2759) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2777) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2795) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2813) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2831) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2847) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2862) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2876) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2890) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2904) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2918) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (2932) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (2946) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (2960) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (2974) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (2988) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (3002) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (3017) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (3032) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (3047) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (3062) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (3077) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (3092) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (3107) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (3122) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (3137) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (3152) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (3167) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (3182) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (3197) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (3212) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (3227) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (3242) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (3257) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (3272) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (3287) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (3302) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (3317) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (3332) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3351) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3370) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3389) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3408) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3427) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3446) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3465) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3484) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3503) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3522) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3542) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3562) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3582) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3602) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3622) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3642) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3660) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3678) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3696) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3714) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3732) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3750) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3768) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3786) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3810) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3835) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3859) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3880) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (3901) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (3925) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (3949) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (3975) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (4001) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (4027) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (4053) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (4079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (4105) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (4131) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (4157) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (4183) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (4209) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (4236) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (4263) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (4290) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (4317) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4344) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4371) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4398) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4425) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4452) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4479) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4506) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4533) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4560) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4587) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4614) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4641) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4668) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4695) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4722) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4749) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4776) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4803) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4826) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4859) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4886) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (4913) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (4940) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (4967) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (4991) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (5016) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (5040) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (5065) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (5086) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (5107) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (5131) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (5155) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (5181) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (5207) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (5233) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (5259) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (5285) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (5311) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5337) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5363) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5389) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5442) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5469) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5496) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5523) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5550) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5577) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5604) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5631) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5658) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5685) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5712) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5739) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5766) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5793) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5820) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5847) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5874) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (5901) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (5928) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (5955) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (5982) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (6009) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (6032) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (6065) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (6092) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (6119) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (6146) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (6173) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (6200) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (6227) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (6254) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (6279) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (6303) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (6335) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6367) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6391) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6439) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6460) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6481) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6505) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6529) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6555) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6581) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6607) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6633) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6659) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6685) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6711) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6737) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6763) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6789) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6816) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6843) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6870) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (6897) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (6924) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (6951) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (6978) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (7005) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (7032) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (7059) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (7086) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (7113) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (7140) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (7167) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (7194) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (7221) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (7248) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (7275) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (7302) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (7329) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7356) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7383) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7408) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7443) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7472) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7501) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7530) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7559) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7586) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7610) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7631) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7652) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7676) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7700) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7726) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7752) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7778) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7804) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7830) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7856) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7882) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (7908) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (7934) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (7960) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (7987) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (8014) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (8041) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (8068) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (8095) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (8122) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (8149) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (8174) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (8198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (8230) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (8262) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (8286) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (8310) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (8334) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8355) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8376) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8400) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8424) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8450) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8476) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8502) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8528) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8554) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8580) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8606) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8632) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8658) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8684) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8711) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8738) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8765) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8792) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8819) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8846) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8873) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (8900) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (8927) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (8954) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (8981) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (9008) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (9035) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (9062) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (9089) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (9116) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (9143) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (9170) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (9197) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (9224) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (9251) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (9278) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (9303) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9338) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9367) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9396) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9425) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9454) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9481) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9505) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9526) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9547) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9571) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9595) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9621) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9647) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9673) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9699) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9725) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9751) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9777) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9803) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9829) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9855) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9882) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (9909) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (9936) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (9963) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (9990) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (10017) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (10044) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (10058) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (10072) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (10086, 10094) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (10102, 10110) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (10118) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (10134) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (10155) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (10176) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (10197, 10205, 10218) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (10225, 10233) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (10250) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (10265) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (10280, 10301) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (10309, 10330) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10338) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10371, 10396) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10404, 10417) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10422, 10435) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10440, 10448, 10450) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10453) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10477) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10504) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10531) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10552) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10579) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10606) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10624) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10642) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10660, 10668) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10688, 10701) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10710) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10730) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10753) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10770) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10791) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10812) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10833) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10854) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10872) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (10891) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (10913) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (10930) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (10959) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (10988) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (11006) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (11026) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (11046) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (11066) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (11086) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (11106) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (11126) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (11146) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (11166) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (11186) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (11206) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (11227) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (11248) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (11269) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (11290) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (11311) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (11332) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11356) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11377, 11385) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11393) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11411) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11428) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11442) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11461) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11481) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11500) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11517, 11533) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11537, 11553) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11557, 11568) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11574) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11589) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11613) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11637) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11653) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11671) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11681) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11697) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11712) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11733) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11749) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11771) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11789) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11807) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11825) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11849) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11868) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (11893) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (11915, 11925) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (11939, 11945, 11950) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (11955) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (11974) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (11995) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (12016) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (12037) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (12058) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (12076) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (12094, 12105) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (12114) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (12138) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (12162) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (12182) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (12202) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (12222) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (12242) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (12262) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (12282) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (12302) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (12322) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12342) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12357) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12386) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12401) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12416) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12441) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12466) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12484) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12502) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12527) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12552) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12577) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12602) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12627) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12652) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12677) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12702) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12727) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12752) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12777) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12802) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12827) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12852) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12877) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (12902) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (12927) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (12952) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (12977) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (13002) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (13028) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (13054) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (13080) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (13106) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (13132) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (13158) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (13184) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (13210) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (13236) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (13262) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (13288) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (13314, 13328) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (13333) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13352, 13366) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13371) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13390, 13404) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13409) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13428, 13442) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13447) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13466) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13485) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13504) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13523) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13542) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13561) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13580) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13599) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13618) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13637) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13656) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13675) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13694, 13708) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13714) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13734) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13754) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13774) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13794) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13814) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13834) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13854) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13874) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (13894) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (13914) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (13934) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (13954) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (13976) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (14004) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (14033) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (14054) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (14064) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (14072) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (14094) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (14115) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (14132) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (14149) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (14166, 14173) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (14182) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (14211) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (14236) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (14249, 14261) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (14264) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (14278) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (14293) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (14308) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (14332) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14351) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14369) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14390) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14409) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14429) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14448) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14468) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14487) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14507) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14528) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14550) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14571) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14593) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14614) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14636) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14657) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14679) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14700) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14722) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14743) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14765) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14786) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14808) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14829) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14851) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14872) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (14894) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (14915) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (14937) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (14958) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (14980) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (15001) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (15023) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (15044) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (15066) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (15087) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (15109) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (15130) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (15152) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (15173) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (15195) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (15216) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (15238) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (15259) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (15281) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (15302) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (15324) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15345) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15367) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15388) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15410) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15431) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15453) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15474) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15496) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15517) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15539) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15560) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15582) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15603) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15625) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15646) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15668) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15690) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15713) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15735) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15758) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15780) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15803) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15825) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15848) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15870) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (15893) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (15915) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (15938) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (15960) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (15983) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (16005) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (16028) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (16050) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (16073) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (16095) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (16118) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (16140) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (16163) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (16185) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (16208) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (16230) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (16253) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (16275) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (16298) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (16320) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16343) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16365) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16388) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16410) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16433) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16455) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16478) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16492) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16506) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16520) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16534) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16548) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16562) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16576) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16590) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16604) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16618) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16632) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16646) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16660) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16674) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16688) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16702) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16716) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16730) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16744) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16758) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16772) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16786) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16800) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16814) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16837) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16857) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16877) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (16897) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (16917) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (16937) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (16957) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (16977) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (16997) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (17017) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (17037) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (17058) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (17079) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (17100) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (17121) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (17142) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (17163) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (17184) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (17205) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (17226) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (17247) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (17268) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (17289) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (17310) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (17331) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17352) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17373) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17394) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17415) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17436) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17457) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17478) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17499) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17517) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17534) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17552) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17573) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17591) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17606) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17623, 17638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17645) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17667) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17687) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17709) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17727) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17748) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17769) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17787) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17805) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17823) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17841) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17859) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17877) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (17895) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (17913) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (17931) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (17949) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (17967) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (17985) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (18003) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (18021) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (18039) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (18057) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (18071) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (18086) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (18104) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (18122) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (18139) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (18160) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (18176) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (18189) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (18208) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (18223) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (18245) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (18272) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (18289) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (18297) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (18314) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (18332) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18348) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18367) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18382) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18400) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18418) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18442) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18467) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18490) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18519) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18541) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18556) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18586) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18601) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18619) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18636) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18655) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18671) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18690) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18711) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18724) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18747) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18770, 18778, 18784) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18790, 18800) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18810, 18820, 18826) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18831) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18846) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18868) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (18890) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (18916) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (18942) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (18954) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (18973) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (18991) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (19009) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (19021, 19025) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (19035, 19039) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (19049, 19053) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (19063) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (19086) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (19109) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (19132) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (19153) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (19164) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (19177, 19185) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (19194) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (19213) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (19224, 19228) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (19243) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (19265, 19281) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (19287) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (19307, 19325) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (19334) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19356) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19381) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19406) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19425, 19439) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19448) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19471, 19475) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19485, 19489) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19500, 19512) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19517) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19544) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19571) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19590) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19616) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19641) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19669) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19695) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19720) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19748) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19774) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19799) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19827) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19853) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19878) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (19906) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (19937) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (19980, 20004, 20011) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (20018, 20025, 20034) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (20038) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (20057) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (20079, 20094) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (20100) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (20117) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (20138) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (20161) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (20184) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (20207) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (20220) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (20237) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (20261) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (20291) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (20315) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20345) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20376) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20405) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20435, 20451) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20455) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20474) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20500) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20524) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20550) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20576) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20592) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20608) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20623) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20646) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20669) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20692) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20715) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20749) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20783) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20817) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20851) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20885) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (20919) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (20953) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (20987) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (21021) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (21055) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (21089) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (21123) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (21157) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (21191) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (21225) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (21259) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (21283) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (21307) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (21328) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21348) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21368) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21406) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21426) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21454) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21475) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21490, 21500) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21506) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21522) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21537) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21552) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21569) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21591) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21607) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21629) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21645) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21667) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21689) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21711) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21730) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21745) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21761) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21777) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21792) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21807) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21824) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21846) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21862) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21884) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (21900) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (21922) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (21944) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (21966) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (21985) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (22000) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (22016) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (22032) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (22047) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (22062) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (22079) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (22101) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (22117) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (22139) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (22155) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (22177) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (22199) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (22221) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (22240) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (22255) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (22271) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (22287) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (22302) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (22317) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (22334) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22356) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22372) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22394) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22410) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22432) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22454) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22476) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22495) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22510) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22526) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22542) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22557) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22572) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22589) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22611) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22627) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22649) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22665) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22687) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22709) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22731) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22750) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22765) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22781) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22797) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22812) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22827) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22844) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22866) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22882) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (22904) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (22920) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (22942) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (22964) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (22986) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (23005) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (23020) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (23036) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (23052) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (23067) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (23082) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (23099) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (23121) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (23137) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (23159) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (23175) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (23197) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (23219) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (23241) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (23260) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (23275) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (23291) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (23307) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (23322) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23337) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23354) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23376) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23392) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23414) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23430) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23452) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23474) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23496) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23515) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23534) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23553) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23572) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23591) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23610) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23629) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23648) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23667) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23692) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23717) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23742) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23767) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23792) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23817) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23842) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23867) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (23892) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (23917) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (23942) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (23967) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (23992) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (24017) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (24042) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (24067) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (24090) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (24113) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (24136) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (24159) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (24182) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (24205) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (24228) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (24251) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (24269) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (24287) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (24305) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (24323) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24341) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24359) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24377) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24395) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24413) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24431) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24449) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24467) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24485) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24503) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24521) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24539) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24559) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24579) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24599) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24619) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24640) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24661, 24664) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24683, 24686) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24705) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24735) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24765) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24794) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24823) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24853) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24883) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (24912) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (24941) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (24971) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (25001) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (25030) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (25059) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (25089) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (25119) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (25148) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (25177, 25180) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (25199, 25202) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (25221) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (25244, 25258) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (25267) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (25290) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (25313) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25336) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25359) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25383) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25407) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25431) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25455) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25479) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25503) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25527) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25551) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25573) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25595) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25616) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25637) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25661) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25685) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25709) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25733) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25757) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25781) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25802) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25825) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25841) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25863) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25885) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (25901) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (25914) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (25927) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (25940) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (25953) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (25966) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (25979) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (25992) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (26005) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (26028) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (26047) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (26065) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (26092) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (26119) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (26132) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (26145) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (26168) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (26191) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (26219) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (26247) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (26275) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (26303) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (26321) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26339) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26354) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26378) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26402) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26421) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26440) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26464) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26488) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26512) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26536, 26539) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26554, 26557) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26572) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26590) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26608, 26611) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26626, 26629) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26644) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26662, 26669) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26681, 26688) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26700) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26724) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26744) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26764) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26783) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26801) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26818) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26839) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26853) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26867) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26881) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (26897, 26907) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (26916, 26926) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (26938, 26948) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (26957, 26967) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (26979, 26989) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (26997) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (27017) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (27040) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (27060) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (27083) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (27102) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (27114) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (27131) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (27148, 27155) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (27166) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (27186) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (27203) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (27219, 27222) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (27232, 27235) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (27246, 27249) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (27260, 27263) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (27282, 27285) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (27302, 27305) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (27324, 27327) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27344) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27361) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27378) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27392) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27414) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27436) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27459) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27482) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27504) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27526) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27547) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27567) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27587) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27604) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27621) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27637, 27643) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27656, 27662) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27675, 27681) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27692, 27698) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27710, 27716) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27728, 27734) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27744, 27750) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27762, 27768) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27780, 27786) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27796) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27811) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27826) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27839) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27854) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27869) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27882, 27885) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (27896, 27899) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (27910, 27913) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (27922) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (27945) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (27967, 27979) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (27987, 27990) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (28001, 28004) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (28015, 28018) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (28027) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (28043) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (28060) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (28077) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (28092) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (28111) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (28136) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (28160, 28168) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (28180) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (28206) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (28235) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (28260) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (28288) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (28311) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28337) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28359) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28384) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28403) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28425) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28439) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28456) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28476) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28493) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28510) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28527) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28547) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28564) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28584) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28603) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28624) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28645) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (28660) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (28679) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28698) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28717) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28732) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28765) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28798) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28831) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28864) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28880) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (28895) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (28921) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (28937) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (28955) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (28972) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (28993) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (29012) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (29031) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (29047) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (29066) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (29086) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (29109) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (29127) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (29148) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (29173) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (29189, 29204) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (29210) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (29218) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (29232) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (29246) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (29260) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (29275) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (29287) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (29309) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29325, 29331, 29344) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29350) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29375) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29401) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29427) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29453) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29479) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29507) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29531) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29555) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29588) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29616) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29645) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29670) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29695) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29729) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29758) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29782) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29802) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29822) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29851) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29875) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (29902) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (29929) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (29956) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (29983) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (30010) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (30037) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (30064) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (30091) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (30102, 30106) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (30116) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (30135) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (30157) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (30181) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (30204) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (30228) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (30251) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (30275) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (30298) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30322) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30345) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30364) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30382) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30394) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30406) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30424) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30443) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30461) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30473) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30485) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30503) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30521, 30531) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30540) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30554) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30572) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30586) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30600, 30609) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30617, 30626) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30634, 30643) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30647) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30659, 30668) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30673) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30689) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30703) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30719) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30734) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30751) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30766) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30783) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30805, 30815) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30822, 30830) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30843) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30855) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30870, 30877) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30885, 30892) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (30899) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (30916) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (30938) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (30962) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (30986) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (31012) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (31032) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (31052) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (31072) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (31092, 31093) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (31112, 31113) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (31132, 31133) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (31152, 31153) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (31172) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (31192) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (31212) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (31232) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (31252) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (31275) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (31298) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31321) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31342) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31363) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31384) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31405) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31429, 31438, 31442) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31453) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31477) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31501) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31525) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31549) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31573) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31597) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31616) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31635) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31654) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31673) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31692) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31711) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31730) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31749) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31768) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31787) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31806) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31825) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31844) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31863) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31882) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (31901) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (31920) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (31939) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (31958) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (31977) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (31997) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (32017) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (32037) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (32057) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (32079) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (32101) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (32123) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (32145) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (32167) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (32189) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (32211) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (32233) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (32255) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (32277) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (32299) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32321) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32343) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32365) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32387) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32409) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32431) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32453) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32475) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32497) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32519) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32541) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32563) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32585) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32605) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32625) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32645) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32665) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32685) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32705) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32725) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32745) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32765) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32785) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32805) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32825) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32844) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32863) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32882) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (32901) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (32920) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (32939) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (32958) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (32977) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (32996) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (33015) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (33034) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (33053) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (33072) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (33091) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (33110) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (33129) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (33148) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (33167) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (33186) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (33205) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (33225) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (33245) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (33265) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (33285) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (33305) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33325) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33345) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33365) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33385) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33405) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33425) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33445) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33464) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33483) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33502) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33521) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33540) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33559) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33578) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33597) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33618) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33639) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33659) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33679) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33699) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33719) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33739) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33759) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33779) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33799) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33818) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33837) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33856) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33875) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (33894) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (33913) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (33932) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (33951) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (33971) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (33991) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (34011) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (34031) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (34051) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (34071) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (34091) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (34111) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (34132) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (34153) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (34174) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (34195) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (34216) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (34237) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (34258) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (34279) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (34300) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34321) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34342) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34363) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34384) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34405) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34426) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34447) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34468) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34489) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34510) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34531) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34552) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34573) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34594) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34615) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34635) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34655) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34675) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34695) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34715) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34735) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34755) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34775) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34796) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34817) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34838) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34859) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34880) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (34901) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (34922) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (34943) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (34962) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (34981) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (35000) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (35019) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (35038) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (35057) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (35076) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (35095) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (35114) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (35133) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (35152) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (35171) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (35190) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (35209) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (35228) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (35247) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (35267) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (35287) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (35307) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35327) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35347) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35367) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35387) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35407) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35427) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35447) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35467) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35487, 35490) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35512, 35515) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35537, 35539) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35563, 35565) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35589) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35614) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35639) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35664) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35689) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35715) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35741) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35763) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35785) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35807) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35829) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35849) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35869) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (35889) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (35909) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (35931) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (35953) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (35975) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (35997) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (36019) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (36041) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (36063) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (36085) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (36107) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (36129) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (36151) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (36173) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (36195) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (36217) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (36239) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (36261) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (36282) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (36303) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36324) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36345) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36366) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36387) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36408) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36429) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36449) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36469) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36489) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36509) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36529) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36549) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36569) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36589) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36609) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36629) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36653) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36678) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36702, 36703) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36726, 36727) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36751) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36775) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36800) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36824) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36840, 36841) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36864) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (36898) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (36932, 36947) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (36957) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (36982) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (37007) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (37022) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (37045) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (37068) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (37086) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (37104) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (37124) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (37149) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (37174, 37183) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (37202) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (37230) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (37258) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (37286) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37314) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37342) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37365) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37389) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37412) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37436) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37459) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37483) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37506) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37530) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37553) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37576) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37599) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37622) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37645) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37668) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37692) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37716) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37742) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37769) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37795) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37822) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37848) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37875) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (37901) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (37928) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (37954) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (37981) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (38007) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (38033) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (38059) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (38085) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (38111) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (38137) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (38163) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (38187) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (38211) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (38235) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (38259) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (38284) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (38309) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38334) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38359) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38383) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38407) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38428) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38451) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38474) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38497) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38520) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38543) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38566) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38589) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38612) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38635) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38658) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38682) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38706) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38730) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38754) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38778) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38802) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38822) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38843) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38868) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (38894) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (38917) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (38940) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (38963) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (38986) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (39009) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (39033) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (39057) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (39081) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (39105) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (39129) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (39153) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (39178) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (39201) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (39225) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (39248) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (39271) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (39295) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39318) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39342) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39367) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39391) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39416) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39440) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39464) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39489) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39515) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39540) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39566) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39591) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39616) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39641) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39667) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39692) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39718) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39743) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39768) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39793) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39819) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39844) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39869) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (39894) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (39918) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (39943) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (39967) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (39991) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (40015) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (40040) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (40066) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (40091) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (40116) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (40141) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (40163) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (40186) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (40210) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (40233) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (40256) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (40279) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (40302) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40326) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40349) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40373) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40396) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40419) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40440) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40469, 40485) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40498) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40524, 40532) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40553) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40572, 40588) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40598) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40621) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40644) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40671) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40698, 40706) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40723, 40731) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40751, 40759) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40779, 40787) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40802, 40810) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40825) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40858) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (40891) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (40923) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (40955) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (40974) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (41001) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (41028) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (41055) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (41082) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (41103) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (41122) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (41141) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (41165) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (41197) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (41227) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (41263) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (41296) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41314) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41334) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41351) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41375) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41399) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41425) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41454) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41483) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41512) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41541) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41562) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41589) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41613) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41638) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41662) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41686) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41711) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41735) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41757, 41760) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41784, 41787) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41811, 41814) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41843, 41845) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41871, 41873) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (41899, 41901) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (41927, 41929) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (41955, 41957) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (41983, 41985) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (42011, 42013) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (42039, 42041) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (42067, 42069) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (42100) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (42129) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (42158) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (42188) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (42218) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (42245) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (42272) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (42302) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42333) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42361) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42385) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42410) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42434) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42460) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42486) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42512) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42539) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42565) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42591) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42617) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42643) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42669) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42695) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42721) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42748) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42775) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42802) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42827) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42853) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42878) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (42903) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (42928) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (42952) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (42977) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (43001) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (43025) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (43049) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (43073) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (43098) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (43120) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (43132) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (43143) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (43154) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (43167) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (43180) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (43193) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (43206) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (43221) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (43236) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (43248) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (43257) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (43272, 43290) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (43295, 43310) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43317, 43324) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43344) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43368) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43389) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43411) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43433) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43459) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43474) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43493) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43515) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43537) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43559) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43581) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43608) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43635) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43662) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43689, 43692) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43701) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43721) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43741) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43761) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43781) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43801) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43821) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43841) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43861) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43886) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (43911) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (43936) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (43961) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (43986) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (44011) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (44036) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (44061) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (44084) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (44107) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (44130) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (44153) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (44176) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (44199) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (44222) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (44245) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (44265) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44285) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44308) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44331) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44350) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44369) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44398) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44427) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44449) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44471) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44493) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44515) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44544) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44573) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44595) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44617) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44639) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44661) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44690) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44719) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44741) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44763) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44785) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44807) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44836) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44865) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44887) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (44909) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (44931) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (44953) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (44977) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (45002) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (45026) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (45051) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (45075) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (45100) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (45124) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (45149) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (45178) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (45208) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (45237) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (45267) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45296) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45326) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45355) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45385) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45412) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45440) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45467) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45495) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45522) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45550) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45577) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45605) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45627) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45649) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45676) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45701) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45726) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45751) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45784) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45811) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45837) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45877) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (45911) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (45941) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (45972) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (46003) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (46037) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (46074) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (46115) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (46140) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (46165) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (46190) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (46215) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (46245) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (46266) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46287) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46313) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46344) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46375) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46411) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46435) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46461) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46488) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46514) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46541) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46572) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46603) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46639) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46663) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46689) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46716) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46742) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46769) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46800) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46831) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46867) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (46891) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (46917) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (46944) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (46970) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (46997) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (47028) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (47059) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (47095) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (47119) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (47145) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (47172) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (47198) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '4', '\0', /* GRBM_STATUS_SE4 (47225) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '5', '\0', /* GRBM_STATUS_SE5 (47241) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_DEBUG_CNTL (47257) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_DEBUG_DATA (47275, 47282) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'D', 'I', 'M', '\0', /* SPI_SHADER_GS_MESHLET_DIM (47293, 47315) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'E', 'X', 'P', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SPI_SHADER_GS_MESHLET_EXP_ALLOC (47319) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '4', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE4 (47351) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '5', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE5 (47382) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '6', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE6 (47413) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '7', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE7 (47444) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '\0', /* COMPUTE_DISPATCH_INTERLEAVE (47475, 47492) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_OVERRIDE_CNTL (47503) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE (47527) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE_EXT (47556) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_FEEDBACK_SIZE_XY (47589) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_RATE_CACHE_CNTL (47621) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_BASE (47647) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_BASE_EXT (47667) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_SIZE_XY (47691) */
	'C', 'B', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_FDCC_CONTROL (47714) */
	'P', 'A', '_', 'R', 'A', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_RATE_CNTL (47730) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SPI_GFX_SCRATCH_BASE_LO (47743) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SPI_GFX_SCRATCH_BASE_HI (47767) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* PA_SC_BINNER_CNTL_2 (47791) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_FDCC_CONTROL (47811) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_FDCC_CONTROL (47834) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_FDCC_CONTROL (47857) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_FDCC_CONTROL (47880) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_FDCC_CONTROL (47903) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_FDCC_CONTROL (47926) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_FDCC_CONTROL (47949) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_FDCC_CONTROL (47972) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_ASINVOC_COUNT_LO (47995) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_ASINVOC_COUNT_HI (48019) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_MSPRIM_COUNT_LO (48043) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_MSPRIM_COUNT_HI (48065) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_GE_MSINVOC_COUNT_LO (48087) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_GE_MSINVOC_COUNT_HI (48110) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM (48133) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '_', '1', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM_1 (48158) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_0 (48185) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_1 (48214) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_2 (48243) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_3 (48272) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '0', '\0', /* GDS_GS_0 (48301) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '1', '\0', /* GDS_GS_1 (48310) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '2', '\0', /* GDS_GS_2 (48319) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '3', '\0', /* GDS_GS_3 (48328) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_LO (48337) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_HI (48367) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_LO (48397) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_HI (48428) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_LO (48459) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_HI (48489) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_LO (48519) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_HI (48550) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_LO (48581) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_HI (48611) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_LO (48641) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_HI (48672) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_LO (48703) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_HI (48733) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_LO (48763) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_HI (48794) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (48825) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (48843) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (48861) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '1', '\0', /* SPI_GS_THROTTLE_CNTL1 (48881) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '2', '\0', /* SPI_GS_THROTTLE_CNTL2 (48903) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* SPI_ATTRIBUTE_RING_BASE (48925) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_ATTRIBUTE_RING_SIZE (48949) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE4_PERFCOUNTER_LO (48973) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE4_PERFCOUNTER_HI (48997) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE5_PERFCOUNTER_LO (49021) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE5_PERFCOUNTER_HI (49045) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE6_PERFCOUNTER_LO (49069) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE6_PERFCOUNTER_HI (49093) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER2_HI (49117) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER2_LO (49136) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER3_HI (49155) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER3_LO (49174) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER0_LO (49193) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER0_HI (49213) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER1_LO (49233) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER1_HI (49253) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER2_LO (49273) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER2_HI (49293) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER3_LO (49313) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER3_HI (49333) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER4_LO (49353) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER4_HI (49373) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER5_LO (49393) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER5_HI (49413) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER6_LO (49433) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER6_HI (49453) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER7_LO (49473) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER7_HI (49493) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* TCP_PERFCOUNTER_FILTER (49513) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '2', '\0', /* TCP_PERFCOUNTER_FILTER2 (49536) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', '\0', /* TCP_PERFCOUNTER_FILTER_EN (49560) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER2_LO (49586) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER2_HI (49608) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER3_LO (49630) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER3_HI (49652) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER0_LO (49674) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER0_HI (49695) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER1_LO (49716) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER1_HI (49737) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER2_LO (49758) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER2_HI (49779) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER3_LO (49800) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER3_HI (49821) */
	'C', 'P', 'C', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_TC_PERF_COUNTER_WINDOW_SELECT (49842) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE4_PERFCOUNTER_SELECT (49876) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE5_PERFCOUNTER_SELECT (49904) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE6_PERFCOUNTER_SELECT (49932) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER2_SELECT (49960) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER3_SELECT (49983) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER1_SELECT1 (50006) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER2_SELECT1 (50030) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER3_SELECT1 (50054) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER0_SELECT (50078) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER1_SELECT (50102) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER2_SELECT (50126) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER3_SELECT (50150) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER4_SELECT (50174) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER5_SELECT (50198) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER6_SELECT (50222) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER7_SELECT (50246) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQG_PERFCOUNTER_CTRL (50270) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQG_PERFCOUNTER_CTRL2 (50291) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* SQG_PERF_SAMPLE_FINISH (50313) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', 'U', 'S', 'E', '\0', /* RLC_SPM_PAUSE (50336, 50344) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_STATUS (50350) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_MODE (50365, 50369) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_RSPM_REQ_DATA_LO (50378) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_RSPM_REQ_DATA_HI (50403) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_REQ_OP (50428) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_RSPM_RET_DATA (50448) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_RET_OP (50470) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_LO (50490) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_HI (50518) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_REQ_OP (50546) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_RSPM_RET_DATA (50569) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_RET_OP (50594) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '\0', /* RLC_SPM_RSPM_CMD (50617, 50630) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '_', 'A', 'C', 'K', '\0', /* RLC_SPM_RSPM_CMD_ACK (50634) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'A', 'R', 'E', '\0', /* RLC_SPM_SPARE (50655) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER2_SELECT (50669) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER3_SELECT (50695) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER0_SELECT (50721) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1H_PERFCOUNTER0_SELECT1 (50746) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER1_SELECT (50772) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER2_SELECT (50797) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER3_SELECT (50822) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '2', '\0', /* ACQUIRE_MEM_PWS_2 (50847) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '7', '\0', /* ACQUIRE_MEM_PWS_7 (50865) */
	'D', 'B', '_', 'S', 'P', 'I', '_', 'V', 'R', 'S', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* DB_SPI_VRS_CENTER_LOCATION (50883) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'S', 'S', 'A', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_SSAA_CNTL (50910) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_BINNER_OUTPUT_TIMEOUT_CNTL (50930) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCL2TLB_PERFCOUNTER_LO (50963) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCL2TLB_PERFCOUNTER_HI (50986) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER0_CFG (51009) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER1_CFG (51034) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER2_CFG (51059) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCL2TLB_PERFCOUNTER3_CFG (51084) */
	'G', 'C', 'L', '2', 'T', 'L', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCL2TLB_PERFCOUNTER_RSLT_CNTL (51109) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (51139) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (51153) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (51170) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (51186) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (51201) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (51216) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (51231) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (51246) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (51259) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (51271) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (51284) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (51294) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (51309) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (51323) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (51339) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (51355) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (51371) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (51391, 51396) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (51413) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (51424) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (51444, 51449) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (51460) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (51474) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (51486) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (51499) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (51517) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (51535) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (51553) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (51571) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (51589) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (51607) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (51625) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (51643) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (51666) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (51683) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (51700) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (51717) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (51730) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (51738) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (51756) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (51775) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (51794) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (51812, 51818) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (51833) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (51845) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (51857) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (51868) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (51881) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (51898) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (51910) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (51922) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (51934) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (51951) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (51972) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (51991) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (52010) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (52028) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (52048) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (52066) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (52079) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (52092) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (52106) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (52119, 52122) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (52132) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (52144) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (52159) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (52175) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (52191) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (52203) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (52215) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (52229) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (52243) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (52261) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (52280) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (52299) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (52317) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (52340) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (52363) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (52386) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (52409) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (52428) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (52447) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (52466) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (52485) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (52504) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (52523) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (52542) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (52561) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (52584, 52588) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (52608, 52612) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (52631, 52635) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (52656) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (52676, 52680) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (52699) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (52715) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (52735) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (52751) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (52766) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (52781) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (52796) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (52810) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (52824) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (52840) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (52866) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (52890) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (52914) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (52938) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (52962) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (52982) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (53002) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (53022) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (53042) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (53062) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (53082) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (53102) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (53122) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (53140) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (53157) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (53174) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (53189) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (53215) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (53243) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (53260) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (53277) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (53295) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (53309) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (53326) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (53344) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (53366) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (53391) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (53408) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (53424) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (53443) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (53460) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (53477) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (53491) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (53501) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (53512) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (53531) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (53546) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (53560) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (53580) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (53602) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (53622) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (53638) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (53654) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (53671) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (53689) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (53702) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (53714) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (53725) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (53736) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (53757) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (53778) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (53804) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (53825) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (53846, 53862) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (53870) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (53888) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (53907) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (53922) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (53944) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (53966) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (53988) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (54010) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (54025) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (54036) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (54047) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (54059) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (54080) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (54101) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (54122) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (54143) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (54164) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (54185) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (54206) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (54227) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (54248) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (54269) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (54290) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (54311) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (54332) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (54353) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (54374) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (54395) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (54416) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (54437) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (54458) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (54479) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (54500) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (54521) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (54542) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (54563, 54571, 54575) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (54583) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (54598) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (54613) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (54628) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (54643) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (54674) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (54705) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (54722) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (54739) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (54753) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (54767) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (54782, 54785) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (54792) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (54807) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (54829) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (54857) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (54888) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER0_LO (54919) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER0_HI (54938) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER1_LO (54957) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER1_HI (54976) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (54995) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (55014) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (55033) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (55052) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (55071) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (55091) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (55111) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (55131) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (55151) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (55171) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (55191) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (55211) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (55231) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (55251) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (55271) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (55291) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (55311) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (55331) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (55351) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (55371) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (55391) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (55411) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (55431) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (55451) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (55471) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (55491) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (55511) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (55531) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER0_SELECT (55551) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER1_SELECT (55574) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (55597) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (55620) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (55643) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (55667) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (55692) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (55717) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (55737) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (55761) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (55786) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (55810) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (55835) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (55859) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (55883) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (55907) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (55932) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (55956) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (55981) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (56005) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (56029) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (56053) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (56078) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (56102) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (56126) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (56150, 56162) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (56183) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (56216) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (56249) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (56281) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (56313) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (56345) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (56378) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (56410) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (56442) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (56475) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (56508) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (56541) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (56573) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (56605) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (56638) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (56671) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (56704) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (56737) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (56769) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (56803) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (56837) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (56871) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (56905) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (56934) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (56950) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (56977) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (57004) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (57031) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (57058) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (57085) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (57112) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (57139) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (57166) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (57193) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (57220) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (57247) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (57274) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (57301) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (57328) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (57355) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (57382) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (57409) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (57436) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (57463) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (57490) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (57517) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (57544) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (57571) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (57598) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (57625) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (57652) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (57679) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (57706) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (57733) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (57760) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (57787) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (57814) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (57844) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (57874) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (57904) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (57934) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (57964) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (57994) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (58024) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (58054) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (58084) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (58114) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (58145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (58176) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (58207) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (58238) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (58269) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (58300) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (58331) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (58362) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (58393) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (58424) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (58455) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (58486) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (58517) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (58548) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (58579) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (58610) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (58641) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (58672) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (58703) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (58734) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (58765) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (58796) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (58807) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (58824, 58832) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (58839) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (58854) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (58869) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (58884) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (58899) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (58914) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (58929) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (58944, 58951) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (58974) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (58992) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (59019) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (59046) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (59079, 59106) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPF_DEBUG_CNTL (59112) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'G', '_', 'C', 'H', 'U', 'N', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TG_CHUNK_SIZE (59130, 59138) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (59152) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (59161) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (59171) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (59182) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (59187) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (59199, 59201) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (59207) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (59222) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (59237) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (59246) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (59256, 59258) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (59264) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (59283) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (59297) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (59314) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (59322) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (59332) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (59345) */
	'C', 'S', 'P', '\0', /* CSP (59351) */
	'S', 'C', 'C', '\0', /* SCC (59355) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (59359) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (59368) */
	'P', 'R', 'I', 'V', '\0', /* PRIV (59378) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (59383) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (59391) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (59401) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (59412) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (59418) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (59423) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (59429) */
	'H', 'A', 'L', 'T', '\0', /* HALT (59440) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (59445) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (59450, 59457) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (59465) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (59473) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (59485) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (59493) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (59504) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (59516) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (59521) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (59529) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (59542) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (59550) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (59561) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (59572) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (59588, 59593) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (59602) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (59614) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (59622) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (59630) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (59638) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (59644) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (59650) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (59662) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (59668) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (59674) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (59683) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (59692) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (59698) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (59708) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (59718) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (59728) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (59738) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (59747) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (59756) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (59773) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (59780) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (59788) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (59802) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (59811) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (59820) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (59833) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (59838) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (59848) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (59862) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (59874) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (59881) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (59887) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (59901) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (59916) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (59921) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (59926) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (59936) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (59945) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (59952) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (59958) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (59964) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (59977, 59979) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (59985) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (60000) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (60009) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (60023) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (60041) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (60051) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (60064) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (60071) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (60081) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (60104) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (60127) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (60150) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (60170) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (60190) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (60210) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (60230) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (60250) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (60270) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (60290) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (60310) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (60325, 60331) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (60336) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (60344) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (60353) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (60370) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (60385) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (60398, 60399) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (60408) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (60425) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (60442) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (60451, 60452) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (60460) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (60469, 60470) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (60478) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (60487) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (60498) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (60521, 60522) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (60537) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (60560) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (60583) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (60602) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (60611) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (60620) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (60628) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (60637) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (60652) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (60660) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (60668) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (60677) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (60686) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (60694) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (60702) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (60710) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (60728) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (60736) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (60747) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (60758) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (60769) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (60798) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (60829) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (60858) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (60878) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (60898) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (60918) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (60938) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (60946) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (60954) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (60965) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (60979) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (60988) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (60997) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (61007) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (61017) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (61026) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (61035) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (61046) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (61057) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (61067) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (61077) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (61087) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (61104) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (61112) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (61125) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (61143) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (61154) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (61163) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (61184) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (61195) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (61222) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (61235) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (61248) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (61263) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (61283) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (61299) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (61317) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (61337) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (61356) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (61375, 61380) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (61388) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (61402) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (61426) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (61442) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (61458) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (61474) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (61490) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (61505) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (61525) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (61541) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (61559) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (61579) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (61598) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (61617) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (61630) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (61644) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (61668) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (61684) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (61700) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (61716) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (61732) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (61751) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (61771) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (61790) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (61811) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (61829) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (61852) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (61874) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (61895) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (61913) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (61936) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (61958) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (61982) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (62006) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (62029) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (62051) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (62070) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (62079) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (62094) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (62108) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (62127) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (62146) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (62161) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (62178) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (62200) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (62222) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (62237) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (62252) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (62261) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (62270) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (62280) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (62294) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (62308) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (62322) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (62339) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (62352) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (62365) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (62378) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (62397) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (62410) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (62428) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (62442) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (62461) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (62480) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (62495) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (62513) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (62531) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (62548) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (62563) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (62577) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (62594) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (62618) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (62636) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (62654) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (62675) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (62699) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (62725) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (62742) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (62762) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (62782) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (62802) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (62823) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (62846) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (62867) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (62886) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (62903) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (62919) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (62935) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (62951) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (62970) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (62982) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (62994) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (63013) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (63033) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (63053) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (63073) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (63094) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (63115) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (63142) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (63169) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (63190) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (63209) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (63228) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (63242) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (63257) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (63274) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (63286) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (63299) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (63314) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (63329) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (63344) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (63359) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (63384) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (63406) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (63431) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (63452) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (63476) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (63503) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (63528) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (63551) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (63571) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (63587) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (63597) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (63606) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (63614) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (63621) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (63635) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (63658) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (63680) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (63703) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (63725) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (63746, 63760) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (63770) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (63788) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (63808) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (63827) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (63849) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (63873) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (63892) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (63906) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (63924) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (63942) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (63962) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (63979) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (63999) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (64018) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (64036) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (64054) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (64066) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (64079) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (64094) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (64103) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E', 'N', '\0', /* INTERRUPT_EN (64114) */
	'D', 'O', 'U', 'B', 'L', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* DOUBLE_BUFFER (64127) */
	'R', 'E', 'G', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* REG_STALL_EN (64141) */
	'S', 'P', 'I', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SPI_STALL_EN (64154) */
	'S', 'Q', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SQ_STALL_EN (64167) */
	'R', 'E', 'G', '_', 'D', 'R', 'O', 'P', '_', 'O', 'N', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* REG_DROP_ON_STALL (64179) */
	'U', 'T', 'I', 'L', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* UTIL_TIMER (64197) */
	'W', 'A', 'V', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* WAVESTART_MODE (64208) */
	'R', 'T', '_', 'F', 'R', 'E', 'Q', '\0', /* RT_FREQ (64223) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'M', 'A', 'R', 'K', 'E', 'R', 'S', '\0', /* SYNC_COUNT_MARKERS (64231) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'D', 'R', 'A', 'W', 'S', '\0', /* SYNC_COUNT_DRAWS (64250) */
	'C', 'A', 'P', 'T', 'U', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* CAPTURE_ALL (64267) */
	'D', 'R', 'A', 'W', '_', 'E', 'V', 'E', 'N', 'T', '_', 'E', 'N', '\0', /* DRAW_EVENT_EN (64279) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* FINISH_PENDING (64293) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '\0', /* FINISH_DONE (64308, 64315) */
	'U', 'T', 'C', '_', 'E', 'R', 'R', '\0', /* UTC_ERR (64320) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* EVENT_CNTR_OVERFLOW (64328) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* EVENT_CNTR_STALL (64348) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', '\0', /* SQ_EXP_MRT (64365) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', 'Z', '\0', /* SQ_EXP_MRTZ (64376) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'N', 'U', 'L', 'L', '\0', /* SQ_EXP_NULL (64388) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'O', 'S', '\0', /* SQ_EXP_POS (64400) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'R', 'I', 'M', '\0', /* SQ_EXP_PRIM (64411) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* SQ_EXP_PARAM (64423) */
	'T', 'G', 'T', '\0', /* TGT (64436) */
	'C', 'O', 'M', 'P', 'R', '\0', /* COMPR (64440) */
	'V', 'M', '\0', /* VM (64446) */
	'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'H', 'I', '\0', /* BASE_ADDRESS_HI (64449, 64454) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* CACHE_SWIZZLE (64465) */
	'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SWIZZLE_ENABLE (64479) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'X', '\0', /* DST_SEL_X (64494) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Y', '\0', /* DST_SEL_Y (64504) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Z', '\0', /* DST_SEL_Z (64514) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'W', '\0', /* DST_SEL_W (64524) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* GFX10_FORMAT_INVALID (64534) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_UNORM (64555) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_SNORM (64576) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_USCALED (64597) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_SSCALED (64620) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_UINT (64643) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_SINT (64663) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_UNORM (64683) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_SNORM (64705) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_USCALED (64727) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_SSCALED (64751) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_UINT (64775) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_SINT (64796) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_FLOAT (64817) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_UNORM (64839) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_SNORM (64862) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_USCALED (64885) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_SSCALED (64910) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_UINT (64935) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_SINT (64957) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_UINT (64979) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_SINT (65000) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_FLOAT (65021) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_UNORM (65043) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_SNORM (65068) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_USCALED (65093) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_SSCALED (65120) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_UINT (65147) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_SINT (65171) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_FLOAT (65195) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_UNORM (65220) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_SNORM (65248) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_USCALED (65276) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_SSCALED (65306) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_UINT (65336) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_SINT (65363) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_10_11_11_FLOAT (65390) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_UNORM (65418) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_SNORM (65446) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_USCALED (65474) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_SSCALED (65504) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_UINT (65534) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_SINT (65561) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_11_11_10_FLOAT (65588) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_UNORM (65616) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_SNORM (65646) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_USCALED (65676) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_SSCALED (65708) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_UINT (65740) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_SINT (65769) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_UNORM (65798) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_SNORM (65828) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_USCALED (65858) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_SSCALED (65890) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_UINT (65922) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_SINT (65951) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_UNORM (65980) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_SNORM (66007) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_USCALED (66034) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_SSCALED (66063) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_UINT (66092) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_SINT (66118) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_UINT (66144) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_SINT (66168) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_FLOAT (66192) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_UNORM (66217) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_SNORM (66248) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_USCALED (66279) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_SSCALED (66312) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_UINT (66345) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_SINT (66375) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_FLOAT (66405) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_UINT (66436) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_SINT (66463) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_FLOAT (66490) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_UINT (66518) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_SINT (66548) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_FLOAT (66578) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_SRGB (66609) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_SRGB (66629) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_8_8_SRGB (66651) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '6', 'E', '4', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_6E4_FLOAT (66677) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '9', '_', '9', '_', '9', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_5_9_9_9_FLOAT (66700) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '6', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_6_5_UNORM (66727) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_5_5_5_UNORM (66752) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '5', '_', '5', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_5_5_1_UNORM (66779) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_4_4_UNORM (66806) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_UNORM (66833) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_UNORM (66856) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', 'D', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_REVERSED_UNORM (66877) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* GFX10_FORMAT_32_FLOAT_CLAMP (66907) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_24_UNORM (66935) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_24_UINT (66959) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_24_8_UNORM (66982) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_24_8_UINT (67006) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_X24_8_32_UINT (67029) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_X24_8_32_FLOAT (67056) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_UNORM (67084) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_SNORM (67109) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_GB_GR_UINT (67134) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_GB_GR_SRGB (67158) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_UNORM (67182) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_SNORM (67207) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_BG_RG_UINT (67232) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BG_RG_SRGB (67256) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S2_F1 (67280) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S4_F1 (67306) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '8', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S8_F1 (67332) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S2_F2 (67358) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S4_F2 (67384) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK8_S4_F4 (67410) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '1', '6', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK16_S16_F1 (67436) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '8', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK16_S8_F2 (67464) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '1', '6', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK32_S16_F2 (67491) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK32_S8_F4 (67519) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK32_S8_F8 (67546) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK64_S16_F4 (67573) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK64_S16_F8 (67601) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC1_UNORM (67629) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC1_SRGB (67652) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC2_UNORM (67674) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC2_SRGB (67697) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC3_UNORM (67719) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC3_SRGB (67742) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_UNORM (67764) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_SNORM (67787) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_UNORM (67810) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_SNORM (67833) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'U', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_UFLOAT (67856) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'S', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_SFLOAT (67880) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC7_UNORM (67904) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC7_SRGB (67927) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_UNORM (67949) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_UINT (67973) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_UNORM (67996) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_UINT (68022) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UNORM (68047) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UINT (68077) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_VYUY8_UNORM (68106) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_VYUY8_UINT (68134) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_11_11_UNORM (68161) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_11_11_UINT (68192) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UNORM (68222) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UINT (68255) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UNORM (68287) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UINT (68321) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_UNORM (68354) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_UINT (68385) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UNORM (68415) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UINT (68449) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', ' ', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM  (68482) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT (68523) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '7', 'E', '3', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_7E3_FLOAT (68562) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_UNORM (68585) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_SNORM (68610) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_USCALED (68635) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_SSCALED (68662) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_UINT (68689) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_SINT (68713) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_YCBCR_SRGB (68737) */
	'I', 'N', 'D', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* INDEX_STRIDE (68761) */
	'A', 'D', 'D', '_', 'T', 'I', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ADD_TID_ENABLE (68774) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* RESOURCE_LEVEL (68789) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '_', 'W', 'I', 'T', 'H', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* OOB_SELECT_STRUCTURED_WITH_OFFSET (68804) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '\0', /* OOB_SELECT_STRUCTURED (68838) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OOB_SELECT_DISABLED (68860) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'R', 'A', 'W', '\0', /* OOB_SELECT_RAW (68880, 68891) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OOB_SELECT (68895) */
	'C', 'L', 'A', 'M', 'P', '_', 'X', '\0', /* CLAMP_X (68906) */
	'C', 'L', 'A', 'M', 'P', '_', 'Y', '\0', /* CLAMP_Y (68914) */
	'C', 'L', 'A', 'M', 'P', '_', 'Z', '\0', /* CLAMP_Z (68922) */
	'M', 'A', 'X', '_', 'A', 'N', 'I', 'S', 'O', '_', 'R', 'A', 'T', 'I', 'O', '\0', /* MAX_ANISO_RATIO (68930) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'F', 'U', 'N', 'C', '\0', /* DEPTH_COMPARE_FUNC (68946) */
	'F', 'O', 'R', 'C', 'E', '_', 'U', 'N', 'N', 'O', 'R', 'M', 'A', 'L', 'I', 'Z', 'E', 'D', '\0', /* FORCE_UNNORMALIZED (68965) */
	'A', 'N', 'I', 'S', 'O', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ANISO_THRESHOLD (68984) */
	'M', 'C', '_', 'C', 'O', 'O', 'R', 'D', '_', 'T', 'R', 'U', 'N', 'C', '\0', /* MC_COORD_TRUNC (69000) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* FORCE_DEGAMMA (69015) */
	'A', 'N', 'I', 'S', 'O', '_', 'B', 'I', 'A', 'S', '\0', /* ANISO_BIAS (69029) */
	'T', 'R', 'U', 'N', 'C', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* TRUNC_COORD (69040) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'U', 'B', 'E', '_', 'W', 'R', 'A', 'P', '\0', /* DISABLE_CUBE_WRAP (69052, 69065) */
	'F', 'I', 'L', 'T', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* FILTER_MODE (69070) */
	'S', 'K', 'I', 'P', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* SKIP_DEGAMMA (69082) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '\0', /* MIN_LOD (69095) */
	'M', 'A', 'X', '_', 'L', 'O', 'D', '\0', /* MAX_LOD (69103) */
	'P', 'E', 'R', 'F', '_', 'M', 'I', 'P', '\0', /* PERF_MIP (69111) */
	'P', 'E', 'R', 'F', '_', 'Z', '\0', /* PERF_Z (69120) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '\0', /* LOD_BIAS (69127) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '_', 'S', 'E', 'C', '\0', /* LOD_BIAS_SEC (69136) */
	'X', 'Y', '_', 'M', 'A', 'G', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MAG_FILTER (69149) */
	'X', 'Y', '_', 'M', 'I', 'N', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MIN_FILTER (69163) */
	'Z', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* Z_FILTER (69177) */
	'M', 'I', 'P', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* MIP_FILTER (69186) */
	'M', 'I', 'P', '_', 'P', 'O', 'I', 'N', 'T', '_', 'P', 'R', 'E', 'C', 'L', 'A', 'M', 'P', '\0', /* MIP_POINT_PRECLAMP (69197) */
	'A', 'N', 'I', 'S', 'O', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* ANISO_OVERRIDE (69216) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '_', 'P', 'R', 'T', '\0', /* BLEND_ZERO_PRT (69231) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'P', 'T', 'R', '\0', /* BORDER_COLOR_PTR (69246) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* BORDER_COLOR_TYPE (69263) */
	'G', 'P', 'R', '_', 'W', 'R', 'I', 'T', 'E', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '\0', /* GPR_WRITE_PRIORITY (69281, 69291) */
	'E', 'X', 'P', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* EXP_PRIORITY_ORDER (69300) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'T', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_TOP_EVENTS (69319) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'B', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_BOP_EVENTS (69341) */
	'R', 'S', 'R', 'C', '_', 'M', 'G', 'M', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* RSRC_MGMT_RESET (69363) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'L', 'L', '_', 'A', 'L', 'L', '\0', /* TTRACE_STALL_ALL (69379) */
	'A', 'L', 'L', 'O', 'C', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* ALLOC_ARB_LRU_ENA (69396) */
	'E', 'X', 'P', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* EXP_ARB_LRU_ENA (69414) */
	'P', 'S', '_', 'P', 'K', 'R', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'N', 'T', 'L', '\0', /* PS_PKR_PRIORITY_CNTL (69430) */
	'N', 'U', 'M', '_', 'P', 'I', 'P', 'E', 'S', '\0', /* NUM_PIPES (69451) */
	'P', 'I', 'P', 'E', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* PIPE_INTERLEAVE_SIZE (69461) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'F', 'R', 'A', 'G', 'S', '\0', /* MAX_COMPRESSED_FRAGS (69482) */
	'N', 'U', 'M', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', 'S', '\0', /* NUM_SHADER_ENGINES (69503) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'E', '\0', /* NUM_RB_PER_SE (69522) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'G', 'E', 'N', 'E', 'R', 'A', 'L', '\0', /* ARRAY_LINEAR_GENERAL (69536, 69542) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* ARRAY_LINEAR_ALIGNED (69557) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_1D_TILED_THIN1 (69578) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_1D_TILED_THICK (69599) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_2D_TILED_THIN1 (69620) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_TILED_THIN1 (69641) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_2D_TILED_THIN1 (69663) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_THICK (69688) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_XTHICK (69709) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_TILED_THICK (69731) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_2D_TILED_THICK (69753) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_3D_TILED_THIN1 (69778) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_3D_TILED_THIN1 (69803) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_THICK (69824) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_XTHICK (69845) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_3D_TILED_THICK (69867) */
	'A', 'R', 'R', 'A', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* ARRAY_MODE (69892) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '\0', /* ADDR_SURF_P2 (69903) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P2_RESERVED0 (69916) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '1', '\0', /* ADDR_SURF_P2_RESERVED1 (69939, 69952) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '2', '\0', /* ADDR_SURF_P2_RESERVED2 (69962, 69975) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P4_8x16 (69985) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P4_16x16 (70003) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P4_16x32 (70022) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P4_32x32 (70041) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '1', '6', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x16_8x16 (70060) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_8x16 (70084) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_8x16 (70108) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_16x16 (70132) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_16x16 (70157) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x32_16x32 (70182) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '6', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x64_32x32 (70207) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P8_RESERVED0 (70232) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_8x16 (70255) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_16x16 (70280) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '\0', /* ADDR_SURF_P16 (70306) */
	'P', 'I', 'P', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PIPE_CONFIG (70320) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '6', '4', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_64B (70332) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', '2', '8', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_128B (70357) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', '5', '6', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_256B (70383) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '5', '1', '2', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_512B (70409) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_1KB (70435) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_2KB (70460) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '4', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_4KB (70485) */
	'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TILE_SPLIT (70510) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'I', 'S', 'P', 'L', 'A', 'Y', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DISPLAY_MICRO_TILING (70521) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'N', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THIN_MICRO_TILING (70552) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'E', 'P', 'T', 'H', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DEPTH_MICRO_TILING (70580) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'R', 'O', 'T', 'A', 'T', 'E', 'D', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_ROTATED_MICRO_TILING (70609) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'C', 'K', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THICK_MICRO_TILING (70640) */
	'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'N', 'E', 'W', '\0', /* MICRO_TILE_MODE_NEW (70669) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* SAMPLE_SPLIT (70689) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '1', '\0', /* ADDR_SURF_BANK_WIDTH_1 (70702) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '2', '\0', /* ADDR_SURF_BANK_WIDTH_2 (70725) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '4', '\0', /* ADDR_SURF_BANK_WIDTH_4 (70748) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '8', '\0', /* ADDR_SURF_BANK_WIDTH_8 (70771) */
	'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* BANK_WIDTH (70794, 70799) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '1', '\0', /* ADDR_SURF_BANK_HEIGHT_1 (70805) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '2', '\0', /* ADDR_SURF_BANK_HEIGHT_2 (70829) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '4', '\0', /* ADDR_SURF_BANK_HEIGHT_4 (70853) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '8', '\0', /* ADDR_SURF_BANK_HEIGHT_8 (70877) */
	'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* BANK_HEIGHT (70901, 70906) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '1', '\0', /* ADDR_SURF_MACRO_ASPECT_1 (70913) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '2', '\0', /* ADDR_SURF_MACRO_ASPECT_2 (70938) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '4', '\0', /* ADDR_SURF_MACRO_ASPECT_4 (70963) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '8', '\0', /* ADDR_SURF_MACRO_ASPECT_8 (70988) */
	'M', 'A', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'A', 'S', 'P', 'E', 'C', 'T', '\0', /* MACRO_TILE_ASPECT (71013) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '2', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_2_BANK (71031) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '4', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_4_BANK (71048) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '8', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_8_BANK (71065) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '1', '6', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_16_BANK (71082) */
	'N', 'U', 'M', '_', 'B', 'A', 'N', 'K', 'S', '\0', /* NUM_BANKS (71100) */
	'W', 'I', 'D', 'T', 'H', '_', 'L', 'O', '\0', /* WIDTH_LO (71110) */
	'W', 'I', 'D', 'T', 'H', '_', 'H', 'I', '\0', /* WIDTH_HI (71119) */
	'B', 'A', 'S', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* BASE_LEVEL (71128) */
	'L', 'A', 'S', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* LAST_LEVEL (71139) */
	'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* SW_MODE (71150) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'Y', 'Z', 'W', '\0', /* BC_SWIZZLE_XYZW (71158) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'W', 'Y', 'Z', '\0', /* BC_SWIZZLE_XWYZ (71174) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'Z', 'Y', 'X', '\0', /* BC_SWIZZLE_WZYX (71190) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'X', 'Y', 'Z', '\0', /* BC_SWIZZLE_WXYZ (71206) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Z', 'Y', 'X', 'W', '\0', /* BC_SWIZZLE_ZYXW (71222) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Y', 'X', 'W', 'Z', '\0', /* BC_SWIZZLE_YXWZ (71238) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* BC_SWIZZLE (71254) */
	'B', 'A', 'S', 'E', '_', 'A', 'R', 'R', 'A', 'Y', '\0', /* BASE_ARRAY (71265) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* ARRAY_PITCH (71276) */
	'M', 'A', 'X', '_', 'M', 'I', 'P', '\0', /* MAX_MIP (71288) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '_', 'W', 'A', 'R', 'N', '\0', /* MIN_LOD_WARN (71296) */
	'P', 'E', 'R', 'F', '_', 'M', 'O', 'D', '\0', /* PERF_MOD (71309) */
	'C', 'O', 'R', 'N', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* CORNER_SAMPLES (71318) */
	'L', 'O', 'D', '_', 'H', 'D', 'W', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* LOD_HDW_CNT_EN (71333) */
	'P', 'R', 'T', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '\0', /* PRT_DEFAULT (71348) */
	'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'A', 'N', 'K', '_', 'I', 'D', '\0', /* COUNTER_BANK_ID (71360) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', '2', '5', '6', '\0', /* ITERATE_256 (71376) */
	'M', 'A', 'X', '_', 'U', 'N', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_UNCOMPRESSED_BLOCK_SIZE (71388) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_COMPRESSED_BLOCK_SIZE (71416) */
	'M', 'E', 'T', 'A', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* META_PIPE_ALIGNED (71442, 71447) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WRITE_COMPRESS_ENABLE (71460) */
	'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'E', 'N', '\0', /* COMPRESSION_EN (71482) */
	'A', 'L', 'P', 'H', 'A', '_', 'I', 'S', '_', 'O', 'N', '_', 'M', 'S', 'B', '\0', /* ALPHA_IS_ON_MSB (71497) */
	'C', 'O', 'L', 'O', 'R', '_', 'T', 'R', 'A', 'N', 'S', 'F', 'O', 'R', 'M', '\0', /* COLOR_TRANSFORM (71513) */
	'M', 'E', 'T', 'A', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', '\0', /* META_DATA_ADDRESS_LO (71529) */
	'C', 'U', '_', 'E', 'N', '\0', /* CU_EN (71550) */
	'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* WAVE_LIMIT (71556, 71561) */
	'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_LOW_THRESHOLD (71567) */
	'M', 'E', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* MEM_BASE (71586) */
	'V', 'G', 'P', 'R', 'S', '\0', /* VGPRS (71595) */
	'S', 'G', 'P', 'R', 'S', '\0', /* SGPRS (71601) */
	'F', 'P', '_', '3', '2', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_32_ROUND_TOWARDS_ZERO (71607) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_16_64_ROUND_TOWARDS_ZERO (71632) */
	'F', 'P', '_', '3', '2', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_32_DENORMS (71660) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_16_64_DENORMS (71674) */
	'F', 'L', 'O', 'A', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* FLOAT_MODE (71691) */
	'I', 'E', 'E', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* IEEE_MODE (71702) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_DISABLE (71712) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '\0', /* MEM_ORDERED (71729) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'E', 'N', '\0', /* SCRATCH_EN (71741) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '\0', /* USER_SGPR (71752) */
	'T', 'R', 'A', 'P', '_', 'P', 'R', 'E', 'S', 'E', 'N', 'T', '\0', /* TRAP_PRESENT (71762) */
	'W', 'A', 'V', 'E', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* WAVE_CNT_EN (71775) */
	'E', 'X', 'T', 'R', 'A', '_', 'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* EXTRA_LDS_SIZE (71787) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '_', 'W', 'A', 'V', 'E', 'I', 'D', '\0', /* LOAD_COLLISION_WAVEID (71802) */
	'L', 'O', 'A', 'D', '_', 'I', 'N', 'T', 'R', 'A', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '\0', /* LOAD_INTRAWAVE_COLLISION (71824) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '_', 'M', 'S', 'B', '\0', /* USER_SGPR_MSB (71849) */
	'S', 'H', 'A', 'R', 'E', 'D', '_', 'V', 'G', 'P', 'R', '_', 'C', 'N', 'T', '\0', /* SHARED_VGPR_CNT (71863) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* SOFT_GROUPING_EN (71879) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'O', 'F', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'S', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* NUMBER_OF_REQUESTS_PER_CU (71896) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* SOFT_GROUPING_ALLOCATION_TIMEOUT (71922) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'H', 'Y', 'S', 'T', 'E', 'R', 'E', 'S', 'I', 'S', '\0', /* HARD_LOCK_HYSTERESIS (71955) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* HARD_LOCK_LOW_THRESHOLD (71976) */
	'P', 'R', 'O', 'D', 'U', 'C', 'E', 'R', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '_', 'L', 'O', 'C', 'K', 'O', 'U', 'T', '\0', /* PRODUCER_REQUEST_LOCKOUT (72000) */
	'G', 'L', 'O', 'B', 'A', 'L', '_', 'S', 'C', 'A', 'N', 'N', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* GLOBAL_SCANNING_EN (72025) */
	'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'R', 'A', 'T', 'E', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'I', 'N', 'G', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ALLOCATION_RATE_THROTTLING_THRESHOLD (72044) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TOTAL_WAVE_COUNT_HIER_SELECT (72081) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PER_TYPE_WAVE_COUNT_HIER_SELECT (72110) */
	'G', 'R', 'O', 'U', 'P', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'E', 'N', '\0', /* GROUP_UPDATE_EN (72142) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* TOTAL_WAVE_COUNT_COEFFICIENT (72158) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* PER_TYPE_WAVE_COUNT_COEFFICIENT (72187) */
	'C', 'O', 'N', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* CONTRIBUTION (72219) */
	'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* VGPR_COMP_CNT (72232) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_ENABLE (72246) */
	'O', 'C', '_', 'L', 'D', 'S', '_', 'E', 'N', '\0', /* OC_LDS_EN (72262) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '0', '_', 'E', 'N', '\0', /* SO_BASE0_EN (72272) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '1', '_', 'E', 'N', '\0', /* SO_BASE1_EN (72284) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '2', '_', 'E', 'N', '\0', /* SO_BASE2_EN (72296) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '3', '_', 'E', 'N', '\0', /* SO_BASE3_EN (72308) */
	'S', 'O', '_', 'E', 'N', '\0', /* SO_EN (72320) */
	'P', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', '\0', /* PC_BASE_EN (72326) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'E', 'N', '\0', /* DISPATCH_DRAW_EN (72337) */
	'S', 'K', 'I', 'P', '_', 'U', 'S', 'G', 'P', 'R', '0', '\0', /* SKIP_USGPR0 (72354) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'G', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_GS (72366) */
	'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* GROUP_FIFO_DEPTH (72391) */
	'W', 'G', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* WGP_MODE (72408) */
	'G', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* GS_VGPR_COMP_CNT (72417) */
	'E', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* ES_VGPR_COMP_CNT (72434) */
	'L', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* LS_VGPR_COMP_CNT (72451) */
	'T', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'E', 'N', '\0', /* TG_SIZE_EN (72468) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', '\0', /* COMPUTE_SHADER_EN (72479) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'G', '_', 'E', 'N', '\0', /* PARTIAL_TG_EN (72497) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'A', 'T', '_', '0', '0', '0', '\0', /* FORCE_START_AT_000 (72511) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'E', 'N', 'B', 'L', '\0', /* ORDERED_APPEND_ENBL (72530) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_APPEND_MODE (72550) */
	'U', 'S', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'D', 'I', 'M', 'E', 'N', 'S', 'I', 'O', 'N', 'S', '\0', /* USE_THREAD_DIMENSIONS (72570) */
	'O', 'R', 'D', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* ORDER_MODE (72592) */
	'S', 'C', 'A', 'L', 'A', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* SCALAR_L1_INV_VOL (72603, 72617) */
	'V', 'E', 'C', 'T', 'O', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* VECTOR_L1_INV_VOL (72621) */
	'T', 'U', 'N', 'N', 'E', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TUNNEL_ENABLE (72639) */
	'R', 'E', 'S', 'T', 'O', 'R', 'E', '\0', /* RESTORE (72653) */
	'C', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* CS_W32_EN (72661) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'F', 'U', 'L', 'L', '\0', /* NUM_THREAD_FULL (72671, 72682) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '\0', /* NUM_THREAD_PARTIAL (72687) */
	'B', 'U', 'L', 'K', 'Y', '\0', /* BULKY (72706) */
	'T', 'G', 'I', 'D', '_', 'X', '_', 'E', 'N', '\0', /* TGID_X_EN (72712) */
	'T', 'G', 'I', 'D', '_', 'Y', '_', 'E', 'N', '\0', /* TGID_Y_EN (72722) */
	'T', 'G', 'I', 'D', '_', 'Z', '_', 'E', 'N', '\0', /* TGID_Z_EN (72732) */
	'T', 'I', 'D', 'I', 'G', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* TIDIG_COMP_CNT (72742) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '_', 'M', 'S', 'B', '\0', /* EXCP_EN_MSB (72757) */
	'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'H', '\0', /* WAVES_PER_SH (72769) */
	'T', 'G', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* TG_PER_CU (72782) */
	'L', 'O', 'C', 'K', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_THRESHOLD (72792) */
	'S', 'I', 'M', 'D', '_', 'D', 'E', 'S', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SIMD_DEST_CNTL (72807) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'D', 'I', 'S', 'T', '\0', /* FORCE_SIMD_DIST (72822) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CU_GROUP_COUNT (72838) */
	'W', 'A', 'V', 'E', 'S', '\0', /* WAVES (72853) */
	'W', 'A', 'V', 'E', 'S', 'I', 'Z', 'E', '\0', /* WAVESIZE (72859) */
	'S', 'E', 'N', 'D', '_', 'S', 'E', 'I', 'D', '\0', /* SEND_SEID (72868) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '3', '\0', /* RESERVED3 (72878) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '4', '\0', /* RESERVED4 (72888) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* WAVE_ID_BASE (72898) */
	'D', 'E', 'D', 'I', 'C', 'A', 'T', 'E', 'D', '_', 'P', 'R', 'E', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* DEDICATED_PREALLOCATION_BUFFER_LIMIT (72911) */
	'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* PAYLOAD (72948, 72951) */
	'I', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* IS_EVENT (72956) */
	'I', 'S', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* IS_STATE (72965) */
	'O', 'F', 'F', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* OFF_DELAY (72974) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_CLEAR_ENABLE (72984) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_CLEAR_ENABLE (73003) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'P', 'Y', '\0', /* DEPTH_COPY (73024) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'P', 'Y', '\0', /* STENCIL_COPY (73035) */
	'R', 'E', 'S', 'U', 'M', 'M', 'A', 'R', 'I', 'Z', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* RESUMMARIZE_ENABLE (73048) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* STENCIL_COMPRESS_DISABLE (73067) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_COMPRESS_DISABLE (73092) */
	'C', 'O', 'P', 'Y', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '\0', /* COPY_CENTROID (73115) */
	'C', 'O', 'P', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* COPY_SAMPLE (73129) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DECOMPRESS_ENABLE (73141) */
	'Z', 'P', 'A', 'S', 'S', '_', 'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZPASS_INCREMENT_DISABLE (73159) */
	'P', 'E', 'R', 'F', 'E', 'C', 'T', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* PERFECT_ZPASS_COUNTS (73183) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* DISABLE_CONSERVATIVE_ZPASS_COUNTS (73204) */
	'E', 'N', 'H', 'A', 'N', 'C', 'E', 'D', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* ENHANCED_CONSERVATIVE_ZPASS_COUNTS (73238) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* SAMPLE_RATE (73273) */
	'Z', 'P', 'A', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZPASS_ENABLE (73285) */
	'Z', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZFAIL_ENABLE (73298) */
	'S', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SFAIL_ENABLE (73311) */
	'D', 'B', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DBFAIL_ENABLE (73324) */
	'S', 'L', 'I', 'C', 'E', '_', 'E', 'V', 'E', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_EVEN_ENABLE (73338) */
	'S', 'L', 'I', 'C', 'E', '_', 'O', 'D', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_ODD_ENABLE (73356) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* SLICE_START (73373, 73379) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'H', 'I', '\0', /* SLICE_START_HI (73385) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '\0', /* SLICE_MAX (73400) */
	'Z', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* Z_READ_ONLY (73410) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* STENCIL_READ_ONLY (73422) */
	'M', 'I', 'P', 'I', 'D', '\0', /* MIPID (73440) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '_', 'H', 'I', '\0', /* SLICE_MAX_HI (73446) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'F', 'F', '\0', /* FORCE_OFF (73459) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_ENABLE (73469) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_DISABLE (73482) */
	'F', 'O', 'R', 'C', 'E', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* FORCE_RESERVED (73496) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_HIZ_ENABLE (73511, 73519) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '0', '\0', /* FORCE_HIS_ENABLE0 (73528, 73538) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '1', '\0', /* FORCE_HIS_ENABLE1 (73546, 73556) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* FORCE_SHADER_Z_ORDER (73564, 73577) */
	'F', 'A', 'S', 'T', '_', 'Z', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_Z_DISABLE (73585) */
	'F', 'A', 'S', 'T', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_STENCIL_DISABLE (73600) */
	'N', 'O', 'O', 'P', '_', 'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* NOOP_CULL_DISABLE (73621) */
	'F', 'O', 'R', 'C', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* FORCE_COLOR_KILL (73639, 73651) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_Z_READ (73656) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_STENCIL_READ (73669) */
	'F', 'O', 'R', 'C', 'E', '_', 'F', 'U', 'L', 'L', '_', 'Z', '_', 'R', 'A', 'N', 'G', 'E', '\0', /* FORCE_FULL_Z_RANGE (73688) */
	'F', 'O', 'R', 'C', 'E', '_', 'Q', 'C', '_', 'S', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'N', 'F', 'L', 'I', 'C', 'T', '\0', /* FORCE_QC_SMASK_CONFLICT (73707) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DISABLE_VIEWPORT_CLAMP (73731) */
	'I', 'G', 'N', 'O', 'R', 'E', '_', 'S', 'C', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* IGNORE_SC_ZRANGE (73754) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'U', 'L', 'L', 'Y', '_', 'C', 'O', 'V', 'E', 'R', 'E', 'D', '\0', /* DISABLE_FULLY_COVERED (73771) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'O', 'F', 'F', '\0', /* FORCE_SUMM_OFF (73793) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'I', 'N', 'Z', '\0', /* FORCE_SUMM_MINZ (73808) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'A', 'X', 'Z', '\0', /* FORCE_SUMM_MAXZ (73824) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'B', 'O', 'T', 'H', '\0', /* FORCE_SUMM_BOTH (73840) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'L', 'I', 'M', 'I', 'T', '_', 'S', 'U', 'M', 'M', '\0', /* FORCE_Z_LIMIT_SUMM (73856) */
	'M', 'A', 'X', '_', 'T', 'I', 'L', 'E', 'S', '_', 'I', 'N', '_', 'D', 'T', 'T', '\0', /* MAX_TILES_IN_DTT (73875) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'I', 'L', 'E', '_', 'R', 'A', 'T', 'E', '_', 'T', 'I', 'L', 'E', 'S', '\0', /* DISABLE_TILE_RATE_TILES (73892) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_Z_DIRTY (73916, 73924) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_STENCIL_DIRTY (73930) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_Z_VALID (73950) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_STENCIL_VALID (73964) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '\0', /* PRESERVE_COMPRESSION (73984, 73993) */
	'P', 'S', 'L', 'C', '_', 'A', 'U', 'T', 'O', '\0', /* PSLC_AUTO (74005) */
	'P', 'S', 'L', 'C', '_', 'O', 'N', '_', 'H', 'A', 'N', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* PSLC_ON_HANG_ONLY (74015) */
	'P', 'S', 'L', 'C', '_', 'A', 'S', 'A', 'P', '\0', /* PSLC_ASAP (74033) */
	'P', 'S', 'L', 'C', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PSLC_COUNTDOWN (74043) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PARTIAL_SQUAD_LAUNCH_CONTROL (74058) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PARTIAL_SQUAD_LAUNCH_COUNTDOWN (74087) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'Z', 'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION (74118) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'M', 'E', 'M', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_SMEM_EXPCLEAR_OPTIMIZATION (74154) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'N', '_', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_COLOR_ON_VALIDATION (74189) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'Z', '_', 'O', 'N', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* DECOMPRESS_Z_ON_FLUSH (74217) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'G', '_', 'S', 'N', 'O', 'O', 'P', '\0', /* DISABLE_REG_SNOOP (74239) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'H', 'I', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_HIER_DEPTH_DISABLE (74257) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'H', 'I', 'Z', 'S', '_', 'F', 'U', 'N', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SEPARATE_HIZS_FUNC_ENABLE (74289) */
	'F', 'R', 'A', 'G', '_', 'N', 'E', 'V', 'E', 'R', '\0', /* FRAG_NEVER (74315) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'S', 'S', '\0', /* FRAG_LESS (74326) */
	'F', 'R', 'A', 'G', '_', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_EQUAL (74336) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_LEQUAL (74347) */
	'F', 'R', 'A', 'G', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '\0', /* FRAG_GREATER (74359) */
	'F', 'R', 'A', 'G', '_', 'N', 'O', 'T', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_NOTEQUAL (74372) */
	'F', 'R', 'A', 'G', '_', 'G', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_GEQUAL (74386) */
	'F', 'R', 'A', 'G', '_', 'A', 'L', 'W', 'A', 'Y', 'S', '\0', /* FRAG_ALWAYS (74398, 74403) */
	'H', 'I', 'Z', '_', 'Z', 'F', 'U', 'N', 'C', '\0', /* HIZ_ZFUNC (74410, 74414) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'F', 'F', '\0', /* HIS_SFUNC_FF (74420) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* HIS_SFUNC_BF (74433) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* PRESERVE_ZRANGE (74446) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '\0', /* PRESERVE_SRESULTS (74462) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'A', 'S', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_FAST_PASS (74480) */
	'A', 'L', 'L', 'O', 'W', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'R', 'E', 'S', '_', 'H', 'I', 'E', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* ALLOW_PARTIAL_RES_HIER_KILL (74498) */
	'X', '_', 'M', 'A', 'X', '\0', /* X_MAX (74526) */
	'T', 'L', '_', 'X', '\0', /* TL_X (74532) */
	'T', 'L', '_', 'Y', '\0', /* TL_Y (74537) */
	'B', 'R', '_', 'X', '\0', /* BR_X (74542) */
	'B', 'R', '_', 'Y', '\0', /* BR_Y (74547) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'N', '\0', /* FORCE_ON (74552) */
	'P', 'U', 'N', 'C', 'H', 'O', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* PUNCHOUT_MODE (74561) */
	'P', 'O', 'P', 'S', '_', 'D', 'R', 'A', 'I', 'N', '_', 'P', 'S', '_', 'O', 'N', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '\0', /* POPS_DRAIN_PS_ON_OVERLAP (74575) */
	'D', 'I', 'S', 'A', 'L', 'L', 'O', 'W', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* DISALLOW_OVERFLOW (74600) */
	'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* FIELD_1 (74618) */
	'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* FIELD_2 (74626) */
	'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* FIELD_3 (74634) */
	'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* FIELD_4 (74642) */
	'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* FIELD_5 (74650) */
	'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* FIELD_6 (74658) */
	'F', 'I', 'E', 'L', 'D', '_', '7', '\0', /* FIELD_7 (74666) */
	'Z', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* Z_INVALID (74674) */
	'Z', '_', '1', '6', '\0', /* Z_16 (74684) */
	'Z', '_', '2', '4', '\0', /* Z_24 (74689) */
	'Z', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* Z_32_FLOAT (74694) */
	'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* NUM_SAMPLES (74705) */
	'F', 'A', 'U', 'L', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* FAULT_ZERO (74717) */
	'F', 'A', 'U', 'L', 'T', '_', 'O', 'N', 'E', '\0', /* FAULT_ONE (74728) */
	'F', 'A', 'U', 'L', 'T', '_', 'F', 'A', 'I', 'L', '\0', /* FAULT_FAIL (74738) */
	'F', 'A', 'U', 'L', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* FAULT_PASS (74749) */
	'F', 'A', 'U', 'L', 'T', '_', 'B', 'E', 'H', 'A', 'V', 'I', 'O', 'R', '\0', /* FAULT_BEHAVIOR (74760) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* ITERATE_FLUSH (74775) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', 'L', 'Y', '_', 'R', 'E', 'S', 'I', 'D', 'E', 'N', 'T', '\0', /* PARTIALLY_RESIDENT (74789) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* RESERVED_FIELD_1 (74808) */
	'M', 'A', 'X', 'M', 'I', 'P', '\0', /* MAXMIP (74825) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'O', 'N', '_', 'N', '_', 'Z', 'P', 'L', 'A', 'N', 'E', 'S', '\0', /* DECOMPRESS_ON_N_ZPLANES (74832) */
	'A', 'L', 'L', 'O', 'W', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '\0', /* ALLOW_EXPCLEAR (74856) */
	'R', 'E', 'A', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* READ_SIZE (74871) */
	'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TILE_SURFACE_ENABLE (74881) */
	'Z', 'R', 'A', 'N', 'G', 'E', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* ZRANGE_PRECISION (74901) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* STENCIL_INVALID (74918) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', '8', '\0', /* STENCIL_8 (74934) */
	'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_STENCIL_DISABLE (74944) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'W', 'R', '\0', /* CACHE_LRU_WR (74965) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* CACHE_STREAM (74978) */
	'C', 'A', 'C', 'H', 'E', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* CACHE_BYPASS (74991) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'W', 'R', '\0', /* UNCACHED_WR (75004) */
	'Z', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_WR_POLICY (75016) */
	'S', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_WR_POLICY (75028) */
	'H', 'T', 'I', 'L', 'E', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_WR_POLICY (75040) */
	'Z', 'P', 'C', 'P', 'S', 'D', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* ZPCPSD_WR_POLICY (75056) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'R', 'D', '\0', /* CACHE_LRU_RD (75073) */
	'C', 'A', 'C', 'H', 'E', '_', 'N', 'O', 'A', '\0', /* CACHE_NOA (75086) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'R', 'D', '\0', /* UNCACHED_RD (75096) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'D', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RESERVED_RDPOLICY (75108) */
	'Z', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_RD_POLICY (75126) */
	'S', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_RD_POLICY (75138) */
	'H', 'T', 'I', 'L', 'E', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_RD_POLICY (75150) */
	'Z', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* Z_BIG_PAGE (75166, 75168) */
	'S', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* S_BIG_PAGE (75177) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* DEST_BASE_HI_256B (75188) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_X_OFFSET (75206) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_Y_OFFSET (75222, 75229) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* WINDOW_OFFSET_DISABLE (75238) */
	'I', 'N', '_', '2', '0', '\0', /* IN_20 (75260) */
	'I', 'N', '_', '2', '1', '\0', /* IN_21 (75266) */
	'I', 'N', '_', '2', '1', '0', '\0', /* IN_210 (75272) */
	'I', 'N', '_', '3', '0', '\0', /* IN_30 (75279) */
	'I', 'N', '_', '3', '1', '\0', /* IN_31 (75285) */
	'I', 'N', '_', '3', '1', '0', '\0', /* IN_310 (75291) */
	'I', 'N', '_', '3', '2', '\0', /* IN_32 (75298) */
	'I', 'N', '_', '3', '2', '0', '\0', /* IN_320 (75304) */
	'I', 'N', '_', '3', '2', '1', '\0', /* IN_321 (75311) */
	'I', 'N', '_', '3', '2', '1', '0', '\0', /* IN_3210 (75318) */
	'C', 'L', 'I', 'P', '_', 'R', 'U', 'L', 'E', '\0', /* CLIP_RULE (75326) */
	'E', 'R', '_', 'T', 'R', 'I', '\0', /* ER_TRI (75336) */
	'E', 'R', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* ER_POINT (75343) */
	'E', 'R', '_', 'R', 'E', 'C', 'T', '\0', /* ER_RECT (75352) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'L', 'R', '\0', /* ER_LINE_LR (75360) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'R', 'L', '\0', /* ER_LINE_RL (75371) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'T', 'B', '\0', /* ER_LINE_TB (75382) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'B', 'T', '\0', /* ER_LINE_BT (75393) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'X', '\0', /* HW_SCREEN_OFFSET_X (75404) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'Y', '\0', /* HW_SCREEN_OFFSET_Y (75423) */
	'T', 'A', 'R', 'G', 'E', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET0_ENABLE (75442) */
	'T', 'A', 'R', 'G', 'E', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET1_ENABLE (75457) */
	'T', 'A', 'R', 'G', 'E', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET2_ENABLE (75472) */
	'T', 'A', 'R', 'G', 'E', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET3_ENABLE (75487) */
	'T', 'A', 'R', 'G', 'E', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET4_ENABLE (75502) */
	'T', 'A', 'R', 'G', 'E', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET5_ENABLE (75517) */
	'T', 'A', 'R', 'G', 'E', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET6_ENABLE (75532) */
	'T', 'A', 'R', 'G', 'E', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET7_ENABLE (75547) */
	'O', 'U', 'T', 'P', 'U', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT0_ENABLE (75562) */
	'O', 'U', 'T', 'P', 'U', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT1_ENABLE (75577) */
	'O', 'U', 'T', 'P', 'U', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT2_ENABLE (75592) */
	'O', 'U', 'T', 'P', 'U', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT3_ENABLE (75607) */
	'O', 'U', 'T', 'P', 'U', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT4_ENABLE (75622) */
	'O', 'U', 'T', 'P', 'U', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT5_ENABLE (75637) */
	'O', 'U', 'T', 'P', 'U', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT6_ENABLE (75652) */
	'O', 'U', 'T', 'P', 'U', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT7_ENABLE (75667) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_RB_MAP_0 (75682) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_RB_MAP_1 (75705) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_RB_MAP_2 (75728) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_RB_MAP_3 (75751) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '0', '\0', /* RB_MAP_PKR0 (75774) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '1', '\0', /* RB_MAP_PKR1 (75786) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL2_0 (75798) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL2_1 (75823) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_RB_XSEL2_2 (75848) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_RB_XSEL2_3 (75873) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '\0', /* RB_XSEL2 (75898) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL_0 (75907) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL_1 (75931) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '\0', /* RB_XSEL (75955) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_YSEL_0 (75963) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_YSEL_1 (75987) */
	'R', 'B', '_', 'Y', 'S', 'E', 'L', '\0', /* RB_YSEL (76011) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_PKR_MAP_0 (76019) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_PKR_MAP_1 (76043) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_PKR_MAP_2 (76067) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_PKR_MAP_3 (76091) */
	'P', 'K', 'R', '_', 'M', 'A', 'P', '\0', /* PKR_MAP (76115) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL_0 (76123) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL_1 (76148) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL_2 (76173) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL_3 (76198) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* PKR_XSEL (76223) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_YSEL_0 (76232) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_YSEL_1 (76257) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_YSEL_2 (76282) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_YSEL_3 (76307) */
	'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* PKR_YSEL (76332) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL2_0 (76341) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL2_1 (76367) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL2_2 (76393) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL2_3 (76419) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '\0', /* PKR_XSEL2 (76445) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SC_MAP_0 (76455) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SC_MAP_1 (76478) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SC_MAP_2 (76501) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SC_MAP_3 (76524) */
	'S', 'C', '_', 'M', 'A', 'P', '\0', /* SC_MAP (76547) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_8_WIDE_TILE (76554) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_16_WIDE_TILE (76588) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_32_WIDE_TILE (76623) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_64_WIDE_TILE (76658) */
	'S', 'C', '_', 'X', 'S', 'E', 'L', '\0', /* SC_XSEL (76693) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_8_WIDE_TILE (76701) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_16_WIDE_TILE (76735) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_32_WIDE_TILE (76770) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_64_WIDE_TILE (76805) */
	'S', 'C', '_', 'Y', 'S', 'E', 'L', '\0', /* SC_YSEL (76840) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_MAP_0 (76848) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_MAP_1 (76871) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_MAP_2 (76894) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_MAP_3 (76917) */
	'S', 'E', '_', 'M', 'A', 'P', '\0', /* SE_MAP (76940) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_8_WIDE_TILE (76947) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_16_WIDE_TILE (76981) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_32_WIDE_TILE (77016) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_64_WIDE_TILE (77051) */
	'S', 'E', '_', 'X', 'S', 'E', 'L', '\0', /* SE_XSEL (77086) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_8_WIDE_TILE (77094) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_16_WIDE_TILE (77128) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_32_WIDE_TILE (77163) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_64_WIDE_TILE (77198) */
	'S', 'E', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_YSEL (77233) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_0 (77241) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_1 (77269) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_2 (77297) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_3 (77325) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '\0', /* SE_PAIR_MAP (77353) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE (77365) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE (77404) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE (77444) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE (77484) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* SE_PAIR_XSEL (77524) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE (77537) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', '